/***************************************************************************
                          khttrack.cpp  -  description
                             -------------------
    begin                : lun jun 10 19:13:24 CEST 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly@ifrance.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>

// system include Unix
#include <stdio.h>  // printf
#include <unistd.h> // system
#include <stdlib.h> // exit
#include <sys/types.h>  // waitpid
#include <sys/wait.h>   // waitpid
#include <errno.h>      // errno
#include <pthread.h> // pthreadv

// application specific includes
#include "khttrack.h"
#include "khttrackview.h"
#include "khttrackdoc.h"
#include "khttrackmainwizard.h"

#define ID_STATUS_MSG 1

extern KhttrackMirror *kMirrorViewGlobal;


KhttrackApp::KhttrackApp(QWidget* , const char* name):KMainWindow(0, name)
{
  config=kapp->config();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
  initDocument();
  initView();
	
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  //fileNew->setEnabled(false);
  fileOpen->setEnabled(false);
  fileOpenRecent->setEnabled(false);
  fileSave->setEnabled(false);
  fileSaveAs->setEnabled(false);
  filePrint->setEnabled(false);
  editCut->setEnabled(false);
  editCopy->setEnabled(false);
  editPaste->setEnabled(false);

  ///////////////////////////////////////////////////////////////////

}

KhttrackApp::~KhttrackApp()
{

}

void KhttrackApp::initActions()
{
  fileBrowse = new KAction(i18n("&Browse"), 0, 0, this, SLOT(slotFileBrowse()), actionCollection(),"file_browse");
  htmlHelp = new KAction(i18n("&Html help"), 0, 0, this, SLOT(slotFileBrowse()), actionCollection(),"html_help");


  fileNewWindow = new KAction(i18n("&File new window"), 0, 0, this, SLOT(slotFileNewWindow()), actionCollection(),"file_new_window");
  fileNew = KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection());
  fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());
  fileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
  fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
  fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), actionCollection());
  fileClose = KStdAction::close(this, SLOT(slotFileClose()), actionCollection());
  filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());

  editCut = KStdAction::cut(this, SLOT(slotEditCut()), actionCollection());
  editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());

  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());

  prefLoadDef = new KAction(i18n("Load default options"), 0, 0, this, SLOT(slotPrefLoadDef()), actionCollection(),"pref_load_def");
  prefSaveDef = new KAction(i18n("Save default options"), 0, 0, this, SLOT(slotPrefSaveDef()), actionCollection(),"pref_save_def");
  prefResetDef = new KAction(i18n("Reset to default options"), 0, 0, this, SLOT(slotPrefResetDef()), actionCollection(),"pref_reset_def");
  prefLoad = new KAction(i18n("Load options..."), 0, 0, this, SLOT(slotPrefLoad()), actionCollection(),"pref_load");
  prefSave = new KAction(i18n("Save options..."), 0, 0, this, SLOT(slotPrefSave()), actionCollection(),"pref_save");
  prefLang = new KAction(i18n("Language preference..."), 0, 0, this, SLOT(slotPrefLang()), actionCollection(),"pref_lang");
  showLog = new KAction(i18n("Log"), 0, 0, this, SLOT(slotShowLog()), actionCollection(),"log");


  /******/

  fileBrowse->setStatusText(i18n("Browse Website"));
  htmlHelp->setStatusText(i18n("HTML help"));
  fileNewWindow->setStatusText(i18n("Opens a new application window"));
  fileNew->setStatusText(i18n("Creates a new document"));
  fileOpen->setStatusText(i18n("Opens an existing document"));
  fileOpenRecent->setStatusText(i18n("Opens a recently used file"));
  fileSave->setStatusText(i18n("Saves the actual document"));
  fileSaveAs->setStatusText(i18n("Saves the actual document as..."));
  fileClose->setStatusText(i18n("Closes the actual document"));
  filePrint ->setStatusText(i18n("Prints out the actual document"));
  fileQuit->setStatusText(i18n("Quits the application"));
  editCut->setStatusText(i18n("Cuts the selected section and puts it to the clipboard"));
  editCopy->setStatusText(i18n("Copies the selected section to the clipboard"));
  editPaste->setStatusText(i18n("Pastes the clipboard contents to actual position"));
  viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  prefLoadDef->setStatusText(i18n("Load default user preferences"));
  prefSaveDef->setStatusText(i18n("Save user preferences"));
  prefResetDef->setStatusText(i18n("Reset to default options"));
  prefLoad->setStatusText(i18n("Load options as..."));
  prefSave->setStatusText(i18n("Save options as..."));
  prefLang->setStatusText(i18n("Set the language..."));



  // use the absolute path to your khttrackui.rc file for testing purpose in createGUI();
  createGUI();

}


void KhttrackApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KhttrackApp::initDocument()
{
  doc = new KhttrackDoc(this);
  doc->newDocument();
}

void KhttrackApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KhttrackView(this);
  doc->addView(view);
  setCaption(doc->URL().fileName(),false);

  project = new KhttrackStruct;

  /** wizard */
  wizard = new KhttrackMainWizard(this);
  // initialisation du pointeur sur project
  wizard->project = project;
  // initialisation des membres du wizard, gui...
  wizard->initWizard();
  wizard->show() ;

  /** indicateur de progression */
  vbox        = new QVBox ( this );
  kMirrorView = new KhttrackMirror(vbox) ;
  kMirrorView->project = project;
  kMirrorView->highPriority();
  kMirrorView->hide() ;
  kMirrorViewGlobal = kMirrorView ;

  /** initialisation */
  setCentralWidget(vbox);
  setFixedSize(640,610);



/*
  QVBox * vbox = new QVBox ( this );

  location = new QLineEdit ( vbox );
  location->setText( "http://localhost" );

  browser = new KHTMLPart( this );
  browser->openURL( location->text() );

  connect( location , SIGNAL( returnPressed() ),
      this, SLOT( changeLocation() ) );

  connect( browser->browserExtension(),
      SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
      this, SLOT( openURLRequest(const KURL &, const KParts::URLArgs & ) ) );
*/


}

void KhttrackApp::rebuildView()
{

  QMessageBox::information( this, "Khttrack",
                                  i18n("Start of a new download.\n"),
                                  i18n("Ok") );


  /*** delete */
  delete kMirrorView;
  delete wizard;
  delete project;

  /*** create */
  project = new KhttrackStruct;

  /** wizard */
  wizard = new KhttrackMainWizard(this);
  // initialisation du pointeur sur project
  wizard->project = project;
  // initialisation des membres du wizard, gui...
  wizard->initWizard();
  wizard->show() ;

  kMirrorView = new KhttrackMirror(vbox) ;
  kMirrorView->project = project;
  kMirrorView->highPriority();
  kMirrorView->hide() ;
  kMirrorViewGlobal = kMirrorView ;

}

void KhttrackApp::openDocumentFile(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));

  doc->openDocument( url);
  fileOpenRecent->addURL( url );
  slotStatusMsg(i18n("Ready."));
}


KhttrackDoc *KhttrackApp::getDocument() const
{
  return doc;
}

void KhttrackApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
  fileOpenRecent->saveEntries(config,"Recent Files");
}


void KhttrackApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();


  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);
	
  // initialize the recent file list
  fileOpenRecent->loadEntries(config,"Recent Files");

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
}

void KhttrackApp::saveProperties(KConfig *_cfg)
{
  if(doc->URL().fileName()!=i18n("Untitled") && !doc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    KURL url=doc->URL();	
    _cfg->writeEntry("filename", url.url());
    _cfg->writeEntry("modified", doc->isModified());
    QString tempname = kapp->tempSaveName(url.url());
    QString tempurl= KURL::encode_string(tempname);
    KURL _url(tempurl);
    doc->saveDocument(_url);
  }
}


void KhttrackApp::readProperties(KConfig* _cfg)
{
  QString filename = _cfg->readEntry("filename", "");
  KURL url(filename);
  bool modified = _cfg->readBoolEntry("modified", false);
  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
    KURL _url(tempname);
  	
    if(canRecover)
    {
      doc->openDocument(_url);
      doc->setModified();
      setCaption(_url.fileName(),true);
      QFile::remove(tempname);
    }
  }
  else
  {
    if(!filename.isEmpty())
    {
      doc->openDocument(url);
      setCaption(url.fileName(),false);
    }
  }
}		

bool KhttrackApp::queryClose()
{
  return doc->saveModified();
}

bool KhttrackApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KhttrackApp::slotPrefLoadDef()
{
  slotStatusMsg(i18n("Launching operation..."));
//	wizard->show();
  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotPrefSaveDef()
{
  slotStatusMsg(i18n("Launching operation..."));
  //this->addWidget( wizard, 1, 1 );
  wizard->show();
	
  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotPrefResetDef()
{
  slotStatusMsg(i18n("Launching operation..."));
	
  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotPrefLoad()
{
  slotStatusMsg(i18n("Launching operation..."));
	
  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotPrefSave()
{
  slotStatusMsg(i18n("Launching operation..."));
	
  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotPrefLang()
{
  slotStatusMsg(i18n("Launching operation..."));
	
  slotStatusMsg(i18n("Ready."));
}


void KhttrackApp::slotFileBrowse()
{
  slotStatusMsg(i18n("Browsing project..."));
	
  slotStatusMsg(i18n("Browsing Ready."));
}

void KhttrackApp::slotFileNewWindow()
{
//  slotStatusMsg(i18n("Opening a new application window..."));
	
//  KhttrackApp *new_window= new KhttrackApp();
//  new_window->show();

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));
  if ( kMirrorView->isVisible() )
  {
      QMessageBox::information( this, "Khttrack",
                                  i18n("Wait end of current download to start new download.\n"),
                                  i18n("Ok") );
      slotStatusMsg(i18n("Wait end of current download"));
  }
  else if ( wizard->isVisible())
  {
      QMessageBox::information( this, "Khttrack",
                                  i18n("Use the wizard to start new download.\n"),
                                  i18n("Ok") );
      slotStatusMsg(i18n("Use the wizard to start new download"));
  }
  else
  {
     rebuildView();
     wizard->show();
     slotStatusMsg(i18n("Use wizard"));
  }

/*
  if(!doc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    doc->newDocument();		
    setCaption(doc->URL().fileName(), false);
  }
*/

}

void KhttrackApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
	
  if(!doc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    KURL url=KFileDialog::getOpenURL(QString::null,
        i18n("*|All files"), this, i18n("Open File..."));
    if(!url.isEmpty())
    {
      doc->openDocument(url);
      setCaption(url.fileName(), false);
      fileOpenRecent->addURL( url );
    }
  }
  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFileOpenRecent(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));
	
  if(!doc->saveModified())
  {
     // here saving wasn't successful
  }
  else
  {
    doc->openDocument(url);
    setCaption(url.fileName(), false);
  }

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));
	
  doc->saveDocument(doc->URL());

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));

  KURL url=KFileDialog::getSaveURL(QDir::currentDirPath(),
        i18n("*|All files"), this, i18n("Save as..."));
  if(!url.isEmpty())
  {
    doc->saveDocument(url);
    fileOpenRecent->addURL(url);
    setCaption(url.fileName(),doc->isModified());
  }

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	
  close();

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();

  close();
  
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
/*  KMainWindow* w;



  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }	 */
}

void KhttrackApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		

  slotStatusMsg(i18n("Ready."));
}

void KhttrackApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}


void KhttrackApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

void KhttrackApp::slotShowLog()
{
    pthread_t threads3[1];
    int rc3 ;

    rc3 = pthread_create(&threads3[0], NULL, pth_showlogmain, (void *)0);
    if (rc3){
       printf("ERROR; return code from pthread_create() is %d\n", rc3);
       exit(-1);
    }
}

void *pth_showlogmain(void *threadid)
{
/*

*/

    char commande[1024] ;
    sprintf(commande, "kwrite %s/%s/hts-log.txt &\n",
                      kMirrorViewGlobal->project->s_project.gene_projectPath,
                      kMirrorViewGlobal->project->s_project.gene_projectName);
    printf(commande);
    system(commande);
    pthread_exit(NULL);
}



