<h1><a name="top" id="top">Sicherheit</a></h1>
<ul>
	<li><a href="#main_rule">Allgemeine Regel</a></li>
	<li><a href="#proc">proc-Filesystem</a></li>
	<li class="c1">
		<ul>
			<li><a href="#proc.icmp">Verwerfen von ICMP-Paketen</a></li>
			<li><a href="#proc.broadcast_pings">Ignorieren von &quot;broadcast pings&quot;</a></li>
			<li><a href="#proc.source_routed_packets">Deaktivierung von &quot;source routed packets&quot;</a></li>
			<li><a href="#proc.bad_error_messages">Schutz vor &quot;bad error messages&quot;</a></li>
			<li><a href="#proc.ip_forward">Deaktivieren von &quot;IP forwarding&quot;</a></li>
			<li><a href="#proc.logging">Logging</a></li>
			<li><a href="#proc.script">proc-Script</a></li>
		</ul>
	</li>
	<li><a href="#boot">Bootloader</a></li>
	<li class="c1">
		<ul>
			<li><a href="#boot.lilo">LILO</a></li>
			<li><a href="#boot.grub">GRUB</a></li>
		</ul>
	</li>
	<li><a href="#fstab">fstab</a></li>
	<li><a href="#syslogd">syslogd</a></li>
</ul>

<h2><a name="main_rule" id="main_rule">Allgemeine Regel</a></h2>
<p>Die allgemeine Regel, die beim Erstellen eines Kernels gilt, lautet:
<br />
	<span style="font-weight:bold;">
	&quot;Deaktivieren Sie alles, was Sie nicht brauchen!&quot;
	</span>
<br />
Dies produziert nicht nur einen wirklich kleinen Kernel, sondern erm&ouml;glicht Ihnen
auch noch Fehler von Kernel-Teilen, die Sie nicht ben&ouml;tigen, zu umgehen.
<br />
Dies beinhaltet auch das Deaktivieren des Module-Supports -
	<span style="font-style:italic;">
	[&nbsp;] Enable loadable module support</span>.
Root Kits per Module in den Kernel zur Laufzeit einzuschl&auml;usen, wird dadurch
Angreifern erschwert.
</p>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>


<h2><a name="proc" id="proc">/proc-Filesystem</a></h2>

<h3><a name="proc.icmp" id="proc.icmp">Verwerfen von ICMP-Paketen</a></h3>
<div class="example">
	# /bin/echo "1" > /proc/sys/net/ipv4/icmp_echo_ignore_all
</div>
<p>Dies veranlasst den Kernel alle pings bzw. alle ICMP-Pakete mit dem Typ 0 zu
verwerfen. In einem Netzwerk dient der ping-Befehl lediglich dazu Verbindungen
zu testen, niemand sonst (au&szlig;er root) ben&ouml;tigt ihn also wirklich.</p>

<h3><a name="proc.broadcast_pings" id="proc.broadcast_pings">Ignorieren von &quot;broadcast pings&quot;</a></h3>
<div class="example">
	# /bin/echo "1" > /proc/sys/net/ipv4/icmp_echo_ignore_broadcasts
</div>
<p>Dies deaktiviert die automatische Antwort auf &quot;ICMP broadcasts&quot;
und sch&uuml;tzt so vor Smurf-Attacken.</p>

<h3><a name="proc.source_routed_packets" id="proc.source_routed_packets">Deaktivierung von &quot;source routed packets&quot;</a></h3>
<div class="example">
	# /bin/echo "0" > /proc/sys/net/ipv4/conf/all/accept_source_route
</div>
<p>Angeifer k&ouml;nnen &quot;source routed&quot; Pakete nutzen um
&quot;Traffic&quot; zu generieren, der vom Intranet zu stammen scheint,
aber der von au&szlig;erhalb Ihres Netzwerks stammt und lediglich zur&uuml;ck geleitet wurde,
wo er her kam. So k&ouml;nnten Angreifer vorgehen um Ihr Netzwerk zu kompromitieren.</p>

<h3><a name="proc.bad_error_messages" id="proc.bad_error_messages">Schutz vor &quot;bad error messages&quot;</a></h3>
<div class="example">
	# /bin/echo "1" > /proc/sys/net/ipv4/icmp_ignore_bogus_error_responses
</div>
<p>Aktiviert den Schutz vor &quot;bogus error message responses&quot;.</p>
 
<h3><a name="proc.ip_forward" id="proc.ip_forward">Deaktivieren von &quot;IP forwarding&quot;</a></h3>
<div class="example">
	# /bin/echo "0" > /proc/sys/net/ipv4/ip_forward
</div>
<p>Diese Option ben&ouml;tigt nur ein Router, ein Host mit mehreren Netzwerk-Interfaces.
Dies sollte also bei Ihnen per Default ausgeschlatet sein.
</p>

<h3><a name="proc.logging" id="proc.logging">Logging</a></h3>
<div class="example">
	# /bin/echo "1" > /proc/sys/net/ipv4/conf/all/log_martians
</div>
<p>Dies loggt gespoofte Pakete, &quot;source routed&quot; und &quot;redirect&quot;.</p>

<h3><a name="proc.script" id="proc.script">proc-Script</a></h3>
<p>Da Einstellungen im <span class="c2">/proc</span> Filesystem beim Reboot
Ihres Systems verloren gehen, empfehle ich folgendes Script in /etc/init.d/
(je nach Distribution verschieden) zu speichern.</p>
<div class="example">
	#!/bin/sh
<br />
<br />	## DECLERATION of the VARIABLES ##
<br />	echo=&quot;/bin/echo&quot;
<br />
<br />	## for GENTOO-Users ##
<br />	depend() {
<br />	use checkroot
<br />	}
<br />
<br />	## other SPECIAL OPTIONS for this script ##
<br />	# ...
<br />
<br />	## BEGINNING to WORK ##
<br />	$echo &quot;Setting /proc options ...&quot;
<br />	$echo &quot;1&quot; &gt; /proc/sys/net/ipv4/icmp_echo_ignore_all
<br />	$echo &quot;1&quot; &gt; /proc/sys/net/ipv4/icmp_echo_ignore_broadcasts
<br />	$echo &quot;0&quot; &gt; /proc/sys/net/ipv4/conf/all/accept_source_route
<br />	$echo &quot;0&quot; &gt; /proc/sys/net/ipv4/conf/all/accept_redirects
<br />	$echo &quot;1&quot; &gt; /proc/sys/net/ipv4/icmp_ignore_bogus_error_responses
<br />	&nbsp;&nbsp;&nbsp;for i in /proc/sys/net/ipv4/conf/*; do
<br />	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$echo &quot;1&quot; &gt; $i/rp_filter
<br />	&nbsp;&nbsp;&nbsp;done
<br />	$echo &quot;1&quot; &gt; /proc/sys/net/ipv4/conf/all/log_martians
<br />	$echo &quot;0&quot; &gt; /proc/sys/net/ipv4/ip_forward
<br />	$echo &quot;DONE&quot;
<br />	exit 0
</div>
<p>Damit dies nun bei jedem Start aufgerufen wird, m&uuml;ssen Sie je nach Distribution verschieden vorgehen.
Alle Vorgehensweisen hier zu schildern w&uuml;rde diese Arbeit &quot;sprengen&quot;.</p>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>

<h2><a name="boot" id="boot">Bootloader</a></h2>
<h3><a name="boot.lilo" id="boot.lilo">LILO</a></h3>

<p>
Um zu verhindern, dass jemand w&auml;hrend des Boot-Vorgangs dem
Kernel Paramter &uuml;bergibt, ist in die <span class="c2">/etc/lilo.conf</span>
folgendes einzutragen:
</p>

<div class="example">
	password="passwort_im_plain-format_hier_eintragen"
</div>

<p>
Diese Datei sollte dann jedoch nur noch der System-Administrator
zu sehen bekommen, da sonst jeder Benutzer das Plain-Passwort
rausbekommen k&ouml;nnte. Dies macht man unter einem
Unix(-like)-System mit:
</p>

<div class="example">
	$ su<br />
	# chmod 0600 /etc/lilo.conf*
</div>

<p>
Jedes weitere Image kann nur durch Passwort gestartet werden,
bei folgendem Eintrag (in die <span class="c2">/etc/lilo.conf</span>):</p>
<div class="example">
	image="/boot/bzImage.bsp"<br />
	label="GNU/Linux"<br />
	# Sch&uuml;tzt dieses Image durch Passwort:<br />
	restricted
</div>

<h3><a name="boot.grub" id="boot.grub">GRUB</a></h3>
<p>
Bei GRUB k&ouml;nnen Sie nicht nur Plain-Text-Passwords angeben
sondern auch MD5 verschl&uuml;sselte. Wie das geht, zeige ich Ihnen im
Folgenden:
</p>
<div class="example">
	# grub<br />
	grub&gt; md5crypt<br />
	Password: **********<br />
	Encrypted: $1$U$JK7xFegdxWH6VuppCUSIb</div>
<p>
Das encryptete Passwort speichern Sie nun in Ihrer
<span class="c2">/boot/grub/menu.lst</span>:
</p>
<div class="example">
	#<br />
	# Sample boot menu configuration file<br />
	#<br />
	# [...]<br />
	<br />
	# md5-passwort:<br />
	password --md5 $1$U$JK7xFegdxWH6VuppCUSIb<br />
	<br />
	# nat&uuml;rlich gehen auch plain-text-passw&ouml;rter:<br />
	password **********<br />
	<br />
	# [...]<br />
	<br />
	title Boot OS<br />
	# dieses Image ist mit einem Passwort gesch&uuml;tzt:<br />
	lock
</div>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>

<h2><a name="fstab" id="fstab">/etc/fstab</a></h2>
<p>
Ein Auszug aus einer fstab:
</p>
<div class="example">
	/dev/hd[a-z][0-9]&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	/boot&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	ext3&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	noauto,noatime&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	1&nbsp;&nbsp;&nbsp;1
</div>
<p>
"Das <span class="c2">noauto</span> bewirkt das die Partition nicht gemountet ist
und das ist gut so, da muss man normalerweise nichts machen (ausser
Kernel neu kopieren oder Bootloader installieren) und da hat auch niemand was zu
suchen - also standardm&auml;&szlig;ig aush&auml;ngen.",<br />
KillerFox Nov 13 18:59:17 @unknow, #uscc
</p>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>

<h2><a name="syslogd" id="syslogd">/etc/syslog.conf</a></h2>
<div class="example">
	daemon,mail.*;\<br />
	news.=crit;news.=err;news.=notice;\<br />
	*.=debug;*.=info;\<br />
	*.=notice;*.=warn&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;/dev/tty8
</div>
<p>
Diese Eintragungen geben alle Log-Eintr&auml;ge des sysklogd
zus&auml;tzlich auf tty8 aus.
</p>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>

