<h1>Konfiguration</h1>
<p>
<?php
if ($lang == "en")
{
	echo "Once you've downloaded Linux from ";
	echo "<a onclick=\"window.open(this.href,\'_blank\');return false;\" href=\"http://www.kernel.org/\">kernel.org</a> ";
	echo "(or from anywhere for that matter), ";
	echo "you should proceed as follows:";

}
else
{
	echo "Wenn Sie sich Linux von ";
	echo "<a onclick=\"window.open(this.href,\'_blank\');return false;\" href=\"http://www.kernel.org/\">kernel.org</a> ";
	echo "runter geladen haben (oder von jeder ";
	echo "anderen beliebigen Stelle), k&ouml;nnen Sie wie folgt vorgehen:";

}
?>
</p>
<div class="example">
	$ su<br />
	# cd /usr/src/<br />
	# gzip -cd linux-2.4.XX.tar.gz | tar xvf -<br />
	# ln -sd linux-2.4.XX linux<br />
	# cd linux
</div>
<p>
<?php
if ($lang == "en")
{
	echo "Where XX is the version number of your kernel. To configure and compile ";
	echo "the kernel, you need to use the Makefile that is distributed with the ";
	echo "kernel sources. The figure below shows the possible parameters for the ";
	echo "Makefile.<br />";
}
else
{
	echo "Wobei XX der Versions-Nummer des Kernels entspricht.<br /> ";
	echo "Zum Konfigurieren und Kompilieren des Kernels verwenden Sie das ";
	echo "Makefile, das dem Archiv bei liegt.<br /> ";
	echo "Die unten stehende Tabelle zeigt die verschiedenen Parameter ";
	echo "f&uuml;r das Makefile.<br />";
}
?>

(<span class="c2">/usr/src/linux/README</span>)
</p>

<table>
<tr>
<th style="width:20%;">make $Regel</th>
<th style="width:80%;">Zweck</th>
</tr>
<tr>
<td style="width:20%;">make psdocs<br />
make pdfdocs<br />
make htmldocs</td>
<td style="width:80%;">Produziert die Dokumentation im gew&uuml;nschten
Format</td>
</tr>
<tr>
<td style="width:20%;">make mrproper</td>
<td style="width:80%;">Stellt sicher, dass Sie keine alten .o Dateien und
Abh&auml;nigkeiten haben</td>
</tr>
<tr>
<td style="width:20%;">make clean</td>
<td style="width:80%;">Um alte Dateien zu l&ouml;schen</td>
</tr>
<tr>
<td style="width:20%;">make config</td>
<td style="width:80%;">Um den Kernel zu konfigurieren</td>
</tr>
<tr>
<td style="width:20%;">make menuconfig</td>
<td style="width:80%;">Text-basierend, farbliche Men&uuml;s, Radiolisten
&amp; Dialoge</td>
</tr>
<tr>
<td style="width:20%;">make xconfig</td>
<td style="width:80%;">X Windows-basiertes Konfigurations-Tool</td>
</tr>
<tr>
<td style="width:20%;">make oldconfig</td>
<td style="width:80%;">Nimmt als Standard f&uuml;r die Fragen Ihre
bestehende<br />
<span class="c2">./.config</span> an</td>
</tr>
<tr>
<td style="width:20%;">make dep</td>
<td style="width:80%;">Um alle Abh&auml;nigkeiten korrekt zu setzen</td>
</tr>
<tr>
<td style="width:20%;">make bzImage</td>
<td style="width:80%;">Um ein komprimiertes Kernel-Image zu erstellen</td>
</tr>
<tr>
<td style="width:20%;">make bzdisk</td>
<td style="width:80%;">Wenn Sie eine Boot-Diskette erstellen wollen (ohne
root Dateisystem oder <span class="c1">LILO</span>)</td>
</tr>
<tr>
<td style="width:20%;">make install</td>
<td style="width:80%;">Wenn Sie LILO installiert haben</td>
</tr>
<tr>
<td style="width:20%;">make modules<br />
&nbsp;&nbsp;modules_install</td>
<td style="width:80%;">Wenn Sie Teile des Kernel als "Module" deklariert
haben, m&uuml;ssen Sie beides ausf&uuml;hren<br />
s. <span class="c2">Documentation/modules.txt</span></td>
</tr>
</table>
<p>
<?php
if ($lang == "en")
{
	echo "When configuring, you can choose between ";
	echo "<span class=\"c1\">make config</span>, ";
	echo "<span class=\"c1\">make menuconfig</span>, ";
	echo "<span class=\"c1\">make xconfig</span>, ";
	echo "<span class=\"c1\">make gconfig</span> and ";
	echo "<span class=\"c1\">make oldconfig</span>.";
}
else
{
	echo "Zur Konfiguration k&ouml;nnen Sie also zwischen ";
	echo "<span class=\"c1\">make config</span>, ";
	echo "<span class=\"c1\">make menuconfig</span>, ";
	echo "<span class=\"c1\">make xconfig</span>, ";
	echo "<span class=\"c1\">make gconfig</span> und ";
	echo "<span class=\"c1\">make oldconfig</span> w&auml;hlen.";
}
?>
</p>
<table>
<tr>
<td style="width:50%;" class="c1">
<p>Dieses Bild zeigt <span class="c1">make xconfig</span></p>
<a href="<?php echo "pic.php?pic=config/xconfig(1).jpg&amp;back=$action&amp;browser=$browser&amp;lang=$lang";?>">
<img src="pics/config/xconfig(2).jpg" width="100%" height="300" alt="Konfiguration mit Hilfe von xconfig" /></a></td>

<td style="width:50%;" class="c1">
<p>... und dieses <span class="c1">make menuconfig</span>.</p>
<a href="<?php echo "pic.php?pic=config/menuconfig(1).jpg&amp;back=$action&amp;browser=$browser&amp;lang=$lang";?>">
<img src="pics/config/menuconfig(2).jpg" width="100%" height="300" alt="Konfiguration mit Hilfe von menuconfig" /></a></td>
</tr>
</table>

<p>
<?php
if ($lang == "en")
{
	echo "So as you can see, you can configure Linux comfortably using ";
	echo "graphical dialogs. More information on the individual kernel ";
	echo "configurations can be found under  ";
	echo "<a onclick=\"window.open(this.href,\'_blank\');return false;\" href=\"http://www.linuxfibel.de/kconf.htm\"> ";
	echo "http://www.linuxfibel.de/kconf.htm</a> (German)";
}
else
{
	echo "Sie k&ouml;nnen also ganz bequem Linux konfigurieren per ";
	echo "Dialog.<br /> ";
	echo "Weitere Informationen zu den einzelnen Kernel-Einstellungen finden ";
	echo "Sie auf ";
	echo "<a onclick=\"window.open(this.href,\'_blank\');return false;\" href=\"http://www.linuxfibel.de/kconf.htm\"> ";
	echo "http://www.linuxfibel.de/kconf.htm</a> ";
}
?>
</p>
