<?php
if ($lang == "en")
	echo "<h1>Compilation</h1>";
else
	echo "<h1>Kompilierung</h1>";
?>
<p>
<?php
if ($lang == "en")
	echo "After configuring your kernel, you need to compile it with:";
else
	echo "Nach der Konfiguration erfolgt das Kompilieren mit:";
?>
</p>

<div class="example">
	$ su<br />
	# cd /usr/src/linux
</div>

<p>&nbsp;</p>
<div class="example">
	# make dep<br />
	# make clean
</div>

<p>
<?php
if ($lang == "en")
	echo "You're now able to choose from one of the following options:";
else
{
	echo "Sie haben desweiteren <span class=\"c1\">eine</span> ";
	echo "von den folgenden M&ouml;glichkeiten auszuw&auml;hlen:";
}
?>
</p>

<div class="example">
	# make bzImage<br />
	# make zImage<br />
	# make bzdisk<br />
	# make install
</div>

<p>
<?php
if ($lang == "en")
{
	echo "Use <span class=\"c2\">bzImage</span> ";
	echo "to create a compressed kernel image<br /> ";
	echo "<span class=\"c2\">zImage</span> ";
	echo "for a compressed kernel,<br /> ";
	echo "<span class=\"c2\">bzdisk</span> ";
	echo "to create a boot disk and <br /> ";
	echo "<span class=\"c2\">install</span> ";
	echo "if you want to use LILO (all further steps then become unneccesary). ";
}
else
{
	echo "Verwenden Sie ";
	echo "<span class=\"c2\">bzImage</span> ";
	echo "f&uuml;r das Erstellen eines komprimierten Kernel-Images,<br /> ";
	echo "<span class=\"c2\">zImage</span> ";
	echo "f&uuml;r einen komprimierten Kernel,<br /> ";
	echo "<span class=\"c2\">bzdisk</span> ";
	echo "f&uuml;r das Erstellen einer Boot-Diskette und<br /> ";
	echo "<span class=\"c2\">install</span> ";
	echo "wenn Sie LILO nutzen wollen (alle weiteren Schritte fallen dann weg). ";
}
?>
</p>

<div class="example">
	# make modules<br />
	# make modules_install
</div>

<p>
<?php
if ($lang == "en")
{
	echo "The time required by your computer to compile Linux is processor and ";
	echo "machine dependant. Once this process has been completed, you can copy ";
	echo "your new kernel to <span class=\"c2\">/boot/</span>. ";
	echo "Please <span class=\"c1\">don't</span> forget to make a backup of your ";
	echo "old kernel though. The backup commands are as follows: ";
}
else
{
	echo "Die Zeit, die der PC ben&ouml;tigt um Linux zu kompilieren, ";
	echo "h&auml;ngt von der Prozessorleistung ab.<br /> ";
	echo "Wenn dieser Vorgang abgeschlossen ist, k&ouml;nnen Sie ihren neuen ";
	echo "Kernel nach <span class=\"c2\">/boot/</span> kopieren. ";
	echo "Vergessen Sie aber <span class=\"c1\">nicht</span> ";
	echo "den alten Kernel zu sichern.<br /> ";
	echo "Die Befehle hierf&uuml;r k&ouml;nnten folgenderma&szlig;en ";
	echo "aussehen: ";
}
?>
</p>

<div class="example">
	# cp /boot/vmlinuz /boot/vmlinuz.old<br />
	# cp /boot/System.map /boot/System.map.old<br />
<br />
	# cp arch/i386/boot/bzImage /boot/<br />
	# cp System.map /boot/<br />
	# cp .config /boot/
</div>

<p>
<?php
if ($lang == "en")
{
	echo "After copying the kernel, you still need to test it. Depending ";
	echo "on your bootloader you still need to set various options in ";
	echo "order to boot your new kernel. ";
}
else
{
	echo "Nach dem kopieren des neuen Kernels kommt nun die Probe.<br /> ";
	echo "Je nach Bootloader m&uuml;ssen Sie noch verschiede Optionen ";
	echo "einstellen um dann booten zu k&ouml;nnen: ";
}
?>
</p>

<div class="example">
	# shutdown -r now
</div>
<p>&nbsp;</p>

<hr />

<p>
<?php
if ($lang == "en")
{
	echo "In the case where you want to overwrite your existing kernel, ";
	echo "you need to use the following commands: ";
	// Part of the code
	echo "<div class=\"example\">";
	echo "# cp /usr/src/kernel-old-version/.config \<br />";
	echo "	/usr/src/kernel-new-version/<br />";
	echo "# cd /usr/src/kernel-new-version/<br />";
	echo "# make oldconfig<br />";
	echo "# make dep &amp;&amp; make clean bzImage modules modules_install";
	echo "</div>";
}
else
{
	echo "F&uuml;r den Fall, dass Sie schon einen vollst&auml;ndigen ";
	echo "Kernel kompiliert haben und nun diesen neu &uuml;bersetzen wollen, ";
	echo "bieten sich folgende Befehle an: ";
	// Part of the code
	echo "<div class=\"example\">";
	echo "# cp /usr/src/kernel-alte-version/.config \<br />";
	echo "	/usr/src/kernel-neue-version/<br />";
	echo "# cd /usr/src/kernel-neue-version/<br />";
	echo "# make oldconfig<br />";
	echo "# make dep &amp;&amp; make clean bzImage modules modules_install";
	echo "</div>";
}
?>
</p>


