#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:85
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 85.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ test-obj() { local x='\''eval'\''; [ "$1" == '\''--debug'\'' ] && { x='\''echo'\''; shift; }; local d=2; local k=4; local n=4; local p='\'''\''; local o; while [ "$#" -gt 0 ]; do o="$1"; [[ "$o" =~ ^-[dkn][1-9][0-9]*$ || "$o" =~ ^-p$ ]] || { error "invalid option '\''$o'\''"; return 1; }; local v="${o:2}"; [ -z "$v" ] && v="${o:1:1}"; eval "${o:1:1}=$v"; shift; done; $x "../lib/test-gen -d$d -k$k -n$n -V|json -t <(../lib/test-gen --object -d$d -k$k -n$n -T$p) --sizes-type-lib-{,own-}pool-size=2M --sizes-type-lib-text-max-size=1M -VO"; }
$ test-obj -d1 -k4 -n1
$ test-obj -d1 -k4 -n1 -p
$ test-obj -d1 -k4 -n2
$ test-obj -d1 -k4 -n2 -p
$ test-obj -d1 -k4 -n4
$ test-obj -d1 -k4 -n4 -p
$ test-obj -d1 -k8 -n1
$ test-obj -d1 -k8 -n1 -p
$ test-obj -d1 -k8 -n2
$ test-obj -d1 -k8 -n2 -p
$ test-obj -d1 -k8 -n4
$ test-obj -d1 -k8 -n4 -p
$ test-obj -d1 -k16 -n1
$ test-obj -d1 -k16 -n1 -p
$ test-obj -d1 -k16 -n2
$ test-obj -d1 -k16 -n2 -p
$ test-obj -d1 -k16 -n4
$ test-obj -d1 -k16 -n4 -p
$ test-obj -d1 -k32 -n1
$ test-obj -d1 -k32 -n1 -p
$ test-obj -d1 -k32 -n2
$ test-obj -d1 -k32 -n2 -p
$ test-obj -d1 -k32 -n4
$ test-obj -d1 -k32 -n4 -p
$ test-obj -d1 -k64 -n1
$ test-obj -d1 -k64 -n1 -p
$ test-obj -d1 -k64 -n2
$ test-obj -d1 -k64 -n2 -p
$ test-obj -d1 -k64 -n4
$ test-obj -d1 -k64 -n4 -p
$ test-obj -d1 -k128 -n1
$ test-obj -d1 -k128 -n1 -p
$ test-obj -d1 -k128 -n2
$ test-obj -d1 -k128 -n2 -p
$ test-obj -d1 -k128 -n4
$ test-obj -d1 -k128 -n4 -p
$ test-obj -d2 -k4 -n1
$ test-obj -d2 -k4 -n1 -p
$ test-obj -d2 -k4 -n2
$ test-obj -d2 -k4 -n2 -p
$ test-obj -d2 -k4 -n4
$ test-obj -d2 -k4 -n4 -p
$ test-obj -d2 -k8 -n1
$ test-obj -d2 -k8 -n1 -p
$ test-obj -d2 -k8 -n2
$ test-obj -d2 -k8 -n2 -p
$ test-obj -d2 -k8 -n4
$ test-obj -d2 -k8 -n4 -p
$ test-obj -d2 -k16 -n1
$ test-obj -d2 -k16 -n1 -p
$ test-obj -d2 -k16 -n2
$ test-obj -d2 -k16 -n2 -p
$ test-obj -d2 -k16 -n4
$ test-obj -d2 -k16 -n4 -p
$ test-obj -d2 -k32 -n1
$ test-obj -d2 -k32 -n1 -p
$ test-obj -d2 -k32 -n2
$ test-obj -d2 -k32 -n2 -p
$ test-obj -d2 -k32 -n4
$ test-obj -d2 -k32 -n4 -p
$ test-obj -d2 -k64 -n1
$ test-obj -d2 -k64 -n1 -p
$ test-obj -d2 -k64 -n2
$ test-obj -d2 -k64 -n2 -p
$ test-obj -d2 -k64 -n4
$ test-obj -d2 -k64 -n4 -p
$ test-obj -d2 -k128 -n1
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d2 -k128 -n1
$ test-obj -d2 -k128 -n1 -p
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d2 -k128 -n1 -p
$ test-obj -d2 -k128 -n2
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d2 -k128 -n2
$ test-obj -d2 -k128 -n2 -p
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d2 -k128 -n2 -p
$ test-obj -d2 -k128 -n4
$ test-obj -d2 -k128 -n4 -p
$ test-obj -d3 -k4 -n1
$ test-obj -d3 -k4 -n1 -p
$ test-obj -d3 -k4 -n2
$ test-obj -d3 -k4 -n2 -p
$ test-obj -d3 -k4 -n4
$ test-obj -d3 -k4 -n4 -p
$ test-obj -d3 -k8 -n1
$ test-obj -d3 -k8 -n1 -p
$ test-obj -d3 -k8 -n2
$ test-obj -d3 -k8 -n2 -p
$ test-obj -d3 -k8 -n4
$ test-obj -d3 -k8 -n4 -p
$ test-obj -d3 -k16 -n1
$ test-obj -d3 -k16 -n1 -p
$ test-obj -d3 -k16 -n2
$ test-obj -d3 -k16 -n2 -p
$ test-obj -d3 -k16 -n4
$ test-obj -d3 -k16 -n4 -p
$ test-obj -d3 -k32 -n1
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d3 -k32 -n1
$ test-obj -d3 -k32 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k32 -n1 -p
$ test-obj -d3 -k32 -n2
$ test-obj -d3 -k32 -n2 -p
$ test-obj -d3 -k32 -n4
$ test-obj -d3 -k32 -n4 -p
$ test-obj -d3 -k64 -n1
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k64 -n1
$ test-obj -d3 -k64 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k64 -n1 -p
$ test-obj -d3 -k64 -n2
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k64 -n2
$ test-obj -d3 -k64 -n2 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k64 -n2 -p
$ test-obj -d3 -k64 -n4
$ test-obj -d3 -k64 -n4 -p
$ test-obj -d3 -k128 -n1
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k128 -n1
$ test-obj -d3 -k128 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k128 -n1 -p
$ test-obj -d3 -k128 -n2
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k128 -n2
$ test-obj -d3 -k128 -n2 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k128 -n2 -p
$ test-obj -d3 -k128 -n4
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k128 -n4
$ test-obj -d3 -k128 -n4 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d3 -k128 -n4 -p
$ test-obj -d4 -k4 -n1
$ test-obj -d4 -k4 -n1 -p
$ test-obj -d4 -k4 -n2
$ test-obj -d4 -k4 -n2 -p
$ test-obj -d4 -k4 -n4
$ test-obj -d4 -k4 -n4 -p
$ test-obj -d4 -k8 -n1
$ test-obj -d4 -k8 -n1 -p
$ test-obj -d4 -k8 -n2
$ test-obj -d4 -k8 -n2 -p
$ test-obj -d4 -k8 -n4
$ test-obj -d4 -k8 -n4 -p
$ test-obj -d4 -k16 -n1
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k16 -n1
$ test-obj -d4 -k16 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k16 -n1 -p
$ test-obj -d4 -k16 -n2
$ test-obj -d4 -k16 -n2 -p
$ test-obj -d4 -k16 -n4
$ test-obj -d4 -k16 -n4 -p
$ test-obj -d4 -k32 -n1
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k32 -n1
$ test-obj -d4 -k32 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k32 -n1 -p
$ test-obj -d4 -k32 -n2
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d4 -k32 -n2
$ test-obj -d4 -k32 -n2 -p
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d4 -k32 -n2 -p
$ test-obj -d4 -k32 -n4
$ test-obj -d4 -k32 -n4 -p
$ test-obj -d4 -k64 -n1
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k64 -n1
$ test-obj -d4 -k64 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k64 -n1 -p
$ test-obj -d4 -k64 -n2
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k64 -n2
$ test-obj -d4 -k64 -n2 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k64 -n2 -p
$ test-obj -d4 -k64 -n4
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d4 -k64 -n4
$ test-obj -d4 -k64 -n4 -p
json.so: fatal error: AST pool alloc failed
command failed: test-obj -d4 -k64 -n4 -p
$ test-obj -d4 -k128 -n1
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k128 -n1
$ test-obj -d4 -k128 -n1 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k128 -n1 -p
$ test-obj -d4 -k128 -n2
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k128 -n2
$ test-obj -d4 -k128 -n2 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k128 -n2 -p
$ test-obj -d4 -k128 -n4
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k128 -n4
$ test-obj -d4 -k128 -n4 -p
json: error: /dev/fd/??: type lib error: system error: file read: File too large
command failed: test-obj -d4 -k128 -n4 -p'
) -L 85.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ test-obj() { local x='\''eval'\''; [ "$1" == '\''--debug'\'' ] && { x='\''echo'\''; shift; }; local d=2; local k=4; local n=4; local p='\'''\''; local o; while [ "$#" -gt 0 ]; do o="$1"; [[ "$o" =~ ^-[dkn][1-9][0-9]*$ || "$o" =~ ^-p$ ]] || { error "invalid option '\''$o'\''"; return 1; }; local v="${o:2}"; [ -z "$v" ] && v="${o:1:1}"; eval "${o:1:1}=$v"; shift; done; $x "../lib/test-gen -d$d -k$k -n$n -V|json -t <(../lib/test-gen --object -d$d -k$k -n$n -T$p) --sizes-type-lib-{,own-}pool-size=2M --sizes-type-lib-text-max-size=1M -VO"; }'
test-obj() { local x='eval'; [ "$1" == '--debug' ] && { x='echo'; shift; }; local d=2; local k=4; local n=4; local p=''; local o; while [ "$#" -gt 0 ]; do o="$1"; [[ "$o" =~ ^-[dkn][1-9][0-9]*$ || "$o" =~ ^-p$ ]] || { error "invalid option '$o'"; return 1; }; local v="${o:2}"; [ -z "$v" ] && v="${o:1:1}"; eval "${o:1:1}=$v"; shift; done; $x "../lib/test-gen -d$d -k$k -n$n -V|json -t <(../lib/test-gen --object -d$d -k$k -n$n -T$p) --sizes-type-lib-{,own-}pool-size=2M --sizes-type-lib-text-max-size=1M -VO"; } 2>&1 ||
echo 'command failed: test-obj() { local x='\''eval'\''; [ "$1" == '\''--debug'\'' ] && { x='\''echo'\''; shift; }; local d=2; local k=4; local n=4; local p='\'''\''; local o; while [ "$#" -gt 0 ]; do o="$1"; [[ "$o" =~ ^-[dkn][1-9][0-9]*$ || "$o" =~ ^-p$ ]] || { error "invalid option '\''$o'\''"; return 1; }; local v="${o:2}"; [ -z "$v" ] && v="${o:1:1}"; eval "${o:1:1}=$v"; shift; done; $x "../lib/test-gen -d$d -k$k -n$n -V|json -t <(../lib/test-gen --object -d$d -k$k -n$n -T$p) --sizes-type-lib-{,own-}pool-size=2M --sizes-type-lib-text-max-size=1M -VO"; }'

echo '$ test-obj -d1 -k4 -n1'
test-obj -d1 -k4 -n1 2>&1 ||
echo 'command failed: test-obj -d1 -k4 -n1'

echo '$ test-obj -d1 -k4 -n1 -p'
test-obj -d1 -k4 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k4 -n1 -p'

echo '$ test-obj -d1 -k4 -n2'
test-obj -d1 -k4 -n2 2>&1 ||
echo 'command failed: test-obj -d1 -k4 -n2'

echo '$ test-obj -d1 -k4 -n2 -p'
test-obj -d1 -k4 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k4 -n2 -p'

echo '$ test-obj -d1 -k4 -n4'
test-obj -d1 -k4 -n4 2>&1 ||
echo 'command failed: test-obj -d1 -k4 -n4'

echo '$ test-obj -d1 -k4 -n4 -p'
test-obj -d1 -k4 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k4 -n4 -p'

echo '$ test-obj -d1 -k8 -n1'
test-obj -d1 -k8 -n1 2>&1 ||
echo 'command failed: test-obj -d1 -k8 -n1'

echo '$ test-obj -d1 -k8 -n1 -p'
test-obj -d1 -k8 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k8 -n1 -p'

echo '$ test-obj -d1 -k8 -n2'
test-obj -d1 -k8 -n2 2>&1 ||
echo 'command failed: test-obj -d1 -k8 -n2'

echo '$ test-obj -d1 -k8 -n2 -p'
test-obj -d1 -k8 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k8 -n2 -p'

echo '$ test-obj -d1 -k8 -n4'
test-obj -d1 -k8 -n4 2>&1 ||
echo 'command failed: test-obj -d1 -k8 -n4'

echo '$ test-obj -d1 -k8 -n4 -p'
test-obj -d1 -k8 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k8 -n4 -p'

echo '$ test-obj -d1 -k16 -n1'
test-obj -d1 -k16 -n1 2>&1 ||
echo 'command failed: test-obj -d1 -k16 -n1'

echo '$ test-obj -d1 -k16 -n1 -p'
test-obj -d1 -k16 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k16 -n1 -p'

echo '$ test-obj -d1 -k16 -n2'
test-obj -d1 -k16 -n2 2>&1 ||
echo 'command failed: test-obj -d1 -k16 -n2'

echo '$ test-obj -d1 -k16 -n2 -p'
test-obj -d1 -k16 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k16 -n2 -p'

echo '$ test-obj -d1 -k16 -n4'
test-obj -d1 -k16 -n4 2>&1 ||
echo 'command failed: test-obj -d1 -k16 -n4'

echo '$ test-obj -d1 -k16 -n4 -p'
test-obj -d1 -k16 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k16 -n4 -p'

echo '$ test-obj -d1 -k32 -n1'
test-obj -d1 -k32 -n1 2>&1 ||
echo 'command failed: test-obj -d1 -k32 -n1'

echo '$ test-obj -d1 -k32 -n1 -p'
test-obj -d1 -k32 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k32 -n1 -p'

echo '$ test-obj -d1 -k32 -n2'
test-obj -d1 -k32 -n2 2>&1 ||
echo 'command failed: test-obj -d1 -k32 -n2'

echo '$ test-obj -d1 -k32 -n2 -p'
test-obj -d1 -k32 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k32 -n2 -p'

echo '$ test-obj -d1 -k32 -n4'
test-obj -d1 -k32 -n4 2>&1 ||
echo 'command failed: test-obj -d1 -k32 -n4'

echo '$ test-obj -d1 -k32 -n4 -p'
test-obj -d1 -k32 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k32 -n4 -p'

echo '$ test-obj -d1 -k64 -n1'
test-obj -d1 -k64 -n1 2>&1 ||
echo 'command failed: test-obj -d1 -k64 -n1'

echo '$ test-obj -d1 -k64 -n1 -p'
test-obj -d1 -k64 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k64 -n1 -p'

echo '$ test-obj -d1 -k64 -n2'
test-obj -d1 -k64 -n2 2>&1 ||
echo 'command failed: test-obj -d1 -k64 -n2'

echo '$ test-obj -d1 -k64 -n2 -p'
test-obj -d1 -k64 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k64 -n2 -p'

echo '$ test-obj -d1 -k64 -n4'
test-obj -d1 -k64 -n4 2>&1 ||
echo 'command failed: test-obj -d1 -k64 -n4'

echo '$ test-obj -d1 -k64 -n4 -p'
test-obj -d1 -k64 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k64 -n4 -p'

echo '$ test-obj -d1 -k128 -n1'
test-obj -d1 -k128 -n1 2>&1 ||
echo 'command failed: test-obj -d1 -k128 -n1'

echo '$ test-obj -d1 -k128 -n1 -p'
test-obj -d1 -k128 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k128 -n1 -p'

echo '$ test-obj -d1 -k128 -n2'
test-obj -d1 -k128 -n2 2>&1 ||
echo 'command failed: test-obj -d1 -k128 -n2'

echo '$ test-obj -d1 -k128 -n2 -p'
test-obj -d1 -k128 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k128 -n2 -p'

echo '$ test-obj -d1 -k128 -n4'
test-obj -d1 -k128 -n4 2>&1 ||
echo 'command failed: test-obj -d1 -k128 -n4'

echo '$ test-obj -d1 -k128 -n4 -p'
test-obj -d1 -k128 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d1 -k128 -n4 -p'

echo '$ test-obj -d2 -k4 -n1'
test-obj -d2 -k4 -n1 2>&1 ||
echo 'command failed: test-obj -d2 -k4 -n1'

echo '$ test-obj -d2 -k4 -n1 -p'
test-obj -d2 -k4 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k4 -n1 -p'

echo '$ test-obj -d2 -k4 -n2'
test-obj -d2 -k4 -n2 2>&1 ||
echo 'command failed: test-obj -d2 -k4 -n2'

echo '$ test-obj -d2 -k4 -n2 -p'
test-obj -d2 -k4 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k4 -n2 -p'

echo '$ test-obj -d2 -k4 -n4'
test-obj -d2 -k4 -n4 2>&1 ||
echo 'command failed: test-obj -d2 -k4 -n4'

echo '$ test-obj -d2 -k4 -n4 -p'
test-obj -d2 -k4 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k4 -n4 -p'

echo '$ test-obj -d2 -k8 -n1'
test-obj -d2 -k8 -n1 2>&1 ||
echo 'command failed: test-obj -d2 -k8 -n1'

echo '$ test-obj -d2 -k8 -n1 -p'
test-obj -d2 -k8 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k8 -n1 -p'

echo '$ test-obj -d2 -k8 -n2'
test-obj -d2 -k8 -n2 2>&1 ||
echo 'command failed: test-obj -d2 -k8 -n2'

echo '$ test-obj -d2 -k8 -n2 -p'
test-obj -d2 -k8 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k8 -n2 -p'

echo '$ test-obj -d2 -k8 -n4'
test-obj -d2 -k8 -n4 2>&1 ||
echo 'command failed: test-obj -d2 -k8 -n4'

echo '$ test-obj -d2 -k8 -n4 -p'
test-obj -d2 -k8 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k8 -n4 -p'

echo '$ test-obj -d2 -k16 -n1'
test-obj -d2 -k16 -n1 2>&1 ||
echo 'command failed: test-obj -d2 -k16 -n1'

echo '$ test-obj -d2 -k16 -n1 -p'
test-obj -d2 -k16 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k16 -n1 -p'

echo '$ test-obj -d2 -k16 -n2'
test-obj -d2 -k16 -n2 2>&1 ||
echo 'command failed: test-obj -d2 -k16 -n2'

echo '$ test-obj -d2 -k16 -n2 -p'
test-obj -d2 -k16 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k16 -n2 -p'

echo '$ test-obj -d2 -k16 -n4'
test-obj -d2 -k16 -n4 2>&1 ||
echo 'command failed: test-obj -d2 -k16 -n4'

echo '$ test-obj -d2 -k16 -n4 -p'
test-obj -d2 -k16 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k16 -n4 -p'

echo '$ test-obj -d2 -k32 -n1'
test-obj -d2 -k32 -n1 2>&1 ||
echo 'command failed: test-obj -d2 -k32 -n1'

echo '$ test-obj -d2 -k32 -n1 -p'
test-obj -d2 -k32 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k32 -n1 -p'

echo '$ test-obj -d2 -k32 -n2'
test-obj -d2 -k32 -n2 2>&1 ||
echo 'command failed: test-obj -d2 -k32 -n2'

echo '$ test-obj -d2 -k32 -n2 -p'
test-obj -d2 -k32 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k32 -n2 -p'

echo '$ test-obj -d2 -k32 -n4'
test-obj -d2 -k32 -n4 2>&1 ||
echo 'command failed: test-obj -d2 -k32 -n4'

echo '$ test-obj -d2 -k32 -n4 -p'
test-obj -d2 -k32 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k32 -n4 -p'

echo '$ test-obj -d2 -k64 -n1'
test-obj -d2 -k64 -n1 2>&1 ||
echo 'command failed: test-obj -d2 -k64 -n1'

echo '$ test-obj -d2 -k64 -n1 -p'
test-obj -d2 -k64 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k64 -n1 -p'

echo '$ test-obj -d2 -k64 -n2'
test-obj -d2 -k64 -n2 2>&1 ||
echo 'command failed: test-obj -d2 -k64 -n2'

echo '$ test-obj -d2 -k64 -n2 -p'
test-obj -d2 -k64 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k64 -n2 -p'

echo '$ test-obj -d2 -k64 -n4'
test-obj -d2 -k64 -n4 2>&1 ||
echo 'command failed: test-obj -d2 -k64 -n4'

echo '$ test-obj -d2 -k64 -n4 -p'
test-obj -d2 -k64 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k64 -n4 -p'

echo '$ test-obj -d2 -k128 -n1'
test-obj -d2 -k128 -n1 2>&1 ||
echo 'command failed: test-obj -d2 -k128 -n1'

echo '$ test-obj -d2 -k128 -n1 -p'
test-obj -d2 -k128 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k128 -n1 -p'

echo '$ test-obj -d2 -k128 -n2'
test-obj -d2 -k128 -n2 2>&1 ||
echo 'command failed: test-obj -d2 -k128 -n2'

echo '$ test-obj -d2 -k128 -n2 -p'
test-obj -d2 -k128 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k128 -n2 -p'

echo '$ test-obj -d2 -k128 -n4'
test-obj -d2 -k128 -n4 2>&1 ||
echo 'command failed: test-obj -d2 -k128 -n4'

echo '$ test-obj -d2 -k128 -n4 -p'
test-obj -d2 -k128 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d2 -k128 -n4 -p'

echo '$ test-obj -d3 -k4 -n1'
test-obj -d3 -k4 -n1 2>&1 ||
echo 'command failed: test-obj -d3 -k4 -n1'

echo '$ test-obj -d3 -k4 -n1 -p'
test-obj -d3 -k4 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k4 -n1 -p'

echo '$ test-obj -d3 -k4 -n2'
test-obj -d3 -k4 -n2 2>&1 ||
echo 'command failed: test-obj -d3 -k4 -n2'

echo '$ test-obj -d3 -k4 -n2 -p'
test-obj -d3 -k4 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k4 -n2 -p'

echo '$ test-obj -d3 -k4 -n4'
test-obj -d3 -k4 -n4 2>&1 ||
echo 'command failed: test-obj -d3 -k4 -n4'

echo '$ test-obj -d3 -k4 -n4 -p'
test-obj -d3 -k4 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k4 -n4 -p'

echo '$ test-obj -d3 -k8 -n1'
test-obj -d3 -k8 -n1 2>&1 ||
echo 'command failed: test-obj -d3 -k8 -n1'

echo '$ test-obj -d3 -k8 -n1 -p'
test-obj -d3 -k8 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k8 -n1 -p'

echo '$ test-obj -d3 -k8 -n2'
test-obj -d3 -k8 -n2 2>&1 ||
echo 'command failed: test-obj -d3 -k8 -n2'

echo '$ test-obj -d3 -k8 -n2 -p'
test-obj -d3 -k8 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k8 -n2 -p'

echo '$ test-obj -d3 -k8 -n4'
test-obj -d3 -k8 -n4 2>&1 ||
echo 'command failed: test-obj -d3 -k8 -n4'

echo '$ test-obj -d3 -k8 -n4 -p'
test-obj -d3 -k8 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k8 -n4 -p'

echo '$ test-obj -d3 -k16 -n1'
test-obj -d3 -k16 -n1 2>&1 ||
echo 'command failed: test-obj -d3 -k16 -n1'

echo '$ test-obj -d3 -k16 -n1 -p'
test-obj -d3 -k16 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k16 -n1 -p'

echo '$ test-obj -d3 -k16 -n2'
test-obj -d3 -k16 -n2 2>&1 ||
echo 'command failed: test-obj -d3 -k16 -n2'

echo '$ test-obj -d3 -k16 -n2 -p'
test-obj -d3 -k16 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k16 -n2 -p'

echo '$ test-obj -d3 -k16 -n4'
test-obj -d3 -k16 -n4 2>&1 ||
echo 'command failed: test-obj -d3 -k16 -n4'

echo '$ test-obj -d3 -k16 -n4 -p'
test-obj -d3 -k16 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k16 -n4 -p'

echo '$ test-obj -d3 -k32 -n1'
test-obj -d3 -k32 -n1 2>&1 ||
echo 'command failed: test-obj -d3 -k32 -n1'

echo '$ test-obj -d3 -k32 -n1 -p'
test-obj -d3 -k32 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k32 -n1 -p'

echo '$ test-obj -d3 -k32 -n2'
test-obj -d3 -k32 -n2 2>&1 ||
echo 'command failed: test-obj -d3 -k32 -n2'

echo '$ test-obj -d3 -k32 -n2 -p'
test-obj -d3 -k32 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k32 -n2 -p'

echo '$ test-obj -d3 -k32 -n4'
test-obj -d3 -k32 -n4 2>&1 ||
echo 'command failed: test-obj -d3 -k32 -n4'

echo '$ test-obj -d3 -k32 -n4 -p'
test-obj -d3 -k32 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k32 -n4 -p'

echo '$ test-obj -d3 -k64 -n1'
test-obj -d3 -k64 -n1 2>&1 ||
echo 'command failed: test-obj -d3 -k64 -n1'

echo '$ test-obj -d3 -k64 -n1 -p'
test-obj -d3 -k64 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k64 -n1 -p'

echo '$ test-obj -d3 -k64 -n2'
test-obj -d3 -k64 -n2 2>&1 ||
echo 'command failed: test-obj -d3 -k64 -n2'

echo '$ test-obj -d3 -k64 -n2 -p'
test-obj -d3 -k64 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k64 -n2 -p'

echo '$ test-obj -d3 -k64 -n4'
test-obj -d3 -k64 -n4 2>&1 ||
echo 'command failed: test-obj -d3 -k64 -n4'

echo '$ test-obj -d3 -k64 -n4 -p'
test-obj -d3 -k64 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k64 -n4 -p'

echo '$ test-obj -d3 -k128 -n1'
test-obj -d3 -k128 -n1 2>&1 ||
echo 'command failed: test-obj -d3 -k128 -n1'

echo '$ test-obj -d3 -k128 -n1 -p'
test-obj -d3 -k128 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k128 -n1 -p'

echo '$ test-obj -d3 -k128 -n2'
test-obj -d3 -k128 -n2 2>&1 ||
echo 'command failed: test-obj -d3 -k128 -n2'

echo '$ test-obj -d3 -k128 -n2 -p'
test-obj -d3 -k128 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k128 -n2 -p'

echo '$ test-obj -d3 -k128 -n4'
test-obj -d3 -k128 -n4 2>&1 ||
echo 'command failed: test-obj -d3 -k128 -n4'

echo '$ test-obj -d3 -k128 -n4 -p'
test-obj -d3 -k128 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d3 -k128 -n4 -p'

echo '$ test-obj -d4 -k4 -n1'
test-obj -d4 -k4 -n1 2>&1 ||
echo 'command failed: test-obj -d4 -k4 -n1'

echo '$ test-obj -d4 -k4 -n1 -p'
test-obj -d4 -k4 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k4 -n1 -p'

echo '$ test-obj -d4 -k4 -n2'
test-obj -d4 -k4 -n2 2>&1 ||
echo 'command failed: test-obj -d4 -k4 -n2'

echo '$ test-obj -d4 -k4 -n2 -p'
test-obj -d4 -k4 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k4 -n2 -p'

echo '$ test-obj -d4 -k4 -n4'
test-obj -d4 -k4 -n4 2>&1 ||
echo 'command failed: test-obj -d4 -k4 -n4'

echo '$ test-obj -d4 -k4 -n4 -p'
test-obj -d4 -k4 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k4 -n4 -p'

echo '$ test-obj -d4 -k8 -n1'
test-obj -d4 -k8 -n1 2>&1 ||
echo 'command failed: test-obj -d4 -k8 -n1'

echo '$ test-obj -d4 -k8 -n1 -p'
test-obj -d4 -k8 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k8 -n1 -p'

echo '$ test-obj -d4 -k8 -n2'
test-obj -d4 -k8 -n2 2>&1 ||
echo 'command failed: test-obj -d4 -k8 -n2'

echo '$ test-obj -d4 -k8 -n2 -p'
test-obj -d4 -k8 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k8 -n2 -p'

echo '$ test-obj -d4 -k8 -n4'
test-obj -d4 -k8 -n4 2>&1 ||
echo 'command failed: test-obj -d4 -k8 -n4'

echo '$ test-obj -d4 -k8 -n4 -p'
test-obj -d4 -k8 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k8 -n4 -p'

echo '$ test-obj -d4 -k16 -n1'
test-obj -d4 -k16 -n1 2>&1 ||
echo 'command failed: test-obj -d4 -k16 -n1'

echo '$ test-obj -d4 -k16 -n1 -p'
test-obj -d4 -k16 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k16 -n1 -p'

echo '$ test-obj -d4 -k16 -n2'
test-obj -d4 -k16 -n2 2>&1 ||
echo 'command failed: test-obj -d4 -k16 -n2'

echo '$ test-obj -d4 -k16 -n2 -p'
test-obj -d4 -k16 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k16 -n2 -p'

echo '$ test-obj -d4 -k16 -n4'
test-obj -d4 -k16 -n4 2>&1 ||
echo 'command failed: test-obj -d4 -k16 -n4'

echo '$ test-obj -d4 -k16 -n4 -p'
test-obj -d4 -k16 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k16 -n4 -p'

echo '$ test-obj -d4 -k32 -n1'
test-obj -d4 -k32 -n1 2>&1 ||
echo 'command failed: test-obj -d4 -k32 -n1'

echo '$ test-obj -d4 -k32 -n1 -p'
test-obj -d4 -k32 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k32 -n1 -p'

echo '$ test-obj -d4 -k32 -n2'
test-obj -d4 -k32 -n2 2>&1 ||
echo 'command failed: test-obj -d4 -k32 -n2'

echo '$ test-obj -d4 -k32 -n2 -p'
test-obj -d4 -k32 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k32 -n2 -p'

echo '$ test-obj -d4 -k32 -n4'
test-obj -d4 -k32 -n4 2>&1 ||
echo 'command failed: test-obj -d4 -k32 -n4'

echo '$ test-obj -d4 -k32 -n4 -p'
test-obj -d4 -k32 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k32 -n4 -p'

echo '$ test-obj -d4 -k64 -n1'
test-obj -d4 -k64 -n1 2>&1 ||
echo 'command failed: test-obj -d4 -k64 -n1'

echo '$ test-obj -d4 -k64 -n1 -p'
test-obj -d4 -k64 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k64 -n1 -p'

echo '$ test-obj -d4 -k64 -n2'
test-obj -d4 -k64 -n2 2>&1 ||
echo 'command failed: test-obj -d4 -k64 -n2'

echo '$ test-obj -d4 -k64 -n2 -p'
test-obj -d4 -k64 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k64 -n2 -p'

echo '$ test-obj -d4 -k64 -n4'
test-obj -d4 -k64 -n4 2>&1 ||
echo 'command failed: test-obj -d4 -k64 -n4'

echo '$ test-obj -d4 -k64 -n4 -p'
test-obj -d4 -k64 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k64 -n4 -p'

echo '$ test-obj -d4 -k128 -n1'
test-obj -d4 -k128 -n1 2>&1 ||
echo 'command failed: test-obj -d4 -k128 -n1'

echo '$ test-obj -d4 -k128 -n1 -p'
test-obj -d4 -k128 -n1 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k128 -n1 -p'

echo '$ test-obj -d4 -k128 -n2'
test-obj -d4 -k128 -n2 2>&1 ||
echo 'command failed: test-obj -d4 -k128 -n2'

echo '$ test-obj -d4 -k128 -n2 -p'
test-obj -d4 -k128 -n2 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k128 -n2 -p'

echo '$ test-obj -d4 -k128 -n4'
test-obj -d4 -k128 -n4 2>&1 ||
echo 'command failed: test-obj -d4 -k128 -n4'

echo '$ test-obj -d4 -k128 -n4 -p'
test-obj -d4 -k128 -n4 -p 2>&1 ||
echo 'command failed: test-obj -d4 -k128 -n4 -p'
)

