#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:trim3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L trim3.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }
$ echo -ne '\''\fA\f'\''|json -b 1
A
$ echo -ne '\''\fA\f'\''|json -b 2
A
$ echo -ne '\''\fA\f'\''|json -b 3
A
$ echo -ne '\''\fA\f'\''|json -b 4
A
$ echo -ne '\''\f\xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\''\f\xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\''\f\xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\''\f\xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\''\f\xc2\x80\f'\''|json -b 5
\u0080
$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 6
\u0800
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 7
$ echo -ne '\''\fA\n'\''|json -b 1
A
$ echo -ne '\''\fA\n'\''|json -b 2
A
$ echo -ne '\''\fA\n'\''|json -b 3
A
$ echo -ne '\''\fA\n'\''|json -b 4
A
$ echo -ne '\''\f\xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\''\f\xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\''\f\xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\''\f\xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\''\f\xc2\x80\n'\''|json -b 5
\u0080
$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 6
\u0800
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 7
$ echo -ne '\''\fA\r'\''|json -b 1
A
$ echo -ne '\''\fA\r'\''|json -b 2
A
$ echo -ne '\''\fA\r'\''|json -b 3
A
$ echo -ne '\''\fA\r'\''|json -b 4
A
$ echo -ne '\''\f\xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\''\f\xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\''\f\xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\''\f\xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\''\f\xc2\x80\r'\''|json -b 5
\u0080
$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 6
\u0800
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 7
$ echo -ne '\''\fA\t'\''|json -b 1
A
$ echo -ne '\''\fA\t'\''|json -b 2
A
$ echo -ne '\''\fA\t'\''|json -b 3
A
$ echo -ne '\''\fA\t'\''|json -b 4
A
$ echo -ne '\''\f\xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\''\f\xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\''\f\xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\''\f\xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\''\f\xc2\x80\t'\''|json -b 5
\u0080
$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 6
\u0800
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 7
$ echo -ne '\''\fA\v'\''|json -b 1
A
$ echo -ne '\''\fA\v'\''|json -b 2
A
$ echo -ne '\''\fA\v'\''|json -b 3
A
$ echo -ne '\''\fA\v'\''|json -b 4
A
$ echo -ne '\''\f\xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\''\f\xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\''\f\xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\''\f\xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\''\f\xc2\x80\v'\''|json -b 5
\u0080
$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 6
\u0800
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 7
$ echo -ne '\''\fA '\''|json -b 1
A
$ echo -ne '\''\fA '\''|json -b 2
A
$ echo -ne '\''\fA '\''|json -b 3
A
$ echo -ne '\''\fA '\''|json -b 4
A
$ echo -ne '\''\f\xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\''\f\xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\''\f\xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\''\f\xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\''\f\xc2\x80 '\''|json -b 5
\u0080
$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 6
\u0800
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 6
$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \f\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 7
$ echo -ne '\''\nA\f'\''|json -b 1
A
$ echo -ne '\''\nA\f'\''|json -b 2
A
$ echo -ne '\''\nA\f'\''|json -b 3
A
$ echo -ne '\''\nA\f'\''|json -b 4
A
$ echo -ne '\''\n\xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\''\n\xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\''\n\xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\''\n\xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\''\n\xc2\x80\f'\''|json -b 5
\u0080
$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 6
\u0800
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 7
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\f
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 7
$ echo -ne '\''\nA\n'\''|json -b 1
A
$ echo -ne '\''\nA\n'\''|json -b 2
A
$ echo -ne '\''\nA\n'\''|json -b 3
A
$ echo -ne '\''\nA\n'\''|json -b 4
A
$ echo -ne '\''\n\xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\''\n\xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\''\n\xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\''\n\xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\''\n\xc2\x80\n'\''|json -b 5
\u0080
$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 6
\u0800
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 7
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 7
$ echo -ne '\''\nA\r'\''|json -b 1
A
$ echo -ne '\''\nA\r'\''|json -b 2
A
$ echo -ne '\''\nA\r'\''|json -b 3
A
$ echo -ne '\''\nA\r'\''|json -b 4
A
$ echo -ne '\''\n\xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\''\n\xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\''\n\xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\''\n\xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\''\n\xc2\x80\r'\''|json -b 5
\u0080
$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 6
\u0800
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 7
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\r
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 7
$ echo -ne '\''\nA\t'\''|json -b 1
A
$ echo -ne '\''\nA\t'\''|json -b 2
A
$ echo -ne '\''\nA\t'\''|json -b 3
A
$ echo -ne '\''\nA\t'\''|json -b 4
A
$ echo -ne '\''\n\xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\''\n\xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\''\n\xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\''\n\xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\''\n\xc2\x80\t'\''|json -b 5
\u0080
$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 6
\u0800
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 7
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\t
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 7
$ echo -ne '\''\nA\v'\''|json -b 1
A
$ echo -ne '\''\nA\v'\''|json -b 2
A
$ echo -ne '\''\nA\v'\''|json -b 3
A
$ echo -ne '\''\nA\v'\''|json -b 4
A
$ echo -ne '\''\n\xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\''\n\xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\''\n\xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\''\n\xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\''\n\xc2\x80\v'\''|json -b 5
\u0080
$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 6
\u0800
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 7
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80\v
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 7
$ echo -ne '\''\nA '\''|json -b 1
A
$ echo -ne '\''\nA '\''|json -b 2
A
$ echo -ne '\''\nA '\''|json -b 3
A
$ echo -ne '\''\nA '\''|json -b 4
A
$ echo -ne '\''\n\xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\''\n\xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\''\n\xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\''\n\xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\''\n\xc2\x80 '\''|json -b 5
\u0080
$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 6
\u0800
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 6
$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 7
json: error: <stdin>:2:1: non-BMP utf-8 encoding
json: error: <stdin>:2:1: \n\xf0\x90\x80\x80 
json: error: <stdin>:2:1:   ^
command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 7
$ echo -ne '\''\rA\f'\''|json -b 1
A
$ echo -ne '\''\rA\f'\''|json -b 2
A
$ echo -ne '\''\rA\f'\''|json -b 3
A
$ echo -ne '\''\rA\f'\''|json -b 4
A
$ echo -ne '\''\r\xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\''\r\xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\''\r\xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\''\r\xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\''\r\xc2\x80\f'\''|json -b 5
\u0080
$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 6
\u0800
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 7
$ echo -ne '\''\rA\n'\''|json -b 1
A
$ echo -ne '\''\rA\n'\''|json -b 2
A
$ echo -ne '\''\rA\n'\''|json -b 3
A
$ echo -ne '\''\rA\n'\''|json -b 4
A
$ echo -ne '\''\r\xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\''\r\xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\''\r\xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\''\r\xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\''\r\xc2\x80\n'\''|json -b 5
\u0080
$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 6
\u0800
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 7
$ echo -ne '\''\rA\r'\''|json -b 1
A
$ echo -ne '\''\rA\r'\''|json -b 2
A
$ echo -ne '\''\rA\r'\''|json -b 3
A
$ echo -ne '\''\rA\r'\''|json -b 4
A
$ echo -ne '\''\r\xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\''\r\xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\''\r\xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\''\r\xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\''\r\xc2\x80\r'\''|json -b 5
\u0080
$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 6
\u0800
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 7
$ echo -ne '\''\rA\t'\''|json -b 1
A
$ echo -ne '\''\rA\t'\''|json -b 2
A
$ echo -ne '\''\rA\t'\''|json -b 3
A
$ echo -ne '\''\rA\t'\''|json -b 4
A
$ echo -ne '\''\r\xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\''\r\xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\''\r\xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\''\r\xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\''\r\xc2\x80\t'\''|json -b 5
\u0080
$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 6
\u0800
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 7
$ echo -ne '\''\rA\v'\''|json -b 1
A
$ echo -ne '\''\rA\v'\''|json -b 2
A
$ echo -ne '\''\rA\v'\''|json -b 3
A
$ echo -ne '\''\rA\v'\''|json -b 4
A
$ echo -ne '\''\r\xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\''\r\xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\''\r\xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\''\r\xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\''\r\xc2\x80\v'\''|json -b 5
\u0080
$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 6
\u0800
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 7
$ echo -ne '\''\rA '\''|json -b 1
A
$ echo -ne '\''\rA '\''|json -b 2
A
$ echo -ne '\''\rA '\''|json -b 3
A
$ echo -ne '\''\rA '\''|json -b 4
A
$ echo -ne '\''\r\xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\''\r\xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\''\r\xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\''\r\xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\''\r\xc2\x80 '\''|json -b 5
\u0080
$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 6
\u0800
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 6
$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \r\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 7
$ echo -ne '\''\tA\f'\''|json -b 1
A
$ echo -ne '\''\tA\f'\''|json -b 2
A
$ echo -ne '\''\tA\f'\''|json -b 3
A
$ echo -ne '\''\tA\f'\''|json -b 4
A
$ echo -ne '\''\t\xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\''\t\xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\''\t\xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\''\t\xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\''\t\xc2\x80\f'\''|json -b 5
\u0080
$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 6
\u0800
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 7
$ echo -ne '\''\tA\n'\''|json -b 1
A
$ echo -ne '\''\tA\n'\''|json -b 2
A
$ echo -ne '\''\tA\n'\''|json -b 3
A
$ echo -ne '\''\tA\n'\''|json -b 4
A
$ echo -ne '\''\t\xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\''\t\xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\''\t\xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\''\t\xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\''\t\xc2\x80\n'\''|json -b 5
\u0080
$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 6
\u0800
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 7
$ echo -ne '\''\tA\r'\''|json -b 1
A
$ echo -ne '\''\tA\r'\''|json -b 2
A
$ echo -ne '\''\tA\r'\''|json -b 3
A
$ echo -ne '\''\tA\r'\''|json -b 4
A
$ echo -ne '\''\t\xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\''\t\xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\''\t\xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\''\t\xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\''\t\xc2\x80\r'\''|json -b 5
\u0080
$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 6
\u0800
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 7
$ echo -ne '\''\tA\t'\''|json -b 1
A
$ echo -ne '\''\tA\t'\''|json -b 2
A
$ echo -ne '\''\tA\t'\''|json -b 3
A
$ echo -ne '\''\tA\t'\''|json -b 4
A
$ echo -ne '\''\t\xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\''\t\xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\''\t\xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\''\t\xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\''\t\xc2\x80\t'\''|json -b 5
\u0080
$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 6
\u0800
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 7
$ echo -ne '\''\tA\v'\''|json -b 1
A
$ echo -ne '\''\tA\v'\''|json -b 2
A
$ echo -ne '\''\tA\v'\''|json -b 3
A
$ echo -ne '\''\tA\v'\''|json -b 4
A
$ echo -ne '\''\t\xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\''\t\xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\''\t\xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\''\t\xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\''\t\xc2\x80\v'\''|json -b 5
\u0080
$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 6
\u0800
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 7
$ echo -ne '\''\tA '\''|json -b 1
A
$ echo -ne '\''\tA '\''|json -b 2
A
$ echo -ne '\''\tA '\''|json -b 3
A
$ echo -ne '\''\tA '\''|json -b 4
A
$ echo -ne '\''\t\xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\''\t\xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\''\t\xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\''\t\xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\''\t\xc2\x80 '\''|json -b 5
\u0080
$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 6
\u0800
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 6
$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \t\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 7
$ echo -ne '\''\vA\f'\''|json -b 1
A
$ echo -ne '\''\vA\f'\''|json -b 2
A
$ echo -ne '\''\vA\f'\''|json -b 3
A
$ echo -ne '\''\vA\f'\''|json -b 4
A
$ echo -ne '\''\v\xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\''\v\xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\''\v\xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\''\v\xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\''\v\xc2\x80\f'\''|json -b 5
\u0080
$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 6
\u0800
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\f
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 7
$ echo -ne '\''\vA\n'\''|json -b 1
A
$ echo -ne '\''\vA\n'\''|json -b 2
A
$ echo -ne '\''\vA\n'\''|json -b 3
A
$ echo -ne '\''\vA\n'\''|json -b 4
A
$ echo -ne '\''\v\xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\''\v\xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\''\v\xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\''\v\xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\''\v\xc2\x80\n'\''|json -b 5
\u0080
$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 6
\u0800
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 7
$ echo -ne '\''\vA\r'\''|json -b 1
A
$ echo -ne '\''\vA\r'\''|json -b 2
A
$ echo -ne '\''\vA\r'\''|json -b 3
A
$ echo -ne '\''\vA\r'\''|json -b 4
A
$ echo -ne '\''\v\xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\''\v\xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\''\v\xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\''\v\xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\''\v\xc2\x80\r'\''|json -b 5
\u0080
$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 6
\u0800
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\r
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 7
$ echo -ne '\''\vA\t'\''|json -b 1
A
$ echo -ne '\''\vA\t'\''|json -b 2
A
$ echo -ne '\''\vA\t'\''|json -b 3
A
$ echo -ne '\''\vA\t'\''|json -b 4
A
$ echo -ne '\''\v\xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\''\v\xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\''\v\xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\''\v\xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\''\v\xc2\x80\t'\''|json -b 5
\u0080
$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 6
\u0800
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\t
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 7
$ echo -ne '\''\vA\v'\''|json -b 1
A
$ echo -ne '\''\vA\v'\''|json -b 2
A
$ echo -ne '\''\vA\v'\''|json -b 3
A
$ echo -ne '\''\vA\v'\''|json -b 4
A
$ echo -ne '\''\v\xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\''\v\xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\''\v\xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\''\v\xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\''\v\xc2\x80\v'\''|json -b 5
\u0080
$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 6
\u0800
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80\v
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 7
$ echo -ne '\''\vA '\''|json -b 1
A
$ echo -ne '\''\vA '\''|json -b 2
A
$ echo -ne '\''\vA '\''|json -b 3
A
$ echo -ne '\''\vA '\''|json -b 4
A
$ echo -ne '\''\v\xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\''\v\xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\''\v\xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\''\v\xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\''\v\xc2\x80 '\''|json -b 5
\u0080
$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 6
\u0800
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 6
$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2: \v\xf0\x90\x80\x80 
json: error: <stdin>:1:2:   ^
command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 7
$ echo -ne '\'' A\f'\''|json -b 1
A
$ echo -ne '\'' A\f'\''|json -b 2
A
$ echo -ne '\'' A\f'\''|json -b 3
A
$ echo -ne '\'' A\f'\''|json -b 4
A
$ echo -ne '\'' \xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\'' \xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\'' \xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\'' \xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\'' \xc2\x80\f'\''|json -b 5
\u0080
$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 6
\u0800
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\f
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 7
$ echo -ne '\'' A\n'\''|json -b 1
A
$ echo -ne '\'' A\n'\''|json -b 2
A
$ echo -ne '\'' A\n'\''|json -b 3
A
$ echo -ne '\'' A\n'\''|json -b 4
A
$ echo -ne '\'' \xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\'' \xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\'' \xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\'' \xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\'' \xc2\x80\n'\''|json -b 5
\u0080
$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 6
\u0800
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 7
$ echo -ne '\'' A\r'\''|json -b 1
A
$ echo -ne '\'' A\r'\''|json -b 2
A
$ echo -ne '\'' A\r'\''|json -b 3
A
$ echo -ne '\'' A\r'\''|json -b 4
A
$ echo -ne '\'' \xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\'' \xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\'' \xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\'' \xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\'' \xc2\x80\r'\''|json -b 5
\u0080
$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 6
\u0800
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\r
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 7
$ echo -ne '\'' A\t'\''|json -b 1
A
$ echo -ne '\'' A\t'\''|json -b 2
A
$ echo -ne '\'' A\t'\''|json -b 3
A
$ echo -ne '\'' A\t'\''|json -b 4
A
$ echo -ne '\'' \xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\'' \xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\'' \xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\'' \xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\'' \xc2\x80\t'\''|json -b 5
\u0080
$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 6
\u0800
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\t
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 7
$ echo -ne '\'' A\v'\''|json -b 1
A
$ echo -ne '\'' A\v'\''|json -b 2
A
$ echo -ne '\'' A\v'\''|json -b 3
A
$ echo -ne '\'' A\v'\''|json -b 4
A
$ echo -ne '\'' \xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\'' \xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\'' \xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\'' \xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\'' \xc2\x80\v'\''|json -b 5
\u0080
$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 6
\u0800
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80\v
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 7
$ echo -ne '\'' A '\''|json -b 1
A
$ echo -ne '\'' A '\''|json -b 2
A
$ echo -ne '\'' A '\''|json -b 3
A
$ echo -ne '\'' A '\''|json -b 4
A
$ echo -ne '\'' \xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\'' \xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\'' \xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\'' \xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\'' \xc2\x80 '\''|json -b 5
\u0080
$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 6
\u0800
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 6
$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 7
json: error: <stdin>:1:2: non-BMP utf-8 encoding
json: error: <stdin>:1:2:  \xf0\x90\x80\x80 
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 7'
) -L trim3.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'

echo '$ echo -ne '\''\fA\f'\''|json -b 1'
echo -ne '\fA\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\fA\f'\''|json -b 1'

echo '$ echo -ne '\''\fA\f'\''|json -b 2'
echo -ne '\fA\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\fA\f'\''|json -b 2'

echo '$ echo -ne '\''\fA\f'\''|json -b 3'
echo -ne '\fA\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\fA\f'\''|json -b 3'

echo '$ echo -ne '\''\fA\f'\''|json -b 4'
echo -ne '\fA\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\fA\f'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\f'\''|json -b 1'
echo -ne '\f\xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\f\xc2\x80\f'\''|json -b 2'
echo -ne '\f\xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\f\xc2\x80\f'\''|json -b 3'
echo -ne '\f\xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\f\xc2\x80\f'\''|json -b 4'
echo -ne '\f\xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\f'\''|json -b 5'
echo -ne '\f\xc2\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 1'
echo -ne '\f\xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 2'
echo -ne '\f\xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 3'
echo -ne '\f\xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 4'
echo -ne '\f\xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 5'
echo -ne '\f\xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 6'
echo -ne '\f\xe0\xa0\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 7'
echo -ne '\f\xf0\x90\x80\x80\f'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\f'\''|json -b 7'

echo '$ echo -ne '\''\fA\n'\''|json -b 1'
echo -ne '\fA\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\fA\n'\''|json -b 1'

echo '$ echo -ne '\''\fA\n'\''|json -b 2'
echo -ne '\fA\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\fA\n'\''|json -b 2'

echo '$ echo -ne '\''\fA\n'\''|json -b 3'
echo -ne '\fA\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\fA\n'\''|json -b 3'

echo '$ echo -ne '\''\fA\n'\''|json -b 4'
echo -ne '\fA\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\fA\n'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\n'\''|json -b 1'
echo -ne '\f\xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\f\xc2\x80\n'\''|json -b 2'
echo -ne '\f\xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\f\xc2\x80\n'\''|json -b 3'
echo -ne '\f\xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\f\xc2\x80\n'\''|json -b 4'
echo -ne '\f\xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\n'\''|json -b 5'
echo -ne '\f\xc2\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 1'
echo -ne '\f\xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 2'
echo -ne '\f\xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 3'
echo -ne '\f\xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 4'
echo -ne '\f\xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 5'
echo -ne '\f\xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 6'
echo -ne '\f\xe0\xa0\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 7'
echo -ne '\f\xf0\x90\x80\x80\n'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\n'\''|json -b 7'

echo '$ echo -ne '\''\fA\r'\''|json -b 1'
echo -ne '\fA\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\fA\r'\''|json -b 1'

echo '$ echo -ne '\''\fA\r'\''|json -b 2'
echo -ne '\fA\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\fA\r'\''|json -b 2'

echo '$ echo -ne '\''\fA\r'\''|json -b 3'
echo -ne '\fA\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\fA\r'\''|json -b 3'

echo '$ echo -ne '\''\fA\r'\''|json -b 4'
echo -ne '\fA\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\fA\r'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\r'\''|json -b 1'
echo -ne '\f\xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\f\xc2\x80\r'\''|json -b 2'
echo -ne '\f\xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\f\xc2\x80\r'\''|json -b 3'
echo -ne '\f\xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\f\xc2\x80\r'\''|json -b 4'
echo -ne '\f\xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\r'\''|json -b 5'
echo -ne '\f\xc2\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 1'
echo -ne '\f\xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 2'
echo -ne '\f\xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 3'
echo -ne '\f\xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 4'
echo -ne '\f\xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 5'
echo -ne '\f\xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 6'
echo -ne '\f\xe0\xa0\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 7'
echo -ne '\f\xf0\x90\x80\x80\r'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\r'\''|json -b 7'

echo '$ echo -ne '\''\fA\t'\''|json -b 1'
echo -ne '\fA\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\fA\t'\''|json -b 1'

echo '$ echo -ne '\''\fA\t'\''|json -b 2'
echo -ne '\fA\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\fA\t'\''|json -b 2'

echo '$ echo -ne '\''\fA\t'\''|json -b 3'
echo -ne '\fA\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\fA\t'\''|json -b 3'

echo '$ echo -ne '\''\fA\t'\''|json -b 4'
echo -ne '\fA\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\fA\t'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\t'\''|json -b 1'
echo -ne '\f\xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\f\xc2\x80\t'\''|json -b 2'
echo -ne '\f\xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\f\xc2\x80\t'\''|json -b 3'
echo -ne '\f\xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\f\xc2\x80\t'\''|json -b 4'
echo -ne '\f\xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\t'\''|json -b 5'
echo -ne '\f\xc2\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 1'
echo -ne '\f\xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 2'
echo -ne '\f\xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 3'
echo -ne '\f\xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 4'
echo -ne '\f\xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 5'
echo -ne '\f\xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 6'
echo -ne '\f\xe0\xa0\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 7'
echo -ne '\f\xf0\x90\x80\x80\t'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\t'\''|json -b 7'

echo '$ echo -ne '\''\fA\v'\''|json -b 1'
echo -ne '\fA\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\fA\v'\''|json -b 1'

echo '$ echo -ne '\''\fA\v'\''|json -b 2'
echo -ne '\fA\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\fA\v'\''|json -b 2'

echo '$ echo -ne '\''\fA\v'\''|json -b 3'
echo -ne '\fA\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\fA\v'\''|json -b 3'

echo '$ echo -ne '\''\fA\v'\''|json -b 4'
echo -ne '\fA\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\fA\v'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\v'\''|json -b 1'
echo -ne '\f\xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\f\xc2\x80\v'\''|json -b 2'
echo -ne '\f\xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\f\xc2\x80\v'\''|json -b 3'
echo -ne '\f\xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\f\xc2\x80\v'\''|json -b 4'
echo -ne '\f\xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80\v'\''|json -b 5'
echo -ne '\f\xc2\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 1'
echo -ne '\f\xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 2'
echo -ne '\f\xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 3'
echo -ne '\f\xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 4'
echo -ne '\f\xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 5'
echo -ne '\f\xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 6'
echo -ne '\f\xe0\xa0\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 7'
echo -ne '\f\xf0\x90\x80\x80\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80\v'\''|json -b 7'

echo '$ echo -ne '\''\fA '\''|json -b 1'
echo -ne '\fA '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\fA '\''|json -b 1'

echo '$ echo -ne '\''\fA '\''|json -b 2'
echo -ne '\fA '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\fA '\''|json -b 2'

echo '$ echo -ne '\''\fA '\''|json -b 3'
echo -ne '\fA '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\fA '\''|json -b 3'

echo '$ echo -ne '\''\fA '\''|json -b 4'
echo -ne '\fA '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\fA '\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80 '\''|json -b 1'
echo -ne '\f\xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\''\f\xc2\x80 '\''|json -b 2'
echo -ne '\f\xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\''\f\xc2\x80 '\''|json -b 3'
echo -ne '\f\xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\''\f\xc2\x80 '\''|json -b 4'
echo -ne '\f\xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\''\f\xc2\x80 '\''|json -b 5'
echo -ne '\f\xc2\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xc2\x80 '\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 1'
echo -ne '\f\xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 2'
echo -ne '\f\xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 3'
echo -ne '\f\xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 4'
echo -ne '\f\xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 5'
echo -ne '\f\xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 6'
echo -ne '\f\xe0\xa0\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xe0\xa0\x80 '\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 1'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 2'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 3'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 4'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 5'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 6'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 6'

echo '$ echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 7'
echo -ne '\f\xf0\x90\x80\x80 '|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\f\xf0\x90\x80\x80 '\''|json -b 7'

echo '$ echo -ne '\''\nA\f'\''|json -b 1'
echo -ne '\nA\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\nA\f'\''|json -b 1'

echo '$ echo -ne '\''\nA\f'\''|json -b 2'
echo -ne '\nA\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\nA\f'\''|json -b 2'

echo '$ echo -ne '\''\nA\f'\''|json -b 3'
echo -ne '\nA\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\nA\f'\''|json -b 3'

echo '$ echo -ne '\''\nA\f'\''|json -b 4'
echo -ne '\nA\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\nA\f'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\f'\''|json -b 1'
echo -ne '\n\xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\n\xc2\x80\f'\''|json -b 2'
echo -ne '\n\xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\n\xc2\x80\f'\''|json -b 3'
echo -ne '\n\xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\n\xc2\x80\f'\''|json -b 4'
echo -ne '\n\xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\f'\''|json -b 5'
echo -ne '\n\xc2\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 1'
echo -ne '\n\xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 2'
echo -ne '\n\xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 3'
echo -ne '\n\xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 4'
echo -ne '\n\xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 5'
echo -ne '\n\xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 6'
echo -ne '\n\xe0\xa0\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 7'
echo -ne '\n\xf0\x90\x80\x80\f'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\f'\''|json -b 7'

echo '$ echo -ne '\''\nA\n'\''|json -b 1'
echo -ne '\nA\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\nA\n'\''|json -b 1'

echo '$ echo -ne '\''\nA\n'\''|json -b 2'
echo -ne '\nA\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\nA\n'\''|json -b 2'

echo '$ echo -ne '\''\nA\n'\''|json -b 3'
echo -ne '\nA\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\nA\n'\''|json -b 3'

echo '$ echo -ne '\''\nA\n'\''|json -b 4'
echo -ne '\nA\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\nA\n'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\n'\''|json -b 1'
echo -ne '\n\xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\n\xc2\x80\n'\''|json -b 2'
echo -ne '\n\xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\n\xc2\x80\n'\''|json -b 3'
echo -ne '\n\xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\n\xc2\x80\n'\''|json -b 4'
echo -ne '\n\xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\n'\''|json -b 5'
echo -ne '\n\xc2\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 1'
echo -ne '\n\xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 2'
echo -ne '\n\xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 3'
echo -ne '\n\xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 4'
echo -ne '\n\xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 5'
echo -ne '\n\xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 6'
echo -ne '\n\xe0\xa0\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 7'
echo -ne '\n\xf0\x90\x80\x80\n'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\n'\''|json -b 7'

echo '$ echo -ne '\''\nA\r'\''|json -b 1'
echo -ne '\nA\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\nA\r'\''|json -b 1'

echo '$ echo -ne '\''\nA\r'\''|json -b 2'
echo -ne '\nA\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\nA\r'\''|json -b 2'

echo '$ echo -ne '\''\nA\r'\''|json -b 3'
echo -ne '\nA\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\nA\r'\''|json -b 3'

echo '$ echo -ne '\''\nA\r'\''|json -b 4'
echo -ne '\nA\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\nA\r'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\r'\''|json -b 1'
echo -ne '\n\xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\n\xc2\x80\r'\''|json -b 2'
echo -ne '\n\xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\n\xc2\x80\r'\''|json -b 3'
echo -ne '\n\xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\n\xc2\x80\r'\''|json -b 4'
echo -ne '\n\xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\r'\''|json -b 5'
echo -ne '\n\xc2\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 1'
echo -ne '\n\xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 2'
echo -ne '\n\xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 3'
echo -ne '\n\xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 4'
echo -ne '\n\xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 5'
echo -ne '\n\xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 6'
echo -ne '\n\xe0\xa0\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 7'
echo -ne '\n\xf0\x90\x80\x80\r'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\r'\''|json -b 7'

echo '$ echo -ne '\''\nA\t'\''|json -b 1'
echo -ne '\nA\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\nA\t'\''|json -b 1'

echo '$ echo -ne '\''\nA\t'\''|json -b 2'
echo -ne '\nA\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\nA\t'\''|json -b 2'

echo '$ echo -ne '\''\nA\t'\''|json -b 3'
echo -ne '\nA\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\nA\t'\''|json -b 3'

echo '$ echo -ne '\''\nA\t'\''|json -b 4'
echo -ne '\nA\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\nA\t'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\t'\''|json -b 1'
echo -ne '\n\xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\n\xc2\x80\t'\''|json -b 2'
echo -ne '\n\xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\n\xc2\x80\t'\''|json -b 3'
echo -ne '\n\xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\n\xc2\x80\t'\''|json -b 4'
echo -ne '\n\xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\t'\''|json -b 5'
echo -ne '\n\xc2\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 1'
echo -ne '\n\xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 2'
echo -ne '\n\xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 3'
echo -ne '\n\xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 4'
echo -ne '\n\xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 5'
echo -ne '\n\xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 6'
echo -ne '\n\xe0\xa0\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 7'
echo -ne '\n\xf0\x90\x80\x80\t'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\t'\''|json -b 7'

echo '$ echo -ne '\''\nA\v'\''|json -b 1'
echo -ne '\nA\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\nA\v'\''|json -b 1'

echo '$ echo -ne '\''\nA\v'\''|json -b 2'
echo -ne '\nA\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\nA\v'\''|json -b 2'

echo '$ echo -ne '\''\nA\v'\''|json -b 3'
echo -ne '\nA\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\nA\v'\''|json -b 3'

echo '$ echo -ne '\''\nA\v'\''|json -b 4'
echo -ne '\nA\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\nA\v'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\v'\''|json -b 1'
echo -ne '\n\xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\n\xc2\x80\v'\''|json -b 2'
echo -ne '\n\xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\n\xc2\x80\v'\''|json -b 3'
echo -ne '\n\xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\n\xc2\x80\v'\''|json -b 4'
echo -ne '\n\xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80\v'\''|json -b 5'
echo -ne '\n\xc2\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 1'
echo -ne '\n\xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 2'
echo -ne '\n\xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 3'
echo -ne '\n\xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 4'
echo -ne '\n\xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 5'
echo -ne '\n\xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 6'
echo -ne '\n\xe0\xa0\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 7'
echo -ne '\n\xf0\x90\x80\x80\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80\v'\''|json -b 7'

echo '$ echo -ne '\''\nA '\''|json -b 1'
echo -ne '\nA '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\nA '\''|json -b 1'

echo '$ echo -ne '\''\nA '\''|json -b 2'
echo -ne '\nA '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\nA '\''|json -b 2'

echo '$ echo -ne '\''\nA '\''|json -b 3'
echo -ne '\nA '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\nA '\''|json -b 3'

echo '$ echo -ne '\''\nA '\''|json -b 4'
echo -ne '\nA '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\nA '\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80 '\''|json -b 1'
echo -ne '\n\xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\''\n\xc2\x80 '\''|json -b 2'
echo -ne '\n\xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\''\n\xc2\x80 '\''|json -b 3'
echo -ne '\n\xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\''\n\xc2\x80 '\''|json -b 4'
echo -ne '\n\xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\''\n\xc2\x80 '\''|json -b 5'
echo -ne '\n\xc2\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xc2\x80 '\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 1'
echo -ne '\n\xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 2'
echo -ne '\n\xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 3'
echo -ne '\n\xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 4'
echo -ne '\n\xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 5'
echo -ne '\n\xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 6'
echo -ne '\n\xe0\xa0\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xe0\xa0\x80 '\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 1'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 2'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 3'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 4'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 5'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 6'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 6'

echo '$ echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 7'
echo -ne '\n\xf0\x90\x80\x80 '|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\n\xf0\x90\x80\x80 '\''|json -b 7'

echo '$ echo -ne '\''\rA\f'\''|json -b 1'
echo -ne '\rA\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\rA\f'\''|json -b 1'

echo '$ echo -ne '\''\rA\f'\''|json -b 2'
echo -ne '\rA\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\rA\f'\''|json -b 2'

echo '$ echo -ne '\''\rA\f'\''|json -b 3'
echo -ne '\rA\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\rA\f'\''|json -b 3'

echo '$ echo -ne '\''\rA\f'\''|json -b 4'
echo -ne '\rA\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\rA\f'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\f'\''|json -b 1'
echo -ne '\r\xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\r\xc2\x80\f'\''|json -b 2'
echo -ne '\r\xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\r\xc2\x80\f'\''|json -b 3'
echo -ne '\r\xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\r\xc2\x80\f'\''|json -b 4'
echo -ne '\r\xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\f'\''|json -b 5'
echo -ne '\r\xc2\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 1'
echo -ne '\r\xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 2'
echo -ne '\r\xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 3'
echo -ne '\r\xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 4'
echo -ne '\r\xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 5'
echo -ne '\r\xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 6'
echo -ne '\r\xe0\xa0\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 7'
echo -ne '\r\xf0\x90\x80\x80\f'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\f'\''|json -b 7'

echo '$ echo -ne '\''\rA\n'\''|json -b 1'
echo -ne '\rA\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\rA\n'\''|json -b 1'

echo '$ echo -ne '\''\rA\n'\''|json -b 2'
echo -ne '\rA\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\rA\n'\''|json -b 2'

echo '$ echo -ne '\''\rA\n'\''|json -b 3'
echo -ne '\rA\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\rA\n'\''|json -b 3'

echo '$ echo -ne '\''\rA\n'\''|json -b 4'
echo -ne '\rA\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\rA\n'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\n'\''|json -b 1'
echo -ne '\r\xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\r\xc2\x80\n'\''|json -b 2'
echo -ne '\r\xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\r\xc2\x80\n'\''|json -b 3'
echo -ne '\r\xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\r\xc2\x80\n'\''|json -b 4'
echo -ne '\r\xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\n'\''|json -b 5'
echo -ne '\r\xc2\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 1'
echo -ne '\r\xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 2'
echo -ne '\r\xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 3'
echo -ne '\r\xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 4'
echo -ne '\r\xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 5'
echo -ne '\r\xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 6'
echo -ne '\r\xe0\xa0\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 7'
echo -ne '\r\xf0\x90\x80\x80\n'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\n'\''|json -b 7'

echo '$ echo -ne '\''\rA\r'\''|json -b 1'
echo -ne '\rA\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\rA\r'\''|json -b 1'

echo '$ echo -ne '\''\rA\r'\''|json -b 2'
echo -ne '\rA\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\rA\r'\''|json -b 2'

echo '$ echo -ne '\''\rA\r'\''|json -b 3'
echo -ne '\rA\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\rA\r'\''|json -b 3'

echo '$ echo -ne '\''\rA\r'\''|json -b 4'
echo -ne '\rA\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\rA\r'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\r'\''|json -b 1'
echo -ne '\r\xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\r\xc2\x80\r'\''|json -b 2'
echo -ne '\r\xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\r\xc2\x80\r'\''|json -b 3'
echo -ne '\r\xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\r\xc2\x80\r'\''|json -b 4'
echo -ne '\r\xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\r'\''|json -b 5'
echo -ne '\r\xc2\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 1'
echo -ne '\r\xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 2'
echo -ne '\r\xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 3'
echo -ne '\r\xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 4'
echo -ne '\r\xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 5'
echo -ne '\r\xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 6'
echo -ne '\r\xe0\xa0\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 7'
echo -ne '\r\xf0\x90\x80\x80\r'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\r'\''|json -b 7'

echo '$ echo -ne '\''\rA\t'\''|json -b 1'
echo -ne '\rA\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\rA\t'\''|json -b 1'

echo '$ echo -ne '\''\rA\t'\''|json -b 2'
echo -ne '\rA\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\rA\t'\''|json -b 2'

echo '$ echo -ne '\''\rA\t'\''|json -b 3'
echo -ne '\rA\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\rA\t'\''|json -b 3'

echo '$ echo -ne '\''\rA\t'\''|json -b 4'
echo -ne '\rA\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\rA\t'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\t'\''|json -b 1'
echo -ne '\r\xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\r\xc2\x80\t'\''|json -b 2'
echo -ne '\r\xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\r\xc2\x80\t'\''|json -b 3'
echo -ne '\r\xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\r\xc2\x80\t'\''|json -b 4'
echo -ne '\r\xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\t'\''|json -b 5'
echo -ne '\r\xc2\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 1'
echo -ne '\r\xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 2'
echo -ne '\r\xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 3'
echo -ne '\r\xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 4'
echo -ne '\r\xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 5'
echo -ne '\r\xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 6'
echo -ne '\r\xe0\xa0\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 7'
echo -ne '\r\xf0\x90\x80\x80\t'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\t'\''|json -b 7'

echo '$ echo -ne '\''\rA\v'\''|json -b 1'
echo -ne '\rA\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\rA\v'\''|json -b 1'

echo '$ echo -ne '\''\rA\v'\''|json -b 2'
echo -ne '\rA\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\rA\v'\''|json -b 2'

echo '$ echo -ne '\''\rA\v'\''|json -b 3'
echo -ne '\rA\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\rA\v'\''|json -b 3'

echo '$ echo -ne '\''\rA\v'\''|json -b 4'
echo -ne '\rA\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\rA\v'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\v'\''|json -b 1'
echo -ne '\r\xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\r\xc2\x80\v'\''|json -b 2'
echo -ne '\r\xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\r\xc2\x80\v'\''|json -b 3'
echo -ne '\r\xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\r\xc2\x80\v'\''|json -b 4'
echo -ne '\r\xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80\v'\''|json -b 5'
echo -ne '\r\xc2\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 1'
echo -ne '\r\xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 2'
echo -ne '\r\xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 3'
echo -ne '\r\xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 4'
echo -ne '\r\xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 5'
echo -ne '\r\xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 6'
echo -ne '\r\xe0\xa0\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 7'
echo -ne '\r\xf0\x90\x80\x80\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80\v'\''|json -b 7'

echo '$ echo -ne '\''\rA '\''|json -b 1'
echo -ne '\rA '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\rA '\''|json -b 1'

echo '$ echo -ne '\''\rA '\''|json -b 2'
echo -ne '\rA '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\rA '\''|json -b 2'

echo '$ echo -ne '\''\rA '\''|json -b 3'
echo -ne '\rA '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\rA '\''|json -b 3'

echo '$ echo -ne '\''\rA '\''|json -b 4'
echo -ne '\rA '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\rA '\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80 '\''|json -b 1'
echo -ne '\r\xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\''\r\xc2\x80 '\''|json -b 2'
echo -ne '\r\xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\''\r\xc2\x80 '\''|json -b 3'
echo -ne '\r\xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\''\r\xc2\x80 '\''|json -b 4'
echo -ne '\r\xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\''\r\xc2\x80 '\''|json -b 5'
echo -ne '\r\xc2\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xc2\x80 '\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 1'
echo -ne '\r\xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 2'
echo -ne '\r\xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 3'
echo -ne '\r\xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 4'
echo -ne '\r\xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 5'
echo -ne '\r\xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 6'
echo -ne '\r\xe0\xa0\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xe0\xa0\x80 '\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 1'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 2'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 3'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 4'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 5'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 6'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 6'

echo '$ echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 7'
echo -ne '\r\xf0\x90\x80\x80 '|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\r\xf0\x90\x80\x80 '\''|json -b 7'

echo '$ echo -ne '\''\tA\f'\''|json -b 1'
echo -ne '\tA\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\tA\f'\''|json -b 1'

echo '$ echo -ne '\''\tA\f'\''|json -b 2'
echo -ne '\tA\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\tA\f'\''|json -b 2'

echo '$ echo -ne '\''\tA\f'\''|json -b 3'
echo -ne '\tA\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\tA\f'\''|json -b 3'

echo '$ echo -ne '\''\tA\f'\''|json -b 4'
echo -ne '\tA\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\tA\f'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\f'\''|json -b 1'
echo -ne '\t\xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\t\xc2\x80\f'\''|json -b 2'
echo -ne '\t\xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\t\xc2\x80\f'\''|json -b 3'
echo -ne '\t\xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\t\xc2\x80\f'\''|json -b 4'
echo -ne '\t\xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\f'\''|json -b 5'
echo -ne '\t\xc2\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 1'
echo -ne '\t\xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 2'
echo -ne '\t\xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 3'
echo -ne '\t\xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 4'
echo -ne '\t\xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 5'
echo -ne '\t\xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 6'
echo -ne '\t\xe0\xa0\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 7'
echo -ne '\t\xf0\x90\x80\x80\f'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\f'\''|json -b 7'

echo '$ echo -ne '\''\tA\n'\''|json -b 1'
echo -ne '\tA\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\tA\n'\''|json -b 1'

echo '$ echo -ne '\''\tA\n'\''|json -b 2'
echo -ne '\tA\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\tA\n'\''|json -b 2'

echo '$ echo -ne '\''\tA\n'\''|json -b 3'
echo -ne '\tA\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\tA\n'\''|json -b 3'

echo '$ echo -ne '\''\tA\n'\''|json -b 4'
echo -ne '\tA\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\tA\n'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\n'\''|json -b 1'
echo -ne '\t\xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\t\xc2\x80\n'\''|json -b 2'
echo -ne '\t\xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\t\xc2\x80\n'\''|json -b 3'
echo -ne '\t\xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\t\xc2\x80\n'\''|json -b 4'
echo -ne '\t\xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\n'\''|json -b 5'
echo -ne '\t\xc2\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 1'
echo -ne '\t\xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 2'
echo -ne '\t\xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 3'
echo -ne '\t\xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 4'
echo -ne '\t\xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 5'
echo -ne '\t\xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 6'
echo -ne '\t\xe0\xa0\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 7'
echo -ne '\t\xf0\x90\x80\x80\n'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\n'\''|json -b 7'

echo '$ echo -ne '\''\tA\r'\''|json -b 1'
echo -ne '\tA\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\tA\r'\''|json -b 1'

echo '$ echo -ne '\''\tA\r'\''|json -b 2'
echo -ne '\tA\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\tA\r'\''|json -b 2'

echo '$ echo -ne '\''\tA\r'\''|json -b 3'
echo -ne '\tA\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\tA\r'\''|json -b 3'

echo '$ echo -ne '\''\tA\r'\''|json -b 4'
echo -ne '\tA\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\tA\r'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\r'\''|json -b 1'
echo -ne '\t\xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\t\xc2\x80\r'\''|json -b 2'
echo -ne '\t\xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\t\xc2\x80\r'\''|json -b 3'
echo -ne '\t\xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\t\xc2\x80\r'\''|json -b 4'
echo -ne '\t\xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\r'\''|json -b 5'
echo -ne '\t\xc2\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 1'
echo -ne '\t\xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 2'
echo -ne '\t\xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 3'
echo -ne '\t\xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 4'
echo -ne '\t\xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 5'
echo -ne '\t\xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 6'
echo -ne '\t\xe0\xa0\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 7'
echo -ne '\t\xf0\x90\x80\x80\r'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\r'\''|json -b 7'

echo '$ echo -ne '\''\tA\t'\''|json -b 1'
echo -ne '\tA\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\tA\t'\''|json -b 1'

echo '$ echo -ne '\''\tA\t'\''|json -b 2'
echo -ne '\tA\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\tA\t'\''|json -b 2'

echo '$ echo -ne '\''\tA\t'\''|json -b 3'
echo -ne '\tA\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\tA\t'\''|json -b 3'

echo '$ echo -ne '\''\tA\t'\''|json -b 4'
echo -ne '\tA\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\tA\t'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\t'\''|json -b 1'
echo -ne '\t\xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\t\xc2\x80\t'\''|json -b 2'
echo -ne '\t\xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\t\xc2\x80\t'\''|json -b 3'
echo -ne '\t\xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\t\xc2\x80\t'\''|json -b 4'
echo -ne '\t\xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\t'\''|json -b 5'
echo -ne '\t\xc2\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 1'
echo -ne '\t\xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 2'
echo -ne '\t\xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 3'
echo -ne '\t\xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 4'
echo -ne '\t\xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 5'
echo -ne '\t\xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 6'
echo -ne '\t\xe0\xa0\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 7'
echo -ne '\t\xf0\x90\x80\x80\t'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\t'\''|json -b 7'

echo '$ echo -ne '\''\tA\v'\''|json -b 1'
echo -ne '\tA\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\tA\v'\''|json -b 1'

echo '$ echo -ne '\''\tA\v'\''|json -b 2'
echo -ne '\tA\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\tA\v'\''|json -b 2'

echo '$ echo -ne '\''\tA\v'\''|json -b 3'
echo -ne '\tA\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\tA\v'\''|json -b 3'

echo '$ echo -ne '\''\tA\v'\''|json -b 4'
echo -ne '\tA\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\tA\v'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\v'\''|json -b 1'
echo -ne '\t\xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\t\xc2\x80\v'\''|json -b 2'
echo -ne '\t\xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\t\xc2\x80\v'\''|json -b 3'
echo -ne '\t\xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\t\xc2\x80\v'\''|json -b 4'
echo -ne '\t\xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80\v'\''|json -b 5'
echo -ne '\t\xc2\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 1'
echo -ne '\t\xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 2'
echo -ne '\t\xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 3'
echo -ne '\t\xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 4'
echo -ne '\t\xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 5'
echo -ne '\t\xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 6'
echo -ne '\t\xe0\xa0\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 7'
echo -ne '\t\xf0\x90\x80\x80\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80\v'\''|json -b 7'

echo '$ echo -ne '\''\tA '\''|json -b 1'
echo -ne '\tA '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\tA '\''|json -b 1'

echo '$ echo -ne '\''\tA '\''|json -b 2'
echo -ne '\tA '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\tA '\''|json -b 2'

echo '$ echo -ne '\''\tA '\''|json -b 3'
echo -ne '\tA '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\tA '\''|json -b 3'

echo '$ echo -ne '\''\tA '\''|json -b 4'
echo -ne '\tA '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\tA '\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80 '\''|json -b 1'
echo -ne '\t\xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\''\t\xc2\x80 '\''|json -b 2'
echo -ne '\t\xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\''\t\xc2\x80 '\''|json -b 3'
echo -ne '\t\xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\''\t\xc2\x80 '\''|json -b 4'
echo -ne '\t\xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\''\t\xc2\x80 '\''|json -b 5'
echo -ne '\t\xc2\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xc2\x80 '\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 1'
echo -ne '\t\xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 2'
echo -ne '\t\xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 3'
echo -ne '\t\xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 4'
echo -ne '\t\xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 5'
echo -ne '\t\xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 6'
echo -ne '\t\xe0\xa0\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xe0\xa0\x80 '\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 1'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 2'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 3'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 4'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 5'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 6'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 6'

echo '$ echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 7'
echo -ne '\t\xf0\x90\x80\x80 '|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\xf0\x90\x80\x80 '\''|json -b 7'

echo '$ echo -ne '\''\vA\f'\''|json -b 1'
echo -ne '\vA\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\vA\f'\''|json -b 1'

echo '$ echo -ne '\''\vA\f'\''|json -b 2'
echo -ne '\vA\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\vA\f'\''|json -b 2'

echo '$ echo -ne '\''\vA\f'\''|json -b 3'
echo -ne '\vA\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\vA\f'\''|json -b 3'

echo '$ echo -ne '\''\vA\f'\''|json -b 4'
echo -ne '\vA\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\vA\f'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\f'\''|json -b 1'
echo -ne '\v\xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\v\xc2\x80\f'\''|json -b 2'
echo -ne '\v\xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\v\xc2\x80\f'\''|json -b 3'
echo -ne '\v\xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\v\xc2\x80\f'\''|json -b 4'
echo -ne '\v\xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\f'\''|json -b 5'
echo -ne '\v\xc2\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 1'
echo -ne '\v\xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 2'
echo -ne '\v\xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 3'
echo -ne '\v\xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 4'
echo -ne '\v\xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 5'
echo -ne '\v\xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 6'
echo -ne '\v\xe0\xa0\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 7'
echo -ne '\v\xf0\x90\x80\x80\f'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\f'\''|json -b 7'

echo '$ echo -ne '\''\vA\n'\''|json -b 1'
echo -ne '\vA\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\vA\n'\''|json -b 1'

echo '$ echo -ne '\''\vA\n'\''|json -b 2'
echo -ne '\vA\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\vA\n'\''|json -b 2'

echo '$ echo -ne '\''\vA\n'\''|json -b 3'
echo -ne '\vA\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\vA\n'\''|json -b 3'

echo '$ echo -ne '\''\vA\n'\''|json -b 4'
echo -ne '\vA\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\vA\n'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\n'\''|json -b 1'
echo -ne '\v\xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\v\xc2\x80\n'\''|json -b 2'
echo -ne '\v\xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\v\xc2\x80\n'\''|json -b 3'
echo -ne '\v\xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\v\xc2\x80\n'\''|json -b 4'
echo -ne '\v\xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\n'\''|json -b 5'
echo -ne '\v\xc2\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 1'
echo -ne '\v\xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 2'
echo -ne '\v\xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 3'
echo -ne '\v\xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 4'
echo -ne '\v\xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 5'
echo -ne '\v\xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 6'
echo -ne '\v\xe0\xa0\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 7'
echo -ne '\v\xf0\x90\x80\x80\n'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\n'\''|json -b 7'

echo '$ echo -ne '\''\vA\r'\''|json -b 1'
echo -ne '\vA\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\vA\r'\''|json -b 1'

echo '$ echo -ne '\''\vA\r'\''|json -b 2'
echo -ne '\vA\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\vA\r'\''|json -b 2'

echo '$ echo -ne '\''\vA\r'\''|json -b 3'
echo -ne '\vA\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\vA\r'\''|json -b 3'

echo '$ echo -ne '\''\vA\r'\''|json -b 4'
echo -ne '\vA\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\vA\r'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\r'\''|json -b 1'
echo -ne '\v\xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\v\xc2\x80\r'\''|json -b 2'
echo -ne '\v\xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\v\xc2\x80\r'\''|json -b 3'
echo -ne '\v\xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\v\xc2\x80\r'\''|json -b 4'
echo -ne '\v\xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\r'\''|json -b 5'
echo -ne '\v\xc2\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 1'
echo -ne '\v\xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 2'
echo -ne '\v\xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 3'
echo -ne '\v\xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 4'
echo -ne '\v\xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 5'
echo -ne '\v\xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 6'
echo -ne '\v\xe0\xa0\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 7'
echo -ne '\v\xf0\x90\x80\x80\r'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\r'\''|json -b 7'

echo '$ echo -ne '\''\vA\t'\''|json -b 1'
echo -ne '\vA\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\vA\t'\''|json -b 1'

echo '$ echo -ne '\''\vA\t'\''|json -b 2'
echo -ne '\vA\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\vA\t'\''|json -b 2'

echo '$ echo -ne '\''\vA\t'\''|json -b 3'
echo -ne '\vA\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\vA\t'\''|json -b 3'

echo '$ echo -ne '\''\vA\t'\''|json -b 4'
echo -ne '\vA\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\vA\t'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\t'\''|json -b 1'
echo -ne '\v\xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\v\xc2\x80\t'\''|json -b 2'
echo -ne '\v\xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\v\xc2\x80\t'\''|json -b 3'
echo -ne '\v\xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\v\xc2\x80\t'\''|json -b 4'
echo -ne '\v\xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\t'\''|json -b 5'
echo -ne '\v\xc2\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 1'
echo -ne '\v\xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 2'
echo -ne '\v\xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 3'
echo -ne '\v\xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 4'
echo -ne '\v\xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 5'
echo -ne '\v\xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 6'
echo -ne '\v\xe0\xa0\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 7'
echo -ne '\v\xf0\x90\x80\x80\t'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\t'\''|json -b 7'

echo '$ echo -ne '\''\vA\v'\''|json -b 1'
echo -ne '\vA\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\vA\v'\''|json -b 1'

echo '$ echo -ne '\''\vA\v'\''|json -b 2'
echo -ne '\vA\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\vA\v'\''|json -b 2'

echo '$ echo -ne '\''\vA\v'\''|json -b 3'
echo -ne '\vA\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\vA\v'\''|json -b 3'

echo '$ echo -ne '\''\vA\v'\''|json -b 4'
echo -ne '\vA\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\vA\v'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\v'\''|json -b 1'
echo -ne '\v\xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\v\xc2\x80\v'\''|json -b 2'
echo -ne '\v\xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\v\xc2\x80\v'\''|json -b 3'
echo -ne '\v\xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\v\xc2\x80\v'\''|json -b 4'
echo -ne '\v\xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80\v'\''|json -b 5'
echo -ne '\v\xc2\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 1'
echo -ne '\v\xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 2'
echo -ne '\v\xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 3'
echo -ne '\v\xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 4'
echo -ne '\v\xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 5'
echo -ne '\v\xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 6'
echo -ne '\v\xe0\xa0\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 7'
echo -ne '\v\xf0\x90\x80\x80\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80\v'\''|json -b 7'

echo '$ echo -ne '\''\vA '\''|json -b 1'
echo -ne '\vA '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\vA '\''|json -b 1'

echo '$ echo -ne '\''\vA '\''|json -b 2'
echo -ne '\vA '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\vA '\''|json -b 2'

echo '$ echo -ne '\''\vA '\''|json -b 3'
echo -ne '\vA '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\vA '\''|json -b 3'

echo '$ echo -ne '\''\vA '\''|json -b 4'
echo -ne '\vA '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\vA '\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80 '\''|json -b 1'
echo -ne '\v\xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\''\v\xc2\x80 '\''|json -b 2'
echo -ne '\v\xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\''\v\xc2\x80 '\''|json -b 3'
echo -ne '\v\xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\''\v\xc2\x80 '\''|json -b 4'
echo -ne '\v\xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\''\v\xc2\x80 '\''|json -b 5'
echo -ne '\v\xc2\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xc2\x80 '\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 1'
echo -ne '\v\xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 2'
echo -ne '\v\xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 3'
echo -ne '\v\xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 4'
echo -ne '\v\xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 5'
echo -ne '\v\xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 6'
echo -ne '\v\xe0\xa0\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xe0\xa0\x80 '\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 1'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 2'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 3'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 4'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 5'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 6'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 6'

echo '$ echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 7'
echo -ne '\v\xf0\x90\x80\x80 '|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\v\xf0\x90\x80\x80 '\''|json -b 7'

echo '$ echo -ne '\'' A\f'\''|json -b 1'
echo -ne ' A\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' A\f'\''|json -b 1'

echo '$ echo -ne '\'' A\f'\''|json -b 2'
echo -ne ' A\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' A\f'\''|json -b 2'

echo '$ echo -ne '\'' A\f'\''|json -b 3'
echo -ne ' A\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' A\f'\''|json -b 3'

echo '$ echo -ne '\'' A\f'\''|json -b 4'
echo -ne ' A\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' A\f'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\f'\''|json -b 1'
echo -ne ' \xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\'' \xc2\x80\f'\''|json -b 2'
echo -ne ' \xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\'' \xc2\x80\f'\''|json -b 3'
echo -ne ' \xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\'' \xc2\x80\f'\''|json -b 4'
echo -ne ' \xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\f'\''|json -b 5'
echo -ne ' \xc2\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\f'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 1'
echo -ne ' \xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 2'
echo -ne ' \xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 3'
echo -ne ' \xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 4'
echo -ne ' \xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 5'
echo -ne ' \xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 6'
echo -ne ' \xe0\xa0\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\f'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 7'
echo -ne ' \xf0\x90\x80\x80\f'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\f'\''|json -b 7'

echo '$ echo -ne '\'' A\n'\''|json -b 1'
echo -ne ' A\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' A\n'\''|json -b 1'

echo '$ echo -ne '\'' A\n'\''|json -b 2'
echo -ne ' A\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' A\n'\''|json -b 2'

echo '$ echo -ne '\'' A\n'\''|json -b 3'
echo -ne ' A\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' A\n'\''|json -b 3'

echo '$ echo -ne '\'' A\n'\''|json -b 4'
echo -ne ' A\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' A\n'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\n'\''|json -b 1'
echo -ne ' \xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\'' \xc2\x80\n'\''|json -b 2'
echo -ne ' \xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\'' \xc2\x80\n'\''|json -b 3'
echo -ne ' \xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\'' \xc2\x80\n'\''|json -b 4'
echo -ne ' \xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\n'\''|json -b 5'
echo -ne ' \xc2\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\n'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 1'
echo -ne ' \xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 2'
echo -ne ' \xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 3'
echo -ne ' \xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 4'
echo -ne ' \xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 5'
echo -ne ' \xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 6'
echo -ne ' \xe0\xa0\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\n'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 7'
echo -ne ' \xf0\x90\x80\x80\n'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\n'\''|json -b 7'

echo '$ echo -ne '\'' A\r'\''|json -b 1'
echo -ne ' A\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' A\r'\''|json -b 1'

echo '$ echo -ne '\'' A\r'\''|json -b 2'
echo -ne ' A\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' A\r'\''|json -b 2'

echo '$ echo -ne '\'' A\r'\''|json -b 3'
echo -ne ' A\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' A\r'\''|json -b 3'

echo '$ echo -ne '\'' A\r'\''|json -b 4'
echo -ne ' A\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' A\r'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\r'\''|json -b 1'
echo -ne ' \xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\'' \xc2\x80\r'\''|json -b 2'
echo -ne ' \xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\'' \xc2\x80\r'\''|json -b 3'
echo -ne ' \xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\'' \xc2\x80\r'\''|json -b 4'
echo -ne ' \xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\r'\''|json -b 5'
echo -ne ' \xc2\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\r'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 1'
echo -ne ' \xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 2'
echo -ne ' \xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 3'
echo -ne ' \xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 4'
echo -ne ' \xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 5'
echo -ne ' \xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 6'
echo -ne ' \xe0\xa0\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\r'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 7'
echo -ne ' \xf0\x90\x80\x80\r'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\r'\''|json -b 7'

echo '$ echo -ne '\'' A\t'\''|json -b 1'
echo -ne ' A\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' A\t'\''|json -b 1'

echo '$ echo -ne '\'' A\t'\''|json -b 2'
echo -ne ' A\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' A\t'\''|json -b 2'

echo '$ echo -ne '\'' A\t'\''|json -b 3'
echo -ne ' A\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' A\t'\''|json -b 3'

echo '$ echo -ne '\'' A\t'\''|json -b 4'
echo -ne ' A\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' A\t'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\t'\''|json -b 1'
echo -ne ' \xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\'' \xc2\x80\t'\''|json -b 2'
echo -ne ' \xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\'' \xc2\x80\t'\''|json -b 3'
echo -ne ' \xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\'' \xc2\x80\t'\''|json -b 4'
echo -ne ' \xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\t'\''|json -b 5'
echo -ne ' \xc2\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\t'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 1'
echo -ne ' \xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 2'
echo -ne ' \xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 3'
echo -ne ' \xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 4'
echo -ne ' \xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 5'
echo -ne ' \xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 6'
echo -ne ' \xe0\xa0\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\t'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 7'
echo -ne ' \xf0\x90\x80\x80\t'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\t'\''|json -b 7'

echo '$ echo -ne '\'' A\v'\''|json -b 1'
echo -ne ' A\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' A\v'\''|json -b 1'

echo '$ echo -ne '\'' A\v'\''|json -b 2'
echo -ne ' A\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' A\v'\''|json -b 2'

echo '$ echo -ne '\'' A\v'\''|json -b 3'
echo -ne ' A\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' A\v'\''|json -b 3'

echo '$ echo -ne '\'' A\v'\''|json -b 4'
echo -ne ' A\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' A\v'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\v'\''|json -b 1'
echo -ne ' \xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\'' \xc2\x80\v'\''|json -b 2'
echo -ne ' \xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\'' \xc2\x80\v'\''|json -b 3'
echo -ne ' \xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\'' \xc2\x80\v'\''|json -b 4'
echo -ne ' \xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80\v'\''|json -b 5'
echo -ne ' \xc2\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80\v'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 1'
echo -ne ' \xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 2'
echo -ne ' \xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 3'
echo -ne ' \xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 4'
echo -ne ' \xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 5'
echo -ne ' \xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 6'
echo -ne ' \xe0\xa0\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80\v'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 7'
echo -ne ' \xf0\x90\x80\x80\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80\v'\''|json -b 7'

echo '$ echo -ne '\'' A '\''|json -b 1'
echo -ne ' A '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' A '\''|json -b 1'

echo '$ echo -ne '\'' A '\''|json -b 2'
echo -ne ' A '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' A '\''|json -b 2'

echo '$ echo -ne '\'' A '\''|json -b 3'
echo -ne ' A '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' A '\''|json -b 3'

echo '$ echo -ne '\'' A '\''|json -b 4'
echo -ne ' A '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' A '\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80 '\''|json -b 1'
echo -ne ' \xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\'' \xc2\x80 '\''|json -b 2'
echo -ne ' \xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\'' \xc2\x80 '\''|json -b 3'
echo -ne ' \xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\'' \xc2\x80 '\''|json -b 4'
echo -ne ' \xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\'' \xc2\x80 '\''|json -b 5'
echo -ne ' \xc2\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xc2\x80 '\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 1'
echo -ne ' \xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 2'
echo -ne ' \xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 3'
echo -ne ' \xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 4'
echo -ne ' \xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 5'
echo -ne ' \xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\'' \xe0\xa0\x80 '\''|json -b 6'
echo -ne ' \xe0\xa0\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xe0\xa0\x80 '\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 1'
echo -ne ' \xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 2'
echo -ne ' \xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 3'
echo -ne ' \xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 4'
echo -ne ' \xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 5'
echo -ne ' \xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 6'
echo -ne ' \xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 6'

echo '$ echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 7'
echo -ne ' \xf0\x90\x80\x80 '|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\'' \xf0\x90\x80\x80 '\''|json -b 7'
)

