#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-expr-attr
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr-attr.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -P --no-error; }
$ json '\''0'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "0",
        "nodes": [
            {
                "num": 0
            }
        ],
        "size": 1
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "000"
            }
        ],
        "size": 1
    }
}
$ json '\''1'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "1",
        "nodes": [
            {
                "num": 1
            }
        ],
        "size": 1
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "111"
            }
        ],
        "size": 1
    }
}
$ json '\''a'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "a",
        "nodes": [
            {
                "key": "a"
            }
        ],
        "size": 1
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "100"
            }
        ],
        "size": 1
    }
}
$ json '\''~a'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "~a",
        "nodes": [
            {
                "key": "a"
            },
            {
                "op": "not"
            }
        ],
        "size": 2
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "011"
            }
        ],
        "size": 1
    }
}
$ json '\''a|b'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "a|b",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "or"
            }
        ],
        "size": 3
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "110"
            }
        ],
        "size": 1
    }
}
$ json '\''~(a|b)'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "~(a|b)",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "or"
            },
            {
                "op": "not"
            }
        ],
        "size": 4
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "001"
            }
        ],
        "size": 1
    }
}
$ json '\''a b'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "a b",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "and"
            }
        ],
        "size": 3
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "000"
            }
        ],
        "size": 1
    }
}
$ json '\''~(a b)'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "~(a b)",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "and"
            },
            {
                "op": "not"
            }
        ],
        "size": 4
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "111"
            }
        ],
        "size": 1
    }
}
$ json '\''~a|~b'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "~a|~b",
        "nodes": [
            {
                "key": "a"
            },
            {
                "op": "not"
            },
            {
                "key": "b"
            },
            {
                "op": "not"
            },
            {
                "op": "or"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "111"
            }
        ],
        "size": 1
    }
}
$ json '\''~a~b'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "~a~b",
        "nodes": [
            {
                "key": "a"
            },
            {
                "op": "not"
            },
            {
                "key": "b"
            },
            {
                "op": "not"
            },
            {
                "op": "and"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "001"
            }
        ],
        "size": 1
    }
}
$ json '\''(a b)|c'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "(a b)|c",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "and"
            },
            {
                "key": "c"
            },
            {
                "op": "or"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "001"
            }
        ],
        "size": 1
    }
}
$ json '\''a(b|c)'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "a(b|c)",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "key": "c"
            },
            {
                "op": "or"
            },
            {
                "op": "and"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "000"
            }
        ],
        "size": 1
    }
}
$ json '\''(a|b)c'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "(a|b)c",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "or"
            },
            {
                "key": "c"
            },
            {
                "op": "and"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "000"
            }
        ],
        "size": 1
    }
}
$ json '\''a|(b c)'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "a|(b c)",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "key": "c"
            },
            {
                "op": "and"
            },
            {
                "op": "or"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "100"
            }
        ],
        "size": 1
    }
}
$ json '\''a||b||c'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "a||b||c",
        "nodes": [
            {
                "key": "a"
            },
            {
                "key": "b"
            },
            {
                "op": "alt"
            },
            {
                "key": "c"
            },
            {
                "op": "alt"
            }
        ],
        "size": 5
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "100"
            },
            {
                "size": 3,
                "bits": "010"
            },
            {
                "size": 3,
                "bits": "001"
            }
        ],
        "size": 3
    }
}
$ json '\''~a||~b||~c'\''
{
    "type": "dict",
    "args": [
        {
            "name": "a",
            "type": "number"
        },
        {
            "name": "b",
            "type": "number"
        },
        {
            "name": "c",
            "type": "number"
        }
    ],
    "expr": {
        "text": "~a||~b||~c",
        "nodes": [
            {
                "key": "a"
            },
            {
                "op": "not"
            },
            {
                "key": "b"
            },
            {
                "op": "not"
            },
            {
                "op": "alt"
            },
            {
                "key": "c"
            },
            {
                "op": "not"
            },
            {
                "op": "alt"
            }
        ],
        "size": 8
    },
    "attr": {
        "args": {
            "sym": "a",
            "lo": null,
            "eq": {
                "val": 0,
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "b",
                "lo": null,
                "eq": {
                    "val": 1,
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "c",
                    "lo": null,
                    "eq": {
                        "val": 2,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        },
        "expr": [
            {
                "size": 3,
                "bits": "011"
            },
            {
                "size": 3,
                "bits": "101"
            },
            {
                "size": 3,
                "bits": "110"
            }
        ],
        "size": 3
    }
}'
) -L dict-expr-attr.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -P --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'$'\n"'"$1"'"}'|LD_LIBRARY_PATH=../lib ../src/json -P --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -P --no-error; }'

echo '$ json '\''0'\'''
json '0' 2>&1 ||
echo 'command failed: json '\''0'\'''

echo '$ json '\''1'\'''
json '1' 2>&1 ||
echo 'command failed: json '\''1'\'''

echo '$ json '\''a'\'''
json 'a' 2>&1 ||
echo 'command failed: json '\''a'\'''

echo '$ json '\''~a'\'''
json '~a' 2>&1 ||
echo 'command failed: json '\''~a'\'''

echo '$ json '\''a|b'\'''
json 'a|b' 2>&1 ||
echo 'command failed: json '\''a|b'\'''

echo '$ json '\''~(a|b)'\'''
json '~(a|b)' 2>&1 ||
echo 'command failed: json '\''~(a|b)'\'''

echo '$ json '\''a b'\'''
json 'a b' 2>&1 ||
echo 'command failed: json '\''a b'\'''

echo '$ json '\''~(a b)'\'''
json '~(a b)' 2>&1 ||
echo 'command failed: json '\''~(a b)'\'''

echo '$ json '\''~a|~b'\'''
json '~a|~b' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'''

echo '$ json '\''~a~b'\'''
json '~a~b' 2>&1 ||
echo 'command failed: json '\''~a~b'\'''

echo '$ json '\''(a b)|c'\'''
json '(a b)|c' 2>&1 ||
echo 'command failed: json '\''(a b)|c'\'''

echo '$ json '\''a(b|c)'\'''
json 'a(b|c)' 2>&1 ||
echo 'command failed: json '\''a(b|c)'\'''

echo '$ json '\''(a|b)c'\'''
json '(a|b)c' 2>&1 ||
echo 'command failed: json '\''(a|b)c'\'''

echo '$ json '\''a|(b c)'\'''
json 'a|(b c)' 2>&1 ||
echo 'command failed: json '\''a|(b c)'\'''

echo '$ json '\''a||b||c'\'''
json 'a||b||c' 2>&1 ||
echo 'command failed: json '\''a||b||c'\'''

echo '$ json '\''~a||~b||~c'\'''
json '~a||~b||~c' 2>&1 ||
echo 'command failed: json '\''~a||~b||~c'\'''
)

