#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list10
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list10.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
[[]]'
) -L open-array-list10.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array",{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
)

