#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict-expr2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }
$ json '\''a ~a'\'' '\''a'\''
{"a":0}
$ json '\''a ~a'\'' '\''b'\''
{"b":1}
$ json '\''a ~a'\'' '\''c'\''
{"c":2}
$ json '\''a ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a ~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''a ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~a'\'' '\''z'\''
{}
$ json '\''a b'\'' '\''a'\''
{"a":0}
$ json '\''a b'\'' '\''b'\''
{"b":1}
$ json '\''a b'\'' '\''c'\''
{"c":2}
$ json '\''a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a b'\'' '\''z'\''
{}
$ json '\''a ~b'\'' '\''a'\''
{"a":0}
$ json '\''a ~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a ~b'\'' '\''b'\''
$ json '\''a ~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a ~b'\'' '\''c'\''
$ json '\''a ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a ~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a ~b'\'' '\''b,c'\''
$ json '\''a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a ~b'\'' '\''z'\''
$ json '\''a c'\'' '\''a'\''
{"a":0}
$ json '\''a c'\'' '\''b'\''
{"b":1}
$ json '\''a c'\'' '\''c'\''
{"c":2}
$ json '\''a c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a c'\'' '\''z'\''
{}
$ json '\''a ~c'\'' '\''a'\''
{"a":0}
$ json '\''a ~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a ~c'\'' '\''b'\''
$ json '\''a ~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a ~c'\'' '\''c'\''
$ json '\''a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a ~c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a ~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a ~c'\'' '\''b,c'\''
$ json '\''a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a ~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a ~c'\'' '\''z'\''
$ json '\''~a a'\'' '\''a'\''
{"a":0}
$ json '\''~a a'\'' '\''b'\''
{"b":1}
$ json '\''~a a'\'' '\''c'\''
{"c":2}
$ json '\''~a a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~a a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a a'\'' '\''z'\''
{}
$ json '\''~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b'\'' '\''a'\''
$ json '\''~a b'\'' '\''b'\''
{"b":1}
$ json '\''~a b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a b'\'' '\''c'\''
$ json '\''~a b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a b'\'' '\''a,c'\''
$ json '\''~a b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a b'\'' '\''z'\''
$ json '\''~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b'\'' '\''a'\''
$ json '\''~a ~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a ~b'\'' '\''b'\''
$ json '\''~a ~b'\'' '\''c'\''
{"c":2}
$ json '\''~a ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a ~b'\'' '\''a,b'\''
$ json '\''~a ~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~a ~b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a ~b'\'' '\''z'\''
$ json '\''~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c'\'' '\''a'\''
$ json '\''~a c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a c'\'' '\''b'\''
$ json '\''~a c'\'' '\''c'\''
{"c":2}
$ json '\''~a c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a c'\'' '\''a,b'\''
$ json '\''~a c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~a c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a c'\'' '\''z'\''
$ json '\''~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c'\'' '\''a'\''
$ json '\''~a ~c'\'' '\''b'\''
{"b":1}
$ json '\''~a ~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a ~c'\'' '\''c'\''
$ json '\''~a ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a ~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a ~c'\'' '\''a,c'\''
$ json '\''~a ~c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a ~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a ~c'\'' '\''z'\''
$ json '\''b a'\'' '\''a'\''
{"a":0}
$ json '\''b a'\'' '\''b'\''
{"b":1}
$ json '\''b a'\'' '\''c'\''
{"c":2}
$ json '\''b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''b a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b a'\'' '\''z'\''
{}
$ json '\''b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a'\'' '\''a'\''
$ json '\''b ~a'\'' '\''b'\''
{"b":1}
$ json '\''b ~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b ~a'\'' '\''c'\''
$ json '\''b ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b ~a'\'' '\''a,c'\''
$ json '\''b ~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b ~a'\'' '\''z'\''
$ json '\''b ~b'\'' '\''a'\''
{"a":0}
$ json '\''b ~b'\'' '\''b'\''
{"b":1}
$ json '\''b ~b'\'' '\''c'\''
{"c":2}
$ json '\''b ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''b ~b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~b'\'' '\''z'\''
{}
$ json '\''b c'\'' '\''a'\''
{"a":0}
$ json '\''b c'\'' '\''b'\''
{"b":1}
$ json '\''b c'\'' '\''c'\''
{"c":2}
$ json '\''b c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''b c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b c'\'' '\''z'\''
{}
$ json '\''b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c'\'' '\''a'\''
$ json '\''b ~c'\'' '\''b'\''
{"b":1}
$ json '\''b ~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b ~c'\'' '\''c'\''
$ json '\''b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b ~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b ~c'\'' '\''a,c'\''
$ json '\''b ~c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b ~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b ~c'\'' '\''z'\''
$ json '\''~b a'\'' '\''a'\''
{"a":0}
$ json '\''~b a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b a'\'' '\''b'\''
$ json '\''~b a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b a'\'' '\''c'\''
$ json '\''~b a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b a'\'' '\''b,c'\''
$ json '\''~b a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b a'\'' '\''z'\''
$ json '\''~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a'\'' '\''a'\''
$ json '\''~b ~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b ~a'\'' '\''b'\''
$ json '\''~b ~a'\'' '\''c'\''
{"c":2}
$ json '\''~b ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b ~a'\'' '\''a,b'\''
$ json '\''~b ~a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b ~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~b ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b ~a'\'' '\''z'\''
$ json '\''~b b'\'' '\''a'\''
{"a":0}
$ json '\''~b b'\'' '\''b'\''
{"b":1}
$ json '\''~b b'\'' '\''c'\''
{"c":2}
$ json '\''~b b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~b b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b b'\'' '\''z'\''
{}
$ json '\''~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c'\'' '\''a'\''
$ json '\''~b c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b c'\'' '\''b'\''
$ json '\''~b c'\'' '\''c'\''
{"c":2}
$ json '\''~b c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b c'\'' '\''a,b'\''
$ json '\''~b c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~b c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b c'\'' '\''z'\''
$ json '\''~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b ~c'\'' '\''b'\''
$ json '\''~b ~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b ~c'\'' '\''c'\''
$ json '\''~b ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b ~c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b ~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b ~c'\'' '\''b,c'\''
$ json '\''~b ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b ~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b ~c'\'' '\''z'\''
$ json '\''c a'\'' '\''a'\''
{"a":0}
$ json '\''c a'\'' '\''b'\''
{"b":1}
$ json '\''c a'\'' '\''c'\''
{"c":2}
$ json '\''c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c a'\'' '\''z'\''
{}
$ json '\''c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a'\'' '\''a'\''
$ json '\''c ~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c ~a'\'' '\''b'\''
$ json '\''c ~a'\'' '\''c'\''
{"c":2}
$ json '\''c ~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~a'\'' '\''a,b'\''
$ json '\''c ~a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c ~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c ~a'\'' '\''z'\''
$ json '\''c b'\'' '\''a'\''
{"a":0}
$ json '\''c b'\'' '\''b'\''
{"b":1}
$ json '\''c b'\'' '\''c'\''
{"c":2}
$ json '\''c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c b'\'' '\''z'\''
{}
$ json '\''c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b'\'' '\''a'\''
$ json '\''c ~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c ~b'\'' '\''b'\''
$ json '\''c ~b'\'' '\''c'\''
{"c":2}
$ json '\''c ~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c ~b'\'' '\''a,b'\''
$ json '\''c ~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c ~b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c ~b'\'' '\''z'\''
$ json '\''c ~c'\'' '\''a'\''
{"a":0}
$ json '\''c ~c'\'' '\''b'\''
{"b":1}
$ json '\''c ~c'\'' '\''c'\''
{"c":2}
$ json '\''c ~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c ~c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c ~c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c ~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c ~c'\'' '\''z'\''
{}
$ json '\''~c a'\'' '\''a'\''
{"a":0}
$ json '\''~c a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c a'\'' '\''b'\''
$ json '\''~c a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c a'\'' '\''c'\''
$ json '\''~c a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~c a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c a'\'' '\''b,c'\''
$ json '\''~c a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c a'\'' '\''z'\''
$ json '\''~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a'\'' '\''a'\''
$ json '\''~c ~a'\'' '\''b'\''
{"b":1}
$ json '\''~c ~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c ~a'\'' '\''c'\''
$ json '\''~c ~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c ~a'\'' '\''a,c'\''
$ json '\''~c ~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~c ~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c ~a'\'' '\''z'\''
$ json '\''~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b'\'' '\''a'\''
$ json '\''~c b'\'' '\''b'\''
{"b":1}
$ json '\''~c b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c b'\'' '\''c'\''
$ json '\''~c b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c b'\'' '\''a,c'\''
$ json '\''~c b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~c b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c b'\'' '\''z'\''
$ json '\''~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c ~b'\'' '\''b'\''
$ json '\''~c ~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c ~b'\'' '\''c'\''
$ json '\''~c ~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c ~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~c ~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c ~b'\'' '\''b,c'\''
$ json '\''~c ~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c ~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c ~b'\'' '\''z'\''
$ json '\''~c c'\'' '\''a'\''
{"a":0}
$ json '\''~c c'\'' '\''b'\''
{"b":1}
$ json '\''~c c'\'' '\''c'\''
{"c":2}
$ json '\''~c c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~c c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~c c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c c'\'' '\''z'\''
{}
$ json '\''a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a'\'' '\''a'\''
$ json '\''a|~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a|~a'\'' '\''b'\''
$ json '\''a|~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a|~a'\'' '\''c'\''
$ json '\''a|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~a'\'' '\''a,b'\''
$ json '\''a|~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''a|~a'\'' '\''a,c'\''
$ json '\''a|~a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a|~a'\'' '\''b,c'\''
$ json '\''a|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a|~a'\'' '\''z'\''
$ json '\''a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b'\'' '\''a'\''
$ json '\''a|b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a|b'\'' '\''b'\''
$ json '\''a|b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a|b'\'' '\''c'\''
$ json '\''a|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''a|b'\'' '\''a,c'\''
$ json '\''a|b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a|b'\'' '\''b,c'\''
$ json '\''a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a|b'\'' '\''z'\''
$ json '\''a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b'\'' '\''a'\''
$ json '\''a|~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a|~b'\'' '\''b'\''
$ json '\''a|~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a|~b'\'' '\''c'\''
$ json '\''a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|~b'\'' '\''a,b'\''
$ json '\''a|~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a|~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a|~b'\'' '\''b,c'\''
$ json '\''a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a|~b'\'' '\''z'\''
$ json '\''a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c'\'' '\''a'\''
$ json '\''a|c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a|c'\'' '\''b'\''
$ json '\''a|c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a|c'\'' '\''c'\''
$ json '\''a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''a|c'\'' '\''a,b'\''
$ json '\''a|c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a|c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a|c'\'' '\''b,c'\''
$ json '\''a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a|c'\'' '\''z'\''
$ json '\''a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c'\'' '\''a'\''
$ json '\''a|~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a|~c'\'' '\''b'\''
$ json '\''a|~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a|~c'\'' '\''c'\''
$ json '\''a|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a|~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''a|~c'\'' '\''a,c'\''
$ json '\''a|~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a|~c'\'' '\''b,c'\''
$ json '\''a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a|~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a|~c'\'' '\''z'\''
$ json '\''~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a'\'' '\''a'\''
$ json '\''~a|a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a|a'\'' '\''b'\''
$ json '\''~a|a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a|a'\'' '\''c'\''
$ json '\''~a|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|a'\'' '\''a,b'\''
$ json '\''~a|a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a|a'\'' '\''a,c'\''
$ json '\''~a|a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~a|a'\'' '\''b,c'\''
$ json '\''~a|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a|a'\'' '\''z'\''
$ json '\''~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b'\'' '\''a'\''
$ json '\''~a|b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a|b'\'' '\''b'\''
$ json '\''~a|b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a|b'\'' '\''c'\''
$ json '\''~a|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|b'\'' '\''a,b'\''
$ json '\''~a|b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a|b'\'' '\''a,c'\''
$ json '\''~a|b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a|b'\'' '\''z'\''
$ json '\''~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b'\'' '\''a'\''
$ json '\''~a|~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a|~b'\'' '\''b'\''
$ json '\''~a|~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a|~b'\'' '\''c'\''
$ json '\''~a|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~b'\'' '\''a,b'\''
$ json '\''~a|~b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a|~b'\'' '\''a,c'\''
$ json '\''~a|~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~a|~b'\'' '\''b,c'\''
$ json '\''~a|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a|~b'\'' '\''z'\''
$ json '\''~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c'\'' '\''a'\''
$ json '\''~a|c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a|c'\'' '\''b'\''
$ json '\''~a|c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a|c'\'' '\''c'\''
$ json '\''~a|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|c'\'' '\''a,b'\''
$ json '\''~a|c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a|c'\'' '\''a,c'\''
$ json '\''~a|c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a|c'\'' '\''z'\''
$ json '\''~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c'\'' '\''a'\''
$ json '\''~a|~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a|~c'\'' '\''b'\''
$ json '\''~a|~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a|~c'\'' '\''c'\''
$ json '\''~a|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a|~c'\'' '\''a,b'\''
$ json '\''~a|~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a|~c'\'' '\''a,c'\''
$ json '\''~a|~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~a|~c'\'' '\''b,c'\''
$ json '\''~a|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a|~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a|~c'\'' '\''z'\''
$ json '\''b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a'\'' '\''a'\''
$ json '\''b|a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''b|a'\'' '\''b'\''
$ json '\''b|a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b|a'\'' '\''c'\''
$ json '\''b|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b|a'\'' '\''a,c'\''
$ json '\''b|a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''b|a'\'' '\''b,c'\''
$ json '\''b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b|a'\'' '\''z'\''
$ json '\''b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a'\'' '\''a'\''
$ json '\''b|~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''b|~a'\'' '\''b'\''
$ json '\''b|~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b|~a'\'' '\''c'\''
$ json '\''b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~a'\'' '\''a,b'\''
$ json '\''b|~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b|~a'\'' '\''a,c'\''
$ json '\''b|~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b|~a'\'' '\''z'\''
$ json '\''b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b'\'' '\''a'\''
$ json '\''b|~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''b|~b'\'' '\''b'\''
$ json '\''b|~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b|~b'\'' '\''c'\''
$ json '\''b|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|~b'\'' '\''a,b'\''
$ json '\''b|~b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b|~b'\'' '\''a,c'\''
$ json '\''b|~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''b|~b'\'' '\''b,c'\''
$ json '\''b|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b|~b'\'' '\''z'\''
$ json '\''b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c'\'' '\''a'\''
$ json '\''b|c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''b|c'\'' '\''b'\''
$ json '\''b|c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b|c'\'' '\''c'\''
$ json '\''b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''b|c'\'' '\''a,b'\''
$ json '\''b|c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b|c'\'' '\''a,c'\''
$ json '\''b|c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b|c'\'' '\''z'\''
$ json '\''b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c'\'' '\''a'\''
$ json '\''b|~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''b|~c'\'' '\''b'\''
$ json '\''b|~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b|~c'\'' '\''c'\''
$ json '\''b|~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b|~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b|~c'\'' '\''a,c'\''
$ json '\''b|~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''b|~c'\'' '\''b,c'\''
$ json '\''b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b|~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b|~c'\'' '\''z'\''
$ json '\''~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a'\'' '\''a'\''
$ json '\''~b|a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b|a'\'' '\''b'\''
$ json '\''~b|a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b|a'\'' '\''c'\''
$ json '\''~b|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|a'\'' '\''a,b'\''
$ json '\''~b|a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b|a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b|a'\'' '\''b,c'\''
$ json '\''~b|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b|a'\'' '\''z'\''
$ json '\''~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a'\'' '\''a'\''
$ json '\''~b|~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b|~a'\'' '\''b'\''
$ json '\''~b|~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b|~a'\'' '\''c'\''
$ json '\''~b|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~a'\'' '\''a,b'\''
$ json '\''~b|~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~b|~a'\'' '\''a,c'\''
$ json '\''~b|~a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b|~a'\'' '\''b,c'\''
$ json '\''~b|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b|~a'\'' '\''z'\''
$ json '\''~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b'\'' '\''a'\''
$ json '\''~b|b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b|b'\'' '\''b'\''
$ json '\''~b|b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b|b'\'' '\''c'\''
$ json '\''~b|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|b'\'' '\''a,b'\''
$ json '\''~b|b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~b|b'\'' '\''a,c'\''
$ json '\''~b|b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b|b'\'' '\''b,c'\''
$ json '\''~b|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b|b'\'' '\''z'\''
$ json '\''~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c'\'' '\''a'\''
$ json '\''~b|c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b|c'\'' '\''b'\''
$ json '\''~b|c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b|c'\'' '\''c'\''
$ json '\''~b|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|c'\'' '\''a,b'\''
$ json '\''~b|c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b|c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b|c'\'' '\''b,c'\''
$ json '\''~b|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b|c'\'' '\''z'\''
$ json '\''~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c'\'' '\''a'\''
$ json '\''~b|~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b|~c'\'' '\''b'\''
$ json '\''~b|~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b|~c'\'' '\''c'\''
$ json '\''~b|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b|~c'\'' '\''a,b'\''
$ json '\''~b|~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~b|~c'\'' '\''a,c'\''
$ json '\''~b|~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b|~c'\'' '\''b,c'\''
$ json '\''~b|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b|~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b|~c'\'' '\''z'\''
$ json '\''c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a'\'' '\''a'\''
$ json '\''c|a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c|a'\'' '\''b'\''
$ json '\''c|a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''c|a'\'' '\''c'\''
$ json '\''c|a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|a'\'' '\''a,b'\''
$ json '\''c|a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c|a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''c|a'\'' '\''b,c'\''
$ json '\''c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c|a'\'' '\''z'\''
$ json '\''c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a'\'' '\''a'\''
$ json '\''c|~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c|~a'\'' '\''b'\''
$ json '\''c|~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''c|~a'\'' '\''c'\''
$ json '\''c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~a'\'' '\''a,b'\''
$ json '\''c|~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''c|~a'\'' '\''a,c'\''
$ json '\''c|~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c|~a'\'' '\''z'\''
$ json '\''c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b'\'' '\''a'\''
$ json '\''c|b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c|b'\'' '\''b'\''
$ json '\''c|b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''c|b'\'' '\''c'\''
$ json '\''c|b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|b'\'' '\''a,b'\''
$ json '\''c|b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''c|b'\'' '\''a,c'\''
$ json '\''c|b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c|b'\'' '\''z'\''
$ json '\''c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b'\'' '\''a'\''
$ json '\''c|~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c|~b'\'' '\''b'\''
$ json '\''c|~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''c|~b'\'' '\''c'\''
$ json '\''c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~b'\'' '\''a,b'\''
$ json '\''c|~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c|~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''c|~b'\'' '\''b,c'\''
$ json '\''c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c|~b'\'' '\''z'\''
$ json '\''c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c'\'' '\''a'\''
$ json '\''c|~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c|~c'\'' '\''b'\''
$ json '\''c|~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''c|~c'\'' '\''c'\''
$ json '\''c|~c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c|~c'\'' '\''a,b'\''
$ json '\''c|~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''c|~c'\'' '\''a,c'\''
$ json '\''c|~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''c|~c'\'' '\''b,c'\''
$ json '\''c|~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c|~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c|~c'\'' '\''z'\''
$ json '\''~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a'\'' '\''a'\''
$ json '\''~c|a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c|a'\'' '\''b'\''
$ json '\''~c|a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c|a'\'' '\''c'\''
$ json '\''~c|a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c|a'\'' '\''a,c'\''
$ json '\''~c|a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c|a'\'' '\''b,c'\''
$ json '\''~c|a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c|a'\'' '\''z'\''
$ json '\''~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a'\'' '\''a'\''
$ json '\''~c|~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c|~a'\'' '\''b'\''
$ json '\''~c|~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c|~a'\'' '\''c'\''
$ json '\''~c|~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~a'\'' '\''a,b'\''
$ json '\''~c|~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c|~a'\'' '\''a,c'\''
$ json '\''~c|~a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c|~a'\'' '\''b,c'\''
$ json '\''~c|~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c|~a'\'' '\''z'\''
$ json '\''~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b'\'' '\''a'\''
$ json '\''~c|b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c|b'\'' '\''b'\''
$ json '\''~c|b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c|b'\'' '\''c'\''
$ json '\''~c|b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c|b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c|b'\'' '\''a,c'\''
$ json '\''~c|b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c|b'\'' '\''b,c'\''
$ json '\''~c|b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c|b'\'' '\''z'\''
$ json '\''~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b'\'' '\''a'\''
$ json '\''~c|~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c|~b'\'' '\''b'\''
$ json '\''~c|~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c|~b'\'' '\''c'\''
$ json '\''~c|~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|~b'\'' '\''a,b'\''
$ json '\''~c|~b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c|~b'\'' '\''a,c'\''
$ json '\''~c|~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c|~b'\'' '\''b,c'\''
$ json '\''~c|~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c|~b'\'' '\''z'\''
$ json '\''~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c'\'' '\''a'\''
$ json '\''~c|c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c|c'\'' '\''b'\''
$ json '\''~c|c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c|c'\'' '\''c'\''
$ json '\''~c|c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~c|c'\'' '\''a,b'\''
$ json '\''~c|c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c|c'\'' '\''a,c'\''
$ json '\''~c|c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c|c'\'' '\''b,c'\''
$ json '\''~c|c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c|c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a", "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c|c'\'' '\''z'\''
$ json '\''a||~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a||~a'\'' '\''b'\''
$ json '\''a||~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a||~a'\'' '\''c'\''
$ json '\''a||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a||~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''a||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a||~a'\'' '\''z'\''
$ json '\''a||b'\'' '\''a'\''
{"a":0}
$ json '\''a||b'\'' '\''b'\''
{"b":1}
$ json '\''a||b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a||b'\'' '\''c'\''
$ json '\''a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a||b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a||b'\'' '\''z'\''
$ json '\''a||~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a||~b'\'' '\''b'\''
$ json '\''a||~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a||~b'\'' '\''c'\''
$ json '\''a||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a||~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a||~b'\'' '\''b,c'\''
$ json '\''a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a||~b'\'' '\''z'\''
$ json '\''a||c'\'' '\''a'\''
{"a":0}
$ json '\''a||c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a||c'\'' '\''b'\''
$ json '\''a||c'\'' '\''c'\''
{"c":2}
$ json '\''a||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a||c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a||c'\'' '\''z'\''
$ json '\''a||~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a||~c'\'' '\''b'\''
$ json '\''a||~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''a||~c'\'' '\''c'\''
$ json '\''a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a||~c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''a||~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''a||~c'\'' '\''b,c'\''
$ json '\''a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''a||~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a||~c'\'' '\''z'\''
$ json '\''~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~a||a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a||a'\'' '\''b'\''
$ json '\''~a||a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a||a'\'' '\''c'\''
$ json '\''~a||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~a||a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a||a'\'' '\''z'\''
$ json '\''~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b'\'' '\''a'\''
$ json '\''~a||b'\'' '\''b'\''
{"b":1}
$ json '\''~a||b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a||b'\'' '\''c'\''
$ json '\''~a||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a||b'\'' '\''a,c'\''
$ json '\''~a||b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a||b'\'' '\''z'\''
$ json '\''~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b'\'' '\''a'\''
$ json '\''~a||~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a||~b'\'' '\''b'\''
$ json '\''~a||~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a||~b'\'' '\''c'\''
$ json '\''~a||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||~b'\'' '\''a,b'\''
$ json '\''~a||~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~a||~b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a||~b'\'' '\''z'\''
$ json '\''~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c'\'' '\''a'\''
$ json '\''~a||c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a||c'\'' '\''b'\''
$ json '\''~a||c'\'' '\''c'\''
{"c":2}
$ json '\''~a||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~a||c'\'' '\''a,b'\''
$ json '\''~a||c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~a||c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a||c'\'' '\''z'\''
$ json '\''~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c'\'' '\''a'\''
$ json '\''~a||~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~a||~c'\'' '\''b'\''
$ json '\''~a||~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~a||~c'\'' '\''c'\''
$ json '\''~a||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a||~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~a||~c'\'' '\''a,c'\''
$ json '\''~a||~c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~a||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~a||~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a||~c'\'' '\''z'\''
$ json '\''b||a'\'' '\''a'\''
{"a":0}
$ json '\''b||a'\'' '\''b'\''
{"b":1}
$ json '\''b||a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b||a'\'' '\''c'\''
$ json '\''b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''b||a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b||a'\'' '\''z'\''
$ json '\''b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a'\'' '\''a'\''
$ json '\''b||~a'\'' '\''b'\''
{"b":1}
$ json '\''b||~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b||~a'\'' '\''c'\''
$ json '\''b||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b||~a'\'' '\''a,c'\''
$ json '\''b||~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b||~a'\'' '\''z'\''
$ json '\''b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b'\'' '\''a'\''
$ json '\''b||~b'\'' '\''b'\''
{"b":1}
$ json '\''b||~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b||~b'\'' '\''c'\''
$ json '\''b||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''b||~b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b||~b'\'' '\''z'\''
$ json '\''b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c'\'' '\''a'\''
$ json '\''b||c'\'' '\''b'\''
{"b":1}
$ json '\''b||c'\'' '\''c'\''
{"c":2}
$ json '\''b||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''b||c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b||c'\'' '\''z'\''
$ json '\''b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c'\'' '\''a'\''
$ json '\''b||~c'\'' '\''b'\''
{"b":1}
$ json '\''b||~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''b||~c'\'' '\''c'\''
$ json '\''b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b||~c'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''b||~c'\'' '\''a,c'\''
$ json '\''b||~c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''b||~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b||~c'\'' '\''z'\''
$ json '\''~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~b||a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b||a'\'' '\''b'\''
$ json '\''~b||a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b||a'\'' '\''c'\''
$ json '\''~b||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b||a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b||a'\'' '\''b,c'\''
$ json '\''~b||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b||a'\'' '\''z'\''
$ json '\''~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a'\'' '\''a'\''
$ json '\''~b||~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b||~a'\'' '\''b'\''
$ json '\''~b||~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b||~a'\'' '\''c'\''
$ json '\''~b||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||~a'\'' '\''a,b'\''
$ json '\''~b||~a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b||~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~b||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b||~a'\'' '\''z'\''
$ json '\''~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b'\'' '\''a'\''
$ json '\''~b||b'\'' '\''b'\''
{"b":1}
$ json '\''~b||b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b||b'\'' '\''c'\''
$ json '\''~b||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b||b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~b||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b||b'\'' '\''z'\''
$ json '\''~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c'\'' '\''a'\''
$ json '\''~b||c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b||c'\'' '\''b'\''
$ json '\''~b||c'\'' '\''c'\''
{"c":2}
$ json '\''~b||c'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''~b||c'\'' '\''a,b'\''
$ json '\''~b||c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b||c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~b||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b||c'\'' '\''z'\''
$ json '\''~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c'\'' '\''a'\''
$ json '\''~b||~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b||~c'\'' '\''b'\''
$ json '\''~b||~c'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a" and "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~b||~c'\'' '\''c'\''
$ json '\''~b||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b||~c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~b||~c'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~b||~c'\'' '\''b,c'\''
$ json '\''~b||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~b||~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "c"; 2nd case: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b||~c'\'' '\''z'\''
$ json '\''c||a'\'' '\''a'\''
{"a":0}
$ json '\''c||a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c||a'\'' '\''b'\''
$ json '\''c||a'\'' '\''c'\''
{"c":2}
$ json '\''c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c||a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c||a'\'' '\''z'\''
$ json '\''c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a'\'' '\''a'\''
$ json '\''c||~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c||~a'\'' '\''b'\''
$ json '\''c||~a'\'' '\''c'\''
{"c":2}
$ json '\''c||~a'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~a'\'' '\''a,b'\''
$ json '\''c||~a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c||~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c||~a'\'' '\''z'\''
$ json '\''c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b'\'' '\''a'\''
$ json '\''c||b'\'' '\''b'\''
{"b":1}
$ json '\''c||b'\'' '\''c'\''
{"c":2}
$ json '\''c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c||b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c||b'\'' '\''z'\''
$ json '\''c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b'\'' '\''a'\''
$ json '\''c||~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c||~b'\'' '\''b'\''
$ json '\''c||~b'\'' '\''c'\''
{"c":2}
$ json '\''c||~b'\'' '\''a,b'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:13: {"a":0,"b":1}
json: error: <stdin>:1:13:             ^
{"a":0,"b":1}
command failed: json '\''c||~b'\'' '\''a,b'\''
$ json '\''c||~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c||~b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c||~b'\'' '\''z'\''
$ json '\''c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c'\'' '\''a'\''
$ json '\''c||~c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''c||~c'\'' '\''b'\''
$ json '\''c||~c'\'' '\''c'\''
{"c":2}
$ json '\''c||~c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''c||~c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''c||~c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''c||~c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''c||~c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "a" and "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''c||~c'\'' '\''z'\''
$ json '\''~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~c||a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c||a'\'' '\''b'\''
$ json '\''~c||a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c||a'\'' '\''c'\''
$ json '\''~c||a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||a'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~c||a'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c||a'\'' '\''b,c'\''
$ json '\''~c||a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c||a'\'' '\''z'\''
$ json '\''~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a'\'' '\''a'\''
$ json '\''~c||~a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c||~a'\'' '\''b'\''
$ json '\''~c||~a'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c||~a'\'' '\''c'\''
$ json '\''~c||~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~a'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c||~a'\'' '\''a,c'\''
$ json '\''~c||~a'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~c||~a'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c||~a'\'' '\''z'\''
$ json '\''~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b'\'' '\''a'\''
$ json '\''~c||b'\'' '\''b'\''
{"b":1}
$ json '\''~c||b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c||b'\'' '\''c'\''
$ json '\''~c||b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||b'\'' '\''a,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:13: {"a":0,"c":2}
json: error: <stdin>:1:13:             ^
{"a":0,"c":2}
command failed: json '\''~c||b'\'' '\''a,c'\''
$ json '\''~c||b'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~c||b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c||b'\'' '\''z'\''
$ json '\''~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b'\'' '\''a'\''
$ json '\''~c||~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a" and "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c||~b'\'' '\''b'\''
$ json '\''~c||~b'\'' '\''c'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "a"
json: error: <stdin>:1:7: {"c":2}
json: error: <stdin>:1:7:       ^
{"c":2}
command failed: json '\''~c||~b'\'' '\''c'\''
$ json '\''~c||~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||~b'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~c||~b'\'' '\''b,c'\''
json: error: <stdin>:1:13: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "a"
json: error: <stdin>:1:13: {"b":1,"c":2}
json: error: <stdin>:1:13:             ^
{"b":1,"c":2}
command failed: json '\''~c||~b'\'' '\''b,c'\''
$ json '\''~c||~b'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "a" and "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c||~b'\'' '\''z'\''
$ json '\''~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c'\'' '\''a'\''
$ json '\''~c||c'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "a"; 2nd case: "c"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~c||c'\'' '\''b'\''
$ json '\''~c||c'\'' '\''c'\''
{"c":2}
$ json '\''~c||c'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~c||c'\'' '\''a,c'\''
{"a":0,"c":2}
$ json '\''~c||c'\'' '\''b,c'\''
{"b":1,"c":2}
$ json '\''~c||c'\'' '\''a,b,c'\''
{"a":0,"b":1,"c":2}
$ json '\''~c||c'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: 1st case: "a" and "b"; 2nd case: "c"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~c||c'\'' '\''z'\'''
) -L dict-expr2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'
json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); } 2>&1 ||
echo 'command failed: json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'

echo '$ json '\''a ~a'\'' '\''a'\'''
json 'a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''a'\'''

echo '$ json '\''a ~a'\'' '\''b'\'''
json 'a ~a' 'b' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''b'\'''

echo '$ json '\''a ~a'\'' '\''c'\'''
json 'a ~a' 'c' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''c'\'''

echo '$ json '\''a ~a'\'' '\''a,b'\'''
json 'a ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''a,b'\'''

echo '$ json '\''a ~a'\'' '\''a,c'\'''
json 'a ~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''a,c'\'''

echo '$ json '\''a ~a'\'' '\''b,c'\'''
json 'a ~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''b,c'\'''

echo '$ json '\''a ~a'\'' '\''a,b,c'\'''
json 'a ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''a,b,c'\'''

echo '$ json '\''a ~a'\'' '\''z'\'''
json 'a ~a' 'z' 2>&1 ||
echo 'command failed: json '\''a ~a'\'' '\''z'\'''

echo '$ json '\''a b'\'' '\''a'\'''
json 'a b' 'a' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''a'\'''

echo '$ json '\''a b'\'' '\''b'\'''
json 'a b' 'b' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''b'\'''

echo '$ json '\''a b'\'' '\''c'\'''
json 'a b' 'c' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''c'\'''

echo '$ json '\''a b'\'' '\''a,b'\'''
json 'a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''a,b'\'''

echo '$ json '\''a b'\'' '\''a,c'\'''
json 'a b' 'a,c' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''a,c'\'''

echo '$ json '\''a b'\'' '\''b,c'\'''
json 'a b' 'b,c' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''b,c'\'''

echo '$ json '\''a b'\'' '\''a,b,c'\'''
json 'a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''a,b,c'\'''

echo '$ json '\''a b'\'' '\''z'\'''
json 'a b' 'z' 2>&1 ||
echo 'command failed: json '\''a b'\'' '\''z'\'''

echo '$ json '\''a ~b'\'' '\''a'\'''
json 'a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''a'\'''

echo '$ json '\''a ~b'\'' '\''b'\'''
json 'a ~b' 'b' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''b'\'''

echo '$ json '\''a ~b'\'' '\''c'\'''
json 'a ~b' 'c' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''c'\'''

echo '$ json '\''a ~b'\'' '\''a,b'\'''
json 'a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''a,b'\'''

echo '$ json '\''a ~b'\'' '\''a,c'\'''
json 'a ~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''a,c'\'''

echo '$ json '\''a ~b'\'' '\''b,c'\'''
json 'a ~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''b,c'\'''

echo '$ json '\''a ~b'\'' '\''a,b,c'\'''
json 'a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''a ~b'\'' '\''z'\'''
json 'a ~b' 'z' 2>&1 ||
echo 'command failed: json '\''a ~b'\'' '\''z'\'''

echo '$ json '\''a c'\'' '\''a'\'''
json 'a c' 'a' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''a'\'''

echo '$ json '\''a c'\'' '\''b'\'''
json 'a c' 'b' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''b'\'''

echo '$ json '\''a c'\'' '\''c'\'''
json 'a c' 'c' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''c'\'''

echo '$ json '\''a c'\'' '\''a,b'\'''
json 'a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''a,b'\'''

echo '$ json '\''a c'\'' '\''a,c'\'''
json 'a c' 'a,c' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''a,c'\'''

echo '$ json '\''a c'\'' '\''b,c'\'''
json 'a c' 'b,c' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''b,c'\'''

echo '$ json '\''a c'\'' '\''a,b,c'\'''
json 'a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''a,b,c'\'''

echo '$ json '\''a c'\'' '\''z'\'''
json 'a c' 'z' 2>&1 ||
echo 'command failed: json '\''a c'\'' '\''z'\'''

echo '$ json '\''a ~c'\'' '\''a'\'''
json 'a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''a'\'''

echo '$ json '\''a ~c'\'' '\''b'\'''
json 'a ~c' 'b' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''b'\'''

echo '$ json '\''a ~c'\'' '\''c'\'''
json 'a ~c' 'c' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''c'\'''

echo '$ json '\''a ~c'\'' '\''a,b'\'''
json 'a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''a,b'\'''

echo '$ json '\''a ~c'\'' '\''a,c'\'''
json 'a ~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''a,c'\'''

echo '$ json '\''a ~c'\'' '\''b,c'\'''
json 'a ~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''b,c'\'''

echo '$ json '\''a ~c'\'' '\''a,b,c'\'''
json 'a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''a ~c'\'' '\''z'\'''
json 'a ~c' 'z' 2>&1 ||
echo 'command failed: json '\''a ~c'\'' '\''z'\'''

echo '$ json '\''~a a'\'' '\''a'\'''
json '~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''a'\'''

echo '$ json '\''~a a'\'' '\''b'\'''
json '~a a' 'b' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''b'\'''

echo '$ json '\''~a a'\'' '\''c'\'''
json '~a a' 'c' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''c'\'''

echo '$ json '\''~a a'\'' '\''a,b'\'''
json '~a a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''a,b'\'''

echo '$ json '\''~a a'\'' '\''a,c'\'''
json '~a a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''a,c'\'''

echo '$ json '\''~a a'\'' '\''b,c'\'''
json '~a a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''b,c'\'''

echo '$ json '\''~a a'\'' '\''a,b,c'\'''
json '~a a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''a,b,c'\'''

echo '$ json '\''~a a'\'' '\''z'\'''
json '~a a' 'z' 2>&1 ||
echo 'command failed: json '\''~a a'\'' '\''z'\'''

echo '$ json '\''~a b'\'' '\''a'\'''
json '~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''a'\'''

echo '$ json '\''~a b'\'' '\''b'\'''
json '~a b' 'b' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''b'\'''

echo '$ json '\''~a b'\'' '\''c'\'''
json '~a b' 'c' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''c'\'''

echo '$ json '\''~a b'\'' '\''a,b'\'''
json '~a b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''a,b'\'''

echo '$ json '\''~a b'\'' '\''a,c'\'''
json '~a b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''a,c'\'''

echo '$ json '\''~a b'\'' '\''b,c'\'''
json '~a b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''b,c'\'''

echo '$ json '\''~a b'\'' '\''a,b,c'\'''
json '~a b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''a,b,c'\'''

echo '$ json '\''~a b'\'' '\''z'\'''
json '~a b' 'z' 2>&1 ||
echo 'command failed: json '\''~a b'\'' '\''z'\'''

echo '$ json '\''~a ~b'\'' '\''a'\'''
json '~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''a'\'''

echo '$ json '\''~a ~b'\'' '\''b'\'''
json '~a ~b' 'b' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''b'\'''

echo '$ json '\''~a ~b'\'' '\''c'\'''
json '~a ~b' 'c' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''c'\'''

echo '$ json '\''~a ~b'\'' '\''a,b'\'''
json '~a ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''a,b'\'''

echo '$ json '\''~a ~b'\'' '\''a,c'\'''
json '~a ~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''a,c'\'''

echo '$ json '\''~a ~b'\'' '\''b,c'\'''
json '~a ~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''b,c'\'''

echo '$ json '\''~a ~b'\'' '\''a,b,c'\'''
json '~a ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~b'\'' '\''z'\'''
json '~a ~b' 'z' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'' '\''z'\'''

echo '$ json '\''~a c'\'' '\''a'\'''
json '~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''a'\'''

echo '$ json '\''~a c'\'' '\''b'\'''
json '~a c' 'b' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''b'\'''

echo '$ json '\''~a c'\'' '\''c'\'''
json '~a c' 'c' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''c'\'''

echo '$ json '\''~a c'\'' '\''a,b'\'''
json '~a c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''a,b'\'''

echo '$ json '\''~a c'\'' '\''a,c'\'''
json '~a c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''a,c'\'''

echo '$ json '\''~a c'\'' '\''b,c'\'''
json '~a c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''b,c'\'''

echo '$ json '\''~a c'\'' '\''a,b,c'\'''
json '~a c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''a,b,c'\'''

echo '$ json '\''~a c'\'' '\''z'\'''
json '~a c' 'z' 2>&1 ||
echo 'command failed: json '\''~a c'\'' '\''z'\'''

echo '$ json '\''~a ~c'\'' '\''a'\'''
json '~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''a'\'''

echo '$ json '\''~a ~c'\'' '\''b'\'''
json '~a ~c' 'b' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''b'\'''

echo '$ json '\''~a ~c'\'' '\''c'\'''
json '~a ~c' 'c' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''c'\'''

echo '$ json '\''~a ~c'\'' '\''a,b'\'''
json '~a ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''a,b'\'''

echo '$ json '\''~a ~c'\'' '\''a,c'\'''
json '~a ~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''a,c'\'''

echo '$ json '\''~a ~c'\'' '\''b,c'\'''
json '~a ~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''b,c'\'''

echo '$ json '\''~a ~c'\'' '\''a,b,c'\'''
json '~a ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a ~c'\'' '\''z'\'''
json '~a ~c' 'z' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'' '\''z'\'''

echo '$ json '\''b a'\'' '\''a'\'''
json 'b a' 'a' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''a'\'''

echo '$ json '\''b a'\'' '\''b'\'''
json 'b a' 'b' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''b'\'''

echo '$ json '\''b a'\'' '\''c'\'''
json 'b a' 'c' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''c'\'''

echo '$ json '\''b a'\'' '\''a,b'\'''
json 'b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''a,b'\'''

echo '$ json '\''b a'\'' '\''a,c'\'''
json 'b a' 'a,c' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''a,c'\'''

echo '$ json '\''b a'\'' '\''b,c'\'''
json 'b a' 'b,c' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''b,c'\'''

echo '$ json '\''b a'\'' '\''a,b,c'\'''
json 'b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''a,b,c'\'''

echo '$ json '\''b a'\'' '\''z'\'''
json 'b a' 'z' 2>&1 ||
echo 'command failed: json '\''b a'\'' '\''z'\'''

echo '$ json '\''b ~a'\'' '\''a'\'''
json 'b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''a'\'''

echo '$ json '\''b ~a'\'' '\''b'\'''
json 'b ~a' 'b' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''b'\'''

echo '$ json '\''b ~a'\'' '\''c'\'''
json 'b ~a' 'c' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''c'\'''

echo '$ json '\''b ~a'\'' '\''a,b'\'''
json 'b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''a,b'\'''

echo '$ json '\''b ~a'\'' '\''a,c'\'''
json 'b ~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''a,c'\'''

echo '$ json '\''b ~a'\'' '\''b,c'\'''
json 'b ~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''b,c'\'''

echo '$ json '\''b ~a'\'' '\''a,b,c'\'''
json 'b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''b ~a'\'' '\''z'\'''
json 'b ~a' 'z' 2>&1 ||
echo 'command failed: json '\''b ~a'\'' '\''z'\'''

echo '$ json '\''b ~b'\'' '\''a'\'''
json 'b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''a'\'''

echo '$ json '\''b ~b'\'' '\''b'\'''
json 'b ~b' 'b' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''b'\'''

echo '$ json '\''b ~b'\'' '\''c'\'''
json 'b ~b' 'c' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''c'\'''

echo '$ json '\''b ~b'\'' '\''a,b'\'''
json 'b ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''a,b'\'''

echo '$ json '\''b ~b'\'' '\''a,c'\'''
json 'b ~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''a,c'\'''

echo '$ json '\''b ~b'\'' '\''b,c'\'''
json 'b ~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''b,c'\'''

echo '$ json '\''b ~b'\'' '\''a,b,c'\'''
json 'b ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''a,b,c'\'''

echo '$ json '\''b ~b'\'' '\''z'\'''
json 'b ~b' 'z' 2>&1 ||
echo 'command failed: json '\''b ~b'\'' '\''z'\'''

echo '$ json '\''b c'\'' '\''a'\'''
json 'b c' 'a' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''a'\'''

echo '$ json '\''b c'\'' '\''b'\'''
json 'b c' 'b' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''b'\'''

echo '$ json '\''b c'\'' '\''c'\'''
json 'b c' 'c' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''c'\'''

echo '$ json '\''b c'\'' '\''a,b'\'''
json 'b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''a,b'\'''

echo '$ json '\''b c'\'' '\''a,c'\'''
json 'b c' 'a,c' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''a,c'\'''

echo '$ json '\''b c'\'' '\''b,c'\'''
json 'b c' 'b,c' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''b,c'\'''

echo '$ json '\''b c'\'' '\''a,b,c'\'''
json 'b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''a,b,c'\'''

echo '$ json '\''b c'\'' '\''z'\'''
json 'b c' 'z' 2>&1 ||
echo 'command failed: json '\''b c'\'' '\''z'\'''

echo '$ json '\''b ~c'\'' '\''a'\'''
json 'b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''a'\'''

echo '$ json '\''b ~c'\'' '\''b'\'''
json 'b ~c' 'b' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''b'\'''

echo '$ json '\''b ~c'\'' '\''c'\'''
json 'b ~c' 'c' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''c'\'''

echo '$ json '\''b ~c'\'' '\''a,b'\'''
json 'b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''a,b'\'''

echo '$ json '\''b ~c'\'' '\''a,c'\'''
json 'b ~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''a,c'\'''

echo '$ json '\''b ~c'\'' '\''b,c'\'''
json 'b ~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''b,c'\'''

echo '$ json '\''b ~c'\'' '\''a,b,c'\'''
json 'b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''b ~c'\'' '\''z'\'''
json 'b ~c' 'z' 2>&1 ||
echo 'command failed: json '\''b ~c'\'' '\''z'\'''

echo '$ json '\''~b a'\'' '\''a'\'''
json '~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''a'\'''

echo '$ json '\''~b a'\'' '\''b'\'''
json '~b a' 'b' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''b'\'''

echo '$ json '\''~b a'\'' '\''c'\'''
json '~b a' 'c' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''c'\'''

echo '$ json '\''~b a'\'' '\''a,b'\'''
json '~b a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''a,b'\'''

echo '$ json '\''~b a'\'' '\''a,c'\'''
json '~b a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''a,c'\'''

echo '$ json '\''~b a'\'' '\''b,c'\'''
json '~b a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''b,c'\'''

echo '$ json '\''~b a'\'' '\''a,b,c'\'''
json '~b a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''a,b,c'\'''

echo '$ json '\''~b a'\'' '\''z'\'''
json '~b a' 'z' 2>&1 ||
echo 'command failed: json '\''~b a'\'' '\''z'\'''

echo '$ json '\''~b ~a'\'' '\''a'\'''
json '~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''a'\'''

echo '$ json '\''~b ~a'\'' '\''b'\'''
json '~b ~a' 'b' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''b'\'''

echo '$ json '\''~b ~a'\'' '\''c'\'''
json '~b ~a' 'c' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''c'\'''

echo '$ json '\''~b ~a'\'' '\''a,b'\'''
json '~b ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''a,b'\'''

echo '$ json '\''~b ~a'\'' '\''a,c'\'''
json '~b ~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''a,c'\'''

echo '$ json '\''~b ~a'\'' '\''b,c'\'''
json '~b ~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''b,c'\'''

echo '$ json '\''~b ~a'\'' '\''a,b,c'\'''
json '~b ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~a'\'' '\''z'\'''
json '~b ~a' 'z' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'' '\''z'\'''

echo '$ json '\''~b b'\'' '\''a'\'''
json '~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''a'\'''

echo '$ json '\''~b b'\'' '\''b'\'''
json '~b b' 'b' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''b'\'''

echo '$ json '\''~b b'\'' '\''c'\'''
json '~b b' 'c' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''c'\'''

echo '$ json '\''~b b'\'' '\''a,b'\'''
json '~b b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''a,b'\'''

echo '$ json '\''~b b'\'' '\''a,c'\'''
json '~b b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''a,c'\'''

echo '$ json '\''~b b'\'' '\''b,c'\'''
json '~b b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''b,c'\'''

echo '$ json '\''~b b'\'' '\''a,b,c'\'''
json '~b b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''a,b,c'\'''

echo '$ json '\''~b b'\'' '\''z'\'''
json '~b b' 'z' 2>&1 ||
echo 'command failed: json '\''~b b'\'' '\''z'\'''

echo '$ json '\''~b c'\'' '\''a'\'''
json '~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''a'\'''

echo '$ json '\''~b c'\'' '\''b'\'''
json '~b c' 'b' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''b'\'''

echo '$ json '\''~b c'\'' '\''c'\'''
json '~b c' 'c' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''c'\'''

echo '$ json '\''~b c'\'' '\''a,b'\'''
json '~b c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''a,b'\'''

echo '$ json '\''~b c'\'' '\''a,c'\'''
json '~b c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''a,c'\'''

echo '$ json '\''~b c'\'' '\''b,c'\'''
json '~b c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''b,c'\'''

echo '$ json '\''~b c'\'' '\''a,b,c'\'''
json '~b c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''a,b,c'\'''

echo '$ json '\''~b c'\'' '\''z'\'''
json '~b c' 'z' 2>&1 ||
echo 'command failed: json '\''~b c'\'' '\''z'\'''

echo '$ json '\''~b ~c'\'' '\''a'\'''
json '~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''a'\'''

echo '$ json '\''~b ~c'\'' '\''b'\'''
json '~b ~c' 'b' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''b'\'''

echo '$ json '\''~b ~c'\'' '\''c'\'''
json '~b ~c' 'c' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''c'\'''

echo '$ json '\''~b ~c'\'' '\''a,b'\'''
json '~b ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''a,b'\'''

echo '$ json '\''~b ~c'\'' '\''a,c'\'''
json '~b ~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''a,c'\'''

echo '$ json '\''~b ~c'\'' '\''b,c'\'''
json '~b ~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''b,c'\'''

echo '$ json '\''~b ~c'\'' '\''a,b,c'\'''
json '~b ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b ~c'\'' '\''z'\'''
json '~b ~c' 'z' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'' '\''z'\'''

echo '$ json '\''c a'\'' '\''a'\'''
json 'c a' 'a' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''a'\'''

echo '$ json '\''c a'\'' '\''b'\'''
json 'c a' 'b' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''b'\'''

echo '$ json '\''c a'\'' '\''c'\'''
json 'c a' 'c' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''c'\'''

echo '$ json '\''c a'\'' '\''a,b'\'''
json 'c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''a,b'\'''

echo '$ json '\''c a'\'' '\''a,c'\'''
json 'c a' 'a,c' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''a,c'\'''

echo '$ json '\''c a'\'' '\''b,c'\'''
json 'c a' 'b,c' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''b,c'\'''

echo '$ json '\''c a'\'' '\''a,b,c'\'''
json 'c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''a,b,c'\'''

echo '$ json '\''c a'\'' '\''z'\'''
json 'c a' 'z' 2>&1 ||
echo 'command failed: json '\''c a'\'' '\''z'\'''

echo '$ json '\''c ~a'\'' '\''a'\'''
json 'c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''a'\'''

echo '$ json '\''c ~a'\'' '\''b'\'''
json 'c ~a' 'b' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''b'\'''

echo '$ json '\''c ~a'\'' '\''c'\'''
json 'c ~a' 'c' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''c'\'''

echo '$ json '\''c ~a'\'' '\''a,b'\'''
json 'c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''a,b'\'''

echo '$ json '\''c ~a'\'' '\''a,c'\'''
json 'c ~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''a,c'\'''

echo '$ json '\''c ~a'\'' '\''b,c'\'''
json 'c ~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''b,c'\'''

echo '$ json '\''c ~a'\'' '\''a,b,c'\'''
json 'c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''c ~a'\'' '\''z'\'''
json 'c ~a' 'z' 2>&1 ||
echo 'command failed: json '\''c ~a'\'' '\''z'\'''

echo '$ json '\''c b'\'' '\''a'\'''
json 'c b' 'a' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''a'\'''

echo '$ json '\''c b'\'' '\''b'\'''
json 'c b' 'b' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''b'\'''

echo '$ json '\''c b'\'' '\''c'\'''
json 'c b' 'c' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''c'\'''

echo '$ json '\''c b'\'' '\''a,b'\'''
json 'c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''a,b'\'''

echo '$ json '\''c b'\'' '\''a,c'\'''
json 'c b' 'a,c' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''a,c'\'''

echo '$ json '\''c b'\'' '\''b,c'\'''
json 'c b' 'b,c' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''b,c'\'''

echo '$ json '\''c b'\'' '\''a,b,c'\'''
json 'c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''a,b,c'\'''

echo '$ json '\''c b'\'' '\''z'\'''
json 'c b' 'z' 2>&1 ||
echo 'command failed: json '\''c b'\'' '\''z'\'''

echo '$ json '\''c ~b'\'' '\''a'\'''
json 'c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''a'\'''

echo '$ json '\''c ~b'\'' '\''b'\'''
json 'c ~b' 'b' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''b'\'''

echo '$ json '\''c ~b'\'' '\''c'\'''
json 'c ~b' 'c' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''c'\'''

echo '$ json '\''c ~b'\'' '\''a,b'\'''
json 'c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''a,b'\'''

echo '$ json '\''c ~b'\'' '\''a,c'\'''
json 'c ~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''a,c'\'''

echo '$ json '\''c ~b'\'' '\''b,c'\'''
json 'c ~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''b,c'\'''

echo '$ json '\''c ~b'\'' '\''a,b,c'\'''
json 'c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''c ~b'\'' '\''z'\'''
json 'c ~b' 'z' 2>&1 ||
echo 'command failed: json '\''c ~b'\'' '\''z'\'''

echo '$ json '\''c ~c'\'' '\''a'\'''
json 'c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''a'\'''

echo '$ json '\''c ~c'\'' '\''b'\'''
json 'c ~c' 'b' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''b'\'''

echo '$ json '\''c ~c'\'' '\''c'\'''
json 'c ~c' 'c' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''c'\'''

echo '$ json '\''c ~c'\'' '\''a,b'\'''
json 'c ~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''a,b'\'''

echo '$ json '\''c ~c'\'' '\''a,c'\'''
json 'c ~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''a,c'\'''

echo '$ json '\''c ~c'\'' '\''b,c'\'''
json 'c ~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''b,c'\'''

echo '$ json '\''c ~c'\'' '\''a,b,c'\'''
json 'c ~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''a,b,c'\'''

echo '$ json '\''c ~c'\'' '\''z'\'''
json 'c ~c' 'z' 2>&1 ||
echo 'command failed: json '\''c ~c'\'' '\''z'\'''

echo '$ json '\''~c a'\'' '\''a'\'''
json '~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''a'\'''

echo '$ json '\''~c a'\'' '\''b'\'''
json '~c a' 'b' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''b'\'''

echo '$ json '\''~c a'\'' '\''c'\'''
json '~c a' 'c' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''c'\'''

echo '$ json '\''~c a'\'' '\''a,b'\'''
json '~c a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''a,b'\'''

echo '$ json '\''~c a'\'' '\''a,c'\'''
json '~c a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''a,c'\'''

echo '$ json '\''~c a'\'' '\''b,c'\'''
json '~c a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''b,c'\'''

echo '$ json '\''~c a'\'' '\''a,b,c'\'''
json '~c a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''a,b,c'\'''

echo '$ json '\''~c a'\'' '\''z'\'''
json '~c a' 'z' 2>&1 ||
echo 'command failed: json '\''~c a'\'' '\''z'\'''

echo '$ json '\''~c ~a'\'' '\''a'\'''
json '~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''a'\'''

echo '$ json '\''~c ~a'\'' '\''b'\'''
json '~c ~a' 'b' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''b'\'''

echo '$ json '\''~c ~a'\'' '\''c'\'''
json '~c ~a' 'c' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''c'\'''

echo '$ json '\''~c ~a'\'' '\''a,b'\'''
json '~c ~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''a,b'\'''

echo '$ json '\''~c ~a'\'' '\''a,c'\'''
json '~c ~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''a,c'\'''

echo '$ json '\''~c ~a'\'' '\''b,c'\'''
json '~c ~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''b,c'\'''

echo '$ json '\''~c ~a'\'' '\''a,b,c'\'''
json '~c ~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~a'\'' '\''z'\'''
json '~c ~a' 'z' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'' '\''z'\'''

echo '$ json '\''~c b'\'' '\''a'\'''
json '~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''a'\'''

echo '$ json '\''~c b'\'' '\''b'\'''
json '~c b' 'b' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''b'\'''

echo '$ json '\''~c b'\'' '\''c'\'''
json '~c b' 'c' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''c'\'''

echo '$ json '\''~c b'\'' '\''a,b'\'''
json '~c b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''a,b'\'''

echo '$ json '\''~c b'\'' '\''a,c'\'''
json '~c b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''a,c'\'''

echo '$ json '\''~c b'\'' '\''b,c'\'''
json '~c b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''b,c'\'''

echo '$ json '\''~c b'\'' '\''a,b,c'\'''
json '~c b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''a,b,c'\'''

echo '$ json '\''~c b'\'' '\''z'\'''
json '~c b' 'z' 2>&1 ||
echo 'command failed: json '\''~c b'\'' '\''z'\'''

echo '$ json '\''~c ~b'\'' '\''a'\'''
json '~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''a'\'''

echo '$ json '\''~c ~b'\'' '\''b'\'''
json '~c ~b' 'b' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''b'\'''

echo '$ json '\''~c ~b'\'' '\''c'\'''
json '~c ~b' 'c' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''c'\'''

echo '$ json '\''~c ~b'\'' '\''a,b'\'''
json '~c ~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''a,b'\'''

echo '$ json '\''~c ~b'\'' '\''a,c'\'''
json '~c ~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''a,c'\'''

echo '$ json '\''~c ~b'\'' '\''b,c'\'''
json '~c ~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''b,c'\'''

echo '$ json '\''~c ~b'\'' '\''a,b,c'\'''
json '~c ~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c ~b'\'' '\''z'\'''
json '~c ~b' 'z' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'' '\''z'\'''

echo '$ json '\''~c c'\'' '\''a'\'''
json '~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''a'\'''

echo '$ json '\''~c c'\'' '\''b'\'''
json '~c c' 'b' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''b'\'''

echo '$ json '\''~c c'\'' '\''c'\'''
json '~c c' 'c' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''c'\'''

echo '$ json '\''~c c'\'' '\''a,b'\'''
json '~c c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''a,b'\'''

echo '$ json '\''~c c'\'' '\''a,c'\'''
json '~c c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''a,c'\'''

echo '$ json '\''~c c'\'' '\''b,c'\'''
json '~c c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''b,c'\'''

echo '$ json '\''~c c'\'' '\''a,b,c'\'''
json '~c c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''a,b,c'\'''

echo '$ json '\''~c c'\'' '\''z'\'''
json '~c c' 'z' 2>&1 ||
echo 'command failed: json '\''~c c'\'' '\''z'\'''

echo '$ json '\''a|~a'\'' '\''a'\'''
json 'a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''a'\'''

echo '$ json '\''a|~a'\'' '\''b'\'''
json 'a|~a' 'b' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''b'\'''

echo '$ json '\''a|~a'\'' '\''c'\'''
json 'a|~a' 'c' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''c'\'''

echo '$ json '\''a|~a'\'' '\''a,b'\'''
json 'a|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''a,b'\'''

echo '$ json '\''a|~a'\'' '\''a,c'\'''
json 'a|~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''a,c'\'''

echo '$ json '\''a|~a'\'' '\''b,c'\'''
json 'a|~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''b,c'\'''

echo '$ json '\''a|~a'\'' '\''a,b,c'\'''
json 'a|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''a,b,c'\'''

echo '$ json '\''a|~a'\'' '\''z'\'''
json 'a|~a' 'z' 2>&1 ||
echo 'command failed: json '\''a|~a'\'' '\''z'\'''

echo '$ json '\''a|b'\'' '\''a'\'''
json 'a|b' 'a' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''a'\'''

echo '$ json '\''a|b'\'' '\''b'\'''
json 'a|b' 'b' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''b'\'''

echo '$ json '\''a|b'\'' '\''c'\'''
json 'a|b' 'c' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''c'\'''

echo '$ json '\''a|b'\'' '\''a,b'\'''
json 'a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''a,b'\'''

echo '$ json '\''a|b'\'' '\''a,c'\'''
json 'a|b' 'a,c' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''a,c'\'''

echo '$ json '\''a|b'\'' '\''b,c'\'''
json 'a|b' 'b,c' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''b,c'\'''

echo '$ json '\''a|b'\'' '\''a,b,c'\'''
json 'a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''a,b,c'\'''

echo '$ json '\''a|b'\'' '\''z'\'''
json 'a|b' 'z' 2>&1 ||
echo 'command failed: json '\''a|b'\'' '\''z'\'''

echo '$ json '\''a|~b'\'' '\''a'\'''
json 'a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''a'\'''

echo '$ json '\''a|~b'\'' '\''b'\'''
json 'a|~b' 'b' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''b'\'''

echo '$ json '\''a|~b'\'' '\''c'\'''
json 'a|~b' 'c' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''c'\'''

echo '$ json '\''a|~b'\'' '\''a,b'\'''
json 'a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''a,b'\'''

echo '$ json '\''a|~b'\'' '\''a,c'\'''
json 'a|~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''a,c'\'''

echo '$ json '\''a|~b'\'' '\''b,c'\'''
json 'a|~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''b,c'\'''

echo '$ json '\''a|~b'\'' '\''a,b,c'\'''
json 'a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''a|~b'\'' '\''z'\'''
json 'a|~b' 'z' 2>&1 ||
echo 'command failed: json '\''a|~b'\'' '\''z'\'''

echo '$ json '\''a|c'\'' '\''a'\'''
json 'a|c' 'a' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''a'\'''

echo '$ json '\''a|c'\'' '\''b'\'''
json 'a|c' 'b' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''b'\'''

echo '$ json '\''a|c'\'' '\''c'\'''
json 'a|c' 'c' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''c'\'''

echo '$ json '\''a|c'\'' '\''a,b'\'''
json 'a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''a,b'\'''

echo '$ json '\''a|c'\'' '\''a,c'\'''
json 'a|c' 'a,c' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''a,c'\'''

echo '$ json '\''a|c'\'' '\''b,c'\'''
json 'a|c' 'b,c' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''b,c'\'''

echo '$ json '\''a|c'\'' '\''a,b,c'\'''
json 'a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''a,b,c'\'''

echo '$ json '\''a|c'\'' '\''z'\'''
json 'a|c' 'z' 2>&1 ||
echo 'command failed: json '\''a|c'\'' '\''z'\'''

echo '$ json '\''a|~c'\'' '\''a'\'''
json 'a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''a'\'''

echo '$ json '\''a|~c'\'' '\''b'\'''
json 'a|~c' 'b' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''b'\'''

echo '$ json '\''a|~c'\'' '\''c'\'''
json 'a|~c' 'c' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''c'\'''

echo '$ json '\''a|~c'\'' '\''a,b'\'''
json 'a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''a,b'\'''

echo '$ json '\''a|~c'\'' '\''a,c'\'''
json 'a|~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''a,c'\'''

echo '$ json '\''a|~c'\'' '\''b,c'\'''
json 'a|~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''b,c'\'''

echo '$ json '\''a|~c'\'' '\''a,b,c'\'''
json 'a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''a|~c'\'' '\''z'\'''
json 'a|~c' 'z' 2>&1 ||
echo 'command failed: json '\''a|~c'\'' '\''z'\'''

echo '$ json '\''~a|a'\'' '\''a'\'''
json '~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''a'\'''

echo '$ json '\''~a|a'\'' '\''b'\'''
json '~a|a' 'b' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''b'\'''

echo '$ json '\''~a|a'\'' '\''c'\'''
json '~a|a' 'c' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''c'\'''

echo '$ json '\''~a|a'\'' '\''a,b'\'''
json '~a|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''a,b'\'''

echo '$ json '\''~a|a'\'' '\''a,c'\'''
json '~a|a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''a,c'\'''

echo '$ json '\''~a|a'\'' '\''b,c'\'''
json '~a|a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''b,c'\'''

echo '$ json '\''~a|a'\'' '\''a,b,c'\'''
json '~a|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''a,b,c'\'''

echo '$ json '\''~a|a'\'' '\''z'\'''
json '~a|a' 'z' 2>&1 ||
echo 'command failed: json '\''~a|a'\'' '\''z'\'''

echo '$ json '\''~a|b'\'' '\''a'\'''
json '~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''a'\'''

echo '$ json '\''~a|b'\'' '\''b'\'''
json '~a|b' 'b' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''b'\'''

echo '$ json '\''~a|b'\'' '\''c'\'''
json '~a|b' 'c' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''c'\'''

echo '$ json '\''~a|b'\'' '\''a,b'\'''
json '~a|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''a,b'\'''

echo '$ json '\''~a|b'\'' '\''a,c'\'''
json '~a|b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''a,c'\'''

echo '$ json '\''~a|b'\'' '\''b,c'\'''
json '~a|b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''b,c'\'''

echo '$ json '\''~a|b'\'' '\''a,b,c'\'''
json '~a|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|b'\'' '\''z'\'''
json '~a|b' 'z' 2>&1 ||
echo 'command failed: json '\''~a|b'\'' '\''z'\'''

echo '$ json '\''~a|~b'\'' '\''a'\'''
json '~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''a'\'''

echo '$ json '\''~a|~b'\'' '\''b'\'''
json '~a|~b' 'b' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''b'\'''

echo '$ json '\''~a|~b'\'' '\''c'\'''
json '~a|~b' 'c' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''c'\'''

echo '$ json '\''~a|~b'\'' '\''a,b'\'''
json '~a|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''a,b'\'''

echo '$ json '\''~a|~b'\'' '\''a,c'\'''
json '~a|~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''a,c'\'''

echo '$ json '\''~a|~b'\'' '\''b,c'\'''
json '~a|~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''b,c'\'''

echo '$ json '\''~a|~b'\'' '\''a,b,c'\'''
json '~a|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~b'\'' '\''z'\'''
json '~a|~b' 'z' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'' '\''z'\'''

echo '$ json '\''~a|c'\'' '\''a'\'''
json '~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''a'\'''

echo '$ json '\''~a|c'\'' '\''b'\'''
json '~a|c' 'b' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''b'\'''

echo '$ json '\''~a|c'\'' '\''c'\'''
json '~a|c' 'c' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''c'\'''

echo '$ json '\''~a|c'\'' '\''a,b'\'''
json '~a|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''a,b'\'''

echo '$ json '\''~a|c'\'' '\''a,c'\'''
json '~a|c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''a,c'\'''

echo '$ json '\''~a|c'\'' '\''b,c'\'''
json '~a|c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''b,c'\'''

echo '$ json '\''~a|c'\'' '\''a,b,c'\'''
json '~a|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|c'\'' '\''z'\'''
json '~a|c' 'z' 2>&1 ||
echo 'command failed: json '\''~a|c'\'' '\''z'\'''

echo '$ json '\''~a|~c'\'' '\''a'\'''
json '~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''a'\'''

echo '$ json '\''~a|~c'\'' '\''b'\'''
json '~a|~c' 'b' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''b'\'''

echo '$ json '\''~a|~c'\'' '\''c'\'''
json '~a|~c' 'c' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''c'\'''

echo '$ json '\''~a|~c'\'' '\''a,b'\'''
json '~a|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''a,b'\'''

echo '$ json '\''~a|~c'\'' '\''a,c'\'''
json '~a|~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''a,c'\'''

echo '$ json '\''~a|~c'\'' '\''b,c'\'''
json '~a|~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''b,c'\'''

echo '$ json '\''~a|~c'\'' '\''a,b,c'\'''
json '~a|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a|~c'\'' '\''z'\'''
json '~a|~c' 'z' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'' '\''z'\'''

echo '$ json '\''b|a'\'' '\''a'\'''
json 'b|a' 'a' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''a'\'''

echo '$ json '\''b|a'\'' '\''b'\'''
json 'b|a' 'b' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''b'\'''

echo '$ json '\''b|a'\'' '\''c'\'''
json 'b|a' 'c' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''c'\'''

echo '$ json '\''b|a'\'' '\''a,b'\'''
json 'b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''a,b'\'''

echo '$ json '\''b|a'\'' '\''a,c'\'''
json 'b|a' 'a,c' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''a,c'\'''

echo '$ json '\''b|a'\'' '\''b,c'\'''
json 'b|a' 'b,c' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''b,c'\'''

echo '$ json '\''b|a'\'' '\''a,b,c'\'''
json 'b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''a,b,c'\'''

echo '$ json '\''b|a'\'' '\''z'\'''
json 'b|a' 'z' 2>&1 ||
echo 'command failed: json '\''b|a'\'' '\''z'\'''

echo '$ json '\''b|~a'\'' '\''a'\'''
json 'b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''a'\'''

echo '$ json '\''b|~a'\'' '\''b'\'''
json 'b|~a' 'b' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''b'\'''

echo '$ json '\''b|~a'\'' '\''c'\'''
json 'b|~a' 'c' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''c'\'''

echo '$ json '\''b|~a'\'' '\''a,b'\'''
json 'b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''a,b'\'''

echo '$ json '\''b|~a'\'' '\''a,c'\'''
json 'b|~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''a,c'\'''

echo '$ json '\''b|~a'\'' '\''b,c'\'''
json 'b|~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''b,c'\'''

echo '$ json '\''b|~a'\'' '\''a,b,c'\'''
json 'b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''b|~a'\'' '\''z'\'''
json 'b|~a' 'z' 2>&1 ||
echo 'command failed: json '\''b|~a'\'' '\''z'\'''

echo '$ json '\''b|~b'\'' '\''a'\'''
json 'b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''a'\'''

echo '$ json '\''b|~b'\'' '\''b'\'''
json 'b|~b' 'b' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''b'\'''

echo '$ json '\''b|~b'\'' '\''c'\'''
json 'b|~b' 'c' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''c'\'''

echo '$ json '\''b|~b'\'' '\''a,b'\'''
json 'b|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''a,b'\'''

echo '$ json '\''b|~b'\'' '\''a,c'\'''
json 'b|~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''a,c'\'''

echo '$ json '\''b|~b'\'' '\''b,c'\'''
json 'b|~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''b,c'\'''

echo '$ json '\''b|~b'\'' '\''a,b,c'\'''
json 'b|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''a,b,c'\'''

echo '$ json '\''b|~b'\'' '\''z'\'''
json 'b|~b' 'z' 2>&1 ||
echo 'command failed: json '\''b|~b'\'' '\''z'\'''

echo '$ json '\''b|c'\'' '\''a'\'''
json 'b|c' 'a' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''a'\'''

echo '$ json '\''b|c'\'' '\''b'\'''
json 'b|c' 'b' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''b'\'''

echo '$ json '\''b|c'\'' '\''c'\'''
json 'b|c' 'c' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''c'\'''

echo '$ json '\''b|c'\'' '\''a,b'\'''
json 'b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''a,b'\'''

echo '$ json '\''b|c'\'' '\''a,c'\'''
json 'b|c' 'a,c' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''a,c'\'''

echo '$ json '\''b|c'\'' '\''b,c'\'''
json 'b|c' 'b,c' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''b,c'\'''

echo '$ json '\''b|c'\'' '\''a,b,c'\'''
json 'b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''a,b,c'\'''

echo '$ json '\''b|c'\'' '\''z'\'''
json 'b|c' 'z' 2>&1 ||
echo 'command failed: json '\''b|c'\'' '\''z'\'''

echo '$ json '\''b|~c'\'' '\''a'\'''
json 'b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''a'\'''

echo '$ json '\''b|~c'\'' '\''b'\'''
json 'b|~c' 'b' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''b'\'''

echo '$ json '\''b|~c'\'' '\''c'\'''
json 'b|~c' 'c' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''c'\'''

echo '$ json '\''b|~c'\'' '\''a,b'\'''
json 'b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''a,b'\'''

echo '$ json '\''b|~c'\'' '\''a,c'\'''
json 'b|~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''a,c'\'''

echo '$ json '\''b|~c'\'' '\''b,c'\'''
json 'b|~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''b,c'\'''

echo '$ json '\''b|~c'\'' '\''a,b,c'\'''
json 'b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''b|~c'\'' '\''z'\'''
json 'b|~c' 'z' 2>&1 ||
echo 'command failed: json '\''b|~c'\'' '\''z'\'''

echo '$ json '\''~b|a'\'' '\''a'\'''
json '~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''a'\'''

echo '$ json '\''~b|a'\'' '\''b'\'''
json '~b|a' 'b' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''b'\'''

echo '$ json '\''~b|a'\'' '\''c'\'''
json '~b|a' 'c' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''c'\'''

echo '$ json '\''~b|a'\'' '\''a,b'\'''
json '~b|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''a,b'\'''

echo '$ json '\''~b|a'\'' '\''a,c'\'''
json '~b|a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''a,c'\'''

echo '$ json '\''~b|a'\'' '\''b,c'\'''
json '~b|a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''b,c'\'''

echo '$ json '\''~b|a'\'' '\''a,b,c'\'''
json '~b|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|a'\'' '\''z'\'''
json '~b|a' 'z' 2>&1 ||
echo 'command failed: json '\''~b|a'\'' '\''z'\'''

echo '$ json '\''~b|~a'\'' '\''a'\'''
json '~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''a'\'''

echo '$ json '\''~b|~a'\'' '\''b'\'''
json '~b|~a' 'b' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''b'\'''

echo '$ json '\''~b|~a'\'' '\''c'\'''
json '~b|~a' 'c' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''c'\'''

echo '$ json '\''~b|~a'\'' '\''a,b'\'''
json '~b|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''a,b'\'''

echo '$ json '\''~b|~a'\'' '\''a,c'\'''
json '~b|~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''a,c'\'''

echo '$ json '\''~b|~a'\'' '\''b,c'\'''
json '~b|~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''b,c'\'''

echo '$ json '\''~b|~a'\'' '\''a,b,c'\'''
json '~b|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~a'\'' '\''z'\'''
json '~b|~a' 'z' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'' '\''z'\'''

echo '$ json '\''~b|b'\'' '\''a'\'''
json '~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''a'\'''

echo '$ json '\''~b|b'\'' '\''b'\'''
json '~b|b' 'b' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''b'\'''

echo '$ json '\''~b|b'\'' '\''c'\'''
json '~b|b' 'c' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''c'\'''

echo '$ json '\''~b|b'\'' '\''a,b'\'''
json '~b|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''a,b'\'''

echo '$ json '\''~b|b'\'' '\''a,c'\'''
json '~b|b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''a,c'\'''

echo '$ json '\''~b|b'\'' '\''b,c'\'''
json '~b|b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''b,c'\'''

echo '$ json '\''~b|b'\'' '\''a,b,c'\'''
json '~b|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''a,b,c'\'''

echo '$ json '\''~b|b'\'' '\''z'\'''
json '~b|b' 'z' 2>&1 ||
echo 'command failed: json '\''~b|b'\'' '\''z'\'''

echo '$ json '\''~b|c'\'' '\''a'\'''
json '~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''a'\'''

echo '$ json '\''~b|c'\'' '\''b'\'''
json '~b|c' 'b' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''b'\'''

echo '$ json '\''~b|c'\'' '\''c'\'''
json '~b|c' 'c' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''c'\'''

echo '$ json '\''~b|c'\'' '\''a,b'\'''
json '~b|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''a,b'\'''

echo '$ json '\''~b|c'\'' '\''a,c'\'''
json '~b|c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''a,c'\'''

echo '$ json '\''~b|c'\'' '\''b,c'\'''
json '~b|c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''b,c'\'''

echo '$ json '\''~b|c'\'' '\''a,b,c'\'''
json '~b|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|c'\'' '\''z'\'''
json '~b|c' 'z' 2>&1 ||
echo 'command failed: json '\''~b|c'\'' '\''z'\'''

echo '$ json '\''~b|~c'\'' '\''a'\'''
json '~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''a'\'''

echo '$ json '\''~b|~c'\'' '\''b'\'''
json '~b|~c' 'b' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''b'\'''

echo '$ json '\''~b|~c'\'' '\''c'\'''
json '~b|~c' 'c' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''c'\'''

echo '$ json '\''~b|~c'\'' '\''a,b'\'''
json '~b|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''a,b'\'''

echo '$ json '\''~b|~c'\'' '\''a,c'\'''
json '~b|~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''a,c'\'''

echo '$ json '\''~b|~c'\'' '\''b,c'\'''
json '~b|~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''b,c'\'''

echo '$ json '\''~b|~c'\'' '\''a,b,c'\'''
json '~b|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b|~c'\'' '\''z'\'''
json '~b|~c' 'z' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'' '\''z'\'''

echo '$ json '\''c|a'\'' '\''a'\'''
json 'c|a' 'a' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''a'\'''

echo '$ json '\''c|a'\'' '\''b'\'''
json 'c|a' 'b' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''b'\'''

echo '$ json '\''c|a'\'' '\''c'\'''
json 'c|a' 'c' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''c'\'''

echo '$ json '\''c|a'\'' '\''a,b'\'''
json 'c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''a,b'\'''

echo '$ json '\''c|a'\'' '\''a,c'\'''
json 'c|a' 'a,c' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''a,c'\'''

echo '$ json '\''c|a'\'' '\''b,c'\'''
json 'c|a' 'b,c' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''b,c'\'''

echo '$ json '\''c|a'\'' '\''a,b,c'\'''
json 'c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''a,b,c'\'''

echo '$ json '\''c|a'\'' '\''z'\'''
json 'c|a' 'z' 2>&1 ||
echo 'command failed: json '\''c|a'\'' '\''z'\'''

echo '$ json '\''c|~a'\'' '\''a'\'''
json 'c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''a'\'''

echo '$ json '\''c|~a'\'' '\''b'\'''
json 'c|~a' 'b' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''b'\'''

echo '$ json '\''c|~a'\'' '\''c'\'''
json 'c|~a' 'c' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''c'\'''

echo '$ json '\''c|~a'\'' '\''a,b'\'''
json 'c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''a,b'\'''

echo '$ json '\''c|~a'\'' '\''a,c'\'''
json 'c|~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''a,c'\'''

echo '$ json '\''c|~a'\'' '\''b,c'\'''
json 'c|~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''b,c'\'''

echo '$ json '\''c|~a'\'' '\''a,b,c'\'''
json 'c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''c|~a'\'' '\''z'\'''
json 'c|~a' 'z' 2>&1 ||
echo 'command failed: json '\''c|~a'\'' '\''z'\'''

echo '$ json '\''c|b'\'' '\''a'\'''
json 'c|b' 'a' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''a'\'''

echo '$ json '\''c|b'\'' '\''b'\'''
json 'c|b' 'b' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''b'\'''

echo '$ json '\''c|b'\'' '\''c'\'''
json 'c|b' 'c' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''c'\'''

echo '$ json '\''c|b'\'' '\''a,b'\'''
json 'c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''a,b'\'''

echo '$ json '\''c|b'\'' '\''a,c'\'''
json 'c|b' 'a,c' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''a,c'\'''

echo '$ json '\''c|b'\'' '\''b,c'\'''
json 'c|b' 'b,c' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''b,c'\'''

echo '$ json '\''c|b'\'' '\''a,b,c'\'''
json 'c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''a,b,c'\'''

echo '$ json '\''c|b'\'' '\''z'\'''
json 'c|b' 'z' 2>&1 ||
echo 'command failed: json '\''c|b'\'' '\''z'\'''

echo '$ json '\''c|~b'\'' '\''a'\'''
json 'c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''a'\'''

echo '$ json '\''c|~b'\'' '\''b'\'''
json 'c|~b' 'b' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''b'\'''

echo '$ json '\''c|~b'\'' '\''c'\'''
json 'c|~b' 'c' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''c'\'''

echo '$ json '\''c|~b'\'' '\''a,b'\'''
json 'c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''a,b'\'''

echo '$ json '\''c|~b'\'' '\''a,c'\'''
json 'c|~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''a,c'\'''

echo '$ json '\''c|~b'\'' '\''b,c'\'''
json 'c|~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''b,c'\'''

echo '$ json '\''c|~b'\'' '\''a,b,c'\'''
json 'c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''c|~b'\'' '\''z'\'''
json 'c|~b' 'z' 2>&1 ||
echo 'command failed: json '\''c|~b'\'' '\''z'\'''

echo '$ json '\''c|~c'\'' '\''a'\'''
json 'c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''a'\'''

echo '$ json '\''c|~c'\'' '\''b'\'''
json 'c|~c' 'b' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''b'\'''

echo '$ json '\''c|~c'\'' '\''c'\'''
json 'c|~c' 'c' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''c'\'''

echo '$ json '\''c|~c'\'' '\''a,b'\'''
json 'c|~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''a,b'\'''

echo '$ json '\''c|~c'\'' '\''a,c'\'''
json 'c|~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''a,c'\'''

echo '$ json '\''c|~c'\'' '\''b,c'\'''
json 'c|~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''b,c'\'''

echo '$ json '\''c|~c'\'' '\''a,b,c'\'''
json 'c|~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''a,b,c'\'''

echo '$ json '\''c|~c'\'' '\''z'\'''
json 'c|~c' 'z' 2>&1 ||
echo 'command failed: json '\''c|~c'\'' '\''z'\'''

echo '$ json '\''~c|a'\'' '\''a'\'''
json '~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''a'\'''

echo '$ json '\''~c|a'\'' '\''b'\'''
json '~c|a' 'b' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''b'\'''

echo '$ json '\''~c|a'\'' '\''c'\'''
json '~c|a' 'c' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''c'\'''

echo '$ json '\''~c|a'\'' '\''a,b'\'''
json '~c|a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''a,b'\'''

echo '$ json '\''~c|a'\'' '\''a,c'\'''
json '~c|a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''a,c'\'''

echo '$ json '\''~c|a'\'' '\''b,c'\'''
json '~c|a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''b,c'\'''

echo '$ json '\''~c|a'\'' '\''a,b,c'\'''
json '~c|a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|a'\'' '\''z'\'''
json '~c|a' 'z' 2>&1 ||
echo 'command failed: json '\''~c|a'\'' '\''z'\'''

echo '$ json '\''~c|~a'\'' '\''a'\'''
json '~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''a'\'''

echo '$ json '\''~c|~a'\'' '\''b'\'''
json '~c|~a' 'b' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''b'\'''

echo '$ json '\''~c|~a'\'' '\''c'\'''
json '~c|~a' 'c' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''c'\'''

echo '$ json '\''~c|~a'\'' '\''a,b'\'''
json '~c|~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''a,b'\'''

echo '$ json '\''~c|~a'\'' '\''a,c'\'''
json '~c|~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''a,c'\'''

echo '$ json '\''~c|~a'\'' '\''b,c'\'''
json '~c|~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''b,c'\'''

echo '$ json '\''~c|~a'\'' '\''a,b,c'\'''
json '~c|~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~a'\'' '\''z'\'''
json '~c|~a' 'z' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'' '\''z'\'''

echo '$ json '\''~c|b'\'' '\''a'\'''
json '~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''a'\'''

echo '$ json '\''~c|b'\'' '\''b'\'''
json '~c|b' 'b' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''b'\'''

echo '$ json '\''~c|b'\'' '\''c'\'''
json '~c|b' 'c' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''c'\'''

echo '$ json '\''~c|b'\'' '\''a,b'\'''
json '~c|b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''a,b'\'''

echo '$ json '\''~c|b'\'' '\''a,c'\'''
json '~c|b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''a,c'\'''

echo '$ json '\''~c|b'\'' '\''b,c'\'''
json '~c|b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''b,c'\'''

echo '$ json '\''~c|b'\'' '\''a,b,c'\'''
json '~c|b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|b'\'' '\''z'\'''
json '~c|b' 'z' 2>&1 ||
echo 'command failed: json '\''~c|b'\'' '\''z'\'''

echo '$ json '\''~c|~b'\'' '\''a'\'''
json '~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''a'\'''

echo '$ json '\''~c|~b'\'' '\''b'\'''
json '~c|~b' 'b' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''b'\'''

echo '$ json '\''~c|~b'\'' '\''c'\'''
json '~c|~b' 'c' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''c'\'''

echo '$ json '\''~c|~b'\'' '\''a,b'\'''
json '~c|~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''a,b'\'''

echo '$ json '\''~c|~b'\'' '\''a,c'\'''
json '~c|~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''a,c'\'''

echo '$ json '\''~c|~b'\'' '\''b,c'\'''
json '~c|~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''b,c'\'''

echo '$ json '\''~c|~b'\'' '\''a,b,c'\'''
json '~c|~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c|~b'\'' '\''z'\'''
json '~c|~b' 'z' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'' '\''z'\'''

echo '$ json '\''~c|c'\'' '\''a'\'''
json '~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''a'\'''

echo '$ json '\''~c|c'\'' '\''b'\'''
json '~c|c' 'b' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''b'\'''

echo '$ json '\''~c|c'\'' '\''c'\'''
json '~c|c' 'c' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''c'\'''

echo '$ json '\''~c|c'\'' '\''a,b'\'''
json '~c|c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''a,b'\'''

echo '$ json '\''~c|c'\'' '\''a,c'\'''
json '~c|c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''a,c'\'''

echo '$ json '\''~c|c'\'' '\''b,c'\'''
json '~c|c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''b,c'\'''

echo '$ json '\''~c|c'\'' '\''a,b,c'\'''
json '~c|c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''a,b,c'\'''

echo '$ json '\''~c|c'\'' '\''z'\'''
json '~c|c' 'z' 2>&1 ||
echo 'command failed: json '\''~c|c'\'' '\''z'\'''

echo '$ json '\''a||~a'\'' '\''a'\'''
json 'a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''a'\'''

echo '$ json '\''a||~a'\'' '\''b'\'''
json 'a||~a' 'b' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''b'\'''

echo '$ json '\''a||~a'\'' '\''c'\'''
json 'a||~a' 'c' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''c'\'''

echo '$ json '\''a||~a'\'' '\''a,b'\'''
json 'a||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''a,b'\'''

echo '$ json '\''a||~a'\'' '\''a,c'\'''
json 'a||~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''a,c'\'''

echo '$ json '\''a||~a'\'' '\''b,c'\'''
json 'a||~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''b,c'\'''

echo '$ json '\''a||~a'\'' '\''a,b,c'\'''
json 'a||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''a,b,c'\'''

echo '$ json '\''a||~a'\'' '\''z'\'''
json 'a||~a' 'z' 2>&1 ||
echo 'command failed: json '\''a||~a'\'' '\''z'\'''

echo '$ json '\''a||b'\'' '\''a'\'''
json 'a||b' 'a' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''a'\'''

echo '$ json '\''a||b'\'' '\''b'\'''
json 'a||b' 'b' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''b'\'''

echo '$ json '\''a||b'\'' '\''c'\'''
json 'a||b' 'c' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''c'\'''

echo '$ json '\''a||b'\'' '\''a,b'\'''
json 'a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''a,b'\'''

echo '$ json '\''a||b'\'' '\''a,c'\'''
json 'a||b' 'a,c' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''a,c'\'''

echo '$ json '\''a||b'\'' '\''b,c'\'''
json 'a||b' 'b,c' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''b,c'\'''

echo '$ json '\''a||b'\'' '\''a,b,c'\'''
json 'a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''a,b,c'\'''

echo '$ json '\''a||b'\'' '\''z'\'''
json 'a||b' 'z' 2>&1 ||
echo 'command failed: json '\''a||b'\'' '\''z'\'''

echo '$ json '\''a||~b'\'' '\''a'\'''
json 'a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''a'\'''

echo '$ json '\''a||~b'\'' '\''b'\'''
json 'a||~b' 'b' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''b'\'''

echo '$ json '\''a||~b'\'' '\''c'\'''
json 'a||~b' 'c' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''c'\'''

echo '$ json '\''a||~b'\'' '\''a,b'\'''
json 'a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''a,b'\'''

echo '$ json '\''a||~b'\'' '\''a,c'\'''
json 'a||~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''a,c'\'''

echo '$ json '\''a||~b'\'' '\''b,c'\'''
json 'a||~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''b,c'\'''

echo '$ json '\''a||~b'\'' '\''a,b,c'\'''
json 'a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''a||~b'\'' '\''z'\'''
json 'a||~b' 'z' 2>&1 ||
echo 'command failed: json '\''a||~b'\'' '\''z'\'''

echo '$ json '\''a||c'\'' '\''a'\'''
json 'a||c' 'a' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''a'\'''

echo '$ json '\''a||c'\'' '\''b'\'''
json 'a||c' 'b' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''b'\'''

echo '$ json '\''a||c'\'' '\''c'\'''
json 'a||c' 'c' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''c'\'''

echo '$ json '\''a||c'\'' '\''a,b'\'''
json 'a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''a,b'\'''

echo '$ json '\''a||c'\'' '\''a,c'\'''
json 'a||c' 'a,c' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''a,c'\'''

echo '$ json '\''a||c'\'' '\''b,c'\'''
json 'a||c' 'b,c' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''b,c'\'''

echo '$ json '\''a||c'\'' '\''a,b,c'\'''
json 'a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''a,b,c'\'''

echo '$ json '\''a||c'\'' '\''z'\'''
json 'a||c' 'z' 2>&1 ||
echo 'command failed: json '\''a||c'\'' '\''z'\'''

echo '$ json '\''a||~c'\'' '\''a'\'''
json 'a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''a'\'''

echo '$ json '\''a||~c'\'' '\''b'\'''
json 'a||~c' 'b' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''b'\'''

echo '$ json '\''a||~c'\'' '\''c'\'''
json 'a||~c' 'c' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''c'\'''

echo '$ json '\''a||~c'\'' '\''a,b'\'''
json 'a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''a,b'\'''

echo '$ json '\''a||~c'\'' '\''a,c'\'''
json 'a||~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''a,c'\'''

echo '$ json '\''a||~c'\'' '\''b,c'\'''
json 'a||~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''b,c'\'''

echo '$ json '\''a||~c'\'' '\''a,b,c'\'''
json 'a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''a||~c'\'' '\''z'\'''
json 'a||~c' 'z' 2>&1 ||
echo 'command failed: json '\''a||~c'\'' '\''z'\'''

echo '$ json '\''~a||a'\'' '\''a'\'''
json '~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''a'\'''

echo '$ json '\''~a||a'\'' '\''b'\'''
json '~a||a' 'b' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''b'\'''

echo '$ json '\''~a||a'\'' '\''c'\'''
json '~a||a' 'c' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''c'\'''

echo '$ json '\''~a||a'\'' '\''a,b'\'''
json '~a||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''a,b'\'''

echo '$ json '\''~a||a'\'' '\''a,c'\'''
json '~a||a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''a,c'\'''

echo '$ json '\''~a||a'\'' '\''b,c'\'''
json '~a||a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''b,c'\'''

echo '$ json '\''~a||a'\'' '\''a,b,c'\'''
json '~a||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''a,b,c'\'''

echo '$ json '\''~a||a'\'' '\''z'\'''
json '~a||a' 'z' 2>&1 ||
echo 'command failed: json '\''~a||a'\'' '\''z'\'''

echo '$ json '\''~a||b'\'' '\''a'\'''
json '~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''a'\'''

echo '$ json '\''~a||b'\'' '\''b'\'''
json '~a||b' 'b' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''b'\'''

echo '$ json '\''~a||b'\'' '\''c'\'''
json '~a||b' 'c' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''c'\'''

echo '$ json '\''~a||b'\'' '\''a,b'\'''
json '~a||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''a,b'\'''

echo '$ json '\''~a||b'\'' '\''a,c'\'''
json '~a||b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''a,c'\'''

echo '$ json '\''~a||b'\'' '\''b,c'\'''
json '~a||b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''b,c'\'''

echo '$ json '\''~a||b'\'' '\''a,b,c'\'''
json '~a||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||b'\'' '\''z'\'''
json '~a||b' 'z' 2>&1 ||
echo 'command failed: json '\''~a||b'\'' '\''z'\'''

echo '$ json '\''~a||~b'\'' '\''a'\'''
json '~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''a'\'''

echo '$ json '\''~a||~b'\'' '\''b'\'''
json '~a||~b' 'b' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''b'\'''

echo '$ json '\''~a||~b'\'' '\''c'\'''
json '~a||~b' 'c' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''c'\'''

echo '$ json '\''~a||~b'\'' '\''a,b'\'''
json '~a||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''a,b'\'''

echo '$ json '\''~a||~b'\'' '\''a,c'\'''
json '~a||~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''a,c'\'''

echo '$ json '\''~a||~b'\'' '\''b,c'\'''
json '~a||~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''b,c'\'''

echo '$ json '\''~a||~b'\'' '\''a,b,c'\'''
json '~a||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~b'\'' '\''z'\'''
json '~a||~b' 'z' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'' '\''z'\'''

echo '$ json '\''~a||c'\'' '\''a'\'''
json '~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''a'\'''

echo '$ json '\''~a||c'\'' '\''b'\'''
json '~a||c' 'b' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''b'\'''

echo '$ json '\''~a||c'\'' '\''c'\'''
json '~a||c' 'c' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''c'\'''

echo '$ json '\''~a||c'\'' '\''a,b'\'''
json '~a||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''a,b'\'''

echo '$ json '\''~a||c'\'' '\''a,c'\'''
json '~a||c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''a,c'\'''

echo '$ json '\''~a||c'\'' '\''b,c'\'''
json '~a||c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''b,c'\'''

echo '$ json '\''~a||c'\'' '\''a,b,c'\'''
json '~a||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||c'\'' '\''z'\'''
json '~a||c' 'z' 2>&1 ||
echo 'command failed: json '\''~a||c'\'' '\''z'\'''

echo '$ json '\''~a||~c'\'' '\''a'\'''
json '~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''a'\'''

echo '$ json '\''~a||~c'\'' '\''b'\'''
json '~a||~c' 'b' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''b'\'''

echo '$ json '\''~a||~c'\'' '\''c'\'''
json '~a||~c' 'c' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''c'\'''

echo '$ json '\''~a||~c'\'' '\''a,b'\'''
json '~a||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''a,b'\'''

echo '$ json '\''~a||~c'\'' '\''a,c'\'''
json '~a||~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''a,c'\'''

echo '$ json '\''~a||~c'\'' '\''b,c'\'''
json '~a||~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''b,c'\'''

echo '$ json '\''~a||~c'\'' '\''a,b,c'\'''
json '~a||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~a||~c'\'' '\''z'\'''
json '~a||~c' 'z' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'' '\''z'\'''

echo '$ json '\''b||a'\'' '\''a'\'''
json 'b||a' 'a' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''a'\'''

echo '$ json '\''b||a'\'' '\''b'\'''
json 'b||a' 'b' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''b'\'''

echo '$ json '\''b||a'\'' '\''c'\'''
json 'b||a' 'c' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''c'\'''

echo '$ json '\''b||a'\'' '\''a,b'\'''
json 'b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''a,b'\'''

echo '$ json '\''b||a'\'' '\''a,c'\'''
json 'b||a' 'a,c' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''a,c'\'''

echo '$ json '\''b||a'\'' '\''b,c'\'''
json 'b||a' 'b,c' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''b,c'\'''

echo '$ json '\''b||a'\'' '\''a,b,c'\'''
json 'b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''a,b,c'\'''

echo '$ json '\''b||a'\'' '\''z'\'''
json 'b||a' 'z' 2>&1 ||
echo 'command failed: json '\''b||a'\'' '\''z'\'''

echo '$ json '\''b||~a'\'' '\''a'\'''
json 'b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''a'\'''

echo '$ json '\''b||~a'\'' '\''b'\'''
json 'b||~a' 'b' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''b'\'''

echo '$ json '\''b||~a'\'' '\''c'\'''
json 'b||~a' 'c' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''c'\'''

echo '$ json '\''b||~a'\'' '\''a,b'\'''
json 'b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''a,b'\'''

echo '$ json '\''b||~a'\'' '\''a,c'\'''
json 'b||~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''a,c'\'''

echo '$ json '\''b||~a'\'' '\''b,c'\'''
json 'b||~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''b,c'\'''

echo '$ json '\''b||~a'\'' '\''a,b,c'\'''
json 'b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''b||~a'\'' '\''z'\'''
json 'b||~a' 'z' 2>&1 ||
echo 'command failed: json '\''b||~a'\'' '\''z'\'''

echo '$ json '\''b||~b'\'' '\''a'\'''
json 'b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''a'\'''

echo '$ json '\''b||~b'\'' '\''b'\'''
json 'b||~b' 'b' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''b'\'''

echo '$ json '\''b||~b'\'' '\''c'\'''
json 'b||~b' 'c' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''c'\'''

echo '$ json '\''b||~b'\'' '\''a,b'\'''
json 'b||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''a,b'\'''

echo '$ json '\''b||~b'\'' '\''a,c'\'''
json 'b||~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''a,c'\'''

echo '$ json '\''b||~b'\'' '\''b,c'\'''
json 'b||~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''b,c'\'''

echo '$ json '\''b||~b'\'' '\''a,b,c'\'''
json 'b||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''a,b,c'\'''

echo '$ json '\''b||~b'\'' '\''z'\'''
json 'b||~b' 'z' 2>&1 ||
echo 'command failed: json '\''b||~b'\'' '\''z'\'''

echo '$ json '\''b||c'\'' '\''a'\'''
json 'b||c' 'a' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''a'\'''

echo '$ json '\''b||c'\'' '\''b'\'''
json 'b||c' 'b' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''b'\'''

echo '$ json '\''b||c'\'' '\''c'\'''
json 'b||c' 'c' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''c'\'''

echo '$ json '\''b||c'\'' '\''a,b'\'''
json 'b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''a,b'\'''

echo '$ json '\''b||c'\'' '\''a,c'\'''
json 'b||c' 'a,c' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''a,c'\'''

echo '$ json '\''b||c'\'' '\''b,c'\'''
json 'b||c' 'b,c' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''b,c'\'''

echo '$ json '\''b||c'\'' '\''a,b,c'\'''
json 'b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''a,b,c'\'''

echo '$ json '\''b||c'\'' '\''z'\'''
json 'b||c' 'z' 2>&1 ||
echo 'command failed: json '\''b||c'\'' '\''z'\'''

echo '$ json '\''b||~c'\'' '\''a'\'''
json 'b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''a'\'''

echo '$ json '\''b||~c'\'' '\''b'\'''
json 'b||~c' 'b' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''b'\'''

echo '$ json '\''b||~c'\'' '\''c'\'''
json 'b||~c' 'c' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''c'\'''

echo '$ json '\''b||~c'\'' '\''a,b'\'''
json 'b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''a,b'\'''

echo '$ json '\''b||~c'\'' '\''a,c'\'''
json 'b||~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''a,c'\'''

echo '$ json '\''b||~c'\'' '\''b,c'\'''
json 'b||~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''b,c'\'''

echo '$ json '\''b||~c'\'' '\''a,b,c'\'''
json 'b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''b||~c'\'' '\''z'\'''
json 'b||~c' 'z' 2>&1 ||
echo 'command failed: json '\''b||~c'\'' '\''z'\'''

echo '$ json '\''~b||a'\'' '\''a'\'''
json '~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''a'\'''

echo '$ json '\''~b||a'\'' '\''b'\'''
json '~b||a' 'b' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''b'\'''

echo '$ json '\''~b||a'\'' '\''c'\'''
json '~b||a' 'c' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''c'\'''

echo '$ json '\''~b||a'\'' '\''a,b'\'''
json '~b||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''a,b'\'''

echo '$ json '\''~b||a'\'' '\''a,c'\'''
json '~b||a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''a,c'\'''

echo '$ json '\''~b||a'\'' '\''b,c'\'''
json '~b||a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''b,c'\'''

echo '$ json '\''~b||a'\'' '\''a,b,c'\'''
json '~b||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||a'\'' '\''z'\'''
json '~b||a' 'z' 2>&1 ||
echo 'command failed: json '\''~b||a'\'' '\''z'\'''

echo '$ json '\''~b||~a'\'' '\''a'\'''
json '~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''a'\'''

echo '$ json '\''~b||~a'\'' '\''b'\'''
json '~b||~a' 'b' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''b'\'''

echo '$ json '\''~b||~a'\'' '\''c'\'''
json '~b||~a' 'c' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''c'\'''

echo '$ json '\''~b||~a'\'' '\''a,b'\'''
json '~b||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''a,b'\'''

echo '$ json '\''~b||~a'\'' '\''a,c'\'''
json '~b||~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''a,c'\'''

echo '$ json '\''~b||~a'\'' '\''b,c'\'''
json '~b||~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''b,c'\'''

echo '$ json '\''~b||~a'\'' '\''a,b,c'\'''
json '~b||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~a'\'' '\''z'\'''
json '~b||~a' 'z' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'' '\''z'\'''

echo '$ json '\''~b||b'\'' '\''a'\'''
json '~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''a'\'''

echo '$ json '\''~b||b'\'' '\''b'\'''
json '~b||b' 'b' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''b'\'''

echo '$ json '\''~b||b'\'' '\''c'\'''
json '~b||b' 'c' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''c'\'''

echo '$ json '\''~b||b'\'' '\''a,b'\'''
json '~b||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''a,b'\'''

echo '$ json '\''~b||b'\'' '\''a,c'\'''
json '~b||b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''a,c'\'''

echo '$ json '\''~b||b'\'' '\''b,c'\'''
json '~b||b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''b,c'\'''

echo '$ json '\''~b||b'\'' '\''a,b,c'\'''
json '~b||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''a,b,c'\'''

echo '$ json '\''~b||b'\'' '\''z'\'''
json '~b||b' 'z' 2>&1 ||
echo 'command failed: json '\''~b||b'\'' '\''z'\'''

echo '$ json '\''~b||c'\'' '\''a'\'''
json '~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''a'\'''

echo '$ json '\''~b||c'\'' '\''b'\'''
json '~b||c' 'b' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''b'\'''

echo '$ json '\''~b||c'\'' '\''c'\'''
json '~b||c' 'c' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''c'\'''

echo '$ json '\''~b||c'\'' '\''a,b'\'''
json '~b||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''a,b'\'''

echo '$ json '\''~b||c'\'' '\''a,c'\'''
json '~b||c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''a,c'\'''

echo '$ json '\''~b||c'\'' '\''b,c'\'''
json '~b||c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''b,c'\'''

echo '$ json '\''~b||c'\'' '\''a,b,c'\'''
json '~b||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||c'\'' '\''z'\'''
json '~b||c' 'z' 2>&1 ||
echo 'command failed: json '\''~b||c'\'' '\''z'\'''

echo '$ json '\''~b||~c'\'' '\''a'\'''
json '~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''a'\'''

echo '$ json '\''~b||~c'\'' '\''b'\'''
json '~b||~c' 'b' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''b'\'''

echo '$ json '\''~b||~c'\'' '\''c'\'''
json '~b||~c' 'c' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''c'\'''

echo '$ json '\''~b||~c'\'' '\''a,b'\'''
json '~b||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''a,b'\'''

echo '$ json '\''~b||~c'\'' '\''a,c'\'''
json '~b||~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''a,c'\'''

echo '$ json '\''~b||~c'\'' '\''b,c'\'''
json '~b||~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''b,c'\'''

echo '$ json '\''~b||~c'\'' '\''a,b,c'\'''
json '~b||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''a,b,c'\'''

echo '$ json '\''~b||~c'\'' '\''z'\'''
json '~b||~c' 'z' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'' '\''z'\'''

echo '$ json '\''c||a'\'' '\''a'\'''
json 'c||a' 'a' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''a'\'''

echo '$ json '\''c||a'\'' '\''b'\'''
json 'c||a' 'b' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''b'\'''

echo '$ json '\''c||a'\'' '\''c'\'''
json 'c||a' 'c' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''c'\'''

echo '$ json '\''c||a'\'' '\''a,b'\'''
json 'c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''a,b'\'''

echo '$ json '\''c||a'\'' '\''a,c'\'''
json 'c||a' 'a,c' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''a,c'\'''

echo '$ json '\''c||a'\'' '\''b,c'\'''
json 'c||a' 'b,c' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''b,c'\'''

echo '$ json '\''c||a'\'' '\''a,b,c'\'''
json 'c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''a,b,c'\'''

echo '$ json '\''c||a'\'' '\''z'\'''
json 'c||a' 'z' 2>&1 ||
echo 'command failed: json '\''c||a'\'' '\''z'\'''

echo '$ json '\''c||~a'\'' '\''a'\'''
json 'c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''a'\'''

echo '$ json '\''c||~a'\'' '\''b'\'''
json 'c||~a' 'b' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''b'\'''

echo '$ json '\''c||~a'\'' '\''c'\'''
json 'c||~a' 'c' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''c'\'''

echo '$ json '\''c||~a'\'' '\''a,b'\'''
json 'c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''a,b'\'''

echo '$ json '\''c||~a'\'' '\''a,c'\'''
json 'c||~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''a,c'\'''

echo '$ json '\''c||~a'\'' '\''b,c'\'''
json 'c||~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''b,c'\'''

echo '$ json '\''c||~a'\'' '\''a,b,c'\'''
json 'c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''c||~a'\'' '\''z'\'''
json 'c||~a' 'z' 2>&1 ||
echo 'command failed: json '\''c||~a'\'' '\''z'\'''

echo '$ json '\''c||b'\'' '\''a'\'''
json 'c||b' 'a' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''a'\'''

echo '$ json '\''c||b'\'' '\''b'\'''
json 'c||b' 'b' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''b'\'''

echo '$ json '\''c||b'\'' '\''c'\'''
json 'c||b' 'c' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''c'\'''

echo '$ json '\''c||b'\'' '\''a,b'\'''
json 'c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''a,b'\'''

echo '$ json '\''c||b'\'' '\''a,c'\'''
json 'c||b' 'a,c' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''a,c'\'''

echo '$ json '\''c||b'\'' '\''b,c'\'''
json 'c||b' 'b,c' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''b,c'\'''

echo '$ json '\''c||b'\'' '\''a,b,c'\'''
json 'c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''a,b,c'\'''

echo '$ json '\''c||b'\'' '\''z'\'''
json 'c||b' 'z' 2>&1 ||
echo 'command failed: json '\''c||b'\'' '\''z'\'''

echo '$ json '\''c||~b'\'' '\''a'\'''
json 'c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''a'\'''

echo '$ json '\''c||~b'\'' '\''b'\'''
json 'c||~b' 'b' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''b'\'''

echo '$ json '\''c||~b'\'' '\''c'\'''
json 'c||~b' 'c' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''c'\'''

echo '$ json '\''c||~b'\'' '\''a,b'\'''
json 'c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''a,b'\'''

echo '$ json '\''c||~b'\'' '\''a,c'\'''
json 'c||~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''a,c'\'''

echo '$ json '\''c||~b'\'' '\''b,c'\'''
json 'c||~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''b,c'\'''

echo '$ json '\''c||~b'\'' '\''a,b,c'\'''
json 'c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''c||~b'\'' '\''z'\'''
json 'c||~b' 'z' 2>&1 ||
echo 'command failed: json '\''c||~b'\'' '\''z'\'''

echo '$ json '\''c||~c'\'' '\''a'\'''
json 'c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''a'\'''

echo '$ json '\''c||~c'\'' '\''b'\'''
json 'c||~c' 'b' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''b'\'''

echo '$ json '\''c||~c'\'' '\''c'\'''
json 'c||~c' 'c' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''c'\'''

echo '$ json '\''c||~c'\'' '\''a,b'\'''
json 'c||~c' 'a,b' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''a,b'\'''

echo '$ json '\''c||~c'\'' '\''a,c'\'''
json 'c||~c' 'a,c' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''a,c'\'''

echo '$ json '\''c||~c'\'' '\''b,c'\'''
json 'c||~c' 'b,c' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''b,c'\'''

echo '$ json '\''c||~c'\'' '\''a,b,c'\'''
json 'c||~c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''a,b,c'\'''

echo '$ json '\''c||~c'\'' '\''z'\'''
json 'c||~c' 'z' 2>&1 ||
echo 'command failed: json '\''c||~c'\'' '\''z'\'''

echo '$ json '\''~c||a'\'' '\''a'\'''
json '~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''a'\'''

echo '$ json '\''~c||a'\'' '\''b'\'''
json '~c||a' 'b' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''b'\'''

echo '$ json '\''~c||a'\'' '\''c'\'''
json '~c||a' 'c' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''c'\'''

echo '$ json '\''~c||a'\'' '\''a,b'\'''
json '~c||a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''a,b'\'''

echo '$ json '\''~c||a'\'' '\''a,c'\'''
json '~c||a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''a,c'\'''

echo '$ json '\''~c||a'\'' '\''b,c'\'''
json '~c||a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''b,c'\'''

echo '$ json '\''~c||a'\'' '\''a,b,c'\'''
json '~c||a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||a'\'' '\''z'\'''
json '~c||a' 'z' 2>&1 ||
echo 'command failed: json '\''~c||a'\'' '\''z'\'''

echo '$ json '\''~c||~a'\'' '\''a'\'''
json '~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''a'\'''

echo '$ json '\''~c||~a'\'' '\''b'\'''
json '~c||~a' 'b' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''b'\'''

echo '$ json '\''~c||~a'\'' '\''c'\'''
json '~c||~a' 'c' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''c'\'''

echo '$ json '\''~c||~a'\'' '\''a,b'\'''
json '~c||~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''a,b'\'''

echo '$ json '\''~c||~a'\'' '\''a,c'\'''
json '~c||~a' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''a,c'\'''

echo '$ json '\''~c||~a'\'' '\''b,c'\'''
json '~c||~a' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''b,c'\'''

echo '$ json '\''~c||~a'\'' '\''a,b,c'\'''
json '~c||~a' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~a'\'' '\''z'\'''
json '~c||~a' 'z' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'' '\''z'\'''

echo '$ json '\''~c||b'\'' '\''a'\'''
json '~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''a'\'''

echo '$ json '\''~c||b'\'' '\''b'\'''
json '~c||b' 'b' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''b'\'''

echo '$ json '\''~c||b'\'' '\''c'\'''
json '~c||b' 'c' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''c'\'''

echo '$ json '\''~c||b'\'' '\''a,b'\'''
json '~c||b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''a,b'\'''

echo '$ json '\''~c||b'\'' '\''a,c'\'''
json '~c||b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''a,c'\'''

echo '$ json '\''~c||b'\'' '\''b,c'\'''
json '~c||b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''b,c'\'''

echo '$ json '\''~c||b'\'' '\''a,b,c'\'''
json '~c||b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||b'\'' '\''z'\'''
json '~c||b' 'z' 2>&1 ||
echo 'command failed: json '\''~c||b'\'' '\''z'\'''

echo '$ json '\''~c||~b'\'' '\''a'\'''
json '~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''a'\'''

echo '$ json '\''~c||~b'\'' '\''b'\'''
json '~c||~b' 'b' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''b'\'''

echo '$ json '\''~c||~b'\'' '\''c'\'''
json '~c||~b' 'c' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''c'\'''

echo '$ json '\''~c||~b'\'' '\''a,b'\'''
json '~c||~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''a,b'\'''

echo '$ json '\''~c||~b'\'' '\''a,c'\'''
json '~c||~b' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''a,c'\'''

echo '$ json '\''~c||~b'\'' '\''b,c'\'''
json '~c||~b' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''b,c'\'''

echo '$ json '\''~c||~b'\'' '\''a,b,c'\'''
json '~c||~b' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''a,b,c'\'''

echo '$ json '\''~c||~b'\'' '\''z'\'''
json '~c||~b' 'z' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'' '\''z'\'''

echo '$ json '\''~c||c'\'' '\''a'\'''
json '~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''a'\'''

echo '$ json '\''~c||c'\'' '\''b'\'''
json '~c||c' 'b' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''b'\'''

echo '$ json '\''~c||c'\'' '\''c'\'''
json '~c||c' 'c' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''c'\'''

echo '$ json '\''~c||c'\'' '\''a,b'\'''
json '~c||c' 'a,b' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''a,b'\'''

echo '$ json '\''~c||c'\'' '\''a,c'\'''
json '~c||c' 'a,c' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''a,c'\'''

echo '$ json '\''~c||c'\'' '\''b,c'\'''
json '~c||c' 'b,c' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''b,c'\'''

echo '$ json '\''~c||c'\'' '\''a,b,c'\'''
json '~c||c' 'a,b,c' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''a,b,c'\'''

echo '$ json '\''~c||c'\'' '\''z'\'''
json '~c||c' 'z' 2>&1 ||
echo 'command failed: json '\''~c||c'\'' '\''z'\'''
)

