#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-plain-val-object-bar-basic-fuu-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-plain-val-object-bar-basic-fuu-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[{}],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"boz"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":"buz"}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"bar":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"bar":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"boz"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":"buz"}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"bar":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"bar":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456,"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz","fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{},"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"boz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[],"fuu":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
) -L list-object-foo-basic-object-bar-plain-val-object-bar-basic-fuu-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":"boz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"boz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[],"fuu":[]}'\'''
)

