#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-basic-object-basic-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-basic-object-basic-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\''
[]'
) -L list-basic-object-basic-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''[]'\'''
)

