#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def:node-list-object-any
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-list-object-any.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __1[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __1,
        .size = 1
    }
};
static const struct json_type_object_trie_node_t __3 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__2
};
static const struct json_type_object_trie_node_t __4 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__0
    },
    .EQ = &__3
};
static const struct json_type_object_trie_node_t __5 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "foo"
    },
    .EQ = &__4
};
static const struct json_type_object_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .object = &__6
};
static const struct json_type_node_t* __8[] = {
    &__2,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__9
};'
) -L node-list-object-any.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'''
)

