#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def-gcc:node-open-array-object-any2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-open-array-object-any2.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"type"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"boolean"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"number"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"string"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"object"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};
$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"array"}]}}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_object_node_arg_t __2[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "bar",
        .type = &__1
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__4
};'
) -L node-open-array-object-any2.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'1i\\\\\\#include "json-type.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee /dev/fd/2|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"type"},{"name":"bar","type":"array"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"null"},{"name":"bar","type":"array"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"array"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"},{"name":"bar","type":"array"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"},{"name":"bar","type":"array"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"object"},{"name":"bar","type":"array"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"type"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"type"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"type"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"null"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"boolean"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"boolean"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"boolean"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"number"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"number"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"number"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"string"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"string"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"string"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"object"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"object"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"object"}]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"array"}]}}'\'''
json <<< '{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"array"}]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"array"},{"name":"bar","type":"array"}]}}'\'''
)

