#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object9
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object9.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
{"foo":{"bar":{"baz":null}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
{"foo":{"bar":{"baz":false}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
{"foo":{"bar":{"baz":true}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
{"foo":{"bar":{"baz":123}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
{"foo":{"bar":{"baz":"foo"}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
{"foo":{"bar":{"baz":{}}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
{"foo":{"bar":{"baz":[]}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
{"foo":{"bar":{"baz":null}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":false}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":true}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":123}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":"foo"}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":{}}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":null}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
{"foo":{"bar":{"baz":false}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
{"foo":{"bar":{"baz":true}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":123}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":"foo"}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":{}}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":null}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":false}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":true}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
{"foo":{"bar":{"baz":123}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":"foo"}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":{}}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":null}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":false}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":true}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":123}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
{"foo":{"bar":{"baz":"foo"}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":{}}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":null}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":false}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":true}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":123}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":"foo"}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
{"foo":{"bar":{"baz":{}}}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":null}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":false}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":true}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":123}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":"foo"}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
json: error: <stdin>:1:22: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:22: {"foo":{"bar":{"baz":{}}}}
json: error: <stdin>:1:22:                      ^
{"foo":{"bar":{"baz":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
{"foo":{"bar":{"baz":[]}}}'
) -L object9.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"type"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"null"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"boolean"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"number"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"string"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"object"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":null}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":null}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":false}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":false}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":true}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":true}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":123}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":123}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":"foo"}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":"foo"}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":{}}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":{}}}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"object","args":[{"name":"bar","type":{"type":"object","args":[{"name":"baz","type":"array"}]}}]}}]}'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
)

