#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-plain-basic-val-object-basic-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-plain-basic-val-object-basic-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":true,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":true,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":123,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":123,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"foo","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"foo",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
) -L list-object-plain-basic-val-object-basic-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":true,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":true,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":123,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":123,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"foo","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"foo","buu":[]}'\'''
)

