#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-plain-val-object-bar-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-plain-val-object-bar-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\''
{"bar":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\''
{"bar":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\''
{"bar":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\''
{"bar":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":"buz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":null}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":false}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":true}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":123}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":456}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":"baz"}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\''
{"bar":"buz"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":{}}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"buz"}'\''
json: error: <stdin>:1:8: {"bar":[]}
json: error: <stdin>:1:8:        ^
{"bar":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
) -L list-object-foo-basic-object-bar-plain-val-object-bar-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"bar":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"bar":[]}'\'''
)

