#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-plain-val-object-basic-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-plain-val-object-basic-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":[{}],"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":null}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":false}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":true}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":123}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":456}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":{}}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
json: error: <stdin>:1:13: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:13: {"faa":null,"buu":[]}
json: error: <stdin>:1:13:             ^
{"faa":null,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":null}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":false}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":true}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":123}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":456}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":false,"buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":false,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":null}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":false}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":true}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":123}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":456}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":{}}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
json: error: <stdin>:1:12: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:12: {"faa":456,"buu":[]}
json: error: <stdin>:1:12:            ^
{"faa":456,
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":null}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":false}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":123}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":456}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"foo"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":"bar"}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":{}}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:14: {"faa":"bar","buu":[]}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":{},"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":{},
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":null}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":false}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":true}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":123}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":456}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":{}}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\''
json: error: <stdin>:1:11: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:11: {"faa":[],"buu":[]}
json: error: <stdin>:1:11:           ^
{"faa":[],
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
) -L list-object-basic-plain-val-object-basic-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[{}],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[{}],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":null,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":null,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":false,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":false,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":456,"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":456,"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"bar","buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"bar","buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":{},"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":{},"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"faa":[],"buu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":[],"buu":[]}'\'''
)

