#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-unicode2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-unicode2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo '\''"\u0020"'\''|json -b 1
" "
$ echo '\''"\u0020"'\''|json -b 2
" "
$ echo '\''"\u0020"'\''|json -b 3
" "
$ echo '\''"\u0020"'\''|json -b 4
" "
$ echo '\''"\u0020"'\''|json -b 5
" "
$ echo '\''"\u0020"'\''|json -b 6
" "
$ echo '\''"\u0020"'\''|json -b 7
" "
$ echo '\''"\u0020"'\''|json -b 8
" "
$ echo '\''"\u0021"'\''|json -b 1
"!"
$ echo '\''"\u0021"'\''|json -b 2
"!"
$ echo '\''"\u0021"'\''|json -b 3
"!"
$ echo '\''"\u0021"'\''|json -b 4
"!"
$ echo '\''"\u0021"'\''|json -b 5
"!"
$ echo '\''"\u0021"'\''|json -b 6
"!"
$ echo '\''"\u0021"'\''|json -b 7
"!"
$ echo '\''"\u0021"'\''|json -b 8
"!"
$ echo '\''"\u0022"'\''|json -b 1
"\""
$ echo '\''"\u0022"'\''|json -b 2
"\""
$ echo '\''"\u0022"'\''|json -b 3
"\""
$ echo '\''"\u0022"'\''|json -b 4
"\""
$ echo '\''"\u0022"'\''|json -b 5
"\""
$ echo '\''"\u0022"'\''|json -b 6
"\""
$ echo '\''"\u0022"'\''|json -b 7
"\""
$ echo '\''"\u0022"'\''|json -b 8
"\""
$ echo '\''"\u0023"'\''|json -b 1
"#"
$ echo '\''"\u0023"'\''|json -b 2
"#"
$ echo '\''"\u0023"'\''|json -b 3
"#"
$ echo '\''"\u0023"'\''|json -b 4
"#"
$ echo '\''"\u0023"'\''|json -b 5
"#"
$ echo '\''"\u0023"'\''|json -b 6
"#"
$ echo '\''"\u0023"'\''|json -b 7
"#"
$ echo '\''"\u0023"'\''|json -b 8
"#"
$ echo '\''"\u0024"'\''|json -b 1
"$"
$ echo '\''"\u0024"'\''|json -b 2
"$"
$ echo '\''"\u0024"'\''|json -b 3
"$"
$ echo '\''"\u0024"'\''|json -b 4
"$"
$ echo '\''"\u0024"'\''|json -b 5
"$"
$ echo '\''"\u0024"'\''|json -b 6
"$"
$ echo '\''"\u0024"'\''|json -b 7
"$"
$ echo '\''"\u0024"'\''|json -b 8
"$"
$ echo '\''"\u0025"'\''|json -b 1
"%"
$ echo '\''"\u0025"'\''|json -b 2
"%"
$ echo '\''"\u0025"'\''|json -b 3
"%"
$ echo '\''"\u0025"'\''|json -b 4
"%"
$ echo '\''"\u0025"'\''|json -b 5
"%"
$ echo '\''"\u0025"'\''|json -b 6
"%"
$ echo '\''"\u0025"'\''|json -b 7
"%"
$ echo '\''"\u0025"'\''|json -b 8
"%"
$ echo '\''"\u0026"'\''|json -b 1
"&"
$ echo '\''"\u0026"'\''|json -b 2
"&"
$ echo '\''"\u0026"'\''|json -b 3
"&"
$ echo '\''"\u0026"'\''|json -b 4
"&"
$ echo '\''"\u0026"'\''|json -b 5
"&"
$ echo '\''"\u0026"'\''|json -b 6
"&"
$ echo '\''"\u0026"'\''|json -b 7
"&"
$ echo '\''"\u0026"'\''|json -b 8
"&"
$ echo '\''"\u0027"'\''|json -b 1
"'\''"
$ echo '\''"\u0027"'\''|json -b 2
"'\''"
$ echo '\''"\u0027"'\''|json -b 3
"'\''"
$ echo '\''"\u0027"'\''|json -b 4
"'\''"
$ echo '\''"\u0027"'\''|json -b 5
"'\''"
$ echo '\''"\u0027"'\''|json -b 6
"'\''"
$ echo '\''"\u0027"'\''|json -b 7
"'\''"
$ echo '\''"\u0027"'\''|json -b 8
"'\''"
$ echo '\''"\u0028"'\''|json -b 1
"("
$ echo '\''"\u0028"'\''|json -b 2
"("
$ echo '\''"\u0028"'\''|json -b 3
"("
$ echo '\''"\u0028"'\''|json -b 4
"("
$ echo '\''"\u0028"'\''|json -b 5
"("
$ echo '\''"\u0028"'\''|json -b 6
"("
$ echo '\''"\u0028"'\''|json -b 7
"("
$ echo '\''"\u0028"'\''|json -b 8
"("
$ echo '\''"\u0029"'\''|json -b 1
")"
$ echo '\''"\u0029"'\''|json -b 2
")"
$ echo '\''"\u0029"'\''|json -b 3
")"
$ echo '\''"\u0029"'\''|json -b 4
")"
$ echo '\''"\u0029"'\''|json -b 5
")"
$ echo '\''"\u0029"'\''|json -b 6
")"
$ echo '\''"\u0029"'\''|json -b 7
")"
$ echo '\''"\u0029"'\''|json -b 8
")"
$ echo '\''"\u002a"'\''|json -b 1
"*"
$ echo '\''"\u002a"'\''|json -b 2
"*"
$ echo '\''"\u002a"'\''|json -b 3
"*"
$ echo '\''"\u002a"'\''|json -b 4
"*"
$ echo '\''"\u002a"'\''|json -b 5
"*"
$ echo '\''"\u002a"'\''|json -b 6
"*"
$ echo '\''"\u002a"'\''|json -b 7
"*"
$ echo '\''"\u002a"'\''|json -b 8
"*"
$ echo '\''"\u002b"'\''|json -b 1
"+"
$ echo '\''"\u002b"'\''|json -b 2
"+"
$ echo '\''"\u002b"'\''|json -b 3
"+"
$ echo '\''"\u002b"'\''|json -b 4
"+"
$ echo '\''"\u002b"'\''|json -b 5
"+"
$ echo '\''"\u002b"'\''|json -b 6
"+"
$ echo '\''"\u002b"'\''|json -b 7
"+"
$ echo '\''"\u002b"'\''|json -b 8
"+"
$ echo '\''"\u002c"'\''|json -b 1
","
$ echo '\''"\u002c"'\''|json -b 2
","
$ echo '\''"\u002c"'\''|json -b 3
","
$ echo '\''"\u002c"'\''|json -b 4
","
$ echo '\''"\u002c"'\''|json -b 5
","
$ echo '\''"\u002c"'\''|json -b 6
","
$ echo '\''"\u002c"'\''|json -b 7
","
$ echo '\''"\u002c"'\''|json -b 8
","
$ echo '\''"\u002d"'\''|json -b 1
"-"
$ echo '\''"\u002d"'\''|json -b 2
"-"
$ echo '\''"\u002d"'\''|json -b 3
"-"
$ echo '\''"\u002d"'\''|json -b 4
"-"
$ echo '\''"\u002d"'\''|json -b 5
"-"
$ echo '\''"\u002d"'\''|json -b 6
"-"
$ echo '\''"\u002d"'\''|json -b 7
"-"
$ echo '\''"\u002d"'\''|json -b 8
"-"
$ echo '\''"\u002e"'\''|json -b 1
"."
$ echo '\''"\u002e"'\''|json -b 2
"."
$ echo '\''"\u002e"'\''|json -b 3
"."
$ echo '\''"\u002e"'\''|json -b 4
"."
$ echo '\''"\u002e"'\''|json -b 5
"."
$ echo '\''"\u002e"'\''|json -b 6
"."
$ echo '\''"\u002e"'\''|json -b 7
"."
$ echo '\''"\u002e"'\''|json -b 8
"."
$ echo '\''"\u002f"'\''|json -b 1
"/"
$ echo '\''"\u002f"'\''|json -b 2
"/"
$ echo '\''"\u002f"'\''|json -b 3
"/"
$ echo '\''"\u002f"'\''|json -b 4
"/"
$ echo '\''"\u002f"'\''|json -b 5
"/"
$ echo '\''"\u002f"'\''|json -b 6
"/"
$ echo '\''"\u002f"'\''|json -b 7
"/"
$ echo '\''"\u002f"'\''|json -b 8
"/"
$ echo '\''"\u0030"'\''|json -b 1
"0"
$ echo '\''"\u0030"'\''|json -b 2
"0"
$ echo '\''"\u0030"'\''|json -b 3
"0"
$ echo '\''"\u0030"'\''|json -b 4
"0"
$ echo '\''"\u0030"'\''|json -b 5
"0"
$ echo '\''"\u0030"'\''|json -b 6
"0"
$ echo '\''"\u0030"'\''|json -b 7
"0"
$ echo '\''"\u0030"'\''|json -b 8
"0"
$ echo '\''"\u0031"'\''|json -b 1
"1"
$ echo '\''"\u0031"'\''|json -b 2
"1"
$ echo '\''"\u0031"'\''|json -b 3
"1"
$ echo '\''"\u0031"'\''|json -b 4
"1"
$ echo '\''"\u0031"'\''|json -b 5
"1"
$ echo '\''"\u0031"'\''|json -b 6
"1"
$ echo '\''"\u0031"'\''|json -b 7
"1"
$ echo '\''"\u0031"'\''|json -b 8
"1"
$ echo '\''"\u0032"'\''|json -b 1
"2"
$ echo '\''"\u0032"'\''|json -b 2
"2"
$ echo '\''"\u0032"'\''|json -b 3
"2"
$ echo '\''"\u0032"'\''|json -b 4
"2"
$ echo '\''"\u0032"'\''|json -b 5
"2"
$ echo '\''"\u0032"'\''|json -b 6
"2"
$ echo '\''"\u0032"'\''|json -b 7
"2"
$ echo '\''"\u0032"'\''|json -b 8
"2"
$ echo '\''"\u0033"'\''|json -b 1
"3"
$ echo '\''"\u0033"'\''|json -b 2
"3"
$ echo '\''"\u0033"'\''|json -b 3
"3"
$ echo '\''"\u0033"'\''|json -b 4
"3"
$ echo '\''"\u0033"'\''|json -b 5
"3"
$ echo '\''"\u0033"'\''|json -b 6
"3"
$ echo '\''"\u0033"'\''|json -b 7
"3"
$ echo '\''"\u0033"'\''|json -b 8
"3"
$ echo '\''"\u0034"'\''|json -b 1
"4"
$ echo '\''"\u0034"'\''|json -b 2
"4"
$ echo '\''"\u0034"'\''|json -b 3
"4"
$ echo '\''"\u0034"'\''|json -b 4
"4"
$ echo '\''"\u0034"'\''|json -b 5
"4"
$ echo '\''"\u0034"'\''|json -b 6
"4"
$ echo '\''"\u0034"'\''|json -b 7
"4"
$ echo '\''"\u0034"'\''|json -b 8
"4"
$ echo '\''"\u0035"'\''|json -b 1
"5"
$ echo '\''"\u0035"'\''|json -b 2
"5"
$ echo '\''"\u0035"'\''|json -b 3
"5"
$ echo '\''"\u0035"'\''|json -b 4
"5"
$ echo '\''"\u0035"'\''|json -b 5
"5"
$ echo '\''"\u0035"'\''|json -b 6
"5"
$ echo '\''"\u0035"'\''|json -b 7
"5"
$ echo '\''"\u0035"'\''|json -b 8
"5"
$ echo '\''"\u0036"'\''|json -b 1
"6"
$ echo '\''"\u0036"'\''|json -b 2
"6"
$ echo '\''"\u0036"'\''|json -b 3
"6"
$ echo '\''"\u0036"'\''|json -b 4
"6"
$ echo '\''"\u0036"'\''|json -b 5
"6"
$ echo '\''"\u0036"'\''|json -b 6
"6"
$ echo '\''"\u0036"'\''|json -b 7
"6"
$ echo '\''"\u0036"'\''|json -b 8
"6"
$ echo '\''"\u0037"'\''|json -b 1
"7"
$ echo '\''"\u0037"'\''|json -b 2
"7"
$ echo '\''"\u0037"'\''|json -b 3
"7"
$ echo '\''"\u0037"'\''|json -b 4
"7"
$ echo '\''"\u0037"'\''|json -b 5
"7"
$ echo '\''"\u0037"'\''|json -b 6
"7"
$ echo '\''"\u0037"'\''|json -b 7
"7"
$ echo '\''"\u0037"'\''|json -b 8
"7"
$ echo '\''"\u0038"'\''|json -b 1
"8"
$ echo '\''"\u0038"'\''|json -b 2
"8"
$ echo '\''"\u0038"'\''|json -b 3
"8"
$ echo '\''"\u0038"'\''|json -b 4
"8"
$ echo '\''"\u0038"'\''|json -b 5
"8"
$ echo '\''"\u0038"'\''|json -b 6
"8"
$ echo '\''"\u0038"'\''|json -b 7
"8"
$ echo '\''"\u0038"'\''|json -b 8
"8"
$ echo '\''"\u0039"'\''|json -b 1
"9"
$ echo '\''"\u0039"'\''|json -b 2
"9"
$ echo '\''"\u0039"'\''|json -b 3
"9"
$ echo '\''"\u0039"'\''|json -b 4
"9"
$ echo '\''"\u0039"'\''|json -b 5
"9"
$ echo '\''"\u0039"'\''|json -b 6
"9"
$ echo '\''"\u0039"'\''|json -b 7
"9"
$ echo '\''"\u0039"'\''|json -b 8
"9"
$ echo '\''"\u003a"'\''|json -b 1
":"
$ echo '\''"\u003a"'\''|json -b 2
":"
$ echo '\''"\u003a"'\''|json -b 3
":"
$ echo '\''"\u003a"'\''|json -b 4
":"
$ echo '\''"\u003a"'\''|json -b 5
":"
$ echo '\''"\u003a"'\''|json -b 6
":"
$ echo '\''"\u003a"'\''|json -b 7
":"
$ echo '\''"\u003a"'\''|json -b 8
":"
$ echo '\''"\u003b"'\''|json -b 1
";"
$ echo '\''"\u003b"'\''|json -b 2
";"
$ echo '\''"\u003b"'\''|json -b 3
";"
$ echo '\''"\u003b"'\''|json -b 4
";"
$ echo '\''"\u003b"'\''|json -b 5
";"
$ echo '\''"\u003b"'\''|json -b 6
";"
$ echo '\''"\u003b"'\''|json -b 7
";"
$ echo '\''"\u003b"'\''|json -b 8
";"
$ echo '\''"\u003c"'\''|json -b 1
"<"
$ echo '\''"\u003c"'\''|json -b 2
"<"
$ echo '\''"\u003c"'\''|json -b 3
"<"
$ echo '\''"\u003c"'\''|json -b 4
"<"
$ echo '\''"\u003c"'\''|json -b 5
"<"
$ echo '\''"\u003c"'\''|json -b 6
"<"
$ echo '\''"\u003c"'\''|json -b 7
"<"
$ echo '\''"\u003c"'\''|json -b 8
"<"
$ echo '\''"\u003d"'\''|json -b 1
"="
$ echo '\''"\u003d"'\''|json -b 2
"="
$ echo '\''"\u003d"'\''|json -b 3
"="
$ echo '\''"\u003d"'\''|json -b 4
"="
$ echo '\''"\u003d"'\''|json -b 5
"="
$ echo '\''"\u003d"'\''|json -b 6
"="
$ echo '\''"\u003d"'\''|json -b 7
"="
$ echo '\''"\u003d"'\''|json -b 8
"="
$ echo '\''"\u003e"'\''|json -b 1
">"
$ echo '\''"\u003e"'\''|json -b 2
">"
$ echo '\''"\u003e"'\''|json -b 3
">"
$ echo '\''"\u003e"'\''|json -b 4
">"
$ echo '\''"\u003e"'\''|json -b 5
">"
$ echo '\''"\u003e"'\''|json -b 6
">"
$ echo '\''"\u003e"'\''|json -b 7
">"
$ echo '\''"\u003e"'\''|json -b 8
">"
$ echo '\''"\u003f"'\''|json -b 1
"?"
$ echo '\''"\u003f"'\''|json -b 2
"?"
$ echo '\''"\u003f"'\''|json -b 3
"?"
$ echo '\''"\u003f"'\''|json -b 4
"?"
$ echo '\''"\u003f"'\''|json -b 5
"?"
$ echo '\''"\u003f"'\''|json -b 6
"?"
$ echo '\''"\u003f"'\''|json -b 7
"?"
$ echo '\''"\u003f"'\''|json -b 8
"?"'
) -L string-unicode2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo '\''"\u0020"'\''|json -b 1'
echo '"\u0020"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 1'

echo '$ echo '\''"\u0020"'\''|json -b 2'
echo '"\u0020"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 2'

echo '$ echo '\''"\u0020"'\''|json -b 3'
echo '"\u0020"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 3'

echo '$ echo '\''"\u0020"'\''|json -b 4'
echo '"\u0020"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 4'

echo '$ echo '\''"\u0020"'\''|json -b 5'
echo '"\u0020"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 5'

echo '$ echo '\''"\u0020"'\''|json -b 6'
echo '"\u0020"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 6'

echo '$ echo '\''"\u0020"'\''|json -b 7'
echo '"\u0020"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 7'

echo '$ echo '\''"\u0020"'\''|json -b 8'
echo '"\u0020"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0020"'\''|json -b 8'

echo '$ echo '\''"\u0021"'\''|json -b 1'
echo '"\u0021"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 1'

echo '$ echo '\''"\u0021"'\''|json -b 2'
echo '"\u0021"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 2'

echo '$ echo '\''"\u0021"'\''|json -b 3'
echo '"\u0021"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 3'

echo '$ echo '\''"\u0021"'\''|json -b 4'
echo '"\u0021"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 4'

echo '$ echo '\''"\u0021"'\''|json -b 5'
echo '"\u0021"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 5'

echo '$ echo '\''"\u0021"'\''|json -b 6'
echo '"\u0021"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 6'

echo '$ echo '\''"\u0021"'\''|json -b 7'
echo '"\u0021"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 7'

echo '$ echo '\''"\u0021"'\''|json -b 8'
echo '"\u0021"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0021"'\''|json -b 8'

echo '$ echo '\''"\u0022"'\''|json -b 1'
echo '"\u0022"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 1'

echo '$ echo '\''"\u0022"'\''|json -b 2'
echo '"\u0022"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 2'

echo '$ echo '\''"\u0022"'\''|json -b 3'
echo '"\u0022"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 3'

echo '$ echo '\''"\u0022"'\''|json -b 4'
echo '"\u0022"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 4'

echo '$ echo '\''"\u0022"'\''|json -b 5'
echo '"\u0022"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 5'

echo '$ echo '\''"\u0022"'\''|json -b 6'
echo '"\u0022"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 6'

echo '$ echo '\''"\u0022"'\''|json -b 7'
echo '"\u0022"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 7'

echo '$ echo '\''"\u0022"'\''|json -b 8'
echo '"\u0022"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0022"'\''|json -b 8'

echo '$ echo '\''"\u0023"'\''|json -b 1'
echo '"\u0023"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 1'

echo '$ echo '\''"\u0023"'\''|json -b 2'
echo '"\u0023"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 2'

echo '$ echo '\''"\u0023"'\''|json -b 3'
echo '"\u0023"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 3'

echo '$ echo '\''"\u0023"'\''|json -b 4'
echo '"\u0023"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 4'

echo '$ echo '\''"\u0023"'\''|json -b 5'
echo '"\u0023"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 5'

echo '$ echo '\''"\u0023"'\''|json -b 6'
echo '"\u0023"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 6'

echo '$ echo '\''"\u0023"'\''|json -b 7'
echo '"\u0023"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 7'

echo '$ echo '\''"\u0023"'\''|json -b 8'
echo '"\u0023"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0023"'\''|json -b 8'

echo '$ echo '\''"\u0024"'\''|json -b 1'
echo '"\u0024"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 1'

echo '$ echo '\''"\u0024"'\''|json -b 2'
echo '"\u0024"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 2'

echo '$ echo '\''"\u0024"'\''|json -b 3'
echo '"\u0024"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 3'

echo '$ echo '\''"\u0024"'\''|json -b 4'
echo '"\u0024"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 4'

echo '$ echo '\''"\u0024"'\''|json -b 5'
echo '"\u0024"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 5'

echo '$ echo '\''"\u0024"'\''|json -b 6'
echo '"\u0024"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 6'

echo '$ echo '\''"\u0024"'\''|json -b 7'
echo '"\u0024"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 7'

echo '$ echo '\''"\u0024"'\''|json -b 8'
echo '"\u0024"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0024"'\''|json -b 8'

echo '$ echo '\''"\u0025"'\''|json -b 1'
echo '"\u0025"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 1'

echo '$ echo '\''"\u0025"'\''|json -b 2'
echo '"\u0025"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 2'

echo '$ echo '\''"\u0025"'\''|json -b 3'
echo '"\u0025"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 3'

echo '$ echo '\''"\u0025"'\''|json -b 4'
echo '"\u0025"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 4'

echo '$ echo '\''"\u0025"'\''|json -b 5'
echo '"\u0025"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 5'

echo '$ echo '\''"\u0025"'\''|json -b 6'
echo '"\u0025"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 6'

echo '$ echo '\''"\u0025"'\''|json -b 7'
echo '"\u0025"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 7'

echo '$ echo '\''"\u0025"'\''|json -b 8'
echo '"\u0025"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0025"'\''|json -b 8'

echo '$ echo '\''"\u0026"'\''|json -b 1'
echo '"\u0026"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 1'

echo '$ echo '\''"\u0026"'\''|json -b 2'
echo '"\u0026"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 2'

echo '$ echo '\''"\u0026"'\''|json -b 3'
echo '"\u0026"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 3'

echo '$ echo '\''"\u0026"'\''|json -b 4'
echo '"\u0026"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 4'

echo '$ echo '\''"\u0026"'\''|json -b 5'
echo '"\u0026"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 5'

echo '$ echo '\''"\u0026"'\''|json -b 6'
echo '"\u0026"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 6'

echo '$ echo '\''"\u0026"'\''|json -b 7'
echo '"\u0026"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 7'

echo '$ echo '\''"\u0026"'\''|json -b 8'
echo '"\u0026"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0026"'\''|json -b 8'

echo '$ echo '\''"\u0027"'\''|json -b 1'
echo '"\u0027"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 1'

echo '$ echo '\''"\u0027"'\''|json -b 2'
echo '"\u0027"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 2'

echo '$ echo '\''"\u0027"'\''|json -b 3'
echo '"\u0027"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 3'

echo '$ echo '\''"\u0027"'\''|json -b 4'
echo '"\u0027"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 4'

echo '$ echo '\''"\u0027"'\''|json -b 5'
echo '"\u0027"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 5'

echo '$ echo '\''"\u0027"'\''|json -b 6'
echo '"\u0027"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 6'

echo '$ echo '\''"\u0027"'\''|json -b 7'
echo '"\u0027"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 7'

echo '$ echo '\''"\u0027"'\''|json -b 8'
echo '"\u0027"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0027"'\''|json -b 8'

echo '$ echo '\''"\u0028"'\''|json -b 1'
echo '"\u0028"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 1'

echo '$ echo '\''"\u0028"'\''|json -b 2'
echo '"\u0028"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 2'

echo '$ echo '\''"\u0028"'\''|json -b 3'
echo '"\u0028"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 3'

echo '$ echo '\''"\u0028"'\''|json -b 4'
echo '"\u0028"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 4'

echo '$ echo '\''"\u0028"'\''|json -b 5'
echo '"\u0028"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 5'

echo '$ echo '\''"\u0028"'\''|json -b 6'
echo '"\u0028"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 6'

echo '$ echo '\''"\u0028"'\''|json -b 7'
echo '"\u0028"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 7'

echo '$ echo '\''"\u0028"'\''|json -b 8'
echo '"\u0028"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0028"'\''|json -b 8'

echo '$ echo '\''"\u0029"'\''|json -b 1'
echo '"\u0029"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 1'

echo '$ echo '\''"\u0029"'\''|json -b 2'
echo '"\u0029"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 2'

echo '$ echo '\''"\u0029"'\''|json -b 3'
echo '"\u0029"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 3'

echo '$ echo '\''"\u0029"'\''|json -b 4'
echo '"\u0029"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 4'

echo '$ echo '\''"\u0029"'\''|json -b 5'
echo '"\u0029"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 5'

echo '$ echo '\''"\u0029"'\''|json -b 6'
echo '"\u0029"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 6'

echo '$ echo '\''"\u0029"'\''|json -b 7'
echo '"\u0029"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 7'

echo '$ echo '\''"\u0029"'\''|json -b 8'
echo '"\u0029"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0029"'\''|json -b 8'

echo '$ echo '\''"\u002a"'\''|json -b 1'
echo '"\u002a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 1'

echo '$ echo '\''"\u002a"'\''|json -b 2'
echo '"\u002a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 2'

echo '$ echo '\''"\u002a"'\''|json -b 3'
echo '"\u002a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 3'

echo '$ echo '\''"\u002a"'\''|json -b 4'
echo '"\u002a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 4'

echo '$ echo '\''"\u002a"'\''|json -b 5'
echo '"\u002a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 5'

echo '$ echo '\''"\u002a"'\''|json -b 6'
echo '"\u002a"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 6'

echo '$ echo '\''"\u002a"'\''|json -b 7'
echo '"\u002a"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 7'

echo '$ echo '\''"\u002a"'\''|json -b 8'
echo '"\u002a"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u002a"'\''|json -b 8'

echo '$ echo '\''"\u002b"'\''|json -b 1'
echo '"\u002b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 1'

echo '$ echo '\''"\u002b"'\''|json -b 2'
echo '"\u002b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 2'

echo '$ echo '\''"\u002b"'\''|json -b 3'
echo '"\u002b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 3'

echo '$ echo '\''"\u002b"'\''|json -b 4'
echo '"\u002b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 4'

echo '$ echo '\''"\u002b"'\''|json -b 5'
echo '"\u002b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 5'

echo '$ echo '\''"\u002b"'\''|json -b 6'
echo '"\u002b"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 6'

echo '$ echo '\''"\u002b"'\''|json -b 7'
echo '"\u002b"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 7'

echo '$ echo '\''"\u002b"'\''|json -b 8'
echo '"\u002b"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u002b"'\''|json -b 8'

echo '$ echo '\''"\u002c"'\''|json -b 1'
echo '"\u002c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 1'

echo '$ echo '\''"\u002c"'\''|json -b 2'
echo '"\u002c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 2'

echo '$ echo '\''"\u002c"'\''|json -b 3'
echo '"\u002c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 3'

echo '$ echo '\''"\u002c"'\''|json -b 4'
echo '"\u002c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 4'

echo '$ echo '\''"\u002c"'\''|json -b 5'
echo '"\u002c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 5'

echo '$ echo '\''"\u002c"'\''|json -b 6'
echo '"\u002c"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 6'

echo '$ echo '\''"\u002c"'\''|json -b 7'
echo '"\u002c"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 7'

echo '$ echo '\''"\u002c"'\''|json -b 8'
echo '"\u002c"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u002c"'\''|json -b 8'

echo '$ echo '\''"\u002d"'\''|json -b 1'
echo '"\u002d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 1'

echo '$ echo '\''"\u002d"'\''|json -b 2'
echo '"\u002d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 2'

echo '$ echo '\''"\u002d"'\''|json -b 3'
echo '"\u002d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 3'

echo '$ echo '\''"\u002d"'\''|json -b 4'
echo '"\u002d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 4'

echo '$ echo '\''"\u002d"'\''|json -b 5'
echo '"\u002d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 5'

echo '$ echo '\''"\u002d"'\''|json -b 6'
echo '"\u002d"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 6'

echo '$ echo '\''"\u002d"'\''|json -b 7'
echo '"\u002d"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 7'

echo '$ echo '\''"\u002d"'\''|json -b 8'
echo '"\u002d"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u002d"'\''|json -b 8'

echo '$ echo '\''"\u002e"'\''|json -b 1'
echo '"\u002e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 1'

echo '$ echo '\''"\u002e"'\''|json -b 2'
echo '"\u002e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 2'

echo '$ echo '\''"\u002e"'\''|json -b 3'
echo '"\u002e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 3'

echo '$ echo '\''"\u002e"'\''|json -b 4'
echo '"\u002e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 4'

echo '$ echo '\''"\u002e"'\''|json -b 5'
echo '"\u002e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 5'

echo '$ echo '\''"\u002e"'\''|json -b 6'
echo '"\u002e"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 6'

echo '$ echo '\''"\u002e"'\''|json -b 7'
echo '"\u002e"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 7'

echo '$ echo '\''"\u002e"'\''|json -b 8'
echo '"\u002e"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u002e"'\''|json -b 8'

echo '$ echo '\''"\u002f"'\''|json -b 1'
echo '"\u002f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 1'

echo '$ echo '\''"\u002f"'\''|json -b 2'
echo '"\u002f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 2'

echo '$ echo '\''"\u002f"'\''|json -b 3'
echo '"\u002f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 3'

echo '$ echo '\''"\u002f"'\''|json -b 4'
echo '"\u002f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 4'

echo '$ echo '\''"\u002f"'\''|json -b 5'
echo '"\u002f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 5'

echo '$ echo '\''"\u002f"'\''|json -b 6'
echo '"\u002f"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 6'

echo '$ echo '\''"\u002f"'\''|json -b 7'
echo '"\u002f"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 7'

echo '$ echo '\''"\u002f"'\''|json -b 8'
echo '"\u002f"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u002f"'\''|json -b 8'

echo '$ echo '\''"\u0030"'\''|json -b 1'
echo '"\u0030"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 1'

echo '$ echo '\''"\u0030"'\''|json -b 2'
echo '"\u0030"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 2'

echo '$ echo '\''"\u0030"'\''|json -b 3'
echo '"\u0030"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 3'

echo '$ echo '\''"\u0030"'\''|json -b 4'
echo '"\u0030"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 4'

echo '$ echo '\''"\u0030"'\''|json -b 5'
echo '"\u0030"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 5'

echo '$ echo '\''"\u0030"'\''|json -b 6'
echo '"\u0030"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 6'

echo '$ echo '\''"\u0030"'\''|json -b 7'
echo '"\u0030"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 7'

echo '$ echo '\''"\u0030"'\''|json -b 8'
echo '"\u0030"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0030"'\''|json -b 8'

echo '$ echo '\''"\u0031"'\''|json -b 1'
echo '"\u0031"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 1'

echo '$ echo '\''"\u0031"'\''|json -b 2'
echo '"\u0031"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 2'

echo '$ echo '\''"\u0031"'\''|json -b 3'
echo '"\u0031"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 3'

echo '$ echo '\''"\u0031"'\''|json -b 4'
echo '"\u0031"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 4'

echo '$ echo '\''"\u0031"'\''|json -b 5'
echo '"\u0031"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 5'

echo '$ echo '\''"\u0031"'\''|json -b 6'
echo '"\u0031"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 6'

echo '$ echo '\''"\u0031"'\''|json -b 7'
echo '"\u0031"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 7'

echo '$ echo '\''"\u0031"'\''|json -b 8'
echo '"\u0031"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0031"'\''|json -b 8'

echo '$ echo '\''"\u0032"'\''|json -b 1'
echo '"\u0032"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 1'

echo '$ echo '\''"\u0032"'\''|json -b 2'
echo '"\u0032"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 2'

echo '$ echo '\''"\u0032"'\''|json -b 3'
echo '"\u0032"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 3'

echo '$ echo '\''"\u0032"'\''|json -b 4'
echo '"\u0032"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 4'

echo '$ echo '\''"\u0032"'\''|json -b 5'
echo '"\u0032"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 5'

echo '$ echo '\''"\u0032"'\''|json -b 6'
echo '"\u0032"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 6'

echo '$ echo '\''"\u0032"'\''|json -b 7'
echo '"\u0032"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 7'

echo '$ echo '\''"\u0032"'\''|json -b 8'
echo '"\u0032"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0032"'\''|json -b 8'

echo '$ echo '\''"\u0033"'\''|json -b 1'
echo '"\u0033"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 1'

echo '$ echo '\''"\u0033"'\''|json -b 2'
echo '"\u0033"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 2'

echo '$ echo '\''"\u0033"'\''|json -b 3'
echo '"\u0033"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 3'

echo '$ echo '\''"\u0033"'\''|json -b 4'
echo '"\u0033"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 4'

echo '$ echo '\''"\u0033"'\''|json -b 5'
echo '"\u0033"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 5'

echo '$ echo '\''"\u0033"'\''|json -b 6'
echo '"\u0033"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 6'

echo '$ echo '\''"\u0033"'\''|json -b 7'
echo '"\u0033"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 7'

echo '$ echo '\''"\u0033"'\''|json -b 8'
echo '"\u0033"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0033"'\''|json -b 8'

echo '$ echo '\''"\u0034"'\''|json -b 1'
echo '"\u0034"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 1'

echo '$ echo '\''"\u0034"'\''|json -b 2'
echo '"\u0034"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 2'

echo '$ echo '\''"\u0034"'\''|json -b 3'
echo '"\u0034"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 3'

echo '$ echo '\''"\u0034"'\''|json -b 4'
echo '"\u0034"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 4'

echo '$ echo '\''"\u0034"'\''|json -b 5'
echo '"\u0034"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 5'

echo '$ echo '\''"\u0034"'\''|json -b 6'
echo '"\u0034"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 6'

echo '$ echo '\''"\u0034"'\''|json -b 7'
echo '"\u0034"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 7'

echo '$ echo '\''"\u0034"'\''|json -b 8'
echo '"\u0034"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0034"'\''|json -b 8'

echo '$ echo '\''"\u0035"'\''|json -b 1'
echo '"\u0035"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 1'

echo '$ echo '\''"\u0035"'\''|json -b 2'
echo '"\u0035"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 2'

echo '$ echo '\''"\u0035"'\''|json -b 3'
echo '"\u0035"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 3'

echo '$ echo '\''"\u0035"'\''|json -b 4'
echo '"\u0035"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 4'

echo '$ echo '\''"\u0035"'\''|json -b 5'
echo '"\u0035"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 5'

echo '$ echo '\''"\u0035"'\''|json -b 6'
echo '"\u0035"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 6'

echo '$ echo '\''"\u0035"'\''|json -b 7'
echo '"\u0035"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 7'

echo '$ echo '\''"\u0035"'\''|json -b 8'
echo '"\u0035"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0035"'\''|json -b 8'

echo '$ echo '\''"\u0036"'\''|json -b 1'
echo '"\u0036"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 1'

echo '$ echo '\''"\u0036"'\''|json -b 2'
echo '"\u0036"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 2'

echo '$ echo '\''"\u0036"'\''|json -b 3'
echo '"\u0036"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 3'

echo '$ echo '\''"\u0036"'\''|json -b 4'
echo '"\u0036"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 4'

echo '$ echo '\''"\u0036"'\''|json -b 5'
echo '"\u0036"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 5'

echo '$ echo '\''"\u0036"'\''|json -b 6'
echo '"\u0036"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 6'

echo '$ echo '\''"\u0036"'\''|json -b 7'
echo '"\u0036"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 7'

echo '$ echo '\''"\u0036"'\''|json -b 8'
echo '"\u0036"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0036"'\''|json -b 8'

echo '$ echo '\''"\u0037"'\''|json -b 1'
echo '"\u0037"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 1'

echo '$ echo '\''"\u0037"'\''|json -b 2'
echo '"\u0037"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 2'

echo '$ echo '\''"\u0037"'\''|json -b 3'
echo '"\u0037"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 3'

echo '$ echo '\''"\u0037"'\''|json -b 4'
echo '"\u0037"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 4'

echo '$ echo '\''"\u0037"'\''|json -b 5'
echo '"\u0037"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 5'

echo '$ echo '\''"\u0037"'\''|json -b 6'
echo '"\u0037"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 6'

echo '$ echo '\''"\u0037"'\''|json -b 7'
echo '"\u0037"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 7'

echo '$ echo '\''"\u0037"'\''|json -b 8'
echo '"\u0037"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0037"'\''|json -b 8'

echo '$ echo '\''"\u0038"'\''|json -b 1'
echo '"\u0038"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 1'

echo '$ echo '\''"\u0038"'\''|json -b 2'
echo '"\u0038"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 2'

echo '$ echo '\''"\u0038"'\''|json -b 3'
echo '"\u0038"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 3'

echo '$ echo '\''"\u0038"'\''|json -b 4'
echo '"\u0038"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 4'

echo '$ echo '\''"\u0038"'\''|json -b 5'
echo '"\u0038"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 5'

echo '$ echo '\''"\u0038"'\''|json -b 6'
echo '"\u0038"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 6'

echo '$ echo '\''"\u0038"'\''|json -b 7'
echo '"\u0038"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 7'

echo '$ echo '\''"\u0038"'\''|json -b 8'
echo '"\u0038"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0038"'\''|json -b 8'

echo '$ echo '\''"\u0039"'\''|json -b 1'
echo '"\u0039"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 1'

echo '$ echo '\''"\u0039"'\''|json -b 2'
echo '"\u0039"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 2'

echo '$ echo '\''"\u0039"'\''|json -b 3'
echo '"\u0039"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 3'

echo '$ echo '\''"\u0039"'\''|json -b 4'
echo '"\u0039"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 4'

echo '$ echo '\''"\u0039"'\''|json -b 5'
echo '"\u0039"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 5'

echo '$ echo '\''"\u0039"'\''|json -b 6'
echo '"\u0039"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 6'

echo '$ echo '\''"\u0039"'\''|json -b 7'
echo '"\u0039"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 7'

echo '$ echo '\''"\u0039"'\''|json -b 8'
echo '"\u0039"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0039"'\''|json -b 8'

echo '$ echo '\''"\u003a"'\''|json -b 1'
echo '"\u003a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 1'

echo '$ echo '\''"\u003a"'\''|json -b 2'
echo '"\u003a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 2'

echo '$ echo '\''"\u003a"'\''|json -b 3'
echo '"\u003a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 3'

echo '$ echo '\''"\u003a"'\''|json -b 4'
echo '"\u003a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 4'

echo '$ echo '\''"\u003a"'\''|json -b 5'
echo '"\u003a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 5'

echo '$ echo '\''"\u003a"'\''|json -b 6'
echo '"\u003a"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 6'

echo '$ echo '\''"\u003a"'\''|json -b 7'
echo '"\u003a"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 7'

echo '$ echo '\''"\u003a"'\''|json -b 8'
echo '"\u003a"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u003a"'\''|json -b 8'

echo '$ echo '\''"\u003b"'\''|json -b 1'
echo '"\u003b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 1'

echo '$ echo '\''"\u003b"'\''|json -b 2'
echo '"\u003b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 2'

echo '$ echo '\''"\u003b"'\''|json -b 3'
echo '"\u003b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 3'

echo '$ echo '\''"\u003b"'\''|json -b 4'
echo '"\u003b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 4'

echo '$ echo '\''"\u003b"'\''|json -b 5'
echo '"\u003b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 5'

echo '$ echo '\''"\u003b"'\''|json -b 6'
echo '"\u003b"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 6'

echo '$ echo '\''"\u003b"'\''|json -b 7'
echo '"\u003b"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 7'

echo '$ echo '\''"\u003b"'\''|json -b 8'
echo '"\u003b"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u003b"'\''|json -b 8'

echo '$ echo '\''"\u003c"'\''|json -b 1'
echo '"\u003c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 1'

echo '$ echo '\''"\u003c"'\''|json -b 2'
echo '"\u003c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 2'

echo '$ echo '\''"\u003c"'\''|json -b 3'
echo '"\u003c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 3'

echo '$ echo '\''"\u003c"'\''|json -b 4'
echo '"\u003c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 4'

echo '$ echo '\''"\u003c"'\''|json -b 5'
echo '"\u003c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 5'

echo '$ echo '\''"\u003c"'\''|json -b 6'
echo '"\u003c"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 6'

echo '$ echo '\''"\u003c"'\''|json -b 7'
echo '"\u003c"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 7'

echo '$ echo '\''"\u003c"'\''|json -b 8'
echo '"\u003c"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u003c"'\''|json -b 8'

echo '$ echo '\''"\u003d"'\''|json -b 1'
echo '"\u003d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 1'

echo '$ echo '\''"\u003d"'\''|json -b 2'
echo '"\u003d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 2'

echo '$ echo '\''"\u003d"'\''|json -b 3'
echo '"\u003d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 3'

echo '$ echo '\''"\u003d"'\''|json -b 4'
echo '"\u003d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 4'

echo '$ echo '\''"\u003d"'\''|json -b 5'
echo '"\u003d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 5'

echo '$ echo '\''"\u003d"'\''|json -b 6'
echo '"\u003d"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 6'

echo '$ echo '\''"\u003d"'\''|json -b 7'
echo '"\u003d"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 7'

echo '$ echo '\''"\u003d"'\''|json -b 8'
echo '"\u003d"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u003d"'\''|json -b 8'

echo '$ echo '\''"\u003e"'\''|json -b 1'
echo '"\u003e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 1'

echo '$ echo '\''"\u003e"'\''|json -b 2'
echo '"\u003e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 2'

echo '$ echo '\''"\u003e"'\''|json -b 3'
echo '"\u003e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 3'

echo '$ echo '\''"\u003e"'\''|json -b 4'
echo '"\u003e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 4'

echo '$ echo '\''"\u003e"'\''|json -b 5'
echo '"\u003e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 5'

echo '$ echo '\''"\u003e"'\''|json -b 6'
echo '"\u003e"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 6'

echo '$ echo '\''"\u003e"'\''|json -b 7'
echo '"\u003e"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 7'

echo '$ echo '\''"\u003e"'\''|json -b 8'
echo '"\u003e"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u003e"'\''|json -b 8'

echo '$ echo '\''"\u003f"'\''|json -b 1'
echo '"\u003f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 1'

echo '$ echo '\''"\u003f"'\''|json -b 2'
echo '"\u003f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 2'

echo '$ echo '\''"\u003f"'\''|json -b 3'
echo '"\u003f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 3'

echo '$ echo '\''"\u003f"'\''|json -b 4'
echo '"\u003f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 4'

echo '$ echo '\''"\u003f"'\''|json -b 5'
echo '"\u003f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 5'

echo '$ echo '\''"\u003f"'\''|json -b 6'
echo '"\u003f"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 6'

echo '$ echo '\''"\u003f"'\''|json -b 7'
echo '"\u003f"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 7'

echo '$ echo '\''"\u003f"'\''|json -b 8'
echo '"\u003f"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u003f"'\''|json -b 8'
)

