#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:name
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L name.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"name":null}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":null}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":null}'\''
$ json <<< '\''{"name":false}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":false}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":false}'\''
$ json <<< '\''{"name":true}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":true}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":true}'\''
$ json <<< '\''{"name":123}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":123}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":123}'\''
$ json <<< '\''{"name":"foo"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"foo"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"foo"}'\''
$ json <<< '\''{"name":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"type"}'\''
$ json <<< '\''{"name":"null"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"null"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"null"}'\''
$ json <<< '\''{"name":"boolean"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"boolean"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"boolean"}'\''
$ json <<< '\''{"name":"number"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"number"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"number"}'\''
$ json <<< '\''{"name":"string"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"string"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"string"}'\''
$ json <<< '\''{"name":"object"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"object"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"object"}'\''
$ json <<< '\''{"name":"array"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"array"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"array"}'\''
$ json <<< '\''{"name":"list"}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":"list"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"list"}'\''
$ json <<< '\''{"name":{}}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":{}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":{}}'\''
$ json <<< '\''{"name":{"foo":"bar"}}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":{"foo":"bar"}}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":{"foo":"bar"}}'\''
$ json <<< '\''{"name":[]}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":[]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":[]}'\''
$ json <<< '\''{"name":["foo","bar"]}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":["foo","bar"]}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":["foo","bar"]}'\'''
) -L name.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"name":null}'\'''
json <<< '{"name":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":null}'\'''

echo '$ json <<< '\''{"name":false}'\'''
json <<< '{"name":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":false}'\'''

echo '$ json <<< '\''{"name":true}'\'''
json <<< '{"name":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":true}'\'''

echo '$ json <<< '\''{"name":123}'\'''
json <<< '{"name":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":123}'\'''

echo '$ json <<< '\''{"name":"foo"}'\'''
json <<< '{"name":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"foo"}'\'''

echo '$ json <<< '\''{"name":"type"}'\'''
json <<< '{"name":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"type"}'\'''

echo '$ json <<< '\''{"name":"null"}'\'''
json <<< '{"name":"null"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"null"}'\'''

echo '$ json <<< '\''{"name":"boolean"}'\'''
json <<< '{"name":"boolean"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"boolean"}'\'''

echo '$ json <<< '\''{"name":"number"}'\'''
json <<< '{"name":"number"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"number"}'\'''

echo '$ json <<< '\''{"name":"string"}'\'''
json <<< '{"name":"string"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"string"}'\'''

echo '$ json <<< '\''{"name":"object"}'\'''
json <<< '{"name":"object"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"object"}'\'''

echo '$ json <<< '\''{"name":"array"}'\'''
json <<< '{"name":"array"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"array"}'\'''

echo '$ json <<< '\''{"name":"list"}'\'''
json <<< '{"name":"list"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"list"}'\'''

echo '$ json <<< '\''{"name":{}}'\'''
json <<< '{"name":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":{}}'\'''

echo '$ json <<< '\''{"name":{"foo":"bar"}}'\'''
json <<< '{"name":{"foo":"bar"}}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":{"foo":"bar"}}'\'''

echo '$ json <<< '\''{"name":[]}'\'''
json <<< '{"name":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":[]}'\'''

echo '$ json <<< '\''{"name":["foo","bar"]}'\'''
json <<< '{"name":["foo","bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":["foo","bar"]}'\'''
)

