#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-open-array-any-empty-closed-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-open-array-any-empty-closed-array.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:55)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"type"},{"type":"array","args":[]
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "type"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "type"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:55)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"null"},{"type":"array","args":[]
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "null"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "null"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:58)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"boolean"},{"type":"array","args"
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "boolean"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "boolean"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:57)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"number"},{"type":"array","args":
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "number"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "number"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"string"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:57)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"string"},{"type":"array","args":
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "string"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "string"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"string"},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"object"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:57)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"object"},{"type":"array","args":
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "object"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "object"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"object"},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":"array"},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:47: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:56)
json: error: <stdin>:1:47: ,"args":[{"type":"array","args":"array"},{"type":"array","args":[
json: error: <stdin>:1:47:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": "array"
        },
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": "array"
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"array"},{"type":"array","args":[]}]}'\'''
) -L list-open-array-any-empty-closed-array.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"type"},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"number"},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"string"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"string"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"string"},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"object"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"object"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"object"},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":"array"},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":"array"},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":"array"},{"type":"array","args":[]}]}'\'''
)

