#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:closed-array8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L closed-array8.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[null,false,123]'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: [null,false,123]
json: error: <stdin>:1:12:            ^
[null,false
command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[null,false,123]'\''
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null,null]'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: [null,null,null]
json: error: <stdin>:1:11:           ^
[null,null
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null,null]'\''
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true,false]'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: [false,true,false]
json: error: <stdin>:1:12:            ^
[false,true
command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true,false]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[123,456,789]'\''
json: error: <stdin>:1:9: type check error: too many arguments
json: error: <stdin>:1:9: [123,456,789]
json: error: <stdin>:1:9:         ^
[123,456
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[123,456,789]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["foo","bar","baz"]'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: ["foo","bar","baz"]
json: error: <stdin>:1:13:             ^
["foo","bar"
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["foo","bar","baz"]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{"foo":1},{"foo":1,"bar":2}]'\''
json: error: <stdin>:1:14: type check error: too many arguments
json: error: <stdin>:1:14: [{},{"foo":1},{"foo":1,"bar":2}]
json: error: <stdin>:1:14:              ^
[{},{"foo":1}
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{"foo":1},{"foo":1,"bar":2}]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[[]],[[[]]]]'\''
json: error: <stdin>:1:9: type check error: too many arguments
json: error: <stdin>:1:9: [[],[[]],[[[]]]]
json: error: <stdin>:1:9:         ^
[[],[[]]
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[[]],[[[]]]]'\'''
) -L closed-array8.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[null,false,123]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[null,false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[null,false,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null,null]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true,false]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[123,456,789]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[123,456,789]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[123,456,789]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["foo","bar","baz"]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["foo","bar","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["foo","bar","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{"foo":1},{"foo":1,"bar":2}]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},{"foo":1},{"foo":1,"bar":2}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{"foo":1},{"foo":1,"bar":2}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[[]],[[[]]]]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],[[]],[[[]]]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[[]],[[[]]]]'\'''
)

