#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-basic-val-object-basic-basic3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-basic-val-object-basic-basic3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
{"faa":[{}],"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
{"faa":[{}],"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
{"faa":[{}],"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
{"faa":[{}],"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
{"faa":[{}],"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
{"faa":[{}],"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
{"faa":[{}],"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
{"faa":[{}],"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
{"faa":[{}],"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
{"faa":[{}],"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
{"faa":[{}],"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
{"faa":[{}],"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
{"faa":[{}],"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":[{}],"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":[{}],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\''
{"faa":[{}],"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
{"faa":null,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
{"faa":null,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
{"faa":null,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
{"faa":null,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
{"faa":null,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
{"faa":null,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
{"faa":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
{"faa":null,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":[]}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":null}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":false}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":true}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":123}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:19: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:19: {"faa":null,"baa":{}}
json: error: <stdin>:1:19:                   ^
{"faa":null,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
{"faa":null,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
{"faa":false,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
{"faa":false,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
{"faa":false,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
{"faa":false,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
{"faa":false,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
{"faa":false,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
{"faa":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
{"faa":false,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":false,"baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":false,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
{"faa":false,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
{"faa":456,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
{"faa":456,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
{"faa":456,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
{"faa":456,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
{"faa":456,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
{"faa":456,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
{"faa":456,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
{"faa":456,"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
{"faa":456,"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
{"faa":456,"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
{"faa":456,"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
{"faa":456,"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
{"faa":456,"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":[]}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":null}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":false}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":true}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":123}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":"foo"}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
json: error: <stdin>:1:18: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:18: {"faa":456,"baa":{}}
json: error: <stdin>:1:18:                  ^
{"faa":456,"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\''
{"faa":456,"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
{"faa":"bar","baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
{"faa":"bar","baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
{"faa":"bar","baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
{"faa":"bar","baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
{"faa":"bar","baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
{"faa":"bar","baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
{"faa":"bar","baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
{"faa":"bar","baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
{"faa":"bar","baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
{"faa":"bar","baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
{"faa":"bar","baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
{"faa":"bar","baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
{"faa":"bar","baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":[]}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":null}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":false}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":true}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":123}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":"foo"}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
json: error: <stdin>:1:20: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:20: {"faa":"bar","baa":{}}
json: error: <stdin>:1:20:                    ^
{"faa":"bar","baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\''
{"faa":"bar","baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
{"faa":{},"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
{"faa":{},"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
{"faa":{},"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
{"faa":{},"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
{"faa":{},"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
{"faa":{},"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
{"faa":{},"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
{"faa":{},"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
{"faa":{},"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
{"faa":{},"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
{"faa":{},"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
{"faa":{},"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
{"faa":{},"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":{},"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":{},"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\''
{"faa":{},"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
{"faa":[],"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
{"faa":[],"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
{"faa":[],"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
{"faa":[],"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
{"faa":[],"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
{"faa":[],"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
{"faa":[],"baa":[]}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
{"faa":[],"baa":null}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
{"faa":[],"baa":false}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
{"faa":[],"baa":true}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
{"faa":[],"baa":123}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
{"faa":[],"baa":"foo"}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
{"faa":[],"baa":{}}
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":[]}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":null}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":false}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":true}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":123}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":"foo"}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
json: error: <stdin>:1:17: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:17: {"faa":[],"baa":{}}
json: error: <stdin>:1:17:                 ^
{"faa":[],"baa":
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\''
{"faa":[],"baa":[]}'
) -L list-object-basic-basic-val-object-basic-basic3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{"faa":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"faa":[],"baa":[]}'\'''
)

