#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-basic-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-basic-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\'''
) -L list-closed-array-basic-basic-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\'''
)

