#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:builtins4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins4.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr '\''date(`%Z`)'\'' '\''"ADT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"ADTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"ADT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"ADT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" ADT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" ADTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" ADT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" ADT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooADT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooADTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooADT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooADT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo ADT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ADTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo ADT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo ADT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"AKDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"AKDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"AKDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"AKDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" AKDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" AKDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" AKDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" AKDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooAKDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooAKDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooAKDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAKDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo AKDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo AKDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo AKDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AKDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"AKST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"AKSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"AKST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"AKST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" AKST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" AKSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" AKST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" AKST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooAKST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooAKSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooAKST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAKST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo AKST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo AKSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo AKST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AKST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"ART"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"ARTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"ART "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"ART bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" ART"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" ARTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" ART "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" ART bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooART"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooARTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooART "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooART bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo ART"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ARTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo ART "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo ART bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"AST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"ASTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"AST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"AST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" AST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" ASTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" AST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" AST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooAST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooASTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooAST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo AST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ASTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo AST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"BRST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"BRSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"BRST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"BRST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" BRST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" BRSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" BRST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" BRST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooBRST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBRSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooBRST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBRST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo BRST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BRSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo BRST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BRST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"BRT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"BRTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"BRT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"BRT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" BRT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" BRTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" BRT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" BRT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooBRT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBRTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooBRT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBRT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo BRT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BRTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo BRT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BRT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"BST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"BSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"BST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"BST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" BST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" BSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" BST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" BST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooBST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooBST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo BST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo BST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CAT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CATbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CAT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CAT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CAT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CATbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CAT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CAT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCAT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCATbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCAT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCAT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CAT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CATbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CAT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CAT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CEST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CESTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CEST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CEST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CEST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CESTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CEST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CEST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCEST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCESTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCEST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCEST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CEST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CESTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CEST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CEST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CET"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CETbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CET "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CET bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CET"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CETbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CET "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CET bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCET"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCETbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCET "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCET bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CET"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CETbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CET "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CET bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CLST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CLSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CLST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CLST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CLST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CLSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CLST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CLST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCLST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCLSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCLST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCLST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CLST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CLSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CLST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CLST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CLT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CLTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CLT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CLT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CLT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CLTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CLT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CLT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCLT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCLTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCLT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCLT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CLT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CLTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CLT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CLT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"CST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"CSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"CST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"CST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" CST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" CSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" CST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" CST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"EAT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"EATbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"EAT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"EAT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" EAT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" EATbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" EAT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" EAT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEAT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEATbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEAT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEAT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EAT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EATbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EAT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EAT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"EDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"EDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"EDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"EDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" EDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" EDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" EDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" EDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"EEST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"EESTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"EEST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"EEST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" EEST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" EESTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" EEST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" EEST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEEST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEESTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEEST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEEST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EEST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EESTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EEST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EEST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"EET"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"EETbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"EET "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"EET bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" EET"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" EETbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" EET "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" EET bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEET"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEETbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEET "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEET bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EET"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EETbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EET "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EET bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"EST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"ESTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"EST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"EST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" EST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" ESTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" EST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" EST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooESTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ESTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"GST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"GSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"GST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"GST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" GST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" GSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" GST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" GST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooGST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooGSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooGST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooGST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo GST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo GSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo GST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo GST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"HADT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"HADTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"HADT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"HADT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" HADT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" HADTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" HADT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" HADT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooHADT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHADTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooHADT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHADT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo HADT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HADTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo HADT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HADT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"HAST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"HASTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"HAST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"HAST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" HAST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" HASTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" HAST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" HAST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooHAST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHASTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooHAST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHAST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo HAST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HASTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo HAST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HAST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"HST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"HSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"HST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"HST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" HST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" HSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" HST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" HST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooHST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooHST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo HST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo HST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"IST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"ISTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"IST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"IST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" IST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" ISTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" IST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" IST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooIST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooISTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooIST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooIST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo IST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ISTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo IST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo IST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"JST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"JSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"JST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"JST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" JST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" JSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" JST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" JST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooJST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooJSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooJST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooJST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo JST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo JSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo JST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo JST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"KST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"KSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"KST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"KST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" KST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" KSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" KST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" KST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooKST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooKSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooKST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooKST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo KST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo KSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo KST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo KST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MEST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MESTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MEST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MEST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MEST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MESTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MEST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MEST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMEST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMESTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMEST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMEST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MEST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MESTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MEST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MEST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MESZ"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MESZbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MESZ "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MESZ bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MESZ"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MESZbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MESZ "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MESZ bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMESZ"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMESZbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMESZ "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMESZ bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MESZ"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MESZbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MESZ "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MESZ bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MET"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"METbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MET "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MET bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MET"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" METbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MET "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MET bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMET"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMETbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMET "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMET bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MET"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo METbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MET "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MET bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MEZ"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MEZbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MEZ "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MEZ bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MEZ"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MEZbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MEZ "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MEZ bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMEZ"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMEZbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMEZ "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMEZ bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MEZ"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MEZbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MEZ "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MEZ bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MSD"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MSDbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MSD "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MSD bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MSD"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MSDbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MSD "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MSD bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMSD"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSDbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMSD "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMSD bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MSD"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSDbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MSD "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MSD bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MSK"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MSKbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MSK "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MSK bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MSK"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MSKbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MSK "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MSK bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMSK"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSKbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMSK "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMSK bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MSK"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSKbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MSK "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MSK bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"MST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"MSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"MST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"MST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" MST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" MSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" MST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" MST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"NDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"NDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"NDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"NDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" NDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" NDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" NDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" NDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"NST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"NSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"NST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"NST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" NST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" NSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" NST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" NST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"NZDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"NZDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"NZDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"NZDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" NZDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" NZDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" NZDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" NZDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNZDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNZDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNZDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNZDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NZDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NZDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NZDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NZDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"NZST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"NZSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"NZST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"NZST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" NZST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" NZSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" NZST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" NZST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNZST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNZSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNZST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNZST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NZST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NZSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NZST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NZST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"PDT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"PDTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"PDT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"PDT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" PDT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" PDTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" PDT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" PDT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooPDT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooPDTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooPDT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooPDT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo PDT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo PDTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo PDT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo PDT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"PST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"PSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"PST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"PST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" PST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" PSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" PST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" PST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooPST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooPSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooPST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooPST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo PST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo PSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo PST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo PST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"SAST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"SASTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"SAST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"SAST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" SAST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" SASTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" SAST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" SAST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooSAST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSASTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooSAST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSAST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo SAST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SASTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo SAST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SAST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"SGT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"SGTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"SGT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"SGT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" SGT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" SGTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" SGT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" SGT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooSGT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSGTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooSGT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSGT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo SGT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SGTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo SGT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SGT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"SST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"SSTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"SST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"SST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" SST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" SSTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" SST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" SST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooSST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSSTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooSST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo SST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SSTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo SST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"UTC"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"UTCbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"UTC "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"UTC bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" UTC"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" UTCbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" UTC "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" UTC bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooUTC"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooUTCbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooUTC "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooUTC bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo UTC"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo UTCbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo UTC "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo UTC bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"WAT"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"WATbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"WAT "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"WAT bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" WAT"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" WATbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" WAT "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" WAT bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooWAT"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWATbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooWAT "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWAT bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo WAT"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WATbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo WAT "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WAT bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"WEST"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"WESTbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"WEST "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"WEST bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" WEST"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" WESTbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" WEST "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" WEST bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooWEST"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWESTbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooWEST "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWEST bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo WEST"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WESTbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo WEST "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WEST bar"'\''
1
$ test-expr '\''date(`%Z`)'\'' '\''"WET"'\''
1
$ test-expr '\''date(`%Zbar`)'\'' '\''"WETbar"'\''
1
$ test-expr '\''date(`%Z `)'\'' '\''"WET "'\''
1
$ test-expr '\''date(`%Z bar`)'\'' '\''"WET bar"'\''
1
$ test-expr '\''date(` %Z`)'\'' '\''" WET"'\''
1
$ test-expr '\''date(` %Zbar`)'\'' '\''" WETbar"'\''
1
$ test-expr '\''date(` %Z `)'\'' '\''" WET "'\''
1
$ test-expr '\''date(` %Z bar`)'\'' '\''" WET bar"'\''
1
$ test-expr '\''date(`foo%Z`)'\'' '\''"fooWET"'\''
1
$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWETbar"'\''
1
$ test-expr '\''date(`foo%Z `)'\'' '\''"fooWET "'\''
1
$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWET bar"'\''
1
$ test-expr '\''date(`foo %Z`)'\'' '\''"foo WET"'\''
1
$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WETbar"'\''
1
$ test-expr '\''date(`foo %Z `)'\'' '\''"foo WET "'\''
1
$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WET bar"'\''
1'
) -L builtins4.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr '\''date(`%Z`)'\'' '\''"ADT"'\'''
test-expr 'date(`%Z`)' '"ADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"ADT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"ADTbar"'\'''
test-expr 'date(`%Zbar`)' '"ADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"ADTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"ADT "'\'''
test-expr 'date(`%Z `)' '"ADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"ADT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"ADT bar"'\'''
test-expr 'date(`%Z bar`)' '"ADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"ADT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" ADT"'\'''
test-expr 'date(` %Z`)' '" ADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" ADT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" ADTbar"'\'''
test-expr 'date(` %Zbar`)' '" ADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" ADTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" ADT "'\'''
test-expr 'date(` %Z `)' '" ADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" ADT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" ADT bar"'\'''
test-expr 'date(` %Z bar`)' '" ADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" ADT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooADT"'\'''
test-expr 'date(`foo%Z`)' '"fooADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooADT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooADTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooADTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooADT "'\'''
test-expr 'date(`foo%Z `)' '"fooADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooADT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooADT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooADT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo ADT"'\'''
test-expr 'date(`foo %Z`)' '"foo ADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo ADT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ADTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo ADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ADTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo ADT "'\'''
test-expr 'date(`foo %Z `)' '"foo ADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo ADT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo ADT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo ADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo ADT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"AKDT"'\'''
test-expr 'date(`%Z`)' '"AKDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"AKDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"AKDTbar"'\'''
test-expr 'date(`%Zbar`)' '"AKDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"AKDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"AKDT "'\'''
test-expr 'date(`%Z `)' '"AKDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"AKDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"AKDT bar"'\'''
test-expr 'date(`%Z bar`)' '"AKDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"AKDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" AKDT"'\'''
test-expr 'date(` %Z`)' '" AKDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" AKDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" AKDTbar"'\'''
test-expr 'date(` %Zbar`)' '" AKDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" AKDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" AKDT "'\'''
test-expr 'date(` %Z `)' '" AKDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" AKDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" AKDT bar"'\'''
test-expr 'date(` %Z bar`)' '" AKDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" AKDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooAKDT"'\'''
test-expr 'date(`foo%Z`)' '"fooAKDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooAKDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooAKDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooAKDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooAKDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooAKDT "'\'''
test-expr 'date(`foo%Z `)' '"fooAKDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooAKDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAKDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooAKDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAKDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo AKDT"'\'''
test-expr 'date(`foo %Z`)' '"foo AKDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo AKDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo AKDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo AKDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo AKDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo AKDT "'\'''
test-expr 'date(`foo %Z `)' '"foo AKDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo AKDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AKDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo AKDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AKDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"AKST"'\'''
test-expr 'date(`%Z`)' '"AKST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"AKST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"AKSTbar"'\'''
test-expr 'date(`%Zbar`)' '"AKSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"AKSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"AKST "'\'''
test-expr 'date(`%Z `)' '"AKST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"AKST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"AKST bar"'\'''
test-expr 'date(`%Z bar`)' '"AKST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"AKST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" AKST"'\'''
test-expr 'date(` %Z`)' '" AKST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" AKST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" AKSTbar"'\'''
test-expr 'date(` %Zbar`)' '" AKSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" AKSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" AKST "'\'''
test-expr 'date(` %Z `)' '" AKST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" AKST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" AKST bar"'\'''
test-expr 'date(` %Z bar`)' '" AKST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" AKST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooAKST"'\'''
test-expr 'date(`foo%Z`)' '"fooAKST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooAKST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooAKSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooAKSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooAKSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooAKST "'\'''
test-expr 'date(`foo%Z `)' '"fooAKST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooAKST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAKST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooAKST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAKST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo AKST"'\'''
test-expr 'date(`foo %Z`)' '"foo AKST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo AKST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo AKSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo AKSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo AKSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo AKST "'\'''
test-expr 'date(`foo %Z `)' '"foo AKST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo AKST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AKST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo AKST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AKST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"ART"'\'''
test-expr 'date(`%Z`)' '"ART"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"ART"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"ARTbar"'\'''
test-expr 'date(`%Zbar`)' '"ARTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"ARTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"ART "'\'''
test-expr 'date(`%Z `)' '"ART "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"ART "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"ART bar"'\'''
test-expr 'date(`%Z bar`)' '"ART bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"ART bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" ART"'\'''
test-expr 'date(` %Z`)' '" ART"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" ART"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" ARTbar"'\'''
test-expr 'date(` %Zbar`)' '" ARTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" ARTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" ART "'\'''
test-expr 'date(` %Z `)' '" ART "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" ART "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" ART bar"'\'''
test-expr 'date(` %Z bar`)' '" ART bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" ART bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooART"'\'''
test-expr 'date(`foo%Z`)' '"fooART"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooART"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooARTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooARTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooARTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooART "'\'''
test-expr 'date(`foo%Z `)' '"fooART "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooART "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooART bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooART bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooART bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo ART"'\'''
test-expr 'date(`foo %Z`)' '"foo ART"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo ART"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ARTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo ARTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ARTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo ART "'\'''
test-expr 'date(`foo %Z `)' '"foo ART "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo ART "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo ART bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo ART bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo ART bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"AST"'\'''
test-expr 'date(`%Z`)' '"AST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"AST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"ASTbar"'\'''
test-expr 'date(`%Zbar`)' '"ASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"ASTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"AST "'\'''
test-expr 'date(`%Z `)' '"AST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"AST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"AST bar"'\'''
test-expr 'date(`%Z bar`)' '"AST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"AST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" AST"'\'''
test-expr 'date(` %Z`)' '" AST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" AST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" ASTbar"'\'''
test-expr 'date(` %Zbar`)' '" ASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" ASTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" AST "'\'''
test-expr 'date(` %Z `)' '" AST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" AST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" AST bar"'\'''
test-expr 'date(` %Z bar`)' '" AST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" AST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooAST"'\'''
test-expr 'date(`foo%Z`)' '"fooAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooAST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooASTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooASTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooAST "'\'''
test-expr 'date(`foo%Z `)' '"fooAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooAST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooAST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo AST"'\'''
test-expr 'date(`foo %Z`)' '"foo AST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo AST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ASTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo ASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ASTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo AST "'\'''
test-expr 'date(`foo %Z `)' '"foo AST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo AST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo AST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo AST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"BRST"'\'''
test-expr 'date(`%Z`)' '"BRST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"BRST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"BRSTbar"'\'''
test-expr 'date(`%Zbar`)' '"BRSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"BRSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"BRST "'\'''
test-expr 'date(`%Z `)' '"BRST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"BRST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"BRST bar"'\'''
test-expr 'date(`%Z bar`)' '"BRST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"BRST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" BRST"'\'''
test-expr 'date(` %Z`)' '" BRST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" BRST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" BRSTbar"'\'''
test-expr 'date(` %Zbar`)' '" BRSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" BRSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" BRST "'\'''
test-expr 'date(` %Z `)' '" BRST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" BRST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" BRST bar"'\'''
test-expr 'date(` %Z bar`)' '" BRST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" BRST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooBRST"'\'''
test-expr 'date(`foo%Z`)' '"fooBRST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooBRST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBRSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooBRSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBRSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooBRST "'\'''
test-expr 'date(`foo%Z `)' '"fooBRST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooBRST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBRST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooBRST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBRST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo BRST"'\'''
test-expr 'date(`foo %Z`)' '"foo BRST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo BRST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BRSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo BRSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BRSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo BRST "'\'''
test-expr 'date(`foo %Z `)' '"foo BRST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo BRST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BRST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo BRST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BRST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"BRT"'\'''
test-expr 'date(`%Z`)' '"BRT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"BRT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"BRTbar"'\'''
test-expr 'date(`%Zbar`)' '"BRTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"BRTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"BRT "'\'''
test-expr 'date(`%Z `)' '"BRT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"BRT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"BRT bar"'\'''
test-expr 'date(`%Z bar`)' '"BRT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"BRT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" BRT"'\'''
test-expr 'date(` %Z`)' '" BRT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" BRT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" BRTbar"'\'''
test-expr 'date(` %Zbar`)' '" BRTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" BRTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" BRT "'\'''
test-expr 'date(` %Z `)' '" BRT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" BRT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" BRT bar"'\'''
test-expr 'date(` %Z bar`)' '" BRT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" BRT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooBRT"'\'''
test-expr 'date(`foo%Z`)' '"fooBRT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooBRT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBRTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooBRTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBRTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooBRT "'\'''
test-expr 'date(`foo%Z `)' '"fooBRT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooBRT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBRT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooBRT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBRT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo BRT"'\'''
test-expr 'date(`foo %Z`)' '"foo BRT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo BRT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BRTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo BRTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BRTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo BRT "'\'''
test-expr 'date(`foo %Z `)' '"foo BRT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo BRT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BRT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo BRT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BRT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"BST"'\'''
test-expr 'date(`%Z`)' '"BST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"BST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"BSTbar"'\'''
test-expr 'date(`%Zbar`)' '"BSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"BSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"BST "'\'''
test-expr 'date(`%Z `)' '"BST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"BST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"BST bar"'\'''
test-expr 'date(`%Z bar`)' '"BST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"BST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" BST"'\'''
test-expr 'date(` %Z`)' '" BST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" BST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" BSTbar"'\'''
test-expr 'date(` %Zbar`)' '" BSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" BSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" BST "'\'''
test-expr 'date(` %Z `)' '" BST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" BST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" BST bar"'\'''
test-expr 'date(` %Z bar`)' '" BST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" BST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooBST"'\'''
test-expr 'date(`foo%Z`)' '"fooBST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooBST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooBSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooBSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooBST "'\'''
test-expr 'date(`foo%Z `)' '"fooBST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooBST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooBST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooBST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo BST"'\'''
test-expr 'date(`foo %Z`)' '"foo BST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo BST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo BSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo BSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo BST "'\'''
test-expr 'date(`foo %Z `)' '"foo BST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo BST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo BST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo BST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CAT"'\'''
test-expr 'date(`%Z`)' '"CAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CAT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CATbar"'\'''
test-expr 'date(`%Zbar`)' '"CATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CATbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CAT "'\'''
test-expr 'date(`%Z `)' '"CAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CAT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CAT bar"'\'''
test-expr 'date(`%Z bar`)' '"CAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CAT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CAT"'\'''
test-expr 'date(` %Z`)' '" CAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CAT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CATbar"'\'''
test-expr 'date(` %Zbar`)' '" CATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CATbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CAT "'\'''
test-expr 'date(` %Z `)' '" CAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CAT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CAT bar"'\'''
test-expr 'date(` %Z bar`)' '" CAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CAT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCAT"'\'''
test-expr 'date(`foo%Z`)' '"fooCAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCAT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCATbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCATbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCAT "'\'''
test-expr 'date(`foo%Z `)' '"fooCAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCAT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCAT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCAT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CAT"'\'''
test-expr 'date(`foo %Z`)' '"foo CAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CAT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CATbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CATbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CAT "'\'''
test-expr 'date(`foo %Z `)' '"foo CAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CAT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CAT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CAT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CDT"'\'''
test-expr 'date(`%Z`)' '"CDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CDTbar"'\'''
test-expr 'date(`%Zbar`)' '"CDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CDT "'\'''
test-expr 'date(`%Z `)' '"CDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CDT bar"'\'''
test-expr 'date(`%Z bar`)' '"CDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CDT"'\'''
test-expr 'date(` %Z`)' '" CDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CDTbar"'\'''
test-expr 'date(` %Zbar`)' '" CDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CDT "'\'''
test-expr 'date(` %Z `)' '" CDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CDT bar"'\'''
test-expr 'date(` %Z bar`)' '" CDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCDT"'\'''
test-expr 'date(`foo%Z`)' '"fooCDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCDT "'\'''
test-expr 'date(`foo%Z `)' '"fooCDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CDT"'\'''
test-expr 'date(`foo %Z`)' '"foo CDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CDT "'\'''
test-expr 'date(`foo %Z `)' '"foo CDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CEST"'\'''
test-expr 'date(`%Z`)' '"CEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CEST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CESTbar"'\'''
test-expr 'date(`%Zbar`)' '"CESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CESTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CEST "'\'''
test-expr 'date(`%Z `)' '"CEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CEST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CEST bar"'\'''
test-expr 'date(`%Z bar`)' '"CEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CEST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CEST"'\'''
test-expr 'date(` %Z`)' '" CEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CEST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CESTbar"'\'''
test-expr 'date(` %Zbar`)' '" CESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CESTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CEST "'\'''
test-expr 'date(` %Z `)' '" CEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CEST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CEST bar"'\'''
test-expr 'date(` %Z bar`)' '" CEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CEST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCEST"'\'''
test-expr 'date(`foo%Z`)' '"fooCEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCEST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCESTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCESTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCEST "'\'''
test-expr 'date(`foo%Z `)' '"fooCEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCEST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCEST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCEST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CEST"'\'''
test-expr 'date(`foo %Z`)' '"foo CEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CEST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CESTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CESTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CEST "'\'''
test-expr 'date(`foo %Z `)' '"foo CEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CEST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CEST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CEST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CET"'\'''
test-expr 'date(`%Z`)' '"CET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CET"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CETbar"'\'''
test-expr 'date(`%Zbar`)' '"CETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CETbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CET "'\'''
test-expr 'date(`%Z `)' '"CET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CET "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CET bar"'\'''
test-expr 'date(`%Z bar`)' '"CET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CET bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CET"'\'''
test-expr 'date(` %Z`)' '" CET"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CET"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CETbar"'\'''
test-expr 'date(` %Zbar`)' '" CETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CETbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CET "'\'''
test-expr 'date(` %Z `)' '" CET "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CET "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CET bar"'\'''
test-expr 'date(` %Z bar`)' '" CET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CET bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCET"'\'''
test-expr 'date(`foo%Z`)' '"fooCET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCET"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCETbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCETbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCET "'\'''
test-expr 'date(`foo%Z `)' '"fooCET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCET "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCET bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCET bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CET"'\'''
test-expr 'date(`foo %Z`)' '"foo CET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CET"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CETbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CETbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CET "'\'''
test-expr 'date(`foo %Z `)' '"foo CET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CET "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CET bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CET bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CLST"'\'''
test-expr 'date(`%Z`)' '"CLST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CLST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CLSTbar"'\'''
test-expr 'date(`%Zbar`)' '"CLSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CLSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CLST "'\'''
test-expr 'date(`%Z `)' '"CLST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CLST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CLST bar"'\'''
test-expr 'date(`%Z bar`)' '"CLST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CLST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CLST"'\'''
test-expr 'date(` %Z`)' '" CLST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CLST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CLSTbar"'\'''
test-expr 'date(` %Zbar`)' '" CLSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CLSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CLST "'\'''
test-expr 'date(` %Z `)' '" CLST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CLST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CLST bar"'\'''
test-expr 'date(` %Z bar`)' '" CLST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CLST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCLST"'\'''
test-expr 'date(`foo%Z`)' '"fooCLST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCLST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCLSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCLSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCLSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCLST "'\'''
test-expr 'date(`foo%Z `)' '"fooCLST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCLST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCLST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCLST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCLST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CLST"'\'''
test-expr 'date(`foo %Z`)' '"foo CLST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CLST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CLSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CLSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CLSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CLST "'\'''
test-expr 'date(`foo %Z `)' '"foo CLST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CLST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CLST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CLST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CLST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CLT"'\'''
test-expr 'date(`%Z`)' '"CLT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CLT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CLTbar"'\'''
test-expr 'date(`%Zbar`)' '"CLTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CLTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CLT "'\'''
test-expr 'date(`%Z `)' '"CLT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CLT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CLT bar"'\'''
test-expr 'date(`%Z bar`)' '"CLT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CLT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CLT"'\'''
test-expr 'date(` %Z`)' '" CLT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CLT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CLTbar"'\'''
test-expr 'date(` %Zbar`)' '" CLTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CLTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CLT "'\'''
test-expr 'date(` %Z `)' '" CLT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CLT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CLT bar"'\'''
test-expr 'date(` %Z bar`)' '" CLT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CLT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCLT"'\'''
test-expr 'date(`foo%Z`)' '"fooCLT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCLT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCLTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCLTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCLTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCLT "'\'''
test-expr 'date(`foo%Z `)' '"fooCLT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCLT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCLT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCLT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCLT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CLT"'\'''
test-expr 'date(`foo %Z`)' '"foo CLT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CLT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CLTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CLTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CLTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CLT "'\'''
test-expr 'date(`foo %Z `)' '"foo CLT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CLT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CLT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CLT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CLT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"CST"'\'''
test-expr 'date(`%Z`)' '"CST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"CST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"CSTbar"'\'''
test-expr 'date(`%Zbar`)' '"CSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"CSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"CST "'\'''
test-expr 'date(`%Z `)' '"CST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"CST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"CST bar"'\'''
test-expr 'date(`%Z bar`)' '"CST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"CST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" CST"'\'''
test-expr 'date(` %Z`)' '" CST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" CST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" CSTbar"'\'''
test-expr 'date(` %Zbar`)' '" CSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" CSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" CST "'\'''
test-expr 'date(` %Z `)' '" CST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" CST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" CST bar"'\'''
test-expr 'date(` %Z bar`)' '" CST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" CST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooCST"'\'''
test-expr 'date(`foo%Z`)' '"fooCST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooCST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooCSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooCSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooCST "'\'''
test-expr 'date(`foo%Z `)' '"fooCST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooCST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooCST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooCST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo CST"'\'''
test-expr 'date(`foo %Z`)' '"foo CST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo CST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo CSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo CSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo CST "'\'''
test-expr 'date(`foo %Z `)' '"foo CST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo CST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo CST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo CST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"EAT"'\'''
test-expr 'date(`%Z`)' '"EAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"EAT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"EATbar"'\'''
test-expr 'date(`%Zbar`)' '"EATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"EATbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"EAT "'\'''
test-expr 'date(`%Z `)' '"EAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"EAT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"EAT bar"'\'''
test-expr 'date(`%Z bar`)' '"EAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"EAT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" EAT"'\'''
test-expr 'date(` %Z`)' '" EAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" EAT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" EATbar"'\'''
test-expr 'date(` %Zbar`)' '" EATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" EATbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" EAT "'\'''
test-expr 'date(` %Z `)' '" EAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" EAT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" EAT bar"'\'''
test-expr 'date(` %Z bar`)' '" EAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" EAT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEAT"'\'''
test-expr 'date(`foo%Z`)' '"fooEAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooEAT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEATbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooEATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEATbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEAT "'\'''
test-expr 'date(`foo%Z `)' '"fooEAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooEAT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEAT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooEAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEAT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EAT"'\'''
test-expr 'date(`foo %Z`)' '"foo EAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo EAT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EATbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo EATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EATbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EAT "'\'''
test-expr 'date(`foo %Z `)' '"foo EAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo EAT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EAT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo EAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EAT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"EDT"'\'''
test-expr 'date(`%Z`)' '"EDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"EDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"EDTbar"'\'''
test-expr 'date(`%Zbar`)' '"EDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"EDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"EDT "'\'''
test-expr 'date(`%Z `)' '"EDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"EDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"EDT bar"'\'''
test-expr 'date(`%Z bar`)' '"EDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"EDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" EDT"'\'''
test-expr 'date(` %Z`)' '" EDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" EDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" EDTbar"'\'''
test-expr 'date(` %Zbar`)' '" EDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" EDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" EDT "'\'''
test-expr 'date(` %Z `)' '" EDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" EDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" EDT bar"'\'''
test-expr 'date(` %Z bar`)' '" EDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" EDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEDT"'\'''
test-expr 'date(`foo%Z`)' '"fooEDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooEDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooEDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEDT "'\'''
test-expr 'date(`foo%Z `)' '"fooEDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooEDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooEDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EDT"'\'''
test-expr 'date(`foo %Z`)' '"foo EDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo EDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo EDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EDT "'\'''
test-expr 'date(`foo %Z `)' '"foo EDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo EDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo EDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"EEST"'\'''
test-expr 'date(`%Z`)' '"EEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"EEST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"EESTbar"'\'''
test-expr 'date(`%Zbar`)' '"EESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"EESTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"EEST "'\'''
test-expr 'date(`%Z `)' '"EEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"EEST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"EEST bar"'\'''
test-expr 'date(`%Z bar`)' '"EEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"EEST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" EEST"'\'''
test-expr 'date(` %Z`)' '" EEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" EEST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" EESTbar"'\'''
test-expr 'date(` %Zbar`)' '" EESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" EESTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" EEST "'\'''
test-expr 'date(` %Z `)' '" EEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" EEST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" EEST bar"'\'''
test-expr 'date(` %Z bar`)' '" EEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" EEST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEEST"'\'''
test-expr 'date(`foo%Z`)' '"fooEEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooEEST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEESTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooEESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEESTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEEST "'\'''
test-expr 'date(`foo%Z `)' '"fooEEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooEEST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEEST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooEEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEEST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EEST"'\'''
test-expr 'date(`foo %Z`)' '"foo EEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo EEST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EESTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo EESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EESTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EEST "'\'''
test-expr 'date(`foo %Z `)' '"foo EEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo EEST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EEST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo EEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EEST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"EET"'\'''
test-expr 'date(`%Z`)' '"EET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"EET"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"EETbar"'\'''
test-expr 'date(`%Zbar`)' '"EETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"EETbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"EET "'\'''
test-expr 'date(`%Z `)' '"EET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"EET "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"EET bar"'\'''
test-expr 'date(`%Z bar`)' '"EET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"EET bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" EET"'\'''
test-expr 'date(` %Z`)' '" EET"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" EET"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" EETbar"'\'''
test-expr 'date(` %Zbar`)' '" EETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" EETbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" EET "'\'''
test-expr 'date(` %Z `)' '" EET "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" EET "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" EET bar"'\'''
test-expr 'date(` %Z bar`)' '" EET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" EET bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEET"'\'''
test-expr 'date(`foo%Z`)' '"fooEET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooEET"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEETbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooEETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooEETbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEET "'\'''
test-expr 'date(`foo%Z `)' '"fooEET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooEET "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEET bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooEET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEET bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EET"'\'''
test-expr 'date(`foo %Z`)' '"foo EET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo EET"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EETbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo EETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo EETbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EET "'\'''
test-expr 'date(`foo %Z `)' '"foo EET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo EET "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EET bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo EET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EET bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"EST"'\'''
test-expr 'date(`%Z`)' '"EST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"EST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"ESTbar"'\'''
test-expr 'date(`%Zbar`)' '"ESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"ESTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"EST "'\'''
test-expr 'date(`%Z `)' '"EST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"EST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"EST bar"'\'''
test-expr 'date(`%Z bar`)' '"EST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"EST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" EST"'\'''
test-expr 'date(` %Z`)' '" EST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" EST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" ESTbar"'\'''
test-expr 'date(` %Zbar`)' '" ESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" ESTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" EST "'\'''
test-expr 'date(` %Z `)' '" EST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" EST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" EST bar"'\'''
test-expr 'date(` %Z bar`)' '" EST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" EST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooEST"'\'''
test-expr 'date(`foo%Z`)' '"fooEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooEST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooESTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooESTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooEST "'\'''
test-expr 'date(`foo%Z `)' '"fooEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooEST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooEST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo EST"'\'''
test-expr 'date(`foo %Z`)' '"foo EST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo EST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ESTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo ESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ESTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo EST "'\'''
test-expr 'date(`foo %Z `)' '"foo EST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo EST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo EST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo EST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"GST"'\'''
test-expr 'date(`%Z`)' '"GST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"GST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"GSTbar"'\'''
test-expr 'date(`%Zbar`)' '"GSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"GSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"GST "'\'''
test-expr 'date(`%Z `)' '"GST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"GST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"GST bar"'\'''
test-expr 'date(`%Z bar`)' '"GST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"GST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" GST"'\'''
test-expr 'date(` %Z`)' '" GST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" GST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" GSTbar"'\'''
test-expr 'date(` %Zbar`)' '" GSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" GSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" GST "'\'''
test-expr 'date(` %Z `)' '" GST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" GST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" GST bar"'\'''
test-expr 'date(` %Z bar`)' '" GST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" GST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooGST"'\'''
test-expr 'date(`foo%Z`)' '"fooGST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooGST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooGSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooGSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooGSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooGST "'\'''
test-expr 'date(`foo%Z `)' '"fooGST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooGST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooGST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooGST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooGST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo GST"'\'''
test-expr 'date(`foo %Z`)' '"foo GST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo GST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo GSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo GSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo GSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo GST "'\'''
test-expr 'date(`foo %Z `)' '"foo GST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo GST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo GST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo GST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo GST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"HADT"'\'''
test-expr 'date(`%Z`)' '"HADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"HADT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"HADTbar"'\'''
test-expr 'date(`%Zbar`)' '"HADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"HADTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"HADT "'\'''
test-expr 'date(`%Z `)' '"HADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"HADT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"HADT bar"'\'''
test-expr 'date(`%Z bar`)' '"HADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"HADT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" HADT"'\'''
test-expr 'date(` %Z`)' '" HADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" HADT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" HADTbar"'\'''
test-expr 'date(` %Zbar`)' '" HADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" HADTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" HADT "'\'''
test-expr 'date(` %Z `)' '" HADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" HADT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" HADT bar"'\'''
test-expr 'date(` %Z bar`)' '" HADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" HADT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooHADT"'\'''
test-expr 'date(`foo%Z`)' '"fooHADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooHADT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHADTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooHADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHADTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooHADT "'\'''
test-expr 'date(`foo%Z `)' '"fooHADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooHADT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHADT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooHADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHADT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo HADT"'\'''
test-expr 'date(`foo %Z`)' '"foo HADT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo HADT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HADTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo HADTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HADTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo HADT "'\'''
test-expr 'date(`foo %Z `)' '"foo HADT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo HADT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HADT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo HADT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HADT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"HAST"'\'''
test-expr 'date(`%Z`)' '"HAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"HAST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"HASTbar"'\'''
test-expr 'date(`%Zbar`)' '"HASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"HASTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"HAST "'\'''
test-expr 'date(`%Z `)' '"HAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"HAST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"HAST bar"'\'''
test-expr 'date(`%Z bar`)' '"HAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"HAST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" HAST"'\'''
test-expr 'date(` %Z`)' '" HAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" HAST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" HASTbar"'\'''
test-expr 'date(` %Zbar`)' '" HASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" HASTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" HAST "'\'''
test-expr 'date(` %Z `)' '" HAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" HAST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" HAST bar"'\'''
test-expr 'date(` %Z bar`)' '" HAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" HAST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooHAST"'\'''
test-expr 'date(`foo%Z`)' '"fooHAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooHAST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHASTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooHASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHASTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooHAST "'\'''
test-expr 'date(`foo%Z `)' '"fooHAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooHAST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHAST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooHAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHAST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo HAST"'\'''
test-expr 'date(`foo %Z`)' '"foo HAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo HAST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HASTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo HASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HASTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo HAST "'\'''
test-expr 'date(`foo %Z `)' '"foo HAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo HAST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HAST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo HAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HAST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"HST"'\'''
test-expr 'date(`%Z`)' '"HST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"HST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"HSTbar"'\'''
test-expr 'date(`%Zbar`)' '"HSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"HSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"HST "'\'''
test-expr 'date(`%Z `)' '"HST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"HST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"HST bar"'\'''
test-expr 'date(`%Z bar`)' '"HST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"HST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" HST"'\'''
test-expr 'date(` %Z`)' '" HST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" HST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" HSTbar"'\'''
test-expr 'date(` %Zbar`)' '" HSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" HSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" HST "'\'''
test-expr 'date(` %Z `)' '" HST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" HST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" HST bar"'\'''
test-expr 'date(` %Z bar`)' '" HST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" HST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooHST"'\'''
test-expr 'date(`foo%Z`)' '"fooHST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooHST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooHSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooHSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooHST "'\'''
test-expr 'date(`foo%Z `)' '"fooHST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooHST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooHST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooHST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo HST"'\'''
test-expr 'date(`foo %Z`)' '"foo HST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo HST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo HSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo HSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo HST "'\'''
test-expr 'date(`foo %Z `)' '"foo HST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo HST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo HST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo HST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"IST"'\'''
test-expr 'date(`%Z`)' '"IST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"IST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"ISTbar"'\'''
test-expr 'date(`%Zbar`)' '"ISTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"ISTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"IST "'\'''
test-expr 'date(`%Z `)' '"IST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"IST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"IST bar"'\'''
test-expr 'date(`%Z bar`)' '"IST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"IST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" IST"'\'''
test-expr 'date(` %Z`)' '" IST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" IST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" ISTbar"'\'''
test-expr 'date(` %Zbar`)' '" ISTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" ISTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" IST "'\'''
test-expr 'date(` %Z `)' '" IST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" IST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" IST bar"'\'''
test-expr 'date(` %Z bar`)' '" IST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" IST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooIST"'\'''
test-expr 'date(`foo%Z`)' '"fooIST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooIST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooISTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooISTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooISTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooIST "'\'''
test-expr 'date(`foo%Z `)' '"fooIST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooIST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooIST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooIST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooIST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo IST"'\'''
test-expr 'date(`foo %Z`)' '"foo IST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo IST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ISTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo ISTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo ISTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo IST "'\'''
test-expr 'date(`foo %Z `)' '"foo IST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo IST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo IST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo IST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo IST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"JST"'\'''
test-expr 'date(`%Z`)' '"JST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"JST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"JSTbar"'\'''
test-expr 'date(`%Zbar`)' '"JSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"JSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"JST "'\'''
test-expr 'date(`%Z `)' '"JST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"JST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"JST bar"'\'''
test-expr 'date(`%Z bar`)' '"JST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"JST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" JST"'\'''
test-expr 'date(` %Z`)' '" JST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" JST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" JSTbar"'\'''
test-expr 'date(` %Zbar`)' '" JSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" JSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" JST "'\'''
test-expr 'date(` %Z `)' '" JST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" JST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" JST bar"'\'''
test-expr 'date(` %Z bar`)' '" JST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" JST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooJST"'\'''
test-expr 'date(`foo%Z`)' '"fooJST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooJST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooJSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooJSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooJSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooJST "'\'''
test-expr 'date(`foo%Z `)' '"fooJST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooJST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooJST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooJST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooJST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo JST"'\'''
test-expr 'date(`foo %Z`)' '"foo JST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo JST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo JSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo JSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo JSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo JST "'\'''
test-expr 'date(`foo %Z `)' '"foo JST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo JST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo JST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo JST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo JST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"KST"'\'''
test-expr 'date(`%Z`)' '"KST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"KST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"KSTbar"'\'''
test-expr 'date(`%Zbar`)' '"KSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"KSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"KST "'\'''
test-expr 'date(`%Z `)' '"KST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"KST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"KST bar"'\'''
test-expr 'date(`%Z bar`)' '"KST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"KST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" KST"'\'''
test-expr 'date(` %Z`)' '" KST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" KST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" KSTbar"'\'''
test-expr 'date(` %Zbar`)' '" KSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" KSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" KST "'\'''
test-expr 'date(` %Z `)' '" KST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" KST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" KST bar"'\'''
test-expr 'date(` %Z bar`)' '" KST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" KST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooKST"'\'''
test-expr 'date(`foo%Z`)' '"fooKST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooKST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooKSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooKSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooKSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooKST "'\'''
test-expr 'date(`foo%Z `)' '"fooKST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooKST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooKST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooKST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooKST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo KST"'\'''
test-expr 'date(`foo %Z`)' '"foo KST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo KST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo KSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo KSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo KSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo KST "'\'''
test-expr 'date(`foo %Z `)' '"foo KST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo KST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo KST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo KST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo KST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MDT"'\'''
test-expr 'date(`%Z`)' '"MDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MDTbar"'\'''
test-expr 'date(`%Zbar`)' '"MDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MDT "'\'''
test-expr 'date(`%Z `)' '"MDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MDT bar"'\'''
test-expr 'date(`%Z bar`)' '"MDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MDT"'\'''
test-expr 'date(` %Z`)' '" MDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MDTbar"'\'''
test-expr 'date(` %Zbar`)' '" MDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MDT "'\'''
test-expr 'date(` %Z `)' '" MDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MDT bar"'\'''
test-expr 'date(` %Z bar`)' '" MDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMDT"'\'''
test-expr 'date(`foo%Z`)' '"fooMDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMDT "'\'''
test-expr 'date(`foo%Z `)' '"fooMDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MDT"'\'''
test-expr 'date(`foo %Z`)' '"foo MDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MDT "'\'''
test-expr 'date(`foo %Z `)' '"foo MDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MEST"'\'''
test-expr 'date(`%Z`)' '"MEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MEST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MESTbar"'\'''
test-expr 'date(`%Zbar`)' '"MESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MESTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MEST "'\'''
test-expr 'date(`%Z `)' '"MEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MEST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MEST bar"'\'''
test-expr 'date(`%Z bar`)' '"MEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MEST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MEST"'\'''
test-expr 'date(` %Z`)' '" MEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MEST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MESTbar"'\'''
test-expr 'date(` %Zbar`)' '" MESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MESTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MEST "'\'''
test-expr 'date(` %Z `)' '" MEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MEST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MEST bar"'\'''
test-expr 'date(` %Z bar`)' '" MEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MEST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMEST"'\'''
test-expr 'date(`foo%Z`)' '"fooMEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMEST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMESTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMESTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMEST "'\'''
test-expr 'date(`foo%Z `)' '"fooMEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMEST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMEST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMEST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MEST"'\'''
test-expr 'date(`foo %Z`)' '"foo MEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MEST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MESTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MESTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MEST "'\'''
test-expr 'date(`foo %Z `)' '"foo MEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MEST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MEST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MEST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MESZ"'\'''
test-expr 'date(`%Z`)' '"MESZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MESZ"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MESZbar"'\'''
test-expr 'date(`%Zbar`)' '"MESZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MESZbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MESZ "'\'''
test-expr 'date(`%Z `)' '"MESZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MESZ "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MESZ bar"'\'''
test-expr 'date(`%Z bar`)' '"MESZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MESZ bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MESZ"'\'''
test-expr 'date(` %Z`)' '" MESZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MESZ"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MESZbar"'\'''
test-expr 'date(` %Zbar`)' '" MESZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MESZbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MESZ "'\'''
test-expr 'date(` %Z `)' '" MESZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MESZ "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MESZ bar"'\'''
test-expr 'date(` %Z bar`)' '" MESZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MESZ bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMESZ"'\'''
test-expr 'date(`foo%Z`)' '"fooMESZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMESZ"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMESZbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMESZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMESZbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMESZ "'\'''
test-expr 'date(`foo%Z `)' '"fooMESZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMESZ "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMESZ bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMESZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMESZ bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MESZ"'\'''
test-expr 'date(`foo %Z`)' '"foo MESZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MESZ"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MESZbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MESZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MESZbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MESZ "'\'''
test-expr 'date(`foo %Z `)' '"foo MESZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MESZ "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MESZ bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MESZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MESZ bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MET"'\'''
test-expr 'date(`%Z`)' '"MET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MET"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"METbar"'\'''
test-expr 'date(`%Zbar`)' '"METbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"METbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MET "'\'''
test-expr 'date(`%Z `)' '"MET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MET "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MET bar"'\'''
test-expr 'date(`%Z bar`)' '"MET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MET bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MET"'\'''
test-expr 'date(` %Z`)' '" MET"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MET"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" METbar"'\'''
test-expr 'date(` %Zbar`)' '" METbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" METbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MET "'\'''
test-expr 'date(` %Z `)' '" MET "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MET "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MET bar"'\'''
test-expr 'date(` %Z bar`)' '" MET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MET bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMET"'\'''
test-expr 'date(`foo%Z`)' '"fooMET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMET"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMETbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMETbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMET "'\'''
test-expr 'date(`foo%Z `)' '"fooMET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMET "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMET bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMET bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MET"'\'''
test-expr 'date(`foo %Z`)' '"foo MET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MET"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo METbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo METbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo METbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MET "'\'''
test-expr 'date(`foo %Z `)' '"foo MET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MET "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MET bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MET bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MEZ"'\'''
test-expr 'date(`%Z`)' '"MEZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MEZ"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MEZbar"'\'''
test-expr 'date(`%Zbar`)' '"MEZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MEZbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MEZ "'\'''
test-expr 'date(`%Z `)' '"MEZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MEZ "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MEZ bar"'\'''
test-expr 'date(`%Z bar`)' '"MEZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MEZ bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MEZ"'\'''
test-expr 'date(` %Z`)' '" MEZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MEZ"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MEZbar"'\'''
test-expr 'date(` %Zbar`)' '" MEZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MEZbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MEZ "'\'''
test-expr 'date(` %Z `)' '" MEZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MEZ "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MEZ bar"'\'''
test-expr 'date(` %Z bar`)' '" MEZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MEZ bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMEZ"'\'''
test-expr 'date(`foo%Z`)' '"fooMEZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMEZ"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMEZbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMEZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMEZbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMEZ "'\'''
test-expr 'date(`foo%Z `)' '"fooMEZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMEZ "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMEZ bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMEZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMEZ bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MEZ"'\'''
test-expr 'date(`foo %Z`)' '"foo MEZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MEZ"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MEZbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MEZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MEZbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MEZ "'\'''
test-expr 'date(`foo %Z `)' '"foo MEZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MEZ "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MEZ bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MEZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MEZ bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MSD"'\'''
test-expr 'date(`%Z`)' '"MSD"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MSD"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MSDbar"'\'''
test-expr 'date(`%Zbar`)' '"MSDbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MSDbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MSD "'\'''
test-expr 'date(`%Z `)' '"MSD "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MSD "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MSD bar"'\'''
test-expr 'date(`%Z bar`)' '"MSD bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MSD bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MSD"'\'''
test-expr 'date(` %Z`)' '" MSD"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MSD"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MSDbar"'\'''
test-expr 'date(` %Zbar`)' '" MSDbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MSDbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MSD "'\'''
test-expr 'date(` %Z `)' '" MSD "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MSD "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MSD bar"'\'''
test-expr 'date(` %Z bar`)' '" MSD bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MSD bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMSD"'\'''
test-expr 'date(`foo%Z`)' '"fooMSD"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMSD"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSDbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMSDbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSDbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMSD "'\'''
test-expr 'date(`foo%Z `)' '"fooMSD "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMSD "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMSD bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMSD bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMSD bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MSD"'\'''
test-expr 'date(`foo %Z`)' '"foo MSD"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MSD"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSDbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MSDbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSDbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MSD "'\'''
test-expr 'date(`foo %Z `)' '"foo MSD "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MSD "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MSD bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MSD bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MSD bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MSK"'\'''
test-expr 'date(`%Z`)' '"MSK"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MSK"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MSKbar"'\'''
test-expr 'date(`%Zbar`)' '"MSKbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MSKbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MSK "'\'''
test-expr 'date(`%Z `)' '"MSK "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MSK "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MSK bar"'\'''
test-expr 'date(`%Z bar`)' '"MSK bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MSK bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MSK"'\'''
test-expr 'date(` %Z`)' '" MSK"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MSK"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MSKbar"'\'''
test-expr 'date(` %Zbar`)' '" MSKbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MSKbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MSK "'\'''
test-expr 'date(` %Z `)' '" MSK "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MSK "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MSK bar"'\'''
test-expr 'date(` %Z bar`)' '" MSK bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MSK bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMSK"'\'''
test-expr 'date(`foo%Z`)' '"fooMSK"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMSK"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSKbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMSKbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSKbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMSK "'\'''
test-expr 'date(`foo%Z `)' '"fooMSK "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMSK "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMSK bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMSK bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMSK bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MSK"'\'''
test-expr 'date(`foo %Z`)' '"foo MSK"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MSK"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSKbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MSKbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSKbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MSK "'\'''
test-expr 'date(`foo %Z `)' '"foo MSK "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MSK "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MSK bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MSK bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MSK bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"MST"'\'''
test-expr 'date(`%Z`)' '"MST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"MST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"MSTbar"'\'''
test-expr 'date(`%Zbar`)' '"MSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"MSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"MST "'\'''
test-expr 'date(`%Z `)' '"MST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"MST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"MST bar"'\'''
test-expr 'date(`%Z bar`)' '"MST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"MST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" MST"'\'''
test-expr 'date(` %Z`)' '" MST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" MST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" MSTbar"'\'''
test-expr 'date(` %Zbar`)' '" MSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" MSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" MST "'\'''
test-expr 'date(` %Z `)' '" MST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" MST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" MST bar"'\'''
test-expr 'date(` %Z bar`)' '" MST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" MST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooMST"'\'''
test-expr 'date(`foo%Z`)' '"fooMST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooMST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooMSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooMSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooMST "'\'''
test-expr 'date(`foo%Z `)' '"fooMST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooMST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooMST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooMST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo MST"'\'''
test-expr 'date(`foo %Z`)' '"foo MST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo MST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo MSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo MSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo MST "'\'''
test-expr 'date(`foo %Z `)' '"foo MST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo MST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo MST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo MST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"NDT"'\'''
test-expr 'date(`%Z`)' '"NDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"NDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"NDTbar"'\'''
test-expr 'date(`%Zbar`)' '"NDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"NDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"NDT "'\'''
test-expr 'date(`%Z `)' '"NDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"NDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"NDT bar"'\'''
test-expr 'date(`%Z bar`)' '"NDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"NDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" NDT"'\'''
test-expr 'date(` %Z`)' '" NDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" NDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" NDTbar"'\'''
test-expr 'date(` %Zbar`)' '" NDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" NDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" NDT "'\'''
test-expr 'date(` %Z `)' '" NDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" NDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" NDT bar"'\'''
test-expr 'date(` %Z bar`)' '" NDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" NDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNDT"'\'''
test-expr 'date(`foo%Z`)' '"fooNDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooNDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooNDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNDT "'\'''
test-expr 'date(`foo%Z `)' '"fooNDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooNDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooNDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NDT"'\'''
test-expr 'date(`foo %Z`)' '"foo NDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo NDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo NDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NDT "'\'''
test-expr 'date(`foo %Z `)' '"foo NDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo NDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo NDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"NST"'\'''
test-expr 'date(`%Z`)' '"NST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"NST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"NSTbar"'\'''
test-expr 'date(`%Zbar`)' '"NSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"NSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"NST "'\'''
test-expr 'date(`%Z `)' '"NST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"NST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"NST bar"'\'''
test-expr 'date(`%Z bar`)' '"NST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"NST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" NST"'\'''
test-expr 'date(` %Z`)' '" NST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" NST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" NSTbar"'\'''
test-expr 'date(` %Zbar`)' '" NSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" NSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" NST "'\'''
test-expr 'date(` %Z `)' '" NST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" NST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" NST bar"'\'''
test-expr 'date(` %Z bar`)' '" NST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" NST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNST"'\'''
test-expr 'date(`foo%Z`)' '"fooNST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooNST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooNSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNST "'\'''
test-expr 'date(`foo%Z `)' '"fooNST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooNST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooNST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NST"'\'''
test-expr 'date(`foo %Z`)' '"foo NST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo NST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo NSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NST "'\'''
test-expr 'date(`foo %Z `)' '"foo NST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo NST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo NST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"NZDT"'\'''
test-expr 'date(`%Z`)' '"NZDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"NZDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"NZDTbar"'\'''
test-expr 'date(`%Zbar`)' '"NZDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"NZDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"NZDT "'\'''
test-expr 'date(`%Z `)' '"NZDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"NZDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"NZDT bar"'\'''
test-expr 'date(`%Z bar`)' '"NZDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"NZDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" NZDT"'\'''
test-expr 'date(` %Z`)' '" NZDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" NZDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" NZDTbar"'\'''
test-expr 'date(` %Zbar`)' '" NZDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" NZDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" NZDT "'\'''
test-expr 'date(` %Z `)' '" NZDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" NZDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" NZDT bar"'\'''
test-expr 'date(` %Z bar`)' '" NZDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" NZDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNZDT"'\'''
test-expr 'date(`foo%Z`)' '"fooNZDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooNZDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNZDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooNZDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNZDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNZDT "'\'''
test-expr 'date(`foo%Z `)' '"fooNZDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooNZDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNZDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooNZDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNZDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NZDT"'\'''
test-expr 'date(`foo %Z`)' '"foo NZDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo NZDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NZDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo NZDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NZDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NZDT "'\'''
test-expr 'date(`foo %Z `)' '"foo NZDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo NZDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NZDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo NZDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NZDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"NZST"'\'''
test-expr 'date(`%Z`)' '"NZST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"NZST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"NZSTbar"'\'''
test-expr 'date(`%Zbar`)' '"NZSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"NZSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"NZST "'\'''
test-expr 'date(`%Z `)' '"NZST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"NZST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"NZST bar"'\'''
test-expr 'date(`%Z bar`)' '"NZST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"NZST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" NZST"'\'''
test-expr 'date(` %Z`)' '" NZST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" NZST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" NZSTbar"'\'''
test-expr 'date(` %Zbar`)' '" NZSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" NZSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" NZST "'\'''
test-expr 'date(` %Z `)' '" NZST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" NZST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" NZST bar"'\'''
test-expr 'date(` %Z bar`)' '" NZST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" NZST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooNZST"'\'''
test-expr 'date(`foo%Z`)' '"fooNZST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooNZST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNZSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooNZSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooNZSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooNZST "'\'''
test-expr 'date(`foo%Z `)' '"fooNZST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooNZST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNZST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooNZST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooNZST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo NZST"'\'''
test-expr 'date(`foo %Z`)' '"foo NZST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo NZST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NZSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo NZSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo NZSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo NZST "'\'''
test-expr 'date(`foo %Z `)' '"foo NZST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo NZST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NZST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo NZST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo NZST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"PDT"'\'''
test-expr 'date(`%Z`)' '"PDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"PDT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"PDTbar"'\'''
test-expr 'date(`%Zbar`)' '"PDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"PDTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"PDT "'\'''
test-expr 'date(`%Z `)' '"PDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"PDT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"PDT bar"'\'''
test-expr 'date(`%Z bar`)' '"PDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"PDT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" PDT"'\'''
test-expr 'date(` %Z`)' '" PDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" PDT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" PDTbar"'\'''
test-expr 'date(` %Zbar`)' '" PDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" PDTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" PDT "'\'''
test-expr 'date(` %Z `)' '" PDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" PDT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" PDT bar"'\'''
test-expr 'date(` %Z bar`)' '" PDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" PDT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooPDT"'\'''
test-expr 'date(`foo%Z`)' '"fooPDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooPDT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooPDTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooPDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooPDTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooPDT "'\'''
test-expr 'date(`foo%Z `)' '"fooPDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooPDT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooPDT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooPDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooPDT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo PDT"'\'''
test-expr 'date(`foo %Z`)' '"foo PDT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo PDT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo PDTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo PDTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo PDTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo PDT "'\'''
test-expr 'date(`foo %Z `)' '"foo PDT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo PDT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo PDT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo PDT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo PDT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"PST"'\'''
test-expr 'date(`%Z`)' '"PST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"PST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"PSTbar"'\'''
test-expr 'date(`%Zbar`)' '"PSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"PSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"PST "'\'''
test-expr 'date(`%Z `)' '"PST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"PST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"PST bar"'\'''
test-expr 'date(`%Z bar`)' '"PST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"PST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" PST"'\'''
test-expr 'date(` %Z`)' '" PST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" PST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" PSTbar"'\'''
test-expr 'date(` %Zbar`)' '" PSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" PSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" PST "'\'''
test-expr 'date(` %Z `)' '" PST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" PST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" PST bar"'\'''
test-expr 'date(` %Z bar`)' '" PST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" PST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooPST"'\'''
test-expr 'date(`foo%Z`)' '"fooPST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooPST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooPSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooPSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooPSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooPST "'\'''
test-expr 'date(`foo%Z `)' '"fooPST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooPST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooPST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooPST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooPST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo PST"'\'''
test-expr 'date(`foo %Z`)' '"foo PST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo PST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo PSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo PSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo PSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo PST "'\'''
test-expr 'date(`foo %Z `)' '"foo PST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo PST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo PST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo PST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo PST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"SAST"'\'''
test-expr 'date(`%Z`)' '"SAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"SAST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"SASTbar"'\'''
test-expr 'date(`%Zbar`)' '"SASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"SASTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"SAST "'\'''
test-expr 'date(`%Z `)' '"SAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"SAST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"SAST bar"'\'''
test-expr 'date(`%Z bar`)' '"SAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"SAST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" SAST"'\'''
test-expr 'date(` %Z`)' '" SAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" SAST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" SASTbar"'\'''
test-expr 'date(` %Zbar`)' '" SASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" SASTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" SAST "'\'''
test-expr 'date(` %Z `)' '" SAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" SAST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" SAST bar"'\'''
test-expr 'date(` %Z bar`)' '" SAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" SAST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooSAST"'\'''
test-expr 'date(`foo%Z`)' '"fooSAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooSAST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSASTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooSASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSASTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooSAST "'\'''
test-expr 'date(`foo%Z `)' '"fooSAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooSAST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSAST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooSAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSAST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo SAST"'\'''
test-expr 'date(`foo %Z`)' '"foo SAST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo SAST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SASTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo SASTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SASTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo SAST "'\'''
test-expr 'date(`foo %Z `)' '"foo SAST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo SAST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SAST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo SAST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SAST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"SGT"'\'''
test-expr 'date(`%Z`)' '"SGT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"SGT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"SGTbar"'\'''
test-expr 'date(`%Zbar`)' '"SGTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"SGTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"SGT "'\'''
test-expr 'date(`%Z `)' '"SGT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"SGT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"SGT bar"'\'''
test-expr 'date(`%Z bar`)' '"SGT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"SGT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" SGT"'\'''
test-expr 'date(` %Z`)' '" SGT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" SGT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" SGTbar"'\'''
test-expr 'date(` %Zbar`)' '" SGTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" SGTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" SGT "'\'''
test-expr 'date(` %Z `)' '" SGT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" SGT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" SGT bar"'\'''
test-expr 'date(` %Z bar`)' '" SGT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" SGT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooSGT"'\'''
test-expr 'date(`foo%Z`)' '"fooSGT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooSGT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSGTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooSGTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSGTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooSGT "'\'''
test-expr 'date(`foo%Z `)' '"fooSGT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooSGT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSGT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooSGT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSGT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo SGT"'\'''
test-expr 'date(`foo %Z`)' '"foo SGT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo SGT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SGTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo SGTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SGTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo SGT "'\'''
test-expr 'date(`foo %Z `)' '"foo SGT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo SGT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SGT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo SGT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SGT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"SST"'\'''
test-expr 'date(`%Z`)' '"SST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"SST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"SSTbar"'\'''
test-expr 'date(`%Zbar`)' '"SSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"SSTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"SST "'\'''
test-expr 'date(`%Z `)' '"SST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"SST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"SST bar"'\'''
test-expr 'date(`%Z bar`)' '"SST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"SST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" SST"'\'''
test-expr 'date(` %Z`)' '" SST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" SST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" SSTbar"'\'''
test-expr 'date(` %Zbar`)' '" SSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" SSTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" SST "'\'''
test-expr 'date(` %Z `)' '" SST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" SST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" SST bar"'\'''
test-expr 'date(` %Z bar`)' '" SST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" SST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooSST"'\'''
test-expr 'date(`foo%Z`)' '"fooSST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooSST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSSTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooSSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooSSTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooSST "'\'''
test-expr 'date(`foo%Z `)' '"fooSST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooSST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooSST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooSST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo SST"'\'''
test-expr 'date(`foo %Z`)' '"foo SST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo SST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SSTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo SSTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo SSTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo SST "'\'''
test-expr 'date(`foo %Z `)' '"foo SST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo SST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo SST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo SST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"UTC"'\'''
test-expr 'date(`%Z`)' '"UTC"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"UTC"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"UTCbar"'\'''
test-expr 'date(`%Zbar`)' '"UTCbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"UTCbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"UTC "'\'''
test-expr 'date(`%Z `)' '"UTC "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"UTC "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"UTC bar"'\'''
test-expr 'date(`%Z bar`)' '"UTC bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"UTC bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" UTC"'\'''
test-expr 'date(` %Z`)' '" UTC"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" UTC"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" UTCbar"'\'''
test-expr 'date(` %Zbar`)' '" UTCbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" UTCbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" UTC "'\'''
test-expr 'date(` %Z `)' '" UTC "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" UTC "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" UTC bar"'\'''
test-expr 'date(` %Z bar`)' '" UTC bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" UTC bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooUTC"'\'''
test-expr 'date(`foo%Z`)' '"fooUTC"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooUTC"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooUTCbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooUTCbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooUTCbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooUTC "'\'''
test-expr 'date(`foo%Z `)' '"fooUTC "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooUTC "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooUTC bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooUTC bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooUTC bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo UTC"'\'''
test-expr 'date(`foo %Z`)' '"foo UTC"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo UTC"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo UTCbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo UTCbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo UTCbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo UTC "'\'''
test-expr 'date(`foo %Z `)' '"foo UTC "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo UTC "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo UTC bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo UTC bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo UTC bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"WAT"'\'''
test-expr 'date(`%Z`)' '"WAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"WAT"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"WATbar"'\'''
test-expr 'date(`%Zbar`)' '"WATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"WATbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"WAT "'\'''
test-expr 'date(`%Z `)' '"WAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"WAT "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"WAT bar"'\'''
test-expr 'date(`%Z bar`)' '"WAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"WAT bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" WAT"'\'''
test-expr 'date(` %Z`)' '" WAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" WAT"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" WATbar"'\'''
test-expr 'date(` %Zbar`)' '" WATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" WATbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" WAT "'\'''
test-expr 'date(` %Z `)' '" WAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" WAT "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" WAT bar"'\'''
test-expr 'date(` %Z bar`)' '" WAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" WAT bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooWAT"'\'''
test-expr 'date(`foo%Z`)' '"fooWAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooWAT"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWATbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooWATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWATbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooWAT "'\'''
test-expr 'date(`foo%Z `)' '"fooWAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooWAT "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWAT bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooWAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWAT bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo WAT"'\'''
test-expr 'date(`foo %Z`)' '"foo WAT"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo WAT"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WATbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo WATbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WATbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo WAT "'\'''
test-expr 'date(`foo %Z `)' '"foo WAT "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo WAT "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WAT bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo WAT bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WAT bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"WEST"'\'''
test-expr 'date(`%Z`)' '"WEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"WEST"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"WESTbar"'\'''
test-expr 'date(`%Zbar`)' '"WESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"WESTbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"WEST "'\'''
test-expr 'date(`%Z `)' '"WEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"WEST "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"WEST bar"'\'''
test-expr 'date(`%Z bar`)' '"WEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"WEST bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" WEST"'\'''
test-expr 'date(` %Z`)' '" WEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" WEST"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" WESTbar"'\'''
test-expr 'date(` %Zbar`)' '" WESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" WESTbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" WEST "'\'''
test-expr 'date(` %Z `)' '" WEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" WEST "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" WEST bar"'\'''
test-expr 'date(` %Z bar`)' '" WEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" WEST bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooWEST"'\'''
test-expr 'date(`foo%Z`)' '"fooWEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooWEST"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWESTbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooWESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWESTbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooWEST "'\'''
test-expr 'date(`foo%Z `)' '"fooWEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooWEST "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWEST bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooWEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWEST bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo WEST"'\'''
test-expr 'date(`foo %Z`)' '"foo WEST"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo WEST"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WESTbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo WESTbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WESTbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo WEST "'\'''
test-expr 'date(`foo %Z `)' '"foo WEST "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo WEST "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WEST bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo WEST bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WEST bar"'\'''

echo '$ test-expr '\''date(`%Z`)'\'' '\''"WET"'\'''
test-expr 'date(`%Z`)' '"WET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z`)'\'' '\''"WET"'\'''

echo '$ test-expr '\''date(`%Zbar`)'\'' '\''"WETbar"'\'''
test-expr 'date(`%Zbar`)' '"WETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Zbar`)'\'' '\''"WETbar"'\'''

echo '$ test-expr '\''date(`%Z `)'\'' '\''"WET "'\'''
test-expr 'date(`%Z `)' '"WET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z `)'\'' '\''"WET "'\'''

echo '$ test-expr '\''date(`%Z bar`)'\'' '\''"WET bar"'\'''
test-expr 'date(`%Z bar`)' '"WET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Z bar`)'\'' '\''"WET bar"'\'''

echo '$ test-expr '\''date(` %Z`)'\'' '\''" WET"'\'''
test-expr 'date(` %Z`)' '" WET"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z`)'\'' '\''" WET"'\'''

echo '$ test-expr '\''date(` %Zbar`)'\'' '\''" WETbar"'\'''
test-expr 'date(` %Zbar`)' '" WETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Zbar`)'\'' '\''" WETbar"'\'''

echo '$ test-expr '\''date(` %Z `)'\'' '\''" WET "'\'''
test-expr 'date(` %Z `)' '" WET "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z `)'\'' '\''" WET "'\'''

echo '$ test-expr '\''date(` %Z bar`)'\'' '\''" WET bar"'\'''
test-expr 'date(` %Z bar`)' '" WET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Z bar`)'\'' '\''" WET bar"'\'''

echo '$ test-expr '\''date(`foo%Z`)'\'' '\''"fooWET"'\'''
test-expr 'date(`foo%Z`)' '"fooWET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z`)'\'' '\''"fooWET"'\'''

echo '$ test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWETbar"'\'''
test-expr 'date(`foo%Zbar`)' '"fooWETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Zbar`)'\'' '\''"fooWETbar"'\'''

echo '$ test-expr '\''date(`foo%Z `)'\'' '\''"fooWET "'\'''
test-expr 'date(`foo%Z `)' '"fooWET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z `)'\'' '\''"fooWET "'\'''

echo '$ test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWET bar"'\'''
test-expr 'date(`foo%Z bar`)' '"fooWET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Z bar`)'\'' '\''"fooWET bar"'\'''

echo '$ test-expr '\''date(`foo %Z`)'\'' '\''"foo WET"'\'''
test-expr 'date(`foo %Z`)' '"foo WET"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z`)'\'' '\''"foo WET"'\'''

echo '$ test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WETbar"'\'''
test-expr 'date(`foo %Zbar`)' '"foo WETbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Zbar`)'\'' '\''"foo WETbar"'\'''

echo '$ test-expr '\''date(`foo %Z `)'\'' '\''"foo WET "'\'''
test-expr 'date(`foo %Z `)' '"foo WET "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z `)'\'' '\''"foo WET "'\'''

echo '$ test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WET bar"'\'''
test-expr 'date(`foo %Z bar`)' '"foo WET bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Z bar`)'\'' '\''"foo WET bar"'\'''
)

