#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:multi-groups
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L multi-groups.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ json() { set -o pipefail && json0 --dump-opt "$@"|sed -nr '\''/^filter-libs/p'\''; }
$ json -F
filter-libs:                   -
$ json -F -- a
filter-libs[0][0]:             a
$ json -F -- a b c
filter-libs[0][0]:             a
filter-libs[0][1]:             b
filter-libs[0][2]:             c
$ json -F -- a b c -- d e
filter-libs[0][0]:             a
filter-libs[0][1]:             b
filter-libs[0][2]:             c
filter-libs[1][0]:             d
filter-libs[1][1]:             e
$ json -F -- a b c -- d e -- f
filter-libs[0][0]:             a
filter-libs[0][1]:             b
filter-libs[0][2]:             c
filter-libs[1][0]:             d
filter-libs[1][1]:             e
filter-libs[2][0]:             f
$ json -f
filter-libs:                   -
$ json -f -- a
filter-libs[0][0]:             a
$ json -f -- a b c
filter-libs[0][0]:             a
filter-libs[0][1]:             b
filter-libs[0][2]:             c
$ json -f -- a b c -- d e
filter-libs[0][0]:             a
filter-libs[0][1]:             b
filter-libs[0][2]:             c
filter-libs[1][0]:             d
filter-libs[1][1]:             e
$ json -f -- a b c -- d e -- f
filter-libs[0][0]:             a
filter-libs[0][1]:             b
filter-libs[0][2]:             c
filter-libs[1][0]:             d
filter-libs[1][1]:             e
filter-libs[2][0]:             f
$ json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16
filter-libs[0][0]:             1
filter-libs[1][0]:             2
filter-libs[2][0]:             3
filter-libs[3][0]:             4
filter-libs[4][0]:             5
filter-libs[5][0]:             6
filter-libs[6][0]:             7
filter-libs[7][0]:             8
filter-libs[8][0]:             9
filter-libs[9][0]:             10
filter-libs[10][0]:            11
filter-libs[11][0]:            12
filter-libs[12][0]:            13
filter-libs[13][0]:            14
filter-libs[14][0]:            15
filter-libs[15][0]:            16
$ json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16
filter-libs[0][0]:             1
filter-libs[1][0]:             2
filter-libs[2][0]:             3
filter-libs[3][0]:             4
filter-libs[4][0]:             5
filter-libs[5][0]:             6
filter-libs[6][0]:             7
filter-libs[7][0]:             8
filter-libs[8][0]:             9
filter-libs[9][0]:             10
filter-libs[10][0]:            11
filter-libs[11][0]:            12
filter-libs[12][0]:            13
filter-libs[13][0]:            14
filter-libs[14][0]:            15
filter-libs[15][0]:            16
$ shopt -s expand_aliases
$ unset -f json && alias json='\''json0 --dump-opt'\''
$ json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17
json: error: too many filter arguments groups (max is 16)
command failed: json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17
$ json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17
json: error: too many filter arguments groups (max is 16)
command failed: json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17'
) -L multi-groups.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ json() { set -o pipefail && json0 --dump-opt "$@"|sed -nr '\''/^filter-libs/p'\''; }'
json() { set -o pipefail && json0 --dump-opt "$@"|sed -nr '/^filter-libs/p'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && json0 --dump-opt "$@"|sed -nr '\''/^filter-libs/p'\''; }'

echo '$ json -F'
json -F 2>&1 ||
echo 'command failed: json -F'

echo '$ json -F -- a'
json -F -- a 2>&1 ||
echo 'command failed: json -F -- a'

echo '$ json -F -- a b c'
json -F -- a b c 2>&1 ||
echo 'command failed: json -F -- a b c'

echo '$ json -F -- a b c -- d e'
json -F -- a b c -- d e 2>&1 ||
echo 'command failed: json -F -- a b c -- d e'

echo '$ json -F -- a b c -- d e -- f'
json -F -- a b c -- d e -- f 2>&1 ||
echo 'command failed: json -F -- a b c -- d e -- f'

echo '$ json -f'
json -f 2>&1 ||
echo 'command failed: json -f'

echo '$ json -f -- a'
json -f -- a 2>&1 ||
echo 'command failed: json -f -- a'

echo '$ json -f -- a b c'
json -f -- a b c 2>&1 ||
echo 'command failed: json -f -- a b c'

echo '$ json -f -- a b c -- d e'
json -f -- a b c -- d e 2>&1 ||
echo 'command failed: json -f -- a b c -- d e'

echo '$ json -f -- a b c -- d e -- f'
json -f -- a b c -- d e -- f 2>&1 ||
echo 'command failed: json -f -- a b c -- d e -- f'

echo '$ json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16'
json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 2>&1 ||
echo 'command failed: json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16'

echo '$ json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16'
json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 2>&1 ||
echo 'command failed: json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ unset -f json && alias json='\''json0 --dump-opt'\'''
unset -f json && alias json='json0 --dump-opt' 2>&1 ||
echo 'command failed: unset -f json && alias json='\''json0 --dump-opt'\'''

echo '$ json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17'
json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17 2>&1 ||
echo 'command failed: json -F -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17'

echo '$ json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17'
json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17 2>&1 ||
echo 'command failed: json -f -- 1 -- 2 -- 3 -- 4 -- 5 -- 6 -- 7 -- 8 -- 9 -- 10 -- 11 -- 12 -- 13 -- 14 -- 15 -- 16 -- 17'
)

