#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict2.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"dict","args":[],"foo":null,"bar":false}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: arguments not of size two or three
json: error: <stdin>:1:1: {"type":"dict","args":[],"foo":nu
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","args":[],"foo":null,"bar":false}'\''
$ json <<< '\''{"type":"dict","args":[],"foo":null}'\''
json: error: <stdin>:1:1: meta error: invalid "type" object: key of third argument is not "expr"
json: error: <stdin>:1:1: {"type":"dict","args":[],"foo":nu
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"type":"dict","args":[],"foo":null}'\''
$ json <<< '\''{"type":"dict","args":[],"expr":null}'\''
json: error: <stdin>:1:33: meta error: invalid "dict" object: value of "expr" must be a string
json: error: <stdin>:1:33: {"type":"dict","args":[],"expr":null}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"dict","args":[],"expr":null}'\''
$ json <<< '\''{"type":"dict","args":[],"expr":""}'\''
json: error: <stdin>:1:34: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:1:34: "type":"dict","args":[],"expr":""}
json: error: <stdin>:1:34:                                 ^
command failed: json <<< '\''{"type":"dict","args":[],"expr":""}'\'''
) -L dict2.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"dict","args":[],"foo":null,"bar":false}'\'''
json <<< '{"type":"dict","args":[],"foo":null,"bar":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[],"foo":null,"bar":false}'\'''

echo '$ json <<< '\''{"type":"dict","args":[],"foo":null}'\'''
json <<< '{"type":"dict","args":[],"foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[],"foo":null}'\'''

echo '$ json <<< '\''{"type":"dict","args":[],"expr":null}'\'''
json <<< '{"type":"dict","args":[],"expr":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[],"expr":null}'\'''

echo '$ json <<< '\''{"type":"dict","args":[],"expr":""}'\'''
json <<< '{"type":"dict","args":[],"expr":""}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[],"expr":""}'\'''
)

