#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:closed-array-list2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L closed-array-list2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[[]]'\''
[[]]'
) -L closed-array-list2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["null"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["null"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["boolean"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["boolean"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["number"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["number"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["string"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["string"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["object"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["object"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":["array"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":["array"]}]}'\'' <<< '\''[[]]'\'''
)

