#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:raw-string
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L raw-string.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --raw-strings "$@"; }
$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\0bar()foo\0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b1
$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\0bar()foo\0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b2
$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\0bar()foo\0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b4
$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\0bar()foo\0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b8
$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\0bar()foo\0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b16
$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\0bar()foo\0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b32
$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x01bar()foo\x01bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b1
$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x01bar()foo\x01bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b2
$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x01bar()foo\x01bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b4
$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x01bar()foo\x01bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b8
$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x01bar()foo\x01bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b16
$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x01bar()foo\x01bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b32
$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x02bar()foo\x02bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b1
$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x02bar()foo\x02bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b2
$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x02bar()foo\x02bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b4
$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x02bar()foo\x02bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b8
$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x02bar()foo\x02bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b16
$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x02bar()foo\x02bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b32
$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x03bar()foo\x03bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b1
$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x03bar()foo\x03bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b2
$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x03bar()foo\x03bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b4
$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x03bar()foo\x03bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b8
$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x03bar()foo\x03bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b16
$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x03bar()foo\x03bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b32
$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x04bar()foo\x04bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b1
$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x04bar()foo\x04bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b2
$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x04bar()foo\x04bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b4
$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x04bar()foo\x04bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b8
$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x04bar()foo\x04bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b16
$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x04bar()foo\x04bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b32
$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x05bar()foo\x05bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b1
$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x05bar()foo\x05bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b2
$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x05bar()foo\x05bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b4
$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x05bar()foo\x05bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b8
$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x05bar()foo\x05bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b16
$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x05bar()foo\x05bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b32
$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x06bar()foo\x06bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b1
$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x06bar()foo\x06bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b2
$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x06bar()foo\x06bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b4
$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x06bar()foo\x06bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b8
$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x06bar()foo\x06bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b16
$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x06bar()foo\x06bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b32
$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\abar()foo\abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b1
$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\abar()foo\abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b2
$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\abar()foo\abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b4
$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\abar()foo\abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b8
$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\abar()foo\abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b16
$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\abar()foo\abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b32
$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\bbar()foo\bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b1
$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\bbar()foo\bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b2
$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\bbar()foo\bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b4
$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\bbar()foo\bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b8
$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\bbar()foo\bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b16
$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\bbar()foo\bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b32
$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\tbar()foo\tbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b1
$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\tbar()foo\tbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b2
$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\tbar()foo\tbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b4
$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\tbar()foo\tbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b8
$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\tbar()foo\tbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b16
$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\tbar()foo\tbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b32
$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\nbar()foo\nbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b1
$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\nbar()foo\nbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b2
$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\nbar()foo\nbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b4
$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\nbar()foo\nbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b8
$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\nbar()foo\nbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b16
$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\nbar()foo\nbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b32
$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\vbar()foo\vbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b1
$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\vbar()foo\vbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b2
$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\vbar()foo\vbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b4
$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\vbar()foo\vbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b8
$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\vbar()foo\vbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b16
$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\vbar()foo\vbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b32
$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\fbar()foo\fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b1
$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\fbar()foo\fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b2
$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\fbar()foo\fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b4
$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\fbar()foo\fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b8
$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\fbar()foo\fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b16
$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\fbar()foo\fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b32
$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\rbar()foo\rbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b1
$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\rbar()foo\rbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b2
$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\rbar()foo\rbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b4
$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\rbar()foo\rbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b8
$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\rbar()foo\rbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b16
$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\rbar()foo\rbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b32
$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0ebar()foo\x0ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b1
$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0ebar()foo\x0ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b2
$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0ebar()foo\x0ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b4
$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0ebar()foo\x0ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b8
$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0ebar()foo\x0ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b16
$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0ebar()foo\x0ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b32
$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0fbar()foo\x0fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b1
$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0fbar()foo\x0fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b2
$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0fbar()foo\x0fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b4
$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0fbar()foo\x0fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b8
$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0fbar()foo\x0fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b16
$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x0fbar()foo\x0fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b32
$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x10bar()foo\x10bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b1
$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x10bar()foo\x10bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b2
$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x10bar()foo\x10bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b4
$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x10bar()foo\x10bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b8
$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x10bar()foo\x10bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b16
$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x10bar()foo\x10bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b32
$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x11bar()foo\x11bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b1
$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x11bar()foo\x11bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b2
$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x11bar()foo\x11bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b4
$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x11bar()foo\x11bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b8
$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x11bar()foo\x11bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b16
$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x11bar()foo\x11bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b32
$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x12bar()foo\x12bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b1
$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x12bar()foo\x12bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b2
$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x12bar()foo\x12bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b4
$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x12bar()foo\x12bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b8
$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x12bar()foo\x12bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b16
$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x12bar()foo\x12bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b32
$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x13bar()foo\x13bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b1
$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x13bar()foo\x13bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b2
$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x13bar()foo\x13bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b4
$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x13bar()foo\x13bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b8
$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x13bar()foo\x13bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b16
$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x13bar()foo\x13bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b32
$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x14bar()foo\x14bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b1
$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x14bar()foo\x14bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b2
$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x14bar()foo\x14bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b4
$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x14bar()foo\x14bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b8
$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x14bar()foo\x14bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b16
$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x14bar()foo\x14bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b32
$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x15bar()foo\x15bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b1
$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x15bar()foo\x15bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b2
$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x15bar()foo\x15bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b4
$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x15bar()foo\x15bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b8
$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x15bar()foo\x15bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b16
$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x15bar()foo\x15bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b32
$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x16bar()foo\x16bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b1
$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x16bar()foo\x16bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b2
$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x16bar()foo\x16bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b4
$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x16bar()foo\x16bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b8
$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x16bar()foo\x16bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b16
$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x16bar()foo\x16bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b32
$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x17bar()foo\x17bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b1
$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x17bar()foo\x17bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b2
$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x17bar()foo\x17bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b4
$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x17bar()foo\x17bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b8
$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x17bar()foo\x17bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b16
$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x17bar()foo\x17bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b32
$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x18bar()foo\x18bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b1
$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x18bar()foo\x18bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b2
$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x18bar()foo\x18bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b4
$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x18bar()foo\x18bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b8
$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x18bar()foo\x18bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b16
$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x18bar()foo\x18bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b32
$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x19bar()foo\x19bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b1
$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x19bar()foo\x19bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b2
$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x19bar()foo\x19bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b4
$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x19bar()foo\x19bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b8
$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x19bar()foo\x19bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b16
$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x19bar()foo\x19bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b32
$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1abar()foo\x1abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b1
$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1abar()foo\x1abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b2
$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1abar()foo\x1abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b4
$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1abar()foo\x1abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b8
$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1abar()foo\x1abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b16
$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1abar()foo\x1abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b32
$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1bbar()foo\x1bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b1
$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1bbar()foo\x1bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b2
$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1bbar()foo\x1bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b4
$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1bbar()foo\x1bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b8
$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1bbar()foo\x1bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b16
$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1bbar()foo\x1bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b32
$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1cbar()foo\x1cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b1
$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1cbar()foo\x1cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b2
$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1cbar()foo\x1cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b4
$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1cbar()foo\x1cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b8
$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1cbar()foo\x1cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b16
$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1cbar()foo\x1cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b32
$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1dbar()foo\x1dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b1
$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1dbar()foo\x1dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b2
$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1dbar()foo\x1dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b4
$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1dbar()foo\x1dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b8
$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1dbar()foo\x1dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b16
$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1dbar()foo\x1dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b32
$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1ebar()foo\x1ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b1
$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1ebar()foo\x1ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b2
$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1ebar()foo\x1ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b4
$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1ebar()foo\x1ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b8
$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1ebar()foo\x1ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b16
$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1ebar()foo\x1ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b32
$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1fbar()foo\x1fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b1
$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1fbar()foo\x1fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b2
$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1fbar()foo\x1fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b4
$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1fbar()foo\x1fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b8
$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1fbar()foo\x1fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b16
$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x1fbar()foo\x1fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b32
$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo bar()foo bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b1
$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo bar()foo bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b2
$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo bar()foo bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b4
$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo bar()foo bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b8
$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo bar()foo bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b16
$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo bar()foo bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b32
$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b1
r"foo!bar()foo!bar"
$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b2
r"foo!bar()foo!bar"
$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b4
r"foo!bar()foo!bar"
$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b8
r"foo!bar()foo!bar"
$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b16
r"foo!bar()foo!bar"
$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b32
r"foo!bar()foo!bar"
$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b1
r"foo"bar()foo"bar"
$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b2
r"foo"bar()foo"bar"
$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b4
r"foo"bar()foo"bar"
$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b8
r"foo"bar()foo"bar"
$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b16
r"foo"bar()foo"bar"
$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b32
r"foo"bar()foo"bar"
$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b1
r"foo#bar()foo#bar"
$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b2
r"foo#bar()foo#bar"
$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b4
r"foo#bar()foo#bar"
$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b8
r"foo#bar()foo#bar"
$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b16
r"foo#bar()foo#bar"
$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b32
r"foo#bar()foo#bar"
$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo$bar()foo$bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b1
$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo$bar()foo$bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b2
$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo$bar()foo$bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b4
$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo$bar()foo$bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b8
$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo$bar()foo$bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b16
$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo$bar()foo$bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b32
$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b1
r"foo%bar()foo%bar"
$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b2
r"foo%bar()foo%bar"
$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b4
r"foo%bar()foo%bar"
$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b8
r"foo%bar()foo%bar"
$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b16
r"foo%bar()foo%bar"
$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b32
r"foo%bar()foo%bar"
$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b1
r"foo&bar()foo&bar"
$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b2
r"foo&bar()foo&bar"
$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b4
r"foo&bar()foo&bar"
$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b8
r"foo&bar()foo&bar"
$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b16
r"foo&bar()foo&bar"
$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b32
r"foo&bar()foo&bar"
$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b1
r"foo'\''bar()foo'\''bar"
$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b2
r"foo'\''bar()foo'\''bar"
$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b4
r"foo'\''bar()foo'\''bar"
$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b8
r"foo'\''bar()foo'\''bar"
$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b16
r"foo'\''bar()foo'\''bar"
$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b32
r"foo'\''bar()foo'\''bar"
$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b1
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"foo(bar()foo(bar"
json: error: <stdin>:1:20:                    ^
command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b1
$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b2
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"foo(bar()foo(bar"
json: error: <stdin>:1:20:                    ^
command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b2
$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b4
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"foo(bar()foo(bar"
json: error: <stdin>:1:20:                    ^
command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b4
$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b8
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"foo(bar()foo(bar"
json: error: <stdin>:1:20:                    ^
command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b8
$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b16
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"foo(bar()foo(bar"
json: error: <stdin>:1:20:                    ^
command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b16
$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b32
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"foo(bar()foo(bar"
json: error: <stdin>:1:20:                    ^
command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b32
$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo)bar()foo)bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b1
$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo)bar()foo)bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b2
$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo)bar()foo)bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b4
$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo)bar()foo)bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b8
$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo)bar()foo)bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b16
$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo)bar()foo)bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b32
$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b1
r"foo*bar()foo*bar"
$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b2
r"foo*bar()foo*bar"
$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b4
r"foo*bar()foo*bar"
$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b8
r"foo*bar()foo*bar"
$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b16
r"foo*bar()foo*bar"
$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b32
r"foo*bar()foo*bar"
$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b1
r"foo+bar()foo+bar"
$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b2
r"foo+bar()foo+bar"
$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b4
r"foo+bar()foo+bar"
$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b8
r"foo+bar()foo+bar"
$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b16
r"foo+bar()foo+bar"
$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b32
r"foo+bar()foo+bar"
$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b1
r"foo,bar()foo,bar"
$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b2
r"foo,bar()foo,bar"
$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b4
r"foo,bar()foo,bar"
$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b8
r"foo,bar()foo,bar"
$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b16
r"foo,bar()foo,bar"
$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b32
r"foo,bar()foo,bar"
$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b1
r"foo-bar()foo-bar"
$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b2
r"foo-bar()foo-bar"
$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b4
r"foo-bar()foo-bar"
$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b8
r"foo-bar()foo-bar"
$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b16
r"foo-bar()foo-bar"
$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b32
r"foo-bar()foo-bar"
$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b1
r"foo.bar()foo.bar"
$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b2
r"foo.bar()foo.bar"
$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b4
r"foo.bar()foo.bar"
$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b8
r"foo.bar()foo.bar"
$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b16
r"foo.bar()foo.bar"
$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b32
r"foo.bar()foo.bar"
$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b1
r"foo/bar()foo/bar"
$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b2
r"foo/bar()foo/bar"
$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b4
r"foo/bar()foo/bar"
$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b8
r"foo/bar()foo/bar"
$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b16
r"foo/bar()foo/bar"
$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b32
r"foo/bar()foo/bar"
$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b1
r"foo0bar()foo0bar"
$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b2
r"foo0bar()foo0bar"
$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b4
r"foo0bar()foo0bar"
$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b8
r"foo0bar()foo0bar"
$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b16
r"foo0bar()foo0bar"
$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b32
r"foo0bar()foo0bar"
$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b1
r"foo1bar()foo1bar"
$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b2
r"foo1bar()foo1bar"
$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b4
r"foo1bar()foo1bar"
$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b8
r"foo1bar()foo1bar"
$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b16
r"foo1bar()foo1bar"
$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b32
r"foo1bar()foo1bar"
$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b1
r"foo2bar()foo2bar"
$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b2
r"foo2bar()foo2bar"
$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b4
r"foo2bar()foo2bar"
$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b8
r"foo2bar()foo2bar"
$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b16
r"foo2bar()foo2bar"
$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b32
r"foo2bar()foo2bar"
$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b1
r"foo3bar()foo3bar"
$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b2
r"foo3bar()foo3bar"
$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b4
r"foo3bar()foo3bar"
$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b8
r"foo3bar()foo3bar"
$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b16
r"foo3bar()foo3bar"
$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b32
r"foo3bar()foo3bar"
$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b1
r"foo4bar()foo4bar"
$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b2
r"foo4bar()foo4bar"
$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b4
r"foo4bar()foo4bar"
$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b8
r"foo4bar()foo4bar"
$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b16
r"foo4bar()foo4bar"
$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b32
r"foo4bar()foo4bar"
$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b1
r"foo5bar()foo5bar"
$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b2
r"foo5bar()foo5bar"
$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b4
r"foo5bar()foo5bar"
$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b8
r"foo5bar()foo5bar"
$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b16
r"foo5bar()foo5bar"
$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b32
r"foo5bar()foo5bar"
$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b1
r"foo6bar()foo6bar"
$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b2
r"foo6bar()foo6bar"
$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b4
r"foo6bar()foo6bar"
$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b8
r"foo6bar()foo6bar"
$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b16
r"foo6bar()foo6bar"
$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b32
r"foo6bar()foo6bar"
$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b1
r"foo7bar()foo7bar"
$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b2
r"foo7bar()foo7bar"
$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b4
r"foo7bar()foo7bar"
$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b8
r"foo7bar()foo7bar"
$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b16
r"foo7bar()foo7bar"
$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b32
r"foo7bar()foo7bar"
$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b1
r"foo8bar()foo8bar"
$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b2
r"foo8bar()foo8bar"
$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b4
r"foo8bar()foo8bar"
$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b8
r"foo8bar()foo8bar"
$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b16
r"foo8bar()foo8bar"
$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b32
r"foo8bar()foo8bar"
$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b1
r"foo9bar()foo9bar"
$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b2
r"foo9bar()foo9bar"
$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b4
r"foo9bar()foo9bar"
$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b8
r"foo9bar()foo9bar"
$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b16
r"foo9bar()foo9bar"
$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b32
r"foo9bar()foo9bar"
$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b1
r"foo:bar()foo:bar"
$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b2
r"foo:bar()foo:bar"
$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b4
r"foo:bar()foo:bar"
$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b8
r"foo:bar()foo:bar"
$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b16
r"foo:bar()foo:bar"
$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b32
r"foo:bar()foo:bar"
$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b1
r"foo;bar()foo;bar"
$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b2
r"foo;bar()foo;bar"
$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b4
r"foo;bar()foo;bar"
$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b8
r"foo;bar()foo;bar"
$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b16
r"foo;bar()foo;bar"
$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b32
r"foo;bar()foo;bar"
$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b1
r"foo<bar()foo<bar"
$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b2
r"foo<bar()foo<bar"
$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b4
r"foo<bar()foo<bar"
$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b8
r"foo<bar()foo<bar"
$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b16
r"foo<bar()foo<bar"
$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b32
r"foo<bar()foo<bar"
$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b1
r"foo=bar()foo=bar"
$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b2
r"foo=bar()foo=bar"
$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b4
r"foo=bar()foo=bar"
$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b8
r"foo=bar()foo=bar"
$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b16
r"foo=bar()foo=bar"
$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b32
r"foo=bar()foo=bar"
$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b1
r"foo>bar()foo>bar"
$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b2
r"foo>bar()foo>bar"
$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b4
r"foo>bar()foo>bar"
$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b8
r"foo>bar()foo>bar"
$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b16
r"foo>bar()foo>bar"
$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b32
r"foo>bar()foo>bar"
$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b1
r"foo?bar()foo?bar"
$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b2
r"foo?bar()foo?bar"
$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b4
r"foo?bar()foo?bar"
$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b8
r"foo?bar()foo?bar"
$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b16
r"foo?bar()foo?bar"
$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b32
r"foo?bar()foo?bar"
$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo@bar()foo@bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b1
$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo@bar()foo@bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b2
$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo@bar()foo@bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b4
$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo@bar()foo@bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b8
$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo@bar()foo@bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b16
$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo@bar()foo@bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b32
$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b1
r"fooAbar()fooAbar"
$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b2
r"fooAbar()fooAbar"
$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b4
r"fooAbar()fooAbar"
$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b8
r"fooAbar()fooAbar"
$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b16
r"fooAbar()fooAbar"
$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b32
r"fooAbar()fooAbar"
$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b1
r"fooBbar()fooBbar"
$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b2
r"fooBbar()fooBbar"
$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b4
r"fooBbar()fooBbar"
$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b8
r"fooBbar()fooBbar"
$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b16
r"fooBbar()fooBbar"
$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b32
r"fooBbar()fooBbar"
$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b1
r"fooCbar()fooCbar"
$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b2
r"fooCbar()fooCbar"
$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b4
r"fooCbar()fooCbar"
$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b8
r"fooCbar()fooCbar"
$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b16
r"fooCbar()fooCbar"
$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b32
r"fooCbar()fooCbar"
$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b1
r"fooDbar()fooDbar"
$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b2
r"fooDbar()fooDbar"
$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b4
r"fooDbar()fooDbar"
$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b8
r"fooDbar()fooDbar"
$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b16
r"fooDbar()fooDbar"
$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b32
r"fooDbar()fooDbar"
$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b1
r"fooEbar()fooEbar"
$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b2
r"fooEbar()fooEbar"
$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b4
r"fooEbar()fooEbar"
$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b8
r"fooEbar()fooEbar"
$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b16
r"fooEbar()fooEbar"
$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b32
r"fooEbar()fooEbar"
$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b1
r"fooFbar()fooFbar"
$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b2
r"fooFbar()fooFbar"
$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b4
r"fooFbar()fooFbar"
$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b8
r"fooFbar()fooFbar"
$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b16
r"fooFbar()fooFbar"
$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b32
r"fooFbar()fooFbar"
$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b1
r"fooGbar()fooGbar"
$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b2
r"fooGbar()fooGbar"
$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b4
r"fooGbar()fooGbar"
$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b8
r"fooGbar()fooGbar"
$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b16
r"fooGbar()fooGbar"
$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b32
r"fooGbar()fooGbar"
$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b1
r"fooHbar()fooHbar"
$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b2
r"fooHbar()fooHbar"
$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b4
r"fooHbar()fooHbar"
$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b8
r"fooHbar()fooHbar"
$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b16
r"fooHbar()fooHbar"
$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b32
r"fooHbar()fooHbar"
$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b1
r"fooIbar()fooIbar"
$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b2
r"fooIbar()fooIbar"
$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b4
r"fooIbar()fooIbar"
$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b8
r"fooIbar()fooIbar"
$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b16
r"fooIbar()fooIbar"
$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b32
r"fooIbar()fooIbar"
$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b1
r"fooJbar()fooJbar"
$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b2
r"fooJbar()fooJbar"
$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b4
r"fooJbar()fooJbar"
$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b8
r"fooJbar()fooJbar"
$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b16
r"fooJbar()fooJbar"
$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b32
r"fooJbar()fooJbar"
$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b1
r"fooKbar()fooKbar"
$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b2
r"fooKbar()fooKbar"
$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b4
r"fooKbar()fooKbar"
$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b8
r"fooKbar()fooKbar"
$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b16
r"fooKbar()fooKbar"
$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b32
r"fooKbar()fooKbar"
$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b1
r"fooLbar()fooLbar"
$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b2
r"fooLbar()fooLbar"
$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b4
r"fooLbar()fooLbar"
$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b8
r"fooLbar()fooLbar"
$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b16
r"fooLbar()fooLbar"
$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b32
r"fooLbar()fooLbar"
$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b1
r"fooMbar()fooMbar"
$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b2
r"fooMbar()fooMbar"
$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b4
r"fooMbar()fooMbar"
$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b8
r"fooMbar()fooMbar"
$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b16
r"fooMbar()fooMbar"
$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b32
r"fooMbar()fooMbar"
$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b1
r"fooNbar()fooNbar"
$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b2
r"fooNbar()fooNbar"
$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b4
r"fooNbar()fooNbar"
$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b8
r"fooNbar()fooNbar"
$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b16
r"fooNbar()fooNbar"
$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b32
r"fooNbar()fooNbar"
$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b1
r"fooObar()fooObar"
$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b2
r"fooObar()fooObar"
$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b4
r"fooObar()fooObar"
$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b8
r"fooObar()fooObar"
$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b16
r"fooObar()fooObar"
$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b32
r"fooObar()fooObar"
$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b1
r"fooPbar()fooPbar"
$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b2
r"fooPbar()fooPbar"
$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b4
r"fooPbar()fooPbar"
$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b8
r"fooPbar()fooPbar"
$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b16
r"fooPbar()fooPbar"
$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b32
r"fooPbar()fooPbar"
$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b1
r"fooQbar()fooQbar"
$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b2
r"fooQbar()fooQbar"
$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b4
r"fooQbar()fooQbar"
$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b8
r"fooQbar()fooQbar"
$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b16
r"fooQbar()fooQbar"
$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b32
r"fooQbar()fooQbar"
$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b1
r"fooRbar()fooRbar"
$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b2
r"fooRbar()fooRbar"
$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b4
r"fooRbar()fooRbar"
$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b8
r"fooRbar()fooRbar"
$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b16
r"fooRbar()fooRbar"
$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b32
r"fooRbar()fooRbar"
$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b1
r"fooSbar()fooSbar"
$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b2
r"fooSbar()fooSbar"
$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b4
r"fooSbar()fooSbar"
$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b8
r"fooSbar()fooSbar"
$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b16
r"fooSbar()fooSbar"
$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b32
r"fooSbar()fooSbar"
$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b1
r"fooTbar()fooTbar"
$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b2
r"fooTbar()fooTbar"
$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b4
r"fooTbar()fooTbar"
$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b8
r"fooTbar()fooTbar"
$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b16
r"fooTbar()fooTbar"
$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b32
r"fooTbar()fooTbar"
$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b1
r"fooUbar()fooUbar"
$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b2
r"fooUbar()fooUbar"
$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b4
r"fooUbar()fooUbar"
$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b8
r"fooUbar()fooUbar"
$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b16
r"fooUbar()fooUbar"
$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b32
r"fooUbar()fooUbar"
$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b1
r"fooVbar()fooVbar"
$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b2
r"fooVbar()fooVbar"
$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b4
r"fooVbar()fooVbar"
$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b8
r"fooVbar()fooVbar"
$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b16
r"fooVbar()fooVbar"
$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b32
r"fooVbar()fooVbar"
$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b1
r"fooWbar()fooWbar"
$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b2
r"fooWbar()fooWbar"
$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b4
r"fooWbar()fooWbar"
$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b8
r"fooWbar()fooWbar"
$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b16
r"fooWbar()fooWbar"
$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b32
r"fooWbar()fooWbar"
$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b1
r"fooXbar()fooXbar"
$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b2
r"fooXbar()fooXbar"
$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b4
r"fooXbar()fooXbar"
$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b8
r"fooXbar()fooXbar"
$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b16
r"fooXbar()fooXbar"
$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b32
r"fooXbar()fooXbar"
$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b1
r"fooYbar()fooYbar"
$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b2
r"fooYbar()fooYbar"
$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b4
r"fooYbar()fooYbar"
$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b8
r"fooYbar()fooYbar"
$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b16
r"fooYbar()fooYbar"
$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b32
r"fooYbar()fooYbar"
$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b1
r"fooZbar()fooZbar"
$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b2
r"fooZbar()fooZbar"
$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b4
r"fooZbar()fooZbar"
$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b8
r"fooZbar()fooZbar"
$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b16
r"fooZbar()fooZbar"
$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b32
r"fooZbar()fooZbar"
$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b1
r"foo[bar()foo[bar"
$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b2
r"foo[bar()foo[bar"
$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b4
r"foo[bar()foo[bar"
$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b8
r"foo[bar()foo[bar"
$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b16
r"foo[bar()foo[bar"
$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b32
r"foo[bar()foo[bar"
$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\\bar()foo\\bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b1
$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\\bar()foo\\bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b2
$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\\bar()foo\\bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b4
$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\\bar()foo\\bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b8
$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\\bar()foo\\bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b16
$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\\bar()foo\\bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b32
$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b1
r"foo]bar()foo]bar"
$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b2
r"foo]bar()foo]bar"
$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b4
r"foo]bar()foo]bar"
$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b8
r"foo]bar()foo]bar"
$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b16
r"foo]bar()foo]bar"
$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b32
r"foo]bar()foo]bar"
$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b1
r"foo^bar()foo^bar"
$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b2
r"foo^bar()foo^bar"
$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b4
r"foo^bar()foo^bar"
$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b8
r"foo^bar()foo^bar"
$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b16
r"foo^bar()foo^bar"
$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b32
r"foo^bar()foo^bar"
$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b1
r"foo_bar()foo_bar"
$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b2
r"foo_bar()foo_bar"
$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b4
r"foo_bar()foo_bar"
$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b8
r"foo_bar()foo_bar"
$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b16
r"foo_bar()foo_bar"
$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b32
r"foo_bar()foo_bar"
$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo`bar()foo`bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b1
$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo`bar()foo`bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b2
$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo`bar()foo`bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b4
$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo`bar()foo`bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b8
$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo`bar()foo`bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b16
$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo`bar()foo`bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b32
$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b1
r"fooabar()fooabar"
$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b2
r"fooabar()fooabar"
$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b4
r"fooabar()fooabar"
$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b8
r"fooabar()fooabar"
$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b16
r"fooabar()fooabar"
$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b32
r"fooabar()fooabar"
$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b1
r"foobbar()foobbar"
$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b2
r"foobbar()foobbar"
$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b4
r"foobbar()foobbar"
$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b8
r"foobbar()foobbar"
$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b16
r"foobbar()foobbar"
$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b32
r"foobbar()foobbar"
$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b1
r"foocbar()foocbar"
$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b2
r"foocbar()foocbar"
$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b4
r"foocbar()foocbar"
$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b8
r"foocbar()foocbar"
$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b16
r"foocbar()foocbar"
$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b32
r"foocbar()foocbar"
$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b1
r"foodbar()foodbar"
$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b2
r"foodbar()foodbar"
$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b4
r"foodbar()foodbar"
$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b8
r"foodbar()foodbar"
$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b16
r"foodbar()foodbar"
$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b32
r"foodbar()foodbar"
$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b1
r"fooebar()fooebar"
$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b2
r"fooebar()fooebar"
$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b4
r"fooebar()fooebar"
$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b8
r"fooebar()fooebar"
$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b16
r"fooebar()fooebar"
$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b32
r"fooebar()fooebar"
$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b1
r"foofbar()foofbar"
$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b2
r"foofbar()foofbar"
$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b4
r"foofbar()foofbar"
$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b8
r"foofbar()foofbar"
$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b16
r"foofbar()foofbar"
$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b32
r"foofbar()foofbar"
$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b1
r"foogbar()foogbar"
$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b2
r"foogbar()foogbar"
$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b4
r"foogbar()foogbar"
$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b8
r"foogbar()foogbar"
$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b16
r"foogbar()foogbar"
$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b32
r"foogbar()foogbar"
$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b1
r"foohbar()foohbar"
$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b2
r"foohbar()foohbar"
$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b4
r"foohbar()foohbar"
$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b8
r"foohbar()foohbar"
$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b16
r"foohbar()foohbar"
$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b32
r"foohbar()foohbar"
$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b1
r"fooibar()fooibar"
$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b2
r"fooibar()fooibar"
$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b4
r"fooibar()fooibar"
$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b8
r"fooibar()fooibar"
$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b16
r"fooibar()fooibar"
$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b32
r"fooibar()fooibar"
$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b1
r"foojbar()foojbar"
$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b2
r"foojbar()foojbar"
$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b4
r"foojbar()foojbar"
$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b8
r"foojbar()foojbar"
$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b16
r"foojbar()foojbar"
$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b32
r"foojbar()foojbar"
$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b1
r"fookbar()fookbar"
$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b2
r"fookbar()fookbar"
$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b4
r"fookbar()fookbar"
$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b8
r"fookbar()fookbar"
$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b16
r"fookbar()fookbar"
$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b32
r"fookbar()fookbar"
$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b1
r"foolbar()foolbar"
$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b2
r"foolbar()foolbar"
$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b4
r"foolbar()foolbar"
$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b8
r"foolbar()foolbar"
$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b16
r"foolbar()foolbar"
$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b32
r"foolbar()foolbar"
$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b1
r"foombar()foombar"
$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b2
r"foombar()foombar"
$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b4
r"foombar()foombar"
$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b8
r"foombar()foombar"
$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b16
r"foombar()foombar"
$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b32
r"foombar()foombar"
$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b1
r"foonbar()foonbar"
$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b2
r"foonbar()foonbar"
$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b4
r"foonbar()foonbar"
$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b8
r"foonbar()foonbar"
$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b16
r"foonbar()foonbar"
$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b32
r"foonbar()foonbar"
$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b1
r"fooobar()fooobar"
$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b2
r"fooobar()fooobar"
$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b4
r"fooobar()fooobar"
$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b8
r"fooobar()fooobar"
$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b16
r"fooobar()fooobar"
$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b32
r"fooobar()fooobar"
$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b1
r"foopbar()foopbar"
$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b2
r"foopbar()foopbar"
$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b4
r"foopbar()foopbar"
$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b8
r"foopbar()foopbar"
$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b16
r"foopbar()foopbar"
$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b32
r"foopbar()foopbar"
$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b1
r"fooqbar()fooqbar"
$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b2
r"fooqbar()fooqbar"
$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b4
r"fooqbar()fooqbar"
$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b8
r"fooqbar()fooqbar"
$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b16
r"fooqbar()fooqbar"
$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b32
r"fooqbar()fooqbar"
$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b1
r"foorbar()foorbar"
$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b2
r"foorbar()foorbar"
$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b4
r"foorbar()foorbar"
$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b8
r"foorbar()foorbar"
$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b16
r"foorbar()foorbar"
$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b32
r"foorbar()foorbar"
$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b1
r"foosbar()foosbar"
$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b2
r"foosbar()foosbar"
$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b4
r"foosbar()foosbar"
$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b8
r"foosbar()foosbar"
$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b16
r"foosbar()foosbar"
$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b32
r"foosbar()foosbar"
$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b1
r"footbar()footbar"
$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b2
r"footbar()footbar"
$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b4
r"footbar()footbar"
$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b8
r"footbar()footbar"
$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b16
r"footbar()footbar"
$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b32
r"footbar()footbar"
$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b1
r"fooubar()fooubar"
$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b2
r"fooubar()fooubar"
$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b4
r"fooubar()fooubar"
$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b8
r"fooubar()fooubar"
$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b16
r"fooubar()fooubar"
$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b32
r"fooubar()fooubar"
$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b1
r"foovbar()foovbar"
$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b2
r"foovbar()foovbar"
$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b4
r"foovbar()foovbar"
$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b8
r"foovbar()foovbar"
$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b16
r"foovbar()foovbar"
$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b32
r"foovbar()foovbar"
$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b1
r"foowbar()foowbar"
$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b2
r"foowbar()foowbar"
$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b4
r"foowbar()foowbar"
$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b8
r"foowbar()foowbar"
$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b16
r"foowbar()foowbar"
$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b32
r"foowbar()foowbar"
$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b1
r"fooxbar()fooxbar"
$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b2
r"fooxbar()fooxbar"
$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b4
r"fooxbar()fooxbar"
$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b8
r"fooxbar()fooxbar"
$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b16
r"fooxbar()fooxbar"
$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b32
r"fooxbar()fooxbar"
$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b1
r"fooybar()fooybar"
$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b2
r"fooybar()fooybar"
$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b4
r"fooybar()fooybar"
$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b8
r"fooybar()fooybar"
$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b16
r"fooybar()fooybar"
$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b32
r"fooybar()fooybar"
$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b1
r"foozbar()foozbar"
$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b2
r"foozbar()foozbar"
$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b4
r"foozbar()foozbar"
$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b8
r"foozbar()foozbar"
$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b16
r"foozbar()foozbar"
$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b32
r"foozbar()foozbar"
$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b1
r"foo{bar()foo{bar"
$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b2
r"foo{bar()foo{bar"
$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b4
r"foo{bar()foo{bar"
$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b8
r"foo{bar()foo{bar"
$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b16
r"foo{bar()foo{bar"
$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b32
r"foo{bar()foo{bar"
$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b1
r"foo|bar()foo|bar"
$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b2
r"foo|bar()foo|bar"
$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b4
r"foo|bar()foo|bar"
$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b8
r"foo|bar()foo|bar"
$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b16
r"foo|bar()foo|bar"
$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b32
r"foo|bar()foo|bar"
$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b1
r"foo}bar()foo}bar"
$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b2
r"foo}bar()foo}bar"
$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b4
r"foo}bar()foo}bar"
$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b8
r"foo}bar()foo}bar"
$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b16
r"foo}bar()foo}bar"
$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b32
r"foo}bar()foo}bar"
$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b1
r"foo~bar()foo~bar"
$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b2
r"foo~bar()foo~bar"
$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b4
r"foo~bar()foo~bar"
$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b8
r"foo~bar()foo~bar"
$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b16
r"foo~bar()foo~bar"
$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b32
r"foo~bar()foo~bar"
$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x7fbar()foo\x7fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b1
$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x7fbar()foo\x7fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b2
$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x7fbar()foo\x7fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b4
$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x7fbar()foo\x7fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b8
$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x7fbar()foo\x7fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b16
$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x7fbar()foo\x7fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b32
$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x80bar()foo\x80bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b1
$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x80bar()foo\x80bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b2
$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x80bar()foo\x80bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b4
$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x80bar()foo\x80bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b8
$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x80bar()foo\x80bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b16
$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x80bar()foo\x80bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b32
$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x81bar()foo\x81bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b1
$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x81bar()foo\x81bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b2
$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x81bar()foo\x81bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b4
$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x81bar()foo\x81bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b8
$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x81bar()foo\x81bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b16
$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x81bar()foo\x81bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b32
$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x82bar()foo\x82bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b1
$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x82bar()foo\x82bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b2
$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x82bar()foo\x82bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b4
$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x82bar()foo\x82bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b8
$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x82bar()foo\x82bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b16
$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x82bar()foo\x82bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b32
$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x83bar()foo\x83bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b1
$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x83bar()foo\x83bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b2
$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x83bar()foo\x83bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b4
$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x83bar()foo\x83bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b8
$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x83bar()foo\x83bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b16
$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x83bar()foo\x83bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b32
$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x84bar()foo\x84bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b1
$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x84bar()foo\x84bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b2
$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x84bar()foo\x84bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b4
$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x84bar()foo\x84bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b8
$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x84bar()foo\x84bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b16
$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x84bar()foo\x84bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b32
$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x85bar()foo\x85bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b1
$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x85bar()foo\x85bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b2
$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x85bar()foo\x85bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b4
$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x85bar()foo\x85bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b8
$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x85bar()foo\x85bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b16
$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x85bar()foo\x85bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b32
$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x86bar()foo\x86bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b1
$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x86bar()foo\x86bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b2
$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x86bar()foo\x86bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b4
$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x86bar()foo\x86bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b8
$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x86bar()foo\x86bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b16
$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x86bar()foo\x86bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b32
$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x87bar()foo\x87bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b1
$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x87bar()foo\x87bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b2
$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x87bar()foo\x87bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b4
$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x87bar()foo\x87bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b8
$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x87bar()foo\x87bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b16
$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x87bar()foo\x87bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b32
$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x88bar()foo\x88bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b1
$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x88bar()foo\x88bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b2
$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x88bar()foo\x88bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b4
$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x88bar()foo\x88bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b8
$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x88bar()foo\x88bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b16
$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x88bar()foo\x88bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b32
$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x89bar()foo\x89bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b1
$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x89bar()foo\x89bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b2
$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x89bar()foo\x89bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b4
$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x89bar()foo\x89bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b8
$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x89bar()foo\x89bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b16
$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x89bar()foo\x89bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b32
$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8abar()foo\x8abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b1
$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8abar()foo\x8abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b2
$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8abar()foo\x8abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b4
$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8abar()foo\x8abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b8
$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8abar()foo\x8abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b16
$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8abar()foo\x8abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b32
$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8bbar()foo\x8bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b1
$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8bbar()foo\x8bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b2
$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8bbar()foo\x8bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b4
$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8bbar()foo\x8bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b8
$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8bbar()foo\x8bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b16
$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8bbar()foo\x8bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b32
$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8cbar()foo\x8cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b1
$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8cbar()foo\x8cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b2
$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8cbar()foo\x8cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b4
$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8cbar()foo\x8cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b8
$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8cbar()foo\x8cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b16
$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8cbar()foo\x8cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b32
$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8dbar()foo\x8dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b1
$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8dbar()foo\x8dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b2
$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8dbar()foo\x8dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b4
$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8dbar()foo\x8dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b8
$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8dbar()foo\x8dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b16
$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8dbar()foo\x8dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b32
$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8ebar()foo\x8ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b1
$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8ebar()foo\x8ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b2
$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8ebar()foo\x8ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b4
$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8ebar()foo\x8ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b8
$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8ebar()foo\x8ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b16
$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8ebar()foo\x8ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b32
$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8fbar()foo\x8fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b1
$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8fbar()foo\x8fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b2
$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8fbar()foo\x8fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b4
$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8fbar()foo\x8fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b8
$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8fbar()foo\x8fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b16
$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x8fbar()foo\x8fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b32
$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x90bar()foo\x90bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b1
$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x90bar()foo\x90bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b2
$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x90bar()foo\x90bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b4
$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x90bar()foo\x90bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b8
$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x90bar()foo\x90bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b16
$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x90bar()foo\x90bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b32
$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x91bar()foo\x91bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b1
$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x91bar()foo\x91bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b2
$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x91bar()foo\x91bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b4
$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x91bar()foo\x91bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b8
$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x91bar()foo\x91bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b16
$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x91bar()foo\x91bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b32
$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x92bar()foo\x92bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b1
$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x92bar()foo\x92bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b2
$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x92bar()foo\x92bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b4
$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x92bar()foo\x92bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b8
$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x92bar()foo\x92bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b16
$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x92bar()foo\x92bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b32
$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x93bar()foo\x93bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b1
$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x93bar()foo\x93bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b2
$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x93bar()foo\x93bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b4
$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x93bar()foo\x93bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b8
$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x93bar()foo\x93bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b16
$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x93bar()foo\x93bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b32
$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x94bar()foo\x94bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b1
$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x94bar()foo\x94bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b2
$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x94bar()foo\x94bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b4
$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x94bar()foo\x94bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b8
$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x94bar()foo\x94bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b16
$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x94bar()foo\x94bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b32
$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x95bar()foo\x95bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b1
$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x95bar()foo\x95bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b2
$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x95bar()foo\x95bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b4
$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x95bar()foo\x95bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b8
$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x95bar()foo\x95bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b16
$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x95bar()foo\x95bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b32
$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x96bar()foo\x96bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b1
$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x96bar()foo\x96bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b2
$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x96bar()foo\x96bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b4
$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x96bar()foo\x96bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b8
$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x96bar()foo\x96bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b16
$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x96bar()foo\x96bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b32
$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x97bar()foo\x97bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b1
$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x97bar()foo\x97bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b2
$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x97bar()foo\x97bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b4
$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x97bar()foo\x97bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b8
$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x97bar()foo\x97bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b16
$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x97bar()foo\x97bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b32
$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x98bar()foo\x98bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b1
$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x98bar()foo\x98bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b2
$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x98bar()foo\x98bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b4
$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x98bar()foo\x98bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b8
$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x98bar()foo\x98bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b16
$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x98bar()foo\x98bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b32
$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x99bar()foo\x99bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b1
$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x99bar()foo\x99bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b2
$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x99bar()foo\x99bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b4
$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x99bar()foo\x99bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b8
$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x99bar()foo\x99bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b16
$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x99bar()foo\x99bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b32
$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9abar()foo\x9abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b1
$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9abar()foo\x9abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b2
$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9abar()foo\x9abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b4
$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9abar()foo\x9abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b8
$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9abar()foo\x9abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b16
$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9abar()foo\x9abar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b32
$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9bbar()foo\x9bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b1
$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9bbar()foo\x9bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b2
$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9bbar()foo\x9bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b4
$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9bbar()foo\x9bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b8
$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9bbar()foo\x9bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b16
$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9bbar()foo\x9bbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b32
$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9cbar()foo\x9cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b1
$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9cbar()foo\x9cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b2
$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9cbar()foo\x9cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b4
$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9cbar()foo\x9cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b8
$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9cbar()foo\x9cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b16
$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9cbar()foo\x9cbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b32
$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9dbar()foo\x9dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b1
$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9dbar()foo\x9dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b2
$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9dbar()foo\x9dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b4
$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9dbar()foo\x9dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b8
$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9dbar()foo\x9dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b16
$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9dbar()foo\x9dbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b32
$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9ebar()foo\x9ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b1
$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9ebar()foo\x9ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b2
$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9ebar()foo\x9ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b4
$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9ebar()foo\x9ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b8
$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9ebar()foo\x9ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b16
$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9ebar()foo\x9ebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b32
$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9fbar()foo\x9fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b1
$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9fbar()foo\x9fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b2
$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9fbar()foo\x9fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b4
$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9fbar()foo\x9fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b8
$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9fbar()foo\x9fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b16
$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\x9fbar()foo\x9fbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b32
$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa0bar()foo\xa0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b1
$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa0bar()foo\xa0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b2
$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa0bar()foo\xa0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b4
$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa0bar()foo\xa0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b8
$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa0bar()foo\xa0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b16
$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa0bar()foo\xa0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b32
$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa1bar()foo\xa1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b1
$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa1bar()foo\xa1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b2
$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa1bar()foo\xa1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b4
$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa1bar()foo\xa1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b8
$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa1bar()foo\xa1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b16
$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa1bar()foo\xa1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b32
$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa2bar()foo\xa2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b1
$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa2bar()foo\xa2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b2
$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa2bar()foo\xa2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b4
$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa2bar()foo\xa2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b8
$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa2bar()foo\xa2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b16
$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa2bar()foo\xa2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b32
$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa3bar()foo\xa3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b1
$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa3bar()foo\xa3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b2
$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa3bar()foo\xa3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b4
$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa3bar()foo\xa3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b8
$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa3bar()foo\xa3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b16
$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa3bar()foo\xa3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b32
$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa4bar()foo\xa4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b1
$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa4bar()foo\xa4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b2
$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa4bar()foo\xa4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b4
$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa4bar()foo\xa4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b8
$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa4bar()foo\xa4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b16
$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa4bar()foo\xa4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b32
$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa5bar()foo\xa5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b1
$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa5bar()foo\xa5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b2
$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa5bar()foo\xa5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b4
$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa5bar()foo\xa5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b8
$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa5bar()foo\xa5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b16
$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa5bar()foo\xa5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b32
$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa6bar()foo\xa6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b1
$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa6bar()foo\xa6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b2
$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa6bar()foo\xa6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b4
$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa6bar()foo\xa6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b8
$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa6bar()foo\xa6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b16
$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa6bar()foo\xa6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b32
$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa7bar()foo\xa7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b1
$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa7bar()foo\xa7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b2
$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa7bar()foo\xa7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b4
$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa7bar()foo\xa7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b8
$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa7bar()foo\xa7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b16
$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa7bar()foo\xa7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b32
$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa8bar()foo\xa8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b1
$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa8bar()foo\xa8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b2
$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa8bar()foo\xa8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b4
$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa8bar()foo\xa8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b8
$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa8bar()foo\xa8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b16
$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa8bar()foo\xa8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b32
$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa9bar()foo\xa9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b1
$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa9bar()foo\xa9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b2
$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa9bar()foo\xa9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b4
$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa9bar()foo\xa9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b8
$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa9bar()foo\xa9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b16
$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xa9bar()foo\xa9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b32
$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaabar()foo\xaabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b1
$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaabar()foo\xaabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b2
$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaabar()foo\xaabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b4
$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaabar()foo\xaabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b8
$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaabar()foo\xaabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b16
$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaabar()foo\xaabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b32
$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xabbar()foo\xabbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b1
$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xabbar()foo\xabbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b2
$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xabbar()foo\xabbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b4
$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xabbar()foo\xabbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b8
$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xabbar()foo\xabbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b16
$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xabbar()foo\xabbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b32
$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xacbar()foo\xacbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b1
$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xacbar()foo\xacbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b2
$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xacbar()foo\xacbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b4
$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xacbar()foo\xacbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b8
$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xacbar()foo\xacbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b16
$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xacbar()foo\xacbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b32
$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xadbar()foo\xadbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b1
$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xadbar()foo\xadbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b2
$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xadbar()foo\xadbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b4
$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xadbar()foo\xadbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b8
$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xadbar()foo\xadbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b16
$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xadbar()foo\xadbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b32
$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaebar()foo\xaebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b1
$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaebar()foo\xaebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b2
$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaebar()foo\xaebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b4
$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaebar()foo\xaebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b8
$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaebar()foo\xaebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b16
$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xaebar()foo\xaebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b32
$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xafbar()foo\xafbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b1
$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xafbar()foo\xafbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b2
$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xafbar()foo\xafbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b4
$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xafbar()foo\xafbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b8
$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xafbar()foo\xafbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b16
$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xafbar()foo\xafbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b32
$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb0bar()foo\xb0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b1
$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb0bar()foo\xb0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b2
$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb0bar()foo\xb0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b4
$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb0bar()foo\xb0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b8
$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb0bar()foo\xb0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b16
$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb0bar()foo\xb0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b32
$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb1bar()foo\xb1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b1
$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb1bar()foo\xb1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b2
$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb1bar()foo\xb1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b4
$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb1bar()foo\xb1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b8
$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb1bar()foo\xb1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b16
$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb1bar()foo\xb1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b32
$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb2bar()foo\xb2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b1
$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb2bar()foo\xb2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b2
$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb2bar()foo\xb2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b4
$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb2bar()foo\xb2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b8
$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb2bar()foo\xb2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b16
$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb2bar()foo\xb2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b32
$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb3bar()foo\xb3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b1
$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb3bar()foo\xb3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b2
$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb3bar()foo\xb3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b4
$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb3bar()foo\xb3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b8
$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb3bar()foo\xb3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b16
$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb3bar()foo\xb3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b32
$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb4bar()foo\xb4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b1
$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb4bar()foo\xb4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b2
$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb4bar()foo\xb4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b4
$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb4bar()foo\xb4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b8
$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb4bar()foo\xb4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b16
$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb4bar()foo\xb4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b32
$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb5bar()foo\xb5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b1
$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb5bar()foo\xb5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b2
$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb5bar()foo\xb5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b4
$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb5bar()foo\xb5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b8
$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb5bar()foo\xb5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b16
$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb5bar()foo\xb5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b32
$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb6bar()foo\xb6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b1
$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb6bar()foo\xb6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b2
$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb6bar()foo\xb6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b4
$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb6bar()foo\xb6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b8
$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb6bar()foo\xb6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b16
$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb6bar()foo\xb6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b32
$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb7bar()foo\xb7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b1
$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb7bar()foo\xb7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b2
$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb7bar()foo\xb7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b4
$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb7bar()foo\xb7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b8
$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb7bar()foo\xb7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b16
$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb7bar()foo\xb7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b32
$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb8bar()foo\xb8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b1
$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb8bar()foo\xb8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b2
$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb8bar()foo\xb8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b4
$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb8bar()foo\xb8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b8
$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb8bar()foo\xb8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b16
$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb8bar()foo\xb8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b32
$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb9bar()foo\xb9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b1
$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb9bar()foo\xb9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b2
$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb9bar()foo\xb9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b4
$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb9bar()foo\xb9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b8
$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb9bar()foo\xb9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b16
$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xb9bar()foo\xb9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b32
$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbabar()foo\xbabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b1
$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbabar()foo\xbabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b2
$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbabar()foo\xbabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b4
$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbabar()foo\xbabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b8
$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbabar()foo\xbabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b16
$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbabar()foo\xbabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b32
$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbbbar()foo\xbbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b1
$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbbbar()foo\xbbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b2
$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbbbar()foo\xbbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b4
$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbbbar()foo\xbbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b8
$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbbbar()foo\xbbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b16
$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbbbar()foo\xbbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b32
$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbcbar()foo\xbcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b1
$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbcbar()foo\xbcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b2
$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbcbar()foo\xbcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b4
$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbcbar()foo\xbcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b8
$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbcbar()foo\xbcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b16
$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbcbar()foo\xbcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b32
$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbdbar()foo\xbdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b1
$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbdbar()foo\xbdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b2
$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbdbar()foo\xbdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b4
$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbdbar()foo\xbdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b8
$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbdbar()foo\xbdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b16
$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbdbar()foo\xbdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b32
$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbebar()foo\xbebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b1
$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbebar()foo\xbebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b2
$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbebar()foo\xbebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b4
$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbebar()foo\xbebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b8
$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbebar()foo\xbebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b16
$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbebar()foo\xbebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b32
$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbfbar()foo\xbfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b1
$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbfbar()foo\xbfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b2
$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbfbar()foo\xbfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b4
$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbfbar()foo\xbfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b8
$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbfbar()foo\xbfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b16
$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xbfbar()foo\xbfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b32
$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc0bar()foo\xc0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b1
$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc0bar()foo\xc0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b2
$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc0bar()foo\xc0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b4
$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc0bar()foo\xc0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b8
$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc0bar()foo\xc0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b16
$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc0bar()foo\xc0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b32
$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc1bar()foo\xc1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b1
$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc1bar()foo\xc1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b2
$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc1bar()foo\xc1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b4
$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc1bar()foo\xc1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b8
$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc1bar()foo\xc1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b16
$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc1bar()foo\xc1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b32
$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc2bar()foo\xc2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b1
$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc2bar()foo\xc2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b2
$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc2bar()foo\xc2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b4
$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc2bar()foo\xc2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b8
$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc2bar()foo\xc2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b16
$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc2bar()foo\xc2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b32
$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc3bar()foo\xc3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b1
$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc3bar()foo\xc3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b2
$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc3bar()foo\xc3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b4
$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc3bar()foo\xc3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b8
$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc3bar()foo\xc3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b16
$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc3bar()foo\xc3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b32
$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc4bar()foo\xc4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b1
$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc4bar()foo\xc4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b2
$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc4bar()foo\xc4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b4
$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc4bar()foo\xc4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b8
$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc4bar()foo\xc4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b16
$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc4bar()foo\xc4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b32
$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc5bar()foo\xc5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b1
$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc5bar()foo\xc5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b2
$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc5bar()foo\xc5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b4
$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc5bar()foo\xc5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b8
$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc5bar()foo\xc5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b16
$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc5bar()foo\xc5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b32
$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc6bar()foo\xc6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b1
$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc6bar()foo\xc6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b2
$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc6bar()foo\xc6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b4
$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc6bar()foo\xc6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b8
$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc6bar()foo\xc6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b16
$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc6bar()foo\xc6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b32
$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc7bar()foo\xc7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b1
$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc7bar()foo\xc7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b2
$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc7bar()foo\xc7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b4
$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc7bar()foo\xc7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b8
$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc7bar()foo\xc7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b16
$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc7bar()foo\xc7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b32
$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc8bar()foo\xc8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b1
$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc8bar()foo\xc8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b2
$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc8bar()foo\xc8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b4
$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc8bar()foo\xc8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b8
$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc8bar()foo\xc8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b16
$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc8bar()foo\xc8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b32
$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc9bar()foo\xc9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b1
$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc9bar()foo\xc9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b2
$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc9bar()foo\xc9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b4
$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc9bar()foo\xc9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b8
$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc9bar()foo\xc9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b16
$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xc9bar()foo\xc9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b32
$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcabar()foo\xcabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b1
$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcabar()foo\xcabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b2
$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcabar()foo\xcabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b4
$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcabar()foo\xcabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b8
$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcabar()foo\xcabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b16
$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcabar()foo\xcabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b32
$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcbbar()foo\xcbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b1
$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcbbar()foo\xcbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b2
$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcbbar()foo\xcbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b4
$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcbbar()foo\xcbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b8
$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcbbar()foo\xcbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b16
$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcbbar()foo\xcbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b32
$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xccbar()foo\xccbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b1
$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xccbar()foo\xccbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b2
$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xccbar()foo\xccbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b4
$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xccbar()foo\xccbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b8
$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xccbar()foo\xccbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b16
$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xccbar()foo\xccbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b32
$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcdbar()foo\xcdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b1
$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcdbar()foo\xcdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b2
$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcdbar()foo\xcdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b4
$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcdbar()foo\xcdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b8
$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcdbar()foo\xcdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b16
$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcdbar()foo\xcdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b32
$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcebar()foo\xcebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b1
$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcebar()foo\xcebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b2
$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcebar()foo\xcebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b4
$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcebar()foo\xcebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b8
$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcebar()foo\xcebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b16
$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcebar()foo\xcebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b32
$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcfbar()foo\xcfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b1
$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcfbar()foo\xcfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b2
$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcfbar()foo\xcfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b4
$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcfbar()foo\xcfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b8
$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcfbar()foo\xcfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b16
$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xcfbar()foo\xcfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b32
$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd0bar()foo\xd0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b1
$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd0bar()foo\xd0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b2
$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd0bar()foo\xd0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b4
$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd0bar()foo\xd0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b8
$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd0bar()foo\xd0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b16
$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd0bar()foo\xd0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b32
$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd1bar()foo\xd1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b1
$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd1bar()foo\xd1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b2
$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd1bar()foo\xd1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b4
$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd1bar()foo\xd1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b8
$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd1bar()foo\xd1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b16
$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd1bar()foo\xd1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b32
$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd2bar()foo\xd2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b1
$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd2bar()foo\xd2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b2
$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd2bar()foo\xd2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b4
$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd2bar()foo\xd2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b8
$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd2bar()foo\xd2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b16
$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd2bar()foo\xd2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b32
$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd3bar()foo\xd3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b1
$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd3bar()foo\xd3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b2
$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd3bar()foo\xd3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b4
$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd3bar()foo\xd3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b8
$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd3bar()foo\xd3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b16
$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd3bar()foo\xd3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b32
$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd4bar()foo\xd4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b1
$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd4bar()foo\xd4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b2
$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd4bar()foo\xd4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b4
$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd4bar()foo\xd4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b8
$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd4bar()foo\xd4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b16
$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd4bar()foo\xd4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b32
$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd5bar()foo\xd5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b1
$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd5bar()foo\xd5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b2
$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd5bar()foo\xd5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b4
$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd5bar()foo\xd5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b8
$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd5bar()foo\xd5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b16
$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd5bar()foo\xd5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b32
$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd6bar()foo\xd6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b1
$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd6bar()foo\xd6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b2
$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd6bar()foo\xd6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b4
$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd6bar()foo\xd6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b8
$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd6bar()foo\xd6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b16
$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd6bar()foo\xd6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b32
$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd7bar()foo\xd7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b1
$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd7bar()foo\xd7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b2
$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd7bar()foo\xd7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b4
$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd7bar()foo\xd7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b8
$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd7bar()foo\xd7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b16
$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd7bar()foo\xd7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b32
$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd8bar()foo\xd8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b1
$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd8bar()foo\xd8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b2
$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd8bar()foo\xd8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b4
$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd8bar()foo\xd8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b8
$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd8bar()foo\xd8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b16
$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd8bar()foo\xd8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b32
$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd9bar()foo\xd9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b1
$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd9bar()foo\xd9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b2
$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd9bar()foo\xd9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b4
$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd9bar()foo\xd9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b8
$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd9bar()foo\xd9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b16
$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xd9bar()foo\xd9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b32
$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdabar()foo\xdabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b1
$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdabar()foo\xdabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b2
$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdabar()foo\xdabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b4
$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdabar()foo\xdabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b8
$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdabar()foo\xdabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b16
$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdabar()foo\xdabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b32
$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdbbar()foo\xdbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b1
$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdbbar()foo\xdbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b2
$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdbbar()foo\xdbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b4
$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdbbar()foo\xdbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b8
$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdbbar()foo\xdbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b16
$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdbbar()foo\xdbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b32
$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdcbar()foo\xdcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b1
$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdcbar()foo\xdcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b2
$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdcbar()foo\xdcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b4
$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdcbar()foo\xdcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b8
$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdcbar()foo\xdcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b16
$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdcbar()foo\xdcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b32
$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xddbar()foo\xddbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b1
$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xddbar()foo\xddbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b2
$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xddbar()foo\xddbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b4
$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xddbar()foo\xddbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b8
$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xddbar()foo\xddbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b16
$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xddbar()foo\xddbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b32
$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdebar()foo\xdebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b1
$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdebar()foo\xdebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b2
$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdebar()foo\xdebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b4
$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdebar()foo\xdebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b8
$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdebar()foo\xdebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b16
$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdebar()foo\xdebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b32
$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdfbar()foo\xdfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b1
$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdfbar()foo\xdfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b2
$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdfbar()foo\xdfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b4
$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdfbar()foo\xdfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b8
$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdfbar()foo\xdfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b16
$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xdfbar()foo\xdfbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b32
$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe0bar()foo\xe0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b1
$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe0bar()foo\xe0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b2
$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe0bar()foo\xe0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b4
$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe0bar()foo\xe0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b8
$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe0bar()foo\xe0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b16
$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe0bar()foo\xe0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b32
$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe1bar()foo\xe1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b1
$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe1bar()foo\xe1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b2
$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe1bar()foo\xe1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b4
$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe1bar()foo\xe1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b8
$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe1bar()foo\xe1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b16
$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe1bar()foo\xe1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b32
$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe2bar()foo\xe2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b1
$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe2bar()foo\xe2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b2
$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe2bar()foo\xe2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b4
$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe2bar()foo\xe2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b8
$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe2bar()foo\xe2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b16
$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe2bar()foo\xe2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b32
$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe3bar()foo\xe3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b1
$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe3bar()foo\xe3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b2
$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe3bar()foo\xe3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b4
$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe3bar()foo\xe3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b8
$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe3bar()foo\xe3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b16
$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe3bar()foo\xe3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b32
$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe4bar()foo\xe4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b1
$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe4bar()foo\xe4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b2
$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe4bar()foo\xe4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b4
$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe4bar()foo\xe4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b8
$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe4bar()foo\xe4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b16
$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe4bar()foo\xe4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b32
$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe5bar()foo\xe5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b1
$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe5bar()foo\xe5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b2
$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe5bar()foo\xe5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b4
$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe5bar()foo\xe5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b8
$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe5bar()foo\xe5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b16
$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe5bar()foo\xe5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b32
$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe6bar()foo\xe6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b1
$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe6bar()foo\xe6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b2
$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe6bar()foo\xe6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b4
$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe6bar()foo\xe6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b8
$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe6bar()foo\xe6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b16
$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe6bar()foo\xe6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b32
$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe7bar()foo\xe7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b1
$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe7bar()foo\xe7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b2
$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe7bar()foo\xe7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b4
$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe7bar()foo\xe7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b8
$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe7bar()foo\xe7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b16
$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe7bar()foo\xe7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b32
$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe8bar()foo\xe8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b1
$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe8bar()foo\xe8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b2
$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe8bar()foo\xe8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b4
$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe8bar()foo\xe8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b8
$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe8bar()foo\xe8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b16
$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe8bar()foo\xe8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b32
$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe9bar()foo\xe9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b1
$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe9bar()foo\xe9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b2
$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe9bar()foo\xe9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b4
$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe9bar()foo\xe9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b8
$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe9bar()foo\xe9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b16
$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xe9bar()foo\xe9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b32
$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeabar()foo\xeabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b1
$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeabar()foo\xeabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b2
$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeabar()foo\xeabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b4
$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeabar()foo\xeabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b8
$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeabar()foo\xeabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b16
$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeabar()foo\xeabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b32
$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xebbar()foo\xebbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b1
$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xebbar()foo\xebbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b2
$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xebbar()foo\xebbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b4
$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xebbar()foo\xebbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b8
$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xebbar()foo\xebbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b16
$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xebbar()foo\xebbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b32
$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xecbar()foo\xecbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b1
$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xecbar()foo\xecbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b2
$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xecbar()foo\xecbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b4
$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xecbar()foo\xecbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b8
$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xecbar()foo\xecbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b16
$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xecbar()foo\xecbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b32
$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xedbar()foo\xedbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b1
$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xedbar()foo\xedbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b2
$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xedbar()foo\xedbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b4
$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xedbar()foo\xedbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b8
$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xedbar()foo\xedbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b16
$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xedbar()foo\xedbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b32
$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeebar()foo\xeebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b1
$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeebar()foo\xeebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b2
$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeebar()foo\xeebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b4
$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeebar()foo\xeebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b8
$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeebar()foo\xeebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b16
$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xeebar()foo\xeebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b32
$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xefbar()foo\xefbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b1
$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xefbar()foo\xefbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b2
$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xefbar()foo\xefbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b4
$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xefbar()foo\xefbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b8
$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xefbar()foo\xefbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b16
$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xefbar()foo\xefbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b32
$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf0bar()foo\xf0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b1
$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf0bar()foo\xf0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b2
$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf0bar()foo\xf0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b4
$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf0bar()foo\xf0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b8
$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf0bar()foo\xf0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b16
$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf0bar()foo\xf0bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b32
$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf1bar()foo\xf1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b1
$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf1bar()foo\xf1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b2
$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf1bar()foo\xf1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b4
$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf1bar()foo\xf1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b8
$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf1bar()foo\xf1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b16
$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf1bar()foo\xf1bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b32
$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf2bar()foo\xf2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b1
$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf2bar()foo\xf2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b2
$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf2bar()foo\xf2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b4
$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf2bar()foo\xf2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b8
$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf2bar()foo\xf2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b16
$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf2bar()foo\xf2bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b32
$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf3bar()foo\xf3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b1
$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf3bar()foo\xf3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b2
$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf3bar()foo\xf3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b4
$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf3bar()foo\xf3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b8
$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf3bar()foo\xf3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b16
$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf3bar()foo\xf3bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b32
$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf4bar()foo\xf4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b1
$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf4bar()foo\xf4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b2
$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf4bar()foo\xf4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b4
$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf4bar()foo\xf4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b8
$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf4bar()foo\xf4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b16
$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf4bar()foo\xf4bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b32
$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf5bar()foo\xf5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b1
$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf5bar()foo\xf5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b2
$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf5bar()foo\xf5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b4
$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf5bar()foo\xf5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b8
$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf5bar()foo\xf5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b16
$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf5bar()foo\xf5bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b32
$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf6bar()foo\xf6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b1
$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf6bar()foo\xf6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b2
$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf6bar()foo\xf6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b4
$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf6bar()foo\xf6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b8
$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf6bar()foo\xf6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b16
$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf6bar()foo\xf6bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b32
$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf7bar()foo\xf7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b1
$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf7bar()foo\xf7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b2
$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf7bar()foo\xf7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b4
$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf7bar()foo\xf7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b8
$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf7bar()foo\xf7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b16
$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf7bar()foo\xf7bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b32
$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf8bar()foo\xf8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b1
$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf8bar()foo\xf8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b2
$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf8bar()foo\xf8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b4
$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf8bar()foo\xf8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b8
$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf8bar()foo\xf8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b16
$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf8bar()foo\xf8bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b32
$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf9bar()foo\xf9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b1
$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf9bar()foo\xf9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b2
$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf9bar()foo\xf9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b4
$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf9bar()foo\xf9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b8
$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf9bar()foo\xf9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b16
$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xf9bar()foo\xf9bar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b32
$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfabar()foo\xfabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b1
$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfabar()foo\xfabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b2
$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfabar()foo\xfabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b4
$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfabar()foo\xfabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b8
$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfabar()foo\xfabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b16
$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfabar()foo\xfabar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b32
$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfbbar()foo\xfbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b1
$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfbbar()foo\xfbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b2
$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfbbar()foo\xfbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b4
$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfbbar()foo\xfbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b8
$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfbbar()foo\xfbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b16
$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfbbar()foo\xfbbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b32
$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfcbar()foo\xfcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b1
$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfcbar()foo\xfcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b2
$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfcbar()foo\xfcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b4
$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfcbar()foo\xfcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b8
$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfcbar()foo\xfcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b16
$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfcbar()foo\xfcbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b32
$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfdbar()foo\xfdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b1
$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfdbar()foo\xfdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b2
$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfdbar()foo\xfdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b4
$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfdbar()foo\xfdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b8
$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfdbar()foo\xfdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b16
$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfdbar()foo\xfdbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b32
$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfebar()foo\xfebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b1
$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfebar()foo\xfebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b2
$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfebar()foo\xfebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b4
$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfebar()foo\xfebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b8
$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfebar()foo\xfebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b16
$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xfebar()foo\xfebar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b32
$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xffbar()foo\xffbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b1
$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xffbar()foo\xffbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b2
$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xffbar()foo\xffbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b4
$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b8
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xffbar()foo\xffbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b8
$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b16
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xffbar()foo\xffbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b16
$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b32
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"foo\xffbar()foo\xffbar"
json: error: <stdin>:1:6:      ^
command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b32'
) -L raw-string.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --raw-strings "$@"; }'
json() { json0 --literal-value --raw-strings "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --raw-strings "$@"; }'

echo '$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b1'
echo -ne 'r"foo\x00bar()foo\x00bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b2'
echo -ne 'r"foo\x00bar()foo\x00bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b4'
echo -ne 'r"foo\x00bar()foo\x00bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b8'
echo -ne 'r"foo\x00bar()foo\x00bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b16'
echo -ne 'r"foo\x00bar()foo\x00bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b32'
echo -ne 'r"foo\x00bar()foo\x00bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x00bar()foo\x00bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b1'
echo -ne 'r"foo\x01bar()foo\x01bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b2'
echo -ne 'r"foo\x01bar()foo\x01bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b4'
echo -ne 'r"foo\x01bar()foo\x01bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b8'
echo -ne 'r"foo\x01bar()foo\x01bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b16'
echo -ne 'r"foo\x01bar()foo\x01bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b32'
echo -ne 'r"foo\x01bar()foo\x01bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x01bar()foo\x01bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b1'
echo -ne 'r"foo\x02bar()foo\x02bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b2'
echo -ne 'r"foo\x02bar()foo\x02bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b4'
echo -ne 'r"foo\x02bar()foo\x02bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b8'
echo -ne 'r"foo\x02bar()foo\x02bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b16'
echo -ne 'r"foo\x02bar()foo\x02bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b32'
echo -ne 'r"foo\x02bar()foo\x02bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x02bar()foo\x02bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b1'
echo -ne 'r"foo\x03bar()foo\x03bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b2'
echo -ne 'r"foo\x03bar()foo\x03bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b4'
echo -ne 'r"foo\x03bar()foo\x03bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b8'
echo -ne 'r"foo\x03bar()foo\x03bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b16'
echo -ne 'r"foo\x03bar()foo\x03bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b32'
echo -ne 'r"foo\x03bar()foo\x03bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x03bar()foo\x03bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b1'
echo -ne 'r"foo\x04bar()foo\x04bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b2'
echo -ne 'r"foo\x04bar()foo\x04bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b4'
echo -ne 'r"foo\x04bar()foo\x04bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b8'
echo -ne 'r"foo\x04bar()foo\x04bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b16'
echo -ne 'r"foo\x04bar()foo\x04bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b32'
echo -ne 'r"foo\x04bar()foo\x04bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x04bar()foo\x04bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b1'
echo -ne 'r"foo\x05bar()foo\x05bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b2'
echo -ne 'r"foo\x05bar()foo\x05bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b4'
echo -ne 'r"foo\x05bar()foo\x05bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b8'
echo -ne 'r"foo\x05bar()foo\x05bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b16'
echo -ne 'r"foo\x05bar()foo\x05bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b32'
echo -ne 'r"foo\x05bar()foo\x05bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x05bar()foo\x05bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b1'
echo -ne 'r"foo\x06bar()foo\x06bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b2'
echo -ne 'r"foo\x06bar()foo\x06bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b4'
echo -ne 'r"foo\x06bar()foo\x06bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b8'
echo -ne 'r"foo\x06bar()foo\x06bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b16'
echo -ne 'r"foo\x06bar()foo\x06bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b32'
echo -ne 'r"foo\x06bar()foo\x06bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x06bar()foo\x06bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b1'
echo -ne 'r"foo\x07bar()foo\x07bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b2'
echo -ne 'r"foo\x07bar()foo\x07bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b4'
echo -ne 'r"foo\x07bar()foo\x07bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b8'
echo -ne 'r"foo\x07bar()foo\x07bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b16'
echo -ne 'r"foo\x07bar()foo\x07bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b32'
echo -ne 'r"foo\x07bar()foo\x07bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x07bar()foo\x07bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b1'
echo -ne 'r"foo\x08bar()foo\x08bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b2'
echo -ne 'r"foo\x08bar()foo\x08bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b4'
echo -ne 'r"foo\x08bar()foo\x08bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b8'
echo -ne 'r"foo\x08bar()foo\x08bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b16'
echo -ne 'r"foo\x08bar()foo\x08bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b32'
echo -ne 'r"foo\x08bar()foo\x08bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x08bar()foo\x08bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b1'
echo -ne 'r"foo\x09bar()foo\x09bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b2'
echo -ne 'r"foo\x09bar()foo\x09bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b4'
echo -ne 'r"foo\x09bar()foo\x09bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b8'
echo -ne 'r"foo\x09bar()foo\x09bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b16'
echo -ne 'r"foo\x09bar()foo\x09bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b32'
echo -ne 'r"foo\x09bar()foo\x09bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x09bar()foo\x09bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b1'
echo -ne 'r"foo\x0abar()foo\x0abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b2'
echo -ne 'r"foo\x0abar()foo\x0abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b4'
echo -ne 'r"foo\x0abar()foo\x0abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b8'
echo -ne 'r"foo\x0abar()foo\x0abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b16'
echo -ne 'r"foo\x0abar()foo\x0abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b32'
echo -ne 'r"foo\x0abar()foo\x0abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0abar()foo\x0abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b1'
echo -ne 'r"foo\x0bbar()foo\x0bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b2'
echo -ne 'r"foo\x0bbar()foo\x0bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b4'
echo -ne 'r"foo\x0bbar()foo\x0bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b8'
echo -ne 'r"foo\x0bbar()foo\x0bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b16'
echo -ne 'r"foo\x0bbar()foo\x0bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b32'
echo -ne 'r"foo\x0bbar()foo\x0bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0bbar()foo\x0bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b1'
echo -ne 'r"foo\x0cbar()foo\x0cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b2'
echo -ne 'r"foo\x0cbar()foo\x0cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b4'
echo -ne 'r"foo\x0cbar()foo\x0cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b8'
echo -ne 'r"foo\x0cbar()foo\x0cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b16'
echo -ne 'r"foo\x0cbar()foo\x0cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b32'
echo -ne 'r"foo\x0cbar()foo\x0cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0cbar()foo\x0cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b1'
echo -ne 'r"foo\x0dbar()foo\x0dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b2'
echo -ne 'r"foo\x0dbar()foo\x0dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b4'
echo -ne 'r"foo\x0dbar()foo\x0dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b8'
echo -ne 'r"foo\x0dbar()foo\x0dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b16'
echo -ne 'r"foo\x0dbar()foo\x0dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b32'
echo -ne 'r"foo\x0dbar()foo\x0dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0dbar()foo\x0dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b1'
echo -ne 'r"foo\x0ebar()foo\x0ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b2'
echo -ne 'r"foo\x0ebar()foo\x0ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b4'
echo -ne 'r"foo\x0ebar()foo\x0ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b8'
echo -ne 'r"foo\x0ebar()foo\x0ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b16'
echo -ne 'r"foo\x0ebar()foo\x0ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b32'
echo -ne 'r"foo\x0ebar()foo\x0ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0ebar()foo\x0ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b1'
echo -ne 'r"foo\x0fbar()foo\x0fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b2'
echo -ne 'r"foo\x0fbar()foo\x0fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b4'
echo -ne 'r"foo\x0fbar()foo\x0fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b8'
echo -ne 'r"foo\x0fbar()foo\x0fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b16'
echo -ne 'r"foo\x0fbar()foo\x0fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b32'
echo -ne 'r"foo\x0fbar()foo\x0fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x0fbar()foo\x0fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b1'
echo -ne 'r"foo\x10bar()foo\x10bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b2'
echo -ne 'r"foo\x10bar()foo\x10bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b4'
echo -ne 'r"foo\x10bar()foo\x10bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b8'
echo -ne 'r"foo\x10bar()foo\x10bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b16'
echo -ne 'r"foo\x10bar()foo\x10bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b32'
echo -ne 'r"foo\x10bar()foo\x10bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x10bar()foo\x10bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b1'
echo -ne 'r"foo\x11bar()foo\x11bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b2'
echo -ne 'r"foo\x11bar()foo\x11bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b4'
echo -ne 'r"foo\x11bar()foo\x11bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b8'
echo -ne 'r"foo\x11bar()foo\x11bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b16'
echo -ne 'r"foo\x11bar()foo\x11bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b32'
echo -ne 'r"foo\x11bar()foo\x11bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x11bar()foo\x11bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b1'
echo -ne 'r"foo\x12bar()foo\x12bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b2'
echo -ne 'r"foo\x12bar()foo\x12bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b4'
echo -ne 'r"foo\x12bar()foo\x12bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b8'
echo -ne 'r"foo\x12bar()foo\x12bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b16'
echo -ne 'r"foo\x12bar()foo\x12bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b32'
echo -ne 'r"foo\x12bar()foo\x12bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x12bar()foo\x12bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b1'
echo -ne 'r"foo\x13bar()foo\x13bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b2'
echo -ne 'r"foo\x13bar()foo\x13bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b4'
echo -ne 'r"foo\x13bar()foo\x13bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b8'
echo -ne 'r"foo\x13bar()foo\x13bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b16'
echo -ne 'r"foo\x13bar()foo\x13bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b32'
echo -ne 'r"foo\x13bar()foo\x13bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x13bar()foo\x13bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b1'
echo -ne 'r"foo\x14bar()foo\x14bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b2'
echo -ne 'r"foo\x14bar()foo\x14bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b4'
echo -ne 'r"foo\x14bar()foo\x14bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b8'
echo -ne 'r"foo\x14bar()foo\x14bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b16'
echo -ne 'r"foo\x14bar()foo\x14bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b32'
echo -ne 'r"foo\x14bar()foo\x14bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x14bar()foo\x14bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b1'
echo -ne 'r"foo\x15bar()foo\x15bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b2'
echo -ne 'r"foo\x15bar()foo\x15bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b4'
echo -ne 'r"foo\x15bar()foo\x15bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b8'
echo -ne 'r"foo\x15bar()foo\x15bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b16'
echo -ne 'r"foo\x15bar()foo\x15bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b32'
echo -ne 'r"foo\x15bar()foo\x15bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x15bar()foo\x15bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b1'
echo -ne 'r"foo\x16bar()foo\x16bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b2'
echo -ne 'r"foo\x16bar()foo\x16bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b4'
echo -ne 'r"foo\x16bar()foo\x16bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b8'
echo -ne 'r"foo\x16bar()foo\x16bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b16'
echo -ne 'r"foo\x16bar()foo\x16bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b32'
echo -ne 'r"foo\x16bar()foo\x16bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x16bar()foo\x16bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b1'
echo -ne 'r"foo\x17bar()foo\x17bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b2'
echo -ne 'r"foo\x17bar()foo\x17bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b4'
echo -ne 'r"foo\x17bar()foo\x17bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b8'
echo -ne 'r"foo\x17bar()foo\x17bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b16'
echo -ne 'r"foo\x17bar()foo\x17bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b32'
echo -ne 'r"foo\x17bar()foo\x17bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x17bar()foo\x17bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b1'
echo -ne 'r"foo\x18bar()foo\x18bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b2'
echo -ne 'r"foo\x18bar()foo\x18bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b4'
echo -ne 'r"foo\x18bar()foo\x18bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b8'
echo -ne 'r"foo\x18bar()foo\x18bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b16'
echo -ne 'r"foo\x18bar()foo\x18bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b32'
echo -ne 'r"foo\x18bar()foo\x18bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x18bar()foo\x18bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b1'
echo -ne 'r"foo\x19bar()foo\x19bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b2'
echo -ne 'r"foo\x19bar()foo\x19bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b4'
echo -ne 'r"foo\x19bar()foo\x19bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b8'
echo -ne 'r"foo\x19bar()foo\x19bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b16'
echo -ne 'r"foo\x19bar()foo\x19bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b32'
echo -ne 'r"foo\x19bar()foo\x19bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x19bar()foo\x19bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b1'
echo -ne 'r"foo\x1abar()foo\x1abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b2'
echo -ne 'r"foo\x1abar()foo\x1abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b4'
echo -ne 'r"foo\x1abar()foo\x1abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b8'
echo -ne 'r"foo\x1abar()foo\x1abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b16'
echo -ne 'r"foo\x1abar()foo\x1abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b32'
echo -ne 'r"foo\x1abar()foo\x1abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1abar()foo\x1abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b1'
echo -ne 'r"foo\x1bbar()foo\x1bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b2'
echo -ne 'r"foo\x1bbar()foo\x1bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b4'
echo -ne 'r"foo\x1bbar()foo\x1bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b8'
echo -ne 'r"foo\x1bbar()foo\x1bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b16'
echo -ne 'r"foo\x1bbar()foo\x1bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b32'
echo -ne 'r"foo\x1bbar()foo\x1bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1bbar()foo\x1bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b1'
echo -ne 'r"foo\x1cbar()foo\x1cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b2'
echo -ne 'r"foo\x1cbar()foo\x1cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b4'
echo -ne 'r"foo\x1cbar()foo\x1cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b8'
echo -ne 'r"foo\x1cbar()foo\x1cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b16'
echo -ne 'r"foo\x1cbar()foo\x1cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b32'
echo -ne 'r"foo\x1cbar()foo\x1cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1cbar()foo\x1cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b1'
echo -ne 'r"foo\x1dbar()foo\x1dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b2'
echo -ne 'r"foo\x1dbar()foo\x1dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b4'
echo -ne 'r"foo\x1dbar()foo\x1dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b8'
echo -ne 'r"foo\x1dbar()foo\x1dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b16'
echo -ne 'r"foo\x1dbar()foo\x1dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b32'
echo -ne 'r"foo\x1dbar()foo\x1dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1dbar()foo\x1dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b1'
echo -ne 'r"foo\x1ebar()foo\x1ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b2'
echo -ne 'r"foo\x1ebar()foo\x1ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b4'
echo -ne 'r"foo\x1ebar()foo\x1ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b8'
echo -ne 'r"foo\x1ebar()foo\x1ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b16'
echo -ne 'r"foo\x1ebar()foo\x1ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b32'
echo -ne 'r"foo\x1ebar()foo\x1ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1ebar()foo\x1ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b1'
echo -ne 'r"foo\x1fbar()foo\x1fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b2'
echo -ne 'r"foo\x1fbar()foo\x1fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b4'
echo -ne 'r"foo\x1fbar()foo\x1fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b8'
echo -ne 'r"foo\x1fbar()foo\x1fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b16'
echo -ne 'r"foo\x1fbar()foo\x1fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b32'
echo -ne 'r"foo\x1fbar()foo\x1fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x1fbar()foo\x1fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b1'
echo -ne 'r"foo\x20bar()foo\x20bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b2'
echo -ne 'r"foo\x20bar()foo\x20bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b4'
echo -ne 'r"foo\x20bar()foo\x20bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b8'
echo -ne 'r"foo\x20bar()foo\x20bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b16'
echo -ne 'r"foo\x20bar()foo\x20bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b32'
echo -ne 'r"foo\x20bar()foo\x20bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x20bar()foo\x20bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b1'
echo -ne 'r"foo\x21bar()foo\x21bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b2'
echo -ne 'r"foo\x21bar()foo\x21bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b4'
echo -ne 'r"foo\x21bar()foo\x21bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b8'
echo -ne 'r"foo\x21bar()foo\x21bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b16'
echo -ne 'r"foo\x21bar()foo\x21bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b32'
echo -ne 'r"foo\x21bar()foo\x21bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x21bar()foo\x21bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b1'
echo -ne 'r"foo\x22bar()foo\x22bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b2'
echo -ne 'r"foo\x22bar()foo\x22bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b4'
echo -ne 'r"foo\x22bar()foo\x22bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b8'
echo -ne 'r"foo\x22bar()foo\x22bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b16'
echo -ne 'r"foo\x22bar()foo\x22bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b32'
echo -ne 'r"foo\x22bar()foo\x22bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x22bar()foo\x22bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b1'
echo -ne 'r"foo\x23bar()foo\x23bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b2'
echo -ne 'r"foo\x23bar()foo\x23bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b4'
echo -ne 'r"foo\x23bar()foo\x23bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b8'
echo -ne 'r"foo\x23bar()foo\x23bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b16'
echo -ne 'r"foo\x23bar()foo\x23bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b32'
echo -ne 'r"foo\x23bar()foo\x23bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x23bar()foo\x23bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b1'
echo -ne 'r"foo\x24bar()foo\x24bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b2'
echo -ne 'r"foo\x24bar()foo\x24bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b4'
echo -ne 'r"foo\x24bar()foo\x24bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b8'
echo -ne 'r"foo\x24bar()foo\x24bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b16'
echo -ne 'r"foo\x24bar()foo\x24bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b32'
echo -ne 'r"foo\x24bar()foo\x24bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x24bar()foo\x24bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b1'
echo -ne 'r"foo\x25bar()foo\x25bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b2'
echo -ne 'r"foo\x25bar()foo\x25bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b4'
echo -ne 'r"foo\x25bar()foo\x25bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b8'
echo -ne 'r"foo\x25bar()foo\x25bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b16'
echo -ne 'r"foo\x25bar()foo\x25bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b32'
echo -ne 'r"foo\x25bar()foo\x25bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x25bar()foo\x25bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b1'
echo -ne 'r"foo\x26bar()foo\x26bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b2'
echo -ne 'r"foo\x26bar()foo\x26bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b4'
echo -ne 'r"foo\x26bar()foo\x26bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b8'
echo -ne 'r"foo\x26bar()foo\x26bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b16'
echo -ne 'r"foo\x26bar()foo\x26bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b32'
echo -ne 'r"foo\x26bar()foo\x26bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x26bar()foo\x26bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b1'
echo -ne 'r"foo\x27bar()foo\x27bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b2'
echo -ne 'r"foo\x27bar()foo\x27bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b4'
echo -ne 'r"foo\x27bar()foo\x27bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b8'
echo -ne 'r"foo\x27bar()foo\x27bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b16'
echo -ne 'r"foo\x27bar()foo\x27bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b32'
echo -ne 'r"foo\x27bar()foo\x27bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x27bar()foo\x27bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b1'
echo -ne 'r"foo\x28bar()foo\x28bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b2'
echo -ne 'r"foo\x28bar()foo\x28bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b4'
echo -ne 'r"foo\x28bar()foo\x28bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b8'
echo -ne 'r"foo\x28bar()foo\x28bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b16'
echo -ne 'r"foo\x28bar()foo\x28bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b32'
echo -ne 'r"foo\x28bar()foo\x28bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x28bar()foo\x28bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b1'
echo -ne 'r"foo\x29bar()foo\x29bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b2'
echo -ne 'r"foo\x29bar()foo\x29bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b4'
echo -ne 'r"foo\x29bar()foo\x29bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b8'
echo -ne 'r"foo\x29bar()foo\x29bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b16'
echo -ne 'r"foo\x29bar()foo\x29bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b32'
echo -ne 'r"foo\x29bar()foo\x29bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x29bar()foo\x29bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b1'
echo -ne 'r"foo\x2abar()foo\x2abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b2'
echo -ne 'r"foo\x2abar()foo\x2abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b4'
echo -ne 'r"foo\x2abar()foo\x2abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b8'
echo -ne 'r"foo\x2abar()foo\x2abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b16'
echo -ne 'r"foo\x2abar()foo\x2abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b32'
echo -ne 'r"foo\x2abar()foo\x2abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2abar()foo\x2abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b1'
echo -ne 'r"foo\x2bbar()foo\x2bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b2'
echo -ne 'r"foo\x2bbar()foo\x2bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b4'
echo -ne 'r"foo\x2bbar()foo\x2bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b8'
echo -ne 'r"foo\x2bbar()foo\x2bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b16'
echo -ne 'r"foo\x2bbar()foo\x2bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b32'
echo -ne 'r"foo\x2bbar()foo\x2bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2bbar()foo\x2bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b1'
echo -ne 'r"foo\x2cbar()foo\x2cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b2'
echo -ne 'r"foo\x2cbar()foo\x2cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b4'
echo -ne 'r"foo\x2cbar()foo\x2cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b8'
echo -ne 'r"foo\x2cbar()foo\x2cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b16'
echo -ne 'r"foo\x2cbar()foo\x2cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b32'
echo -ne 'r"foo\x2cbar()foo\x2cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2cbar()foo\x2cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b1'
echo -ne 'r"foo\x2dbar()foo\x2dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b2'
echo -ne 'r"foo\x2dbar()foo\x2dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b4'
echo -ne 'r"foo\x2dbar()foo\x2dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b8'
echo -ne 'r"foo\x2dbar()foo\x2dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b16'
echo -ne 'r"foo\x2dbar()foo\x2dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b32'
echo -ne 'r"foo\x2dbar()foo\x2dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2dbar()foo\x2dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b1'
echo -ne 'r"foo\x2ebar()foo\x2ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b2'
echo -ne 'r"foo\x2ebar()foo\x2ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b4'
echo -ne 'r"foo\x2ebar()foo\x2ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b8'
echo -ne 'r"foo\x2ebar()foo\x2ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b16'
echo -ne 'r"foo\x2ebar()foo\x2ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b32'
echo -ne 'r"foo\x2ebar()foo\x2ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2ebar()foo\x2ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b1'
echo -ne 'r"foo\x2fbar()foo\x2fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b2'
echo -ne 'r"foo\x2fbar()foo\x2fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b4'
echo -ne 'r"foo\x2fbar()foo\x2fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b8'
echo -ne 'r"foo\x2fbar()foo\x2fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b16'
echo -ne 'r"foo\x2fbar()foo\x2fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b32'
echo -ne 'r"foo\x2fbar()foo\x2fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x2fbar()foo\x2fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b1'
echo -ne 'r"foo\x30bar()foo\x30bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b2'
echo -ne 'r"foo\x30bar()foo\x30bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b4'
echo -ne 'r"foo\x30bar()foo\x30bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b8'
echo -ne 'r"foo\x30bar()foo\x30bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b16'
echo -ne 'r"foo\x30bar()foo\x30bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b32'
echo -ne 'r"foo\x30bar()foo\x30bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x30bar()foo\x30bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b1'
echo -ne 'r"foo\x31bar()foo\x31bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b2'
echo -ne 'r"foo\x31bar()foo\x31bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b4'
echo -ne 'r"foo\x31bar()foo\x31bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b8'
echo -ne 'r"foo\x31bar()foo\x31bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b16'
echo -ne 'r"foo\x31bar()foo\x31bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b32'
echo -ne 'r"foo\x31bar()foo\x31bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x31bar()foo\x31bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b1'
echo -ne 'r"foo\x32bar()foo\x32bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b2'
echo -ne 'r"foo\x32bar()foo\x32bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b4'
echo -ne 'r"foo\x32bar()foo\x32bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b8'
echo -ne 'r"foo\x32bar()foo\x32bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b16'
echo -ne 'r"foo\x32bar()foo\x32bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b32'
echo -ne 'r"foo\x32bar()foo\x32bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x32bar()foo\x32bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b1'
echo -ne 'r"foo\x33bar()foo\x33bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b2'
echo -ne 'r"foo\x33bar()foo\x33bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b4'
echo -ne 'r"foo\x33bar()foo\x33bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b8'
echo -ne 'r"foo\x33bar()foo\x33bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b16'
echo -ne 'r"foo\x33bar()foo\x33bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b32'
echo -ne 'r"foo\x33bar()foo\x33bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x33bar()foo\x33bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b1'
echo -ne 'r"foo\x34bar()foo\x34bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b2'
echo -ne 'r"foo\x34bar()foo\x34bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b4'
echo -ne 'r"foo\x34bar()foo\x34bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b8'
echo -ne 'r"foo\x34bar()foo\x34bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b16'
echo -ne 'r"foo\x34bar()foo\x34bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b32'
echo -ne 'r"foo\x34bar()foo\x34bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x34bar()foo\x34bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b1'
echo -ne 'r"foo\x35bar()foo\x35bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b2'
echo -ne 'r"foo\x35bar()foo\x35bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b4'
echo -ne 'r"foo\x35bar()foo\x35bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b8'
echo -ne 'r"foo\x35bar()foo\x35bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b16'
echo -ne 'r"foo\x35bar()foo\x35bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b32'
echo -ne 'r"foo\x35bar()foo\x35bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x35bar()foo\x35bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b1'
echo -ne 'r"foo\x36bar()foo\x36bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b2'
echo -ne 'r"foo\x36bar()foo\x36bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b4'
echo -ne 'r"foo\x36bar()foo\x36bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b8'
echo -ne 'r"foo\x36bar()foo\x36bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b16'
echo -ne 'r"foo\x36bar()foo\x36bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b32'
echo -ne 'r"foo\x36bar()foo\x36bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x36bar()foo\x36bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b1'
echo -ne 'r"foo\x37bar()foo\x37bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b2'
echo -ne 'r"foo\x37bar()foo\x37bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b4'
echo -ne 'r"foo\x37bar()foo\x37bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b8'
echo -ne 'r"foo\x37bar()foo\x37bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b16'
echo -ne 'r"foo\x37bar()foo\x37bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b32'
echo -ne 'r"foo\x37bar()foo\x37bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x37bar()foo\x37bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b1'
echo -ne 'r"foo\x38bar()foo\x38bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b2'
echo -ne 'r"foo\x38bar()foo\x38bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b4'
echo -ne 'r"foo\x38bar()foo\x38bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b8'
echo -ne 'r"foo\x38bar()foo\x38bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b16'
echo -ne 'r"foo\x38bar()foo\x38bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b32'
echo -ne 'r"foo\x38bar()foo\x38bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x38bar()foo\x38bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b1'
echo -ne 'r"foo\x39bar()foo\x39bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b2'
echo -ne 'r"foo\x39bar()foo\x39bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b4'
echo -ne 'r"foo\x39bar()foo\x39bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b8'
echo -ne 'r"foo\x39bar()foo\x39bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b16'
echo -ne 'r"foo\x39bar()foo\x39bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b32'
echo -ne 'r"foo\x39bar()foo\x39bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x39bar()foo\x39bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b1'
echo -ne 'r"foo\x3abar()foo\x3abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b2'
echo -ne 'r"foo\x3abar()foo\x3abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b4'
echo -ne 'r"foo\x3abar()foo\x3abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b8'
echo -ne 'r"foo\x3abar()foo\x3abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b16'
echo -ne 'r"foo\x3abar()foo\x3abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b32'
echo -ne 'r"foo\x3abar()foo\x3abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3abar()foo\x3abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b1'
echo -ne 'r"foo\x3bbar()foo\x3bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b2'
echo -ne 'r"foo\x3bbar()foo\x3bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b4'
echo -ne 'r"foo\x3bbar()foo\x3bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b8'
echo -ne 'r"foo\x3bbar()foo\x3bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b16'
echo -ne 'r"foo\x3bbar()foo\x3bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b32'
echo -ne 'r"foo\x3bbar()foo\x3bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3bbar()foo\x3bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b1'
echo -ne 'r"foo\x3cbar()foo\x3cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b2'
echo -ne 'r"foo\x3cbar()foo\x3cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b4'
echo -ne 'r"foo\x3cbar()foo\x3cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b8'
echo -ne 'r"foo\x3cbar()foo\x3cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b16'
echo -ne 'r"foo\x3cbar()foo\x3cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b32'
echo -ne 'r"foo\x3cbar()foo\x3cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3cbar()foo\x3cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b1'
echo -ne 'r"foo\x3dbar()foo\x3dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b2'
echo -ne 'r"foo\x3dbar()foo\x3dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b4'
echo -ne 'r"foo\x3dbar()foo\x3dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b8'
echo -ne 'r"foo\x3dbar()foo\x3dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b16'
echo -ne 'r"foo\x3dbar()foo\x3dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b32'
echo -ne 'r"foo\x3dbar()foo\x3dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3dbar()foo\x3dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b1'
echo -ne 'r"foo\x3ebar()foo\x3ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b2'
echo -ne 'r"foo\x3ebar()foo\x3ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b4'
echo -ne 'r"foo\x3ebar()foo\x3ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b8'
echo -ne 'r"foo\x3ebar()foo\x3ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b16'
echo -ne 'r"foo\x3ebar()foo\x3ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b32'
echo -ne 'r"foo\x3ebar()foo\x3ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3ebar()foo\x3ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b1'
echo -ne 'r"foo\x3fbar()foo\x3fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b2'
echo -ne 'r"foo\x3fbar()foo\x3fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b4'
echo -ne 'r"foo\x3fbar()foo\x3fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b8'
echo -ne 'r"foo\x3fbar()foo\x3fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b16'
echo -ne 'r"foo\x3fbar()foo\x3fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b32'
echo -ne 'r"foo\x3fbar()foo\x3fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x3fbar()foo\x3fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b1'
echo -ne 'r"foo\x40bar()foo\x40bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b2'
echo -ne 'r"foo\x40bar()foo\x40bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b4'
echo -ne 'r"foo\x40bar()foo\x40bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b8'
echo -ne 'r"foo\x40bar()foo\x40bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b16'
echo -ne 'r"foo\x40bar()foo\x40bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b32'
echo -ne 'r"foo\x40bar()foo\x40bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x40bar()foo\x40bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b1'
echo -ne 'r"foo\x41bar()foo\x41bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b2'
echo -ne 'r"foo\x41bar()foo\x41bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b4'
echo -ne 'r"foo\x41bar()foo\x41bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b8'
echo -ne 'r"foo\x41bar()foo\x41bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b16'
echo -ne 'r"foo\x41bar()foo\x41bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b32'
echo -ne 'r"foo\x41bar()foo\x41bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x41bar()foo\x41bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b1'
echo -ne 'r"foo\x42bar()foo\x42bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b2'
echo -ne 'r"foo\x42bar()foo\x42bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b4'
echo -ne 'r"foo\x42bar()foo\x42bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b8'
echo -ne 'r"foo\x42bar()foo\x42bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b16'
echo -ne 'r"foo\x42bar()foo\x42bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b32'
echo -ne 'r"foo\x42bar()foo\x42bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x42bar()foo\x42bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b1'
echo -ne 'r"foo\x43bar()foo\x43bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b2'
echo -ne 'r"foo\x43bar()foo\x43bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b4'
echo -ne 'r"foo\x43bar()foo\x43bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b8'
echo -ne 'r"foo\x43bar()foo\x43bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b16'
echo -ne 'r"foo\x43bar()foo\x43bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b32'
echo -ne 'r"foo\x43bar()foo\x43bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x43bar()foo\x43bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b1'
echo -ne 'r"foo\x44bar()foo\x44bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b2'
echo -ne 'r"foo\x44bar()foo\x44bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b4'
echo -ne 'r"foo\x44bar()foo\x44bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b8'
echo -ne 'r"foo\x44bar()foo\x44bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b16'
echo -ne 'r"foo\x44bar()foo\x44bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b32'
echo -ne 'r"foo\x44bar()foo\x44bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x44bar()foo\x44bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b1'
echo -ne 'r"foo\x45bar()foo\x45bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b2'
echo -ne 'r"foo\x45bar()foo\x45bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b4'
echo -ne 'r"foo\x45bar()foo\x45bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b8'
echo -ne 'r"foo\x45bar()foo\x45bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b16'
echo -ne 'r"foo\x45bar()foo\x45bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b32'
echo -ne 'r"foo\x45bar()foo\x45bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x45bar()foo\x45bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b1'
echo -ne 'r"foo\x46bar()foo\x46bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b2'
echo -ne 'r"foo\x46bar()foo\x46bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b4'
echo -ne 'r"foo\x46bar()foo\x46bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b8'
echo -ne 'r"foo\x46bar()foo\x46bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b16'
echo -ne 'r"foo\x46bar()foo\x46bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b32'
echo -ne 'r"foo\x46bar()foo\x46bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x46bar()foo\x46bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b1'
echo -ne 'r"foo\x47bar()foo\x47bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b2'
echo -ne 'r"foo\x47bar()foo\x47bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b4'
echo -ne 'r"foo\x47bar()foo\x47bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b8'
echo -ne 'r"foo\x47bar()foo\x47bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b16'
echo -ne 'r"foo\x47bar()foo\x47bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b32'
echo -ne 'r"foo\x47bar()foo\x47bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x47bar()foo\x47bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b1'
echo -ne 'r"foo\x48bar()foo\x48bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b2'
echo -ne 'r"foo\x48bar()foo\x48bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b4'
echo -ne 'r"foo\x48bar()foo\x48bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b8'
echo -ne 'r"foo\x48bar()foo\x48bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b16'
echo -ne 'r"foo\x48bar()foo\x48bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b32'
echo -ne 'r"foo\x48bar()foo\x48bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x48bar()foo\x48bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b1'
echo -ne 'r"foo\x49bar()foo\x49bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b2'
echo -ne 'r"foo\x49bar()foo\x49bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b4'
echo -ne 'r"foo\x49bar()foo\x49bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b8'
echo -ne 'r"foo\x49bar()foo\x49bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b16'
echo -ne 'r"foo\x49bar()foo\x49bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b32'
echo -ne 'r"foo\x49bar()foo\x49bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x49bar()foo\x49bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b1'
echo -ne 'r"foo\x4abar()foo\x4abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b2'
echo -ne 'r"foo\x4abar()foo\x4abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b4'
echo -ne 'r"foo\x4abar()foo\x4abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b8'
echo -ne 'r"foo\x4abar()foo\x4abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b16'
echo -ne 'r"foo\x4abar()foo\x4abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b32'
echo -ne 'r"foo\x4abar()foo\x4abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4abar()foo\x4abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b1'
echo -ne 'r"foo\x4bbar()foo\x4bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b2'
echo -ne 'r"foo\x4bbar()foo\x4bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b4'
echo -ne 'r"foo\x4bbar()foo\x4bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b8'
echo -ne 'r"foo\x4bbar()foo\x4bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b16'
echo -ne 'r"foo\x4bbar()foo\x4bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b32'
echo -ne 'r"foo\x4bbar()foo\x4bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4bbar()foo\x4bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b1'
echo -ne 'r"foo\x4cbar()foo\x4cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b2'
echo -ne 'r"foo\x4cbar()foo\x4cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b4'
echo -ne 'r"foo\x4cbar()foo\x4cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b8'
echo -ne 'r"foo\x4cbar()foo\x4cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b16'
echo -ne 'r"foo\x4cbar()foo\x4cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b32'
echo -ne 'r"foo\x4cbar()foo\x4cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4cbar()foo\x4cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b1'
echo -ne 'r"foo\x4dbar()foo\x4dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b2'
echo -ne 'r"foo\x4dbar()foo\x4dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b4'
echo -ne 'r"foo\x4dbar()foo\x4dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b8'
echo -ne 'r"foo\x4dbar()foo\x4dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b16'
echo -ne 'r"foo\x4dbar()foo\x4dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b32'
echo -ne 'r"foo\x4dbar()foo\x4dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4dbar()foo\x4dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b1'
echo -ne 'r"foo\x4ebar()foo\x4ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b2'
echo -ne 'r"foo\x4ebar()foo\x4ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b4'
echo -ne 'r"foo\x4ebar()foo\x4ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b8'
echo -ne 'r"foo\x4ebar()foo\x4ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b16'
echo -ne 'r"foo\x4ebar()foo\x4ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b32'
echo -ne 'r"foo\x4ebar()foo\x4ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4ebar()foo\x4ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b1'
echo -ne 'r"foo\x4fbar()foo\x4fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b2'
echo -ne 'r"foo\x4fbar()foo\x4fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b4'
echo -ne 'r"foo\x4fbar()foo\x4fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b8'
echo -ne 'r"foo\x4fbar()foo\x4fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b16'
echo -ne 'r"foo\x4fbar()foo\x4fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b32'
echo -ne 'r"foo\x4fbar()foo\x4fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x4fbar()foo\x4fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b1'
echo -ne 'r"foo\x50bar()foo\x50bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b2'
echo -ne 'r"foo\x50bar()foo\x50bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b4'
echo -ne 'r"foo\x50bar()foo\x50bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b8'
echo -ne 'r"foo\x50bar()foo\x50bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b16'
echo -ne 'r"foo\x50bar()foo\x50bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b32'
echo -ne 'r"foo\x50bar()foo\x50bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x50bar()foo\x50bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b1'
echo -ne 'r"foo\x51bar()foo\x51bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b2'
echo -ne 'r"foo\x51bar()foo\x51bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b4'
echo -ne 'r"foo\x51bar()foo\x51bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b8'
echo -ne 'r"foo\x51bar()foo\x51bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b16'
echo -ne 'r"foo\x51bar()foo\x51bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b32'
echo -ne 'r"foo\x51bar()foo\x51bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x51bar()foo\x51bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b1'
echo -ne 'r"foo\x52bar()foo\x52bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b2'
echo -ne 'r"foo\x52bar()foo\x52bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b4'
echo -ne 'r"foo\x52bar()foo\x52bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b8'
echo -ne 'r"foo\x52bar()foo\x52bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b16'
echo -ne 'r"foo\x52bar()foo\x52bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b32'
echo -ne 'r"foo\x52bar()foo\x52bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x52bar()foo\x52bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b1'
echo -ne 'r"foo\x53bar()foo\x53bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b2'
echo -ne 'r"foo\x53bar()foo\x53bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b4'
echo -ne 'r"foo\x53bar()foo\x53bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b8'
echo -ne 'r"foo\x53bar()foo\x53bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b16'
echo -ne 'r"foo\x53bar()foo\x53bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b32'
echo -ne 'r"foo\x53bar()foo\x53bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x53bar()foo\x53bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b1'
echo -ne 'r"foo\x54bar()foo\x54bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b2'
echo -ne 'r"foo\x54bar()foo\x54bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b4'
echo -ne 'r"foo\x54bar()foo\x54bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b8'
echo -ne 'r"foo\x54bar()foo\x54bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b16'
echo -ne 'r"foo\x54bar()foo\x54bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b32'
echo -ne 'r"foo\x54bar()foo\x54bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x54bar()foo\x54bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b1'
echo -ne 'r"foo\x55bar()foo\x55bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b2'
echo -ne 'r"foo\x55bar()foo\x55bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b4'
echo -ne 'r"foo\x55bar()foo\x55bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b8'
echo -ne 'r"foo\x55bar()foo\x55bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b16'
echo -ne 'r"foo\x55bar()foo\x55bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b32'
echo -ne 'r"foo\x55bar()foo\x55bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x55bar()foo\x55bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b1'
echo -ne 'r"foo\x56bar()foo\x56bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b2'
echo -ne 'r"foo\x56bar()foo\x56bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b4'
echo -ne 'r"foo\x56bar()foo\x56bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b8'
echo -ne 'r"foo\x56bar()foo\x56bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b16'
echo -ne 'r"foo\x56bar()foo\x56bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b32'
echo -ne 'r"foo\x56bar()foo\x56bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x56bar()foo\x56bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b1'
echo -ne 'r"foo\x57bar()foo\x57bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b2'
echo -ne 'r"foo\x57bar()foo\x57bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b4'
echo -ne 'r"foo\x57bar()foo\x57bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b8'
echo -ne 'r"foo\x57bar()foo\x57bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b16'
echo -ne 'r"foo\x57bar()foo\x57bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b32'
echo -ne 'r"foo\x57bar()foo\x57bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x57bar()foo\x57bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b1'
echo -ne 'r"foo\x58bar()foo\x58bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b2'
echo -ne 'r"foo\x58bar()foo\x58bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b4'
echo -ne 'r"foo\x58bar()foo\x58bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b8'
echo -ne 'r"foo\x58bar()foo\x58bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b16'
echo -ne 'r"foo\x58bar()foo\x58bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b32'
echo -ne 'r"foo\x58bar()foo\x58bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x58bar()foo\x58bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b1'
echo -ne 'r"foo\x59bar()foo\x59bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b2'
echo -ne 'r"foo\x59bar()foo\x59bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b4'
echo -ne 'r"foo\x59bar()foo\x59bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b8'
echo -ne 'r"foo\x59bar()foo\x59bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b16'
echo -ne 'r"foo\x59bar()foo\x59bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b32'
echo -ne 'r"foo\x59bar()foo\x59bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x59bar()foo\x59bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b1'
echo -ne 'r"foo\x5abar()foo\x5abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b2'
echo -ne 'r"foo\x5abar()foo\x5abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b4'
echo -ne 'r"foo\x5abar()foo\x5abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b8'
echo -ne 'r"foo\x5abar()foo\x5abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b16'
echo -ne 'r"foo\x5abar()foo\x5abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b32'
echo -ne 'r"foo\x5abar()foo\x5abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5abar()foo\x5abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b1'
echo -ne 'r"foo\x5bbar()foo\x5bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b2'
echo -ne 'r"foo\x5bbar()foo\x5bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b4'
echo -ne 'r"foo\x5bbar()foo\x5bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b8'
echo -ne 'r"foo\x5bbar()foo\x5bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b16'
echo -ne 'r"foo\x5bbar()foo\x5bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b32'
echo -ne 'r"foo\x5bbar()foo\x5bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5bbar()foo\x5bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b1'
echo -ne 'r"foo\x5cbar()foo\x5cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b2'
echo -ne 'r"foo\x5cbar()foo\x5cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b4'
echo -ne 'r"foo\x5cbar()foo\x5cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b8'
echo -ne 'r"foo\x5cbar()foo\x5cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b16'
echo -ne 'r"foo\x5cbar()foo\x5cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b32'
echo -ne 'r"foo\x5cbar()foo\x5cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5cbar()foo\x5cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b1'
echo -ne 'r"foo\x5dbar()foo\x5dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b2'
echo -ne 'r"foo\x5dbar()foo\x5dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b4'
echo -ne 'r"foo\x5dbar()foo\x5dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b8'
echo -ne 'r"foo\x5dbar()foo\x5dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b16'
echo -ne 'r"foo\x5dbar()foo\x5dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b32'
echo -ne 'r"foo\x5dbar()foo\x5dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5dbar()foo\x5dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b1'
echo -ne 'r"foo\x5ebar()foo\x5ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b2'
echo -ne 'r"foo\x5ebar()foo\x5ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b4'
echo -ne 'r"foo\x5ebar()foo\x5ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b8'
echo -ne 'r"foo\x5ebar()foo\x5ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b16'
echo -ne 'r"foo\x5ebar()foo\x5ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b32'
echo -ne 'r"foo\x5ebar()foo\x5ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5ebar()foo\x5ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b1'
echo -ne 'r"foo\x5fbar()foo\x5fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b2'
echo -ne 'r"foo\x5fbar()foo\x5fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b4'
echo -ne 'r"foo\x5fbar()foo\x5fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b8'
echo -ne 'r"foo\x5fbar()foo\x5fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b16'
echo -ne 'r"foo\x5fbar()foo\x5fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b32'
echo -ne 'r"foo\x5fbar()foo\x5fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x5fbar()foo\x5fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b1'
echo -ne 'r"foo\x60bar()foo\x60bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b2'
echo -ne 'r"foo\x60bar()foo\x60bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b4'
echo -ne 'r"foo\x60bar()foo\x60bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b8'
echo -ne 'r"foo\x60bar()foo\x60bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b16'
echo -ne 'r"foo\x60bar()foo\x60bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b32'
echo -ne 'r"foo\x60bar()foo\x60bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x60bar()foo\x60bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b1'
echo -ne 'r"foo\x61bar()foo\x61bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b2'
echo -ne 'r"foo\x61bar()foo\x61bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b4'
echo -ne 'r"foo\x61bar()foo\x61bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b8'
echo -ne 'r"foo\x61bar()foo\x61bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b16'
echo -ne 'r"foo\x61bar()foo\x61bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b32'
echo -ne 'r"foo\x61bar()foo\x61bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x61bar()foo\x61bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b1'
echo -ne 'r"foo\x62bar()foo\x62bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b2'
echo -ne 'r"foo\x62bar()foo\x62bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b4'
echo -ne 'r"foo\x62bar()foo\x62bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b8'
echo -ne 'r"foo\x62bar()foo\x62bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b16'
echo -ne 'r"foo\x62bar()foo\x62bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b32'
echo -ne 'r"foo\x62bar()foo\x62bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x62bar()foo\x62bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b1'
echo -ne 'r"foo\x63bar()foo\x63bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b2'
echo -ne 'r"foo\x63bar()foo\x63bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b4'
echo -ne 'r"foo\x63bar()foo\x63bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b8'
echo -ne 'r"foo\x63bar()foo\x63bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b16'
echo -ne 'r"foo\x63bar()foo\x63bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b32'
echo -ne 'r"foo\x63bar()foo\x63bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x63bar()foo\x63bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b1'
echo -ne 'r"foo\x64bar()foo\x64bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b2'
echo -ne 'r"foo\x64bar()foo\x64bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b4'
echo -ne 'r"foo\x64bar()foo\x64bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b8'
echo -ne 'r"foo\x64bar()foo\x64bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b16'
echo -ne 'r"foo\x64bar()foo\x64bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b32'
echo -ne 'r"foo\x64bar()foo\x64bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x64bar()foo\x64bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b1'
echo -ne 'r"foo\x65bar()foo\x65bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b2'
echo -ne 'r"foo\x65bar()foo\x65bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b4'
echo -ne 'r"foo\x65bar()foo\x65bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b8'
echo -ne 'r"foo\x65bar()foo\x65bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b16'
echo -ne 'r"foo\x65bar()foo\x65bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b32'
echo -ne 'r"foo\x65bar()foo\x65bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x65bar()foo\x65bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b1'
echo -ne 'r"foo\x66bar()foo\x66bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b2'
echo -ne 'r"foo\x66bar()foo\x66bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b4'
echo -ne 'r"foo\x66bar()foo\x66bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b8'
echo -ne 'r"foo\x66bar()foo\x66bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b16'
echo -ne 'r"foo\x66bar()foo\x66bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b32'
echo -ne 'r"foo\x66bar()foo\x66bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x66bar()foo\x66bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b1'
echo -ne 'r"foo\x67bar()foo\x67bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b2'
echo -ne 'r"foo\x67bar()foo\x67bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b4'
echo -ne 'r"foo\x67bar()foo\x67bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b8'
echo -ne 'r"foo\x67bar()foo\x67bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b16'
echo -ne 'r"foo\x67bar()foo\x67bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b32'
echo -ne 'r"foo\x67bar()foo\x67bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x67bar()foo\x67bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b1'
echo -ne 'r"foo\x68bar()foo\x68bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b2'
echo -ne 'r"foo\x68bar()foo\x68bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b4'
echo -ne 'r"foo\x68bar()foo\x68bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b8'
echo -ne 'r"foo\x68bar()foo\x68bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b16'
echo -ne 'r"foo\x68bar()foo\x68bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b32'
echo -ne 'r"foo\x68bar()foo\x68bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x68bar()foo\x68bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b1'
echo -ne 'r"foo\x69bar()foo\x69bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b2'
echo -ne 'r"foo\x69bar()foo\x69bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b4'
echo -ne 'r"foo\x69bar()foo\x69bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b8'
echo -ne 'r"foo\x69bar()foo\x69bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b16'
echo -ne 'r"foo\x69bar()foo\x69bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b32'
echo -ne 'r"foo\x69bar()foo\x69bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x69bar()foo\x69bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b1'
echo -ne 'r"foo\x6abar()foo\x6abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b2'
echo -ne 'r"foo\x6abar()foo\x6abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b4'
echo -ne 'r"foo\x6abar()foo\x6abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b8'
echo -ne 'r"foo\x6abar()foo\x6abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b16'
echo -ne 'r"foo\x6abar()foo\x6abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b32'
echo -ne 'r"foo\x6abar()foo\x6abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6abar()foo\x6abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b1'
echo -ne 'r"foo\x6bbar()foo\x6bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b2'
echo -ne 'r"foo\x6bbar()foo\x6bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b4'
echo -ne 'r"foo\x6bbar()foo\x6bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b8'
echo -ne 'r"foo\x6bbar()foo\x6bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b16'
echo -ne 'r"foo\x6bbar()foo\x6bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b32'
echo -ne 'r"foo\x6bbar()foo\x6bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6bbar()foo\x6bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b1'
echo -ne 'r"foo\x6cbar()foo\x6cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b2'
echo -ne 'r"foo\x6cbar()foo\x6cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b4'
echo -ne 'r"foo\x6cbar()foo\x6cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b8'
echo -ne 'r"foo\x6cbar()foo\x6cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b16'
echo -ne 'r"foo\x6cbar()foo\x6cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b32'
echo -ne 'r"foo\x6cbar()foo\x6cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6cbar()foo\x6cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b1'
echo -ne 'r"foo\x6dbar()foo\x6dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b2'
echo -ne 'r"foo\x6dbar()foo\x6dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b4'
echo -ne 'r"foo\x6dbar()foo\x6dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b8'
echo -ne 'r"foo\x6dbar()foo\x6dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b16'
echo -ne 'r"foo\x6dbar()foo\x6dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b32'
echo -ne 'r"foo\x6dbar()foo\x6dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6dbar()foo\x6dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b1'
echo -ne 'r"foo\x6ebar()foo\x6ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b2'
echo -ne 'r"foo\x6ebar()foo\x6ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b4'
echo -ne 'r"foo\x6ebar()foo\x6ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b8'
echo -ne 'r"foo\x6ebar()foo\x6ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b16'
echo -ne 'r"foo\x6ebar()foo\x6ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b32'
echo -ne 'r"foo\x6ebar()foo\x6ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6ebar()foo\x6ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b1'
echo -ne 'r"foo\x6fbar()foo\x6fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b2'
echo -ne 'r"foo\x6fbar()foo\x6fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b4'
echo -ne 'r"foo\x6fbar()foo\x6fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b8'
echo -ne 'r"foo\x6fbar()foo\x6fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b16'
echo -ne 'r"foo\x6fbar()foo\x6fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b32'
echo -ne 'r"foo\x6fbar()foo\x6fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x6fbar()foo\x6fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b1'
echo -ne 'r"foo\x70bar()foo\x70bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b2'
echo -ne 'r"foo\x70bar()foo\x70bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b4'
echo -ne 'r"foo\x70bar()foo\x70bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b8'
echo -ne 'r"foo\x70bar()foo\x70bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b16'
echo -ne 'r"foo\x70bar()foo\x70bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b32'
echo -ne 'r"foo\x70bar()foo\x70bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x70bar()foo\x70bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b1'
echo -ne 'r"foo\x71bar()foo\x71bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b2'
echo -ne 'r"foo\x71bar()foo\x71bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b4'
echo -ne 'r"foo\x71bar()foo\x71bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b8'
echo -ne 'r"foo\x71bar()foo\x71bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b16'
echo -ne 'r"foo\x71bar()foo\x71bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b32'
echo -ne 'r"foo\x71bar()foo\x71bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x71bar()foo\x71bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b1'
echo -ne 'r"foo\x72bar()foo\x72bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b2'
echo -ne 'r"foo\x72bar()foo\x72bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b4'
echo -ne 'r"foo\x72bar()foo\x72bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b8'
echo -ne 'r"foo\x72bar()foo\x72bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b16'
echo -ne 'r"foo\x72bar()foo\x72bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b32'
echo -ne 'r"foo\x72bar()foo\x72bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x72bar()foo\x72bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b1'
echo -ne 'r"foo\x73bar()foo\x73bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b2'
echo -ne 'r"foo\x73bar()foo\x73bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b4'
echo -ne 'r"foo\x73bar()foo\x73bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b8'
echo -ne 'r"foo\x73bar()foo\x73bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b16'
echo -ne 'r"foo\x73bar()foo\x73bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b32'
echo -ne 'r"foo\x73bar()foo\x73bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x73bar()foo\x73bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b1'
echo -ne 'r"foo\x74bar()foo\x74bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b2'
echo -ne 'r"foo\x74bar()foo\x74bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b4'
echo -ne 'r"foo\x74bar()foo\x74bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b8'
echo -ne 'r"foo\x74bar()foo\x74bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b16'
echo -ne 'r"foo\x74bar()foo\x74bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b32'
echo -ne 'r"foo\x74bar()foo\x74bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x74bar()foo\x74bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b1'
echo -ne 'r"foo\x75bar()foo\x75bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b2'
echo -ne 'r"foo\x75bar()foo\x75bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b4'
echo -ne 'r"foo\x75bar()foo\x75bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b8'
echo -ne 'r"foo\x75bar()foo\x75bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b16'
echo -ne 'r"foo\x75bar()foo\x75bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b32'
echo -ne 'r"foo\x75bar()foo\x75bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x75bar()foo\x75bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b1'
echo -ne 'r"foo\x76bar()foo\x76bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b2'
echo -ne 'r"foo\x76bar()foo\x76bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b4'
echo -ne 'r"foo\x76bar()foo\x76bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b8'
echo -ne 'r"foo\x76bar()foo\x76bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b16'
echo -ne 'r"foo\x76bar()foo\x76bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b32'
echo -ne 'r"foo\x76bar()foo\x76bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x76bar()foo\x76bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b1'
echo -ne 'r"foo\x77bar()foo\x77bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b2'
echo -ne 'r"foo\x77bar()foo\x77bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b4'
echo -ne 'r"foo\x77bar()foo\x77bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b8'
echo -ne 'r"foo\x77bar()foo\x77bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b16'
echo -ne 'r"foo\x77bar()foo\x77bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b32'
echo -ne 'r"foo\x77bar()foo\x77bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x77bar()foo\x77bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b1'
echo -ne 'r"foo\x78bar()foo\x78bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b2'
echo -ne 'r"foo\x78bar()foo\x78bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b4'
echo -ne 'r"foo\x78bar()foo\x78bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b8'
echo -ne 'r"foo\x78bar()foo\x78bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b16'
echo -ne 'r"foo\x78bar()foo\x78bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b32'
echo -ne 'r"foo\x78bar()foo\x78bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x78bar()foo\x78bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b1'
echo -ne 'r"foo\x79bar()foo\x79bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b2'
echo -ne 'r"foo\x79bar()foo\x79bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b4'
echo -ne 'r"foo\x79bar()foo\x79bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b8'
echo -ne 'r"foo\x79bar()foo\x79bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b16'
echo -ne 'r"foo\x79bar()foo\x79bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b32'
echo -ne 'r"foo\x79bar()foo\x79bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x79bar()foo\x79bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b1'
echo -ne 'r"foo\x7abar()foo\x7abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b2'
echo -ne 'r"foo\x7abar()foo\x7abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b4'
echo -ne 'r"foo\x7abar()foo\x7abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b8'
echo -ne 'r"foo\x7abar()foo\x7abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b16'
echo -ne 'r"foo\x7abar()foo\x7abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b32'
echo -ne 'r"foo\x7abar()foo\x7abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7abar()foo\x7abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b1'
echo -ne 'r"foo\x7bbar()foo\x7bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b2'
echo -ne 'r"foo\x7bbar()foo\x7bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b4'
echo -ne 'r"foo\x7bbar()foo\x7bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b8'
echo -ne 'r"foo\x7bbar()foo\x7bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b16'
echo -ne 'r"foo\x7bbar()foo\x7bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b32'
echo -ne 'r"foo\x7bbar()foo\x7bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7bbar()foo\x7bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b1'
echo -ne 'r"foo\x7cbar()foo\x7cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b2'
echo -ne 'r"foo\x7cbar()foo\x7cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b4'
echo -ne 'r"foo\x7cbar()foo\x7cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b8'
echo -ne 'r"foo\x7cbar()foo\x7cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b16'
echo -ne 'r"foo\x7cbar()foo\x7cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b32'
echo -ne 'r"foo\x7cbar()foo\x7cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7cbar()foo\x7cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b1'
echo -ne 'r"foo\x7dbar()foo\x7dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b2'
echo -ne 'r"foo\x7dbar()foo\x7dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b4'
echo -ne 'r"foo\x7dbar()foo\x7dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b8'
echo -ne 'r"foo\x7dbar()foo\x7dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b16'
echo -ne 'r"foo\x7dbar()foo\x7dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b32'
echo -ne 'r"foo\x7dbar()foo\x7dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7dbar()foo\x7dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b1'
echo -ne 'r"foo\x7ebar()foo\x7ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b2'
echo -ne 'r"foo\x7ebar()foo\x7ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b4'
echo -ne 'r"foo\x7ebar()foo\x7ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b8'
echo -ne 'r"foo\x7ebar()foo\x7ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b16'
echo -ne 'r"foo\x7ebar()foo\x7ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b32'
echo -ne 'r"foo\x7ebar()foo\x7ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7ebar()foo\x7ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b1'
echo -ne 'r"foo\x7fbar()foo\x7fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b2'
echo -ne 'r"foo\x7fbar()foo\x7fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b4'
echo -ne 'r"foo\x7fbar()foo\x7fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b8'
echo -ne 'r"foo\x7fbar()foo\x7fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b16'
echo -ne 'r"foo\x7fbar()foo\x7fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b32'
echo -ne 'r"foo\x7fbar()foo\x7fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x7fbar()foo\x7fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b1'
echo -ne 'r"foo\x80bar()foo\x80bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b2'
echo -ne 'r"foo\x80bar()foo\x80bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b4'
echo -ne 'r"foo\x80bar()foo\x80bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b8'
echo -ne 'r"foo\x80bar()foo\x80bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b16'
echo -ne 'r"foo\x80bar()foo\x80bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b32'
echo -ne 'r"foo\x80bar()foo\x80bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x80bar()foo\x80bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b1'
echo -ne 'r"foo\x81bar()foo\x81bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b2'
echo -ne 'r"foo\x81bar()foo\x81bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b4'
echo -ne 'r"foo\x81bar()foo\x81bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b8'
echo -ne 'r"foo\x81bar()foo\x81bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b16'
echo -ne 'r"foo\x81bar()foo\x81bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b32'
echo -ne 'r"foo\x81bar()foo\x81bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x81bar()foo\x81bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b1'
echo -ne 'r"foo\x82bar()foo\x82bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b2'
echo -ne 'r"foo\x82bar()foo\x82bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b4'
echo -ne 'r"foo\x82bar()foo\x82bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b8'
echo -ne 'r"foo\x82bar()foo\x82bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b16'
echo -ne 'r"foo\x82bar()foo\x82bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b32'
echo -ne 'r"foo\x82bar()foo\x82bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x82bar()foo\x82bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b1'
echo -ne 'r"foo\x83bar()foo\x83bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b2'
echo -ne 'r"foo\x83bar()foo\x83bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b4'
echo -ne 'r"foo\x83bar()foo\x83bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b8'
echo -ne 'r"foo\x83bar()foo\x83bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b16'
echo -ne 'r"foo\x83bar()foo\x83bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b32'
echo -ne 'r"foo\x83bar()foo\x83bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x83bar()foo\x83bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b1'
echo -ne 'r"foo\x84bar()foo\x84bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b2'
echo -ne 'r"foo\x84bar()foo\x84bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b4'
echo -ne 'r"foo\x84bar()foo\x84bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b8'
echo -ne 'r"foo\x84bar()foo\x84bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b16'
echo -ne 'r"foo\x84bar()foo\x84bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b32'
echo -ne 'r"foo\x84bar()foo\x84bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x84bar()foo\x84bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b1'
echo -ne 'r"foo\x85bar()foo\x85bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b2'
echo -ne 'r"foo\x85bar()foo\x85bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b4'
echo -ne 'r"foo\x85bar()foo\x85bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b8'
echo -ne 'r"foo\x85bar()foo\x85bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b16'
echo -ne 'r"foo\x85bar()foo\x85bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b32'
echo -ne 'r"foo\x85bar()foo\x85bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x85bar()foo\x85bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b1'
echo -ne 'r"foo\x86bar()foo\x86bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b2'
echo -ne 'r"foo\x86bar()foo\x86bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b4'
echo -ne 'r"foo\x86bar()foo\x86bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b8'
echo -ne 'r"foo\x86bar()foo\x86bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b16'
echo -ne 'r"foo\x86bar()foo\x86bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b32'
echo -ne 'r"foo\x86bar()foo\x86bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x86bar()foo\x86bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b1'
echo -ne 'r"foo\x87bar()foo\x87bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b2'
echo -ne 'r"foo\x87bar()foo\x87bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b4'
echo -ne 'r"foo\x87bar()foo\x87bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b8'
echo -ne 'r"foo\x87bar()foo\x87bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b16'
echo -ne 'r"foo\x87bar()foo\x87bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b32'
echo -ne 'r"foo\x87bar()foo\x87bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x87bar()foo\x87bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b1'
echo -ne 'r"foo\x88bar()foo\x88bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b2'
echo -ne 'r"foo\x88bar()foo\x88bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b4'
echo -ne 'r"foo\x88bar()foo\x88bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b8'
echo -ne 'r"foo\x88bar()foo\x88bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b16'
echo -ne 'r"foo\x88bar()foo\x88bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b32'
echo -ne 'r"foo\x88bar()foo\x88bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x88bar()foo\x88bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b1'
echo -ne 'r"foo\x89bar()foo\x89bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b2'
echo -ne 'r"foo\x89bar()foo\x89bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b4'
echo -ne 'r"foo\x89bar()foo\x89bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b8'
echo -ne 'r"foo\x89bar()foo\x89bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b16'
echo -ne 'r"foo\x89bar()foo\x89bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b32'
echo -ne 'r"foo\x89bar()foo\x89bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x89bar()foo\x89bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b1'
echo -ne 'r"foo\x8abar()foo\x8abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b2'
echo -ne 'r"foo\x8abar()foo\x8abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b4'
echo -ne 'r"foo\x8abar()foo\x8abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b8'
echo -ne 'r"foo\x8abar()foo\x8abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b16'
echo -ne 'r"foo\x8abar()foo\x8abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b32'
echo -ne 'r"foo\x8abar()foo\x8abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8abar()foo\x8abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b1'
echo -ne 'r"foo\x8bbar()foo\x8bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b2'
echo -ne 'r"foo\x8bbar()foo\x8bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b4'
echo -ne 'r"foo\x8bbar()foo\x8bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b8'
echo -ne 'r"foo\x8bbar()foo\x8bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b16'
echo -ne 'r"foo\x8bbar()foo\x8bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b32'
echo -ne 'r"foo\x8bbar()foo\x8bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8bbar()foo\x8bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b1'
echo -ne 'r"foo\x8cbar()foo\x8cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b2'
echo -ne 'r"foo\x8cbar()foo\x8cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b4'
echo -ne 'r"foo\x8cbar()foo\x8cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b8'
echo -ne 'r"foo\x8cbar()foo\x8cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b16'
echo -ne 'r"foo\x8cbar()foo\x8cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b32'
echo -ne 'r"foo\x8cbar()foo\x8cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8cbar()foo\x8cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b1'
echo -ne 'r"foo\x8dbar()foo\x8dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b2'
echo -ne 'r"foo\x8dbar()foo\x8dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b4'
echo -ne 'r"foo\x8dbar()foo\x8dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b8'
echo -ne 'r"foo\x8dbar()foo\x8dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b16'
echo -ne 'r"foo\x8dbar()foo\x8dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b32'
echo -ne 'r"foo\x8dbar()foo\x8dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8dbar()foo\x8dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b1'
echo -ne 'r"foo\x8ebar()foo\x8ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b2'
echo -ne 'r"foo\x8ebar()foo\x8ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b4'
echo -ne 'r"foo\x8ebar()foo\x8ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b8'
echo -ne 'r"foo\x8ebar()foo\x8ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b16'
echo -ne 'r"foo\x8ebar()foo\x8ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b32'
echo -ne 'r"foo\x8ebar()foo\x8ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8ebar()foo\x8ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b1'
echo -ne 'r"foo\x8fbar()foo\x8fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b2'
echo -ne 'r"foo\x8fbar()foo\x8fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b4'
echo -ne 'r"foo\x8fbar()foo\x8fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b8'
echo -ne 'r"foo\x8fbar()foo\x8fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b16'
echo -ne 'r"foo\x8fbar()foo\x8fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b32'
echo -ne 'r"foo\x8fbar()foo\x8fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x8fbar()foo\x8fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b1'
echo -ne 'r"foo\x90bar()foo\x90bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b2'
echo -ne 'r"foo\x90bar()foo\x90bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b4'
echo -ne 'r"foo\x90bar()foo\x90bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b8'
echo -ne 'r"foo\x90bar()foo\x90bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b16'
echo -ne 'r"foo\x90bar()foo\x90bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b32'
echo -ne 'r"foo\x90bar()foo\x90bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x90bar()foo\x90bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b1'
echo -ne 'r"foo\x91bar()foo\x91bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b2'
echo -ne 'r"foo\x91bar()foo\x91bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b4'
echo -ne 'r"foo\x91bar()foo\x91bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b8'
echo -ne 'r"foo\x91bar()foo\x91bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b16'
echo -ne 'r"foo\x91bar()foo\x91bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b32'
echo -ne 'r"foo\x91bar()foo\x91bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x91bar()foo\x91bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b1'
echo -ne 'r"foo\x92bar()foo\x92bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b2'
echo -ne 'r"foo\x92bar()foo\x92bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b4'
echo -ne 'r"foo\x92bar()foo\x92bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b8'
echo -ne 'r"foo\x92bar()foo\x92bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b16'
echo -ne 'r"foo\x92bar()foo\x92bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b32'
echo -ne 'r"foo\x92bar()foo\x92bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x92bar()foo\x92bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b1'
echo -ne 'r"foo\x93bar()foo\x93bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b2'
echo -ne 'r"foo\x93bar()foo\x93bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b4'
echo -ne 'r"foo\x93bar()foo\x93bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b8'
echo -ne 'r"foo\x93bar()foo\x93bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b16'
echo -ne 'r"foo\x93bar()foo\x93bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b32'
echo -ne 'r"foo\x93bar()foo\x93bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x93bar()foo\x93bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b1'
echo -ne 'r"foo\x94bar()foo\x94bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b2'
echo -ne 'r"foo\x94bar()foo\x94bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b4'
echo -ne 'r"foo\x94bar()foo\x94bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b8'
echo -ne 'r"foo\x94bar()foo\x94bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b16'
echo -ne 'r"foo\x94bar()foo\x94bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b32'
echo -ne 'r"foo\x94bar()foo\x94bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x94bar()foo\x94bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b1'
echo -ne 'r"foo\x95bar()foo\x95bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b2'
echo -ne 'r"foo\x95bar()foo\x95bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b4'
echo -ne 'r"foo\x95bar()foo\x95bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b8'
echo -ne 'r"foo\x95bar()foo\x95bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b16'
echo -ne 'r"foo\x95bar()foo\x95bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b32'
echo -ne 'r"foo\x95bar()foo\x95bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x95bar()foo\x95bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b1'
echo -ne 'r"foo\x96bar()foo\x96bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b2'
echo -ne 'r"foo\x96bar()foo\x96bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b4'
echo -ne 'r"foo\x96bar()foo\x96bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b8'
echo -ne 'r"foo\x96bar()foo\x96bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b16'
echo -ne 'r"foo\x96bar()foo\x96bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b32'
echo -ne 'r"foo\x96bar()foo\x96bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x96bar()foo\x96bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b1'
echo -ne 'r"foo\x97bar()foo\x97bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b2'
echo -ne 'r"foo\x97bar()foo\x97bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b4'
echo -ne 'r"foo\x97bar()foo\x97bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b8'
echo -ne 'r"foo\x97bar()foo\x97bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b16'
echo -ne 'r"foo\x97bar()foo\x97bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b32'
echo -ne 'r"foo\x97bar()foo\x97bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x97bar()foo\x97bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b1'
echo -ne 'r"foo\x98bar()foo\x98bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b2'
echo -ne 'r"foo\x98bar()foo\x98bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b4'
echo -ne 'r"foo\x98bar()foo\x98bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b8'
echo -ne 'r"foo\x98bar()foo\x98bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b16'
echo -ne 'r"foo\x98bar()foo\x98bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b32'
echo -ne 'r"foo\x98bar()foo\x98bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x98bar()foo\x98bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b1'
echo -ne 'r"foo\x99bar()foo\x99bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b2'
echo -ne 'r"foo\x99bar()foo\x99bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b4'
echo -ne 'r"foo\x99bar()foo\x99bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b8'
echo -ne 'r"foo\x99bar()foo\x99bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b16'
echo -ne 'r"foo\x99bar()foo\x99bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b32'
echo -ne 'r"foo\x99bar()foo\x99bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x99bar()foo\x99bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b1'
echo -ne 'r"foo\x9abar()foo\x9abar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b2'
echo -ne 'r"foo\x9abar()foo\x9abar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b4'
echo -ne 'r"foo\x9abar()foo\x9abar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b8'
echo -ne 'r"foo\x9abar()foo\x9abar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b16'
echo -ne 'r"foo\x9abar()foo\x9abar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b32'
echo -ne 'r"foo\x9abar()foo\x9abar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9abar()foo\x9abar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b1'
echo -ne 'r"foo\x9bbar()foo\x9bbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b2'
echo -ne 'r"foo\x9bbar()foo\x9bbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b4'
echo -ne 'r"foo\x9bbar()foo\x9bbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b8'
echo -ne 'r"foo\x9bbar()foo\x9bbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b16'
echo -ne 'r"foo\x9bbar()foo\x9bbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b32'
echo -ne 'r"foo\x9bbar()foo\x9bbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9bbar()foo\x9bbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b1'
echo -ne 'r"foo\x9cbar()foo\x9cbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b2'
echo -ne 'r"foo\x9cbar()foo\x9cbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b4'
echo -ne 'r"foo\x9cbar()foo\x9cbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b8'
echo -ne 'r"foo\x9cbar()foo\x9cbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b16'
echo -ne 'r"foo\x9cbar()foo\x9cbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b32'
echo -ne 'r"foo\x9cbar()foo\x9cbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9cbar()foo\x9cbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b1'
echo -ne 'r"foo\x9dbar()foo\x9dbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b2'
echo -ne 'r"foo\x9dbar()foo\x9dbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b4'
echo -ne 'r"foo\x9dbar()foo\x9dbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b8'
echo -ne 'r"foo\x9dbar()foo\x9dbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b16'
echo -ne 'r"foo\x9dbar()foo\x9dbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b32'
echo -ne 'r"foo\x9dbar()foo\x9dbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9dbar()foo\x9dbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b1'
echo -ne 'r"foo\x9ebar()foo\x9ebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b2'
echo -ne 'r"foo\x9ebar()foo\x9ebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b4'
echo -ne 'r"foo\x9ebar()foo\x9ebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b8'
echo -ne 'r"foo\x9ebar()foo\x9ebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b16'
echo -ne 'r"foo\x9ebar()foo\x9ebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b32'
echo -ne 'r"foo\x9ebar()foo\x9ebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9ebar()foo\x9ebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b1'
echo -ne 'r"foo\x9fbar()foo\x9fbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b2'
echo -ne 'r"foo\x9fbar()foo\x9fbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b4'
echo -ne 'r"foo\x9fbar()foo\x9fbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b8'
echo -ne 'r"foo\x9fbar()foo\x9fbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b16'
echo -ne 'r"foo\x9fbar()foo\x9fbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b32'
echo -ne 'r"foo\x9fbar()foo\x9fbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\x9fbar()foo\x9fbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b1'
echo -ne 'r"foo\xa0bar()foo\xa0bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b2'
echo -ne 'r"foo\xa0bar()foo\xa0bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b4'
echo -ne 'r"foo\xa0bar()foo\xa0bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b8'
echo -ne 'r"foo\xa0bar()foo\xa0bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b16'
echo -ne 'r"foo\xa0bar()foo\xa0bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b32'
echo -ne 'r"foo\xa0bar()foo\xa0bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa0bar()foo\xa0bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b1'
echo -ne 'r"foo\xa1bar()foo\xa1bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b2'
echo -ne 'r"foo\xa1bar()foo\xa1bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b4'
echo -ne 'r"foo\xa1bar()foo\xa1bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b8'
echo -ne 'r"foo\xa1bar()foo\xa1bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b16'
echo -ne 'r"foo\xa1bar()foo\xa1bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b32'
echo -ne 'r"foo\xa1bar()foo\xa1bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa1bar()foo\xa1bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b1'
echo -ne 'r"foo\xa2bar()foo\xa2bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b2'
echo -ne 'r"foo\xa2bar()foo\xa2bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b4'
echo -ne 'r"foo\xa2bar()foo\xa2bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b8'
echo -ne 'r"foo\xa2bar()foo\xa2bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b16'
echo -ne 'r"foo\xa2bar()foo\xa2bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b32'
echo -ne 'r"foo\xa2bar()foo\xa2bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa2bar()foo\xa2bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b1'
echo -ne 'r"foo\xa3bar()foo\xa3bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b2'
echo -ne 'r"foo\xa3bar()foo\xa3bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b4'
echo -ne 'r"foo\xa3bar()foo\xa3bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b8'
echo -ne 'r"foo\xa3bar()foo\xa3bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b16'
echo -ne 'r"foo\xa3bar()foo\xa3bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b32'
echo -ne 'r"foo\xa3bar()foo\xa3bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa3bar()foo\xa3bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b1'
echo -ne 'r"foo\xa4bar()foo\xa4bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b2'
echo -ne 'r"foo\xa4bar()foo\xa4bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b4'
echo -ne 'r"foo\xa4bar()foo\xa4bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b8'
echo -ne 'r"foo\xa4bar()foo\xa4bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b16'
echo -ne 'r"foo\xa4bar()foo\xa4bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b32'
echo -ne 'r"foo\xa4bar()foo\xa4bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa4bar()foo\xa4bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b1'
echo -ne 'r"foo\xa5bar()foo\xa5bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b2'
echo -ne 'r"foo\xa5bar()foo\xa5bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b4'
echo -ne 'r"foo\xa5bar()foo\xa5bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b8'
echo -ne 'r"foo\xa5bar()foo\xa5bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b16'
echo -ne 'r"foo\xa5bar()foo\xa5bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b32'
echo -ne 'r"foo\xa5bar()foo\xa5bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa5bar()foo\xa5bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b1'
echo -ne 'r"foo\xa6bar()foo\xa6bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b2'
echo -ne 'r"foo\xa6bar()foo\xa6bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b4'
echo -ne 'r"foo\xa6bar()foo\xa6bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b8'
echo -ne 'r"foo\xa6bar()foo\xa6bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b16'
echo -ne 'r"foo\xa6bar()foo\xa6bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b32'
echo -ne 'r"foo\xa6bar()foo\xa6bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa6bar()foo\xa6bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b1'
echo -ne 'r"foo\xa7bar()foo\xa7bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b2'
echo -ne 'r"foo\xa7bar()foo\xa7bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b4'
echo -ne 'r"foo\xa7bar()foo\xa7bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b8'
echo -ne 'r"foo\xa7bar()foo\xa7bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b16'
echo -ne 'r"foo\xa7bar()foo\xa7bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b32'
echo -ne 'r"foo\xa7bar()foo\xa7bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa7bar()foo\xa7bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b1'
echo -ne 'r"foo\xa8bar()foo\xa8bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b2'
echo -ne 'r"foo\xa8bar()foo\xa8bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b4'
echo -ne 'r"foo\xa8bar()foo\xa8bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b8'
echo -ne 'r"foo\xa8bar()foo\xa8bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b16'
echo -ne 'r"foo\xa8bar()foo\xa8bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b32'
echo -ne 'r"foo\xa8bar()foo\xa8bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa8bar()foo\xa8bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b1'
echo -ne 'r"foo\xa9bar()foo\xa9bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b2'
echo -ne 'r"foo\xa9bar()foo\xa9bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b4'
echo -ne 'r"foo\xa9bar()foo\xa9bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b8'
echo -ne 'r"foo\xa9bar()foo\xa9bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b16'
echo -ne 'r"foo\xa9bar()foo\xa9bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b32'
echo -ne 'r"foo\xa9bar()foo\xa9bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xa9bar()foo\xa9bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b1'
echo -ne 'r"foo\xaabar()foo\xaabar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b2'
echo -ne 'r"foo\xaabar()foo\xaabar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b4'
echo -ne 'r"foo\xaabar()foo\xaabar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b8'
echo -ne 'r"foo\xaabar()foo\xaabar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b16'
echo -ne 'r"foo\xaabar()foo\xaabar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b32'
echo -ne 'r"foo\xaabar()foo\xaabar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaabar()foo\xaabar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b1'
echo -ne 'r"foo\xabbar()foo\xabbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b2'
echo -ne 'r"foo\xabbar()foo\xabbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b4'
echo -ne 'r"foo\xabbar()foo\xabbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b8'
echo -ne 'r"foo\xabbar()foo\xabbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b16'
echo -ne 'r"foo\xabbar()foo\xabbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b32'
echo -ne 'r"foo\xabbar()foo\xabbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xabbar()foo\xabbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b1'
echo -ne 'r"foo\xacbar()foo\xacbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b2'
echo -ne 'r"foo\xacbar()foo\xacbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b4'
echo -ne 'r"foo\xacbar()foo\xacbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b8'
echo -ne 'r"foo\xacbar()foo\xacbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b16'
echo -ne 'r"foo\xacbar()foo\xacbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b32'
echo -ne 'r"foo\xacbar()foo\xacbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xacbar()foo\xacbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b1'
echo -ne 'r"foo\xadbar()foo\xadbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b2'
echo -ne 'r"foo\xadbar()foo\xadbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b4'
echo -ne 'r"foo\xadbar()foo\xadbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b8'
echo -ne 'r"foo\xadbar()foo\xadbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b16'
echo -ne 'r"foo\xadbar()foo\xadbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b32'
echo -ne 'r"foo\xadbar()foo\xadbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xadbar()foo\xadbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b1'
echo -ne 'r"foo\xaebar()foo\xaebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b2'
echo -ne 'r"foo\xaebar()foo\xaebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b4'
echo -ne 'r"foo\xaebar()foo\xaebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b8'
echo -ne 'r"foo\xaebar()foo\xaebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b16'
echo -ne 'r"foo\xaebar()foo\xaebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b32'
echo -ne 'r"foo\xaebar()foo\xaebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xaebar()foo\xaebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b1'
echo -ne 'r"foo\xafbar()foo\xafbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b2'
echo -ne 'r"foo\xafbar()foo\xafbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b4'
echo -ne 'r"foo\xafbar()foo\xafbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b8'
echo -ne 'r"foo\xafbar()foo\xafbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b16'
echo -ne 'r"foo\xafbar()foo\xafbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b32'
echo -ne 'r"foo\xafbar()foo\xafbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xafbar()foo\xafbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b1'
echo -ne 'r"foo\xb0bar()foo\xb0bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b2'
echo -ne 'r"foo\xb0bar()foo\xb0bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b4'
echo -ne 'r"foo\xb0bar()foo\xb0bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b8'
echo -ne 'r"foo\xb0bar()foo\xb0bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b16'
echo -ne 'r"foo\xb0bar()foo\xb0bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b32'
echo -ne 'r"foo\xb0bar()foo\xb0bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb0bar()foo\xb0bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b1'
echo -ne 'r"foo\xb1bar()foo\xb1bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b2'
echo -ne 'r"foo\xb1bar()foo\xb1bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b4'
echo -ne 'r"foo\xb1bar()foo\xb1bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b8'
echo -ne 'r"foo\xb1bar()foo\xb1bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b16'
echo -ne 'r"foo\xb1bar()foo\xb1bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b32'
echo -ne 'r"foo\xb1bar()foo\xb1bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb1bar()foo\xb1bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b1'
echo -ne 'r"foo\xb2bar()foo\xb2bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b2'
echo -ne 'r"foo\xb2bar()foo\xb2bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b4'
echo -ne 'r"foo\xb2bar()foo\xb2bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b8'
echo -ne 'r"foo\xb2bar()foo\xb2bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b16'
echo -ne 'r"foo\xb2bar()foo\xb2bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b32'
echo -ne 'r"foo\xb2bar()foo\xb2bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb2bar()foo\xb2bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b1'
echo -ne 'r"foo\xb3bar()foo\xb3bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b2'
echo -ne 'r"foo\xb3bar()foo\xb3bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b4'
echo -ne 'r"foo\xb3bar()foo\xb3bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b8'
echo -ne 'r"foo\xb3bar()foo\xb3bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b16'
echo -ne 'r"foo\xb3bar()foo\xb3bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b32'
echo -ne 'r"foo\xb3bar()foo\xb3bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb3bar()foo\xb3bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b1'
echo -ne 'r"foo\xb4bar()foo\xb4bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b2'
echo -ne 'r"foo\xb4bar()foo\xb4bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b4'
echo -ne 'r"foo\xb4bar()foo\xb4bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b8'
echo -ne 'r"foo\xb4bar()foo\xb4bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b16'
echo -ne 'r"foo\xb4bar()foo\xb4bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b32'
echo -ne 'r"foo\xb4bar()foo\xb4bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb4bar()foo\xb4bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b1'
echo -ne 'r"foo\xb5bar()foo\xb5bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b2'
echo -ne 'r"foo\xb5bar()foo\xb5bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b4'
echo -ne 'r"foo\xb5bar()foo\xb5bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b8'
echo -ne 'r"foo\xb5bar()foo\xb5bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b16'
echo -ne 'r"foo\xb5bar()foo\xb5bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b32'
echo -ne 'r"foo\xb5bar()foo\xb5bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb5bar()foo\xb5bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b1'
echo -ne 'r"foo\xb6bar()foo\xb6bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b2'
echo -ne 'r"foo\xb6bar()foo\xb6bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b4'
echo -ne 'r"foo\xb6bar()foo\xb6bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b8'
echo -ne 'r"foo\xb6bar()foo\xb6bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b16'
echo -ne 'r"foo\xb6bar()foo\xb6bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b32'
echo -ne 'r"foo\xb6bar()foo\xb6bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb6bar()foo\xb6bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b1'
echo -ne 'r"foo\xb7bar()foo\xb7bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b2'
echo -ne 'r"foo\xb7bar()foo\xb7bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b4'
echo -ne 'r"foo\xb7bar()foo\xb7bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b8'
echo -ne 'r"foo\xb7bar()foo\xb7bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b16'
echo -ne 'r"foo\xb7bar()foo\xb7bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b32'
echo -ne 'r"foo\xb7bar()foo\xb7bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb7bar()foo\xb7bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b1'
echo -ne 'r"foo\xb8bar()foo\xb8bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b2'
echo -ne 'r"foo\xb8bar()foo\xb8bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b4'
echo -ne 'r"foo\xb8bar()foo\xb8bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b8'
echo -ne 'r"foo\xb8bar()foo\xb8bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b16'
echo -ne 'r"foo\xb8bar()foo\xb8bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b32'
echo -ne 'r"foo\xb8bar()foo\xb8bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb8bar()foo\xb8bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b1'
echo -ne 'r"foo\xb9bar()foo\xb9bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b2'
echo -ne 'r"foo\xb9bar()foo\xb9bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b4'
echo -ne 'r"foo\xb9bar()foo\xb9bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b8'
echo -ne 'r"foo\xb9bar()foo\xb9bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b16'
echo -ne 'r"foo\xb9bar()foo\xb9bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b32'
echo -ne 'r"foo\xb9bar()foo\xb9bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xb9bar()foo\xb9bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b1'
echo -ne 'r"foo\xbabar()foo\xbabar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b2'
echo -ne 'r"foo\xbabar()foo\xbabar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b4'
echo -ne 'r"foo\xbabar()foo\xbabar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b8'
echo -ne 'r"foo\xbabar()foo\xbabar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b16'
echo -ne 'r"foo\xbabar()foo\xbabar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b32'
echo -ne 'r"foo\xbabar()foo\xbabar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbabar()foo\xbabar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b1'
echo -ne 'r"foo\xbbbar()foo\xbbbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b2'
echo -ne 'r"foo\xbbbar()foo\xbbbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b4'
echo -ne 'r"foo\xbbbar()foo\xbbbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b8'
echo -ne 'r"foo\xbbbar()foo\xbbbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b16'
echo -ne 'r"foo\xbbbar()foo\xbbbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b32'
echo -ne 'r"foo\xbbbar()foo\xbbbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbbbar()foo\xbbbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b1'
echo -ne 'r"foo\xbcbar()foo\xbcbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b2'
echo -ne 'r"foo\xbcbar()foo\xbcbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b4'
echo -ne 'r"foo\xbcbar()foo\xbcbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b8'
echo -ne 'r"foo\xbcbar()foo\xbcbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b16'
echo -ne 'r"foo\xbcbar()foo\xbcbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b32'
echo -ne 'r"foo\xbcbar()foo\xbcbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbcbar()foo\xbcbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b1'
echo -ne 'r"foo\xbdbar()foo\xbdbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b2'
echo -ne 'r"foo\xbdbar()foo\xbdbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b4'
echo -ne 'r"foo\xbdbar()foo\xbdbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b8'
echo -ne 'r"foo\xbdbar()foo\xbdbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b16'
echo -ne 'r"foo\xbdbar()foo\xbdbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b32'
echo -ne 'r"foo\xbdbar()foo\xbdbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbdbar()foo\xbdbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b1'
echo -ne 'r"foo\xbebar()foo\xbebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b2'
echo -ne 'r"foo\xbebar()foo\xbebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b4'
echo -ne 'r"foo\xbebar()foo\xbebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b8'
echo -ne 'r"foo\xbebar()foo\xbebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b16'
echo -ne 'r"foo\xbebar()foo\xbebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b32'
echo -ne 'r"foo\xbebar()foo\xbebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbebar()foo\xbebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b1'
echo -ne 'r"foo\xbfbar()foo\xbfbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b2'
echo -ne 'r"foo\xbfbar()foo\xbfbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b4'
echo -ne 'r"foo\xbfbar()foo\xbfbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b8'
echo -ne 'r"foo\xbfbar()foo\xbfbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b16'
echo -ne 'r"foo\xbfbar()foo\xbfbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b32'
echo -ne 'r"foo\xbfbar()foo\xbfbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xbfbar()foo\xbfbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b1'
echo -ne 'r"foo\xc0bar()foo\xc0bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b2'
echo -ne 'r"foo\xc0bar()foo\xc0bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b4'
echo -ne 'r"foo\xc0bar()foo\xc0bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b8'
echo -ne 'r"foo\xc0bar()foo\xc0bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b16'
echo -ne 'r"foo\xc0bar()foo\xc0bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b32'
echo -ne 'r"foo\xc0bar()foo\xc0bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc0bar()foo\xc0bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b1'
echo -ne 'r"foo\xc1bar()foo\xc1bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b2'
echo -ne 'r"foo\xc1bar()foo\xc1bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b4'
echo -ne 'r"foo\xc1bar()foo\xc1bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b8'
echo -ne 'r"foo\xc1bar()foo\xc1bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b16'
echo -ne 'r"foo\xc1bar()foo\xc1bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b32'
echo -ne 'r"foo\xc1bar()foo\xc1bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc1bar()foo\xc1bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b1'
echo -ne 'r"foo\xc2bar()foo\xc2bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b2'
echo -ne 'r"foo\xc2bar()foo\xc2bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b4'
echo -ne 'r"foo\xc2bar()foo\xc2bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b8'
echo -ne 'r"foo\xc2bar()foo\xc2bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b16'
echo -ne 'r"foo\xc2bar()foo\xc2bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b32'
echo -ne 'r"foo\xc2bar()foo\xc2bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc2bar()foo\xc2bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b1'
echo -ne 'r"foo\xc3bar()foo\xc3bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b2'
echo -ne 'r"foo\xc3bar()foo\xc3bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b4'
echo -ne 'r"foo\xc3bar()foo\xc3bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b8'
echo -ne 'r"foo\xc3bar()foo\xc3bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b16'
echo -ne 'r"foo\xc3bar()foo\xc3bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b32'
echo -ne 'r"foo\xc3bar()foo\xc3bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc3bar()foo\xc3bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b1'
echo -ne 'r"foo\xc4bar()foo\xc4bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b2'
echo -ne 'r"foo\xc4bar()foo\xc4bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b4'
echo -ne 'r"foo\xc4bar()foo\xc4bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b8'
echo -ne 'r"foo\xc4bar()foo\xc4bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b16'
echo -ne 'r"foo\xc4bar()foo\xc4bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b32'
echo -ne 'r"foo\xc4bar()foo\xc4bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc4bar()foo\xc4bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b1'
echo -ne 'r"foo\xc5bar()foo\xc5bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b2'
echo -ne 'r"foo\xc5bar()foo\xc5bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b4'
echo -ne 'r"foo\xc5bar()foo\xc5bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b8'
echo -ne 'r"foo\xc5bar()foo\xc5bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b16'
echo -ne 'r"foo\xc5bar()foo\xc5bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b32'
echo -ne 'r"foo\xc5bar()foo\xc5bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc5bar()foo\xc5bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b1'
echo -ne 'r"foo\xc6bar()foo\xc6bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b2'
echo -ne 'r"foo\xc6bar()foo\xc6bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b4'
echo -ne 'r"foo\xc6bar()foo\xc6bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b8'
echo -ne 'r"foo\xc6bar()foo\xc6bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b16'
echo -ne 'r"foo\xc6bar()foo\xc6bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b32'
echo -ne 'r"foo\xc6bar()foo\xc6bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc6bar()foo\xc6bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b1'
echo -ne 'r"foo\xc7bar()foo\xc7bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b2'
echo -ne 'r"foo\xc7bar()foo\xc7bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b4'
echo -ne 'r"foo\xc7bar()foo\xc7bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b8'
echo -ne 'r"foo\xc7bar()foo\xc7bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b16'
echo -ne 'r"foo\xc7bar()foo\xc7bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b32'
echo -ne 'r"foo\xc7bar()foo\xc7bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc7bar()foo\xc7bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b1'
echo -ne 'r"foo\xc8bar()foo\xc8bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b2'
echo -ne 'r"foo\xc8bar()foo\xc8bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b4'
echo -ne 'r"foo\xc8bar()foo\xc8bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b8'
echo -ne 'r"foo\xc8bar()foo\xc8bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b16'
echo -ne 'r"foo\xc8bar()foo\xc8bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b32'
echo -ne 'r"foo\xc8bar()foo\xc8bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc8bar()foo\xc8bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b1'
echo -ne 'r"foo\xc9bar()foo\xc9bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b2'
echo -ne 'r"foo\xc9bar()foo\xc9bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b4'
echo -ne 'r"foo\xc9bar()foo\xc9bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b8'
echo -ne 'r"foo\xc9bar()foo\xc9bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b16'
echo -ne 'r"foo\xc9bar()foo\xc9bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b32'
echo -ne 'r"foo\xc9bar()foo\xc9bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xc9bar()foo\xc9bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b1'
echo -ne 'r"foo\xcabar()foo\xcabar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b2'
echo -ne 'r"foo\xcabar()foo\xcabar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b4'
echo -ne 'r"foo\xcabar()foo\xcabar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b8'
echo -ne 'r"foo\xcabar()foo\xcabar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b16'
echo -ne 'r"foo\xcabar()foo\xcabar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b32'
echo -ne 'r"foo\xcabar()foo\xcabar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcabar()foo\xcabar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b1'
echo -ne 'r"foo\xcbbar()foo\xcbbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b2'
echo -ne 'r"foo\xcbbar()foo\xcbbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b4'
echo -ne 'r"foo\xcbbar()foo\xcbbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b8'
echo -ne 'r"foo\xcbbar()foo\xcbbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b16'
echo -ne 'r"foo\xcbbar()foo\xcbbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b32'
echo -ne 'r"foo\xcbbar()foo\xcbbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcbbar()foo\xcbbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b1'
echo -ne 'r"foo\xccbar()foo\xccbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b2'
echo -ne 'r"foo\xccbar()foo\xccbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b4'
echo -ne 'r"foo\xccbar()foo\xccbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b8'
echo -ne 'r"foo\xccbar()foo\xccbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b16'
echo -ne 'r"foo\xccbar()foo\xccbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b32'
echo -ne 'r"foo\xccbar()foo\xccbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xccbar()foo\xccbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b1'
echo -ne 'r"foo\xcdbar()foo\xcdbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b2'
echo -ne 'r"foo\xcdbar()foo\xcdbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b4'
echo -ne 'r"foo\xcdbar()foo\xcdbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b8'
echo -ne 'r"foo\xcdbar()foo\xcdbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b16'
echo -ne 'r"foo\xcdbar()foo\xcdbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b32'
echo -ne 'r"foo\xcdbar()foo\xcdbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcdbar()foo\xcdbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b1'
echo -ne 'r"foo\xcebar()foo\xcebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b2'
echo -ne 'r"foo\xcebar()foo\xcebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b4'
echo -ne 'r"foo\xcebar()foo\xcebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b8'
echo -ne 'r"foo\xcebar()foo\xcebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b16'
echo -ne 'r"foo\xcebar()foo\xcebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b32'
echo -ne 'r"foo\xcebar()foo\xcebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcebar()foo\xcebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b1'
echo -ne 'r"foo\xcfbar()foo\xcfbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b2'
echo -ne 'r"foo\xcfbar()foo\xcfbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b4'
echo -ne 'r"foo\xcfbar()foo\xcfbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b8'
echo -ne 'r"foo\xcfbar()foo\xcfbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b16'
echo -ne 'r"foo\xcfbar()foo\xcfbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b32'
echo -ne 'r"foo\xcfbar()foo\xcfbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xcfbar()foo\xcfbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b1'
echo -ne 'r"foo\xd0bar()foo\xd0bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b2'
echo -ne 'r"foo\xd0bar()foo\xd0bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b4'
echo -ne 'r"foo\xd0bar()foo\xd0bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b8'
echo -ne 'r"foo\xd0bar()foo\xd0bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b16'
echo -ne 'r"foo\xd0bar()foo\xd0bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b32'
echo -ne 'r"foo\xd0bar()foo\xd0bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd0bar()foo\xd0bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b1'
echo -ne 'r"foo\xd1bar()foo\xd1bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b2'
echo -ne 'r"foo\xd1bar()foo\xd1bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b4'
echo -ne 'r"foo\xd1bar()foo\xd1bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b8'
echo -ne 'r"foo\xd1bar()foo\xd1bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b16'
echo -ne 'r"foo\xd1bar()foo\xd1bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b32'
echo -ne 'r"foo\xd1bar()foo\xd1bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd1bar()foo\xd1bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b1'
echo -ne 'r"foo\xd2bar()foo\xd2bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b2'
echo -ne 'r"foo\xd2bar()foo\xd2bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b4'
echo -ne 'r"foo\xd2bar()foo\xd2bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b8'
echo -ne 'r"foo\xd2bar()foo\xd2bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b16'
echo -ne 'r"foo\xd2bar()foo\xd2bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b32'
echo -ne 'r"foo\xd2bar()foo\xd2bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd2bar()foo\xd2bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b1'
echo -ne 'r"foo\xd3bar()foo\xd3bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b2'
echo -ne 'r"foo\xd3bar()foo\xd3bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b4'
echo -ne 'r"foo\xd3bar()foo\xd3bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b8'
echo -ne 'r"foo\xd3bar()foo\xd3bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b16'
echo -ne 'r"foo\xd3bar()foo\xd3bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b32'
echo -ne 'r"foo\xd3bar()foo\xd3bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd3bar()foo\xd3bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b1'
echo -ne 'r"foo\xd4bar()foo\xd4bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b2'
echo -ne 'r"foo\xd4bar()foo\xd4bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b4'
echo -ne 'r"foo\xd4bar()foo\xd4bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b8'
echo -ne 'r"foo\xd4bar()foo\xd4bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b16'
echo -ne 'r"foo\xd4bar()foo\xd4bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b32'
echo -ne 'r"foo\xd4bar()foo\xd4bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd4bar()foo\xd4bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b1'
echo -ne 'r"foo\xd5bar()foo\xd5bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b2'
echo -ne 'r"foo\xd5bar()foo\xd5bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b4'
echo -ne 'r"foo\xd5bar()foo\xd5bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b8'
echo -ne 'r"foo\xd5bar()foo\xd5bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b16'
echo -ne 'r"foo\xd5bar()foo\xd5bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b32'
echo -ne 'r"foo\xd5bar()foo\xd5bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd5bar()foo\xd5bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b1'
echo -ne 'r"foo\xd6bar()foo\xd6bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b2'
echo -ne 'r"foo\xd6bar()foo\xd6bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b4'
echo -ne 'r"foo\xd6bar()foo\xd6bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b8'
echo -ne 'r"foo\xd6bar()foo\xd6bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b16'
echo -ne 'r"foo\xd6bar()foo\xd6bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b32'
echo -ne 'r"foo\xd6bar()foo\xd6bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd6bar()foo\xd6bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b1'
echo -ne 'r"foo\xd7bar()foo\xd7bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b2'
echo -ne 'r"foo\xd7bar()foo\xd7bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b4'
echo -ne 'r"foo\xd7bar()foo\xd7bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b8'
echo -ne 'r"foo\xd7bar()foo\xd7bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b16'
echo -ne 'r"foo\xd7bar()foo\xd7bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b32'
echo -ne 'r"foo\xd7bar()foo\xd7bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd7bar()foo\xd7bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b1'
echo -ne 'r"foo\xd8bar()foo\xd8bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b2'
echo -ne 'r"foo\xd8bar()foo\xd8bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b4'
echo -ne 'r"foo\xd8bar()foo\xd8bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b8'
echo -ne 'r"foo\xd8bar()foo\xd8bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b16'
echo -ne 'r"foo\xd8bar()foo\xd8bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b32'
echo -ne 'r"foo\xd8bar()foo\xd8bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd8bar()foo\xd8bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b1'
echo -ne 'r"foo\xd9bar()foo\xd9bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b2'
echo -ne 'r"foo\xd9bar()foo\xd9bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b4'
echo -ne 'r"foo\xd9bar()foo\xd9bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b8'
echo -ne 'r"foo\xd9bar()foo\xd9bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b16'
echo -ne 'r"foo\xd9bar()foo\xd9bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b32'
echo -ne 'r"foo\xd9bar()foo\xd9bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xd9bar()foo\xd9bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b1'
echo -ne 'r"foo\xdabar()foo\xdabar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b2'
echo -ne 'r"foo\xdabar()foo\xdabar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b4'
echo -ne 'r"foo\xdabar()foo\xdabar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b8'
echo -ne 'r"foo\xdabar()foo\xdabar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b16'
echo -ne 'r"foo\xdabar()foo\xdabar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b32'
echo -ne 'r"foo\xdabar()foo\xdabar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdabar()foo\xdabar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b1'
echo -ne 'r"foo\xdbbar()foo\xdbbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b2'
echo -ne 'r"foo\xdbbar()foo\xdbbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b4'
echo -ne 'r"foo\xdbbar()foo\xdbbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b8'
echo -ne 'r"foo\xdbbar()foo\xdbbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b16'
echo -ne 'r"foo\xdbbar()foo\xdbbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b32'
echo -ne 'r"foo\xdbbar()foo\xdbbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdbbar()foo\xdbbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b1'
echo -ne 'r"foo\xdcbar()foo\xdcbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b2'
echo -ne 'r"foo\xdcbar()foo\xdcbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b4'
echo -ne 'r"foo\xdcbar()foo\xdcbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b8'
echo -ne 'r"foo\xdcbar()foo\xdcbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b16'
echo -ne 'r"foo\xdcbar()foo\xdcbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b32'
echo -ne 'r"foo\xdcbar()foo\xdcbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdcbar()foo\xdcbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b1'
echo -ne 'r"foo\xddbar()foo\xddbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b2'
echo -ne 'r"foo\xddbar()foo\xddbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b4'
echo -ne 'r"foo\xddbar()foo\xddbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b8'
echo -ne 'r"foo\xddbar()foo\xddbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b16'
echo -ne 'r"foo\xddbar()foo\xddbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b32'
echo -ne 'r"foo\xddbar()foo\xddbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xddbar()foo\xddbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b1'
echo -ne 'r"foo\xdebar()foo\xdebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b2'
echo -ne 'r"foo\xdebar()foo\xdebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b4'
echo -ne 'r"foo\xdebar()foo\xdebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b8'
echo -ne 'r"foo\xdebar()foo\xdebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b16'
echo -ne 'r"foo\xdebar()foo\xdebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b32'
echo -ne 'r"foo\xdebar()foo\xdebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdebar()foo\xdebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b1'
echo -ne 'r"foo\xdfbar()foo\xdfbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b2'
echo -ne 'r"foo\xdfbar()foo\xdfbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b4'
echo -ne 'r"foo\xdfbar()foo\xdfbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b8'
echo -ne 'r"foo\xdfbar()foo\xdfbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b16'
echo -ne 'r"foo\xdfbar()foo\xdfbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b32'
echo -ne 'r"foo\xdfbar()foo\xdfbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xdfbar()foo\xdfbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b1'
echo -ne 'r"foo\xe0bar()foo\xe0bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b2'
echo -ne 'r"foo\xe0bar()foo\xe0bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b4'
echo -ne 'r"foo\xe0bar()foo\xe0bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b8'
echo -ne 'r"foo\xe0bar()foo\xe0bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b16'
echo -ne 'r"foo\xe0bar()foo\xe0bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b32'
echo -ne 'r"foo\xe0bar()foo\xe0bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe0bar()foo\xe0bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b1'
echo -ne 'r"foo\xe1bar()foo\xe1bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b2'
echo -ne 'r"foo\xe1bar()foo\xe1bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b4'
echo -ne 'r"foo\xe1bar()foo\xe1bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b8'
echo -ne 'r"foo\xe1bar()foo\xe1bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b16'
echo -ne 'r"foo\xe1bar()foo\xe1bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b32'
echo -ne 'r"foo\xe1bar()foo\xe1bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe1bar()foo\xe1bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b1'
echo -ne 'r"foo\xe2bar()foo\xe2bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b2'
echo -ne 'r"foo\xe2bar()foo\xe2bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b4'
echo -ne 'r"foo\xe2bar()foo\xe2bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b8'
echo -ne 'r"foo\xe2bar()foo\xe2bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b16'
echo -ne 'r"foo\xe2bar()foo\xe2bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b32'
echo -ne 'r"foo\xe2bar()foo\xe2bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe2bar()foo\xe2bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b1'
echo -ne 'r"foo\xe3bar()foo\xe3bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b2'
echo -ne 'r"foo\xe3bar()foo\xe3bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b4'
echo -ne 'r"foo\xe3bar()foo\xe3bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b8'
echo -ne 'r"foo\xe3bar()foo\xe3bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b16'
echo -ne 'r"foo\xe3bar()foo\xe3bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b32'
echo -ne 'r"foo\xe3bar()foo\xe3bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe3bar()foo\xe3bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b1'
echo -ne 'r"foo\xe4bar()foo\xe4bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b2'
echo -ne 'r"foo\xe4bar()foo\xe4bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b4'
echo -ne 'r"foo\xe4bar()foo\xe4bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b8'
echo -ne 'r"foo\xe4bar()foo\xe4bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b16'
echo -ne 'r"foo\xe4bar()foo\xe4bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b32'
echo -ne 'r"foo\xe4bar()foo\xe4bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe4bar()foo\xe4bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b1'
echo -ne 'r"foo\xe5bar()foo\xe5bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b2'
echo -ne 'r"foo\xe5bar()foo\xe5bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b4'
echo -ne 'r"foo\xe5bar()foo\xe5bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b8'
echo -ne 'r"foo\xe5bar()foo\xe5bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b16'
echo -ne 'r"foo\xe5bar()foo\xe5bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b32'
echo -ne 'r"foo\xe5bar()foo\xe5bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe5bar()foo\xe5bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b1'
echo -ne 'r"foo\xe6bar()foo\xe6bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b2'
echo -ne 'r"foo\xe6bar()foo\xe6bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b4'
echo -ne 'r"foo\xe6bar()foo\xe6bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b8'
echo -ne 'r"foo\xe6bar()foo\xe6bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b16'
echo -ne 'r"foo\xe6bar()foo\xe6bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b32'
echo -ne 'r"foo\xe6bar()foo\xe6bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe6bar()foo\xe6bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b1'
echo -ne 'r"foo\xe7bar()foo\xe7bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b2'
echo -ne 'r"foo\xe7bar()foo\xe7bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b4'
echo -ne 'r"foo\xe7bar()foo\xe7bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b8'
echo -ne 'r"foo\xe7bar()foo\xe7bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b16'
echo -ne 'r"foo\xe7bar()foo\xe7bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b32'
echo -ne 'r"foo\xe7bar()foo\xe7bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe7bar()foo\xe7bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b1'
echo -ne 'r"foo\xe8bar()foo\xe8bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b2'
echo -ne 'r"foo\xe8bar()foo\xe8bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b4'
echo -ne 'r"foo\xe8bar()foo\xe8bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b8'
echo -ne 'r"foo\xe8bar()foo\xe8bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b16'
echo -ne 'r"foo\xe8bar()foo\xe8bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b32'
echo -ne 'r"foo\xe8bar()foo\xe8bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe8bar()foo\xe8bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b1'
echo -ne 'r"foo\xe9bar()foo\xe9bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b2'
echo -ne 'r"foo\xe9bar()foo\xe9bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b4'
echo -ne 'r"foo\xe9bar()foo\xe9bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b8'
echo -ne 'r"foo\xe9bar()foo\xe9bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b16'
echo -ne 'r"foo\xe9bar()foo\xe9bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b32'
echo -ne 'r"foo\xe9bar()foo\xe9bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xe9bar()foo\xe9bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b1'
echo -ne 'r"foo\xeabar()foo\xeabar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b2'
echo -ne 'r"foo\xeabar()foo\xeabar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b4'
echo -ne 'r"foo\xeabar()foo\xeabar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b8'
echo -ne 'r"foo\xeabar()foo\xeabar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b16'
echo -ne 'r"foo\xeabar()foo\xeabar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b32'
echo -ne 'r"foo\xeabar()foo\xeabar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeabar()foo\xeabar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b1'
echo -ne 'r"foo\xebbar()foo\xebbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b2'
echo -ne 'r"foo\xebbar()foo\xebbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b4'
echo -ne 'r"foo\xebbar()foo\xebbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b8'
echo -ne 'r"foo\xebbar()foo\xebbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b16'
echo -ne 'r"foo\xebbar()foo\xebbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b32'
echo -ne 'r"foo\xebbar()foo\xebbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xebbar()foo\xebbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b1'
echo -ne 'r"foo\xecbar()foo\xecbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b2'
echo -ne 'r"foo\xecbar()foo\xecbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b4'
echo -ne 'r"foo\xecbar()foo\xecbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b8'
echo -ne 'r"foo\xecbar()foo\xecbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b16'
echo -ne 'r"foo\xecbar()foo\xecbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b32'
echo -ne 'r"foo\xecbar()foo\xecbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xecbar()foo\xecbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b1'
echo -ne 'r"foo\xedbar()foo\xedbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b2'
echo -ne 'r"foo\xedbar()foo\xedbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b4'
echo -ne 'r"foo\xedbar()foo\xedbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b8'
echo -ne 'r"foo\xedbar()foo\xedbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b16'
echo -ne 'r"foo\xedbar()foo\xedbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b32'
echo -ne 'r"foo\xedbar()foo\xedbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xedbar()foo\xedbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b1'
echo -ne 'r"foo\xeebar()foo\xeebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b2'
echo -ne 'r"foo\xeebar()foo\xeebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b4'
echo -ne 'r"foo\xeebar()foo\xeebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b8'
echo -ne 'r"foo\xeebar()foo\xeebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b16'
echo -ne 'r"foo\xeebar()foo\xeebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b32'
echo -ne 'r"foo\xeebar()foo\xeebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xeebar()foo\xeebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b1'
echo -ne 'r"foo\xefbar()foo\xefbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b2'
echo -ne 'r"foo\xefbar()foo\xefbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b4'
echo -ne 'r"foo\xefbar()foo\xefbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b8'
echo -ne 'r"foo\xefbar()foo\xefbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b16'
echo -ne 'r"foo\xefbar()foo\xefbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b32'
echo -ne 'r"foo\xefbar()foo\xefbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xefbar()foo\xefbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b1'
echo -ne 'r"foo\xf0bar()foo\xf0bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b2'
echo -ne 'r"foo\xf0bar()foo\xf0bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b4'
echo -ne 'r"foo\xf0bar()foo\xf0bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b8'
echo -ne 'r"foo\xf0bar()foo\xf0bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b16'
echo -ne 'r"foo\xf0bar()foo\xf0bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b32'
echo -ne 'r"foo\xf0bar()foo\xf0bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf0bar()foo\xf0bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b1'
echo -ne 'r"foo\xf1bar()foo\xf1bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b2'
echo -ne 'r"foo\xf1bar()foo\xf1bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b4'
echo -ne 'r"foo\xf1bar()foo\xf1bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b8'
echo -ne 'r"foo\xf1bar()foo\xf1bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b16'
echo -ne 'r"foo\xf1bar()foo\xf1bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b32'
echo -ne 'r"foo\xf1bar()foo\xf1bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf1bar()foo\xf1bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b1'
echo -ne 'r"foo\xf2bar()foo\xf2bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b2'
echo -ne 'r"foo\xf2bar()foo\xf2bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b4'
echo -ne 'r"foo\xf2bar()foo\xf2bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b8'
echo -ne 'r"foo\xf2bar()foo\xf2bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b16'
echo -ne 'r"foo\xf2bar()foo\xf2bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b32'
echo -ne 'r"foo\xf2bar()foo\xf2bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf2bar()foo\xf2bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b1'
echo -ne 'r"foo\xf3bar()foo\xf3bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b2'
echo -ne 'r"foo\xf3bar()foo\xf3bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b4'
echo -ne 'r"foo\xf3bar()foo\xf3bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b8'
echo -ne 'r"foo\xf3bar()foo\xf3bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b16'
echo -ne 'r"foo\xf3bar()foo\xf3bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b32'
echo -ne 'r"foo\xf3bar()foo\xf3bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf3bar()foo\xf3bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b1'
echo -ne 'r"foo\xf4bar()foo\xf4bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b2'
echo -ne 'r"foo\xf4bar()foo\xf4bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b4'
echo -ne 'r"foo\xf4bar()foo\xf4bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b8'
echo -ne 'r"foo\xf4bar()foo\xf4bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b16'
echo -ne 'r"foo\xf4bar()foo\xf4bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b32'
echo -ne 'r"foo\xf4bar()foo\xf4bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf4bar()foo\xf4bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b1'
echo -ne 'r"foo\xf5bar()foo\xf5bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b2'
echo -ne 'r"foo\xf5bar()foo\xf5bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b4'
echo -ne 'r"foo\xf5bar()foo\xf5bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b8'
echo -ne 'r"foo\xf5bar()foo\xf5bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b16'
echo -ne 'r"foo\xf5bar()foo\xf5bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b32'
echo -ne 'r"foo\xf5bar()foo\xf5bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf5bar()foo\xf5bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b1'
echo -ne 'r"foo\xf6bar()foo\xf6bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b2'
echo -ne 'r"foo\xf6bar()foo\xf6bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b4'
echo -ne 'r"foo\xf6bar()foo\xf6bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b8'
echo -ne 'r"foo\xf6bar()foo\xf6bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b16'
echo -ne 'r"foo\xf6bar()foo\xf6bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b32'
echo -ne 'r"foo\xf6bar()foo\xf6bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf6bar()foo\xf6bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b1'
echo -ne 'r"foo\xf7bar()foo\xf7bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b2'
echo -ne 'r"foo\xf7bar()foo\xf7bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b4'
echo -ne 'r"foo\xf7bar()foo\xf7bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b8'
echo -ne 'r"foo\xf7bar()foo\xf7bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b16'
echo -ne 'r"foo\xf7bar()foo\xf7bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b32'
echo -ne 'r"foo\xf7bar()foo\xf7bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf7bar()foo\xf7bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b1'
echo -ne 'r"foo\xf8bar()foo\xf8bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b2'
echo -ne 'r"foo\xf8bar()foo\xf8bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b4'
echo -ne 'r"foo\xf8bar()foo\xf8bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b8'
echo -ne 'r"foo\xf8bar()foo\xf8bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b16'
echo -ne 'r"foo\xf8bar()foo\xf8bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b32'
echo -ne 'r"foo\xf8bar()foo\xf8bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf8bar()foo\xf8bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b1'
echo -ne 'r"foo\xf9bar()foo\xf9bar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b2'
echo -ne 'r"foo\xf9bar()foo\xf9bar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b4'
echo -ne 'r"foo\xf9bar()foo\xf9bar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b8'
echo -ne 'r"foo\xf9bar()foo\xf9bar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b16'
echo -ne 'r"foo\xf9bar()foo\xf9bar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b32'
echo -ne 'r"foo\xf9bar()foo\xf9bar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xf9bar()foo\xf9bar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b1'
echo -ne 'r"foo\xfabar()foo\xfabar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b2'
echo -ne 'r"foo\xfabar()foo\xfabar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b4'
echo -ne 'r"foo\xfabar()foo\xfabar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b8'
echo -ne 'r"foo\xfabar()foo\xfabar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b16'
echo -ne 'r"foo\xfabar()foo\xfabar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b32'
echo -ne 'r"foo\xfabar()foo\xfabar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfabar()foo\xfabar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b1'
echo -ne 'r"foo\xfbbar()foo\xfbbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b2'
echo -ne 'r"foo\xfbbar()foo\xfbbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b4'
echo -ne 'r"foo\xfbbar()foo\xfbbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b8'
echo -ne 'r"foo\xfbbar()foo\xfbbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b16'
echo -ne 'r"foo\xfbbar()foo\xfbbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b32'
echo -ne 'r"foo\xfbbar()foo\xfbbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfbbar()foo\xfbbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b1'
echo -ne 'r"foo\xfcbar()foo\xfcbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b2'
echo -ne 'r"foo\xfcbar()foo\xfcbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b4'
echo -ne 'r"foo\xfcbar()foo\xfcbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b8'
echo -ne 'r"foo\xfcbar()foo\xfcbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b16'
echo -ne 'r"foo\xfcbar()foo\xfcbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b32'
echo -ne 'r"foo\xfcbar()foo\xfcbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfcbar()foo\xfcbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b1'
echo -ne 'r"foo\xfdbar()foo\xfdbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b2'
echo -ne 'r"foo\xfdbar()foo\xfdbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b4'
echo -ne 'r"foo\xfdbar()foo\xfdbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b8'
echo -ne 'r"foo\xfdbar()foo\xfdbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b16'
echo -ne 'r"foo\xfdbar()foo\xfdbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b32'
echo -ne 'r"foo\xfdbar()foo\xfdbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfdbar()foo\xfdbar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b1'
echo -ne 'r"foo\xfebar()foo\xfebar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b2'
echo -ne 'r"foo\xfebar()foo\xfebar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b4'
echo -ne 'r"foo\xfebar()foo\xfebar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b8'
echo -ne 'r"foo\xfebar()foo\xfebar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b16'
echo -ne 'r"foo\xfebar()foo\xfebar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b32'
echo -ne 'r"foo\xfebar()foo\xfebar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xfebar()foo\xfebar"'\''|json -b32'

echo '$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b1'
echo -ne 'r"foo\xffbar()foo\xffbar"'|json -b1 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b1'

echo '$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b2'
echo -ne 'r"foo\xffbar()foo\xffbar"'|json -b2 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b2'

echo '$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b4'
echo -ne 'r"foo\xffbar()foo\xffbar"'|json -b4 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b4'

echo '$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b8'
echo -ne 'r"foo\xffbar()foo\xffbar"'|json -b8 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b8'

echo '$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b16'
echo -ne 'r"foo\xffbar()foo\xffbar"'|json -b16 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b16'

echo '$ echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b32'
echo -ne 'r"foo\xffbar()foo\xffbar"'|json -b32 2>&1 ||
echo 'command failed: echo -ne '\''r"foo\xffbar()foo\xffbar"'\''|json -b32'
)

