#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:ignore-opt
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L ignore-opt.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ json() { json0 "$@" <<< '\''"null"'\''; }
$ json -S -- ./foo.so
json: warning: ignoring the filter command line arguments since neither `-F|--filterlib-exec'\'' nor `-f|--filter-libs'\'' were given
\"null\"\n
$ json -Tp -- ./foo.so
json: warning: ignoring the filter command line arguments since neither `-F|--filterlib-exec'\'' nor `-f|--filter-libs'\'' were given
"null"
$ json -S -f -- ./foo.so
json: warning: ignoring the filter command line arguments since none of JSON parser, printer or flattener options were given
\"null\"\n
$ json -Tp -f -- ./foo.so
json: warning: ignoring the filter command line arguments since none of JSON parser, printer or flattener options were given
"null"'
) -L ignore-opt.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ json() { json0 "$@" <<< '\''"null"'\''; }'
json() { json0 "$@" <<< '"null"'; } 2>&1 ||
echo 'command failed: json() { json0 "$@" <<< '\''"null"'\''; }'

echo '$ json -S -- ./foo.so'
json -S -- ./foo.so 2>&1 ||
echo 'command failed: json -S -- ./foo.so'

echo '$ json -Tp -- ./foo.so'
json -Tp -- ./foo.so 2>&1 ||
echo 'command failed: json -Tp -- ./foo.so'

echo '$ json -S -f -- ./foo.so'
json -S -f -- ./foo.so 2>&1 ||
echo 'command failed: json -S -f -- ./foo.so'

echo '$ json -Tp -f -- ./foo.so'
json -Tp -f -- ./foo.so 2>&1 ||
echo 'command failed: json -Tp -f -- ./foo.so'
)

