#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:empty-groups
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L empty-groups.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ shopt -s expand_aliases
$ alias json='\''json0 -f'\''
$ json --
json: error: empty filter arguments group #1
command failed: json --
$ json -- --
json: error: empty filter arguments group #1
command failed: json -- --
$ json -- -- a
json: error: empty filter arguments group #1
command failed: json -- -- a
$ json -- -- a --
json: error: empty filter arguments group #1
command failed: json -- -- a --
$ json -- a --
json: error: empty filter arguments group #2
command failed: json -- a --
$ json -- a -- --
json: error: empty filter arguments group #2
command failed: json -- a -- --
$ json -- a -- -- b
json: error: empty filter arguments group #2
command failed: json -- a -- -- b
$ json -- a -- -- b --
json: error: empty filter arguments group #2
command failed: json -- a -- -- b --
$ json -- a -- b --
json: error: empty filter arguments group #3
command failed: json -- a -- b --
$ json -- a -- b -- --
json: error: empty filter arguments group #3
command failed: json -- a -- b -- --
$ json -- a -- b -- -- c
json: error: empty filter arguments group #3
command failed: json -- a -- b -- -- c
$ json -- a -- b -- -- c --
json: error: empty filter arguments group #3
command failed: json -- a -- b -- -- c --
$ json -- a -- b -- c --
json: error: empty filter arguments group #4
command failed: json -- a -- b -- c --
$ json -- a -- b -- c -- --
json: error: empty filter arguments group #4
command failed: json -- a -- b -- c -- --
$ json -- a -- b -- c -- -- d
json: error: empty filter arguments group #4
command failed: json -- a -- b -- c -- -- d
$ json -- a -- b -- c -- -- d --
json: error: empty filter arguments group #4
command failed: json -- a -- b -- c -- -- d --'
) -L empty-groups.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ alias json='\''json0 -f'\'''
alias json='json0 -f' 2>&1 ||
echo 'command failed: alias json='\''json0 -f'\'''

echo '$ json --'
json -- 2>&1 ||
echo 'command failed: json --'

echo '$ json -- --'
json -- -- 2>&1 ||
echo 'command failed: json -- --'

echo '$ json -- -- a'
json -- -- a 2>&1 ||
echo 'command failed: json -- -- a'

echo '$ json -- -- a --'
json -- -- a -- 2>&1 ||
echo 'command failed: json -- -- a --'

echo '$ json -- a --'
json -- a -- 2>&1 ||
echo 'command failed: json -- a --'

echo '$ json -- a -- --'
json -- a -- -- 2>&1 ||
echo 'command failed: json -- a -- --'

echo '$ json -- a -- -- b'
json -- a -- -- b 2>&1 ||
echo 'command failed: json -- a -- -- b'

echo '$ json -- a -- -- b --'
json -- a -- -- b -- 2>&1 ||
echo 'command failed: json -- a -- -- b --'

echo '$ json -- a -- b --'
json -- a -- b -- 2>&1 ||
echo 'command failed: json -- a -- b --'

echo '$ json -- a -- b -- --'
json -- a -- b -- -- 2>&1 ||
echo 'command failed: json -- a -- b -- --'

echo '$ json -- a -- b -- -- c'
json -- a -- b -- -- c 2>&1 ||
echo 'command failed: json -- a -- b -- -- c'

echo '$ json -- a -- b -- -- c --'
json -- a -- b -- -- c -- 2>&1 ||
echo 'command failed: json -- a -- b -- -- c --'

echo '$ json -- a -- b -- c --'
json -- a -- b -- c -- 2>&1 ||
echo 'command failed: json -- a -- b -- c --'

echo '$ json -- a -- b -- c -- --'
json -- a -- b -- c -- -- 2>&1 ||
echo 'command failed: json -- a -- b -- c -- --'

echo '$ json -- a -- b -- c -- -- d'
json -- a -- b -- c -- -- d 2>&1 ||
echo 'command failed: json -- a -- b -- c -- -- d'

echo '$ json -- a -- b -- c -- -- d --'
json -- a -- b -- c -- -- d -- 2>&1 ||
echo 'command failed: json -- a -- b -- c -- -- d --'
)

