#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:github-sobj-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L github-sobj-lib.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ norm() { sed -r '\''/^\/\/|^\s*$/d'\'' ${1:+"$1"}; }
$ libs/github/github.so|sed -r '\''1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/'\''
github.so: library version: x.y.z
$ diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.so|json -P)
$ json -Tv libs/github/github.so
$ json -Tc libs/github/github.so
$ diff -u -Ltext <(json -Td libs/github/github.json|norm) -Lsobj <(json -Td libs/github/github.so|norm)'
) -L github-sobj-lib.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ norm() { sed -r '\''/^\/\/|^\s*$/d'\'' ${1:+"$1"}; }'
norm() { sed -r '/^\/\/|^\s*$/d' ${1:+"$1"}; } 2>&1 ||
echo 'command failed: norm() { sed -r '\''/^\/\/|^\s*$/d'\'' ${1:+"$1"}; }'

echo '$ libs/github/github.so|sed -r '\''1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/'\'''
libs/github/github.so|sed -r '1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/' 2>&1 ||
echo 'command failed: libs/github/github.so|sed -r '\''1s/[0-9]+\.[0-9]+\.[0-9]+/x.y.z/'\'''

echo '$ diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.so|json -P)'
diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.so|json -P) 2>&1 ||
echo 'command failed: diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.so|json -P)'

echo '$ json -Tv libs/github/github.so'
json -Tv libs/github/github.so 2>&1 ||
echo 'command failed: json -Tv libs/github/github.so'

echo '$ json -Tc libs/github/github.so'
json -Tc libs/github/github.so 2>&1 ||
echo 'command failed: json -Tc libs/github/github.so'

echo '$ diff -u -Ltext <(json -Td libs/github/github.json|norm) -Lsobj <(json -Td libs/github/github.so|norm)'
diff -u -Ltext <(json -Td libs/github/github.json|norm) -Lsobj <(json -Td libs/github/github.so|norm) 2>&1 ||
echo 'command failed: diff -u -Ltext <(json -Td libs/github/github.json|norm) -Lsobj <(json -Td libs/github/github.so|norm)'
)

