#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def-gcc:node-closed-array-list-any2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-closed-array-list-any2.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__0,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__1,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};
$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_trie_node_t __2 = {
    .sym = NULL,
    .VAL = &__1
};
static const struct json_type_trie_node_t __3 = {
    .sym = &__1,
    .EQ = &__2
};
static const struct json_type_trie_node_t __4 = {
    .sym = NULL,
    .VAL = &__0
};
static const struct json_type_trie_node_t __5 = {
    .sym = &__0,
    .lo = &__3,
    .EQ = &__4
};
static const struct json_type_trie_t __6 = {
    .root = &__5
};
static const struct json_type_list_attr_t __7 = {
    .any = &__6
};
static const struct json_type_node_t* __8[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_list_node_type,
    .attr.list = &__7,
    .node.list = {
        .args = __8,
        .size = 2
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__9
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__10
};'
) -L node-closed-array-list-any2.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'1i\\\\\\#include "json-type.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee /dev/fd/2|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["type","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["null","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["number","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["string","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["object","array"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","type"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","null"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","number"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","string"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'''

echo '$ json <<< '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'''
json <<< '{"type":"array","args":{"type":"list","args":["array","object"]}}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'''
)

