#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-plain-basic-val-object-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-plain-basic-val-object-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
) -L list-object-plain-basic-val-object-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":null}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":false}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":true}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":123}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{"fuu":[]}'\'''
)

