#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:16
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 16.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type none
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null"]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null","boolean"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\'' or `"boolean"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null","boolean"]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null","boolean","number"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\'', `"boolean"'\'' or `"number"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null","boolean","number"]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null","boolean","number","string"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\'', `"boolean"'\'', `"number"'\'' or `"string"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null","boolean","number","string"]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null","boolean","number","string","object"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\'', `"boolean"'\'', `"number"'\'', `"string"'\'' or `"object"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null","boolean","number","string","object"]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null","boolean","number","string","object","array"]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["boolean","number","string","object","array"]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\'', `"number"'\'', `"string"'\'', `"object"'\'' or `"array"'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean","number","string","object","array"]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\'' or `{"type":"object",...}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[]},"object"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\'' or `"object"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[]},"object"]}'\'' <<< '\''[]'\'''
) -L 16.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null","boolean"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null","boolean"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null","boolean"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null","boolean","number"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null","boolean","number"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null","boolean","number"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null","boolean","number","string"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null","boolean","number","string"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null","boolean","number","string"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null","boolean","number","string","object"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null","boolean","number","string","object"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null","boolean","number","string","object"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null","boolean","number","string","object","array"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null","boolean","number","string","object","array"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null","boolean","number","string","object","array"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean","number","string","object","array"]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean","number","string","object","array"]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean","number","string","object","array"]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[]},"object"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[]},"object"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[]},"object"]}'\'' <<< '\''[]'\'''
)

