#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:object
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --terse "$@"; }
$ json <<< '\''{}'\''
{}
$ json <<< '\''{"":null}'\''
{"":null}
$ json <<< '\''{"":false}'\''
{"":false}
$ json <<< '\''{"":true}'\''
{"":true}
$ json <<< '\''{"":1}'\''
{"":1}
$ json <<< '\''{"":""}'\''
{"":""}
$ json <<< '\''{"":"foo"}'\''
{"":"foo"}
$ json <<< '\''{"":[]}'\''
{"":[]}
$ json <<< '\''{"":[null]}'\''
{"":[null]}
$ json <<< '\''{"":[false]}'\''
{"":[false]}
$ json <<< '\''{"":[true]}'\''
{"":[true]}
$ json <<< '\''{"":[1]}'\''
{"":[1]}
$ json <<< '\''{"":[""]}'\''
{"":[""]}
$ json <<< '\''{"":["foo"]}'\''
{"":["foo"]}
$ json <<< '\''{"foo":null}'\''
{"foo":null}
$ json <<< '\''{"foo":false}'\''
{"foo":false}
$ json <<< '\''{"foo":true}'\''
{"foo":true}
$ json <<< '\''{"foo":1}'\''
{"foo":1}
$ json <<< '\''{"foo":""}'\''
{"foo":""}
$ json <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json <<< '\''{"foo":[null]}'\''
{"foo":[null]}
$ json <<< '\''{"foo":[false]}'\''
{"foo":[false]}
$ json <<< '\''{"foo":[true]}'\''
{"foo":[true]}
$ json <<< '\''{"foo":[1]}'\''
{"foo":[1]}
$ json <<< '\''{"foo":[""]}'\''
{"foo":[""]}
$ json <<< '\''{"foo":["bar"]}'\''
{"foo":["bar"]}
$ json <<< '\''{"foo":null,"bar":null}'\''
{"foo":null,"bar":null}
$ json <<< '\''{"foo":null,"bar":false}'\''
{"foo":null,"bar":false}
$ json <<< '\''{"foo":null,"bar":true}'\''
{"foo":null,"bar":true}
$ json <<< '\''{"foo":null,"bar":123}'\''
{"foo":null,"bar":123}
$ json <<< '\''{"foo":null,"bar":[]}'\''
{"foo":null,"bar":[]}
$ json <<< '\''{"foo":null,"bar":{}}'\''
{"foo":null,"bar":{}}
$ json <<< '\''{"foo":false,"bar":null}'\''
{"foo":false,"bar":null}
$ json <<< '\''{"foo":true,"bar":null}'\''
{"foo":true,"bar":null}
$ json <<< '\''{"foo":123,"bar":null}'\''
{"foo":123,"bar":null}
$ json <<< '\''{"foo":[],"bar":null}'\''
{"foo":[],"bar":null}
$ json <<< '\''{"foo":{},"bar":null}'\''
{"foo":{},"bar":null}
$ json <<< '\''{"0":null}'\''
{"0":null}
$ json <<< '\''{"0":null,"1":null}'\''
{"0":null,"1":null}
$ json <<< '\''{"0":null,"1":null,"2":null}'\''
{"0":null,"1":null,"2":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null}'\''
{"0":null,"1":null,"2":null,"3":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null}
$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null,"15":null}'\''
{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null,"15":null}
$ json <<< '\''{"0":{}}'\''
{"0":{}}
$ json <<< '\''{"0":{},"1":{}}'\''
{"0":{},"1":{}}
$ json <<< '\''{"0":{},"1":{},"2":{}}'\''
{"0":{},"1":{},"2":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{}}'\''
{"0":{},"1":{},"2":{},"3":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{}}
$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{},"15":{}}'\''
{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{},"15":{}}
$ json <<< '\''{"0":{}}'\''
{"0":{}}
$ json <<< '\''{"0":{"1":{}}}'\''
{"0":{"1":{}}}
$ json <<< '\''{"0":{"1":{"2":{}}}}'\''
{"0":{"1":{"2":{}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{}}}}}'\''
{"0":{"1":{"2":{"3":{}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{}}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{}}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{}}}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{}}}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{}}}}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{}}}}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{}}}}}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{}}}}}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{}}}}}}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{}}}}}}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{}}}}}}}}}}}}}}}}
$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{"15":{}}}}}}}}}}}}}}}}}'\''
{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{"15":{}}}}}}}}}}}}}}}}}'
) -L object.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --terse "$@"; }'
json() { json0 --terse "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --terse "$@"; }'

echo '$ json <<< '\''{}'\'''
json <<< '{}' 2>&1 ||
echo 'command failed: json <<< '\''{}'\'''

echo '$ json <<< '\''{"":null}'\'''
json <<< '{"":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"":null}'\'''

echo '$ json <<< '\''{"":false}'\'''
json <<< '{"":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"":false}'\'''

echo '$ json <<< '\''{"":true}'\'''
json <<< '{"":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"":true}'\'''

echo '$ json <<< '\''{"":1}'\'''
json <<< '{"":1}' 2>&1 ||
echo 'command failed: json <<< '\''{"":1}'\'''

echo '$ json <<< '\''{"":""}'\'''
json <<< '{"":""}' 2>&1 ||
echo 'command failed: json <<< '\''{"":""}'\'''

echo '$ json <<< '\''{"":"foo"}'\'''
json <<< '{"":"foo"}' 2>&1 ||
echo 'command failed: json <<< '\''{"":"foo"}'\'''

echo '$ json <<< '\''{"":[]}'\'''
json <<< '{"":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":[]}'\'''

echo '$ json <<< '\''{"":[null]}'\'''
json <<< '{"":[null]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":[null]}'\'''

echo '$ json <<< '\''{"":[false]}'\'''
json <<< '{"":[false]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":[false]}'\'''

echo '$ json <<< '\''{"":[true]}'\'''
json <<< '{"":[true]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":[true]}'\'''

echo '$ json <<< '\''{"":[1]}'\'''
json <<< '{"":[1]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":[1]}'\'''

echo '$ json <<< '\''{"":[""]}'\'''
json <<< '{"":[""]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":[""]}'\'''

echo '$ json <<< '\''{"":["foo"]}'\'''
json <<< '{"":["foo"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"":["foo"]}'\'''

echo '$ json <<< '\''{"foo":null}'\'''
json <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null}'\'''

echo '$ json <<< '\''{"foo":false}'\'''
json <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":false}'\'''

echo '$ json <<< '\''{"foo":true}'\'''
json <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":true}'\'''

echo '$ json <<< '\''{"foo":1}'\'''
json <<< '{"foo":1}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":1}'\'''

echo '$ json <<< '\''{"foo":""}'\'''
json <<< '{"foo":""}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":""}'\'''

echo '$ json <<< '\''{"foo":"bar"}'\'''
json <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":"bar"}'\'''

echo '$ json <<< '\''{"foo":[]}'\'''
json <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[]}'\'''

echo '$ json <<< '\''{"foo":[null]}'\'''
json <<< '{"foo":[null]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[null]}'\'''

echo '$ json <<< '\''{"foo":[false]}'\'''
json <<< '{"foo":[false]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[false]}'\'''

echo '$ json <<< '\''{"foo":[true]}'\'''
json <<< '{"foo":[true]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[true]}'\'''

echo '$ json <<< '\''{"foo":[1]}'\'''
json <<< '{"foo":[1]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[1]}'\'''

echo '$ json <<< '\''{"foo":[""]}'\'''
json <<< '{"foo":[""]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[""]}'\'''

echo '$ json <<< '\''{"foo":["bar"]}'\'''
json <<< '{"foo":["bar"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":["bar"]}'\'''

echo '$ json <<< '\''{"foo":null,"bar":null}'\'''
json <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json <<< '\''{"foo":null,"bar":false}'\'''
json <<< '{"foo":null,"bar":false}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,"bar":false}'\'''

echo '$ json <<< '\''{"foo":null,"bar":true}'\'''
json <<< '{"foo":null,"bar":true}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,"bar":true}'\'''

echo '$ json <<< '\''{"foo":null,"bar":123}'\'''
json <<< '{"foo":null,"bar":123}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,"bar":123}'\'''

echo '$ json <<< '\''{"foo":null,"bar":[]}'\'''
json <<< '{"foo":null,"bar":[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,"bar":[]}'\'''

echo '$ json <<< '\''{"foo":null,"bar":{}}'\'''
json <<< '{"foo":null,"bar":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,"bar":{}}'\'''

echo '$ json <<< '\''{"foo":false,"bar":null}'\'''
json <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json <<< '\''{"foo":true,"bar":null}'\'''
json <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json <<< '\''{"foo":123,"bar":null}'\'''
json <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json <<< '\''{"foo":[],"bar":null}'\'''
json <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json <<< '\''{"foo":{},"bar":null}'\'''
json <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json <<< '\''{"0":null}'\'''
json <<< '{"0":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null}'\'''
json <<< '{"0":null,"1":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null}'\'''
json <<< '{"0":null,"1":null,"2":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null}'\'''

echo '$ json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null,"15":null}'\'''
json <<< '{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null,"15":null}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":null,"1":null,"2":null,"3":null,"4":null,"5":null,"6":null,"7":null,"8":null,"9":null,"10":null,"11":null,"12":null,"13":null,"14":null,"15":null}'\'''

echo '$ json <<< '\''{"0":{}}'\'''
json <<< '{"0":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{}}'\'''
json <<< '{"0":{},"1":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{}}'\'''
json <<< '{"0":{},"1":{},"2":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{}}'\'''

echo '$ json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{},"15":{}}'\'''
json <<< '{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{},"15":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{},"1":{},"2":{},"3":{},"4":{},"5":{},"6":{},"7":{},"8":{},"9":{},"10":{},"11":{},"12":{},"13":{},"14":{},"15":{}}'\'''

echo '$ json <<< '\''{"0":{}}'\'''
json <<< '{"0":{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{}}'\'''

echo '$ json <<< '\''{"0":{"1":{}}}'\'''
json <<< '{"0":{"1":{}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{}}}}'\'''
json <<< '{"0":{"1":{"2":{}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{}}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{}}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{}}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{}}}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{}}}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{}}}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{}}}}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{}}}}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{}}}}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{}}}}}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{}}}}}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{}}}}}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{}}}}}}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{}}}}}}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{}}}}}}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{}}}}}}}}}}}}}}}}'\'''

echo '$ json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{"15":{}}}}}}}}}}}}}}}}}'\'''
json <<< '{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{"15":{}}}}}}}}}}}}}}}}}' 2>&1 ||
echo 'command failed: json <<< '\''{"0":{"1":{"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"10":{"11":{"12":{"13":{"14":{"15":{}}}}}}}}}}}}}}}}}'\'''
)

