#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:multi-str
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L multi-str.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''["a","b"]'\''
json: error: <text>:1:6: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:2)
json: error: <text>:1:6: ["a","b"]
json: error: <text>:1:6:      ^
command failed: json-litex -d '\''["a","b"]'\''
$ json-litex -d '\''{"foo":["a","b"]}'\''
json: error: <text>:1:13: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:9)
json: error: <text>:1:13: {"foo":["a","b"]}
json: error: <text>:1:13:             ^
command failed: json-litex -d '\''{"foo":["a","b"]}'\''
$ json-litex -d '\''{"bar":{"foo":["a","b"]}}'\''
json: error: <text>:1:20: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:16)
json: error: <text>:1:20: {"bar":{"foo":["a","b"]}}
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''{"bar":{"foo":["a","b"]}}'\''
$ json-litex -d '\''[{"foo":["a","b"]}]'\''
json: error: <text>:1:14: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:10)
json: error: <text>:1:14: [{"foo":["a","b"]}]
json: error: <text>:1:14:              ^
command failed: json-litex -d '\''[{"foo":["a","b"]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":["a","b"]}}}'\''
json: error: <text>:1:27: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:23)
json: error: <text>:1:27: {"baz":{"bar":{"foo":["a","b"]}}}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":["a","b"]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":["a","b"]}]}'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:17)
json: error: <text>:1:21: {"baz":[{"foo":["a","b"]}]}
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"foo":["a","b"]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":["a","b"]}}]'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:17)
json: error: <text>:1:21: [{"bar":{"foo":["a","b"]}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''[{"bar":{"foo":["a","b"]}}]'\''
$ json-litex -d '\''[{"c":"`x`"},"a","b"]'\''
json: error: <text>:1:18: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:14)
json: error: <text>:1:18: [{"c":"`x`"},"a","b"]
json: error: <text>:1:18:                  ^
command failed: json-litex -d '\''[{"c":"`x`"},"a","b"]'\''
$ json-litex -d '\''{"foo":[{"c":"`x`"},"a","b"]}'\''
json: error: <text>:1:25: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:21)
json: error: <text>:1:25: {"foo":[{"c":"`x`"},"a","b"]}
json: error: <text>:1:25:                         ^
command failed: json-litex -d '\''{"foo":[{"c":"`x`"},"a","b"]}'\''
$ json-litex -d '\''{"bar":{"foo":[{"c":"`x`"},"a","b"]}}'\''
json: error: <text>:1:32: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:28)
json: error: <text>:1:32: {"bar":{"foo":[{"c":"`x`"},"a","b"]}}
json: error: <text>:1:32:                                ^
command failed: json-litex -d '\''{"bar":{"foo":[{"c":"`x`"},"a","b"]}}'\''
$ json-litex -d '\''[{"foo":[{"c":"`x`"},"a","b"]}]'\''
json: error: <text>:1:26: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:22)
json: error: <text>:1:26: [{"foo":[{"c":"`x`"},"a","b"]}]
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''[{"foo":[{"c":"`x`"},"a","b"]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":[{"c":"`x`"},"a","b"]}}}'\''
json: error: <text>:1:39: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:35)
json: error: <text>:1:39: :{"bar":{"foo":[{"c":"`x`"},"a","b"]}}}
json: error: <text>:1:39:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"c":"`x`"},"a","b"]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":[{"c":"`x`"},"a","b"]}]}'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:29)
json: error: <text>:1:33: {"baz":[{"foo":[{"c":"`x`"},"a","b"]}]}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":[{"foo":[{"c":"`x`"},"a","b"]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":[{"c":"`x`"},"a","b"]}}]'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:29)
json: error: <text>:1:33: [{"bar":{"foo":[{"c":"`x`"},"a","b"]}}]
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''[{"bar":{"foo":[{"c":"`x`"},"a","b"]}}]'\''
$ json-litex -d '\''["a",{"c":"`x`"},"b"]'\''
json: error: <text>:1:18: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:2)
json: error: <text>:1:18: ["a",{"c":"`x`"},"b"]
json: error: <text>:1:18:                  ^
command failed: json-litex -d '\''["a",{"c":"`x`"},"b"]'\''
$ json-litex -d '\''{"foo":["a",{"c":"`x`"},"b"]}'\''
json: error: <text>:1:25: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:9)
json: error: <text>:1:25: {"foo":["a",{"c":"`x`"},"b"]}
json: error: <text>:1:25:                         ^
command failed: json-litex -d '\''{"foo":["a",{"c":"`x`"},"b"]}'\''
$ json-litex -d '\''{"bar":{"foo":["a",{"c":"`x`"},"b"]}}'\''
json: error: <text>:1:32: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:16)
json: error: <text>:1:32: {"bar":{"foo":["a",{"c":"`x`"},"b"]}}
json: error: <text>:1:32:                                ^
command failed: json-litex -d '\''{"bar":{"foo":["a",{"c":"`x`"},"b"]}}'\''
$ json-litex -d '\''[{"foo":["a",{"c":"`x`"},"b"]}]'\''
json: error: <text>:1:26: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:10)
json: error: <text>:1:26: [{"foo":["a",{"c":"`x`"},"b"]}]
json: error: <text>:1:26:                          ^
command failed: json-litex -d '\''[{"foo":["a",{"c":"`x`"},"b"]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":["a",{"c":"`x`"},"b"]}}}'\''
json: error: <text>:1:39: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:23)
json: error: <text>:1:39: :{"bar":{"foo":["a",{"c":"`x`"},"b"]}}}
json: error: <text>:1:39:                                 ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":["a",{"c":"`x`"},"b"]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":["a",{"c":"`x`"},"b"]}]}'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:17)
json: error: <text>:1:33: {"baz":[{"foo":["a",{"c":"`x`"},"b"]}]}
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''{"baz":[{"foo":["a",{"c":"`x`"},"b"]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":["a",{"c":"`x`"},"b"]}}]'\''
json: error: <text>:1:33: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:17)
json: error: <text>:1:33: [{"bar":{"foo":["a",{"c":"`x`"},"b"]}}]
json: error: <text>:1:33:                                 ^
command failed: json-litex -d '\''[{"bar":{"foo":["a",{"c":"`x`"},"b"]}}]'\''
$ json-litex -d '\''["a","b",{"c":"`x`"}]'\''
json: error: <text>:1:6: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:2)
json: error: <text>:1:6: ["a","b",{"c":"`x`"}]
json: error: <text>:1:6:      ^
command failed: json-litex -d '\''["a","b",{"c":"`x`"}]'\''
$ json-litex -d '\''{"foo":["a","b",{"c":"`x`"}]}'\''
json: error: <text>:1:13: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:9)
json: error: <text>:1:13: {"foo":["a","b",{"c":"`x`"}]}
json: error: <text>:1:13:             ^
command failed: json-litex -d '\''{"foo":["a","b",{"c":"`x`"}]}'\''
$ json-litex -d '\''{"bar":{"foo":["a","b",{"c":"`x`"}]}}'\''
json: error: <text>:1:20: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:16)
json: error: <text>:1:20: {"bar":{"foo":["a","b",{"c":"`x`"}]}}
json: error: <text>:1:20:                    ^
command failed: json-litex -d '\''{"bar":{"foo":["a","b",{"c":"`x`"}]}}'\''
$ json-litex -d '\''[{"foo":["a","b",{"c":"`x`"}]}]'\''
json: error: <text>:1:14: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:10)
json: error: <text>:1:14: [{"foo":["a","b",{"c":"`x`"}]}]
json: error: <text>:1:14:              ^
command failed: json-litex -d '\''[{"foo":["a","b",{"c":"`x`"}]}]'\''
$ json-litex -d '\''{"baz":{"bar":{"foo":["a","b",{"c":"`x`"}]}}}'\''
json: error: <text>:1:27: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:23)
json: error: <text>:1:27: {"baz":{"bar":{"foo":["a","b",{"c":"`x`"}]}}}
json: error: <text>:1:27:                           ^
command failed: json-litex -d '\''{"baz":{"bar":{"foo":["a","b",{"c":"`x`"}]}}}'\''
$ json-litex -d '\''{"baz":[{"foo":["a","b",{"c":"`x`"}]}]}'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:17)
json: error: <text>:1:21: {"baz":[{"foo":["a","b",{"c":"`x`"}]}]}
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''{"baz":[{"foo":["a","b",{"c":"`x`"}]}]}'\''
$ json-litex -d '\''[{"bar":{"foo":["a","b",{"c":"`x`"}]}}]'\''
json: error: <text>:1:21: filter library: attribute error: invalid array: multiple inner strings (previous defined at 1:17)
json: error: <text>:1:21: [{"bar":{"foo":["a","b",{"c":"`x`"}]}}]
json: error: <text>:1:21:                     ^
command failed: json-litex -d '\''[{"bar":{"foo":["a","b",{"c":"`x`"}]}}]'\'''
) -L multi-str.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''["a","b"]'\'''
json-litex -d '["a","b"]' 2>&1 ||
echo 'command failed: json-litex -d '\''["a","b"]'\'''

echo '$ json-litex -d '\''{"foo":["a","b"]}'\'''
json-litex -d '{"foo":["a","b"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":["a","b"]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":["a","b"]}}'\'''
json-litex -d '{"bar":{"foo":["a","b"]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":["a","b"]}}'\'''

echo '$ json-litex -d '\''[{"foo":["a","b"]}]'\'''
json-litex -d '[{"foo":["a","b"]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":["a","b"]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":["a","b"]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":["a","b"]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":["a","b"]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":["a","b"]}]}'\'''
json-litex -d '{"baz":[{"foo":["a","b"]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":["a","b"]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":["a","b"]}}]'\'''
json-litex -d '[{"bar":{"foo":["a","b"]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":["a","b"]}}]'\'''

echo '$ json-litex -d '\''[{"c":"`x`"},"a","b"]'\'''
json-litex -d '[{"c":"`x`"},"a","b"]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"c":"`x`"},"a","b"]'\'''

echo '$ json-litex -d '\''{"foo":[{"c":"`x`"},"a","b"]}'\'''
json-litex -d '{"foo":[{"c":"`x`"},"a","b"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":[{"c":"`x`"},"a","b"]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":[{"c":"`x`"},"a","b"]}}'\'''
json-litex -d '{"bar":{"foo":[{"c":"`x`"},"a","b"]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":[{"c":"`x`"},"a","b"]}}'\'''

echo '$ json-litex -d '\''[{"foo":[{"c":"`x`"},"a","b"]}]'\'''
json-litex -d '[{"foo":[{"c":"`x`"},"a","b"]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":[{"c":"`x`"},"a","b"]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":[{"c":"`x`"},"a","b"]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":[{"c":"`x`"},"a","b"]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":[{"c":"`x`"},"a","b"]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":[{"c":"`x`"},"a","b"]}]}'\'''
json-litex -d '{"baz":[{"foo":[{"c":"`x`"},"a","b"]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":[{"c":"`x`"},"a","b"]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":[{"c":"`x`"},"a","b"]}}]'\'''
json-litex -d '[{"bar":{"foo":[{"c":"`x`"},"a","b"]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":[{"c":"`x`"},"a","b"]}}]'\'''

echo '$ json-litex -d '\''["a",{"c":"`x`"},"b"]'\'''
json-litex -d '["a",{"c":"`x`"},"b"]' 2>&1 ||
echo 'command failed: json-litex -d '\''["a",{"c":"`x`"},"b"]'\'''

echo '$ json-litex -d '\''{"foo":["a",{"c":"`x`"},"b"]}'\'''
json-litex -d '{"foo":["a",{"c":"`x`"},"b"]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":["a",{"c":"`x`"},"b"]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":["a",{"c":"`x`"},"b"]}}'\'''
json-litex -d '{"bar":{"foo":["a",{"c":"`x`"},"b"]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":["a",{"c":"`x`"},"b"]}}'\'''

echo '$ json-litex -d '\''[{"foo":["a",{"c":"`x`"},"b"]}]'\'''
json-litex -d '[{"foo":["a",{"c":"`x`"},"b"]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":["a",{"c":"`x`"},"b"]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":["a",{"c":"`x`"},"b"]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":["a",{"c":"`x`"},"b"]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":["a",{"c":"`x`"},"b"]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":["a",{"c":"`x`"},"b"]}]}'\'''
json-litex -d '{"baz":[{"foo":["a",{"c":"`x`"},"b"]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":["a",{"c":"`x`"},"b"]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":["a",{"c":"`x`"},"b"]}}]'\'''
json-litex -d '[{"bar":{"foo":["a",{"c":"`x`"},"b"]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":["a",{"c":"`x`"},"b"]}}]'\'''

echo '$ json-litex -d '\''["a","b",{"c":"`x`"}]'\'''
json-litex -d '["a","b",{"c":"`x`"}]' 2>&1 ||
echo 'command failed: json-litex -d '\''["a","b",{"c":"`x`"}]'\'''

echo '$ json-litex -d '\''{"foo":["a","b",{"c":"`x`"}]}'\'''
json-litex -d '{"foo":["a","b",{"c":"`x`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"foo":["a","b",{"c":"`x`"}]}'\'''

echo '$ json-litex -d '\''{"bar":{"foo":["a","b",{"c":"`x`"}]}}'\'''
json-litex -d '{"bar":{"foo":["a","b",{"c":"`x`"}]}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar":{"foo":["a","b",{"c":"`x`"}]}}'\'''

echo '$ json-litex -d '\''[{"foo":["a","b",{"c":"`x`"}]}]'\'''
json-litex -d '[{"foo":["a","b",{"c":"`x`"}]}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"foo":["a","b",{"c":"`x`"}]}]'\'''

echo '$ json-litex -d '\''{"baz":{"bar":{"foo":["a","b",{"c":"`x`"}]}}}'\'''
json-litex -d '{"baz":{"bar":{"foo":["a","b",{"c":"`x`"}]}}}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":{"bar":{"foo":["a","b",{"c":"`x`"}]}}}'\'''

echo '$ json-litex -d '\''{"baz":[{"foo":["a","b",{"c":"`x`"}]}]}'\'''
json-litex -d '{"baz":[{"foo":["a","b",{"c":"`x`"}]}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"foo":["a","b",{"c":"`x`"}]}]}'\'''

echo '$ json-litex -d '\''[{"bar":{"foo":["a","b",{"c":"`x`"}]}}]'\'''
json-litex -d '[{"bar":{"foo":["a","b",{"c":"`x`"}]}}]' 2>&1 ||
echo 'command failed: json-litex -d '\''[{"bar":{"foo":["a","b",{"c":"`x`"}]}}]'\'''
)

