#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C gen-def-gcc:sobj-litex-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L sobj-litex-lib.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ set -o pipefail
$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'\''1i\\\\\\#include "json-litex.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee >(sed -r '\''/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\'' >&2)|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='\''__attribute__((unused))'\'' -I ../lib -xc -c - -o /dev/null; }
$ json-litex libs/test-litex/test-litex.so
\#include "json-litex.h"
static const uchar_t __0[] = {
};
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
    .size = 2
};
static const struct json_litex_object_node_arg_t __33[];
static const struct json_litex_node_t __34;
static const struct json_litex_object_node_arg_t __22[];
static const struct json_litex_node_t __23;
static const struct json_litex_node_t __19;
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0),
    jump_false(4, false),
    const_num(1),
    count_str("\n"),
    cmp_op(ge)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 5
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[[:ascii:]]*$/ && #`\n` <= 1"
    },
    .attr.string = &__4,
    .parent = &__19
};
static const struct json_litex_object_node_arg_t __15[];
static const struct json_litex_node_t __16;
static const struct json_litex_object_node_arg_t __11[];
static const struct json_litex_node_t __12;
static const struct json_litex_expr_node_t __6[] = {
    call_builtin(null),
    jump_true(6, false),
    match_rex(1),
    jump_false(4, false),
    count_str("x"),
    count_str("y"),
    cmp_op(lt)
};
static const struct json_litex_expr_def_t __7 = {
    .nodes = __6,
    .size = 7
};
static const struct json_litex_node_t __8 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null || /^x+y+$/ && #`x` < #`y`"
    },
    .attr.string = &__7,
    .path = __11 + 0,
    .parent = &__12
};
static const struct json_litex_node_t* __9(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''d'\'' &&
        *p == 0)
        return &__8;
    return NULL;
}
static const struct json_litex_object_attr_t __10 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __9
};
static const struct json_litex_object_node_arg_t __11[] = {
    {
        .key = {
            .val = (const uchar_t*) "d"
        },
        .val = &__8
    }
};
static const struct json_litex_node_t __12 = {
    .type = json_litex_object_node_type,
    .attr.object = &__10,
    .node.object = {
        .args = __11,
        .size = 1
    },
    .path = __15 + 0,
    .parent = &__16
};
static const struct json_litex_node_t* __13(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''c'\'' &&
        *p == 0)
        return &__12;
    return NULL;
}
static const struct json_litex_object_attr_t __14 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __13
};
static const struct json_litex_object_node_arg_t __15[] = {
    {
        .key = {
            .val = (const uchar_t*) "c"
        },
        .val = &__12
    }
};
static const struct json_litex_node_t __16 = {
    .type = json_litex_object_node_type,
    .attr.object = &__14,
    .node.object = {
        .args = __15,
        .size = 1
    },
    .parent = &__19
};
static const struct json_litex_array_attr_t __17 = {
    .string = &__5,
    .object = &__16
};
static const struct json_litex_node_t* __18[] = {
    &__5,
    &__16,
    NULL
};
static const struct json_litex_node_t __19 = {
    .type = json_litex_array_node_type,
    .attr.array = &__17,
    .node.array = {
        .args = __18,
        .size = 2
    },
    .path = __22 + 0,
    .parent = &__23
};
static const struct json_litex_node_t* __20(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''b'\'' &&
        *p == 0)
        return &__19;
    return NULL;
}
static const struct json_litex_object_attr_t __21 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __20
};
static const struct json_litex_object_node_arg_t __22[] = {
    {
        .key = {
            .val = (const uchar_t*) "b"
        },
        .val = &__19
    }
};
static const struct json_litex_node_t __23 = {
    .type = json_litex_object_node_type,
    .attr.object = &__21,
    .node.object = {
        .args = __22,
        .size = 1
    },
    .path = __33 + 0,
    .parent = &__34
};
static const struct json_litex_object_node_arg_t __29[];
static const struct json_litex_node_t __30;
static const struct json_litex_expr_node_t __24[] = {
    call_builtin(null),
    jump_true(3, false),
    const_str("%Y-%m-%d"),
    call_builtin(date)
};
static const struct json_litex_expr_def_t __25 = {
    .nodes = __24,
    .size = 4
};
static const struct json_litex_node_t __26 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null || date(`%Y-%m-%d`)"
    },
    .attr.string = &__25,
    .path = __29 + 0,
    .parent = &__30
};
static const struct json_litex_node_t* __27(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''d'\'' &&
        *p == 0)
        return &__26;
    return NULL;
}
static const struct json_litex_object_attr_t __28 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __27
};
static const struct json_litex_object_node_arg_t __29[] = {
    {
        .key = {
            .val = (const uchar_t*) "d"
        },
        .val = &__26
    }
};
static const struct json_litex_node_t __30 = {
    .type = json_litex_object_node_type,
    .attr.object = &__28,
    .node.object = {
        .args = __29,
        .size = 1
    },
    .path = __33 + 1,
    .parent = &__34
};
static const struct json_litex_node_t* __31(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return &__23;
        return NULL;
    case '\''c'\'':
        if (*p == 0)
            return &__30;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __32 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __31
};
static const struct json_litex_object_node_arg_t __33[] = {
    {
        .key = {
            .val = (const uchar_t*) "a"
        },
        .val = &__23
    },
    {
        .key = {
            .val = (const uchar_t*) "c"
        },
        .val = &__30
    }
};
static const struct json_litex_node_t __34 = {
    .type = json_litex_object_node_type,
    .attr.object = &__32,
    .node.object = {
        .args = __33,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__34
};'
) -L sobj-litex-lib.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'\''1i\\\\\\#include "json-litex.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee >(sed -r '\''/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\'' >&2)|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='\''__attribute__((unused))'\'' -I ../lib -xc -c - -o /dev/null; }'
json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'1i\\\\\\#include "json-litex.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee >(sed -r '/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'$'};\n''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/' >&2)|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='__attribute__((unused))' -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'\''1i\\\\\\#include "json-litex.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee >(sed -r '\''/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\'' >&2)|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='\''__attribute__((unused))'\'' -I ../lib -xc -c - -o /dev/null; }'

echo '$ json-litex libs/test-litex/test-litex.so'
json-litex libs/test-litex/test-litex.so 2>&1 ||
echo 'command failed: json-litex libs/test-litex/test-litex.so'
)

