#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:builtins6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins6.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr '\''date(`%z`)'\'' '\''""'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''" "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''" bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" "'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''"  "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''"  bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foobar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo "'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo  "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo  bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"0"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"0bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"0 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"0 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 0"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 0bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 0 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 0 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo0"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo0 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"0:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"0:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"0: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"0: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 0:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 0:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 0: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 0: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo0: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"0:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"0:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"0:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"0:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 0:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 0:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 0:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 0:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo0:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"0:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"0:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"0:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"0:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 0:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 0:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 0:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 0:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo0:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"0:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"0:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"0:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"0:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 0:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 0:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 0:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 0:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo0:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"03"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"03bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"03 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"03 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 03"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 03bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 03 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 03 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo03"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo03bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo03 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo03 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 03"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 03bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 03 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 03 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"11"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"11bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"11 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"11 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 11"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 11bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 11 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 11 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo11"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo11 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"11:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"11:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"11: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"11: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 11:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 11:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 11: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 11: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo11: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"11:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"11:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"11:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"11:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 11:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 11:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 11:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 11:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo11:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"11:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"11:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"11:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"11:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 11:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 11:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 11:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 11:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo11:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"11:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"11:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"11:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"11:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 11:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 11:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 11:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 11:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo11:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"044"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"044bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"044 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"044 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 044"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 044bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 044 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 044 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo044"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo044bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo044 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo044 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 044"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 044bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 044 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 044 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"055"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"055bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"055 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"055 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 055"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 055bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 055 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 055 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo055"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo055bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo055 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo055 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 055"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 055bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 055 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 055 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"113"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"113bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"113 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"113 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 113"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 113bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 113 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 113 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo113"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo113bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo113 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo113 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 113"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 113bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 113 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 113 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"222"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"222bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"222 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"222 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 222"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 222bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 222 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 222 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo222"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo222 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"222:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"222:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"222: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"222: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 222:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 222:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 222: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 222: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo222: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"222:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"222:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"222:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"222:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 222:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 222:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 222:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 222:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo222:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"222:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"222:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"222:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"222:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 222:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 222:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 222:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 222:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo222:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"222:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"222:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"222:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"222:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 222:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 222:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 222:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 222:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo222:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"1144"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"1144bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"1144 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"1144 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 1144"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 1144bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 1144 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 1144 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo1144"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo1144bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo1144 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo1144 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 1144"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 1144bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 1144 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 1144 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"1155"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"1155bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"1155 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"1155 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 1155"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 1155bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 1155 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 1155 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo1155"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo1155bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo1155 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo1155 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 1155"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 1155bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 1155 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 1155 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"2223"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"2223bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"2223 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"2223 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 2223"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 2223bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 2223 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 2223 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo2223"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo2223bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo2223 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo2223 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 2223"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 2223bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 2223 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 2223 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"22244"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"22244bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"22244 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"22244 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 22244"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 22244bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 22244 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 22244 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo22244"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo22244bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo22244 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo22244 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 22244"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 22244bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 22244 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 22244 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"22255"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"22255bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"22255 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"22255 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" 22255"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" 22255bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" 22255 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" 22255 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo22255"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo22255bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo22255 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo22255 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo 22255"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 22255bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo 22255 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 22255 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"Z"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"Zbar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"Z "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"Z bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" Z"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" Zbar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" Z "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" Z bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"fooZ"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"fooZbar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"fooZ "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"fooZ bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo Z"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo Zbar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo Z "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo Z bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+ "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+ bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" + "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" + bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+ "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+ bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo + "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo + bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+0"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+0bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+0 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+0 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +0"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +0bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +0 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +0 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+0:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+0:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+0: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+0: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +0:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +0:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +0: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +0: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+0:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+0:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+0:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+0:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +0:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +0:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +0:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +0:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+0:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+0:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+0:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+0:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +0:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +0:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +0:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +0:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+0:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+0:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+0:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+0:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +0:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +0:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +0:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +0:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+03"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+03bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+03 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+03 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +03"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +03bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +03 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +03 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+03"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+03bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+03 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+03 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +03"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +03bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +03 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +03 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+11"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+11bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+11 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+11 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +11"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +11bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +11 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +11 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+11:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+11:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+11: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+11: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +11:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +11:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +11: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +11: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+11:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+11:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+11:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+11:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +11:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +11:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +11:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +11:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+11:44"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+11:44bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+11:44 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+11:44 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +11:44"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +11:44bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +11:44 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +11:44 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:44"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:44bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11:44 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:44 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:44"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:44bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11:44 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:44 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+11:55"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+11:55bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+11:55 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+11:55 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +11:55"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +11:55bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +11:55 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +11:55 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:55"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:55bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11:55 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:55 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:55"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:55bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11:55 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:55 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+044"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+044bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+044 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+044 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +044"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +044bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +044 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +044 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+044"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+044bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+044 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+044 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +044"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +044bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +044 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +044 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+055"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+055bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+055 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+055 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +055"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +055bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +055 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +055 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+055"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+055bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+055 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+055 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +055"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +055bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +055 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +055 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+113"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+113bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+113 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+113 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +113"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +113bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +113 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +113 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+113"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+113bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+113 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+113 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +113"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +113bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +113 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +113 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+222"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+222bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+222 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+222 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +222"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +222bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +222 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +222 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+222:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+222:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+222: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+222: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +222:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +222:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +222: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +222: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+222:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+222:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+222:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+222:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +222:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +222:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +222:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +222:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+222:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+222:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+222:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+222:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +222:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +222:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +222:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +222:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+222:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+222:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+222:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+222:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +222:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +222:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +222:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +222:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+1144"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+1144bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+1144 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+1144 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +1144"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +1144bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +1144 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +1144 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+1144"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+1144bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+1144 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+1144 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +1144"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +1144bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +1144 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +1144 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+1155"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+1155bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+1155 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+1155 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +1155"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +1155bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +1155 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +1155 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+1155"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+1155bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+1155 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+1155 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +1155"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +1155bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +1155 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +1155 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+2223"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"+2223bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"+2223 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"+2223 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" +2223"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" +2223bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" +2223 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" +2223 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+2223"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+2223bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+2223 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+2223 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +2223"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +2223bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +2223 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +2223 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"+22244"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+22244bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+22244 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+22244 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +22244"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +22244bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +22244 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +22244 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+22244"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+22244bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+22244 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+22244 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +22244"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +22244bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +22244 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +22244 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+22255"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+22255bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+22255 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+22255 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +22255"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +22255bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +22255 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +22255 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+22255"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+22255bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+22255 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+22255 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +22255"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +22255bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +22255 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +22255 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+Z"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+Zbar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+Z "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+Z bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +Z"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +Zbar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +Z "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +Z bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+Z"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+Zbar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+Z "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+Z bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +Z"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +Zbar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +Z "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +Z bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"+:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"+:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"+:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"+:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" +:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" +:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" +:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" +:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo+:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo +:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"- "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"- bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" - "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" - bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo- "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo- bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo - "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo - bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-0"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-0bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-0 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-0 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -0"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -0bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -0 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -0 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-0:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-0:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-0: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-0: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -0:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -0:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -0: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -0: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-0:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-0:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-0:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-0:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -0:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -0:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -0:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -0:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-0:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-0:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-0:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-0:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -0:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -0:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -0:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -0:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-0:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-0:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-0:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-0:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -0:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -0:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -0:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -0:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-03"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-03bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-03 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-03 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -03"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -03bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -03 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -03 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-03"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-03bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-03 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-03 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -03"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -03bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -03 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -03 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-11"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-11bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-11 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-11 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -11"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -11bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -11 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -11 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-11:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-11:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-11: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-11: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -11:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -11:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -11: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -11: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-11:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-11:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-11:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-11:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -11:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -11:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -11:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -11:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-11:44"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-11:44bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-11:44 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-11:44 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -11:44"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -11:44bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -11:44 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -11:44 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:44"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:44bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11:44 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:44 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:44"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:44bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11:44 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:44 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-11:55"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-11:55bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-11:55 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-11:55 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -11:55"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -11:55bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -11:55 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -11:55 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:55"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:55bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11:55 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:55 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:55"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:55bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11:55 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:55 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-044"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-044bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-044 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-044 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -044"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -044bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -044 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -044 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-044"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-044bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-044 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-044 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -044"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -044bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -044 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -044 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-055"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-055bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-055 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-055 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -055"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -055bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -055 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -055 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-055"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-055bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-055 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-055 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -055"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -055bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -055 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -055 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-113"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-113bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-113 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-113 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -113"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -113bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -113 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -113 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-113"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-113bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-113 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-113 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -113"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -113bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -113 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -113 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-222"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-222bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-222 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-222 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -222"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -222bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -222 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -222 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-222:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-222:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-222: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-222: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -222:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -222:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -222: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -222: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-222:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-222:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-222:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-222:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -222:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -222:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -222:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -222:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-222:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-222:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-222:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-222:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -222:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -222:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -222:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -222:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-222:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-222:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-222:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-222:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -222:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -222:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -222:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -222:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-1144"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-1144bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-1144 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-1144 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -1144"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -1144bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -1144 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -1144 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-1144"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-1144bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-1144 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-1144 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -1144"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -1144bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -1144 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -1144 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-1155"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-1155bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-1155 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-1155 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -1155"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -1155bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -1155 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -1155 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-1155"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-1155bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-1155 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-1155 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -1155"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -1155bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -1155 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -1155 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-2223"'\''
1
$ test-expr '\''date(`%zbar`)'\'' '\''"-2223bar"'\''
1
$ test-expr '\''date(`%z `)'\'' '\''"-2223 "'\''
1
$ test-expr '\''date(`%z bar`)'\'' '\''"-2223 bar"'\''
1
$ test-expr '\''date(` %z`)'\'' '\''" -2223"'\''
1
$ test-expr '\''date(` %zbar`)'\'' '\''" -2223bar"'\''
1
$ test-expr '\''date(` %z `)'\'' '\''" -2223 "'\''
1
$ test-expr '\''date(` %z bar`)'\'' '\''" -2223 bar"'\''
1
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-2223"'\''
1
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-2223bar"'\''
1
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-2223 "'\''
1
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-2223 bar"'\''
1
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -2223"'\''
1
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -2223bar"'\''
1
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -2223 "'\''
1
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -2223 bar"'\''
1
$ test-expr '\''date(`%z`)'\'' '\''"-22244"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-22244bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-22244 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-22244 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -22244"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -22244bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -22244 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -22244 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-22244"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-22244bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-22244 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-22244 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -22244"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -22244bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -22244 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -22244 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-22255"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-22255bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-22255 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-22255 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -22255"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -22255bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -22255 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -22255 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-22255"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-22255bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-22255 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-22255 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -22255"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -22255bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -22255 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -22255 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-Z"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-Zbar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-Z "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-Z bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -Z"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -Zbar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -Z "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -Z bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-Z"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-Zbar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-Z "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-Z bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -Z"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -Zbar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -Z "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -Z bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-:"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-:bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-: "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-: bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -:"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -:bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -: "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -: bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -: "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -: bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-:3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-:3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-:3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-:3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -:3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -:3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -:3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -:3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -:3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-:44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-:44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-:44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-:44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -:44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -:44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -:44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -:44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -:44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''"-:55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''"-:55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''"-:55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''"-:55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" -:55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" -:55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" -:55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" -:55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo-:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo -:55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:55 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''":"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''":bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''": "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''": bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" :"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" :bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" : "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" : bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo:"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo: "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo: bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo :"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo : "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo : bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''":3"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''":3bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''":3 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''":3 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" :3"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" :3bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" :3 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" :3 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo:3"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:3bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo:3 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo:3 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo :3"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :3bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo :3 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo :3 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''":44"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''":44bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''":44 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''":44 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" :44"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" :44bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" :44 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" :44 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo:44"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:44bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo:44 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo:44 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo :44"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :44bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo :44 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo :44 bar"'\''
0
$ test-expr '\''date(`%z`)'\'' '\''":55"'\''
0
$ test-expr '\''date(`%zbar`)'\'' '\''":55bar"'\''
0
$ test-expr '\''date(`%z `)'\'' '\''":55 "'\''
0
$ test-expr '\''date(`%z bar`)'\'' '\''":55 bar"'\''
0
$ test-expr '\''date(` %z`)'\'' '\''" :55"'\''
0
$ test-expr '\''date(` %zbar`)'\'' '\''" :55bar"'\''
0
$ test-expr '\''date(` %z `)'\'' '\''" :55 "'\''
0
$ test-expr '\''date(` %z bar`)'\'' '\''" :55 bar"'\''
0
$ test-expr '\''date(`foo%z`)'\'' '\''"foo:55"'\''
0
$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:55bar"'\''
0
$ test-expr '\''date(`foo%z `)'\'' '\''"foo:55 "'\''
0
$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo:55 bar"'\''
0
$ test-expr '\''date(`foo %z`)'\'' '\''"foo :55"'\''
0
$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :55bar"'\''
0
$ test-expr '\''date(`foo %z `)'\'' '\''"foo :55 "'\''
0
$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo :55 bar"'\''
0'
) -L builtins6.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr '\''date(`%z`)'\'' '\''""'\'''
test-expr 'date(`%z`)' '""' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''""'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"bar"'\'''
test-expr 'date(`%zbar`)' '"bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''" "'\'''
test-expr 'date(`%z `)' '" "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''" "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''" bar"'\'''
test-expr 'date(`%z bar`)' '" bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''" bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" "'\'''
test-expr 'date(` %z`)' '" "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" "'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" bar"'\'''
test-expr 'date(` %zbar`)' '" bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''"  "'\'''
test-expr 'date(` %z `)' '"  "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''"  "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''"  bar"'\'''
test-expr 'date(` %z bar`)' '"  bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''"  bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo"'\'''
test-expr 'date(`foo%z`)' '"foo"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foobar"'\'''
test-expr 'date(`foo%zbar`)' '"foobar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foobar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo "'\'''
test-expr 'date(`foo%z `)' '"foo "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo "'\'''
test-expr 'date(`foo %z`)' '"foo "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo "'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo  "'\'''
test-expr 'date(`foo %z `)' '"foo  "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo  "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo  bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo  bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo  bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"0"'\'''
test-expr 'date(`%z`)' '"0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"0"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"0bar"'\'''
test-expr 'date(`%zbar`)' '"0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"0bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"0 "'\'''
test-expr 'date(`%z `)' '"0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"0 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"0 bar"'\'''
test-expr 'date(`%z bar`)' '"0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"0 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 0"'\'''
test-expr 'date(` %z`)' '" 0"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 0"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 0bar"'\'''
test-expr 'date(` %zbar`)' '" 0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 0bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 0 "'\'''
test-expr 'date(` %z `)' '" 0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 0 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 0 bar"'\'''
test-expr 'date(` %z bar`)' '" 0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 0 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo0"'\'''
test-expr 'date(`foo%z`)' '"foo0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo0"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo0bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo0 "'\'''
test-expr 'date(`foo%z `)' '"foo0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo0 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo0 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0"'\'''
test-expr 'date(`foo %z`)' '"foo 0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 0"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0 "'\'''
test-expr 'date(`foo %z `)' '"foo 0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 0 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"0:"'\'''
test-expr 'date(`%z`)' '"0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"0:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"0:bar"'\'''
test-expr 'date(`%zbar`)' '"0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"0:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"0: "'\'''
test-expr 'date(`%z `)' '"0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"0: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"0: bar"'\'''
test-expr 'date(`%z bar`)' '"0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"0: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 0:"'\'''
test-expr 'date(` %z`)' '" 0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 0:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 0:bar"'\'''
test-expr 'date(` %zbar`)' '" 0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 0:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 0: "'\'''
test-expr 'date(` %z `)' '" 0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 0: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 0: bar"'\'''
test-expr 'date(` %z bar`)' '" 0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 0: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:"'\'''
test-expr 'date(`foo%z`)' '"foo0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo0:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo0: "'\'''
test-expr 'date(`foo%z `)' '"foo0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo0: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo0: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:"'\'''
test-expr 'date(`foo %z`)' '"foo 0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 0:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0: "'\'''
test-expr 'date(`foo %z `)' '"foo 0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 0: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"0:3"'\'''
test-expr 'date(`%z`)' '"0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"0:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"0:3bar"'\'''
test-expr 'date(`%zbar`)' '"0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"0:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"0:3 "'\'''
test-expr 'date(`%z `)' '"0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"0:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"0:3 bar"'\'''
test-expr 'date(`%z bar`)' '"0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"0:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 0:3"'\'''
test-expr 'date(` %z`)' '" 0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 0:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 0:3bar"'\'''
test-expr 'date(` %zbar`)' '" 0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 0:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 0:3 "'\'''
test-expr 'date(` %z `)' '" 0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 0:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 0:3 bar"'\'''
test-expr 'date(` %z bar`)' '" 0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 0:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:3"'\'''
test-expr 'date(`foo%z`)' '"foo0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo0:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo0:3 "'\'''
test-expr 'date(`foo%z `)' '"foo0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo0:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:3"'\'''
test-expr 'date(`foo %z`)' '"foo 0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 0:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0:3 "'\'''
test-expr 'date(`foo %z `)' '"foo 0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 0:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"0:44"'\'''
test-expr 'date(`%z`)' '"0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"0:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"0:44bar"'\'''
test-expr 'date(`%zbar`)' '"0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"0:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"0:44 "'\'''
test-expr 'date(`%z `)' '"0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"0:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"0:44 bar"'\'''
test-expr 'date(`%z bar`)' '"0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"0:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 0:44"'\'''
test-expr 'date(` %z`)' '" 0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 0:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 0:44bar"'\'''
test-expr 'date(` %zbar`)' '" 0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 0:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 0:44 "'\'''
test-expr 'date(` %z `)' '" 0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 0:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 0:44 bar"'\'''
test-expr 'date(` %z bar`)' '" 0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 0:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:44"'\'''
test-expr 'date(`foo%z`)' '"foo0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo0:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo0:44 "'\'''
test-expr 'date(`foo%z `)' '"foo0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo0:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:44"'\'''
test-expr 'date(`foo %z`)' '"foo 0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 0:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0:44 "'\'''
test-expr 'date(`foo %z `)' '"foo 0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 0:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"0:55"'\'''
test-expr 'date(`%z`)' '"0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"0:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"0:55bar"'\'''
test-expr 'date(`%zbar`)' '"0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"0:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"0:55 "'\'''
test-expr 'date(`%z `)' '"0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"0:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"0:55 bar"'\'''
test-expr 'date(`%z bar`)' '"0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"0:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 0:55"'\'''
test-expr 'date(` %z`)' '" 0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 0:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 0:55bar"'\'''
test-expr 'date(` %zbar`)' '" 0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 0:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 0:55 "'\'''
test-expr 'date(` %z `)' '" 0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 0:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 0:55 bar"'\'''
test-expr 'date(` %z bar`)' '" 0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 0:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo0:55"'\'''
test-expr 'date(`foo%z`)' '"foo0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo0:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo0:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo0:55 "'\'''
test-expr 'date(`foo%z `)' '"foo0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo0:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo0:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 0:55"'\'''
test-expr 'date(`foo %z`)' '"foo 0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 0:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 0:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 0:55 "'\'''
test-expr 'date(`foo %z `)' '"foo 0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 0:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 0:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"03"'\'''
test-expr 'date(`%z`)' '"03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"03"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"03bar"'\'''
test-expr 'date(`%zbar`)' '"03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"03bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"03 "'\'''
test-expr 'date(`%z `)' '"03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"03 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"03 bar"'\'''
test-expr 'date(`%z bar`)' '"03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"03 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 03"'\'''
test-expr 'date(` %z`)' '" 03"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 03"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 03bar"'\'''
test-expr 'date(` %zbar`)' '" 03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 03bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 03 "'\'''
test-expr 'date(` %z `)' '" 03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 03 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 03 bar"'\'''
test-expr 'date(` %z bar`)' '" 03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 03 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo03"'\'''
test-expr 'date(`foo%z`)' '"foo03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo03"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo03bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo03bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo03 "'\'''
test-expr 'date(`foo%z `)' '"foo03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo03 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo03 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo03 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 03"'\'''
test-expr 'date(`foo %z`)' '"foo 03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 03"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 03bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 03bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 03 "'\'''
test-expr 'date(`foo %z `)' '"foo 03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 03 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 03 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 03 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"11"'\'''
test-expr 'date(`%z`)' '"11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"11"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"11bar"'\'''
test-expr 'date(`%zbar`)' '"11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"11bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"11 "'\'''
test-expr 'date(`%z `)' '"11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"11 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"11 bar"'\'''
test-expr 'date(`%z bar`)' '"11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"11 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 11"'\'''
test-expr 'date(` %z`)' '" 11"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 11"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 11bar"'\'''
test-expr 'date(` %zbar`)' '" 11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 11bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 11 "'\'''
test-expr 'date(` %z `)' '" 11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 11 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 11 bar"'\'''
test-expr 'date(` %z bar`)' '" 11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 11 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo11"'\'''
test-expr 'date(`foo%z`)' '"foo11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo11"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo11bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo11 "'\'''
test-expr 'date(`foo%z `)' '"foo11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo11 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo11 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11"'\'''
test-expr 'date(`foo %z`)' '"foo 11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 11"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11 "'\'''
test-expr 'date(`foo %z `)' '"foo 11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 11 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"11:"'\'''
test-expr 'date(`%z`)' '"11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"11:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"11:bar"'\'''
test-expr 'date(`%zbar`)' '"11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"11:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"11: "'\'''
test-expr 'date(`%z `)' '"11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"11: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"11: bar"'\'''
test-expr 'date(`%z bar`)' '"11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"11: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 11:"'\'''
test-expr 'date(` %z`)' '" 11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 11:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 11:bar"'\'''
test-expr 'date(` %zbar`)' '" 11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 11:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 11: "'\'''
test-expr 'date(` %z `)' '" 11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 11: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 11: bar"'\'''
test-expr 'date(` %z bar`)' '" 11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 11: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:"'\'''
test-expr 'date(`foo%z`)' '"foo11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo11:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo11: "'\'''
test-expr 'date(`foo%z `)' '"foo11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo11: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo11: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:"'\'''
test-expr 'date(`foo %z`)' '"foo 11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 11:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11: "'\'''
test-expr 'date(`foo %z `)' '"foo 11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 11: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"11:3"'\'''
test-expr 'date(`%z`)' '"11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"11:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"11:3bar"'\'''
test-expr 'date(`%zbar`)' '"11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"11:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"11:3 "'\'''
test-expr 'date(`%z `)' '"11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"11:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"11:3 bar"'\'''
test-expr 'date(`%z bar`)' '"11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"11:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 11:3"'\'''
test-expr 'date(` %z`)' '" 11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 11:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 11:3bar"'\'''
test-expr 'date(` %zbar`)' '" 11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 11:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 11:3 "'\'''
test-expr 'date(` %z `)' '" 11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 11:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 11:3 bar"'\'''
test-expr 'date(` %z bar`)' '" 11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 11:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:3"'\'''
test-expr 'date(`foo%z`)' '"foo11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo11:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo11:3 "'\'''
test-expr 'date(`foo%z `)' '"foo11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo11:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:3"'\'''
test-expr 'date(`foo %z`)' '"foo 11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 11:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11:3 "'\'''
test-expr 'date(`foo %z `)' '"foo 11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 11:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"11:44"'\'''
test-expr 'date(`%z`)' '"11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"11:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"11:44bar"'\'''
test-expr 'date(`%zbar`)' '"11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"11:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"11:44 "'\'''
test-expr 'date(`%z `)' '"11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"11:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"11:44 bar"'\'''
test-expr 'date(`%z bar`)' '"11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"11:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 11:44"'\'''
test-expr 'date(` %z`)' '" 11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 11:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 11:44bar"'\'''
test-expr 'date(` %zbar`)' '" 11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 11:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 11:44 "'\'''
test-expr 'date(` %z `)' '" 11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 11:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 11:44 bar"'\'''
test-expr 'date(` %z bar`)' '" 11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 11:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:44"'\'''
test-expr 'date(`foo%z`)' '"foo11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo11:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo11:44 "'\'''
test-expr 'date(`foo%z `)' '"foo11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo11:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:44"'\'''
test-expr 'date(`foo %z`)' '"foo 11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 11:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11:44 "'\'''
test-expr 'date(`foo %z `)' '"foo 11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 11:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"11:55"'\'''
test-expr 'date(`%z`)' '"11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"11:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"11:55bar"'\'''
test-expr 'date(`%zbar`)' '"11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"11:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"11:55 "'\'''
test-expr 'date(`%z `)' '"11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"11:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"11:55 bar"'\'''
test-expr 'date(`%z bar`)' '"11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"11:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 11:55"'\'''
test-expr 'date(` %z`)' '" 11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 11:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 11:55bar"'\'''
test-expr 'date(` %zbar`)' '" 11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 11:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 11:55 "'\'''
test-expr 'date(` %z `)' '" 11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 11:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 11:55 bar"'\'''
test-expr 'date(` %z bar`)' '" 11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 11:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo11:55"'\'''
test-expr 'date(`foo%z`)' '"foo11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo11:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo11:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo11:55 "'\'''
test-expr 'date(`foo%z `)' '"foo11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo11:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo11:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 11:55"'\'''
test-expr 'date(`foo %z`)' '"foo 11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 11:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 11:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 11:55 "'\'''
test-expr 'date(`foo %z `)' '"foo 11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 11:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 11:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"044"'\'''
test-expr 'date(`%z`)' '"044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"044"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"044bar"'\'''
test-expr 'date(`%zbar`)' '"044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"044bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"044 "'\'''
test-expr 'date(`%z `)' '"044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"044 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"044 bar"'\'''
test-expr 'date(`%z bar`)' '"044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"044 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 044"'\'''
test-expr 'date(` %z`)' '" 044"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 044"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 044bar"'\'''
test-expr 'date(` %zbar`)' '" 044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 044bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 044 "'\'''
test-expr 'date(` %z `)' '" 044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 044 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 044 bar"'\'''
test-expr 'date(` %z bar`)' '" 044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 044 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo044"'\'''
test-expr 'date(`foo%z`)' '"foo044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo044"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo044bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo044bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo044 "'\'''
test-expr 'date(`foo%z `)' '"foo044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo044 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo044 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo044 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 044"'\'''
test-expr 'date(`foo %z`)' '"foo 044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 044"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 044bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 044bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 044 "'\'''
test-expr 'date(`foo %z `)' '"foo 044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 044 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 044 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 044 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"055"'\'''
test-expr 'date(`%z`)' '"055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"055"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"055bar"'\'''
test-expr 'date(`%zbar`)' '"055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"055bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"055 "'\'''
test-expr 'date(`%z `)' '"055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"055 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"055 bar"'\'''
test-expr 'date(`%z bar`)' '"055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"055 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 055"'\'''
test-expr 'date(` %z`)' '" 055"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 055"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 055bar"'\'''
test-expr 'date(` %zbar`)' '" 055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 055bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 055 "'\'''
test-expr 'date(` %z `)' '" 055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 055 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 055 bar"'\'''
test-expr 'date(` %z bar`)' '" 055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 055 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo055"'\'''
test-expr 'date(`foo%z`)' '"foo055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo055"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo055bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo055bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo055 "'\'''
test-expr 'date(`foo%z `)' '"foo055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo055 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo055 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo055 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 055"'\'''
test-expr 'date(`foo %z`)' '"foo 055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 055"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 055bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 055bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 055 "'\'''
test-expr 'date(`foo %z `)' '"foo 055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 055 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 055 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 055 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"113"'\'''
test-expr 'date(`%z`)' '"113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"113"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"113bar"'\'''
test-expr 'date(`%zbar`)' '"113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"113bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"113 "'\'''
test-expr 'date(`%z `)' '"113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"113 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"113 bar"'\'''
test-expr 'date(`%z bar`)' '"113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"113 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 113"'\'''
test-expr 'date(` %z`)' '" 113"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 113"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 113bar"'\'''
test-expr 'date(` %zbar`)' '" 113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 113bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 113 "'\'''
test-expr 'date(` %z `)' '" 113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 113 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 113 bar"'\'''
test-expr 'date(` %z bar`)' '" 113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 113 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo113"'\'''
test-expr 'date(`foo%z`)' '"foo113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo113"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo113bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo113bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo113 "'\'''
test-expr 'date(`foo%z `)' '"foo113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo113 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo113 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo113 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 113"'\'''
test-expr 'date(`foo %z`)' '"foo 113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 113"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 113bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 113bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 113 "'\'''
test-expr 'date(`foo %z `)' '"foo 113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 113 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 113 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 113 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"222"'\'''
test-expr 'date(`%z`)' '"222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"222"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"222bar"'\'''
test-expr 'date(`%zbar`)' '"222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"222bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"222 "'\'''
test-expr 'date(`%z `)' '"222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"222 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"222 bar"'\'''
test-expr 'date(`%z bar`)' '"222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"222 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 222"'\'''
test-expr 'date(` %z`)' '" 222"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 222"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 222bar"'\'''
test-expr 'date(` %zbar`)' '" 222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 222bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 222 "'\'''
test-expr 'date(` %z `)' '" 222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 222 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 222 bar"'\'''
test-expr 'date(` %z bar`)' '" 222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 222 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo222"'\'''
test-expr 'date(`foo%z`)' '"foo222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo222"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo222bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo222 "'\'''
test-expr 'date(`foo%z `)' '"foo222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo222 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo222 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222"'\'''
test-expr 'date(`foo %z`)' '"foo 222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 222"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222 "'\'''
test-expr 'date(`foo %z `)' '"foo 222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 222 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"222:"'\'''
test-expr 'date(`%z`)' '"222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"222:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"222:bar"'\'''
test-expr 'date(`%zbar`)' '"222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"222:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"222: "'\'''
test-expr 'date(`%z `)' '"222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"222: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"222: bar"'\'''
test-expr 'date(`%z bar`)' '"222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"222: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 222:"'\'''
test-expr 'date(` %z`)' '" 222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 222:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 222:bar"'\'''
test-expr 'date(` %zbar`)' '" 222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 222:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 222: "'\'''
test-expr 'date(` %z `)' '" 222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 222: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 222: bar"'\'''
test-expr 'date(` %z bar`)' '" 222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 222: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:"'\'''
test-expr 'date(`foo%z`)' '"foo222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo222:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo222: "'\'''
test-expr 'date(`foo%z `)' '"foo222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo222: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo222: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:"'\'''
test-expr 'date(`foo %z`)' '"foo 222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 222:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222: "'\'''
test-expr 'date(`foo %z `)' '"foo 222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 222: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"222:3"'\'''
test-expr 'date(`%z`)' '"222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"222:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"222:3bar"'\'''
test-expr 'date(`%zbar`)' '"222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"222:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"222:3 "'\'''
test-expr 'date(`%z `)' '"222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"222:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"222:3 bar"'\'''
test-expr 'date(`%z bar`)' '"222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"222:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 222:3"'\'''
test-expr 'date(` %z`)' '" 222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 222:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 222:3bar"'\'''
test-expr 'date(` %zbar`)' '" 222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 222:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 222:3 "'\'''
test-expr 'date(` %z `)' '" 222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 222:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 222:3 bar"'\'''
test-expr 'date(` %z bar`)' '" 222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 222:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:3"'\'''
test-expr 'date(`foo%z`)' '"foo222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo222:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo222:3 "'\'''
test-expr 'date(`foo%z `)' '"foo222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo222:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:3"'\'''
test-expr 'date(`foo %z`)' '"foo 222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 222:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222:3 "'\'''
test-expr 'date(`foo %z `)' '"foo 222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 222:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"222:44"'\'''
test-expr 'date(`%z`)' '"222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"222:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"222:44bar"'\'''
test-expr 'date(`%zbar`)' '"222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"222:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"222:44 "'\'''
test-expr 'date(`%z `)' '"222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"222:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"222:44 bar"'\'''
test-expr 'date(`%z bar`)' '"222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"222:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 222:44"'\'''
test-expr 'date(` %z`)' '" 222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 222:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 222:44bar"'\'''
test-expr 'date(` %zbar`)' '" 222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 222:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 222:44 "'\'''
test-expr 'date(` %z `)' '" 222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 222:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 222:44 bar"'\'''
test-expr 'date(` %z bar`)' '" 222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 222:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:44"'\'''
test-expr 'date(`foo%z`)' '"foo222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo222:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo222:44 "'\'''
test-expr 'date(`foo%z `)' '"foo222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo222:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:44"'\'''
test-expr 'date(`foo %z`)' '"foo 222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 222:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222:44 "'\'''
test-expr 'date(`foo %z `)' '"foo 222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 222:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"222:55"'\'''
test-expr 'date(`%z`)' '"222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"222:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"222:55bar"'\'''
test-expr 'date(`%zbar`)' '"222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"222:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"222:55 "'\'''
test-expr 'date(`%z `)' '"222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"222:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"222:55 bar"'\'''
test-expr 'date(`%z bar`)' '"222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"222:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 222:55"'\'''
test-expr 'date(` %z`)' '" 222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 222:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 222:55bar"'\'''
test-expr 'date(` %zbar`)' '" 222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 222:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 222:55 "'\'''
test-expr 'date(` %z `)' '" 222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 222:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 222:55 bar"'\'''
test-expr 'date(` %z bar`)' '" 222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 222:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo222:55"'\'''
test-expr 'date(`foo%z`)' '"foo222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo222:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo222:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo222:55 "'\'''
test-expr 'date(`foo%z `)' '"foo222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo222:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo222:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 222:55"'\'''
test-expr 'date(`foo %z`)' '"foo 222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 222:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 222:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 222:55 "'\'''
test-expr 'date(`foo %z `)' '"foo 222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 222:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 222:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"1144"'\'''
test-expr 'date(`%z`)' '"1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"1144"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"1144bar"'\'''
test-expr 'date(`%zbar`)' '"1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"1144bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"1144 "'\'''
test-expr 'date(`%z `)' '"1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"1144 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"1144 bar"'\'''
test-expr 'date(`%z bar`)' '"1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"1144 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 1144"'\'''
test-expr 'date(` %z`)' '" 1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 1144"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 1144bar"'\'''
test-expr 'date(` %zbar`)' '" 1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 1144bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 1144 "'\'''
test-expr 'date(` %z `)' '" 1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 1144 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 1144 bar"'\'''
test-expr 'date(` %z bar`)' '" 1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 1144 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo1144"'\'''
test-expr 'date(`foo%z`)' '"foo1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo1144"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo1144bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo1144bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo1144 "'\'''
test-expr 'date(`foo%z `)' '"foo1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo1144 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo1144 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo1144 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 1144"'\'''
test-expr 'date(`foo %z`)' '"foo 1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 1144"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 1144bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 1144bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 1144 "'\'''
test-expr 'date(`foo %z `)' '"foo 1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 1144 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 1144 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 1144 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"1155"'\'''
test-expr 'date(`%z`)' '"1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"1155"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"1155bar"'\'''
test-expr 'date(`%zbar`)' '"1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"1155bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"1155 "'\'''
test-expr 'date(`%z `)' '"1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"1155 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"1155 bar"'\'''
test-expr 'date(`%z bar`)' '"1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"1155 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 1155"'\'''
test-expr 'date(` %z`)' '" 1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 1155"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 1155bar"'\'''
test-expr 'date(` %zbar`)' '" 1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 1155bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 1155 "'\'''
test-expr 'date(` %z `)' '" 1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 1155 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 1155 bar"'\'''
test-expr 'date(` %z bar`)' '" 1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 1155 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo1155"'\'''
test-expr 'date(`foo%z`)' '"foo1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo1155"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo1155bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo1155bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo1155 "'\'''
test-expr 'date(`foo%z `)' '"foo1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo1155 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo1155 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo1155 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 1155"'\'''
test-expr 'date(`foo %z`)' '"foo 1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 1155"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 1155bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 1155bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 1155 "'\'''
test-expr 'date(`foo %z `)' '"foo 1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 1155 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 1155 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 1155 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"2223"'\'''
test-expr 'date(`%z`)' '"2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"2223"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"2223bar"'\'''
test-expr 'date(`%zbar`)' '"2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"2223bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"2223 "'\'''
test-expr 'date(`%z `)' '"2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"2223 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"2223 bar"'\'''
test-expr 'date(`%z bar`)' '"2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"2223 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 2223"'\'''
test-expr 'date(` %z`)' '" 2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 2223"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 2223bar"'\'''
test-expr 'date(` %zbar`)' '" 2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 2223bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 2223 "'\'''
test-expr 'date(` %z `)' '" 2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 2223 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 2223 bar"'\'''
test-expr 'date(` %z bar`)' '" 2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 2223 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo2223"'\'''
test-expr 'date(`foo%z`)' '"foo2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo2223"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo2223bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo2223bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo2223 "'\'''
test-expr 'date(`foo%z `)' '"foo2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo2223 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo2223 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo2223 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 2223"'\'''
test-expr 'date(`foo %z`)' '"foo 2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 2223"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 2223bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 2223bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 2223 "'\'''
test-expr 'date(`foo %z `)' '"foo 2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 2223 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 2223 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 2223 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"22244"'\'''
test-expr 'date(`%z`)' '"22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"22244"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"22244bar"'\'''
test-expr 'date(`%zbar`)' '"22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"22244bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"22244 "'\'''
test-expr 'date(`%z `)' '"22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"22244 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"22244 bar"'\'''
test-expr 'date(`%z bar`)' '"22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"22244 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 22244"'\'''
test-expr 'date(` %z`)' '" 22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 22244"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 22244bar"'\'''
test-expr 'date(` %zbar`)' '" 22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 22244bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 22244 "'\'''
test-expr 'date(` %z `)' '" 22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 22244 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 22244 bar"'\'''
test-expr 'date(` %z bar`)' '" 22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 22244 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo22244"'\'''
test-expr 'date(`foo%z`)' '"foo22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo22244"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo22244bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo22244bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo22244 "'\'''
test-expr 'date(`foo%z `)' '"foo22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo22244 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo22244 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo22244 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 22244"'\'''
test-expr 'date(`foo %z`)' '"foo 22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 22244"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 22244bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 22244bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 22244 "'\'''
test-expr 'date(`foo %z `)' '"foo 22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 22244 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 22244 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 22244 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"22255"'\'''
test-expr 'date(`%z`)' '"22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"22255"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"22255bar"'\'''
test-expr 'date(`%zbar`)' '"22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"22255bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"22255 "'\'''
test-expr 'date(`%z `)' '"22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"22255 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"22255 bar"'\'''
test-expr 'date(`%z bar`)' '"22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"22255 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" 22255"'\'''
test-expr 'date(` %z`)' '" 22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" 22255"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" 22255bar"'\'''
test-expr 'date(` %zbar`)' '" 22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" 22255bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" 22255 "'\'''
test-expr 'date(` %z `)' '" 22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" 22255 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" 22255 bar"'\'''
test-expr 'date(` %z bar`)' '" 22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" 22255 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo22255"'\'''
test-expr 'date(`foo%z`)' '"foo22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo22255"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo22255bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo22255bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo22255 "'\'''
test-expr 'date(`foo%z `)' '"foo22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo22255 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo22255 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo22255 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo 22255"'\'''
test-expr 'date(`foo %z`)' '"foo 22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo 22255"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo 22255bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo 22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo 22255bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo 22255 "'\'''
test-expr 'date(`foo %z `)' '"foo 22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo 22255 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo 22255 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo 22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo 22255 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"Z"'\'''
test-expr 'date(`%z`)' '"Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"Z"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"Zbar"'\'''
test-expr 'date(`%zbar`)' '"Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"Zbar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"Z "'\'''
test-expr 'date(`%z `)' '"Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"Z "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"Z bar"'\'''
test-expr 'date(`%z bar`)' '"Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"Z bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" Z"'\'''
test-expr 'date(` %z`)' '" Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" Z"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" Zbar"'\'''
test-expr 'date(` %zbar`)' '" Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" Zbar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" Z "'\'''
test-expr 'date(` %z `)' '" Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" Z "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" Z bar"'\'''
test-expr 'date(` %z bar`)' '" Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" Z bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"fooZ"'\'''
test-expr 'date(`foo%z`)' '"fooZ"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"fooZ"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"fooZbar"'\'''
test-expr 'date(`foo%zbar`)' '"fooZbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"fooZbar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"fooZ "'\'''
test-expr 'date(`foo%z `)' '"fooZ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"fooZ "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"fooZ bar"'\'''
test-expr 'date(`foo%z bar`)' '"fooZ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"fooZ bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo Z"'\'''
test-expr 'date(`foo %z`)' '"foo Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo Z"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo Zbar"'\'''
test-expr 'date(`foo %zbar`)' '"foo Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo Zbar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo Z "'\'''
test-expr 'date(`foo %z `)' '"foo Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo Z "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo Z bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo Z bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+"'\'''
test-expr 'date(`%z`)' '"+"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+bar"'\'''
test-expr 'date(`%zbar`)' '"+bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+ "'\'''
test-expr 'date(`%z `)' '"+ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+ "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+ bar"'\'''
test-expr 'date(`%z bar`)' '"+ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+ bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +"'\'''
test-expr 'date(` %z`)' '" +"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +bar"'\'''
test-expr 'date(` %zbar`)' '" +bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" + "'\'''
test-expr 'date(` %z `)' '" + "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" + "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" + bar"'\'''
test-expr 'date(` %z bar`)' '" + bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" + bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+"'\'''
test-expr 'date(`foo%z`)' '"foo+"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+ "'\'''
test-expr 'date(`foo%z `)' '"foo+ "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+ "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+ bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+ bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+ bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +"'\'''
test-expr 'date(`foo %z`)' '"foo +"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo + "'\'''
test-expr 'date(`foo %z `)' '"foo + "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo + "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo + bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo + bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo + bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+0"'\'''
test-expr 'date(`%z`)' '"+0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+0"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+0bar"'\'''
test-expr 'date(`%zbar`)' '"+0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+0bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+0 "'\'''
test-expr 'date(`%z `)' '"+0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+0 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+0 bar"'\'''
test-expr 'date(`%z bar`)' '"+0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+0 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +0"'\'''
test-expr 'date(` %z`)' '" +0"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +0"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +0bar"'\'''
test-expr 'date(` %zbar`)' '" +0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +0bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +0 "'\'''
test-expr 'date(` %z `)' '" +0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +0 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +0 bar"'\'''
test-expr 'date(` %z bar`)' '" +0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +0 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0"'\'''
test-expr 'date(`foo%z`)' '"foo+0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+0"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0 "'\'''
test-expr 'date(`foo%z `)' '"foo+0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+0 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0"'\'''
test-expr 'date(`foo %z`)' '"foo +0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +0"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0 "'\'''
test-expr 'date(`foo %z `)' '"foo +0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +0 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+0:"'\'''
test-expr 'date(`%z`)' '"+0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+0:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+0:bar"'\'''
test-expr 'date(`%zbar`)' '"+0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+0:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+0: "'\'''
test-expr 'date(`%z `)' '"+0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+0: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+0: bar"'\'''
test-expr 'date(`%z bar`)' '"+0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+0: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +0:"'\'''
test-expr 'date(` %z`)' '" +0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +0:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +0:bar"'\'''
test-expr 'date(` %zbar`)' '" +0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +0:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +0: "'\'''
test-expr 'date(` %z `)' '" +0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +0: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +0: bar"'\'''
test-expr 'date(` %z bar`)' '" +0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +0: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:"'\'''
test-expr 'date(`foo%z`)' '"foo+0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+0:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0: "'\'''
test-expr 'date(`foo%z `)' '"foo+0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+0: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:"'\'''
test-expr 'date(`foo %z`)' '"foo +0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +0:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0: "'\'''
test-expr 'date(`foo %z `)' '"foo +0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +0: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+0:3"'\'''
test-expr 'date(`%z`)' '"+0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+0:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+0:3bar"'\'''
test-expr 'date(`%zbar`)' '"+0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+0:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+0:3 "'\'''
test-expr 'date(`%z `)' '"+0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+0:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+0:3 bar"'\'''
test-expr 'date(`%z bar`)' '"+0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+0:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +0:3"'\'''
test-expr 'date(` %z`)' '" +0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +0:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +0:3bar"'\'''
test-expr 'date(` %zbar`)' '" +0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +0:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +0:3 "'\'''
test-expr 'date(` %z `)' '" +0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +0:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +0:3 bar"'\'''
test-expr 'date(` %z bar`)' '" +0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +0:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:3"'\'''
test-expr 'date(`foo%z`)' '"foo+0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+0:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0:3 "'\'''
test-expr 'date(`foo%z `)' '"foo+0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+0:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:3"'\'''
test-expr 'date(`foo %z`)' '"foo +0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +0:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0:3 "'\'''
test-expr 'date(`foo %z `)' '"foo +0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +0:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+0:44"'\'''
test-expr 'date(`%z`)' '"+0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+0:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+0:44bar"'\'''
test-expr 'date(`%zbar`)' '"+0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+0:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+0:44 "'\'''
test-expr 'date(`%z `)' '"+0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+0:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+0:44 bar"'\'''
test-expr 'date(`%z bar`)' '"+0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+0:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +0:44"'\'''
test-expr 'date(` %z`)' '" +0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +0:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +0:44bar"'\'''
test-expr 'date(` %zbar`)' '" +0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +0:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +0:44 "'\'''
test-expr 'date(` %z `)' '" +0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +0:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +0:44 bar"'\'''
test-expr 'date(` %z bar`)' '" +0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +0:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:44"'\'''
test-expr 'date(`foo%z`)' '"foo+0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+0:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0:44 "'\'''
test-expr 'date(`foo%z `)' '"foo+0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+0:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:44"'\'''
test-expr 'date(`foo %z`)' '"foo +0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +0:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0:44 "'\'''
test-expr 'date(`foo %z `)' '"foo +0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +0:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+0:55"'\'''
test-expr 'date(`%z`)' '"+0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+0:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+0:55bar"'\'''
test-expr 'date(`%zbar`)' '"+0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+0:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+0:55 "'\'''
test-expr 'date(`%z `)' '"+0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+0:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+0:55 bar"'\'''
test-expr 'date(`%z bar`)' '"+0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+0:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +0:55"'\'''
test-expr 'date(` %z`)' '" +0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +0:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +0:55bar"'\'''
test-expr 'date(` %zbar`)' '" +0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +0:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +0:55 "'\'''
test-expr 'date(` %z `)' '" +0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +0:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +0:55 bar"'\'''
test-expr 'date(` %z bar`)' '" +0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +0:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+0:55"'\'''
test-expr 'date(`foo%z`)' '"foo+0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+0:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+0:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+0:55 "'\'''
test-expr 'date(`foo%z `)' '"foo+0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+0:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+0:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +0:55"'\'''
test-expr 'date(`foo %z`)' '"foo +0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +0:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +0:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +0:55 "'\'''
test-expr 'date(`foo %z `)' '"foo +0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +0:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +0:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+03"'\'''
test-expr 'date(`%z`)' '"+03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+03"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+03bar"'\'''
test-expr 'date(`%zbar`)' '"+03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+03bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+03 "'\'''
test-expr 'date(`%z `)' '"+03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+03 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+03 bar"'\'''
test-expr 'date(`%z bar`)' '"+03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+03 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +03"'\'''
test-expr 'date(` %z`)' '" +03"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +03"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +03bar"'\'''
test-expr 'date(` %zbar`)' '" +03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +03bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +03 "'\'''
test-expr 'date(` %z `)' '" +03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +03 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +03 bar"'\'''
test-expr 'date(` %z bar`)' '" +03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +03 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+03"'\'''
test-expr 'date(`foo%z`)' '"foo+03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+03"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+03bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+03bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+03 "'\'''
test-expr 'date(`foo%z `)' '"foo+03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+03 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+03 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+03 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +03"'\'''
test-expr 'date(`foo %z`)' '"foo +03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +03"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +03bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +03bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +03 "'\'''
test-expr 'date(`foo %z `)' '"foo +03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +03 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +03 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +03 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+11"'\'''
test-expr 'date(`%z`)' '"+11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+11"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+11bar"'\'''
test-expr 'date(`%zbar`)' '"+11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+11bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+11 "'\'''
test-expr 'date(`%z `)' '"+11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+11 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+11 bar"'\'''
test-expr 'date(`%z bar`)' '"+11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+11 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +11"'\'''
test-expr 'date(` %z`)' '" +11"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +11"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +11bar"'\'''
test-expr 'date(` %zbar`)' '" +11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +11bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +11 "'\'''
test-expr 'date(` %z `)' '" +11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +11 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +11 bar"'\'''
test-expr 'date(` %z bar`)' '" +11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +11 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11"'\'''
test-expr 'date(`foo%z`)' '"foo+11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+11"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11 "'\'''
test-expr 'date(`foo%z `)' '"foo+11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+11 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11"'\'''
test-expr 'date(`foo %z`)' '"foo +11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +11"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11 "'\'''
test-expr 'date(`foo %z `)' '"foo +11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +11 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+11:"'\'''
test-expr 'date(`%z`)' '"+11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+11:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+11:bar"'\'''
test-expr 'date(`%zbar`)' '"+11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+11:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+11: "'\'''
test-expr 'date(`%z `)' '"+11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+11: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+11: bar"'\'''
test-expr 'date(`%z bar`)' '"+11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+11: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +11:"'\'''
test-expr 'date(` %z`)' '" +11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +11:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +11:bar"'\'''
test-expr 'date(` %zbar`)' '" +11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +11:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +11: "'\'''
test-expr 'date(` %z `)' '" +11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +11: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +11: bar"'\'''
test-expr 'date(` %z bar`)' '" +11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +11: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:"'\'''
test-expr 'date(`foo%z`)' '"foo+11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+11:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11: "'\'''
test-expr 'date(`foo%z `)' '"foo+11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+11: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:"'\'''
test-expr 'date(`foo %z`)' '"foo +11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +11:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11: "'\'''
test-expr 'date(`foo %z `)' '"foo +11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +11: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+11:3"'\'''
test-expr 'date(`%z`)' '"+11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+11:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+11:3bar"'\'''
test-expr 'date(`%zbar`)' '"+11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+11:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+11:3 "'\'''
test-expr 'date(`%z `)' '"+11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+11:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+11:3 bar"'\'''
test-expr 'date(`%z bar`)' '"+11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+11:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +11:3"'\'''
test-expr 'date(` %z`)' '" +11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +11:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +11:3bar"'\'''
test-expr 'date(` %zbar`)' '" +11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +11:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +11:3 "'\'''
test-expr 'date(` %z `)' '" +11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +11:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +11:3 bar"'\'''
test-expr 'date(` %z bar`)' '" +11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +11:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:3"'\'''
test-expr 'date(`foo%z`)' '"foo+11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+11:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11:3 "'\'''
test-expr 'date(`foo%z `)' '"foo+11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+11:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:3"'\'''
test-expr 'date(`foo %z`)' '"foo +11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +11:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11:3 "'\'''
test-expr 'date(`foo %z `)' '"foo +11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +11:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+11:44"'\'''
test-expr 'date(`%z`)' '"+11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+11:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+11:44bar"'\'''
test-expr 'date(`%zbar`)' '"+11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+11:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+11:44 "'\'''
test-expr 'date(`%z `)' '"+11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+11:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+11:44 bar"'\'''
test-expr 'date(`%z bar`)' '"+11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+11:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +11:44"'\'''
test-expr 'date(` %z`)' '" +11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +11:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +11:44bar"'\'''
test-expr 'date(` %zbar`)' '" +11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +11:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +11:44 "'\'''
test-expr 'date(` %z `)' '" +11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +11:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +11:44 bar"'\'''
test-expr 'date(` %z bar`)' '" +11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +11:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:44"'\'''
test-expr 'date(`foo%z`)' '"foo+11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+11:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11:44 "'\'''
test-expr 'date(`foo%z `)' '"foo+11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+11:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:44"'\'''
test-expr 'date(`foo %z`)' '"foo +11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +11:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11:44 "'\'''
test-expr 'date(`foo %z `)' '"foo +11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +11:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+11:55"'\'''
test-expr 'date(`%z`)' '"+11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+11:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+11:55bar"'\'''
test-expr 'date(`%zbar`)' '"+11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+11:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+11:55 "'\'''
test-expr 'date(`%z `)' '"+11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+11:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+11:55 bar"'\'''
test-expr 'date(`%z bar`)' '"+11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+11:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +11:55"'\'''
test-expr 'date(` %z`)' '" +11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +11:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +11:55bar"'\'''
test-expr 'date(` %zbar`)' '" +11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +11:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +11:55 "'\'''
test-expr 'date(` %z `)' '" +11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +11:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +11:55 bar"'\'''
test-expr 'date(` %z bar`)' '" +11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +11:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+11:55"'\'''
test-expr 'date(`foo%z`)' '"foo+11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+11:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+11:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+11:55 "'\'''
test-expr 'date(`foo%z `)' '"foo+11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+11:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+11:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +11:55"'\'''
test-expr 'date(`foo %z`)' '"foo +11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +11:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +11:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +11:55 "'\'''
test-expr 'date(`foo %z `)' '"foo +11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +11:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +11:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+044"'\'''
test-expr 'date(`%z`)' '"+044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+044"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+044bar"'\'''
test-expr 'date(`%zbar`)' '"+044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+044bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+044 "'\'''
test-expr 'date(`%z `)' '"+044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+044 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+044 bar"'\'''
test-expr 'date(`%z bar`)' '"+044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+044 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +044"'\'''
test-expr 'date(` %z`)' '" +044"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +044"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +044bar"'\'''
test-expr 'date(` %zbar`)' '" +044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +044bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +044 "'\'''
test-expr 'date(` %z `)' '" +044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +044 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +044 bar"'\'''
test-expr 'date(` %z bar`)' '" +044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +044 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+044"'\'''
test-expr 'date(`foo%z`)' '"foo+044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+044"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+044bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+044bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+044 "'\'''
test-expr 'date(`foo%z `)' '"foo+044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+044 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+044 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+044 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +044"'\'''
test-expr 'date(`foo %z`)' '"foo +044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +044"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +044bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +044bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +044 "'\'''
test-expr 'date(`foo %z `)' '"foo +044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +044 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +044 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +044 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+055"'\'''
test-expr 'date(`%z`)' '"+055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+055"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+055bar"'\'''
test-expr 'date(`%zbar`)' '"+055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+055bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+055 "'\'''
test-expr 'date(`%z `)' '"+055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+055 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+055 bar"'\'''
test-expr 'date(`%z bar`)' '"+055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+055 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +055"'\'''
test-expr 'date(` %z`)' '" +055"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +055"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +055bar"'\'''
test-expr 'date(` %zbar`)' '" +055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +055bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +055 "'\'''
test-expr 'date(` %z `)' '" +055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +055 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +055 bar"'\'''
test-expr 'date(` %z bar`)' '" +055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +055 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+055"'\'''
test-expr 'date(`foo%z`)' '"foo+055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+055"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+055bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+055bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+055 "'\'''
test-expr 'date(`foo%z `)' '"foo+055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+055 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+055 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+055 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +055"'\'''
test-expr 'date(`foo %z`)' '"foo +055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +055"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +055bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +055bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +055 "'\'''
test-expr 'date(`foo %z `)' '"foo +055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +055 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +055 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +055 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+113"'\'''
test-expr 'date(`%z`)' '"+113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+113"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+113bar"'\'''
test-expr 'date(`%zbar`)' '"+113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+113bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+113 "'\'''
test-expr 'date(`%z `)' '"+113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+113 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+113 bar"'\'''
test-expr 'date(`%z bar`)' '"+113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+113 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +113"'\'''
test-expr 'date(` %z`)' '" +113"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +113"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +113bar"'\'''
test-expr 'date(` %zbar`)' '" +113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +113bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +113 "'\'''
test-expr 'date(` %z `)' '" +113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +113 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +113 bar"'\'''
test-expr 'date(` %z bar`)' '" +113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +113 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+113"'\'''
test-expr 'date(`foo%z`)' '"foo+113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+113"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+113bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+113bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+113 "'\'''
test-expr 'date(`foo%z `)' '"foo+113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+113 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+113 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+113 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +113"'\'''
test-expr 'date(`foo %z`)' '"foo +113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +113"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +113bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +113bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +113 "'\'''
test-expr 'date(`foo %z `)' '"foo +113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +113 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +113 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +113 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+222"'\'''
test-expr 'date(`%z`)' '"+222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+222"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+222bar"'\'''
test-expr 'date(`%zbar`)' '"+222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+222bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+222 "'\'''
test-expr 'date(`%z `)' '"+222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+222 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+222 bar"'\'''
test-expr 'date(`%z bar`)' '"+222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+222 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +222"'\'''
test-expr 'date(` %z`)' '" +222"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +222"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +222bar"'\'''
test-expr 'date(` %zbar`)' '" +222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +222bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +222 "'\'''
test-expr 'date(` %z `)' '" +222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +222 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +222 bar"'\'''
test-expr 'date(` %z bar`)' '" +222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +222 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222"'\'''
test-expr 'date(`foo%z`)' '"foo+222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+222"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222 "'\'''
test-expr 'date(`foo%z `)' '"foo+222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+222 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222"'\'''
test-expr 'date(`foo %z`)' '"foo +222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +222"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222 "'\'''
test-expr 'date(`foo %z `)' '"foo +222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +222 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+222:"'\'''
test-expr 'date(`%z`)' '"+222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+222:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+222:bar"'\'''
test-expr 'date(`%zbar`)' '"+222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+222:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+222: "'\'''
test-expr 'date(`%z `)' '"+222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+222: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+222: bar"'\'''
test-expr 'date(`%z bar`)' '"+222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+222: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +222:"'\'''
test-expr 'date(` %z`)' '" +222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +222:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +222:bar"'\'''
test-expr 'date(` %zbar`)' '" +222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +222:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +222: "'\'''
test-expr 'date(` %z `)' '" +222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +222: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +222: bar"'\'''
test-expr 'date(` %z bar`)' '" +222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +222: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:"'\'''
test-expr 'date(`foo%z`)' '"foo+222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+222:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222: "'\'''
test-expr 'date(`foo%z `)' '"foo+222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+222: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:"'\'''
test-expr 'date(`foo %z`)' '"foo +222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +222:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222: "'\'''
test-expr 'date(`foo %z `)' '"foo +222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +222: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+222:3"'\'''
test-expr 'date(`%z`)' '"+222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+222:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+222:3bar"'\'''
test-expr 'date(`%zbar`)' '"+222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+222:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+222:3 "'\'''
test-expr 'date(`%z `)' '"+222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+222:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+222:3 bar"'\'''
test-expr 'date(`%z bar`)' '"+222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+222:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +222:3"'\'''
test-expr 'date(` %z`)' '" +222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +222:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +222:3bar"'\'''
test-expr 'date(` %zbar`)' '" +222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +222:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +222:3 "'\'''
test-expr 'date(` %z `)' '" +222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +222:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +222:3 bar"'\'''
test-expr 'date(` %z bar`)' '" +222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +222:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:3"'\'''
test-expr 'date(`foo%z`)' '"foo+222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+222:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222:3 "'\'''
test-expr 'date(`foo%z `)' '"foo+222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+222:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:3"'\'''
test-expr 'date(`foo %z`)' '"foo +222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +222:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222:3 "'\'''
test-expr 'date(`foo %z `)' '"foo +222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +222:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+222:44"'\'''
test-expr 'date(`%z`)' '"+222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+222:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+222:44bar"'\'''
test-expr 'date(`%zbar`)' '"+222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+222:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+222:44 "'\'''
test-expr 'date(`%z `)' '"+222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+222:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+222:44 bar"'\'''
test-expr 'date(`%z bar`)' '"+222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+222:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +222:44"'\'''
test-expr 'date(` %z`)' '" +222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +222:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +222:44bar"'\'''
test-expr 'date(` %zbar`)' '" +222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +222:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +222:44 "'\'''
test-expr 'date(` %z `)' '" +222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +222:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +222:44 bar"'\'''
test-expr 'date(` %z bar`)' '" +222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +222:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:44"'\'''
test-expr 'date(`foo%z`)' '"foo+222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+222:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222:44 "'\'''
test-expr 'date(`foo%z `)' '"foo+222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+222:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:44"'\'''
test-expr 'date(`foo %z`)' '"foo +222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +222:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222:44 "'\'''
test-expr 'date(`foo %z `)' '"foo +222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +222:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+222:55"'\'''
test-expr 'date(`%z`)' '"+222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+222:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+222:55bar"'\'''
test-expr 'date(`%zbar`)' '"+222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+222:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+222:55 "'\'''
test-expr 'date(`%z `)' '"+222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+222:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+222:55 bar"'\'''
test-expr 'date(`%z bar`)' '"+222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+222:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +222:55"'\'''
test-expr 'date(` %z`)' '" +222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +222:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +222:55bar"'\'''
test-expr 'date(` %zbar`)' '" +222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +222:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +222:55 "'\'''
test-expr 'date(` %z `)' '" +222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +222:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +222:55 bar"'\'''
test-expr 'date(` %z bar`)' '" +222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +222:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+222:55"'\'''
test-expr 'date(`foo%z`)' '"foo+222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+222:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+222:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+222:55 "'\'''
test-expr 'date(`foo%z `)' '"foo+222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+222:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+222:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +222:55"'\'''
test-expr 'date(`foo %z`)' '"foo +222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +222:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +222:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +222:55 "'\'''
test-expr 'date(`foo %z `)' '"foo +222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +222:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +222:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+1144"'\'''
test-expr 'date(`%z`)' '"+1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+1144"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+1144bar"'\'''
test-expr 'date(`%zbar`)' '"+1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+1144bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+1144 "'\'''
test-expr 'date(`%z `)' '"+1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+1144 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+1144 bar"'\'''
test-expr 'date(`%z bar`)' '"+1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+1144 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +1144"'\'''
test-expr 'date(` %z`)' '" +1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +1144"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +1144bar"'\'''
test-expr 'date(` %zbar`)' '" +1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +1144bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +1144 "'\'''
test-expr 'date(` %z `)' '" +1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +1144 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +1144 bar"'\'''
test-expr 'date(` %z bar`)' '" +1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +1144 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+1144"'\'''
test-expr 'date(`foo%z`)' '"foo+1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+1144"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+1144bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+1144bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+1144 "'\'''
test-expr 'date(`foo%z `)' '"foo+1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+1144 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+1144 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+1144 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +1144"'\'''
test-expr 'date(`foo %z`)' '"foo +1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +1144"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +1144bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +1144bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +1144 "'\'''
test-expr 'date(`foo %z `)' '"foo +1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +1144 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +1144 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +1144 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+1155"'\'''
test-expr 'date(`%z`)' '"+1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+1155"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+1155bar"'\'''
test-expr 'date(`%zbar`)' '"+1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+1155bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+1155 "'\'''
test-expr 'date(`%z `)' '"+1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+1155 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+1155 bar"'\'''
test-expr 'date(`%z bar`)' '"+1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+1155 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +1155"'\'''
test-expr 'date(` %z`)' '" +1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +1155"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +1155bar"'\'''
test-expr 'date(` %zbar`)' '" +1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +1155bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +1155 "'\'''
test-expr 'date(` %z `)' '" +1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +1155 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +1155 bar"'\'''
test-expr 'date(` %z bar`)' '" +1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +1155 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+1155"'\'''
test-expr 'date(`foo%z`)' '"foo+1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+1155"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+1155bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+1155bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+1155 "'\'''
test-expr 'date(`foo%z `)' '"foo+1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+1155 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+1155 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+1155 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +1155"'\'''
test-expr 'date(`foo %z`)' '"foo +1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +1155"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +1155bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +1155bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +1155 "'\'''
test-expr 'date(`foo %z `)' '"foo +1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +1155 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +1155 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +1155 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+2223"'\'''
test-expr 'date(`%z`)' '"+2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+2223"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+2223bar"'\'''
test-expr 'date(`%zbar`)' '"+2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+2223bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+2223 "'\'''
test-expr 'date(`%z `)' '"+2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+2223 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+2223 bar"'\'''
test-expr 'date(`%z bar`)' '"+2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+2223 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +2223"'\'''
test-expr 'date(` %z`)' '" +2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +2223"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +2223bar"'\'''
test-expr 'date(` %zbar`)' '" +2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +2223bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +2223 "'\'''
test-expr 'date(` %z `)' '" +2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +2223 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +2223 bar"'\'''
test-expr 'date(` %z bar`)' '" +2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +2223 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+2223"'\'''
test-expr 'date(`foo%z`)' '"foo+2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+2223"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+2223bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+2223bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+2223 "'\'''
test-expr 'date(`foo%z `)' '"foo+2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+2223 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+2223 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+2223 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +2223"'\'''
test-expr 'date(`foo %z`)' '"foo +2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +2223"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +2223bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +2223bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +2223 "'\'''
test-expr 'date(`foo %z `)' '"foo +2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +2223 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +2223 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +2223 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+22244"'\'''
test-expr 'date(`%z`)' '"+22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+22244"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+22244bar"'\'''
test-expr 'date(`%zbar`)' '"+22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+22244bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+22244 "'\'''
test-expr 'date(`%z `)' '"+22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+22244 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+22244 bar"'\'''
test-expr 'date(`%z bar`)' '"+22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+22244 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +22244"'\'''
test-expr 'date(` %z`)' '" +22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +22244"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +22244bar"'\'''
test-expr 'date(` %zbar`)' '" +22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +22244bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +22244 "'\'''
test-expr 'date(` %z `)' '" +22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +22244 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +22244 bar"'\'''
test-expr 'date(` %z bar`)' '" +22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +22244 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+22244"'\'''
test-expr 'date(`foo%z`)' '"foo+22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+22244"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+22244bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+22244bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+22244 "'\'''
test-expr 'date(`foo%z `)' '"foo+22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+22244 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+22244 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+22244 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +22244"'\'''
test-expr 'date(`foo %z`)' '"foo +22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +22244"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +22244bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +22244bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +22244 "'\'''
test-expr 'date(`foo %z `)' '"foo +22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +22244 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +22244 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +22244 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+22255"'\'''
test-expr 'date(`%z`)' '"+22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+22255"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+22255bar"'\'''
test-expr 'date(`%zbar`)' '"+22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+22255bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+22255 "'\'''
test-expr 'date(`%z `)' '"+22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+22255 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+22255 bar"'\'''
test-expr 'date(`%z bar`)' '"+22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+22255 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +22255"'\'''
test-expr 'date(` %z`)' '" +22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +22255"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +22255bar"'\'''
test-expr 'date(` %zbar`)' '" +22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +22255bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +22255 "'\'''
test-expr 'date(` %z `)' '" +22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +22255 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +22255 bar"'\'''
test-expr 'date(` %z bar`)' '" +22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +22255 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+22255"'\'''
test-expr 'date(`foo%z`)' '"foo+22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+22255"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+22255bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+22255bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+22255 "'\'''
test-expr 'date(`foo%z `)' '"foo+22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+22255 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+22255 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+22255 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +22255"'\'''
test-expr 'date(`foo %z`)' '"foo +22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +22255"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +22255bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +22255bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +22255 "'\'''
test-expr 'date(`foo %z `)' '"foo +22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +22255 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +22255 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +22255 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+Z"'\'''
test-expr 'date(`%z`)' '"+Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+Z"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+Zbar"'\'''
test-expr 'date(`%zbar`)' '"+Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+Zbar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+Z "'\'''
test-expr 'date(`%z `)' '"+Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+Z "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+Z bar"'\'''
test-expr 'date(`%z bar`)' '"+Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+Z bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +Z"'\'''
test-expr 'date(` %z`)' '" +Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +Z"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +Zbar"'\'''
test-expr 'date(` %zbar`)' '" +Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +Zbar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +Z "'\'''
test-expr 'date(` %z `)' '" +Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +Z "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +Z bar"'\'''
test-expr 'date(` %z bar`)' '" +Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +Z bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+Z"'\'''
test-expr 'date(`foo%z`)' '"foo+Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+Z"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+Zbar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+Zbar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+Z "'\'''
test-expr 'date(`foo%z `)' '"foo+Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+Z "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+Z bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+Z bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +Z"'\'''
test-expr 'date(`foo %z`)' '"foo +Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +Z"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +Zbar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +Zbar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +Z "'\'''
test-expr 'date(`foo %z `)' '"foo +Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +Z "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +Z bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +Z bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+:"'\'''
test-expr 'date(`%z`)' '"+:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+:bar"'\'''
test-expr 'date(`%zbar`)' '"+:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+: "'\'''
test-expr 'date(`%z `)' '"+: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+: bar"'\'''
test-expr 'date(`%z bar`)' '"+: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +:"'\'''
test-expr 'date(` %z`)' '" +:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +:bar"'\'''
test-expr 'date(` %zbar`)' '" +:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +: "'\'''
test-expr 'date(` %z `)' '" +: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +: bar"'\'''
test-expr 'date(` %z bar`)' '" +: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:"'\'''
test-expr 'date(`foo%z`)' '"foo+:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+: "'\'''
test-expr 'date(`foo%z `)' '"foo+: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:"'\'''
test-expr 'date(`foo %z`)' '"foo +:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +: "'\'''
test-expr 'date(`foo %z `)' '"foo +: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+:3"'\'''
test-expr 'date(`%z`)' '"+:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+:3bar"'\'''
test-expr 'date(`%zbar`)' '"+:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+:3 "'\'''
test-expr 'date(`%z `)' '"+:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+:3 bar"'\'''
test-expr 'date(`%z bar`)' '"+:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +:3"'\'''
test-expr 'date(` %z`)' '" +:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +:3bar"'\'''
test-expr 'date(` %zbar`)' '" +:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +:3 "'\'''
test-expr 'date(` %z `)' '" +:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +:3 bar"'\'''
test-expr 'date(` %z bar`)' '" +:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:3"'\'''
test-expr 'date(`foo%z`)' '"foo+:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+:3 "'\'''
test-expr 'date(`foo%z `)' '"foo+:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:3"'\'''
test-expr 'date(`foo %z`)' '"foo +:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +:3 "'\'''
test-expr 'date(`foo %z `)' '"foo +:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+:44"'\'''
test-expr 'date(`%z`)' '"+:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+:44bar"'\'''
test-expr 'date(`%zbar`)' '"+:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+:44 "'\'''
test-expr 'date(`%z `)' '"+:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+:44 bar"'\'''
test-expr 'date(`%z bar`)' '"+:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +:44"'\'''
test-expr 'date(` %z`)' '" +:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +:44bar"'\'''
test-expr 'date(` %zbar`)' '" +:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +:44 "'\'''
test-expr 'date(` %z `)' '" +:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +:44 bar"'\'''
test-expr 'date(` %z bar`)' '" +:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:44"'\'''
test-expr 'date(`foo%z`)' '"foo+:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+:44 "'\'''
test-expr 'date(`foo%z `)' '"foo+:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:44"'\'''
test-expr 'date(`foo %z`)' '"foo +:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +:44 "'\'''
test-expr 'date(`foo %z `)' '"foo +:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"+:55"'\'''
test-expr 'date(`%z`)' '"+:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"+:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"+:55bar"'\'''
test-expr 'date(`%zbar`)' '"+:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"+:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"+:55 "'\'''
test-expr 'date(`%z `)' '"+:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"+:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"+:55 bar"'\'''
test-expr 'date(`%z bar`)' '"+:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"+:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" +:55"'\'''
test-expr 'date(` %z`)' '" +:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" +:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" +:55bar"'\'''
test-expr 'date(` %zbar`)' '" +:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" +:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" +:55 "'\'''
test-expr 'date(` %z `)' '" +:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" +:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" +:55 bar"'\'''
test-expr 'date(` %z bar`)' '" +:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" +:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo+:55"'\'''
test-expr 'date(`foo%z`)' '"foo+:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo+:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo+:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo+:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo+:55 "'\'''
test-expr 'date(`foo%z `)' '"foo+:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo+:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo+:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo+:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo +:55"'\'''
test-expr 'date(`foo %z`)' '"foo +:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo +:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo +:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo +:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo +:55 "'\'''
test-expr 'date(`foo %z `)' '"foo +:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo +:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo +:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo +:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-"'\'''
test-expr 'date(`%z`)' '"-"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-bar"'\'''
test-expr 'date(`%zbar`)' '"-bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"- "'\'''
test-expr 'date(`%z `)' '"- "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"- "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"- bar"'\'''
test-expr 'date(`%z bar`)' '"- bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"- bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -"'\'''
test-expr 'date(` %z`)' '" -"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -bar"'\'''
test-expr 'date(` %zbar`)' '" -bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" - "'\'''
test-expr 'date(` %z `)' '" - "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" - "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" - bar"'\'''
test-expr 'date(` %z bar`)' '" - bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" - bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-"'\'''
test-expr 'date(`foo%z`)' '"foo-"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo- "'\'''
test-expr 'date(`foo%z `)' '"foo- "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo- "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo- bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo- bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo- bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -"'\'''
test-expr 'date(`foo %z`)' '"foo -"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo - "'\'''
test-expr 'date(`foo %z `)' '"foo - "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo - "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo - bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo - bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo - bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-0"'\'''
test-expr 'date(`%z`)' '"-0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-0"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-0bar"'\'''
test-expr 'date(`%zbar`)' '"-0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-0bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-0 "'\'''
test-expr 'date(`%z `)' '"-0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-0 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-0 bar"'\'''
test-expr 'date(`%z bar`)' '"-0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-0 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -0"'\'''
test-expr 'date(` %z`)' '" -0"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -0"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -0bar"'\'''
test-expr 'date(` %zbar`)' '" -0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -0bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -0 "'\'''
test-expr 'date(` %z `)' '" -0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -0 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -0 bar"'\'''
test-expr 'date(` %z bar`)' '" -0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -0 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0"'\'''
test-expr 'date(`foo%z`)' '"foo-0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-0"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0 "'\'''
test-expr 'date(`foo%z `)' '"foo-0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-0 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0"'\'''
test-expr 'date(`foo %z`)' '"foo -0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -0"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0 "'\'''
test-expr 'date(`foo %z `)' '"foo -0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -0 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-0:"'\'''
test-expr 'date(`%z`)' '"-0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-0:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-0:bar"'\'''
test-expr 'date(`%zbar`)' '"-0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-0:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-0: "'\'''
test-expr 'date(`%z `)' '"-0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-0: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-0: bar"'\'''
test-expr 'date(`%z bar`)' '"-0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-0: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -0:"'\'''
test-expr 'date(` %z`)' '" -0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -0:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -0:bar"'\'''
test-expr 'date(` %zbar`)' '" -0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -0:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -0: "'\'''
test-expr 'date(` %z `)' '" -0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -0: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -0: bar"'\'''
test-expr 'date(` %z bar`)' '" -0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -0: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:"'\'''
test-expr 'date(`foo%z`)' '"foo-0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-0:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0: "'\'''
test-expr 'date(`foo%z `)' '"foo-0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-0: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:"'\'''
test-expr 'date(`foo %z`)' '"foo -0:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -0:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -0:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0: "'\'''
test-expr 'date(`foo %z `)' '"foo -0: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -0: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -0: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-0:3"'\'''
test-expr 'date(`%z`)' '"-0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-0:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-0:3bar"'\'''
test-expr 'date(`%zbar`)' '"-0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-0:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-0:3 "'\'''
test-expr 'date(`%z `)' '"-0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-0:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-0:3 bar"'\'''
test-expr 'date(`%z bar`)' '"-0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-0:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -0:3"'\'''
test-expr 'date(` %z`)' '" -0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -0:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -0:3bar"'\'''
test-expr 'date(` %zbar`)' '" -0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -0:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -0:3 "'\'''
test-expr 'date(` %z `)' '" -0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -0:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -0:3 bar"'\'''
test-expr 'date(` %z bar`)' '" -0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -0:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:3"'\'''
test-expr 'date(`foo%z`)' '"foo-0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-0:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0:3 "'\'''
test-expr 'date(`foo%z `)' '"foo-0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-0:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:3"'\'''
test-expr 'date(`foo %z`)' '"foo -0:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -0:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -0:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0:3 "'\'''
test-expr 'date(`foo %z `)' '"foo -0:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -0:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -0:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-0:44"'\'''
test-expr 'date(`%z`)' '"-0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-0:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-0:44bar"'\'''
test-expr 'date(`%zbar`)' '"-0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-0:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-0:44 "'\'''
test-expr 'date(`%z `)' '"-0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-0:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-0:44 bar"'\'''
test-expr 'date(`%z bar`)' '"-0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-0:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -0:44"'\'''
test-expr 'date(` %z`)' '" -0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -0:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -0:44bar"'\'''
test-expr 'date(` %zbar`)' '" -0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -0:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -0:44 "'\'''
test-expr 'date(` %z `)' '" -0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -0:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -0:44 bar"'\'''
test-expr 'date(` %z bar`)' '" -0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -0:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:44"'\'''
test-expr 'date(`foo%z`)' '"foo-0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-0:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0:44 "'\'''
test-expr 'date(`foo%z `)' '"foo-0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-0:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:44"'\'''
test-expr 'date(`foo %z`)' '"foo -0:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -0:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -0:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0:44 "'\'''
test-expr 'date(`foo %z `)' '"foo -0:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -0:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -0:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-0:55"'\'''
test-expr 'date(`%z`)' '"-0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-0:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-0:55bar"'\'''
test-expr 'date(`%zbar`)' '"-0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-0:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-0:55 "'\'''
test-expr 'date(`%z `)' '"-0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-0:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-0:55 bar"'\'''
test-expr 'date(`%z bar`)' '"-0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-0:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -0:55"'\'''
test-expr 'date(` %z`)' '" -0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -0:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -0:55bar"'\'''
test-expr 'date(` %zbar`)' '" -0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -0:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -0:55 "'\'''
test-expr 'date(` %z `)' '" -0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -0:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -0:55 bar"'\'''
test-expr 'date(` %z bar`)' '" -0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -0:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-0:55"'\'''
test-expr 'date(`foo%z`)' '"foo-0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-0:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-0:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-0:55 "'\'''
test-expr 'date(`foo%z `)' '"foo-0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-0:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-0:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -0:55"'\'''
test-expr 'date(`foo %z`)' '"foo -0:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -0:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -0:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -0:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -0:55 "'\'''
test-expr 'date(`foo %z `)' '"foo -0:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -0:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -0:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -0:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-03"'\'''
test-expr 'date(`%z`)' '"-03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-03"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-03bar"'\'''
test-expr 'date(`%zbar`)' '"-03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-03bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-03 "'\'''
test-expr 'date(`%z `)' '"-03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-03 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-03 bar"'\'''
test-expr 'date(`%z bar`)' '"-03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-03 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -03"'\'''
test-expr 'date(` %z`)' '" -03"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -03"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -03bar"'\'''
test-expr 'date(` %zbar`)' '" -03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -03bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -03 "'\'''
test-expr 'date(` %z `)' '" -03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -03 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -03 bar"'\'''
test-expr 'date(` %z bar`)' '" -03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -03 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-03"'\'''
test-expr 'date(`foo%z`)' '"foo-03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-03"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-03bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-03bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-03 "'\'''
test-expr 'date(`foo%z `)' '"foo-03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-03 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-03 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-03 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -03"'\'''
test-expr 'date(`foo %z`)' '"foo -03"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -03"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -03bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -03bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -03bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -03 "'\'''
test-expr 'date(`foo %z `)' '"foo -03 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -03 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -03 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -03 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -03 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-11"'\'''
test-expr 'date(`%z`)' '"-11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-11"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-11bar"'\'''
test-expr 'date(`%zbar`)' '"-11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-11bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-11 "'\'''
test-expr 'date(`%z `)' '"-11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-11 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-11 bar"'\'''
test-expr 'date(`%z bar`)' '"-11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-11 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -11"'\'''
test-expr 'date(` %z`)' '" -11"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -11"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -11bar"'\'''
test-expr 'date(` %zbar`)' '" -11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -11bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -11 "'\'''
test-expr 'date(` %z `)' '" -11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -11 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -11 bar"'\'''
test-expr 'date(` %z bar`)' '" -11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -11 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11"'\'''
test-expr 'date(`foo%z`)' '"foo-11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-11"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11 "'\'''
test-expr 'date(`foo%z `)' '"foo-11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-11 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11"'\'''
test-expr 'date(`foo %z`)' '"foo -11"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -11"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -11bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11 "'\'''
test-expr 'date(`foo %z `)' '"foo -11 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -11 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -11 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-11:"'\'''
test-expr 'date(`%z`)' '"-11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-11:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-11:bar"'\'''
test-expr 'date(`%zbar`)' '"-11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-11:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-11: "'\'''
test-expr 'date(`%z `)' '"-11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-11: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-11: bar"'\'''
test-expr 'date(`%z bar`)' '"-11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-11: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -11:"'\'''
test-expr 'date(` %z`)' '" -11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -11:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -11:bar"'\'''
test-expr 'date(` %zbar`)' '" -11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -11:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -11: "'\'''
test-expr 'date(` %z `)' '" -11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -11: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -11: bar"'\'''
test-expr 'date(` %z bar`)' '" -11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -11: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:"'\'''
test-expr 'date(`foo%z`)' '"foo-11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-11:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11: "'\'''
test-expr 'date(`foo%z `)' '"foo-11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-11: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:"'\'''
test-expr 'date(`foo %z`)' '"foo -11:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -11:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -11:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11: "'\'''
test-expr 'date(`foo %z `)' '"foo -11: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -11: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -11: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-11:3"'\'''
test-expr 'date(`%z`)' '"-11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-11:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-11:3bar"'\'''
test-expr 'date(`%zbar`)' '"-11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-11:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-11:3 "'\'''
test-expr 'date(`%z `)' '"-11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-11:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-11:3 bar"'\'''
test-expr 'date(`%z bar`)' '"-11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-11:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -11:3"'\'''
test-expr 'date(` %z`)' '" -11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -11:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -11:3bar"'\'''
test-expr 'date(` %zbar`)' '" -11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -11:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -11:3 "'\'''
test-expr 'date(` %z `)' '" -11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -11:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -11:3 bar"'\'''
test-expr 'date(` %z bar`)' '" -11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -11:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:3"'\'''
test-expr 'date(`foo%z`)' '"foo-11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-11:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11:3 "'\'''
test-expr 'date(`foo%z `)' '"foo-11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-11:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:3"'\'''
test-expr 'date(`foo %z`)' '"foo -11:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -11:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -11:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11:3 "'\'''
test-expr 'date(`foo %z `)' '"foo -11:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -11:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -11:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-11:44"'\'''
test-expr 'date(`%z`)' '"-11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-11:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-11:44bar"'\'''
test-expr 'date(`%zbar`)' '"-11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-11:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-11:44 "'\'''
test-expr 'date(`%z `)' '"-11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-11:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-11:44 bar"'\'''
test-expr 'date(`%z bar`)' '"-11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-11:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -11:44"'\'''
test-expr 'date(` %z`)' '" -11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -11:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -11:44bar"'\'''
test-expr 'date(` %zbar`)' '" -11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -11:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -11:44 "'\'''
test-expr 'date(` %z `)' '" -11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -11:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -11:44 bar"'\'''
test-expr 'date(` %z bar`)' '" -11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -11:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:44"'\'''
test-expr 'date(`foo%z`)' '"foo-11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-11:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11:44 "'\'''
test-expr 'date(`foo%z `)' '"foo-11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-11:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:44"'\'''
test-expr 'date(`foo %z`)' '"foo -11:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -11:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -11:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11:44 "'\'''
test-expr 'date(`foo %z `)' '"foo -11:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -11:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -11:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-11:55"'\'''
test-expr 'date(`%z`)' '"-11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-11:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-11:55bar"'\'''
test-expr 'date(`%zbar`)' '"-11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-11:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-11:55 "'\'''
test-expr 'date(`%z `)' '"-11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-11:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-11:55 bar"'\'''
test-expr 'date(`%z bar`)' '"-11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-11:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -11:55"'\'''
test-expr 'date(` %z`)' '" -11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -11:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -11:55bar"'\'''
test-expr 'date(` %zbar`)' '" -11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -11:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -11:55 "'\'''
test-expr 'date(` %z `)' '" -11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -11:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -11:55 bar"'\'''
test-expr 'date(` %z bar`)' '" -11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -11:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-11:55"'\'''
test-expr 'date(`foo%z`)' '"foo-11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-11:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-11:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-11:55 "'\'''
test-expr 'date(`foo%z `)' '"foo-11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-11:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-11:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -11:55"'\'''
test-expr 'date(`foo %z`)' '"foo -11:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -11:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -11:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -11:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -11:55 "'\'''
test-expr 'date(`foo %z `)' '"foo -11:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -11:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -11:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -11:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-044"'\'''
test-expr 'date(`%z`)' '"-044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-044"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-044bar"'\'''
test-expr 'date(`%zbar`)' '"-044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-044bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-044 "'\'''
test-expr 'date(`%z `)' '"-044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-044 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-044 bar"'\'''
test-expr 'date(`%z bar`)' '"-044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-044 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -044"'\'''
test-expr 'date(` %z`)' '" -044"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -044"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -044bar"'\'''
test-expr 'date(` %zbar`)' '" -044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -044bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -044 "'\'''
test-expr 'date(` %z `)' '" -044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -044 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -044 bar"'\'''
test-expr 'date(` %z bar`)' '" -044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -044 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-044"'\'''
test-expr 'date(`foo%z`)' '"foo-044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-044"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-044bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-044bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-044 "'\'''
test-expr 'date(`foo%z `)' '"foo-044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-044 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-044 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-044 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -044"'\'''
test-expr 'date(`foo %z`)' '"foo -044"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -044"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -044bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -044bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -044bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -044 "'\'''
test-expr 'date(`foo %z `)' '"foo -044 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -044 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -044 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -044 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -044 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-055"'\'''
test-expr 'date(`%z`)' '"-055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-055"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-055bar"'\'''
test-expr 'date(`%zbar`)' '"-055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-055bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-055 "'\'''
test-expr 'date(`%z `)' '"-055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-055 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-055 bar"'\'''
test-expr 'date(`%z bar`)' '"-055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-055 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -055"'\'''
test-expr 'date(` %z`)' '" -055"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -055"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -055bar"'\'''
test-expr 'date(` %zbar`)' '" -055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -055bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -055 "'\'''
test-expr 'date(` %z `)' '" -055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -055 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -055 bar"'\'''
test-expr 'date(` %z bar`)' '" -055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -055 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-055"'\'''
test-expr 'date(`foo%z`)' '"foo-055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-055"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-055bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-055bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-055 "'\'''
test-expr 'date(`foo%z `)' '"foo-055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-055 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-055 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-055 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -055"'\'''
test-expr 'date(`foo %z`)' '"foo -055"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -055"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -055bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -055bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -055bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -055 "'\'''
test-expr 'date(`foo %z `)' '"foo -055 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -055 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -055 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -055 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -055 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-113"'\'''
test-expr 'date(`%z`)' '"-113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-113"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-113bar"'\'''
test-expr 'date(`%zbar`)' '"-113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-113bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-113 "'\'''
test-expr 'date(`%z `)' '"-113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-113 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-113 bar"'\'''
test-expr 'date(`%z bar`)' '"-113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-113 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -113"'\'''
test-expr 'date(` %z`)' '" -113"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -113"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -113bar"'\'''
test-expr 'date(` %zbar`)' '" -113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -113bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -113 "'\'''
test-expr 'date(` %z `)' '" -113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -113 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -113 bar"'\'''
test-expr 'date(` %z bar`)' '" -113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -113 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-113"'\'''
test-expr 'date(`foo%z`)' '"foo-113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-113"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-113bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-113bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-113 "'\'''
test-expr 'date(`foo%z `)' '"foo-113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-113 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-113 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-113 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -113"'\'''
test-expr 'date(`foo %z`)' '"foo -113"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -113"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -113bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -113bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -113bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -113 "'\'''
test-expr 'date(`foo %z `)' '"foo -113 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -113 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -113 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -113 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -113 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-222"'\'''
test-expr 'date(`%z`)' '"-222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-222"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-222bar"'\'''
test-expr 'date(`%zbar`)' '"-222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-222bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-222 "'\'''
test-expr 'date(`%z `)' '"-222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-222 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-222 bar"'\'''
test-expr 'date(`%z bar`)' '"-222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-222 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -222"'\'''
test-expr 'date(` %z`)' '" -222"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -222"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -222bar"'\'''
test-expr 'date(` %zbar`)' '" -222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -222bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -222 "'\'''
test-expr 'date(` %z `)' '" -222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -222 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -222 bar"'\'''
test-expr 'date(` %z bar`)' '" -222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -222 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222"'\'''
test-expr 'date(`foo%z`)' '"foo-222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-222"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222 "'\'''
test-expr 'date(`foo%z `)' '"foo-222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-222 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222"'\'''
test-expr 'date(`foo %z`)' '"foo -222"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -222"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -222bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222 "'\'''
test-expr 'date(`foo %z `)' '"foo -222 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -222 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -222 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-222:"'\'''
test-expr 'date(`%z`)' '"-222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-222:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-222:bar"'\'''
test-expr 'date(`%zbar`)' '"-222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-222:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-222: "'\'''
test-expr 'date(`%z `)' '"-222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-222: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-222: bar"'\'''
test-expr 'date(`%z bar`)' '"-222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-222: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -222:"'\'''
test-expr 'date(` %z`)' '" -222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -222:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -222:bar"'\'''
test-expr 'date(` %zbar`)' '" -222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -222:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -222: "'\'''
test-expr 'date(` %z `)' '" -222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -222: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -222: bar"'\'''
test-expr 'date(` %z bar`)' '" -222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -222: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:"'\'''
test-expr 'date(`foo%z`)' '"foo-222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-222:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222: "'\'''
test-expr 'date(`foo%z `)' '"foo-222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-222: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:"'\'''
test-expr 'date(`foo %z`)' '"foo -222:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -222:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -222:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222: "'\'''
test-expr 'date(`foo %z `)' '"foo -222: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -222: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -222: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-222:3"'\'''
test-expr 'date(`%z`)' '"-222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-222:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-222:3bar"'\'''
test-expr 'date(`%zbar`)' '"-222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-222:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-222:3 "'\'''
test-expr 'date(`%z `)' '"-222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-222:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-222:3 bar"'\'''
test-expr 'date(`%z bar`)' '"-222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-222:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -222:3"'\'''
test-expr 'date(` %z`)' '" -222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -222:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -222:3bar"'\'''
test-expr 'date(` %zbar`)' '" -222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -222:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -222:3 "'\'''
test-expr 'date(` %z `)' '" -222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -222:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -222:3 bar"'\'''
test-expr 'date(` %z bar`)' '" -222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -222:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:3"'\'''
test-expr 'date(`foo%z`)' '"foo-222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-222:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222:3 "'\'''
test-expr 'date(`foo%z `)' '"foo-222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-222:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:3"'\'''
test-expr 'date(`foo %z`)' '"foo -222:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -222:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -222:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222:3 "'\'''
test-expr 'date(`foo %z `)' '"foo -222:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -222:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -222:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-222:44"'\'''
test-expr 'date(`%z`)' '"-222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-222:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-222:44bar"'\'''
test-expr 'date(`%zbar`)' '"-222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-222:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-222:44 "'\'''
test-expr 'date(`%z `)' '"-222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-222:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-222:44 bar"'\'''
test-expr 'date(`%z bar`)' '"-222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-222:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -222:44"'\'''
test-expr 'date(` %z`)' '" -222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -222:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -222:44bar"'\'''
test-expr 'date(` %zbar`)' '" -222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -222:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -222:44 "'\'''
test-expr 'date(` %z `)' '" -222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -222:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -222:44 bar"'\'''
test-expr 'date(` %z bar`)' '" -222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -222:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:44"'\'''
test-expr 'date(`foo%z`)' '"foo-222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-222:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222:44 "'\'''
test-expr 'date(`foo%z `)' '"foo-222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-222:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:44"'\'''
test-expr 'date(`foo %z`)' '"foo -222:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -222:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -222:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222:44 "'\'''
test-expr 'date(`foo %z `)' '"foo -222:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -222:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -222:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-222:55"'\'''
test-expr 'date(`%z`)' '"-222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-222:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-222:55bar"'\'''
test-expr 'date(`%zbar`)' '"-222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-222:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-222:55 "'\'''
test-expr 'date(`%z `)' '"-222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-222:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-222:55 bar"'\'''
test-expr 'date(`%z bar`)' '"-222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-222:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -222:55"'\'''
test-expr 'date(` %z`)' '" -222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -222:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -222:55bar"'\'''
test-expr 'date(` %zbar`)' '" -222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -222:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -222:55 "'\'''
test-expr 'date(` %z `)' '" -222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -222:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -222:55 bar"'\'''
test-expr 'date(` %z bar`)' '" -222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -222:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-222:55"'\'''
test-expr 'date(`foo%z`)' '"foo-222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-222:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-222:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-222:55 "'\'''
test-expr 'date(`foo%z `)' '"foo-222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-222:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-222:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -222:55"'\'''
test-expr 'date(`foo %z`)' '"foo -222:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -222:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -222:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -222:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -222:55 "'\'''
test-expr 'date(`foo %z `)' '"foo -222:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -222:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -222:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -222:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-1144"'\'''
test-expr 'date(`%z`)' '"-1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-1144"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-1144bar"'\'''
test-expr 'date(`%zbar`)' '"-1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-1144bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-1144 "'\'''
test-expr 'date(`%z `)' '"-1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-1144 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-1144 bar"'\'''
test-expr 'date(`%z bar`)' '"-1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-1144 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -1144"'\'''
test-expr 'date(` %z`)' '" -1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -1144"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -1144bar"'\'''
test-expr 'date(` %zbar`)' '" -1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -1144bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -1144 "'\'''
test-expr 'date(` %z `)' '" -1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -1144 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -1144 bar"'\'''
test-expr 'date(` %z bar`)' '" -1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -1144 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-1144"'\'''
test-expr 'date(`foo%z`)' '"foo-1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-1144"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-1144bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-1144bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-1144 "'\'''
test-expr 'date(`foo%z `)' '"foo-1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-1144 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-1144 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-1144 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -1144"'\'''
test-expr 'date(`foo %z`)' '"foo -1144"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -1144"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -1144bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -1144bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -1144bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -1144 "'\'''
test-expr 'date(`foo %z `)' '"foo -1144 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -1144 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -1144 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -1144 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -1144 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-1155"'\'''
test-expr 'date(`%z`)' '"-1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-1155"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-1155bar"'\'''
test-expr 'date(`%zbar`)' '"-1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-1155bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-1155 "'\'''
test-expr 'date(`%z `)' '"-1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-1155 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-1155 bar"'\'''
test-expr 'date(`%z bar`)' '"-1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-1155 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -1155"'\'''
test-expr 'date(` %z`)' '" -1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -1155"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -1155bar"'\'''
test-expr 'date(` %zbar`)' '" -1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -1155bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -1155 "'\'''
test-expr 'date(` %z `)' '" -1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -1155 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -1155 bar"'\'''
test-expr 'date(` %z bar`)' '" -1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -1155 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-1155"'\'''
test-expr 'date(`foo%z`)' '"foo-1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-1155"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-1155bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-1155bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-1155 "'\'''
test-expr 'date(`foo%z `)' '"foo-1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-1155 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-1155 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-1155 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -1155"'\'''
test-expr 'date(`foo %z`)' '"foo -1155"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -1155"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -1155bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -1155bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -1155bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -1155 "'\'''
test-expr 'date(`foo %z `)' '"foo -1155 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -1155 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -1155 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -1155 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -1155 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-2223"'\'''
test-expr 'date(`%z`)' '"-2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-2223"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-2223bar"'\'''
test-expr 'date(`%zbar`)' '"-2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-2223bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-2223 "'\'''
test-expr 'date(`%z `)' '"-2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-2223 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-2223 bar"'\'''
test-expr 'date(`%z bar`)' '"-2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-2223 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -2223"'\'''
test-expr 'date(` %z`)' '" -2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -2223"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -2223bar"'\'''
test-expr 'date(` %zbar`)' '" -2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -2223bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -2223 "'\'''
test-expr 'date(` %z `)' '" -2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -2223 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -2223 bar"'\'''
test-expr 'date(` %z bar`)' '" -2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -2223 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-2223"'\'''
test-expr 'date(`foo%z`)' '"foo-2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-2223"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-2223bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-2223bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-2223 "'\'''
test-expr 'date(`foo%z `)' '"foo-2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-2223 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-2223 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-2223 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -2223"'\'''
test-expr 'date(`foo %z`)' '"foo -2223"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -2223"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -2223bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -2223bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -2223bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -2223 "'\'''
test-expr 'date(`foo %z `)' '"foo -2223 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -2223 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -2223 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -2223 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -2223 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-22244"'\'''
test-expr 'date(`%z`)' '"-22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-22244"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-22244bar"'\'''
test-expr 'date(`%zbar`)' '"-22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-22244bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-22244 "'\'''
test-expr 'date(`%z `)' '"-22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-22244 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-22244 bar"'\'''
test-expr 'date(`%z bar`)' '"-22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-22244 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -22244"'\'''
test-expr 'date(` %z`)' '" -22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -22244"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -22244bar"'\'''
test-expr 'date(` %zbar`)' '" -22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -22244bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -22244 "'\'''
test-expr 'date(` %z `)' '" -22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -22244 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -22244 bar"'\'''
test-expr 'date(` %z bar`)' '" -22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -22244 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-22244"'\'''
test-expr 'date(`foo%z`)' '"foo-22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-22244"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-22244bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-22244bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-22244 "'\'''
test-expr 'date(`foo%z `)' '"foo-22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-22244 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-22244 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-22244 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -22244"'\'''
test-expr 'date(`foo %z`)' '"foo -22244"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -22244"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -22244bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -22244bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -22244bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -22244 "'\'''
test-expr 'date(`foo %z `)' '"foo -22244 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -22244 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -22244 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -22244 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -22244 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-22255"'\'''
test-expr 'date(`%z`)' '"-22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-22255"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-22255bar"'\'''
test-expr 'date(`%zbar`)' '"-22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-22255bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-22255 "'\'''
test-expr 'date(`%z `)' '"-22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-22255 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-22255 bar"'\'''
test-expr 'date(`%z bar`)' '"-22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-22255 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -22255"'\'''
test-expr 'date(` %z`)' '" -22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -22255"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -22255bar"'\'''
test-expr 'date(` %zbar`)' '" -22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -22255bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -22255 "'\'''
test-expr 'date(` %z `)' '" -22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -22255 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -22255 bar"'\'''
test-expr 'date(` %z bar`)' '" -22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -22255 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-22255"'\'''
test-expr 'date(`foo%z`)' '"foo-22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-22255"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-22255bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-22255bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-22255 "'\'''
test-expr 'date(`foo%z `)' '"foo-22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-22255 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-22255 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-22255 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -22255"'\'''
test-expr 'date(`foo %z`)' '"foo -22255"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -22255"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -22255bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -22255bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -22255bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -22255 "'\'''
test-expr 'date(`foo %z `)' '"foo -22255 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -22255 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -22255 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -22255 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -22255 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-Z"'\'''
test-expr 'date(`%z`)' '"-Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-Z"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-Zbar"'\'''
test-expr 'date(`%zbar`)' '"-Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-Zbar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-Z "'\'''
test-expr 'date(`%z `)' '"-Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-Z "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-Z bar"'\'''
test-expr 'date(`%z bar`)' '"-Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-Z bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -Z"'\'''
test-expr 'date(` %z`)' '" -Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -Z"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -Zbar"'\'''
test-expr 'date(` %zbar`)' '" -Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -Zbar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -Z "'\'''
test-expr 'date(` %z `)' '" -Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -Z "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -Z bar"'\'''
test-expr 'date(` %z bar`)' '" -Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -Z bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-Z"'\'''
test-expr 'date(`foo%z`)' '"foo-Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-Z"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-Zbar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-Zbar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-Z "'\'''
test-expr 'date(`foo%z `)' '"foo-Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-Z "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-Z bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-Z bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -Z"'\'''
test-expr 'date(`foo %z`)' '"foo -Z"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -Z"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -Zbar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -Zbar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -Zbar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -Z "'\'''
test-expr 'date(`foo %z `)' '"foo -Z "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -Z "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -Z bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -Z bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -Z bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-:"'\'''
test-expr 'date(`%z`)' '"-:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-:"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-:bar"'\'''
test-expr 'date(`%zbar`)' '"-:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-:bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-: "'\'''
test-expr 'date(`%z `)' '"-: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-: "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-: bar"'\'''
test-expr 'date(`%z bar`)' '"-: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-: bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -:"'\'''
test-expr 'date(` %z`)' '" -:"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -:"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -:bar"'\'''
test-expr 'date(` %zbar`)' '" -:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -:bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -: "'\'''
test-expr 'date(` %z `)' '" -: "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -: "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -: bar"'\'''
test-expr 'date(` %z bar`)' '" -: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -: bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:"'\'''
test-expr 'date(`foo%z`)' '"foo-:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-: "'\'''
test-expr 'date(`foo%z `)' '"foo-: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:"'\'''
test-expr 'date(`foo %z`)' '"foo -:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -:"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -: "'\'''
test-expr 'date(`foo %z `)' '"foo -: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -: "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -: bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -: bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-:3"'\'''
test-expr 'date(`%z`)' '"-:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-:3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-:3bar"'\'''
test-expr 'date(`%zbar`)' '"-:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-:3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-:3 "'\'''
test-expr 'date(`%z `)' '"-:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-:3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-:3 bar"'\'''
test-expr 'date(`%z bar`)' '"-:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-:3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -:3"'\'''
test-expr 'date(` %z`)' '" -:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -:3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -:3bar"'\'''
test-expr 'date(` %zbar`)' '" -:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -:3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -:3 "'\'''
test-expr 'date(` %z `)' '" -:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -:3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -:3 bar"'\'''
test-expr 'date(` %z bar`)' '" -:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -:3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:3"'\'''
test-expr 'date(`foo%z`)' '"foo-:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-:3 "'\'''
test-expr 'date(`foo%z `)' '"foo-:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:3"'\'''
test-expr 'date(`foo %z`)' '"foo -:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -:3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -:3 "'\'''
test-expr 'date(`foo %z `)' '"foo -:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -:3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-:44"'\'''
test-expr 'date(`%z`)' '"-:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-:44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-:44bar"'\'''
test-expr 'date(`%zbar`)' '"-:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-:44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-:44 "'\'''
test-expr 'date(`%z `)' '"-:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-:44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-:44 bar"'\'''
test-expr 'date(`%z bar`)' '"-:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-:44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -:44"'\'''
test-expr 'date(` %z`)' '" -:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -:44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -:44bar"'\'''
test-expr 'date(` %zbar`)' '" -:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -:44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -:44 "'\'''
test-expr 'date(` %z `)' '" -:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -:44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -:44 bar"'\'''
test-expr 'date(` %z bar`)' '" -:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -:44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:44"'\'''
test-expr 'date(`foo%z`)' '"foo-:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-:44 "'\'''
test-expr 'date(`foo%z `)' '"foo-:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:44"'\'''
test-expr 'date(`foo %z`)' '"foo -:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -:44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -:44 "'\'''
test-expr 'date(`foo %z `)' '"foo -:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -:44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''"-:55"'\'''
test-expr 'date(`%z`)' '"-:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''"-:55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''"-:55bar"'\'''
test-expr 'date(`%zbar`)' '"-:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''"-:55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''"-:55 "'\'''
test-expr 'date(`%z `)' '"-:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''"-:55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''"-:55 bar"'\'''
test-expr 'date(`%z bar`)' '"-:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''"-:55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" -:55"'\'''
test-expr 'date(` %z`)' '" -:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" -:55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" -:55bar"'\'''
test-expr 'date(` %zbar`)' '" -:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" -:55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" -:55 "'\'''
test-expr 'date(` %z `)' '" -:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" -:55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" -:55 bar"'\'''
test-expr 'date(` %z bar`)' '" -:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" -:55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo-:55"'\'''
test-expr 'date(`foo%z`)' '"foo-:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo-:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo-:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo-:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo-:55 "'\'''
test-expr 'date(`foo%z `)' '"foo-:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo-:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo-:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo-:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo -:55"'\'''
test-expr 'date(`foo %z`)' '"foo -:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo -:55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo -:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo -:55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo -:55 "'\'''
test-expr 'date(`foo %z `)' '"foo -:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo -:55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo -:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo -:55 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''":"'\'''
test-expr 'date(`%z`)' '":"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''":"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''":bar"'\'''
test-expr 'date(`%zbar`)' '":bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''":bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''": "'\'''
test-expr 'date(`%z `)' '": "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''": "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''": bar"'\'''
test-expr 'date(`%z bar`)' '": bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''": bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" :"'\'''
test-expr 'date(` %z`)' '" :"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" :"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" :bar"'\'''
test-expr 'date(` %zbar`)' '" :bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" :bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" : "'\'''
test-expr 'date(` %z `)' '" : "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" : "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" : bar"'\'''
test-expr 'date(` %z bar`)' '" : bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" : bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo:"'\'''
test-expr 'date(`foo%z`)' '"foo:"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo:"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo:bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo:bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo: "'\'''
test-expr 'date(`foo%z `)' '"foo: "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo: "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo: bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo: bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo: bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo :"'\'''
test-expr 'date(`foo %z`)' '"foo :"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo :"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo :bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo :bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo : "'\'''
test-expr 'date(`foo %z `)' '"foo : "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo : "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo : bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo : bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo : bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''":3"'\'''
test-expr 'date(`%z`)' '":3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''":3"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''":3bar"'\'''
test-expr 'date(`%zbar`)' '":3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''":3bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''":3 "'\'''
test-expr 'date(`%z `)' '":3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''":3 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''":3 bar"'\'''
test-expr 'date(`%z bar`)' '":3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''":3 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" :3"'\'''
test-expr 'date(` %z`)' '" :3"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" :3"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" :3bar"'\'''
test-expr 'date(` %zbar`)' '" :3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" :3bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" :3 "'\'''
test-expr 'date(` %z `)' '" :3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" :3 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" :3 bar"'\'''
test-expr 'date(` %z bar`)' '" :3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" :3 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo:3"'\'''
test-expr 'date(`foo%z`)' '"foo:3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo:3"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:3bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo:3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo:3bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo:3 "'\'''
test-expr 'date(`foo%z `)' '"foo:3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo:3 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo:3 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo:3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo:3 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo :3"'\'''
test-expr 'date(`foo %z`)' '"foo :3"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo :3"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :3bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo :3bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo :3bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo :3 "'\'''
test-expr 'date(`foo %z `)' '"foo :3 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo :3 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo :3 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo :3 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo :3 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''":44"'\'''
test-expr 'date(`%z`)' '":44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''":44"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''":44bar"'\'''
test-expr 'date(`%zbar`)' '":44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''":44bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''":44 "'\'''
test-expr 'date(`%z `)' '":44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''":44 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''":44 bar"'\'''
test-expr 'date(`%z bar`)' '":44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''":44 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" :44"'\'''
test-expr 'date(` %z`)' '" :44"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" :44"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" :44bar"'\'''
test-expr 'date(` %zbar`)' '" :44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" :44bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" :44 "'\'''
test-expr 'date(` %z `)' '" :44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" :44 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" :44 bar"'\'''
test-expr 'date(` %z bar`)' '" :44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" :44 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo:44"'\'''
test-expr 'date(`foo%z`)' '"foo:44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo:44"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:44bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo:44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo:44bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo:44 "'\'''
test-expr 'date(`foo%z `)' '"foo:44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo:44 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo:44 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo:44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo:44 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo :44"'\'''
test-expr 'date(`foo %z`)' '"foo :44"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo :44"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :44bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo :44bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo :44bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo :44 "'\'''
test-expr 'date(`foo %z `)' '"foo :44 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo :44 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo :44 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo :44 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo :44 bar"'\'''

echo '$ test-expr '\''date(`%z`)'\'' '\''":55"'\'''
test-expr 'date(`%z`)' '":55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z`)'\'' '\''":55"'\'''

echo '$ test-expr '\''date(`%zbar`)'\'' '\''":55bar"'\'''
test-expr 'date(`%zbar`)' '":55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%zbar`)'\'' '\''":55bar"'\'''

echo '$ test-expr '\''date(`%z `)'\'' '\''":55 "'\'''
test-expr 'date(`%z `)' '":55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z `)'\'' '\''":55 "'\'''

echo '$ test-expr '\''date(`%z bar`)'\'' '\''":55 bar"'\'''
test-expr 'date(`%z bar`)' '":55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%z bar`)'\'' '\''":55 bar"'\'''

echo '$ test-expr '\''date(` %z`)'\'' '\''" :55"'\'''
test-expr 'date(` %z`)' '" :55"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z`)'\'' '\''" :55"'\'''

echo '$ test-expr '\''date(` %zbar`)'\'' '\''" :55bar"'\'''
test-expr 'date(` %zbar`)' '" :55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %zbar`)'\'' '\''" :55bar"'\'''

echo '$ test-expr '\''date(` %z `)'\'' '\''" :55 "'\'''
test-expr 'date(` %z `)' '" :55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z `)'\'' '\''" :55 "'\'''

echo '$ test-expr '\''date(` %z bar`)'\'' '\''" :55 bar"'\'''
test-expr 'date(` %z bar`)' '" :55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %z bar`)'\'' '\''" :55 bar"'\'''

echo '$ test-expr '\''date(`foo%z`)'\'' '\''"foo:55"'\'''
test-expr 'date(`foo%z`)' '"foo:55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z`)'\'' '\''"foo:55"'\'''

echo '$ test-expr '\''date(`foo%zbar`)'\'' '\''"foo:55bar"'\'''
test-expr 'date(`foo%zbar`)' '"foo:55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%zbar`)'\'' '\''"foo:55bar"'\'''

echo '$ test-expr '\''date(`foo%z `)'\'' '\''"foo:55 "'\'''
test-expr 'date(`foo%z `)' '"foo:55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z `)'\'' '\''"foo:55 "'\'''

echo '$ test-expr '\''date(`foo%z bar`)'\'' '\''"foo:55 bar"'\'''
test-expr 'date(`foo%z bar`)' '"foo:55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%z bar`)'\'' '\''"foo:55 bar"'\'''

echo '$ test-expr '\''date(`foo %z`)'\'' '\''"foo :55"'\'''
test-expr 'date(`foo %z`)' '"foo :55"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z`)'\'' '\''"foo :55"'\'''

echo '$ test-expr '\''date(`foo %zbar`)'\'' '\''"foo :55bar"'\'''
test-expr 'date(`foo %zbar`)' '"foo :55bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %zbar`)'\'' '\''"foo :55bar"'\'''

echo '$ test-expr '\''date(`foo %z `)'\'' '\''"foo :55 "'\'''
test-expr 'date(`foo %z `)' '"foo :55 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z `)'\'' '\''"foo :55 "'\'''

echo '$ test-expr '\''date(`foo %z bar`)'\'' '\''"foo :55 bar"'\'''
test-expr 'date(`foo %z bar`)' '"foo :55 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %z bar`)'\'' '\''"foo :55 bar"'\'''
)

