#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:builtins
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -C'\''
$ test-expr '\''b'\''
0 call_builtin(boolean)
$ test-expr '\''b()'\''
0 call_builtin(boolean)
$ test-expr '\''b(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: b(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''b(0)'\''
$ test-expr '\''b(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: b(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''b(`foo`)'\''
$ test-expr '\''b(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: b(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''b(0,1)'\''
$ test-expr '\''b(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: b(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''b(`foo`,1)'\''
$ test-expr '\''b(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: b(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''b(`foo`,`bar`)'\''
$ test-expr '\''b(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: b(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''b(0,`bar`)'\''
$ test-expr '\''bo'\''
0 call_builtin(boolean)
$ test-expr '\''bo()'\''
0 call_builtin(boolean)
$ test-expr '\''bo(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: bo(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bo(0)'\''
$ test-expr '\''bo(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: bo(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bo(`foo`)'\''
$ test-expr '\''bo(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bo(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bo(0,1)'\''
$ test-expr '\''bo(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bo(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bo(`foo`,1)'\''
$ test-expr '\''bo(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bo(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bo(`foo`,`bar`)'\''
$ test-expr '\''bo(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bo(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bo(0,`bar`)'\''
$ test-expr '\''boo'\''
0 call_builtin(boolean)
$ test-expr '\''boo()'\''
0 call_builtin(boolean)
$ test-expr '\''boo(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boo(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boo(0)'\''
$ test-expr '\''boo(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boo(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boo(`foo`)'\''
$ test-expr '\''boo(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boo(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boo(0,1)'\''
$ test-expr '\''boo(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boo(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boo(`foo`,1)'\''
$ test-expr '\''boo(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boo(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boo(`foo`,`bar`)'\''
$ test-expr '\''boo(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boo(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boo(0,`bar`)'\''
$ test-expr '\''bool'\''
0 call_builtin(boolean)
$ test-expr '\''bool()'\''
0 call_builtin(boolean)
$ test-expr '\''bool(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: bool(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bool(0)'\''
$ test-expr '\''bool(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: bool(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bool(`foo`)'\''
$ test-expr '\''bool(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bool(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bool(0,1)'\''
$ test-expr '\''bool(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bool(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bool(`foo`,1)'\''
$ test-expr '\''bool(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bool(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bool(`foo`,`bar`)'\''
$ test-expr '\''bool(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: bool(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''bool(0,`bar`)'\''
$ test-expr '\''boole'\''
0 call_builtin(boolean)
$ test-expr '\''boole()'\''
0 call_builtin(boolean)
$ test-expr '\''boole(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boole(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boole(0)'\''
$ test-expr '\''boole(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boole(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boole(`foo`)'\''
$ test-expr '\''boole(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boole(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boole(0,1)'\''
$ test-expr '\''boole(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boole(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boole(`foo`,1)'\''
$ test-expr '\''boole(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boole(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boole(`foo`,`bar`)'\''
$ test-expr '\''boole(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boole(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boole(0,`bar`)'\''
$ test-expr '\''boolea'\''
0 call_builtin(boolean)
$ test-expr '\''boolea()'\''
0 call_builtin(boolean)
$ test-expr '\''boolea(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boolea(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolea(0)'\''
$ test-expr '\''boolea(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boolea(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolea(`foo`)'\''
$ test-expr '\''boolea(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolea(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolea(0,1)'\''
$ test-expr '\''boolea(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolea(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolea(`foo`,1)'\''
$ test-expr '\''boolea(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolea(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolea(`foo`,`bar`)'\''
$ test-expr '\''boolea(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolea(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolea(0,`bar`)'\''
$ test-expr '\''boolean'\''
0 call_builtin(boolean)
$ test-expr '\''boolean()'\''
0 call_builtin(boolean)
$ test-expr '\''boolean(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boolean(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolean(0)'\''
$ test-expr '\''boolean(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: boolean(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolean(`foo`)'\''
$ test-expr '\''boolean(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolean(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolean(0,1)'\''
$ test-expr '\''boolean(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolean(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolean(`foo`,1)'\''
$ test-expr '\''boolean(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolean(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolean(`foo`,`bar`)'\''
$ test-expr '\''boolean(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''boolean'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: boolean(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''boolean(0,`bar`)'\''
$ test-expr '\''c'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c'\''
$ test-expr '\''c()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c()'\''
$ test-expr '\''c(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c(0)'\''
$ test-expr '\''c(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c(`foo`)'\''
$ test-expr '\''c(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c(0,1)'\''
$ test-expr '\''c(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c(`foo`,1)'\''
$ test-expr '\''c(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c(`foo`,`bar`)'\''
$ test-expr '\''c(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c(0,`bar`)'\''
$ test-expr '\''c_'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_'\''
$ test-expr '\''c_()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_()'\''
$ test-expr '\''c_(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_(0)'\''
$ test-expr '\''c_(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_(`foo`)'\''
$ test-expr '\''c_(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_(0,1)'\''
$ test-expr '\''c_(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_(`foo`,1)'\''
$ test-expr '\''c_(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_(`foo`,`bar`)'\''
$ test-expr '\''c_(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_(0,`bar`)'\''
$ test-expr '\''c_l'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l'\''
$ test-expr '\''c_l()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l()'\''
$ test-expr '\''c_l(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l(0)'\''
$ test-expr '\''c_l(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l(`foo`)'\''
$ test-expr '\''c_l(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l(0,1)'\''
$ test-expr '\''c_l(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l(`foo`,1)'\''
$ test-expr '\''c_l(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l(`foo`,`bar`)'\''
$ test-expr '\''c_l(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_l(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_l(0,`bar`)'\''
$ test-expr '\''c_lo'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo'\''
$ test-expr '\''c_lo()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo()'\''
$ test-expr '\''c_lo(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo(0)'\''
$ test-expr '\''c_lo(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo(`foo`)'\''
$ test-expr '\''c_lo(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo(0,1)'\''
$ test-expr '\''c_lo(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo(`foo`,1)'\''
$ test-expr '\''c_lo(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo(`foo`,`bar`)'\''
$ test-expr '\''c_lo(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_lo(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_lo(0,`bar`)'\''
$ test-expr '\''c_loc'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc'\''
$ test-expr '\''c_loc()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc()'\''
$ test-expr '\''c_loc(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc(0)'\''
$ test-expr '\''c_loc(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc(`foo`)'\''
$ test-expr '\''c_loc(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc(0,1)'\''
$ test-expr '\''c_loc(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc(`foo`,1)'\''
$ test-expr '\''c_loc(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc(`foo`,`bar`)'\''
$ test-expr '\''c_loc(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loc(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loc(0,`bar`)'\''
$ test-expr '\''c_loca'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca'\''
$ test-expr '\''c_loca()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca()'\''
$ test-expr '\''c_loca(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca(0)'\''
$ test-expr '\''c_loca(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca(`foo`)'\''
$ test-expr '\''c_loca(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca(0,1)'\''
$ test-expr '\''c_loca(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca(`foo`,1)'\''
$ test-expr '\''c_loca(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca(`foo`,`bar`)'\''
$ test-expr '\''c_loca(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_loca(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_loca(0,`bar`)'\''
$ test-expr '\''c_local'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local'\''
$ test-expr '\''c_local()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local()'\''
$ test-expr '\''c_local(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local(0)'\''
$ test-expr '\''c_local(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local(`foo`)'\''
$ test-expr '\''c_local(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local(0,1)'\''
$ test-expr '\''c_local(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local(`foo`,1)'\''
$ test-expr '\''c_local(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local(`foo`,`bar`)'\''
$ test-expr '\''c_local(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_local(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_local(0,`bar`)'\''
$ test-expr '\''c_locale'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale'\''
$ test-expr '\''c_locale()'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale()'\''
$ test-expr '\''c_locale(0)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale(0)'\''
$ test-expr '\''c_locale(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale(`foo`)'\''
$ test-expr '\''c_locale(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale(0,1)'\''
$ test-expr '\''c_locale(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale(`foo`,1)'\''
$ test-expr '\''c_locale(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale(`foo`,`bar`)'\''
$ test-expr '\''c_locale(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''c_locale'\'' is not a function
test-expr: error:1:1: compiler error: c_locale(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''c_locale(0,`bar`)'\''
$ test-expr '\''d'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d'\''
$ test-expr '\''d()'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d()'\''
$ test-expr '\''d(0)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d(0)'\''
$ test-expr '\''d(`foo`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d(`foo`)'\''
$ test-expr '\''d(0,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d(0,1)'\''
$ test-expr '\''d(`foo`,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d(`foo`,1)'\''
$ test-expr '\''d(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d(`foo`,`bar`)'\''
$ test-expr '\''d(0,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: d(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''d(0,`bar`)'\''
$ test-expr '\''da'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: da
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''da'\''
$ test-expr '\''da()'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: da()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''da()'\''
$ test-expr '\''da(0)'\''
test-expr: error:1:4: compiler error: builtin function '\''date'\'': arg #1 type mismatch: expected a string
test-expr: error:1:4: compiler error: da(0)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''da(0)'\''
$ test-expr '\''da(`foo`)'\''
0 const_str("foo")
1 call_builtin(date)
$ test-expr '\''da(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: da(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''da(0,1)'\''
$ test-expr '\''da(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: da(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''da(`foo`,1)'\''
$ test-expr '\''da(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: da(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''da(`foo`,`bar`)'\''
$ test-expr '\''da(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: da(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''da(0,`bar`)'\''
$ test-expr '\''dat'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: dat
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dat'\''
$ test-expr '\''dat()'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: dat()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dat()'\''
$ test-expr '\''dat(0)'\''
test-expr: error:1:5: compiler error: builtin function '\''date'\'': arg #1 type mismatch: expected a string
test-expr: error:1:5: compiler error: dat(0)
test-expr: error:1:5: compiler error:     ^
command failed: test-expr '\''dat(0)'\''
$ test-expr '\''dat(`foo`)'\''
0 const_str("foo")
1 call_builtin(date)
$ test-expr '\''dat(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: dat(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dat(0,1)'\''
$ test-expr '\''dat(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: dat(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dat(`foo`,1)'\''
$ test-expr '\''dat(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: dat(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dat(`foo`,`bar`)'\''
$ test-expr '\''dat(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: dat(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dat(0,`bar`)'\''
$ test-expr '\''date'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: date
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''date'\''
$ test-expr '\''date()'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: date()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''date()'\''
$ test-expr '\''date(0)'\''
test-expr: error:1:6: compiler error: builtin function '\''date'\'': arg #1 type mismatch: expected a string
test-expr: error:1:6: compiler error: date(0)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''date(0)'\''
$ test-expr '\''date(`foo`)'\''
0 const_str("foo")
1 call_builtin(date)
$ test-expr '\''date(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: date(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''date(0,1)'\''
$ test-expr '\''date(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: date(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''date(`foo`,1)'\''
$ test-expr '\''date(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: date(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''date(`foo`,`bar`)'\''
$ test-expr '\''date(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''date'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: date(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''date(0,`bar`)'\''
$ test-expr '\''do'\''
0 call_builtin(double)
$ test-expr '\''do()'\''
0 call_builtin(double)
$ test-expr '\''do(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: do(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''do(0)'\''
$ test-expr '\''do(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: do(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''do(`foo`)'\''
$ test-expr '\''do(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: do(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''do(0,1)'\''
$ test-expr '\''do(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: do(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''do(`foo`,1)'\''
$ test-expr '\''do(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: do(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''do(`foo`,`bar`)'\''
$ test-expr '\''do(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: do(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''do(0,`bar`)'\''
$ test-expr '\''dou'\''
0 call_builtin(double)
$ test-expr '\''dou()'\''
0 call_builtin(double)
$ test-expr '\''dou(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: dou(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dou(0)'\''
$ test-expr '\''dou(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: dou(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dou(`foo`)'\''
$ test-expr '\''dou(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: dou(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dou(0,1)'\''
$ test-expr '\''dou(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: dou(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dou(`foo`,1)'\''
$ test-expr '\''dou(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: dou(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dou(`foo`,`bar`)'\''
$ test-expr '\''dou(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: dou(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''dou(0,`bar`)'\''
$ test-expr '\''doub'\''
0 call_builtin(double)
$ test-expr '\''doub()'\''
0 call_builtin(double)
$ test-expr '\''doub(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: doub(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doub(0)'\''
$ test-expr '\''doub(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: doub(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doub(`foo`)'\''
$ test-expr '\''doub(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doub(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doub(0,1)'\''
$ test-expr '\''doub(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doub(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doub(`foo`,1)'\''
$ test-expr '\''doub(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doub(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doub(`foo`,`bar`)'\''
$ test-expr '\''doub(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doub(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doub(0,`bar`)'\''
$ test-expr '\''doubl'\''
0 call_builtin(double)
$ test-expr '\''doubl()'\''
0 call_builtin(double)
$ test-expr '\''doubl(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: doubl(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doubl(0)'\''
$ test-expr '\''doubl(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: doubl(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doubl(`foo`)'\''
$ test-expr '\''doubl(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doubl(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doubl(0,1)'\''
$ test-expr '\''doubl(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doubl(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doubl(`foo`,1)'\''
$ test-expr '\''doubl(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doubl(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doubl(`foo`,`bar`)'\''
$ test-expr '\''doubl(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: doubl(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''doubl(0,`bar`)'\''
$ test-expr '\''double'\''
0 call_builtin(double)
$ test-expr '\''double()'\''
0 call_builtin(double)
$ test-expr '\''double(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: double(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''double(0)'\''
$ test-expr '\''double(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: double(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''double(`foo`)'\''
$ test-expr '\''double(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: double(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''double(0,1)'\''
$ test-expr '\''double(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: double(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''double(`foo`,1)'\''
$ test-expr '\''double(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: double(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''double(`foo`,`bar`)'\''
$ test-expr '\''double(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''double'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: double(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''double(0,`bar`)'\''
$ test-expr '\''f'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f'\''
$ test-expr '\''f()'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f()'\''
$ test-expr '\''f(0)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f(0)'\''
$ test-expr '\''f(`foo`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f(`foo`)'\''
$ test-expr '\''f(0,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f(0,1)'\''
$ test-expr '\''f(`foo`,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f(`foo`,1)'\''
$ test-expr '\''f(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f(`foo`,`bar`)'\''
$ test-expr '\''f(0,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: f(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''f(0,`bar`)'\''
$ test-expr '\''fl'\''
0 call_builtin(float)
$ test-expr '\''fl()'\''
0 call_builtin(float)
$ test-expr '\''fl(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: fl(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fl(0)'\''
$ test-expr '\''fl(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: fl(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fl(`foo`)'\''
$ test-expr '\''fl(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: fl(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fl(0,1)'\''
$ test-expr '\''fl(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: fl(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fl(`foo`,1)'\''
$ test-expr '\''fl(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: fl(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fl(`foo`,`bar`)'\''
$ test-expr '\''fl(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: fl(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fl(0,`bar`)'\''
$ test-expr '\''flo'\''
0 call_builtin(float)
$ test-expr '\''flo()'\''
0 call_builtin(float)
$ test-expr '\''flo(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: flo(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''flo(0)'\''
$ test-expr '\''flo(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: flo(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''flo(`foo`)'\''
$ test-expr '\''flo(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: flo(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''flo(0,1)'\''
$ test-expr '\''flo(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: flo(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''flo(`foo`,1)'\''
$ test-expr '\''flo(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: flo(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''flo(`foo`,`bar`)'\''
$ test-expr '\''flo(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: flo(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''flo(0,`bar`)'\''
$ test-expr '\''floa'\''
0 call_builtin(float)
$ test-expr '\''floa()'\''
0 call_builtin(float)
$ test-expr '\''floa(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: floa(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''floa(0)'\''
$ test-expr '\''floa(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: floa(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''floa(`foo`)'\''
$ test-expr '\''floa(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: floa(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''floa(0,1)'\''
$ test-expr '\''floa(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: floa(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''floa(`foo`,1)'\''
$ test-expr '\''floa(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: floa(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''floa(`foo`,`bar`)'\''
$ test-expr '\''floa(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: floa(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''floa(0,`bar`)'\''
$ test-expr '\''float'\''
0 call_builtin(float)
$ test-expr '\''float()'\''
0 call_builtin(float)
$ test-expr '\''float(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: float(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''float(0)'\''
$ test-expr '\''float(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: float(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''float(`foo`)'\''
$ test-expr '\''float(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: float(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''float(0,1)'\''
$ test-expr '\''float(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: float(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''float(`foo`,1)'\''
$ test-expr '\''float(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: float(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''float(`foo`,`bar`)'\''
$ test-expr '\''float(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''float'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: float(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''float(0,`bar`)'\''
$ test-expr '\''fu'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu'\''
$ test-expr '\''fu()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu()'\''
$ test-expr '\''fu(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu(0)'\''
$ test-expr '\''fu(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu(`foo`)'\''
$ test-expr '\''fu(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu(0,1)'\''
$ test-expr '\''fu(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu(`foo`,1)'\''
$ test-expr '\''fu(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu(`foo`,`bar`)'\''
$ test-expr '\''fu(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: fu(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''fu(0,`bar`)'\''
$ test-expr '\''ful'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful'\''
$ test-expr '\''ful()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful()'\''
$ test-expr '\''ful(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful(0)'\''
$ test-expr '\''ful(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful(`foo`)'\''
$ test-expr '\''ful(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful(0,1)'\''
$ test-expr '\''ful(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful(`foo`,1)'\''
$ test-expr '\''ful(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful(`foo`,`bar`)'\''
$ test-expr '\''ful(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: ful(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ful(0,`bar`)'\''
$ test-expr '\''full'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full'\''
$ test-expr '\''full()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full()'\''
$ test-expr '\''full(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full(0)'\''
$ test-expr '\''full(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full(`foo`)'\''
$ test-expr '\''full(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full(0,1)'\''
$ test-expr '\''full(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full(`foo`,1)'\''
$ test-expr '\''full(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full(`foo`,`bar`)'\''
$ test-expr '\''full(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full(0,`bar`)'\''
$ test-expr '\''full_'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_'\''
$ test-expr '\''full_()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_()'\''
$ test-expr '\''full_(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_(0)'\''
$ test-expr '\''full_(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_(`foo`)'\''
$ test-expr '\''full_(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_(0,1)'\''
$ test-expr '\''full_(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_(`foo`,1)'\''
$ test-expr '\''full_(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_(`foo`,`bar`)'\''
$ test-expr '\''full_(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_(0,`bar`)'\''
$ test-expr '\''full_i'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i'\''
$ test-expr '\''full_i()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i()'\''
$ test-expr '\''full_i(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i(0)'\''
$ test-expr '\''full_i(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i(`foo`)'\''
$ test-expr '\''full_i(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i(0,1)'\''
$ test-expr '\''full_i(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i(`foo`,1)'\''
$ test-expr '\''full_i(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i(`foo`,`bar`)'\''
$ test-expr '\''full_i(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_i(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_i(0,`bar`)'\''
$ test-expr '\''full_is'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is'\''
$ test-expr '\''full_is()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is()'\''
$ test-expr '\''full_is(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is(0)'\''
$ test-expr '\''full_is(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is(`foo`)'\''
$ test-expr '\''full_is(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is(0,1)'\''
$ test-expr '\''full_is(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is(`foo`,1)'\''
$ test-expr '\''full_is(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is(`foo`,`bar`)'\''
$ test-expr '\''full_is(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_is(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_is(0,`bar`)'\''
$ test-expr '\''full_iso'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso'\''
$ test-expr '\''full_iso()'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso()'\''
$ test-expr '\''full_iso(0)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso(0)'\''
$ test-expr '\''full_iso(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso(`foo`)'\''
$ test-expr '\''full_iso(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso(0,1)'\''
$ test-expr '\''full_iso(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso(`foo`,1)'\''
$ test-expr '\''full_iso(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso(`foo`,`bar`)'\''
$ test-expr '\''full_iso(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''full_iso'\'' is not a function
test-expr: error:1:1: compiler error: full_iso(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''full_iso(0,`bar`)'\''
$ test-expr '\''i'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i'\''
$ test-expr '\''i()'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i()'\''
$ test-expr '\''i(0)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i(0)'\''
$ test-expr '\''i(`foo`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i(`foo`)'\''
$ test-expr '\''i(0,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i(0,1)'\''
$ test-expr '\''i(`foo`,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i(`foo`,1)'\''
$ test-expr '\''i(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i(`foo`,`bar`)'\''
$ test-expr '\''i(0,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: i(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''i(0,`bar`)'\''
$ test-expr '\''in'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: in
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''in'\''
$ test-expr '\''in()'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: in()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''in()'\''
$ test-expr '\''in(0)'\''
0 const_num(0)
1 call_builtin(int)
$ test-expr '\''in(`foo`)'\''
test-expr: error:1:4: compiler error: builtin function '\''int'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: in(`foo`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''in(`foo`)'\''
$ test-expr '\''in(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: in(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''in(0,1)'\''
$ test-expr '\''in(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: in(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''in(`foo`,1)'\''
$ test-expr '\''in(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: in(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''in(`foo`,`bar`)'\''
$ test-expr '\''in(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: in(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''in(0,`bar`)'\''
$ test-expr '\''int'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: int
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''int'\''
$ test-expr '\''int()'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: int()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''int()'\''
$ test-expr '\''int(0)'\''
0 const_num(0)
1 call_builtin(int)
$ test-expr '\''int(`foo`)'\''
test-expr: error:1:5: compiler error: builtin function '\''int'\'': arg #1 type mismatch: expected a number
test-expr: error:1:5: compiler error: int(`foo`)
test-expr: error:1:5: compiler error:     ^
command failed: test-expr '\''int(`foo`)'\''
$ test-expr '\''int(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: int(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''int(0,1)'\''
$ test-expr '\''int(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: int(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''int(`foo`,1)'\''
$ test-expr '\''int(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: int(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''int(`foo`,`bar`)'\''
$ test-expr '\''int(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''int'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: int(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''int(0,`bar`)'\''
$ test-expr '\''is'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is'\''
$ test-expr '\''is()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is()'\''
$ test-expr '\''is(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is(0)'\''
$ test-expr '\''is(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is(`foo`)'\''
$ test-expr '\''is(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is(0,1)'\''
$ test-expr '\''is(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is(`foo`,1)'\''
$ test-expr '\''is(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is(`foo`,`bar`)'\''
$ test-expr '\''is(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: is(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''is(0,`bar`)'\''
$ test-expr '\''iso'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso'\''
$ test-expr '\''iso()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso()'\''
$ test-expr '\''iso(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso(0)'\''
$ test-expr '\''iso(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso(`foo`)'\''
$ test-expr '\''iso(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso(0,1)'\''
$ test-expr '\''iso(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso(`foo`,1)'\''
$ test-expr '\''iso(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso(`foo`,`bar`)'\''
$ test-expr '\''iso(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso(0,`bar`)'\''
$ test-expr '\''iso_'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_'\''
$ test-expr '\''iso_()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_()'\''
$ test-expr '\''iso_(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_(0)'\''
$ test-expr '\''iso_(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_(`foo`)'\''
$ test-expr '\''iso_(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_(0,1)'\''
$ test-expr '\''iso_(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_(`foo`,1)'\''
$ test-expr '\''iso_(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_(`foo`,`bar`)'\''
$ test-expr '\''iso_(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_(0,`bar`)'\''
$ test-expr '\''iso_8'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8'\''
$ test-expr '\''iso_8()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8()'\''
$ test-expr '\''iso_8(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8(0)'\''
$ test-expr '\''iso_8(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8(`foo`)'\''
$ test-expr '\''iso_8(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8(0,1)'\''
$ test-expr '\''iso_8(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8(`foo`,1)'\''
$ test-expr '\''iso_8(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8(`foo`,`bar`)'\''
$ test-expr '\''iso_8(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8(0,`bar`)'\''
$ test-expr '\''iso_86'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86'\''
$ test-expr '\''iso_86()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86()'\''
$ test-expr '\''iso_86(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86(0)'\''
$ test-expr '\''iso_86(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86(`foo`)'\''
$ test-expr '\''iso_86(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86(0,1)'\''
$ test-expr '\''iso_86(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86(`foo`,1)'\''
$ test-expr '\''iso_86(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86(`foo`,`bar`)'\''
$ test-expr '\''iso_86(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_86(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_86(0,`bar`)'\''
$ test-expr '\''iso_860'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860'\''
$ test-expr '\''iso_860()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860()'\''
$ test-expr '\''iso_860(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860(0)'\''
$ test-expr '\''iso_860(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860(`foo`)'\''
$ test-expr '\''iso_860(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860(0,1)'\''
$ test-expr '\''iso_860(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860(`foo`,1)'\''
$ test-expr '\''iso_860(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860(`foo`,`bar`)'\''
$ test-expr '\''iso_860(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_860(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_860(0,`bar`)'\''
$ test-expr '\''iso_8601'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601'\''
$ test-expr '\''iso_8601()'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601()'\''
$ test-expr '\''iso_8601(0)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601(0)'\''
$ test-expr '\''iso_8601(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601(`foo`)'\''
$ test-expr '\''iso_8601(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601(0,1)'\''
$ test-expr '\''iso_8601(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601(`foo`,1)'\''
$ test-expr '\''iso_8601(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601(`foo`,`bar`)'\''
$ test-expr '\''iso_8601(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''iso_8601'\'' is not a function
test-expr: error:1:1: compiler error: iso_8601(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''iso_8601(0,`bar`)'\''
$ test-expr '\''l'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l'\''
$ test-expr '\''l()'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l()'\''
$ test-expr '\''l(0)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l(0)'\''
$ test-expr '\''l(`foo`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l(`foo`)'\''
$ test-expr '\''l(0,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l(0,1)'\''
$ test-expr '\''l(`foo`,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l(`foo`,1)'\''
$ test-expr '\''l(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l(`foo`,`bar`)'\''
$ test-expr '\''l(0,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: l(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''l(0,`bar`)'\''
$ test-expr '\''ld'\''
0 call_builtin(ldouble)
$ test-expr '\''ld()'\''
0 call_builtin(ldouble)
$ test-expr '\''ld(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ld(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ld(0)'\''
$ test-expr '\''ld(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ld(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ld(`foo`)'\''
$ test-expr '\''ld(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ld(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ld(0,1)'\''
$ test-expr '\''ld(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ld(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ld(`foo`,1)'\''
$ test-expr '\''ld(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ld(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ld(`foo`,`bar`)'\''
$ test-expr '\''ld(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ld(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ld(0,`bar`)'\''
$ test-expr '\''ldo'\''
0 call_builtin(ldouble)
$ test-expr '\''ldo()'\''
0 call_builtin(ldouble)
$ test-expr '\''ldo(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldo(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldo(0)'\''
$ test-expr '\''ldo(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldo(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldo(`foo`)'\''
$ test-expr '\''ldo(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldo(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldo(0,1)'\''
$ test-expr '\''ldo(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldo(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldo(`foo`,1)'\''
$ test-expr '\''ldo(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldo(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldo(`foo`,`bar`)'\''
$ test-expr '\''ldo(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldo(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldo(0,`bar`)'\''
$ test-expr '\''ldou'\''
0 call_builtin(ldouble)
$ test-expr '\''ldou()'\''
0 call_builtin(ldouble)
$ test-expr '\''ldou(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldou(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldou(0)'\''
$ test-expr '\''ldou(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldou(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldou(`foo`)'\''
$ test-expr '\''ldou(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldou(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldou(0,1)'\''
$ test-expr '\''ldou(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldou(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldou(`foo`,1)'\''
$ test-expr '\''ldou(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldou(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldou(`foo`,`bar`)'\''
$ test-expr '\''ldou(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldou(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldou(0,`bar`)'\''
$ test-expr '\''ldoub'\''
0 call_builtin(ldouble)
$ test-expr '\''ldoub()'\''
0 call_builtin(ldouble)
$ test-expr '\''ldoub(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldoub(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoub(0)'\''
$ test-expr '\''ldoub(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldoub(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoub(`foo`)'\''
$ test-expr '\''ldoub(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoub(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoub(0,1)'\''
$ test-expr '\''ldoub(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoub(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoub(`foo`,1)'\''
$ test-expr '\''ldoub(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoub(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoub(`foo`,`bar`)'\''
$ test-expr '\''ldoub(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoub(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoub(0,`bar`)'\''
$ test-expr '\''ldoubl'\''
0 call_builtin(ldouble)
$ test-expr '\''ldoubl()'\''
0 call_builtin(ldouble)
$ test-expr '\''ldoubl(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldoubl(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoubl(0)'\''
$ test-expr '\''ldoubl(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldoubl(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoubl(`foo`)'\''
$ test-expr '\''ldoubl(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoubl(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoubl(0,1)'\''
$ test-expr '\''ldoubl(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoubl(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoubl(`foo`,1)'\''
$ test-expr '\''ldoubl(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoubl(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoubl(`foo`,`bar`)'\''
$ test-expr '\''ldoubl(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldoubl(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldoubl(0,`bar`)'\''
$ test-expr '\''ldouble'\''
0 call_builtin(ldouble)
$ test-expr '\''ldouble()'\''
0 call_builtin(ldouble)
$ test-expr '\''ldouble(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldouble(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldouble(0)'\''
$ test-expr '\''ldouble(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: ldouble(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldouble(`foo`)'\''
$ test-expr '\''ldouble(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldouble(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldouble(0,1)'\''
$ test-expr '\''ldouble(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldouble(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldouble(`foo`,1)'\''
$ test-expr '\''ldouble(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldouble(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldouble(`foo`,`bar`)'\''
$ test-expr '\''ldouble(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''ldouble'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: ldouble(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ldouble(0,`bar`)'\''
$ test-expr '\''le'\''
0 call_builtin(len)
$ test-expr '\''le()'\''
0 call_builtin(len)
$ test-expr '\''le(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: le(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''le(0)'\''
$ test-expr '\''le(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: le(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''le(`foo`)'\''
$ test-expr '\''le(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: le(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''le(0,1)'\''
$ test-expr '\''le(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: le(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''le(`foo`,1)'\''
$ test-expr '\''le(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: le(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''le(`foo`,`bar`)'\''
$ test-expr '\''le(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: le(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''le(0,`bar`)'\''
$ test-expr '\''len'\''
0 call_builtin(len)
$ test-expr '\''len()'\''
0 call_builtin(len)
$ test-expr '\''len(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: len(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''len(0)'\''
$ test-expr '\''len(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: len(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''len(`foo`)'\''
$ test-expr '\''len(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: len(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''len(0,1)'\''
$ test-expr '\''len(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: len(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''len(`foo`,1)'\''
$ test-expr '\''len(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: len(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''len(`foo`,`bar`)'\''
$ test-expr '\''len(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''len'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: len(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''len(0,`bar`)'\''
$ test-expr '\''lo'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo'\''
$ test-expr '\''lo()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo()'\''
$ test-expr '\''lo(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo(0)'\''
$ test-expr '\''lo(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo(`foo`)'\''
$ test-expr '\''lo(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo(0,1)'\''
$ test-expr '\''lo(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo(`foo`,1)'\''
$ test-expr '\''lo(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo(`foo`,`bar`)'\''
$ test-expr '\''lo(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lo(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lo(0,`bar`)'\''
$ test-expr '\''lon'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon'\''
$ test-expr '\''lon()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon()'\''
$ test-expr '\''lon(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon(0)'\''
$ test-expr '\''lon(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon(`foo`)'\''
$ test-expr '\''lon(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon(0,1)'\''
$ test-expr '\''lon(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon(`foo`,1)'\''
$ test-expr '\''lon(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon(`foo`,`bar`)'\''
$ test-expr '\''lon(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: lon(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''lon(0,`bar`)'\''
$ test-expr '\''long'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long'\''
$ test-expr '\''long()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long()'\''
$ test-expr '\''long(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long(0)'\''
$ test-expr '\''long(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long(`foo`)'\''
$ test-expr '\''long(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long(0,1)'\''
$ test-expr '\''long(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long(`foo`,1)'\''
$ test-expr '\''long(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long(`foo`,`bar`)'\''
$ test-expr '\''long(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long(0,`bar`)'\''
$ test-expr '\''long_'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_'\''
$ test-expr '\''long_()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_()'\''
$ test-expr '\''long_(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_(0)'\''
$ test-expr '\''long_(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_(`foo`)'\''
$ test-expr '\''long_(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_(0,1)'\''
$ test-expr '\''long_(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_(`foo`,1)'\''
$ test-expr '\''long_(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_(`foo`,`bar`)'\''
$ test-expr '\''long_(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_(0,`bar`)'\''
$ test-expr '\''long_i'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i'\''
$ test-expr '\''long_i()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i()'\''
$ test-expr '\''long_i(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i(0)'\''
$ test-expr '\''long_i(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i(`foo`)'\''
$ test-expr '\''long_i(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i(0,1)'\''
$ test-expr '\''long_i(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i(`foo`,1)'\''
$ test-expr '\''long_i(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i(`foo`,`bar`)'\''
$ test-expr '\''long_i(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_i(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_i(0,`bar`)'\''
$ test-expr '\''long_is'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is'\''
$ test-expr '\''long_is()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is()'\''
$ test-expr '\''long_is(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is(0)'\''
$ test-expr '\''long_is(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is(`foo`)'\''
$ test-expr '\''long_is(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is(0,1)'\''
$ test-expr '\''long_is(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is(`foo`,1)'\''
$ test-expr '\''long_is(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is(`foo`,`bar`)'\''
$ test-expr '\''long_is(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_is(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_is(0,`bar`)'\''
$ test-expr '\''long_iso'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso'\''
$ test-expr '\''long_iso()'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso()'\''
$ test-expr '\''long_iso(0)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso(0)'\''
$ test-expr '\''long_iso(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso(`foo`)'\''
$ test-expr '\''long_iso(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso(0,1)'\''
$ test-expr '\''long_iso(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso(`foo`,1)'\''
$ test-expr '\''long_iso(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso(`foo`,`bar`)'\''
$ test-expr '\''long_iso(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''long_iso'\'' is not a function
test-expr: error:1:1: compiler error: long_iso(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''long_iso(0,`bar`)'\''
$ test-expr '\''n'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n'\''
$ test-expr '\''n()'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n()'\''
$ test-expr '\''n(0)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n(0)'\''
$ test-expr '\''n(`foo`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n(`foo`)'\''
$ test-expr '\''n(0,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n(0,1)'\''
$ test-expr '\''n(`foo`,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n(`foo`,1)'\''
$ test-expr '\''n(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n(`foo`,`bar`)'\''
$ test-expr '\''n(0,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: n(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''n(0,`bar`)'\''
$ test-expr '\''nu'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu'\''
$ test-expr '\''nu()'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu()'\''
$ test-expr '\''nu(0)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu(0)'\''
$ test-expr '\''nu(`foo`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu(`foo`)'\''
$ test-expr '\''nu(0,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu(0,1)'\''
$ test-expr '\''nu(`foo`,1)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu(`foo`,1)'\''
$ test-expr '\''nu(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu(`foo`,`bar`)'\''
$ test-expr '\''nu(0,`bar`)'\''
test-expr: error:1:1: compiler error: unknown builtin
test-expr: error:1:1: compiler error: nu(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nu(0,`bar`)'\''
$ test-expr '\''nul'\''
0 call_builtin(null)
$ test-expr '\''nul()'\''
0 call_builtin(null)
$ test-expr '\''nul(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: nul(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nul(0)'\''
$ test-expr '\''nul(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: nul(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nul(`foo`)'\''
$ test-expr '\''nul(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: nul(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nul(0,1)'\''
$ test-expr '\''nul(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: nul(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nul(`foo`,1)'\''
$ test-expr '\''nul(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: nul(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nul(`foo`,`bar`)'\''
$ test-expr '\''nul(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: nul(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''nul(0,`bar`)'\''
$ test-expr '\''null'\''
0 call_builtin(null)
$ test-expr '\''null()'\''
0 call_builtin(null)
$ test-expr '\''null(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: null(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''null(0)'\''
$ test-expr '\''null(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: null(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''null(`foo`)'\''
$ test-expr '\''null(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: null(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''null(0,1)'\''
$ test-expr '\''null(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: null(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''null(`foo`,1)'\''
$ test-expr '\''null(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: null(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''null(`foo`,`bar`)'\''
$ test-expr '\''null(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''null'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: null(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''null(0,`bar`)'\''
$ test-expr '\''num'\''
0 call_builtin(number)
$ test-expr '\''num()'\''
0 call_builtin(number)
$ test-expr '\''num(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: num(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''num(0)'\''
$ test-expr '\''num(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: num(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''num(`foo`)'\''
$ test-expr '\''num(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: num(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''num(0,1)'\''
$ test-expr '\''num(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: num(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''num(`foo`,1)'\''
$ test-expr '\''num(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: num(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''num(`foo`,`bar`)'\''
$ test-expr '\''num(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: num(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''num(0,`bar`)'\''
$ test-expr '\''numb'\''
0 call_builtin(number)
$ test-expr '\''numb()'\''
0 call_builtin(number)
$ test-expr '\''numb(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: numb(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numb(0)'\''
$ test-expr '\''numb(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: numb(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numb(`foo`)'\''
$ test-expr '\''numb(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numb(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numb(0,1)'\''
$ test-expr '\''numb(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numb(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numb(`foo`,1)'\''
$ test-expr '\''numb(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numb(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numb(`foo`,`bar`)'\''
$ test-expr '\''numb(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numb(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numb(0,`bar`)'\''
$ test-expr '\''numbe'\''
0 call_builtin(number)
$ test-expr '\''numbe()'\''
0 call_builtin(number)
$ test-expr '\''numbe(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: numbe(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numbe(0)'\''
$ test-expr '\''numbe(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: numbe(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numbe(`foo`)'\''
$ test-expr '\''numbe(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numbe(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numbe(0,1)'\''
$ test-expr '\''numbe(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numbe(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numbe(`foo`,1)'\''
$ test-expr '\''numbe(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numbe(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numbe(`foo`,`bar`)'\''
$ test-expr '\''numbe(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: numbe(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''numbe(0,`bar`)'\''
$ test-expr '\''number'\''
0 call_builtin(number)
$ test-expr '\''number()'\''
0 call_builtin(number)
$ test-expr '\''number(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: number(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''number(0)'\''
$ test-expr '\''number(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: number(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''number(`foo`)'\''
$ test-expr '\''number(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: number(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''number(0,1)'\''
$ test-expr '\''number(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: number(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''number(`foo`,1)'\''
$ test-expr '\''number(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: number(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''number(`foo`,`bar`)'\''
$ test-expr '\''number(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''number'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: number(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''number(0,`bar`)'\''
$ test-expr '\''s'\''
0 call_builtin(string)
$ test-expr '\''s()'\''
0 call_builtin(string)
$ test-expr '\''s(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: s(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''s(0)'\''
$ test-expr '\''s(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: s(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''s(`foo`)'\''
$ test-expr '\''s(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: s(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''s(0,1)'\''
$ test-expr '\''s(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: s(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''s(`foo`,1)'\''
$ test-expr '\''s(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: s(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''s(`foo`,`bar`)'\''
$ test-expr '\''s(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: s(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''s(0,`bar`)'\''
$ test-expr '\''st'\''
0 call_builtin(string)
$ test-expr '\''st()'\''
0 call_builtin(string)
$ test-expr '\''st(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: st(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''st(0)'\''
$ test-expr '\''st(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: st(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''st(`foo`)'\''
$ test-expr '\''st(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: st(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''st(0,1)'\''
$ test-expr '\''st(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: st(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''st(`foo`,1)'\''
$ test-expr '\''st(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: st(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''st(`foo`,`bar`)'\''
$ test-expr '\''st(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: st(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''st(0,`bar`)'\''
$ test-expr '\''str'\''
0 call_builtin(string)
$ test-expr '\''str()'\''
0 call_builtin(string)
$ test-expr '\''str(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: str(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''str(0)'\''
$ test-expr '\''str(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: str(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''str(`foo`)'\''
$ test-expr '\''str(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: str(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''str(0,1)'\''
$ test-expr '\''str(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: str(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''str(`foo`,1)'\''
$ test-expr '\''str(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: str(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''str(`foo`,`bar`)'\''
$ test-expr '\''str(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: str(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''str(0,`bar`)'\''
$ test-expr '\''stri'\''
0 call_builtin(string)
$ test-expr '\''stri()'\''
0 call_builtin(string)
$ test-expr '\''stri(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: stri(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''stri(0)'\''
$ test-expr '\''stri(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: stri(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''stri(`foo`)'\''
$ test-expr '\''stri(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: stri(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''stri(0,1)'\''
$ test-expr '\''stri(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: stri(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''stri(`foo`,1)'\''
$ test-expr '\''stri(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: stri(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''stri(`foo`,`bar`)'\''
$ test-expr '\''stri(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: stri(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''stri(0,`bar`)'\''
$ test-expr '\''strin'\''
0 call_builtin(string)
$ test-expr '\''strin()'\''
0 call_builtin(string)
$ test-expr '\''strin(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: strin(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''strin(0)'\''
$ test-expr '\''strin(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: strin(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''strin(`foo`)'\''
$ test-expr '\''strin(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: strin(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''strin(0,1)'\''
$ test-expr '\''strin(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: strin(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''strin(`foo`,1)'\''
$ test-expr '\''strin(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: strin(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''strin(`foo`,`bar`)'\''
$ test-expr '\''strin(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: strin(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''strin(0,`bar`)'\''
$ test-expr '\''string'\''
0 call_builtin(string)
$ test-expr '\''string()'\''
0 call_builtin(string)
$ test-expr '\''string(0)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: string(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''string(0)'\''
$ test-expr '\''string(`foo`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 1
test-expr: error:1:1: compiler error: string(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''string(`foo`)'\''
$ test-expr '\''string(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: string(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''string(0,1)'\''
$ test-expr '\''string(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: string(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''string(`foo`,1)'\''
$ test-expr '\''string(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: string(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''string(`foo`,`bar`)'\''
$ test-expr '\''string(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''string'\'': expected 0 args, but got 2
test-expr: error:1:1: compiler error: string(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''string(0,`bar`)'\''
$ test-expr '\''t'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t'\''
$ test-expr '\''t()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t()'\''
$ test-expr '\''t(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t(0)'\''
$ test-expr '\''t(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t(`foo`)'\''
$ test-expr '\''t(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t(0,1)'\''
$ test-expr '\''t(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t(`foo`,1)'\''
$ test-expr '\''t(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t(`foo`,`bar`)'\''
$ test-expr '\''t(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: t(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''t(0,`bar`)'\''
$ test-expr '\''ti'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti'\''
$ test-expr '\''ti()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti()'\''
$ test-expr '\''ti(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti(0)'\''
$ test-expr '\''ti(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti(`foo`)'\''
$ test-expr '\''ti(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti(0,1)'\''
$ test-expr '\''ti(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti(`foo`,1)'\''
$ test-expr '\''ti(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti(`foo`,`bar`)'\''
$ test-expr '\''ti(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: ti(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ti(0,`bar`)'\''
$ test-expr '\''tim'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim'\''
$ test-expr '\''tim()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim()'\''
$ test-expr '\''tim(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim(0)'\''
$ test-expr '\''tim(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim(`foo`)'\''
$ test-expr '\''tim(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim(0,1)'\''
$ test-expr '\''tim(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim(`foo`,1)'\''
$ test-expr '\''tim(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim(`foo`,`bar`)'\''
$ test-expr '\''tim(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: tim(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''tim(0,`bar`)'\''
$ test-expr '\''time'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time'\''
$ test-expr '\''time()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time()'\''
$ test-expr '\''time(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time(0)'\''
$ test-expr '\''time(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time(`foo`)'\''
$ test-expr '\''time(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time(0,1)'\''
$ test-expr '\''time(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time(`foo`,1)'\''
$ test-expr '\''time(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time(`foo`,`bar`)'\''
$ test-expr '\''time(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: time(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''time(0,`bar`)'\''
$ test-expr '\''times'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times'\''
$ test-expr '\''times()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times()'\''
$ test-expr '\''times(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times(0)'\''
$ test-expr '\''times(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times(`foo`)'\''
$ test-expr '\''times(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times(0,1)'\''
$ test-expr '\''times(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times(`foo`,1)'\''
$ test-expr '\''times(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times(`foo`,`bar`)'\''
$ test-expr '\''times(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: times(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''times(0,`bar`)'\''
$ test-expr '\''timest'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest'\''
$ test-expr '\''timest()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest()'\''
$ test-expr '\''timest(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest(0)'\''
$ test-expr '\''timest(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest(`foo`)'\''
$ test-expr '\''timest(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest(0,1)'\''
$ test-expr '\''timest(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest(`foo`,1)'\''
$ test-expr '\''timest(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest(`foo`,`bar`)'\''
$ test-expr '\''timest(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timest(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timest(0,`bar`)'\''
$ test-expr '\''timesta'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta'\''
$ test-expr '\''timesta()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta()'\''
$ test-expr '\''timesta(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta(0)'\''
$ test-expr '\''timesta(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta(`foo`)'\''
$ test-expr '\''timesta(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta(0,1)'\''
$ test-expr '\''timesta(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta(`foo`,1)'\''
$ test-expr '\''timesta(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta(`foo`,`bar`)'\''
$ test-expr '\''timesta(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timesta(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timesta(0,`bar`)'\''
$ test-expr '\''timestam'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam'\''
$ test-expr '\''timestam()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam()'\''
$ test-expr '\''timestam(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam(0)'\''
$ test-expr '\''timestam(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam(`foo`)'\''
$ test-expr '\''timestam(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam(0,1)'\''
$ test-expr '\''timestam(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam(`foo`,1)'\''
$ test-expr '\''timestam(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam(`foo`,`bar`)'\''
$ test-expr '\''timestam(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestam(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestam(0,`bar`)'\''
$ test-expr '\''timestamp'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp'\''
$ test-expr '\''timestamp()'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp()'\''
$ test-expr '\''timestamp(0)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp(0)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp(0)'\''
$ test-expr '\''timestamp(`foo`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp(`foo`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp(`foo`)'\''
$ test-expr '\''timestamp(0,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp(0,1)'\''
$ test-expr '\''timestamp(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp(`foo`,1)'\''
$ test-expr '\''timestamp(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp(`foo`,`bar`)'\''
$ test-expr '\''timestamp(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin '\''timestamp'\'' is not a function
test-expr: error:1:1: compiler error: timestamp(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''timestamp(0,`bar`)'\''
$ test-expr '\''u'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: u
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''u'\''
$ test-expr '\''u()'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: u()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''u()'\''
$ test-expr '\''u(0)'\''
0 const_num(0)
1 call_builtin(uint)
$ test-expr '\''u(`foo`)'\''
test-expr: error:1:3: compiler error: builtin function '\''uint'\'': arg #1 type mismatch: expected a number
test-expr: error:1:3: compiler error: u(`foo`)
test-expr: error:1:3: compiler error:   ^
command failed: test-expr '\''u(`foo`)'\''
$ test-expr '\''u(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: u(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''u(0,1)'\''
$ test-expr '\''u(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: u(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''u(`foo`,1)'\''
$ test-expr '\''u(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: u(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''u(`foo`,`bar`)'\''
$ test-expr '\''u(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: u(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''u(0,`bar`)'\''
$ test-expr '\''ui'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: ui
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ui'\''
$ test-expr '\''ui()'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: ui()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ui()'\''
$ test-expr '\''ui(0)'\''
0 const_num(0)
1 call_builtin(uint)
$ test-expr '\''ui(`foo`)'\''
test-expr: error:1:4: compiler error: builtin function '\''uint'\'': arg #1 type mismatch: expected a number
test-expr: error:1:4: compiler error: ui(`foo`)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr '\''ui(`foo`)'\''
$ test-expr '\''ui(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: ui(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ui(0,1)'\''
$ test-expr '\''ui(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: ui(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ui(`foo`,1)'\''
$ test-expr '\''ui(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: ui(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ui(`foo`,`bar`)'\''
$ test-expr '\''ui(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: ui(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''ui(0,`bar`)'\''
$ test-expr '\''uin'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: uin
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uin'\''
$ test-expr '\''uin()'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: uin()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uin()'\''
$ test-expr '\''uin(0)'\''
0 const_num(0)
1 call_builtin(uint)
$ test-expr '\''uin(`foo`)'\''
test-expr: error:1:5: compiler error: builtin function '\''uint'\'': arg #1 type mismatch: expected a number
test-expr: error:1:5: compiler error: uin(`foo`)
test-expr: error:1:5: compiler error:     ^
command failed: test-expr '\''uin(`foo`)'\''
$ test-expr '\''uin(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uin(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uin(0,1)'\''
$ test-expr '\''uin(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uin(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uin(`foo`,1)'\''
$ test-expr '\''uin(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uin(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uin(`foo`,`bar`)'\''
$ test-expr '\''uin(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uin(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uin(0,`bar`)'\''
$ test-expr '\''uint'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: uint
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uint'\''
$ test-expr '\''uint()'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 0
test-expr: error:1:1: compiler error: uint()
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uint()'\''
$ test-expr '\''uint(0)'\''
0 const_num(0)
1 call_builtin(uint)
$ test-expr '\''uint(`foo`)'\''
test-expr: error:1:6: compiler error: builtin function '\''uint'\'': arg #1 type mismatch: expected a number
test-expr: error:1:6: compiler error: uint(`foo`)
test-expr: error:1:6: compiler error:      ^
command failed: test-expr '\''uint(`foo`)'\''
$ test-expr '\''uint(0,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uint(0,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uint(0,1)'\''
$ test-expr '\''uint(`foo`,1)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uint(`foo`,1)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uint(`foo`,1)'\''
$ test-expr '\''uint(`foo`,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uint(`foo`,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uint(`foo`,`bar`)'\''
$ test-expr '\''uint(0,`bar`)'\''
test-expr: error:1:1: compiler error: builtin function '\''uint'\'': expected 1 arg, but got 2
test-expr: error:1:1: compiler error: uint(0,`bar`)
test-expr: error:1:1: compiler error: ^
command failed: test-expr '\''uint(0,`bar`)'\'''
) -L builtins.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -C'\'''
alias test-expr='test-expr -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -C'\'''

echo '$ test-expr '\''b'\'''
test-expr 'b' 2>&1 ||
echo 'command failed: test-expr '\''b'\'''

echo '$ test-expr '\''b()'\'''
test-expr 'b()' 2>&1 ||
echo 'command failed: test-expr '\''b()'\'''

echo '$ test-expr '\''b(0)'\'''
test-expr 'b(0)' 2>&1 ||
echo 'command failed: test-expr '\''b(0)'\'''

echo '$ test-expr '\''b(`foo`)'\'''
test-expr 'b(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''b(`foo`)'\'''

echo '$ test-expr '\''b(0,1)'\'''
test-expr 'b(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''b(0,1)'\'''

echo '$ test-expr '\''b(`foo`,1)'\'''
test-expr 'b(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''b(`foo`,1)'\'''

echo '$ test-expr '\''b(`foo`,`bar`)'\'''
test-expr 'b(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''b(`foo`,`bar`)'\'''

echo '$ test-expr '\''b(0,`bar`)'\'''
test-expr 'b(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''b(0,`bar`)'\'''

echo '$ test-expr '\''bo'\'''
test-expr 'bo' 2>&1 ||
echo 'command failed: test-expr '\''bo'\'''

echo '$ test-expr '\''bo()'\'''
test-expr 'bo()' 2>&1 ||
echo 'command failed: test-expr '\''bo()'\'''

echo '$ test-expr '\''bo(0)'\'''
test-expr 'bo(0)' 2>&1 ||
echo 'command failed: test-expr '\''bo(0)'\'''

echo '$ test-expr '\''bo(`foo`)'\'''
test-expr 'bo(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''bo(`foo`)'\'''

echo '$ test-expr '\''bo(0,1)'\'''
test-expr 'bo(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''bo(0,1)'\'''

echo '$ test-expr '\''bo(`foo`,1)'\'''
test-expr 'bo(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''bo(`foo`,1)'\'''

echo '$ test-expr '\''bo(`foo`,`bar`)'\'''
test-expr 'bo(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''bo(`foo`,`bar`)'\'''

echo '$ test-expr '\''bo(0,`bar`)'\'''
test-expr 'bo(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''bo(0,`bar`)'\'''

echo '$ test-expr '\''boo'\'''
test-expr 'boo' 2>&1 ||
echo 'command failed: test-expr '\''boo'\'''

echo '$ test-expr '\''boo()'\'''
test-expr 'boo()' 2>&1 ||
echo 'command failed: test-expr '\''boo()'\'''

echo '$ test-expr '\''boo(0)'\'''
test-expr 'boo(0)' 2>&1 ||
echo 'command failed: test-expr '\''boo(0)'\'''

echo '$ test-expr '\''boo(`foo`)'\'''
test-expr 'boo(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''boo(`foo`)'\'''

echo '$ test-expr '\''boo(0,1)'\'''
test-expr 'boo(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''boo(0,1)'\'''

echo '$ test-expr '\''boo(`foo`,1)'\'''
test-expr 'boo(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''boo(`foo`,1)'\'''

echo '$ test-expr '\''boo(`foo`,`bar`)'\'''
test-expr 'boo(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boo(`foo`,`bar`)'\'''

echo '$ test-expr '\''boo(0,`bar`)'\'''
test-expr 'boo(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boo(0,`bar`)'\'''

echo '$ test-expr '\''bool'\'''
test-expr 'bool' 2>&1 ||
echo 'command failed: test-expr '\''bool'\'''

echo '$ test-expr '\''bool()'\'''
test-expr 'bool()' 2>&1 ||
echo 'command failed: test-expr '\''bool()'\'''

echo '$ test-expr '\''bool(0)'\'''
test-expr 'bool(0)' 2>&1 ||
echo 'command failed: test-expr '\''bool(0)'\'''

echo '$ test-expr '\''bool(`foo`)'\'''
test-expr 'bool(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''bool(`foo`)'\'''

echo '$ test-expr '\''bool(0,1)'\'''
test-expr 'bool(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''bool(0,1)'\'''

echo '$ test-expr '\''bool(`foo`,1)'\'''
test-expr 'bool(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''bool(`foo`,1)'\'''

echo '$ test-expr '\''bool(`foo`,`bar`)'\'''
test-expr 'bool(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''bool(`foo`,`bar`)'\'''

echo '$ test-expr '\''bool(0,`bar`)'\'''
test-expr 'bool(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''bool(0,`bar`)'\'''

echo '$ test-expr '\''boole'\'''
test-expr 'boole' 2>&1 ||
echo 'command failed: test-expr '\''boole'\'''

echo '$ test-expr '\''boole()'\'''
test-expr 'boole()' 2>&1 ||
echo 'command failed: test-expr '\''boole()'\'''

echo '$ test-expr '\''boole(0)'\'''
test-expr 'boole(0)' 2>&1 ||
echo 'command failed: test-expr '\''boole(0)'\'''

echo '$ test-expr '\''boole(`foo`)'\'''
test-expr 'boole(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''boole(`foo`)'\'''

echo '$ test-expr '\''boole(0,1)'\'''
test-expr 'boole(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''boole(0,1)'\'''

echo '$ test-expr '\''boole(`foo`,1)'\'''
test-expr 'boole(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''boole(`foo`,1)'\'''

echo '$ test-expr '\''boole(`foo`,`bar`)'\'''
test-expr 'boole(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boole(`foo`,`bar`)'\'''

echo '$ test-expr '\''boole(0,`bar`)'\'''
test-expr 'boole(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boole(0,`bar`)'\'''

echo '$ test-expr '\''boolea'\'''
test-expr 'boolea' 2>&1 ||
echo 'command failed: test-expr '\''boolea'\'''

echo '$ test-expr '\''boolea()'\'''
test-expr 'boolea()' 2>&1 ||
echo 'command failed: test-expr '\''boolea()'\'''

echo '$ test-expr '\''boolea(0)'\'''
test-expr 'boolea(0)' 2>&1 ||
echo 'command failed: test-expr '\''boolea(0)'\'''

echo '$ test-expr '\''boolea(`foo`)'\'''
test-expr 'boolea(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''boolea(`foo`)'\'''

echo '$ test-expr '\''boolea(0,1)'\'''
test-expr 'boolea(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''boolea(0,1)'\'''

echo '$ test-expr '\''boolea(`foo`,1)'\'''
test-expr 'boolea(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''boolea(`foo`,1)'\'''

echo '$ test-expr '\''boolea(`foo`,`bar`)'\'''
test-expr 'boolea(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boolea(`foo`,`bar`)'\'''

echo '$ test-expr '\''boolea(0,`bar`)'\'''
test-expr 'boolea(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boolea(0,`bar`)'\'''

echo '$ test-expr '\''boolean'\'''
test-expr 'boolean' 2>&1 ||
echo 'command failed: test-expr '\''boolean'\'''

echo '$ test-expr '\''boolean()'\'''
test-expr 'boolean()' 2>&1 ||
echo 'command failed: test-expr '\''boolean()'\'''

echo '$ test-expr '\''boolean(0)'\'''
test-expr 'boolean(0)' 2>&1 ||
echo 'command failed: test-expr '\''boolean(0)'\'''

echo '$ test-expr '\''boolean(`foo`)'\'''
test-expr 'boolean(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''boolean(`foo`)'\'''

echo '$ test-expr '\''boolean(0,1)'\'''
test-expr 'boolean(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''boolean(0,1)'\'''

echo '$ test-expr '\''boolean(`foo`,1)'\'''
test-expr 'boolean(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''boolean(`foo`,1)'\'''

echo '$ test-expr '\''boolean(`foo`,`bar`)'\'''
test-expr 'boolean(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boolean(`foo`,`bar`)'\'''

echo '$ test-expr '\''boolean(0,`bar`)'\'''
test-expr 'boolean(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''boolean(0,`bar`)'\'''

echo '$ test-expr '\''c'\'''
test-expr 'c' 2>&1 ||
echo 'command failed: test-expr '\''c'\'''

echo '$ test-expr '\''c()'\'''
test-expr 'c()' 2>&1 ||
echo 'command failed: test-expr '\''c()'\'''

echo '$ test-expr '\''c(0)'\'''
test-expr 'c(0)' 2>&1 ||
echo 'command failed: test-expr '\''c(0)'\'''

echo '$ test-expr '\''c(`foo`)'\'''
test-expr 'c(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c(`foo`)'\'''

echo '$ test-expr '\''c(0,1)'\'''
test-expr 'c(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c(0,1)'\'''

echo '$ test-expr '\''c(`foo`,1)'\'''
test-expr 'c(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c(`foo`,1)'\'''

echo '$ test-expr '\''c(`foo`,`bar`)'\'''
test-expr 'c(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c(`foo`,`bar`)'\'''

echo '$ test-expr '\''c(0,`bar`)'\'''
test-expr 'c(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c(0,`bar`)'\'''

echo '$ test-expr '\''c_'\'''
test-expr 'c_' 2>&1 ||
echo 'command failed: test-expr '\''c_'\'''

echo '$ test-expr '\''c_()'\'''
test-expr 'c_()' 2>&1 ||
echo 'command failed: test-expr '\''c_()'\'''

echo '$ test-expr '\''c_(0)'\'''
test-expr 'c_(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_(0)'\'''

echo '$ test-expr '\''c_(`foo`)'\'''
test-expr 'c_(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_(`foo`)'\'''

echo '$ test-expr '\''c_(0,1)'\'''
test-expr 'c_(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_(0,1)'\'''

echo '$ test-expr '\''c_(`foo`,1)'\'''
test-expr 'c_(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_(`foo`,1)'\'''

echo '$ test-expr '\''c_(`foo`,`bar`)'\'''
test-expr 'c_(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_(0,`bar`)'\'''
test-expr 'c_(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_(0,`bar`)'\'''

echo '$ test-expr '\''c_l'\'''
test-expr 'c_l' 2>&1 ||
echo 'command failed: test-expr '\''c_l'\'''

echo '$ test-expr '\''c_l()'\'''
test-expr 'c_l()' 2>&1 ||
echo 'command failed: test-expr '\''c_l()'\'''

echo '$ test-expr '\''c_l(0)'\'''
test-expr 'c_l(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_l(0)'\'''

echo '$ test-expr '\''c_l(`foo`)'\'''
test-expr 'c_l(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_l(`foo`)'\'''

echo '$ test-expr '\''c_l(0,1)'\'''
test-expr 'c_l(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_l(0,1)'\'''

echo '$ test-expr '\''c_l(`foo`,1)'\'''
test-expr 'c_l(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_l(`foo`,1)'\'''

echo '$ test-expr '\''c_l(`foo`,`bar`)'\'''
test-expr 'c_l(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_l(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_l(0,`bar`)'\'''
test-expr 'c_l(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_l(0,`bar`)'\'''

echo '$ test-expr '\''c_lo'\'''
test-expr 'c_lo' 2>&1 ||
echo 'command failed: test-expr '\''c_lo'\'''

echo '$ test-expr '\''c_lo()'\'''
test-expr 'c_lo()' 2>&1 ||
echo 'command failed: test-expr '\''c_lo()'\'''

echo '$ test-expr '\''c_lo(0)'\'''
test-expr 'c_lo(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_lo(0)'\'''

echo '$ test-expr '\''c_lo(`foo`)'\'''
test-expr 'c_lo(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_lo(`foo`)'\'''

echo '$ test-expr '\''c_lo(0,1)'\'''
test-expr 'c_lo(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_lo(0,1)'\'''

echo '$ test-expr '\''c_lo(`foo`,1)'\'''
test-expr 'c_lo(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_lo(`foo`,1)'\'''

echo '$ test-expr '\''c_lo(`foo`,`bar`)'\'''
test-expr 'c_lo(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_lo(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_lo(0,`bar`)'\'''
test-expr 'c_lo(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_lo(0,`bar`)'\'''

echo '$ test-expr '\''c_loc'\'''
test-expr 'c_loc' 2>&1 ||
echo 'command failed: test-expr '\''c_loc'\'''

echo '$ test-expr '\''c_loc()'\'''
test-expr 'c_loc()' 2>&1 ||
echo 'command failed: test-expr '\''c_loc()'\'''

echo '$ test-expr '\''c_loc(0)'\'''
test-expr 'c_loc(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_loc(0)'\'''

echo '$ test-expr '\''c_loc(`foo`)'\'''
test-expr 'c_loc(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_loc(`foo`)'\'''

echo '$ test-expr '\''c_loc(0,1)'\'''
test-expr 'c_loc(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_loc(0,1)'\'''

echo '$ test-expr '\''c_loc(`foo`,1)'\'''
test-expr 'c_loc(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_loc(`foo`,1)'\'''

echo '$ test-expr '\''c_loc(`foo`,`bar`)'\'''
test-expr 'c_loc(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_loc(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_loc(0,`bar`)'\'''
test-expr 'c_loc(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_loc(0,`bar`)'\'''

echo '$ test-expr '\''c_loca'\'''
test-expr 'c_loca' 2>&1 ||
echo 'command failed: test-expr '\''c_loca'\'''

echo '$ test-expr '\''c_loca()'\'''
test-expr 'c_loca()' 2>&1 ||
echo 'command failed: test-expr '\''c_loca()'\'''

echo '$ test-expr '\''c_loca(0)'\'''
test-expr 'c_loca(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_loca(0)'\'''

echo '$ test-expr '\''c_loca(`foo`)'\'''
test-expr 'c_loca(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_loca(`foo`)'\'''

echo '$ test-expr '\''c_loca(0,1)'\'''
test-expr 'c_loca(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_loca(0,1)'\'''

echo '$ test-expr '\''c_loca(`foo`,1)'\'''
test-expr 'c_loca(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_loca(`foo`,1)'\'''

echo '$ test-expr '\''c_loca(`foo`,`bar`)'\'''
test-expr 'c_loca(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_loca(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_loca(0,`bar`)'\'''
test-expr 'c_loca(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_loca(0,`bar`)'\'''

echo '$ test-expr '\''c_local'\'''
test-expr 'c_local' 2>&1 ||
echo 'command failed: test-expr '\''c_local'\'''

echo '$ test-expr '\''c_local()'\'''
test-expr 'c_local()' 2>&1 ||
echo 'command failed: test-expr '\''c_local()'\'''

echo '$ test-expr '\''c_local(0)'\'''
test-expr 'c_local(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_local(0)'\'''

echo '$ test-expr '\''c_local(`foo`)'\'''
test-expr 'c_local(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_local(`foo`)'\'''

echo '$ test-expr '\''c_local(0,1)'\'''
test-expr 'c_local(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_local(0,1)'\'''

echo '$ test-expr '\''c_local(`foo`,1)'\'''
test-expr 'c_local(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_local(`foo`,1)'\'''

echo '$ test-expr '\''c_local(`foo`,`bar`)'\'''
test-expr 'c_local(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_local(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_local(0,`bar`)'\'''
test-expr 'c_local(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_local(0,`bar`)'\'''

echo '$ test-expr '\''c_locale'\'''
test-expr 'c_locale' 2>&1 ||
echo 'command failed: test-expr '\''c_locale'\'''

echo '$ test-expr '\''c_locale()'\'''
test-expr 'c_locale()' 2>&1 ||
echo 'command failed: test-expr '\''c_locale()'\'''

echo '$ test-expr '\''c_locale(0)'\'''
test-expr 'c_locale(0)' 2>&1 ||
echo 'command failed: test-expr '\''c_locale(0)'\'''

echo '$ test-expr '\''c_locale(`foo`)'\'''
test-expr 'c_locale(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''c_locale(`foo`)'\'''

echo '$ test-expr '\''c_locale(0,1)'\'''
test-expr 'c_locale(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_locale(0,1)'\'''

echo '$ test-expr '\''c_locale(`foo`,1)'\'''
test-expr 'c_locale(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''c_locale(`foo`,1)'\'''

echo '$ test-expr '\''c_locale(`foo`,`bar`)'\'''
test-expr 'c_locale(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_locale(`foo`,`bar`)'\'''

echo '$ test-expr '\''c_locale(0,`bar`)'\'''
test-expr 'c_locale(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''c_locale(0,`bar`)'\'''

echo '$ test-expr '\''d'\'''
test-expr 'd' 2>&1 ||
echo 'command failed: test-expr '\''d'\'''

echo '$ test-expr '\''d()'\'''
test-expr 'd()' 2>&1 ||
echo 'command failed: test-expr '\''d()'\'''

echo '$ test-expr '\''d(0)'\'''
test-expr 'd(0)' 2>&1 ||
echo 'command failed: test-expr '\''d(0)'\'''

echo '$ test-expr '\''d(`foo`)'\'''
test-expr 'd(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''d(`foo`)'\'''

echo '$ test-expr '\''d(0,1)'\'''
test-expr 'd(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''d(0,1)'\'''

echo '$ test-expr '\''d(`foo`,1)'\'''
test-expr 'd(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''d(`foo`,1)'\'''

echo '$ test-expr '\''d(`foo`,`bar`)'\'''
test-expr 'd(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''d(`foo`,`bar`)'\'''

echo '$ test-expr '\''d(0,`bar`)'\'''
test-expr 'd(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''d(0,`bar`)'\'''

echo '$ test-expr '\''da'\'''
test-expr 'da' 2>&1 ||
echo 'command failed: test-expr '\''da'\'''

echo '$ test-expr '\''da()'\'''
test-expr 'da()' 2>&1 ||
echo 'command failed: test-expr '\''da()'\'''

echo '$ test-expr '\''da(0)'\'''
test-expr 'da(0)' 2>&1 ||
echo 'command failed: test-expr '\''da(0)'\'''

echo '$ test-expr '\''da(`foo`)'\'''
test-expr 'da(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''da(`foo`)'\'''

echo '$ test-expr '\''da(0,1)'\'''
test-expr 'da(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''da(0,1)'\'''

echo '$ test-expr '\''da(`foo`,1)'\'''
test-expr 'da(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''da(`foo`,1)'\'''

echo '$ test-expr '\''da(`foo`,`bar`)'\'''
test-expr 'da(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''da(`foo`,`bar`)'\'''

echo '$ test-expr '\''da(0,`bar`)'\'''
test-expr 'da(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''da(0,`bar`)'\'''

echo '$ test-expr '\''dat'\'''
test-expr 'dat' 2>&1 ||
echo 'command failed: test-expr '\''dat'\'''

echo '$ test-expr '\''dat()'\'''
test-expr 'dat()' 2>&1 ||
echo 'command failed: test-expr '\''dat()'\'''

echo '$ test-expr '\''dat(0)'\'''
test-expr 'dat(0)' 2>&1 ||
echo 'command failed: test-expr '\''dat(0)'\'''

echo '$ test-expr '\''dat(`foo`)'\'''
test-expr 'dat(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''dat(`foo`)'\'''

echo '$ test-expr '\''dat(0,1)'\'''
test-expr 'dat(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''dat(0,1)'\'''

echo '$ test-expr '\''dat(`foo`,1)'\'''
test-expr 'dat(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''dat(`foo`,1)'\'''

echo '$ test-expr '\''dat(`foo`,`bar`)'\'''
test-expr 'dat(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''dat(`foo`,`bar`)'\'''

echo '$ test-expr '\''dat(0,`bar`)'\'''
test-expr 'dat(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''dat(0,`bar`)'\'''

echo '$ test-expr '\''date'\'''
test-expr 'date' 2>&1 ||
echo 'command failed: test-expr '\''date'\'''

echo '$ test-expr '\''date()'\'''
test-expr 'date()' 2>&1 ||
echo 'command failed: test-expr '\''date()'\'''

echo '$ test-expr '\''date(0)'\'''
test-expr 'date(0)' 2>&1 ||
echo 'command failed: test-expr '\''date(0)'\'''

echo '$ test-expr '\''date(`foo`)'\'''
test-expr 'date(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo`)'\'''

echo '$ test-expr '\''date(0,1)'\'''
test-expr 'date(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''date(0,1)'\'''

echo '$ test-expr '\''date(`foo`,1)'\'''
test-expr 'date(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo`,1)'\'''

echo '$ test-expr '\''date(`foo`,`bar`)'\'''
test-expr 'date(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo`,`bar`)'\'''

echo '$ test-expr '\''date(0,`bar`)'\'''
test-expr 'date(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''date(0,`bar`)'\'''

echo '$ test-expr '\''do'\'''
test-expr 'do' 2>&1 ||
echo 'command failed: test-expr '\''do'\'''

echo '$ test-expr '\''do()'\'''
test-expr 'do()' 2>&1 ||
echo 'command failed: test-expr '\''do()'\'''

echo '$ test-expr '\''do(0)'\'''
test-expr 'do(0)' 2>&1 ||
echo 'command failed: test-expr '\''do(0)'\'''

echo '$ test-expr '\''do(`foo`)'\'''
test-expr 'do(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''do(`foo`)'\'''

echo '$ test-expr '\''do(0,1)'\'''
test-expr 'do(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''do(0,1)'\'''

echo '$ test-expr '\''do(`foo`,1)'\'''
test-expr 'do(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''do(`foo`,1)'\'''

echo '$ test-expr '\''do(`foo`,`bar`)'\'''
test-expr 'do(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''do(`foo`,`bar`)'\'''

echo '$ test-expr '\''do(0,`bar`)'\'''
test-expr 'do(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''do(0,`bar`)'\'''

echo '$ test-expr '\''dou'\'''
test-expr 'dou' 2>&1 ||
echo 'command failed: test-expr '\''dou'\'''

echo '$ test-expr '\''dou()'\'''
test-expr 'dou()' 2>&1 ||
echo 'command failed: test-expr '\''dou()'\'''

echo '$ test-expr '\''dou(0)'\'''
test-expr 'dou(0)' 2>&1 ||
echo 'command failed: test-expr '\''dou(0)'\'''

echo '$ test-expr '\''dou(`foo`)'\'''
test-expr 'dou(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''dou(`foo`)'\'''

echo '$ test-expr '\''dou(0,1)'\'''
test-expr 'dou(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''dou(0,1)'\'''

echo '$ test-expr '\''dou(`foo`,1)'\'''
test-expr 'dou(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''dou(`foo`,1)'\'''

echo '$ test-expr '\''dou(`foo`,`bar`)'\'''
test-expr 'dou(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''dou(`foo`,`bar`)'\'''

echo '$ test-expr '\''dou(0,`bar`)'\'''
test-expr 'dou(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''dou(0,`bar`)'\'''

echo '$ test-expr '\''doub'\'''
test-expr 'doub' 2>&1 ||
echo 'command failed: test-expr '\''doub'\'''

echo '$ test-expr '\''doub()'\'''
test-expr 'doub()' 2>&1 ||
echo 'command failed: test-expr '\''doub()'\'''

echo '$ test-expr '\''doub(0)'\'''
test-expr 'doub(0)' 2>&1 ||
echo 'command failed: test-expr '\''doub(0)'\'''

echo '$ test-expr '\''doub(`foo`)'\'''
test-expr 'doub(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''doub(`foo`)'\'''

echo '$ test-expr '\''doub(0,1)'\'''
test-expr 'doub(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''doub(0,1)'\'''

echo '$ test-expr '\''doub(`foo`,1)'\'''
test-expr 'doub(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''doub(`foo`,1)'\'''

echo '$ test-expr '\''doub(`foo`,`bar`)'\'''
test-expr 'doub(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''doub(`foo`,`bar`)'\'''

echo '$ test-expr '\''doub(0,`bar`)'\'''
test-expr 'doub(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''doub(0,`bar`)'\'''

echo '$ test-expr '\''doubl'\'''
test-expr 'doubl' 2>&1 ||
echo 'command failed: test-expr '\''doubl'\'''

echo '$ test-expr '\''doubl()'\'''
test-expr 'doubl()' 2>&1 ||
echo 'command failed: test-expr '\''doubl()'\'''

echo '$ test-expr '\''doubl(0)'\'''
test-expr 'doubl(0)' 2>&1 ||
echo 'command failed: test-expr '\''doubl(0)'\'''

echo '$ test-expr '\''doubl(`foo`)'\'''
test-expr 'doubl(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''doubl(`foo`)'\'''

echo '$ test-expr '\''doubl(0,1)'\'''
test-expr 'doubl(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''doubl(0,1)'\'''

echo '$ test-expr '\''doubl(`foo`,1)'\'''
test-expr 'doubl(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''doubl(`foo`,1)'\'''

echo '$ test-expr '\''doubl(`foo`,`bar`)'\'''
test-expr 'doubl(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''doubl(`foo`,`bar`)'\'''

echo '$ test-expr '\''doubl(0,`bar`)'\'''
test-expr 'doubl(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''doubl(0,`bar`)'\'''

echo '$ test-expr '\''double'\'''
test-expr 'double' 2>&1 ||
echo 'command failed: test-expr '\''double'\'''

echo '$ test-expr '\''double()'\'''
test-expr 'double()' 2>&1 ||
echo 'command failed: test-expr '\''double()'\'''

echo '$ test-expr '\''double(0)'\'''
test-expr 'double(0)' 2>&1 ||
echo 'command failed: test-expr '\''double(0)'\'''

echo '$ test-expr '\''double(`foo`)'\'''
test-expr 'double(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''double(`foo`)'\'''

echo '$ test-expr '\''double(0,1)'\'''
test-expr 'double(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''double(0,1)'\'''

echo '$ test-expr '\''double(`foo`,1)'\'''
test-expr 'double(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''double(`foo`,1)'\'''

echo '$ test-expr '\''double(`foo`,`bar`)'\'''
test-expr 'double(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''double(`foo`,`bar`)'\'''

echo '$ test-expr '\''double(0,`bar`)'\'''
test-expr 'double(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''double(0,`bar`)'\'''

echo '$ test-expr '\''f'\'''
test-expr 'f' 2>&1 ||
echo 'command failed: test-expr '\''f'\'''

echo '$ test-expr '\''f()'\'''
test-expr 'f()' 2>&1 ||
echo 'command failed: test-expr '\''f()'\'''

echo '$ test-expr '\''f(0)'\'''
test-expr 'f(0)' 2>&1 ||
echo 'command failed: test-expr '\''f(0)'\'''

echo '$ test-expr '\''f(`foo`)'\'''
test-expr 'f(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''f(`foo`)'\'''

echo '$ test-expr '\''f(0,1)'\'''
test-expr 'f(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''f(0,1)'\'''

echo '$ test-expr '\''f(`foo`,1)'\'''
test-expr 'f(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''f(`foo`,1)'\'''

echo '$ test-expr '\''f(`foo`,`bar`)'\'''
test-expr 'f(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''f(`foo`,`bar`)'\'''

echo '$ test-expr '\''f(0,`bar`)'\'''
test-expr 'f(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''f(0,`bar`)'\'''

echo '$ test-expr '\''fl'\'''
test-expr 'fl' 2>&1 ||
echo 'command failed: test-expr '\''fl'\'''

echo '$ test-expr '\''fl()'\'''
test-expr 'fl()' 2>&1 ||
echo 'command failed: test-expr '\''fl()'\'''

echo '$ test-expr '\''fl(0)'\'''
test-expr 'fl(0)' 2>&1 ||
echo 'command failed: test-expr '\''fl(0)'\'''

echo '$ test-expr '\''fl(`foo`)'\'''
test-expr 'fl(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''fl(`foo`)'\'''

echo '$ test-expr '\''fl(0,1)'\'''
test-expr 'fl(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''fl(0,1)'\'''

echo '$ test-expr '\''fl(`foo`,1)'\'''
test-expr 'fl(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''fl(`foo`,1)'\'''

echo '$ test-expr '\''fl(`foo`,`bar`)'\'''
test-expr 'fl(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''fl(`foo`,`bar`)'\'''

echo '$ test-expr '\''fl(0,`bar`)'\'''
test-expr 'fl(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''fl(0,`bar`)'\'''

echo '$ test-expr '\''flo'\'''
test-expr 'flo' 2>&1 ||
echo 'command failed: test-expr '\''flo'\'''

echo '$ test-expr '\''flo()'\'''
test-expr 'flo()' 2>&1 ||
echo 'command failed: test-expr '\''flo()'\'''

echo '$ test-expr '\''flo(0)'\'''
test-expr 'flo(0)' 2>&1 ||
echo 'command failed: test-expr '\''flo(0)'\'''

echo '$ test-expr '\''flo(`foo`)'\'''
test-expr 'flo(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''flo(`foo`)'\'''

echo '$ test-expr '\''flo(0,1)'\'''
test-expr 'flo(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''flo(0,1)'\'''

echo '$ test-expr '\''flo(`foo`,1)'\'''
test-expr 'flo(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''flo(`foo`,1)'\'''

echo '$ test-expr '\''flo(`foo`,`bar`)'\'''
test-expr 'flo(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''flo(`foo`,`bar`)'\'''

echo '$ test-expr '\''flo(0,`bar`)'\'''
test-expr 'flo(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''flo(0,`bar`)'\'''

echo '$ test-expr '\''floa'\'''
test-expr 'floa' 2>&1 ||
echo 'command failed: test-expr '\''floa'\'''

echo '$ test-expr '\''floa()'\'''
test-expr 'floa()' 2>&1 ||
echo 'command failed: test-expr '\''floa()'\'''

echo '$ test-expr '\''floa(0)'\'''
test-expr 'floa(0)' 2>&1 ||
echo 'command failed: test-expr '\''floa(0)'\'''

echo '$ test-expr '\''floa(`foo`)'\'''
test-expr 'floa(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''floa(`foo`)'\'''

echo '$ test-expr '\''floa(0,1)'\'''
test-expr 'floa(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''floa(0,1)'\'''

echo '$ test-expr '\''floa(`foo`,1)'\'''
test-expr 'floa(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''floa(`foo`,1)'\'''

echo '$ test-expr '\''floa(`foo`,`bar`)'\'''
test-expr 'floa(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''floa(`foo`,`bar`)'\'''

echo '$ test-expr '\''floa(0,`bar`)'\'''
test-expr 'floa(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''floa(0,`bar`)'\'''

echo '$ test-expr '\''float'\'''
test-expr 'float' 2>&1 ||
echo 'command failed: test-expr '\''float'\'''

echo '$ test-expr '\''float()'\'''
test-expr 'float()' 2>&1 ||
echo 'command failed: test-expr '\''float()'\'''

echo '$ test-expr '\''float(0)'\'''
test-expr 'float(0)' 2>&1 ||
echo 'command failed: test-expr '\''float(0)'\'''

echo '$ test-expr '\''float(`foo`)'\'''
test-expr 'float(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''float(`foo`)'\'''

echo '$ test-expr '\''float(0,1)'\'''
test-expr 'float(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''float(0,1)'\'''

echo '$ test-expr '\''float(`foo`,1)'\'''
test-expr 'float(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''float(`foo`,1)'\'''

echo '$ test-expr '\''float(`foo`,`bar`)'\'''
test-expr 'float(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''float(`foo`,`bar`)'\'''

echo '$ test-expr '\''float(0,`bar`)'\'''
test-expr 'float(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''float(0,`bar`)'\'''

echo '$ test-expr '\''fu'\'''
test-expr 'fu' 2>&1 ||
echo 'command failed: test-expr '\''fu'\'''

echo '$ test-expr '\''fu()'\'''
test-expr 'fu()' 2>&1 ||
echo 'command failed: test-expr '\''fu()'\'''

echo '$ test-expr '\''fu(0)'\'''
test-expr 'fu(0)' 2>&1 ||
echo 'command failed: test-expr '\''fu(0)'\'''

echo '$ test-expr '\''fu(`foo`)'\'''
test-expr 'fu(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''fu(`foo`)'\'''

echo '$ test-expr '\''fu(0,1)'\'''
test-expr 'fu(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''fu(0,1)'\'''

echo '$ test-expr '\''fu(`foo`,1)'\'''
test-expr 'fu(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''fu(`foo`,1)'\'''

echo '$ test-expr '\''fu(`foo`,`bar`)'\'''
test-expr 'fu(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''fu(`foo`,`bar`)'\'''

echo '$ test-expr '\''fu(0,`bar`)'\'''
test-expr 'fu(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''fu(0,`bar`)'\'''

echo '$ test-expr '\''ful'\'''
test-expr 'ful' 2>&1 ||
echo 'command failed: test-expr '\''ful'\'''

echo '$ test-expr '\''ful()'\'''
test-expr 'ful()' 2>&1 ||
echo 'command failed: test-expr '\''ful()'\'''

echo '$ test-expr '\''ful(0)'\'''
test-expr 'ful(0)' 2>&1 ||
echo 'command failed: test-expr '\''ful(0)'\'''

echo '$ test-expr '\''ful(`foo`)'\'''
test-expr 'ful(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ful(`foo`)'\'''

echo '$ test-expr '\''ful(0,1)'\'''
test-expr 'ful(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ful(0,1)'\'''

echo '$ test-expr '\''ful(`foo`,1)'\'''
test-expr 'ful(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ful(`foo`,1)'\'''

echo '$ test-expr '\''ful(`foo`,`bar`)'\'''
test-expr 'ful(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ful(`foo`,`bar`)'\'''

echo '$ test-expr '\''ful(0,`bar`)'\'''
test-expr 'ful(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ful(0,`bar`)'\'''

echo '$ test-expr '\''full'\'''
test-expr 'full' 2>&1 ||
echo 'command failed: test-expr '\''full'\'''

echo '$ test-expr '\''full()'\'''
test-expr 'full()' 2>&1 ||
echo 'command failed: test-expr '\''full()'\'''

echo '$ test-expr '\''full(0)'\'''
test-expr 'full(0)' 2>&1 ||
echo 'command failed: test-expr '\''full(0)'\'''

echo '$ test-expr '\''full(`foo`)'\'''
test-expr 'full(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''full(`foo`)'\'''

echo '$ test-expr '\''full(0,1)'\'''
test-expr 'full(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''full(0,1)'\'''

echo '$ test-expr '\''full(`foo`,1)'\'''
test-expr 'full(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''full(`foo`,1)'\'''

echo '$ test-expr '\''full(`foo`,`bar`)'\'''
test-expr 'full(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full(`foo`,`bar`)'\'''

echo '$ test-expr '\''full(0,`bar`)'\'''
test-expr 'full(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full(0,`bar`)'\'''

echo '$ test-expr '\''full_'\'''
test-expr 'full_' 2>&1 ||
echo 'command failed: test-expr '\''full_'\'''

echo '$ test-expr '\''full_()'\'''
test-expr 'full_()' 2>&1 ||
echo 'command failed: test-expr '\''full_()'\'''

echo '$ test-expr '\''full_(0)'\'''
test-expr 'full_(0)' 2>&1 ||
echo 'command failed: test-expr '\''full_(0)'\'''

echo '$ test-expr '\''full_(`foo`)'\'''
test-expr 'full_(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''full_(`foo`)'\'''

echo '$ test-expr '\''full_(0,1)'\'''
test-expr 'full_(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_(0,1)'\'''

echo '$ test-expr '\''full_(`foo`,1)'\'''
test-expr 'full_(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_(`foo`,1)'\'''

echo '$ test-expr '\''full_(`foo`,`bar`)'\'''
test-expr 'full_(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_(`foo`,`bar`)'\'''

echo '$ test-expr '\''full_(0,`bar`)'\'''
test-expr 'full_(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_(0,`bar`)'\'''

echo '$ test-expr '\''full_i'\'''
test-expr 'full_i' 2>&1 ||
echo 'command failed: test-expr '\''full_i'\'''

echo '$ test-expr '\''full_i()'\'''
test-expr 'full_i()' 2>&1 ||
echo 'command failed: test-expr '\''full_i()'\'''

echo '$ test-expr '\''full_i(0)'\'''
test-expr 'full_i(0)' 2>&1 ||
echo 'command failed: test-expr '\''full_i(0)'\'''

echo '$ test-expr '\''full_i(`foo`)'\'''
test-expr 'full_i(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''full_i(`foo`)'\'''

echo '$ test-expr '\''full_i(0,1)'\'''
test-expr 'full_i(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_i(0,1)'\'''

echo '$ test-expr '\''full_i(`foo`,1)'\'''
test-expr 'full_i(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_i(`foo`,1)'\'''

echo '$ test-expr '\''full_i(`foo`,`bar`)'\'''
test-expr 'full_i(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_i(`foo`,`bar`)'\'''

echo '$ test-expr '\''full_i(0,`bar`)'\'''
test-expr 'full_i(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_i(0,`bar`)'\'''

echo '$ test-expr '\''full_is'\'''
test-expr 'full_is' 2>&1 ||
echo 'command failed: test-expr '\''full_is'\'''

echo '$ test-expr '\''full_is()'\'''
test-expr 'full_is()' 2>&1 ||
echo 'command failed: test-expr '\''full_is()'\'''

echo '$ test-expr '\''full_is(0)'\'''
test-expr 'full_is(0)' 2>&1 ||
echo 'command failed: test-expr '\''full_is(0)'\'''

echo '$ test-expr '\''full_is(`foo`)'\'''
test-expr 'full_is(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''full_is(`foo`)'\'''

echo '$ test-expr '\''full_is(0,1)'\'''
test-expr 'full_is(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_is(0,1)'\'''

echo '$ test-expr '\''full_is(`foo`,1)'\'''
test-expr 'full_is(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_is(`foo`,1)'\'''

echo '$ test-expr '\''full_is(`foo`,`bar`)'\'''
test-expr 'full_is(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_is(`foo`,`bar`)'\'''

echo '$ test-expr '\''full_is(0,`bar`)'\'''
test-expr 'full_is(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_is(0,`bar`)'\'''

echo '$ test-expr '\''full_iso'\'''
test-expr 'full_iso' 2>&1 ||
echo 'command failed: test-expr '\''full_iso'\'''

echo '$ test-expr '\''full_iso()'\'''
test-expr 'full_iso()' 2>&1 ||
echo 'command failed: test-expr '\''full_iso()'\'''

echo '$ test-expr '\''full_iso(0)'\'''
test-expr 'full_iso(0)' 2>&1 ||
echo 'command failed: test-expr '\''full_iso(0)'\'''

echo '$ test-expr '\''full_iso(`foo`)'\'''
test-expr 'full_iso(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''full_iso(`foo`)'\'''

echo '$ test-expr '\''full_iso(0,1)'\'''
test-expr 'full_iso(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_iso(0,1)'\'''

echo '$ test-expr '\''full_iso(`foo`,1)'\'''
test-expr 'full_iso(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''full_iso(`foo`,1)'\'''

echo '$ test-expr '\''full_iso(`foo`,`bar`)'\'''
test-expr 'full_iso(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_iso(`foo`,`bar`)'\'''

echo '$ test-expr '\''full_iso(0,`bar`)'\'''
test-expr 'full_iso(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''full_iso(0,`bar`)'\'''

echo '$ test-expr '\''i'\'''
test-expr 'i' 2>&1 ||
echo 'command failed: test-expr '\''i'\'''

echo '$ test-expr '\''i()'\'''
test-expr 'i()' 2>&1 ||
echo 'command failed: test-expr '\''i()'\'''

echo '$ test-expr '\''i(0)'\'''
test-expr 'i(0)' 2>&1 ||
echo 'command failed: test-expr '\''i(0)'\'''

echo '$ test-expr '\''i(`foo`)'\'''
test-expr 'i(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''i(`foo`)'\'''

echo '$ test-expr '\''i(0,1)'\'''
test-expr 'i(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''i(0,1)'\'''

echo '$ test-expr '\''i(`foo`,1)'\'''
test-expr 'i(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''i(`foo`,1)'\'''

echo '$ test-expr '\''i(`foo`,`bar`)'\'''
test-expr 'i(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''i(`foo`,`bar`)'\'''

echo '$ test-expr '\''i(0,`bar`)'\'''
test-expr 'i(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''i(0,`bar`)'\'''

echo '$ test-expr '\''in'\'''
test-expr 'in' 2>&1 ||
echo 'command failed: test-expr '\''in'\'''

echo '$ test-expr '\''in()'\'''
test-expr 'in()' 2>&1 ||
echo 'command failed: test-expr '\''in()'\'''

echo '$ test-expr '\''in(0)'\'''
test-expr 'in(0)' 2>&1 ||
echo 'command failed: test-expr '\''in(0)'\'''

echo '$ test-expr '\''in(`foo`)'\'''
test-expr 'in(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''in(`foo`)'\'''

echo '$ test-expr '\''in(0,1)'\'''
test-expr 'in(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''in(0,1)'\'''

echo '$ test-expr '\''in(`foo`,1)'\'''
test-expr 'in(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''in(`foo`,1)'\'''

echo '$ test-expr '\''in(`foo`,`bar`)'\'''
test-expr 'in(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''in(`foo`,`bar`)'\'''

echo '$ test-expr '\''in(0,`bar`)'\'''
test-expr 'in(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''in(0,`bar`)'\'''

echo '$ test-expr '\''int'\'''
test-expr 'int' 2>&1 ||
echo 'command failed: test-expr '\''int'\'''

echo '$ test-expr '\''int()'\'''
test-expr 'int()' 2>&1 ||
echo 'command failed: test-expr '\''int()'\'''

echo '$ test-expr '\''int(0)'\'''
test-expr 'int(0)' 2>&1 ||
echo 'command failed: test-expr '\''int(0)'\'''

echo '$ test-expr '\''int(`foo`)'\'''
test-expr 'int(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''int(`foo`)'\'''

echo '$ test-expr '\''int(0,1)'\'''
test-expr 'int(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''int(0,1)'\'''

echo '$ test-expr '\''int(`foo`,1)'\'''
test-expr 'int(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''int(`foo`,1)'\'''

echo '$ test-expr '\''int(`foo`,`bar`)'\'''
test-expr 'int(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''int(`foo`,`bar`)'\'''

echo '$ test-expr '\''int(0,`bar`)'\'''
test-expr 'int(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''int(0,`bar`)'\'''

echo '$ test-expr '\''is'\'''
test-expr 'is' 2>&1 ||
echo 'command failed: test-expr '\''is'\'''

echo '$ test-expr '\''is()'\'''
test-expr 'is()' 2>&1 ||
echo 'command failed: test-expr '\''is()'\'''

echo '$ test-expr '\''is(0)'\'''
test-expr 'is(0)' 2>&1 ||
echo 'command failed: test-expr '\''is(0)'\'''

echo '$ test-expr '\''is(`foo`)'\'''
test-expr 'is(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''is(`foo`)'\'''

echo '$ test-expr '\''is(0,1)'\'''
test-expr 'is(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''is(0,1)'\'''

echo '$ test-expr '\''is(`foo`,1)'\'''
test-expr 'is(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''is(`foo`,1)'\'''

echo '$ test-expr '\''is(`foo`,`bar`)'\'''
test-expr 'is(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''is(`foo`,`bar`)'\'''

echo '$ test-expr '\''is(0,`bar`)'\'''
test-expr 'is(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''is(0,`bar`)'\'''

echo '$ test-expr '\''iso'\'''
test-expr 'iso' 2>&1 ||
echo 'command failed: test-expr '\''iso'\'''

echo '$ test-expr '\''iso()'\'''
test-expr 'iso()' 2>&1 ||
echo 'command failed: test-expr '\''iso()'\'''

echo '$ test-expr '\''iso(0)'\'''
test-expr 'iso(0)' 2>&1 ||
echo 'command failed: test-expr '\''iso(0)'\'''

echo '$ test-expr '\''iso(`foo`)'\'''
test-expr 'iso(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''iso(`foo`)'\'''

echo '$ test-expr '\''iso(0,1)'\'''
test-expr 'iso(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso(0,1)'\'''

echo '$ test-expr '\''iso(`foo`,1)'\'''
test-expr 'iso(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso(`foo`,1)'\'''

echo '$ test-expr '\''iso(`foo`,`bar`)'\'''
test-expr 'iso(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso(`foo`,`bar`)'\'''

echo '$ test-expr '\''iso(0,`bar`)'\'''
test-expr 'iso(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso(0,`bar`)'\'''

echo '$ test-expr '\''iso_'\'''
test-expr 'iso_' 2>&1 ||
echo 'command failed: test-expr '\''iso_'\'''

echo '$ test-expr '\''iso_()'\'''
test-expr 'iso_()' 2>&1 ||
echo 'command failed: test-expr '\''iso_()'\'''

echo '$ test-expr '\''iso_(0)'\'''
test-expr 'iso_(0)' 2>&1 ||
echo 'command failed: test-expr '\''iso_(0)'\'''

echo '$ test-expr '\''iso_(`foo`)'\'''
test-expr 'iso_(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_(`foo`)'\'''

echo '$ test-expr '\''iso_(0,1)'\'''
test-expr 'iso_(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_(0,1)'\'''

echo '$ test-expr '\''iso_(`foo`,1)'\'''
test-expr 'iso_(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_(`foo`,1)'\'''

echo '$ test-expr '\''iso_(`foo`,`bar`)'\'''
test-expr 'iso_(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_(`foo`,`bar`)'\'''

echo '$ test-expr '\''iso_(0,`bar`)'\'''
test-expr 'iso_(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_(0,`bar`)'\'''

echo '$ test-expr '\''iso_8'\'''
test-expr 'iso_8' 2>&1 ||
echo 'command failed: test-expr '\''iso_8'\'''

echo '$ test-expr '\''iso_8()'\'''
test-expr 'iso_8()' 2>&1 ||
echo 'command failed: test-expr '\''iso_8()'\'''

echo '$ test-expr '\''iso_8(0)'\'''
test-expr 'iso_8(0)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8(0)'\'''

echo '$ test-expr '\''iso_8(`foo`)'\'''
test-expr 'iso_8(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8(`foo`)'\'''

echo '$ test-expr '\''iso_8(0,1)'\'''
test-expr 'iso_8(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8(0,1)'\'''

echo '$ test-expr '\''iso_8(`foo`,1)'\'''
test-expr 'iso_8(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8(`foo`,1)'\'''

echo '$ test-expr '\''iso_8(`foo`,`bar`)'\'''
test-expr 'iso_8(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8(`foo`,`bar`)'\'''

echo '$ test-expr '\''iso_8(0,`bar`)'\'''
test-expr 'iso_8(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8(0,`bar`)'\'''

echo '$ test-expr '\''iso_86'\'''
test-expr 'iso_86' 2>&1 ||
echo 'command failed: test-expr '\''iso_86'\'''

echo '$ test-expr '\''iso_86()'\'''
test-expr 'iso_86()' 2>&1 ||
echo 'command failed: test-expr '\''iso_86()'\'''

echo '$ test-expr '\''iso_86(0)'\'''
test-expr 'iso_86(0)' 2>&1 ||
echo 'command failed: test-expr '\''iso_86(0)'\'''

echo '$ test-expr '\''iso_86(`foo`)'\'''
test-expr 'iso_86(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_86(`foo`)'\'''

echo '$ test-expr '\''iso_86(0,1)'\'''
test-expr 'iso_86(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_86(0,1)'\'''

echo '$ test-expr '\''iso_86(`foo`,1)'\'''
test-expr 'iso_86(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_86(`foo`,1)'\'''

echo '$ test-expr '\''iso_86(`foo`,`bar`)'\'''
test-expr 'iso_86(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_86(`foo`,`bar`)'\'''

echo '$ test-expr '\''iso_86(0,`bar`)'\'''
test-expr 'iso_86(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_86(0,`bar`)'\'''

echo '$ test-expr '\''iso_860'\'''
test-expr 'iso_860' 2>&1 ||
echo 'command failed: test-expr '\''iso_860'\'''

echo '$ test-expr '\''iso_860()'\'''
test-expr 'iso_860()' 2>&1 ||
echo 'command failed: test-expr '\''iso_860()'\'''

echo '$ test-expr '\''iso_860(0)'\'''
test-expr 'iso_860(0)' 2>&1 ||
echo 'command failed: test-expr '\''iso_860(0)'\'''

echo '$ test-expr '\''iso_860(`foo`)'\'''
test-expr 'iso_860(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_860(`foo`)'\'''

echo '$ test-expr '\''iso_860(0,1)'\'''
test-expr 'iso_860(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_860(0,1)'\'''

echo '$ test-expr '\''iso_860(`foo`,1)'\'''
test-expr 'iso_860(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_860(`foo`,1)'\'''

echo '$ test-expr '\''iso_860(`foo`,`bar`)'\'''
test-expr 'iso_860(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_860(`foo`,`bar`)'\'''

echo '$ test-expr '\''iso_860(0,`bar`)'\'''
test-expr 'iso_860(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_860(0,`bar`)'\'''

echo '$ test-expr '\''iso_8601'\'''
test-expr 'iso_8601' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601'\'''

echo '$ test-expr '\''iso_8601()'\'''
test-expr 'iso_8601()' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601()'\'''

echo '$ test-expr '\''iso_8601(0)'\'''
test-expr 'iso_8601(0)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601(0)'\'''

echo '$ test-expr '\''iso_8601(`foo`)'\'''
test-expr 'iso_8601(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601(`foo`)'\'''

echo '$ test-expr '\''iso_8601(0,1)'\'''
test-expr 'iso_8601(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601(0,1)'\'''

echo '$ test-expr '\''iso_8601(`foo`,1)'\'''
test-expr 'iso_8601(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601(`foo`,1)'\'''

echo '$ test-expr '\''iso_8601(`foo`,`bar`)'\'''
test-expr 'iso_8601(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601(`foo`,`bar`)'\'''

echo '$ test-expr '\''iso_8601(0,`bar`)'\'''
test-expr 'iso_8601(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''iso_8601(0,`bar`)'\'''

echo '$ test-expr '\''l'\'''
test-expr 'l' 2>&1 ||
echo 'command failed: test-expr '\''l'\'''

echo '$ test-expr '\''l()'\'''
test-expr 'l()' 2>&1 ||
echo 'command failed: test-expr '\''l()'\'''

echo '$ test-expr '\''l(0)'\'''
test-expr 'l(0)' 2>&1 ||
echo 'command failed: test-expr '\''l(0)'\'''

echo '$ test-expr '\''l(`foo`)'\'''
test-expr 'l(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''l(`foo`)'\'''

echo '$ test-expr '\''l(0,1)'\'''
test-expr 'l(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''l(0,1)'\'''

echo '$ test-expr '\''l(`foo`,1)'\'''
test-expr 'l(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''l(`foo`,1)'\'''

echo '$ test-expr '\''l(`foo`,`bar`)'\'''
test-expr 'l(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''l(`foo`,`bar`)'\'''

echo '$ test-expr '\''l(0,`bar`)'\'''
test-expr 'l(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''l(0,`bar`)'\'''

echo '$ test-expr '\''ld'\'''
test-expr 'ld' 2>&1 ||
echo 'command failed: test-expr '\''ld'\'''

echo '$ test-expr '\''ld()'\'''
test-expr 'ld()' 2>&1 ||
echo 'command failed: test-expr '\''ld()'\'''

echo '$ test-expr '\''ld(0)'\'''
test-expr 'ld(0)' 2>&1 ||
echo 'command failed: test-expr '\''ld(0)'\'''

echo '$ test-expr '\''ld(`foo`)'\'''
test-expr 'ld(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ld(`foo`)'\'''

echo '$ test-expr '\''ld(0,1)'\'''
test-expr 'ld(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ld(0,1)'\'''

echo '$ test-expr '\''ld(`foo`,1)'\'''
test-expr 'ld(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ld(`foo`,1)'\'''

echo '$ test-expr '\''ld(`foo`,`bar`)'\'''
test-expr 'ld(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ld(`foo`,`bar`)'\'''

echo '$ test-expr '\''ld(0,`bar`)'\'''
test-expr 'ld(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ld(0,`bar`)'\'''

echo '$ test-expr '\''ldo'\'''
test-expr 'ldo' 2>&1 ||
echo 'command failed: test-expr '\''ldo'\'''

echo '$ test-expr '\''ldo()'\'''
test-expr 'ldo()' 2>&1 ||
echo 'command failed: test-expr '\''ldo()'\'''

echo '$ test-expr '\''ldo(0)'\'''
test-expr 'ldo(0)' 2>&1 ||
echo 'command failed: test-expr '\''ldo(0)'\'''

echo '$ test-expr '\''ldo(`foo`)'\'''
test-expr 'ldo(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ldo(`foo`)'\'''

echo '$ test-expr '\''ldo(0,1)'\'''
test-expr 'ldo(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldo(0,1)'\'''

echo '$ test-expr '\''ldo(`foo`,1)'\'''
test-expr 'ldo(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldo(`foo`,1)'\'''

echo '$ test-expr '\''ldo(`foo`,`bar`)'\'''
test-expr 'ldo(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldo(`foo`,`bar`)'\'''

echo '$ test-expr '\''ldo(0,`bar`)'\'''
test-expr 'ldo(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldo(0,`bar`)'\'''

echo '$ test-expr '\''ldou'\'''
test-expr 'ldou' 2>&1 ||
echo 'command failed: test-expr '\''ldou'\'''

echo '$ test-expr '\''ldou()'\'''
test-expr 'ldou()' 2>&1 ||
echo 'command failed: test-expr '\''ldou()'\'''

echo '$ test-expr '\''ldou(0)'\'''
test-expr 'ldou(0)' 2>&1 ||
echo 'command failed: test-expr '\''ldou(0)'\'''

echo '$ test-expr '\''ldou(`foo`)'\'''
test-expr 'ldou(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ldou(`foo`)'\'''

echo '$ test-expr '\''ldou(0,1)'\'''
test-expr 'ldou(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldou(0,1)'\'''

echo '$ test-expr '\''ldou(`foo`,1)'\'''
test-expr 'ldou(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldou(`foo`,1)'\'''

echo '$ test-expr '\''ldou(`foo`,`bar`)'\'''
test-expr 'ldou(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldou(`foo`,`bar`)'\'''

echo '$ test-expr '\''ldou(0,`bar`)'\'''
test-expr 'ldou(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldou(0,`bar`)'\'''

echo '$ test-expr '\''ldoub'\'''
test-expr 'ldoub' 2>&1 ||
echo 'command failed: test-expr '\''ldoub'\'''

echo '$ test-expr '\''ldoub()'\'''
test-expr 'ldoub()' 2>&1 ||
echo 'command failed: test-expr '\''ldoub()'\'''

echo '$ test-expr '\''ldoub(0)'\'''
test-expr 'ldoub(0)' 2>&1 ||
echo 'command failed: test-expr '\''ldoub(0)'\'''

echo '$ test-expr '\''ldoub(`foo`)'\'''
test-expr 'ldoub(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ldoub(`foo`)'\'''

echo '$ test-expr '\''ldoub(0,1)'\'''
test-expr 'ldoub(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldoub(0,1)'\'''

echo '$ test-expr '\''ldoub(`foo`,1)'\'''
test-expr 'ldoub(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldoub(`foo`,1)'\'''

echo '$ test-expr '\''ldoub(`foo`,`bar`)'\'''
test-expr 'ldoub(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldoub(`foo`,`bar`)'\'''

echo '$ test-expr '\''ldoub(0,`bar`)'\'''
test-expr 'ldoub(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldoub(0,`bar`)'\'''

echo '$ test-expr '\''ldoubl'\'''
test-expr 'ldoubl' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl'\'''

echo '$ test-expr '\''ldoubl()'\'''
test-expr 'ldoubl()' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl()'\'''

echo '$ test-expr '\''ldoubl(0)'\'''
test-expr 'ldoubl(0)' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl(0)'\'''

echo '$ test-expr '\''ldoubl(`foo`)'\'''
test-expr 'ldoubl(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl(`foo`)'\'''

echo '$ test-expr '\''ldoubl(0,1)'\'''
test-expr 'ldoubl(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl(0,1)'\'''

echo '$ test-expr '\''ldoubl(`foo`,1)'\'''
test-expr 'ldoubl(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl(`foo`,1)'\'''

echo '$ test-expr '\''ldoubl(`foo`,`bar`)'\'''
test-expr 'ldoubl(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl(`foo`,`bar`)'\'''

echo '$ test-expr '\''ldoubl(0,`bar`)'\'''
test-expr 'ldoubl(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldoubl(0,`bar`)'\'''

echo '$ test-expr '\''ldouble'\'''
test-expr 'ldouble' 2>&1 ||
echo 'command failed: test-expr '\''ldouble'\'''

echo '$ test-expr '\''ldouble()'\'''
test-expr 'ldouble()' 2>&1 ||
echo 'command failed: test-expr '\''ldouble()'\'''

echo '$ test-expr '\''ldouble(0)'\'''
test-expr 'ldouble(0)' 2>&1 ||
echo 'command failed: test-expr '\''ldouble(0)'\'''

echo '$ test-expr '\''ldouble(`foo`)'\'''
test-expr 'ldouble(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ldouble(`foo`)'\'''

echo '$ test-expr '\''ldouble(0,1)'\'''
test-expr 'ldouble(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldouble(0,1)'\'''

echo '$ test-expr '\''ldouble(`foo`,1)'\'''
test-expr 'ldouble(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ldouble(`foo`,1)'\'''

echo '$ test-expr '\''ldouble(`foo`,`bar`)'\'''
test-expr 'ldouble(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldouble(`foo`,`bar`)'\'''

echo '$ test-expr '\''ldouble(0,`bar`)'\'''
test-expr 'ldouble(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ldouble(0,`bar`)'\'''

echo '$ test-expr '\''le'\'''
test-expr 'le' 2>&1 ||
echo 'command failed: test-expr '\''le'\'''

echo '$ test-expr '\''le()'\'''
test-expr 'le()' 2>&1 ||
echo 'command failed: test-expr '\''le()'\'''

echo '$ test-expr '\''le(0)'\'''
test-expr 'le(0)' 2>&1 ||
echo 'command failed: test-expr '\''le(0)'\'''

echo '$ test-expr '\''le(`foo`)'\'''
test-expr 'le(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''le(`foo`)'\'''

echo '$ test-expr '\''le(0,1)'\'''
test-expr 'le(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''le(0,1)'\'''

echo '$ test-expr '\''le(`foo`,1)'\'''
test-expr 'le(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''le(`foo`,1)'\'''

echo '$ test-expr '\''le(`foo`,`bar`)'\'''
test-expr 'le(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''le(`foo`,`bar`)'\'''

echo '$ test-expr '\''le(0,`bar`)'\'''
test-expr 'le(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''le(0,`bar`)'\'''

echo '$ test-expr '\''len'\'''
test-expr 'len' 2>&1 ||
echo 'command failed: test-expr '\''len'\'''

echo '$ test-expr '\''len()'\'''
test-expr 'len()' 2>&1 ||
echo 'command failed: test-expr '\''len()'\'''

echo '$ test-expr '\''len(0)'\'''
test-expr 'len(0)' 2>&1 ||
echo 'command failed: test-expr '\''len(0)'\'''

echo '$ test-expr '\''len(`foo`)'\'''
test-expr 'len(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''len(`foo`)'\'''

echo '$ test-expr '\''len(0,1)'\'''
test-expr 'len(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''len(0,1)'\'''

echo '$ test-expr '\''len(`foo`,1)'\'''
test-expr 'len(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''len(`foo`,1)'\'''

echo '$ test-expr '\''len(`foo`,`bar`)'\'''
test-expr 'len(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''len(`foo`,`bar`)'\'''

echo '$ test-expr '\''len(0,`bar`)'\'''
test-expr 'len(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''len(0,`bar`)'\'''

echo '$ test-expr '\''lo'\'''
test-expr 'lo' 2>&1 ||
echo 'command failed: test-expr '\''lo'\'''

echo '$ test-expr '\''lo()'\'''
test-expr 'lo()' 2>&1 ||
echo 'command failed: test-expr '\''lo()'\'''

echo '$ test-expr '\''lo(0)'\'''
test-expr 'lo(0)' 2>&1 ||
echo 'command failed: test-expr '\''lo(0)'\'''

echo '$ test-expr '\''lo(`foo`)'\'''
test-expr 'lo(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''lo(`foo`)'\'''

echo '$ test-expr '\''lo(0,1)'\'''
test-expr 'lo(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''lo(0,1)'\'''

echo '$ test-expr '\''lo(`foo`,1)'\'''
test-expr 'lo(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''lo(`foo`,1)'\'''

echo '$ test-expr '\''lo(`foo`,`bar`)'\'''
test-expr 'lo(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''lo(`foo`,`bar`)'\'''

echo '$ test-expr '\''lo(0,`bar`)'\'''
test-expr 'lo(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''lo(0,`bar`)'\'''

echo '$ test-expr '\''lon'\'''
test-expr 'lon' 2>&1 ||
echo 'command failed: test-expr '\''lon'\'''

echo '$ test-expr '\''lon()'\'''
test-expr 'lon()' 2>&1 ||
echo 'command failed: test-expr '\''lon()'\'''

echo '$ test-expr '\''lon(0)'\'''
test-expr 'lon(0)' 2>&1 ||
echo 'command failed: test-expr '\''lon(0)'\'''

echo '$ test-expr '\''lon(`foo`)'\'''
test-expr 'lon(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''lon(`foo`)'\'''

echo '$ test-expr '\''lon(0,1)'\'''
test-expr 'lon(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''lon(0,1)'\'''

echo '$ test-expr '\''lon(`foo`,1)'\'''
test-expr 'lon(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''lon(`foo`,1)'\'''

echo '$ test-expr '\''lon(`foo`,`bar`)'\'''
test-expr 'lon(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''lon(`foo`,`bar`)'\'''

echo '$ test-expr '\''lon(0,`bar`)'\'''
test-expr 'lon(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''lon(0,`bar`)'\'''

echo '$ test-expr '\''long'\'''
test-expr 'long' 2>&1 ||
echo 'command failed: test-expr '\''long'\'''

echo '$ test-expr '\''long()'\'''
test-expr 'long()' 2>&1 ||
echo 'command failed: test-expr '\''long()'\'''

echo '$ test-expr '\''long(0)'\'''
test-expr 'long(0)' 2>&1 ||
echo 'command failed: test-expr '\''long(0)'\'''

echo '$ test-expr '\''long(`foo`)'\'''
test-expr 'long(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''long(`foo`)'\'''

echo '$ test-expr '\''long(0,1)'\'''
test-expr 'long(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''long(0,1)'\'''

echo '$ test-expr '\''long(`foo`,1)'\'''
test-expr 'long(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''long(`foo`,1)'\'''

echo '$ test-expr '\''long(`foo`,`bar`)'\'''
test-expr 'long(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long(`foo`,`bar`)'\'''

echo '$ test-expr '\''long(0,`bar`)'\'''
test-expr 'long(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long(0,`bar`)'\'''

echo '$ test-expr '\''long_'\'''
test-expr 'long_' 2>&1 ||
echo 'command failed: test-expr '\''long_'\'''

echo '$ test-expr '\''long_()'\'''
test-expr 'long_()' 2>&1 ||
echo 'command failed: test-expr '\''long_()'\'''

echo '$ test-expr '\''long_(0)'\'''
test-expr 'long_(0)' 2>&1 ||
echo 'command failed: test-expr '\''long_(0)'\'''

echo '$ test-expr '\''long_(`foo`)'\'''
test-expr 'long_(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''long_(`foo`)'\'''

echo '$ test-expr '\''long_(0,1)'\'''
test-expr 'long_(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_(0,1)'\'''

echo '$ test-expr '\''long_(`foo`,1)'\'''
test-expr 'long_(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_(`foo`,1)'\'''

echo '$ test-expr '\''long_(`foo`,`bar`)'\'''
test-expr 'long_(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_(`foo`,`bar`)'\'''

echo '$ test-expr '\''long_(0,`bar`)'\'''
test-expr 'long_(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_(0,`bar`)'\'''

echo '$ test-expr '\''long_i'\'''
test-expr 'long_i' 2>&1 ||
echo 'command failed: test-expr '\''long_i'\'''

echo '$ test-expr '\''long_i()'\'''
test-expr 'long_i()' 2>&1 ||
echo 'command failed: test-expr '\''long_i()'\'''

echo '$ test-expr '\''long_i(0)'\'''
test-expr 'long_i(0)' 2>&1 ||
echo 'command failed: test-expr '\''long_i(0)'\'''

echo '$ test-expr '\''long_i(`foo`)'\'''
test-expr 'long_i(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''long_i(`foo`)'\'''

echo '$ test-expr '\''long_i(0,1)'\'''
test-expr 'long_i(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_i(0,1)'\'''

echo '$ test-expr '\''long_i(`foo`,1)'\'''
test-expr 'long_i(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_i(`foo`,1)'\'''

echo '$ test-expr '\''long_i(`foo`,`bar`)'\'''
test-expr 'long_i(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_i(`foo`,`bar`)'\'''

echo '$ test-expr '\''long_i(0,`bar`)'\'''
test-expr 'long_i(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_i(0,`bar`)'\'''

echo '$ test-expr '\''long_is'\'''
test-expr 'long_is' 2>&1 ||
echo 'command failed: test-expr '\''long_is'\'''

echo '$ test-expr '\''long_is()'\'''
test-expr 'long_is()' 2>&1 ||
echo 'command failed: test-expr '\''long_is()'\'''

echo '$ test-expr '\''long_is(0)'\'''
test-expr 'long_is(0)' 2>&1 ||
echo 'command failed: test-expr '\''long_is(0)'\'''

echo '$ test-expr '\''long_is(`foo`)'\'''
test-expr 'long_is(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''long_is(`foo`)'\'''

echo '$ test-expr '\''long_is(0,1)'\'''
test-expr 'long_is(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_is(0,1)'\'''

echo '$ test-expr '\''long_is(`foo`,1)'\'''
test-expr 'long_is(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_is(`foo`,1)'\'''

echo '$ test-expr '\''long_is(`foo`,`bar`)'\'''
test-expr 'long_is(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_is(`foo`,`bar`)'\'''

echo '$ test-expr '\''long_is(0,`bar`)'\'''
test-expr 'long_is(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_is(0,`bar`)'\'''

echo '$ test-expr '\''long_iso'\'''
test-expr 'long_iso' 2>&1 ||
echo 'command failed: test-expr '\''long_iso'\'''

echo '$ test-expr '\''long_iso()'\'''
test-expr 'long_iso()' 2>&1 ||
echo 'command failed: test-expr '\''long_iso()'\'''

echo '$ test-expr '\''long_iso(0)'\'''
test-expr 'long_iso(0)' 2>&1 ||
echo 'command failed: test-expr '\''long_iso(0)'\'''

echo '$ test-expr '\''long_iso(`foo`)'\'''
test-expr 'long_iso(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''long_iso(`foo`)'\'''

echo '$ test-expr '\''long_iso(0,1)'\'''
test-expr 'long_iso(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_iso(0,1)'\'''

echo '$ test-expr '\''long_iso(`foo`,1)'\'''
test-expr 'long_iso(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''long_iso(`foo`,1)'\'''

echo '$ test-expr '\''long_iso(`foo`,`bar`)'\'''
test-expr 'long_iso(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_iso(`foo`,`bar`)'\'''

echo '$ test-expr '\''long_iso(0,`bar`)'\'''
test-expr 'long_iso(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''long_iso(0,`bar`)'\'''

echo '$ test-expr '\''n'\'''
test-expr 'n' 2>&1 ||
echo 'command failed: test-expr '\''n'\'''

echo '$ test-expr '\''n()'\'''
test-expr 'n()' 2>&1 ||
echo 'command failed: test-expr '\''n()'\'''

echo '$ test-expr '\''n(0)'\'''
test-expr 'n(0)' 2>&1 ||
echo 'command failed: test-expr '\''n(0)'\'''

echo '$ test-expr '\''n(`foo`)'\'''
test-expr 'n(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''n(`foo`)'\'''

echo '$ test-expr '\''n(0,1)'\'''
test-expr 'n(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''n(0,1)'\'''

echo '$ test-expr '\''n(`foo`,1)'\'''
test-expr 'n(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''n(`foo`,1)'\'''

echo '$ test-expr '\''n(`foo`,`bar`)'\'''
test-expr 'n(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''n(`foo`,`bar`)'\'''

echo '$ test-expr '\''n(0,`bar`)'\'''
test-expr 'n(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''n(0,`bar`)'\'''

echo '$ test-expr '\''nu'\'''
test-expr 'nu' 2>&1 ||
echo 'command failed: test-expr '\''nu'\'''

echo '$ test-expr '\''nu()'\'''
test-expr 'nu()' 2>&1 ||
echo 'command failed: test-expr '\''nu()'\'''

echo '$ test-expr '\''nu(0)'\'''
test-expr 'nu(0)' 2>&1 ||
echo 'command failed: test-expr '\''nu(0)'\'''

echo '$ test-expr '\''nu(`foo`)'\'''
test-expr 'nu(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''nu(`foo`)'\'''

echo '$ test-expr '\''nu(0,1)'\'''
test-expr 'nu(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''nu(0,1)'\'''

echo '$ test-expr '\''nu(`foo`,1)'\'''
test-expr 'nu(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''nu(`foo`,1)'\'''

echo '$ test-expr '\''nu(`foo`,`bar`)'\'''
test-expr 'nu(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''nu(`foo`,`bar`)'\'''

echo '$ test-expr '\''nu(0,`bar`)'\'''
test-expr 'nu(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''nu(0,`bar`)'\'''

echo '$ test-expr '\''nul'\'''
test-expr 'nul' 2>&1 ||
echo 'command failed: test-expr '\''nul'\'''

echo '$ test-expr '\''nul()'\'''
test-expr 'nul()' 2>&1 ||
echo 'command failed: test-expr '\''nul()'\'''

echo '$ test-expr '\''nul(0)'\'''
test-expr 'nul(0)' 2>&1 ||
echo 'command failed: test-expr '\''nul(0)'\'''

echo '$ test-expr '\''nul(`foo`)'\'''
test-expr 'nul(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''nul(`foo`)'\'''

echo '$ test-expr '\''nul(0,1)'\'''
test-expr 'nul(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''nul(0,1)'\'''

echo '$ test-expr '\''nul(`foo`,1)'\'''
test-expr 'nul(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''nul(`foo`,1)'\'''

echo '$ test-expr '\''nul(`foo`,`bar`)'\'''
test-expr 'nul(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''nul(`foo`,`bar`)'\'''

echo '$ test-expr '\''nul(0,`bar`)'\'''
test-expr 'nul(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''nul(0,`bar`)'\'''

echo '$ test-expr '\''null'\'''
test-expr 'null' 2>&1 ||
echo 'command failed: test-expr '\''null'\'''

echo '$ test-expr '\''null()'\'''
test-expr 'null()' 2>&1 ||
echo 'command failed: test-expr '\''null()'\'''

echo '$ test-expr '\''null(0)'\'''
test-expr 'null(0)' 2>&1 ||
echo 'command failed: test-expr '\''null(0)'\'''

echo '$ test-expr '\''null(`foo`)'\'''
test-expr 'null(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''null(`foo`)'\'''

echo '$ test-expr '\''null(0,1)'\'''
test-expr 'null(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''null(0,1)'\'''

echo '$ test-expr '\''null(`foo`,1)'\'''
test-expr 'null(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''null(`foo`,1)'\'''

echo '$ test-expr '\''null(`foo`,`bar`)'\'''
test-expr 'null(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''null(`foo`,`bar`)'\'''

echo '$ test-expr '\''null(0,`bar`)'\'''
test-expr 'null(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''null(0,`bar`)'\'''

echo '$ test-expr '\''num'\'''
test-expr 'num' 2>&1 ||
echo 'command failed: test-expr '\''num'\'''

echo '$ test-expr '\''num()'\'''
test-expr 'num()' 2>&1 ||
echo 'command failed: test-expr '\''num()'\'''

echo '$ test-expr '\''num(0)'\'''
test-expr 'num(0)' 2>&1 ||
echo 'command failed: test-expr '\''num(0)'\'''

echo '$ test-expr '\''num(`foo`)'\'''
test-expr 'num(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''num(`foo`)'\'''

echo '$ test-expr '\''num(0,1)'\'''
test-expr 'num(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''num(0,1)'\'''

echo '$ test-expr '\''num(`foo`,1)'\'''
test-expr 'num(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''num(`foo`,1)'\'''

echo '$ test-expr '\''num(`foo`,`bar`)'\'''
test-expr 'num(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''num(`foo`,`bar`)'\'''

echo '$ test-expr '\''num(0,`bar`)'\'''
test-expr 'num(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''num(0,`bar`)'\'''

echo '$ test-expr '\''numb'\'''
test-expr 'numb' 2>&1 ||
echo 'command failed: test-expr '\''numb'\'''

echo '$ test-expr '\''numb()'\'''
test-expr 'numb()' 2>&1 ||
echo 'command failed: test-expr '\''numb()'\'''

echo '$ test-expr '\''numb(0)'\'''
test-expr 'numb(0)' 2>&1 ||
echo 'command failed: test-expr '\''numb(0)'\'''

echo '$ test-expr '\''numb(`foo`)'\'''
test-expr 'numb(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''numb(`foo`)'\'''

echo '$ test-expr '\''numb(0,1)'\'''
test-expr 'numb(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''numb(0,1)'\'''

echo '$ test-expr '\''numb(`foo`,1)'\'''
test-expr 'numb(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''numb(`foo`,1)'\'''

echo '$ test-expr '\''numb(`foo`,`bar`)'\'''
test-expr 'numb(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''numb(`foo`,`bar`)'\'''

echo '$ test-expr '\''numb(0,`bar`)'\'''
test-expr 'numb(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''numb(0,`bar`)'\'''

echo '$ test-expr '\''numbe'\'''
test-expr 'numbe' 2>&1 ||
echo 'command failed: test-expr '\''numbe'\'''

echo '$ test-expr '\''numbe()'\'''
test-expr 'numbe()' 2>&1 ||
echo 'command failed: test-expr '\''numbe()'\'''

echo '$ test-expr '\''numbe(0)'\'''
test-expr 'numbe(0)' 2>&1 ||
echo 'command failed: test-expr '\''numbe(0)'\'''

echo '$ test-expr '\''numbe(`foo`)'\'''
test-expr 'numbe(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''numbe(`foo`)'\'''

echo '$ test-expr '\''numbe(0,1)'\'''
test-expr 'numbe(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''numbe(0,1)'\'''

echo '$ test-expr '\''numbe(`foo`,1)'\'''
test-expr 'numbe(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''numbe(`foo`,1)'\'''

echo '$ test-expr '\''numbe(`foo`,`bar`)'\'''
test-expr 'numbe(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''numbe(`foo`,`bar`)'\'''

echo '$ test-expr '\''numbe(0,`bar`)'\'''
test-expr 'numbe(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''numbe(0,`bar`)'\'''

echo '$ test-expr '\''number'\'''
test-expr 'number' 2>&1 ||
echo 'command failed: test-expr '\''number'\'''

echo '$ test-expr '\''number()'\'''
test-expr 'number()' 2>&1 ||
echo 'command failed: test-expr '\''number()'\'''

echo '$ test-expr '\''number(0)'\'''
test-expr 'number(0)' 2>&1 ||
echo 'command failed: test-expr '\''number(0)'\'''

echo '$ test-expr '\''number(`foo`)'\'''
test-expr 'number(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''number(`foo`)'\'''

echo '$ test-expr '\''number(0,1)'\'''
test-expr 'number(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''number(0,1)'\'''

echo '$ test-expr '\''number(`foo`,1)'\'''
test-expr 'number(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''number(`foo`,1)'\'''

echo '$ test-expr '\''number(`foo`,`bar`)'\'''
test-expr 'number(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''number(`foo`,`bar`)'\'''

echo '$ test-expr '\''number(0,`bar`)'\'''
test-expr 'number(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''number(0,`bar`)'\'''

echo '$ test-expr '\''s'\'''
test-expr 's' 2>&1 ||
echo 'command failed: test-expr '\''s'\'''

echo '$ test-expr '\''s()'\'''
test-expr 's()' 2>&1 ||
echo 'command failed: test-expr '\''s()'\'''

echo '$ test-expr '\''s(0)'\'''
test-expr 's(0)' 2>&1 ||
echo 'command failed: test-expr '\''s(0)'\'''

echo '$ test-expr '\''s(`foo`)'\'''
test-expr 's(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''s(`foo`)'\'''

echo '$ test-expr '\''s(0,1)'\'''
test-expr 's(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''s(0,1)'\'''

echo '$ test-expr '\''s(`foo`,1)'\'''
test-expr 's(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''s(`foo`,1)'\'''

echo '$ test-expr '\''s(`foo`,`bar`)'\'''
test-expr 's(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''s(`foo`,`bar`)'\'''

echo '$ test-expr '\''s(0,`bar`)'\'''
test-expr 's(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''s(0,`bar`)'\'''

echo '$ test-expr '\''st'\'''
test-expr 'st' 2>&1 ||
echo 'command failed: test-expr '\''st'\'''

echo '$ test-expr '\''st()'\'''
test-expr 'st()' 2>&1 ||
echo 'command failed: test-expr '\''st()'\'''

echo '$ test-expr '\''st(0)'\'''
test-expr 'st(0)' 2>&1 ||
echo 'command failed: test-expr '\''st(0)'\'''

echo '$ test-expr '\''st(`foo`)'\'''
test-expr 'st(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''st(`foo`)'\'''

echo '$ test-expr '\''st(0,1)'\'''
test-expr 'st(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''st(0,1)'\'''

echo '$ test-expr '\''st(`foo`,1)'\'''
test-expr 'st(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''st(`foo`,1)'\'''

echo '$ test-expr '\''st(`foo`,`bar`)'\'''
test-expr 'st(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''st(`foo`,`bar`)'\'''

echo '$ test-expr '\''st(0,`bar`)'\'''
test-expr 'st(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''st(0,`bar`)'\'''

echo '$ test-expr '\''str'\'''
test-expr 'str' 2>&1 ||
echo 'command failed: test-expr '\''str'\'''

echo '$ test-expr '\''str()'\'''
test-expr 'str()' 2>&1 ||
echo 'command failed: test-expr '\''str()'\'''

echo '$ test-expr '\''str(0)'\'''
test-expr 'str(0)' 2>&1 ||
echo 'command failed: test-expr '\''str(0)'\'''

echo '$ test-expr '\''str(`foo`)'\'''
test-expr 'str(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''str(`foo`)'\'''

echo '$ test-expr '\''str(0,1)'\'''
test-expr 'str(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''str(0,1)'\'''

echo '$ test-expr '\''str(`foo`,1)'\'''
test-expr 'str(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''str(`foo`,1)'\'''

echo '$ test-expr '\''str(`foo`,`bar`)'\'''
test-expr 'str(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''str(`foo`,`bar`)'\'''

echo '$ test-expr '\''str(0,`bar`)'\'''
test-expr 'str(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''str(0,`bar`)'\'''

echo '$ test-expr '\''stri'\'''
test-expr 'stri' 2>&1 ||
echo 'command failed: test-expr '\''stri'\'''

echo '$ test-expr '\''stri()'\'''
test-expr 'stri()' 2>&1 ||
echo 'command failed: test-expr '\''stri()'\'''

echo '$ test-expr '\''stri(0)'\'''
test-expr 'stri(0)' 2>&1 ||
echo 'command failed: test-expr '\''stri(0)'\'''

echo '$ test-expr '\''stri(`foo`)'\'''
test-expr 'stri(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''stri(`foo`)'\'''

echo '$ test-expr '\''stri(0,1)'\'''
test-expr 'stri(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''stri(0,1)'\'''

echo '$ test-expr '\''stri(`foo`,1)'\'''
test-expr 'stri(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''stri(`foo`,1)'\'''

echo '$ test-expr '\''stri(`foo`,`bar`)'\'''
test-expr 'stri(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''stri(`foo`,`bar`)'\'''

echo '$ test-expr '\''stri(0,`bar`)'\'''
test-expr 'stri(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''stri(0,`bar`)'\'''

echo '$ test-expr '\''strin'\'''
test-expr 'strin' 2>&1 ||
echo 'command failed: test-expr '\''strin'\'''

echo '$ test-expr '\''strin()'\'''
test-expr 'strin()' 2>&1 ||
echo 'command failed: test-expr '\''strin()'\'''

echo '$ test-expr '\''strin(0)'\'''
test-expr 'strin(0)' 2>&1 ||
echo 'command failed: test-expr '\''strin(0)'\'''

echo '$ test-expr '\''strin(`foo`)'\'''
test-expr 'strin(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''strin(`foo`)'\'''

echo '$ test-expr '\''strin(0,1)'\'''
test-expr 'strin(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''strin(0,1)'\'''

echo '$ test-expr '\''strin(`foo`,1)'\'''
test-expr 'strin(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''strin(`foo`,1)'\'''

echo '$ test-expr '\''strin(`foo`,`bar`)'\'''
test-expr 'strin(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''strin(`foo`,`bar`)'\'''

echo '$ test-expr '\''strin(0,`bar`)'\'''
test-expr 'strin(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''strin(0,`bar`)'\'''

echo '$ test-expr '\''string'\'''
test-expr 'string' 2>&1 ||
echo 'command failed: test-expr '\''string'\'''

echo '$ test-expr '\''string()'\'''
test-expr 'string()' 2>&1 ||
echo 'command failed: test-expr '\''string()'\'''

echo '$ test-expr '\''string(0)'\'''
test-expr 'string(0)' 2>&1 ||
echo 'command failed: test-expr '\''string(0)'\'''

echo '$ test-expr '\''string(`foo`)'\'''
test-expr 'string(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''string(`foo`)'\'''

echo '$ test-expr '\''string(0,1)'\'''
test-expr 'string(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''string(0,1)'\'''

echo '$ test-expr '\''string(`foo`,1)'\'''
test-expr 'string(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''string(`foo`,1)'\'''

echo '$ test-expr '\''string(`foo`,`bar`)'\'''
test-expr 'string(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''string(`foo`,`bar`)'\'''

echo '$ test-expr '\''string(0,`bar`)'\'''
test-expr 'string(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''string(0,`bar`)'\'''

echo '$ test-expr '\''t'\'''
test-expr 't' 2>&1 ||
echo 'command failed: test-expr '\''t'\'''

echo '$ test-expr '\''t()'\'''
test-expr 't()' 2>&1 ||
echo 'command failed: test-expr '\''t()'\'''

echo '$ test-expr '\''t(0)'\'''
test-expr 't(0)' 2>&1 ||
echo 'command failed: test-expr '\''t(0)'\'''

echo '$ test-expr '\''t(`foo`)'\'''
test-expr 't(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''t(`foo`)'\'''

echo '$ test-expr '\''t(0,1)'\'''
test-expr 't(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''t(0,1)'\'''

echo '$ test-expr '\''t(`foo`,1)'\'''
test-expr 't(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''t(`foo`,1)'\'''

echo '$ test-expr '\''t(`foo`,`bar`)'\'''
test-expr 't(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''t(`foo`,`bar`)'\'''

echo '$ test-expr '\''t(0,`bar`)'\'''
test-expr 't(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''t(0,`bar`)'\'''

echo '$ test-expr '\''ti'\'''
test-expr 'ti' 2>&1 ||
echo 'command failed: test-expr '\''ti'\'''

echo '$ test-expr '\''ti()'\'''
test-expr 'ti()' 2>&1 ||
echo 'command failed: test-expr '\''ti()'\'''

echo '$ test-expr '\''ti(0)'\'''
test-expr 'ti(0)' 2>&1 ||
echo 'command failed: test-expr '\''ti(0)'\'''

echo '$ test-expr '\''ti(`foo`)'\'''
test-expr 'ti(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ti(`foo`)'\'''

echo '$ test-expr '\''ti(0,1)'\'''
test-expr 'ti(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ti(0,1)'\'''

echo '$ test-expr '\''ti(`foo`,1)'\'''
test-expr 'ti(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ti(`foo`,1)'\'''

echo '$ test-expr '\''ti(`foo`,`bar`)'\'''
test-expr 'ti(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ti(`foo`,`bar`)'\'''

echo '$ test-expr '\''ti(0,`bar`)'\'''
test-expr 'ti(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ti(0,`bar`)'\'''

echo '$ test-expr '\''tim'\'''
test-expr 'tim' 2>&1 ||
echo 'command failed: test-expr '\''tim'\'''

echo '$ test-expr '\''tim()'\'''
test-expr 'tim()' 2>&1 ||
echo 'command failed: test-expr '\''tim()'\'''

echo '$ test-expr '\''tim(0)'\'''
test-expr 'tim(0)' 2>&1 ||
echo 'command failed: test-expr '\''tim(0)'\'''

echo '$ test-expr '\''tim(`foo`)'\'''
test-expr 'tim(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''tim(`foo`)'\'''

echo '$ test-expr '\''tim(0,1)'\'''
test-expr 'tim(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''tim(0,1)'\'''

echo '$ test-expr '\''tim(`foo`,1)'\'''
test-expr 'tim(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''tim(`foo`,1)'\'''

echo '$ test-expr '\''tim(`foo`,`bar`)'\'''
test-expr 'tim(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''tim(`foo`,`bar`)'\'''

echo '$ test-expr '\''tim(0,`bar`)'\'''
test-expr 'tim(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''tim(0,`bar`)'\'''

echo '$ test-expr '\''time'\'''
test-expr 'time' 2>&1 ||
echo 'command failed: test-expr '\''time'\'''

echo '$ test-expr '\''time()'\'''
test-expr 'time()' 2>&1 ||
echo 'command failed: test-expr '\''time()'\'''

echo '$ test-expr '\''time(0)'\'''
test-expr 'time(0)' 2>&1 ||
echo 'command failed: test-expr '\''time(0)'\'''

echo '$ test-expr '\''time(`foo`)'\'''
test-expr 'time(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''time(`foo`)'\'''

echo '$ test-expr '\''time(0,1)'\'''
test-expr 'time(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''time(0,1)'\'''

echo '$ test-expr '\''time(`foo`,1)'\'''
test-expr 'time(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''time(`foo`,1)'\'''

echo '$ test-expr '\''time(`foo`,`bar`)'\'''
test-expr 'time(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''time(`foo`,`bar`)'\'''

echo '$ test-expr '\''time(0,`bar`)'\'''
test-expr 'time(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''time(0,`bar`)'\'''

echo '$ test-expr '\''times'\'''
test-expr 'times' 2>&1 ||
echo 'command failed: test-expr '\''times'\'''

echo '$ test-expr '\''times()'\'''
test-expr 'times()' 2>&1 ||
echo 'command failed: test-expr '\''times()'\'''

echo '$ test-expr '\''times(0)'\'''
test-expr 'times(0)' 2>&1 ||
echo 'command failed: test-expr '\''times(0)'\'''

echo '$ test-expr '\''times(`foo`)'\'''
test-expr 'times(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''times(`foo`)'\'''

echo '$ test-expr '\''times(0,1)'\'''
test-expr 'times(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''times(0,1)'\'''

echo '$ test-expr '\''times(`foo`,1)'\'''
test-expr 'times(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''times(`foo`,1)'\'''

echo '$ test-expr '\''times(`foo`,`bar`)'\'''
test-expr 'times(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''times(`foo`,`bar`)'\'''

echo '$ test-expr '\''times(0,`bar`)'\'''
test-expr 'times(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''times(0,`bar`)'\'''

echo '$ test-expr '\''timest'\'''
test-expr 'timest' 2>&1 ||
echo 'command failed: test-expr '\''timest'\'''

echo '$ test-expr '\''timest()'\'''
test-expr 'timest()' 2>&1 ||
echo 'command failed: test-expr '\''timest()'\'''

echo '$ test-expr '\''timest(0)'\'''
test-expr 'timest(0)' 2>&1 ||
echo 'command failed: test-expr '\''timest(0)'\'''

echo '$ test-expr '\''timest(`foo`)'\'''
test-expr 'timest(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''timest(`foo`)'\'''

echo '$ test-expr '\''timest(0,1)'\'''
test-expr 'timest(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''timest(0,1)'\'''

echo '$ test-expr '\''timest(`foo`,1)'\'''
test-expr 'timest(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''timest(`foo`,1)'\'''

echo '$ test-expr '\''timest(`foo`,`bar`)'\'''
test-expr 'timest(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timest(`foo`,`bar`)'\'''

echo '$ test-expr '\''timest(0,`bar`)'\'''
test-expr 'timest(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timest(0,`bar`)'\'''

echo '$ test-expr '\''timesta'\'''
test-expr 'timesta' 2>&1 ||
echo 'command failed: test-expr '\''timesta'\'''

echo '$ test-expr '\''timesta()'\'''
test-expr 'timesta()' 2>&1 ||
echo 'command failed: test-expr '\''timesta()'\'''

echo '$ test-expr '\''timesta(0)'\'''
test-expr 'timesta(0)' 2>&1 ||
echo 'command failed: test-expr '\''timesta(0)'\'''

echo '$ test-expr '\''timesta(`foo`)'\'''
test-expr 'timesta(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''timesta(`foo`)'\'''

echo '$ test-expr '\''timesta(0,1)'\'''
test-expr 'timesta(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''timesta(0,1)'\'''

echo '$ test-expr '\''timesta(`foo`,1)'\'''
test-expr 'timesta(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''timesta(`foo`,1)'\'''

echo '$ test-expr '\''timesta(`foo`,`bar`)'\'''
test-expr 'timesta(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timesta(`foo`,`bar`)'\'''

echo '$ test-expr '\''timesta(0,`bar`)'\'''
test-expr 'timesta(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timesta(0,`bar`)'\'''

echo '$ test-expr '\''timestam'\'''
test-expr 'timestam' 2>&1 ||
echo 'command failed: test-expr '\''timestam'\'''

echo '$ test-expr '\''timestam()'\'''
test-expr 'timestam()' 2>&1 ||
echo 'command failed: test-expr '\''timestam()'\'''

echo '$ test-expr '\''timestam(0)'\'''
test-expr 'timestam(0)' 2>&1 ||
echo 'command failed: test-expr '\''timestam(0)'\'''

echo '$ test-expr '\''timestam(`foo`)'\'''
test-expr 'timestam(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''timestam(`foo`)'\'''

echo '$ test-expr '\''timestam(0,1)'\'''
test-expr 'timestam(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''timestam(0,1)'\'''

echo '$ test-expr '\''timestam(`foo`,1)'\'''
test-expr 'timestam(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''timestam(`foo`,1)'\'''

echo '$ test-expr '\''timestam(`foo`,`bar`)'\'''
test-expr 'timestam(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timestam(`foo`,`bar`)'\'''

echo '$ test-expr '\''timestam(0,`bar`)'\'''
test-expr 'timestam(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timestam(0,`bar`)'\'''

echo '$ test-expr '\''timestamp'\'''
test-expr 'timestamp' 2>&1 ||
echo 'command failed: test-expr '\''timestamp'\'''

echo '$ test-expr '\''timestamp()'\'''
test-expr 'timestamp()' 2>&1 ||
echo 'command failed: test-expr '\''timestamp()'\'''

echo '$ test-expr '\''timestamp(0)'\'''
test-expr 'timestamp(0)' 2>&1 ||
echo 'command failed: test-expr '\''timestamp(0)'\'''

echo '$ test-expr '\''timestamp(`foo`)'\'''
test-expr 'timestamp(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''timestamp(`foo`)'\'''

echo '$ test-expr '\''timestamp(0,1)'\'''
test-expr 'timestamp(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''timestamp(0,1)'\'''

echo '$ test-expr '\''timestamp(`foo`,1)'\'''
test-expr 'timestamp(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''timestamp(`foo`,1)'\'''

echo '$ test-expr '\''timestamp(`foo`,`bar`)'\'''
test-expr 'timestamp(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timestamp(`foo`,`bar`)'\'''

echo '$ test-expr '\''timestamp(0,`bar`)'\'''
test-expr 'timestamp(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''timestamp(0,`bar`)'\'''

echo '$ test-expr '\''u'\'''
test-expr 'u' 2>&1 ||
echo 'command failed: test-expr '\''u'\'''

echo '$ test-expr '\''u()'\'''
test-expr 'u()' 2>&1 ||
echo 'command failed: test-expr '\''u()'\'''

echo '$ test-expr '\''u(0)'\'''
test-expr 'u(0)' 2>&1 ||
echo 'command failed: test-expr '\''u(0)'\'''

echo '$ test-expr '\''u(`foo`)'\'''
test-expr 'u(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''u(`foo`)'\'''

echo '$ test-expr '\''u(0,1)'\'''
test-expr 'u(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''u(0,1)'\'''

echo '$ test-expr '\''u(`foo`,1)'\'''
test-expr 'u(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''u(`foo`,1)'\'''

echo '$ test-expr '\''u(`foo`,`bar`)'\'''
test-expr 'u(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''u(`foo`,`bar`)'\'''

echo '$ test-expr '\''u(0,`bar`)'\'''
test-expr 'u(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''u(0,`bar`)'\'''

echo '$ test-expr '\''ui'\'''
test-expr 'ui' 2>&1 ||
echo 'command failed: test-expr '\''ui'\'''

echo '$ test-expr '\''ui()'\'''
test-expr 'ui()' 2>&1 ||
echo 'command failed: test-expr '\''ui()'\'''

echo '$ test-expr '\''ui(0)'\'''
test-expr 'ui(0)' 2>&1 ||
echo 'command failed: test-expr '\''ui(0)'\'''

echo '$ test-expr '\''ui(`foo`)'\'''
test-expr 'ui(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''ui(`foo`)'\'''

echo '$ test-expr '\''ui(0,1)'\'''
test-expr 'ui(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''ui(0,1)'\'''

echo '$ test-expr '\''ui(`foo`,1)'\'''
test-expr 'ui(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''ui(`foo`,1)'\'''

echo '$ test-expr '\''ui(`foo`,`bar`)'\'''
test-expr 'ui(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ui(`foo`,`bar`)'\'''

echo '$ test-expr '\''ui(0,`bar`)'\'''
test-expr 'ui(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''ui(0,`bar`)'\'''

echo '$ test-expr '\''uin'\'''
test-expr 'uin' 2>&1 ||
echo 'command failed: test-expr '\''uin'\'''

echo '$ test-expr '\''uin()'\'''
test-expr 'uin()' 2>&1 ||
echo 'command failed: test-expr '\''uin()'\'''

echo '$ test-expr '\''uin(0)'\'''
test-expr 'uin(0)' 2>&1 ||
echo 'command failed: test-expr '\''uin(0)'\'''

echo '$ test-expr '\''uin(`foo`)'\'''
test-expr 'uin(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''uin(`foo`)'\'''

echo '$ test-expr '\''uin(0,1)'\'''
test-expr 'uin(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''uin(0,1)'\'''

echo '$ test-expr '\''uin(`foo`,1)'\'''
test-expr 'uin(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''uin(`foo`,1)'\'''

echo '$ test-expr '\''uin(`foo`,`bar`)'\'''
test-expr 'uin(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''uin(`foo`,`bar`)'\'''

echo '$ test-expr '\''uin(0,`bar`)'\'''
test-expr 'uin(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''uin(0,`bar`)'\'''

echo '$ test-expr '\''uint'\'''
test-expr 'uint' 2>&1 ||
echo 'command failed: test-expr '\''uint'\'''

echo '$ test-expr '\''uint()'\'''
test-expr 'uint()' 2>&1 ||
echo 'command failed: test-expr '\''uint()'\'''

echo '$ test-expr '\''uint(0)'\'''
test-expr 'uint(0)' 2>&1 ||
echo 'command failed: test-expr '\''uint(0)'\'''

echo '$ test-expr '\''uint(`foo`)'\'''
test-expr 'uint(`foo`)' 2>&1 ||
echo 'command failed: test-expr '\''uint(`foo`)'\'''

echo '$ test-expr '\''uint(0,1)'\'''
test-expr 'uint(0,1)' 2>&1 ||
echo 'command failed: test-expr '\''uint(0,1)'\'''

echo '$ test-expr '\''uint(`foo`,1)'\'''
test-expr 'uint(`foo`,1)' 2>&1 ||
echo 'command failed: test-expr '\''uint(`foo`,1)'\'''

echo '$ test-expr '\''uint(`foo`,`bar`)'\'''
test-expr 'uint(`foo`,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''uint(`foo`,`bar`)'\'''

echo '$ test-expr '\''uint(0,`bar`)'\'''
test-expr 'uint(0,`bar`)' 2>&1 ||
echo 'command failed: test-expr '\''uint(0,`bar`)'\'''
)

