#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:dump-opts
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dump-opts.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ shopt -s expand_aliases
$ alias json='\''json0 -F -- ../lib/test-filter.so --dump-opt'\''
$ json
action:    generic
fail:      none
argc:      0
argv:      -
$ json --no-fail
action:    generic
fail:      none
argc:      0
argv:      -
$ json --fail=init
json: error: ../lib/test-filter.so: filter library: init failure
command failed: json --fail=init
$ json --fail=handler
action:    generic
fail:      handler
argc:      0
argv:      -
$ json --fail=exec
action:    generic
fail:      exec
argc:      0
argv:      -'
) -L dump-opts.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ alias json='\''json0 -F -- ../lib/test-filter.so --dump-opt'\'''
alias json='json0 -F -- ../lib/test-filter.so --dump-opt' 2>&1 ||
echo 'command failed: alias json='\''json0 -F -- ../lib/test-filter.so --dump-opt'\'''

echo '$ json'
json 2>&1 ||
echo 'command failed: json'

echo '$ json --no-fail'
json --no-fail 2>&1 ||
echo 'command failed: json --no-fail'

echo '$ json --fail=init'
json --fail=init 2>&1 ||
echo 'command failed: json --fail=init'

echo '$ json --fail=handler'
json --fail=handler 2>&1 ||
echo 'command failed: json --fail=handler'

echo '$ json --fail=exec'
json --fail=exec 2>&1 ||
echo 'command failed: json --fail=exec'
)

