#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:ascii2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L ascii2.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }
$ squote() { sed -r '\''s/^[#$]/\\\0/'\''; }
$ set -o pipefail
$ echo -e '\''\x0'\''|json -b 1
\u0000\n
$ echo -e '\''\x0'\''|json -b 2
\u0000\n
$ echo -e '\''\x0'\''|json -b 3
\u0000\n
$ echo -e '\''\x1'\''|json -b 1
\u0001\n
$ echo -e '\''\x1'\''|json -b 2
\u0001\n
$ echo -e '\''\x1'\''|json -b 3
\u0001\n
$ echo -e '\''\x2'\''|json -b 1
\u0002\n
$ echo -e '\''\x2'\''|json -b 2
\u0002\n
$ echo -e '\''\x2'\''|json -b 3
\u0002\n
$ echo -e '\''\x3'\''|json -b 1
\u0003\n
$ echo -e '\''\x3'\''|json -b 2
\u0003\n
$ echo -e '\''\x3'\''|json -b 3
\u0003\n
$ echo -e '\''\x4'\''|json -b 1
\u0004\n
$ echo -e '\''\x4'\''|json -b 2
\u0004\n
$ echo -e '\''\x4'\''|json -b 3
\u0004\n
$ echo -e '\''\x5'\''|json -b 1
\u0005\n
$ echo -e '\''\x5'\''|json -b 2
\u0005\n
$ echo -e '\''\x5'\''|json -b 3
\u0005\n
$ echo -e '\''\x6'\''|json -b 1
\u0006\n
$ echo -e '\''\x6'\''|json -b 2
\u0006\n
$ echo -e '\''\x6'\''|json -b 3
\u0006\n
$ echo -e '\''\x7'\''|json -b 1
\u0007\n
$ echo -e '\''\x7'\''|json -b 2
\u0007\n
$ echo -e '\''\x7'\''|json -b 3
\u0007\n
$ echo -e '\''\x8'\''|json -b 1
\b\n
$ echo -e '\''\x8'\''|json -b 2
\b\n
$ echo -e '\''\x8'\''|json -b 3
\b\n
$ echo -e '\''\x9'\''|json -b 1
\t\n
$ echo -e '\''\x9'\''|json -b 2
\t\n
$ echo -e '\''\x9'\''|json -b 3
\t\n
$ echo -e '\''\xa'\''|json -b 1
\n\n
$ echo -e '\''\xa'\''|json -b 2
\n\n
$ echo -e '\''\xa'\''|json -b 3
\n\n
$ echo -e '\''\xb'\''|json -b 1
\u000b\n
$ echo -e '\''\xb'\''|json -b 2
\u000b\n
$ echo -e '\''\xb'\''|json -b 3
\u000b\n
$ echo -e '\''\xc'\''|json -b 1
\f\n
$ echo -e '\''\xc'\''|json -b 2
\f\n
$ echo -e '\''\xc'\''|json -b 3
\f\n
$ echo -e '\''\xd'\''|json -b 1
\r\n
$ echo -e '\''\xd'\''|json -b 2
\r\n
$ echo -e '\''\xd'\''|json -b 3
\r\n
$ echo -e '\''\xe'\''|json -b 1
\u000e\n
$ echo -e '\''\xe'\''|json -b 2
\u000e\n
$ echo -e '\''\xe'\''|json -b 3
\u000e\n
$ echo -e '\''\xf'\''|json -b 1
\u000f\n
$ echo -e '\''\xf'\''|json -b 2
\u000f\n
$ echo -e '\''\xf'\''|json -b 3
\u000f\n
$ echo -e '\''\x10'\''|json -b 1
\u0010\n
$ echo -e '\''\x10'\''|json -b 2
\u0010\n
$ echo -e '\''\x10'\''|json -b 3
\u0010\n
$ echo -e '\''\x11'\''|json -b 1
\u0011\n
$ echo -e '\''\x11'\''|json -b 2
\u0011\n
$ echo -e '\''\x11'\''|json -b 3
\u0011\n
$ echo -e '\''\x12'\''|json -b 1
\u0012\n
$ echo -e '\''\x12'\''|json -b 2
\u0012\n
$ echo -e '\''\x12'\''|json -b 3
\u0012\n
$ echo -e '\''\x13'\''|json -b 1
\u0013\n
$ echo -e '\''\x13'\''|json -b 2
\u0013\n
$ echo -e '\''\x13'\''|json -b 3
\u0013\n
$ echo -e '\''\x14'\''|json -b 1
\u0014\n
$ echo -e '\''\x14'\''|json -b 2
\u0014\n
$ echo -e '\''\x14'\''|json -b 3
\u0014\n
$ echo -e '\''\x15'\''|json -b 1
\u0015\n
$ echo -e '\''\x15'\''|json -b 2
\u0015\n
$ echo -e '\''\x15'\''|json -b 3
\u0015\n
$ echo -e '\''\x16'\''|json -b 1
\u0016\n
$ echo -e '\''\x16'\''|json -b 2
\u0016\n
$ echo -e '\''\x16'\''|json -b 3
\u0016\n
$ echo -e '\''\x17'\''|json -b 1
\u0017\n
$ echo -e '\''\x17'\''|json -b 2
\u0017\n
$ echo -e '\''\x17'\''|json -b 3
\u0017\n
$ echo -e '\''\x18'\''|json -b 1
\u0018\n
$ echo -e '\''\x18'\''|json -b 2
\u0018\n
$ echo -e '\''\x18'\''|json -b 3
\u0018\n
$ echo -e '\''\x19'\''|json -b 1
\u0019\n
$ echo -e '\''\x19'\''|json -b 2
\u0019\n
$ echo -e '\''\x19'\''|json -b 3
\u0019\n
$ echo -e '\''\x1a'\''|json -b 1
\u001a\n
$ echo -e '\''\x1a'\''|json -b 2
\u001a\n
$ echo -e '\''\x1a'\''|json -b 3
\u001a\n
$ echo -e '\''\x1b'\''|json -b 1
\u001b\n
$ echo -e '\''\x1b'\''|json -b 2
\u001b\n
$ echo -e '\''\x1b'\''|json -b 3
\u001b\n
$ echo -e '\''\x1c'\''|json -b 1
\u001c\n
$ echo -e '\''\x1c'\''|json -b 2
\u001c\n
$ echo -e '\''\x1c'\''|json -b 3
\u001c\n
$ echo -e '\''\x1d'\''|json -b 1
\u001d\n
$ echo -e '\''\x1d'\''|json -b 2
\u001d\n
$ echo -e '\''\x1d'\''|json -b 3
\u001d\n
$ echo -e '\''\x1e'\''|json -b 1
\u001e\n
$ echo -e '\''\x1e'\''|json -b 2
\u001e\n
$ echo -e '\''\x1e'\''|json -b 3
\u001e\n
$ echo -e '\''\x1f'\''|json -b 1
\u001f\n
$ echo -e '\''\x1f'\''|json -b 2
\u001f\n
$ echo -e '\''\x1f'\''|json -b 3
\u001f\n
$ echo '\'' '\''|json -b 1
 \n
$ echo '\'' '\''|json -b 2
 \n
$ echo '\'' '\''|json -b 3
 \n
$ echo '\''!'\''|json -b 1
!\n
$ echo '\''!'\''|json -b 2
!\n
$ echo '\''!'\''|json -b 3
!\n
$ echo '\''"'\''|json -b 1
\"\n
$ echo '\''"'\''|json -b 2
\"\n
$ echo '\''"'\''|json -b 3
\"\n
$ echo '\''#'\''|json -b 1|squote
\#\n
$ echo '\''#'\''|json -b 2|squote
\#\n
$ echo '\''#'\''|json -b 3|squote
\#\n
$ echo '\''$'\''|json -b 1|squote
\$\n
$ echo '\''$'\''|json -b 2|squote
\$\n
$ echo '\''$'\''|json -b 3|squote
\$\n
$ echo '\''%'\''|json -b 1
%\n
$ echo '\''%'\''|json -b 2
%\n
$ echo '\''%'\''|json -b 3
%\n
$ echo '\''&'\''|json -b 1
&\n
$ echo '\''&'\''|json -b 2
&\n
$ echo '\''&'\''|json -b 3
&\n
$ echo -e '\''\x27'\''|json -b 1
'\''\n
$ echo -e '\''\x27'\''|json -b 2
'\''\n
$ echo -e '\''\x27'\''|json -b 3
'\''\n
$ echo '\''('\''|json -b 1
(\n
$ echo '\''('\''|json -b 2
(\n
$ echo '\''('\''|json -b 3
(\n
$ echo '\'')'\''|json -b 1
)\n
$ echo '\'')'\''|json -b 2
)\n
$ echo '\'')'\''|json -b 3
)\n
$ echo '\''*'\''|json -b 1
*\n
$ echo '\''*'\''|json -b 2
*\n
$ echo '\''*'\''|json -b 3
*\n
$ echo '\''+'\''|json -b 1
+\n
$ echo '\''+'\''|json -b 2
+\n
$ echo '\''+'\''|json -b 3
+\n
$ echo '\'','\''|json -b 1
,\n
$ echo '\'','\''|json -b 2
,\n
$ echo '\'','\''|json -b 3
,\n
$ echo '\''-'\''|json -b 1
-\n
$ echo '\''-'\''|json -b 2
-\n
$ echo '\''-'\''|json -b 3
-\n
$ echo '\''.'\''|json -b 1
.\n
$ echo '\''.'\''|json -b 2
.\n
$ echo '\''.'\''|json -b 3
.\n
$ echo '\''/'\''|json -b 1
/\n
$ echo '\''/'\''|json -b 2
/\n
$ echo '\''/'\''|json -b 3
/\n
$ echo '\''0'\''|json -b 1
0\n
$ echo '\''0'\''|json -b 2
0\n
$ echo '\''0'\''|json -b 3
0\n
$ echo '\''1'\''|json -b 1
1\n
$ echo '\''1'\''|json -b 2
1\n
$ echo '\''1'\''|json -b 3
1\n
$ echo '\''2'\''|json -b 1
2\n
$ echo '\''2'\''|json -b 2
2\n
$ echo '\''2'\''|json -b 3
2\n
$ echo '\''3'\''|json -b 1
3\n
$ echo '\''3'\''|json -b 2
3\n
$ echo '\''3'\''|json -b 3
3\n
$ echo '\''4'\''|json -b 1
4\n
$ echo '\''4'\''|json -b 2
4\n
$ echo '\''4'\''|json -b 3
4\n
$ echo '\''5'\''|json -b 1
5\n
$ echo '\''5'\''|json -b 2
5\n
$ echo '\''5'\''|json -b 3
5\n
$ echo '\''6'\''|json -b 1
6\n
$ echo '\''6'\''|json -b 2
6\n
$ echo '\''6'\''|json -b 3
6\n
$ echo '\''7'\''|json -b 1
7\n
$ echo '\''7'\''|json -b 2
7\n
$ echo '\''7'\''|json -b 3
7\n
$ echo '\''8'\''|json -b 1
8\n
$ echo '\''8'\''|json -b 2
8\n
$ echo '\''8'\''|json -b 3
8\n
$ echo '\''9'\''|json -b 1
9\n
$ echo '\''9'\''|json -b 2
9\n
$ echo '\''9'\''|json -b 3
9\n
$ echo '\'':'\''|json -b 1
:\n
$ echo '\'':'\''|json -b 2
:\n
$ echo '\'':'\''|json -b 3
:\n
$ echo '\'';'\''|json -b 1
;\n
$ echo '\'';'\''|json -b 2
;\n
$ echo '\'';'\''|json -b 3
;\n
$ echo '\''<'\''|json -b 1
<\n
$ echo '\''<'\''|json -b 2
<\n
$ echo '\''<'\''|json -b 3
<\n
$ echo '\''='\''|json -b 1
=\n
$ echo '\''='\''|json -b 2
=\n
$ echo '\''='\''|json -b 3
=\n
$ echo '\''>'\''|json -b 1
>\n
$ echo '\''>'\''|json -b 2
>\n
$ echo '\''>'\''|json -b 3
>\n
$ echo '\''?'\''|json -b 1
?\n
$ echo '\''?'\''|json -b 2
?\n
$ echo '\''?'\''|json -b 3
?\n
$ echo '\''@'\''|json -b 1
@\n
$ echo '\''@'\''|json -b 2
@\n
$ echo '\''@'\''|json -b 3
@\n
$ echo '\''A'\''|json -b 1
A\n
$ echo '\''A'\''|json -b 2
A\n
$ echo '\''A'\''|json -b 3
A\n
$ echo '\''B'\''|json -b 1
B\n
$ echo '\''B'\''|json -b 2
B\n
$ echo '\''B'\''|json -b 3
B\n
$ echo '\''C'\''|json -b 1
C\n
$ echo '\''C'\''|json -b 2
C\n
$ echo '\''C'\''|json -b 3
C\n
$ echo '\''D'\''|json -b 1
D\n
$ echo '\''D'\''|json -b 2
D\n
$ echo '\''D'\''|json -b 3
D\n
$ echo '\''E'\''|json -b 1
E\n
$ echo '\''E'\''|json -b 2
E\n
$ echo '\''E'\''|json -b 3
E\n
$ echo '\''F'\''|json -b 1
F\n
$ echo '\''F'\''|json -b 2
F\n
$ echo '\''F'\''|json -b 3
F\n
$ echo '\''G'\''|json -b 1
G\n
$ echo '\''G'\''|json -b 2
G\n
$ echo '\''G'\''|json -b 3
G\n
$ echo '\''H'\''|json -b 1
H\n
$ echo '\''H'\''|json -b 2
H\n
$ echo '\''H'\''|json -b 3
H\n
$ echo '\''I'\''|json -b 1
I\n
$ echo '\''I'\''|json -b 2
I\n
$ echo '\''I'\''|json -b 3
I\n
$ echo '\''J'\''|json -b 1
J\n
$ echo '\''J'\''|json -b 2
J\n
$ echo '\''J'\''|json -b 3
J\n
$ echo '\''K'\''|json -b 1
K\n
$ echo '\''K'\''|json -b 2
K\n
$ echo '\''K'\''|json -b 3
K\n
$ echo '\''L'\''|json -b 1
L\n
$ echo '\''L'\''|json -b 2
L\n
$ echo '\''L'\''|json -b 3
L\n
$ echo '\''M'\''|json -b 1
M\n
$ echo '\''M'\''|json -b 2
M\n
$ echo '\''M'\''|json -b 3
M\n
$ echo '\''N'\''|json -b 1
N\n
$ echo '\''N'\''|json -b 2
N\n
$ echo '\''N'\''|json -b 3
N\n
$ echo '\''O'\''|json -b 1
O\n
$ echo '\''O'\''|json -b 2
O\n
$ echo '\''O'\''|json -b 3
O\n
$ echo '\''P'\''|json -b 1
P\n
$ echo '\''P'\''|json -b 2
P\n
$ echo '\''P'\''|json -b 3
P\n
$ echo '\''Q'\''|json -b 1
Q\n
$ echo '\''Q'\''|json -b 2
Q\n
$ echo '\''Q'\''|json -b 3
Q\n
$ echo '\''R'\''|json -b 1
R\n
$ echo '\''R'\''|json -b 2
R\n
$ echo '\''R'\''|json -b 3
R\n
$ echo '\''S'\''|json -b 1
S\n
$ echo '\''S'\''|json -b 2
S\n
$ echo '\''S'\''|json -b 3
S\n
$ echo '\''T'\''|json -b 1
T\n
$ echo '\''T'\''|json -b 2
T\n
$ echo '\''T'\''|json -b 3
T\n
$ echo '\''U'\''|json -b 1
U\n
$ echo '\''U'\''|json -b 2
U\n
$ echo '\''U'\''|json -b 3
U\n
$ echo '\''V'\''|json -b 1
V\n
$ echo '\''V'\''|json -b 2
V\n
$ echo '\''V'\''|json -b 3
V\n
$ echo '\''W'\''|json -b 1
W\n
$ echo '\''W'\''|json -b 2
W\n
$ echo '\''W'\''|json -b 3
W\n
$ echo '\''X'\''|json -b 1
X\n
$ echo '\''X'\''|json -b 2
X\n
$ echo '\''X'\''|json -b 3
X\n
$ echo '\''Y'\''|json -b 1
Y\n
$ echo '\''Y'\''|json -b 2
Y\n
$ echo '\''Y'\''|json -b 3
Y\n
$ echo '\''Z'\''|json -b 1
Z\n
$ echo '\''Z'\''|json -b 2
Z\n
$ echo '\''Z'\''|json -b 3
Z\n
$ echo '\''['\''|json -b 1
[\n
$ echo '\''['\''|json -b 2
[\n
$ echo '\''['\''|json -b 3
[\n
$ echo '\''\'\''|json -b 1
\\\n
$ echo '\''\'\''|json -b 2
\\\n
$ echo '\''\'\''|json -b 3
\\\n
$ echo '\'']'\''|json -b 1
]\n
$ echo '\'']'\''|json -b 2
]\n
$ echo '\'']'\''|json -b 3
]\n
$ echo '\''^'\''|json -b 1
^\n
$ echo '\''^'\''|json -b 2
^\n
$ echo '\''^'\''|json -b 3
^\n
$ echo '\''_'\''|json -b 1
_\n
$ echo '\''_'\''|json -b 2
_\n
$ echo '\''_'\''|json -b 3
_\n
$ echo '\''`'\''|json -b 1
`\n
$ echo '\''`'\''|json -b 2
`\n
$ echo '\''`'\''|json -b 3
`\n
$ echo '\''a'\''|json -b 1
a\n
$ echo '\''a'\''|json -b 2
a\n
$ echo '\''a'\''|json -b 3
a\n
$ echo '\''b'\''|json -b 1
b\n
$ echo '\''b'\''|json -b 2
b\n
$ echo '\''b'\''|json -b 3
b\n
$ echo '\''c'\''|json -b 1
c\n
$ echo '\''c'\''|json -b 2
c\n
$ echo '\''c'\''|json -b 3
c\n
$ echo '\''d'\''|json -b 1
d\n
$ echo '\''d'\''|json -b 2
d\n
$ echo '\''d'\''|json -b 3
d\n
$ echo '\''e'\''|json -b 1
e\n
$ echo '\''e'\''|json -b 2
e\n
$ echo '\''e'\''|json -b 3
e\n
$ echo '\''f'\''|json -b 1
f\n
$ echo '\''f'\''|json -b 2
f\n
$ echo '\''f'\''|json -b 3
f\n
$ echo '\''g'\''|json -b 1
g\n
$ echo '\''g'\''|json -b 2
g\n
$ echo '\''g'\''|json -b 3
g\n
$ echo '\''h'\''|json -b 1
h\n
$ echo '\''h'\''|json -b 2
h\n
$ echo '\''h'\''|json -b 3
h\n
$ echo '\''i'\''|json -b 1
i\n
$ echo '\''i'\''|json -b 2
i\n
$ echo '\''i'\''|json -b 3
i\n
$ echo '\''j'\''|json -b 1
j\n
$ echo '\''j'\''|json -b 2
j\n
$ echo '\''j'\''|json -b 3
j\n
$ echo '\''k'\''|json -b 1
k\n
$ echo '\''k'\''|json -b 2
k\n
$ echo '\''k'\''|json -b 3
k\n
$ echo '\''l'\''|json -b 1
l\n
$ echo '\''l'\''|json -b 2
l\n
$ echo '\''l'\''|json -b 3
l\n
$ echo '\''m'\''|json -b 1
m\n
$ echo '\''m'\''|json -b 2
m\n
$ echo '\''m'\''|json -b 3
m\n
$ echo '\''n'\''|json -b 1
n\n
$ echo '\''n'\''|json -b 2
n\n
$ echo '\''n'\''|json -b 3
n\n
$ echo '\''o'\''|json -b 1
o\n
$ echo '\''o'\''|json -b 2
o\n
$ echo '\''o'\''|json -b 3
o\n
$ echo '\''p'\''|json -b 1
p\n
$ echo '\''p'\''|json -b 2
p\n
$ echo '\''p'\''|json -b 3
p\n
$ echo '\''q'\''|json -b 1
q\n
$ echo '\''q'\''|json -b 2
q\n
$ echo '\''q'\''|json -b 3
q\n
$ echo '\''r'\''|json -b 1
r\n
$ echo '\''r'\''|json -b 2
r\n
$ echo '\''r'\''|json -b 3
r\n
$ echo '\''s'\''|json -b 1
s\n
$ echo '\''s'\''|json -b 2
s\n
$ echo '\''s'\''|json -b 3
s\n
$ echo '\''t'\''|json -b 1
t\n
$ echo '\''t'\''|json -b 2
t\n
$ echo '\''t'\''|json -b 3
t\n
$ echo '\''u'\''|json -b 1
u\n
$ echo '\''u'\''|json -b 2
u\n
$ echo '\''u'\''|json -b 3
u\n
$ echo '\''v'\''|json -b 1
v\n
$ echo '\''v'\''|json -b 2
v\n
$ echo '\''v'\''|json -b 3
v\n
$ echo '\''w'\''|json -b 1
w\n
$ echo '\''w'\''|json -b 2
w\n
$ echo '\''w'\''|json -b 3
w\n
$ echo '\''x'\''|json -b 1
x\n
$ echo '\''x'\''|json -b 2
x\n
$ echo '\''x'\''|json -b 3
x\n
$ echo '\''y'\''|json -b 1
y\n
$ echo '\''y'\''|json -b 2
y\n
$ echo '\''y'\''|json -b 3
y\n
$ echo '\''z'\''|json -b 1
z\n
$ echo '\''z'\''|json -b 2
z\n
$ echo '\''z'\''|json -b 3
z\n
$ echo '\''{'\''|json -b 1
{\n
$ echo '\''{'\''|json -b 2
{\n
$ echo '\''{'\''|json -b 3
{\n
$ echo '\''|'\''|json -b 1
|\n
$ echo '\''|'\''|json -b 2
|\n
$ echo '\''|'\''|json -b 3
|\n
$ echo '\''}'\''|json -b 1
}\n
$ echo '\''}'\''|json -b 2
}\n
$ echo '\''}'\''|json -b 3
}\n
$ echo '\''~'\''|json -b 1
~\n
$ echo '\''~'\''|json -b 2
~\n
$ echo '\''~'\''|json -b 3
~\n
$ echo -e '\''\x7f'\''|json -b 1
\u007f\n
$ echo -e '\''\x7f'\''|json -b 2
\u007f\n
$ echo -e '\''\x7f'\''|json -b 3
\u007f\n'
) -L ascii2.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'

echo '$ squote() { sed -r '\''s/^[#$]/\\\0/'\''; }'
squote() { sed -r 's/^[#$]/\\\0/'; } 2>&1 ||
echo 'command failed: squote() { sed -r '\''s/^[#$]/\\\0/'\''; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ echo -e '\''\x0'\''|json -b 1'
echo -e '\x0'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x0'\''|json -b 1'

echo '$ echo -e '\''\x0'\''|json -b 2'
echo -e '\x0'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x0'\''|json -b 2'

echo '$ echo -e '\''\x0'\''|json -b 3'
echo -e '\x0'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x0'\''|json -b 3'

echo '$ echo -e '\''\x1'\''|json -b 1'
echo -e '\x1'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1'\''|json -b 1'

echo '$ echo -e '\''\x1'\''|json -b 2'
echo -e '\x1'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1'\''|json -b 2'

echo '$ echo -e '\''\x1'\''|json -b 3'
echo -e '\x1'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1'\''|json -b 3'

echo '$ echo -e '\''\x2'\''|json -b 1'
echo -e '\x2'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x2'\''|json -b 1'

echo '$ echo -e '\''\x2'\''|json -b 2'
echo -e '\x2'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x2'\''|json -b 2'

echo '$ echo -e '\''\x2'\''|json -b 3'
echo -e '\x2'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x2'\''|json -b 3'

echo '$ echo -e '\''\x3'\''|json -b 1'
echo -e '\x3'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x3'\''|json -b 1'

echo '$ echo -e '\''\x3'\''|json -b 2'
echo -e '\x3'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x3'\''|json -b 2'

echo '$ echo -e '\''\x3'\''|json -b 3'
echo -e '\x3'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x3'\''|json -b 3'

echo '$ echo -e '\''\x4'\''|json -b 1'
echo -e '\x4'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x4'\''|json -b 1'

echo '$ echo -e '\''\x4'\''|json -b 2'
echo -e '\x4'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x4'\''|json -b 2'

echo '$ echo -e '\''\x4'\''|json -b 3'
echo -e '\x4'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x4'\''|json -b 3'

echo '$ echo -e '\''\x5'\''|json -b 1'
echo -e '\x5'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x5'\''|json -b 1'

echo '$ echo -e '\''\x5'\''|json -b 2'
echo -e '\x5'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x5'\''|json -b 2'

echo '$ echo -e '\''\x5'\''|json -b 3'
echo -e '\x5'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x5'\''|json -b 3'

echo '$ echo -e '\''\x6'\''|json -b 1'
echo -e '\x6'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x6'\''|json -b 1'

echo '$ echo -e '\''\x6'\''|json -b 2'
echo -e '\x6'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x6'\''|json -b 2'

echo '$ echo -e '\''\x6'\''|json -b 3'
echo -e '\x6'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x6'\''|json -b 3'

echo '$ echo -e '\''\x7'\''|json -b 1'
echo -e '\x7'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x7'\''|json -b 1'

echo '$ echo -e '\''\x7'\''|json -b 2'
echo -e '\x7'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x7'\''|json -b 2'

echo '$ echo -e '\''\x7'\''|json -b 3'
echo -e '\x7'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x7'\''|json -b 3'

echo '$ echo -e '\''\x8'\''|json -b 1'
echo -e '\x8'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x8'\''|json -b 1'

echo '$ echo -e '\''\x8'\''|json -b 2'
echo -e '\x8'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x8'\''|json -b 2'

echo '$ echo -e '\''\x8'\''|json -b 3'
echo -e '\x8'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x8'\''|json -b 3'

echo '$ echo -e '\''\x9'\''|json -b 1'
echo -e '\x9'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x9'\''|json -b 1'

echo '$ echo -e '\''\x9'\''|json -b 2'
echo -e '\x9'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x9'\''|json -b 2'

echo '$ echo -e '\''\x9'\''|json -b 3'
echo -e '\x9'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x9'\''|json -b 3'

echo '$ echo -e '\''\xa'\''|json -b 1'
echo -e '\xa'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\xa'\''|json -b 1'

echo '$ echo -e '\''\xa'\''|json -b 2'
echo -e '\xa'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\xa'\''|json -b 2'

echo '$ echo -e '\''\xa'\''|json -b 3'
echo -e '\xa'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\xa'\''|json -b 3'

echo '$ echo -e '\''\xb'\''|json -b 1'
echo -e '\xb'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\xb'\''|json -b 1'

echo '$ echo -e '\''\xb'\''|json -b 2'
echo -e '\xb'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\xb'\''|json -b 2'

echo '$ echo -e '\''\xb'\''|json -b 3'
echo -e '\xb'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\xb'\''|json -b 3'

echo '$ echo -e '\''\xc'\''|json -b 1'
echo -e '\xc'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\xc'\''|json -b 1'

echo '$ echo -e '\''\xc'\''|json -b 2'
echo -e '\xc'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\xc'\''|json -b 2'

echo '$ echo -e '\''\xc'\''|json -b 3'
echo -e '\xc'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\xc'\''|json -b 3'

echo '$ echo -e '\''\xd'\''|json -b 1'
echo -e '\xd'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\xd'\''|json -b 1'

echo '$ echo -e '\''\xd'\''|json -b 2'
echo -e '\xd'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\xd'\''|json -b 2'

echo '$ echo -e '\''\xd'\''|json -b 3'
echo -e '\xd'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\xd'\''|json -b 3'

echo '$ echo -e '\''\xe'\''|json -b 1'
echo -e '\xe'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\xe'\''|json -b 1'

echo '$ echo -e '\''\xe'\''|json -b 2'
echo -e '\xe'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\xe'\''|json -b 2'

echo '$ echo -e '\''\xe'\''|json -b 3'
echo -e '\xe'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\xe'\''|json -b 3'

echo '$ echo -e '\''\xf'\''|json -b 1'
echo -e '\xf'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\xf'\''|json -b 1'

echo '$ echo -e '\''\xf'\''|json -b 2'
echo -e '\xf'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\xf'\''|json -b 2'

echo '$ echo -e '\''\xf'\''|json -b 3'
echo -e '\xf'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\xf'\''|json -b 3'

echo '$ echo -e '\''\x10'\''|json -b 1'
echo -e '\x10'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x10'\''|json -b 1'

echo '$ echo -e '\''\x10'\''|json -b 2'
echo -e '\x10'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x10'\''|json -b 2'

echo '$ echo -e '\''\x10'\''|json -b 3'
echo -e '\x10'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x10'\''|json -b 3'

echo '$ echo -e '\''\x11'\''|json -b 1'
echo -e '\x11'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x11'\''|json -b 1'

echo '$ echo -e '\''\x11'\''|json -b 2'
echo -e '\x11'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x11'\''|json -b 2'

echo '$ echo -e '\''\x11'\''|json -b 3'
echo -e '\x11'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x11'\''|json -b 3'

echo '$ echo -e '\''\x12'\''|json -b 1'
echo -e '\x12'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x12'\''|json -b 1'

echo '$ echo -e '\''\x12'\''|json -b 2'
echo -e '\x12'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x12'\''|json -b 2'

echo '$ echo -e '\''\x12'\''|json -b 3'
echo -e '\x12'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x12'\''|json -b 3'

echo '$ echo -e '\''\x13'\''|json -b 1'
echo -e '\x13'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x13'\''|json -b 1'

echo '$ echo -e '\''\x13'\''|json -b 2'
echo -e '\x13'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x13'\''|json -b 2'

echo '$ echo -e '\''\x13'\''|json -b 3'
echo -e '\x13'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x13'\''|json -b 3'

echo '$ echo -e '\''\x14'\''|json -b 1'
echo -e '\x14'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x14'\''|json -b 1'

echo '$ echo -e '\''\x14'\''|json -b 2'
echo -e '\x14'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x14'\''|json -b 2'

echo '$ echo -e '\''\x14'\''|json -b 3'
echo -e '\x14'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x14'\''|json -b 3'

echo '$ echo -e '\''\x15'\''|json -b 1'
echo -e '\x15'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x15'\''|json -b 1'

echo '$ echo -e '\''\x15'\''|json -b 2'
echo -e '\x15'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x15'\''|json -b 2'

echo '$ echo -e '\''\x15'\''|json -b 3'
echo -e '\x15'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x15'\''|json -b 3'

echo '$ echo -e '\''\x16'\''|json -b 1'
echo -e '\x16'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x16'\''|json -b 1'

echo '$ echo -e '\''\x16'\''|json -b 2'
echo -e '\x16'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x16'\''|json -b 2'

echo '$ echo -e '\''\x16'\''|json -b 3'
echo -e '\x16'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x16'\''|json -b 3'

echo '$ echo -e '\''\x17'\''|json -b 1'
echo -e '\x17'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x17'\''|json -b 1'

echo '$ echo -e '\''\x17'\''|json -b 2'
echo -e '\x17'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x17'\''|json -b 2'

echo '$ echo -e '\''\x17'\''|json -b 3'
echo -e '\x17'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x17'\''|json -b 3'

echo '$ echo -e '\''\x18'\''|json -b 1'
echo -e '\x18'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x18'\''|json -b 1'

echo '$ echo -e '\''\x18'\''|json -b 2'
echo -e '\x18'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x18'\''|json -b 2'

echo '$ echo -e '\''\x18'\''|json -b 3'
echo -e '\x18'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x18'\''|json -b 3'

echo '$ echo -e '\''\x19'\''|json -b 1'
echo -e '\x19'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x19'\''|json -b 1'

echo '$ echo -e '\''\x19'\''|json -b 2'
echo -e '\x19'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x19'\''|json -b 2'

echo '$ echo -e '\''\x19'\''|json -b 3'
echo -e '\x19'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x19'\''|json -b 3'

echo '$ echo -e '\''\x1a'\''|json -b 1'
echo -e '\x1a'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1a'\''|json -b 1'

echo '$ echo -e '\''\x1a'\''|json -b 2'
echo -e '\x1a'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1a'\''|json -b 2'

echo '$ echo -e '\''\x1a'\''|json -b 3'
echo -e '\x1a'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1a'\''|json -b 3'

echo '$ echo -e '\''\x1b'\''|json -b 1'
echo -e '\x1b'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1b'\''|json -b 1'

echo '$ echo -e '\''\x1b'\''|json -b 2'
echo -e '\x1b'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1b'\''|json -b 2'

echo '$ echo -e '\''\x1b'\''|json -b 3'
echo -e '\x1b'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1b'\''|json -b 3'

echo '$ echo -e '\''\x1c'\''|json -b 1'
echo -e '\x1c'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1c'\''|json -b 1'

echo '$ echo -e '\''\x1c'\''|json -b 2'
echo -e '\x1c'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1c'\''|json -b 2'

echo '$ echo -e '\''\x1c'\''|json -b 3'
echo -e '\x1c'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1c'\''|json -b 3'

echo '$ echo -e '\''\x1d'\''|json -b 1'
echo -e '\x1d'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1d'\''|json -b 1'

echo '$ echo -e '\''\x1d'\''|json -b 2'
echo -e '\x1d'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1d'\''|json -b 2'

echo '$ echo -e '\''\x1d'\''|json -b 3'
echo -e '\x1d'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1d'\''|json -b 3'

echo '$ echo -e '\''\x1e'\''|json -b 1'
echo -e '\x1e'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1e'\''|json -b 1'

echo '$ echo -e '\''\x1e'\''|json -b 2'
echo -e '\x1e'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1e'\''|json -b 2'

echo '$ echo -e '\''\x1e'\''|json -b 3'
echo -e '\x1e'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1e'\''|json -b 3'

echo '$ echo -e '\''\x1f'\''|json -b 1'
echo -e '\x1f'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x1f'\''|json -b 1'

echo '$ echo -e '\''\x1f'\''|json -b 2'
echo -e '\x1f'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x1f'\''|json -b 2'

echo '$ echo -e '\''\x1f'\''|json -b 3'
echo -e '\x1f'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x1f'\''|json -b 3'

echo '$ echo '\'' '\''|json -b 1'
echo ' '|json -b 1 2>&1 ||
echo 'command failed: echo '\'' '\''|json -b 1'

echo '$ echo '\'' '\''|json -b 2'
echo ' '|json -b 2 2>&1 ||
echo 'command failed: echo '\'' '\''|json -b 2'

echo '$ echo '\'' '\''|json -b 3'
echo ' '|json -b 3 2>&1 ||
echo 'command failed: echo '\'' '\''|json -b 3'

echo '$ echo '\''!'\''|json -b 1'
echo '!'|json -b 1 2>&1 ||
echo 'command failed: echo '\''!'\''|json -b 1'

echo '$ echo '\''!'\''|json -b 2'
echo '!'|json -b 2 2>&1 ||
echo 'command failed: echo '\''!'\''|json -b 2'

echo '$ echo '\''!'\''|json -b 3'
echo '!'|json -b 3 2>&1 ||
echo 'command failed: echo '\''!'\''|json -b 3'

echo '$ echo '\''"'\''|json -b 1'
echo '"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"'\''|json -b 1'

echo '$ echo '\''"'\''|json -b 2'
echo '"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"'\''|json -b 2'

echo '$ echo '\''"'\''|json -b 3'
echo '"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"'\''|json -b 3'

echo '$ echo '\''#'\''|json -b 1|squote'
echo '#'|json -b 1|squote 2>&1 ||
echo 'command failed: echo '\''#'\''|json -b 1|squote'

echo '$ echo '\''#'\''|json -b 2|squote'
echo '#'|json -b 2|squote 2>&1 ||
echo 'command failed: echo '\''#'\''|json -b 2|squote'

echo '$ echo '\''#'\''|json -b 3|squote'
echo '#'|json -b 3|squote 2>&1 ||
echo 'command failed: echo '\''#'\''|json -b 3|squote'

echo '$ echo '\''$'\''|json -b 1|squote'
echo '$'|json -b 1|squote 2>&1 ||
echo 'command failed: echo '\''$'\''|json -b 1|squote'

echo '$ echo '\''$'\''|json -b 2|squote'
echo '$'|json -b 2|squote 2>&1 ||
echo 'command failed: echo '\''$'\''|json -b 2|squote'

echo '$ echo '\''$'\''|json -b 3|squote'
echo '$'|json -b 3|squote 2>&1 ||
echo 'command failed: echo '\''$'\''|json -b 3|squote'

echo '$ echo '\''%'\''|json -b 1'
echo '%'|json -b 1 2>&1 ||
echo 'command failed: echo '\''%'\''|json -b 1'

echo '$ echo '\''%'\''|json -b 2'
echo '%'|json -b 2 2>&1 ||
echo 'command failed: echo '\''%'\''|json -b 2'

echo '$ echo '\''%'\''|json -b 3'
echo '%'|json -b 3 2>&1 ||
echo 'command failed: echo '\''%'\''|json -b 3'

echo '$ echo '\''&'\''|json -b 1'
echo '&'|json -b 1 2>&1 ||
echo 'command failed: echo '\''&'\''|json -b 1'

echo '$ echo '\''&'\''|json -b 2'
echo '&'|json -b 2 2>&1 ||
echo 'command failed: echo '\''&'\''|json -b 2'

echo '$ echo '\''&'\''|json -b 3'
echo '&'|json -b 3 2>&1 ||
echo 'command failed: echo '\''&'\''|json -b 3'

echo '$ echo -e '\''\x27'\''|json -b 1'
echo -e '\x27'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x27'\''|json -b 1'

echo '$ echo -e '\''\x27'\''|json -b 2'
echo -e '\x27'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x27'\''|json -b 2'

echo '$ echo -e '\''\x27'\''|json -b 3'
echo -e '\x27'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x27'\''|json -b 3'

echo '$ echo '\''('\''|json -b 1'
echo '('|json -b 1 2>&1 ||
echo 'command failed: echo '\''('\''|json -b 1'

echo '$ echo '\''('\''|json -b 2'
echo '('|json -b 2 2>&1 ||
echo 'command failed: echo '\''('\''|json -b 2'

echo '$ echo '\''('\''|json -b 3'
echo '('|json -b 3 2>&1 ||
echo 'command failed: echo '\''('\''|json -b 3'

echo '$ echo '\'')'\''|json -b 1'
echo ')'|json -b 1 2>&1 ||
echo 'command failed: echo '\'')'\''|json -b 1'

echo '$ echo '\'')'\''|json -b 2'
echo ')'|json -b 2 2>&1 ||
echo 'command failed: echo '\'')'\''|json -b 2'

echo '$ echo '\'')'\''|json -b 3'
echo ')'|json -b 3 2>&1 ||
echo 'command failed: echo '\'')'\''|json -b 3'

echo '$ echo '\''*'\''|json -b 1'
echo '*'|json -b 1 2>&1 ||
echo 'command failed: echo '\''*'\''|json -b 1'

echo '$ echo '\''*'\''|json -b 2'
echo '*'|json -b 2 2>&1 ||
echo 'command failed: echo '\''*'\''|json -b 2'

echo '$ echo '\''*'\''|json -b 3'
echo '*'|json -b 3 2>&1 ||
echo 'command failed: echo '\''*'\''|json -b 3'

echo '$ echo '\''+'\''|json -b 1'
echo '+'|json -b 1 2>&1 ||
echo 'command failed: echo '\''+'\''|json -b 1'

echo '$ echo '\''+'\''|json -b 2'
echo '+'|json -b 2 2>&1 ||
echo 'command failed: echo '\''+'\''|json -b 2'

echo '$ echo '\''+'\''|json -b 3'
echo '+'|json -b 3 2>&1 ||
echo 'command failed: echo '\''+'\''|json -b 3'

echo '$ echo '\'','\''|json -b 1'
echo ','|json -b 1 2>&1 ||
echo 'command failed: echo '\'','\''|json -b 1'

echo '$ echo '\'','\''|json -b 2'
echo ','|json -b 2 2>&1 ||
echo 'command failed: echo '\'','\''|json -b 2'

echo '$ echo '\'','\''|json -b 3'
echo ','|json -b 3 2>&1 ||
echo 'command failed: echo '\'','\''|json -b 3'

echo '$ echo '\''-'\''|json -b 1'
echo '-'|json -b 1 2>&1 ||
echo 'command failed: echo '\''-'\''|json -b 1'

echo '$ echo '\''-'\''|json -b 2'
echo '-'|json -b 2 2>&1 ||
echo 'command failed: echo '\''-'\''|json -b 2'

echo '$ echo '\''-'\''|json -b 3'
echo '-'|json -b 3 2>&1 ||
echo 'command failed: echo '\''-'\''|json -b 3'

echo '$ echo '\''.'\''|json -b 1'
echo '.'|json -b 1 2>&1 ||
echo 'command failed: echo '\''.'\''|json -b 1'

echo '$ echo '\''.'\''|json -b 2'
echo '.'|json -b 2 2>&1 ||
echo 'command failed: echo '\''.'\''|json -b 2'

echo '$ echo '\''.'\''|json -b 3'
echo '.'|json -b 3 2>&1 ||
echo 'command failed: echo '\''.'\''|json -b 3'

echo '$ echo '\''/'\''|json -b 1'
echo '/'|json -b 1 2>&1 ||
echo 'command failed: echo '\''/'\''|json -b 1'

echo '$ echo '\''/'\''|json -b 2'
echo '/'|json -b 2 2>&1 ||
echo 'command failed: echo '\''/'\''|json -b 2'

echo '$ echo '\''/'\''|json -b 3'
echo '/'|json -b 3 2>&1 ||
echo 'command failed: echo '\''/'\''|json -b 3'

echo '$ echo '\''0'\''|json -b 1'
echo '0'|json -b 1 2>&1 ||
echo 'command failed: echo '\''0'\''|json -b 1'

echo '$ echo '\''0'\''|json -b 2'
echo '0'|json -b 2 2>&1 ||
echo 'command failed: echo '\''0'\''|json -b 2'

echo '$ echo '\''0'\''|json -b 3'
echo '0'|json -b 3 2>&1 ||
echo 'command failed: echo '\''0'\''|json -b 3'

echo '$ echo '\''1'\''|json -b 1'
echo '1'|json -b 1 2>&1 ||
echo 'command failed: echo '\''1'\''|json -b 1'

echo '$ echo '\''1'\''|json -b 2'
echo '1'|json -b 2 2>&1 ||
echo 'command failed: echo '\''1'\''|json -b 2'

echo '$ echo '\''1'\''|json -b 3'
echo '1'|json -b 3 2>&1 ||
echo 'command failed: echo '\''1'\''|json -b 3'

echo '$ echo '\''2'\''|json -b 1'
echo '2'|json -b 1 2>&1 ||
echo 'command failed: echo '\''2'\''|json -b 1'

echo '$ echo '\''2'\''|json -b 2'
echo '2'|json -b 2 2>&1 ||
echo 'command failed: echo '\''2'\''|json -b 2'

echo '$ echo '\''2'\''|json -b 3'
echo '2'|json -b 3 2>&1 ||
echo 'command failed: echo '\''2'\''|json -b 3'

echo '$ echo '\''3'\''|json -b 1'
echo '3'|json -b 1 2>&1 ||
echo 'command failed: echo '\''3'\''|json -b 1'

echo '$ echo '\''3'\''|json -b 2'
echo '3'|json -b 2 2>&1 ||
echo 'command failed: echo '\''3'\''|json -b 2'

echo '$ echo '\''3'\''|json -b 3'
echo '3'|json -b 3 2>&1 ||
echo 'command failed: echo '\''3'\''|json -b 3'

echo '$ echo '\''4'\''|json -b 1'
echo '4'|json -b 1 2>&1 ||
echo 'command failed: echo '\''4'\''|json -b 1'

echo '$ echo '\''4'\''|json -b 2'
echo '4'|json -b 2 2>&1 ||
echo 'command failed: echo '\''4'\''|json -b 2'

echo '$ echo '\''4'\''|json -b 3'
echo '4'|json -b 3 2>&1 ||
echo 'command failed: echo '\''4'\''|json -b 3'

echo '$ echo '\''5'\''|json -b 1'
echo '5'|json -b 1 2>&1 ||
echo 'command failed: echo '\''5'\''|json -b 1'

echo '$ echo '\''5'\''|json -b 2'
echo '5'|json -b 2 2>&1 ||
echo 'command failed: echo '\''5'\''|json -b 2'

echo '$ echo '\''5'\''|json -b 3'
echo '5'|json -b 3 2>&1 ||
echo 'command failed: echo '\''5'\''|json -b 3'

echo '$ echo '\''6'\''|json -b 1'
echo '6'|json -b 1 2>&1 ||
echo 'command failed: echo '\''6'\''|json -b 1'

echo '$ echo '\''6'\''|json -b 2'
echo '6'|json -b 2 2>&1 ||
echo 'command failed: echo '\''6'\''|json -b 2'

echo '$ echo '\''6'\''|json -b 3'
echo '6'|json -b 3 2>&1 ||
echo 'command failed: echo '\''6'\''|json -b 3'

echo '$ echo '\''7'\''|json -b 1'
echo '7'|json -b 1 2>&1 ||
echo 'command failed: echo '\''7'\''|json -b 1'

echo '$ echo '\''7'\''|json -b 2'
echo '7'|json -b 2 2>&1 ||
echo 'command failed: echo '\''7'\''|json -b 2'

echo '$ echo '\''7'\''|json -b 3'
echo '7'|json -b 3 2>&1 ||
echo 'command failed: echo '\''7'\''|json -b 3'

echo '$ echo '\''8'\''|json -b 1'
echo '8'|json -b 1 2>&1 ||
echo 'command failed: echo '\''8'\''|json -b 1'

echo '$ echo '\''8'\''|json -b 2'
echo '8'|json -b 2 2>&1 ||
echo 'command failed: echo '\''8'\''|json -b 2'

echo '$ echo '\''8'\''|json -b 3'
echo '8'|json -b 3 2>&1 ||
echo 'command failed: echo '\''8'\''|json -b 3'

echo '$ echo '\''9'\''|json -b 1'
echo '9'|json -b 1 2>&1 ||
echo 'command failed: echo '\''9'\''|json -b 1'

echo '$ echo '\''9'\''|json -b 2'
echo '9'|json -b 2 2>&1 ||
echo 'command failed: echo '\''9'\''|json -b 2'

echo '$ echo '\''9'\''|json -b 3'
echo '9'|json -b 3 2>&1 ||
echo 'command failed: echo '\''9'\''|json -b 3'

echo '$ echo '\'':'\''|json -b 1'
echo ':'|json -b 1 2>&1 ||
echo 'command failed: echo '\'':'\''|json -b 1'

echo '$ echo '\'':'\''|json -b 2'
echo ':'|json -b 2 2>&1 ||
echo 'command failed: echo '\'':'\''|json -b 2'

echo '$ echo '\'':'\''|json -b 3'
echo ':'|json -b 3 2>&1 ||
echo 'command failed: echo '\'':'\''|json -b 3'

echo '$ echo '\'';'\''|json -b 1'
echo ';'|json -b 1 2>&1 ||
echo 'command failed: echo '\'';'\''|json -b 1'

echo '$ echo '\'';'\''|json -b 2'
echo ';'|json -b 2 2>&1 ||
echo 'command failed: echo '\'';'\''|json -b 2'

echo '$ echo '\'';'\''|json -b 3'
echo ';'|json -b 3 2>&1 ||
echo 'command failed: echo '\'';'\''|json -b 3'

echo '$ echo '\''<'\''|json -b 1'
echo '<'|json -b 1 2>&1 ||
echo 'command failed: echo '\''<'\''|json -b 1'

echo '$ echo '\''<'\''|json -b 2'
echo '<'|json -b 2 2>&1 ||
echo 'command failed: echo '\''<'\''|json -b 2'

echo '$ echo '\''<'\''|json -b 3'
echo '<'|json -b 3 2>&1 ||
echo 'command failed: echo '\''<'\''|json -b 3'

echo '$ echo '\''='\''|json -b 1'
echo '='|json -b 1 2>&1 ||
echo 'command failed: echo '\''='\''|json -b 1'

echo '$ echo '\''='\''|json -b 2'
echo '='|json -b 2 2>&1 ||
echo 'command failed: echo '\''='\''|json -b 2'

echo '$ echo '\''='\''|json -b 3'
echo '='|json -b 3 2>&1 ||
echo 'command failed: echo '\''='\''|json -b 3'

echo '$ echo '\''>'\''|json -b 1'
echo '>'|json -b 1 2>&1 ||
echo 'command failed: echo '\''>'\''|json -b 1'

echo '$ echo '\''>'\''|json -b 2'
echo '>'|json -b 2 2>&1 ||
echo 'command failed: echo '\''>'\''|json -b 2'

echo '$ echo '\''>'\''|json -b 3'
echo '>'|json -b 3 2>&1 ||
echo 'command failed: echo '\''>'\''|json -b 3'

echo '$ echo '\''?'\''|json -b 1'
echo '?'|json -b 1 2>&1 ||
echo 'command failed: echo '\''?'\''|json -b 1'

echo '$ echo '\''?'\''|json -b 2'
echo '?'|json -b 2 2>&1 ||
echo 'command failed: echo '\''?'\''|json -b 2'

echo '$ echo '\''?'\''|json -b 3'
echo '?'|json -b 3 2>&1 ||
echo 'command failed: echo '\''?'\''|json -b 3'

echo '$ echo '\''@'\''|json -b 1'
echo '@'|json -b 1 2>&1 ||
echo 'command failed: echo '\''@'\''|json -b 1'

echo '$ echo '\''@'\''|json -b 2'
echo '@'|json -b 2 2>&1 ||
echo 'command failed: echo '\''@'\''|json -b 2'

echo '$ echo '\''@'\''|json -b 3'
echo '@'|json -b 3 2>&1 ||
echo 'command failed: echo '\''@'\''|json -b 3'

echo '$ echo '\''A'\''|json -b 1'
echo 'A'|json -b 1 2>&1 ||
echo 'command failed: echo '\''A'\''|json -b 1'

echo '$ echo '\''A'\''|json -b 2'
echo 'A'|json -b 2 2>&1 ||
echo 'command failed: echo '\''A'\''|json -b 2'

echo '$ echo '\''A'\''|json -b 3'
echo 'A'|json -b 3 2>&1 ||
echo 'command failed: echo '\''A'\''|json -b 3'

echo '$ echo '\''B'\''|json -b 1'
echo 'B'|json -b 1 2>&1 ||
echo 'command failed: echo '\''B'\''|json -b 1'

echo '$ echo '\''B'\''|json -b 2'
echo 'B'|json -b 2 2>&1 ||
echo 'command failed: echo '\''B'\''|json -b 2'

echo '$ echo '\''B'\''|json -b 3'
echo 'B'|json -b 3 2>&1 ||
echo 'command failed: echo '\''B'\''|json -b 3'

echo '$ echo '\''C'\''|json -b 1'
echo 'C'|json -b 1 2>&1 ||
echo 'command failed: echo '\''C'\''|json -b 1'

echo '$ echo '\''C'\''|json -b 2'
echo 'C'|json -b 2 2>&1 ||
echo 'command failed: echo '\''C'\''|json -b 2'

echo '$ echo '\''C'\''|json -b 3'
echo 'C'|json -b 3 2>&1 ||
echo 'command failed: echo '\''C'\''|json -b 3'

echo '$ echo '\''D'\''|json -b 1'
echo 'D'|json -b 1 2>&1 ||
echo 'command failed: echo '\''D'\''|json -b 1'

echo '$ echo '\''D'\''|json -b 2'
echo 'D'|json -b 2 2>&1 ||
echo 'command failed: echo '\''D'\''|json -b 2'

echo '$ echo '\''D'\''|json -b 3'
echo 'D'|json -b 3 2>&1 ||
echo 'command failed: echo '\''D'\''|json -b 3'

echo '$ echo '\''E'\''|json -b 1'
echo 'E'|json -b 1 2>&1 ||
echo 'command failed: echo '\''E'\''|json -b 1'

echo '$ echo '\''E'\''|json -b 2'
echo 'E'|json -b 2 2>&1 ||
echo 'command failed: echo '\''E'\''|json -b 2'

echo '$ echo '\''E'\''|json -b 3'
echo 'E'|json -b 3 2>&1 ||
echo 'command failed: echo '\''E'\''|json -b 3'

echo '$ echo '\''F'\''|json -b 1'
echo 'F'|json -b 1 2>&1 ||
echo 'command failed: echo '\''F'\''|json -b 1'

echo '$ echo '\''F'\''|json -b 2'
echo 'F'|json -b 2 2>&1 ||
echo 'command failed: echo '\''F'\''|json -b 2'

echo '$ echo '\''F'\''|json -b 3'
echo 'F'|json -b 3 2>&1 ||
echo 'command failed: echo '\''F'\''|json -b 3'

echo '$ echo '\''G'\''|json -b 1'
echo 'G'|json -b 1 2>&1 ||
echo 'command failed: echo '\''G'\''|json -b 1'

echo '$ echo '\''G'\''|json -b 2'
echo 'G'|json -b 2 2>&1 ||
echo 'command failed: echo '\''G'\''|json -b 2'

echo '$ echo '\''G'\''|json -b 3'
echo 'G'|json -b 3 2>&1 ||
echo 'command failed: echo '\''G'\''|json -b 3'

echo '$ echo '\''H'\''|json -b 1'
echo 'H'|json -b 1 2>&1 ||
echo 'command failed: echo '\''H'\''|json -b 1'

echo '$ echo '\''H'\''|json -b 2'
echo 'H'|json -b 2 2>&1 ||
echo 'command failed: echo '\''H'\''|json -b 2'

echo '$ echo '\''H'\''|json -b 3'
echo 'H'|json -b 3 2>&1 ||
echo 'command failed: echo '\''H'\''|json -b 3'

echo '$ echo '\''I'\''|json -b 1'
echo 'I'|json -b 1 2>&1 ||
echo 'command failed: echo '\''I'\''|json -b 1'

echo '$ echo '\''I'\''|json -b 2'
echo 'I'|json -b 2 2>&1 ||
echo 'command failed: echo '\''I'\''|json -b 2'

echo '$ echo '\''I'\''|json -b 3'
echo 'I'|json -b 3 2>&1 ||
echo 'command failed: echo '\''I'\''|json -b 3'

echo '$ echo '\''J'\''|json -b 1'
echo 'J'|json -b 1 2>&1 ||
echo 'command failed: echo '\''J'\''|json -b 1'

echo '$ echo '\''J'\''|json -b 2'
echo 'J'|json -b 2 2>&1 ||
echo 'command failed: echo '\''J'\''|json -b 2'

echo '$ echo '\''J'\''|json -b 3'
echo 'J'|json -b 3 2>&1 ||
echo 'command failed: echo '\''J'\''|json -b 3'

echo '$ echo '\''K'\''|json -b 1'
echo 'K'|json -b 1 2>&1 ||
echo 'command failed: echo '\''K'\''|json -b 1'

echo '$ echo '\''K'\''|json -b 2'
echo 'K'|json -b 2 2>&1 ||
echo 'command failed: echo '\''K'\''|json -b 2'

echo '$ echo '\''K'\''|json -b 3'
echo 'K'|json -b 3 2>&1 ||
echo 'command failed: echo '\''K'\''|json -b 3'

echo '$ echo '\''L'\''|json -b 1'
echo 'L'|json -b 1 2>&1 ||
echo 'command failed: echo '\''L'\''|json -b 1'

echo '$ echo '\''L'\''|json -b 2'
echo 'L'|json -b 2 2>&1 ||
echo 'command failed: echo '\''L'\''|json -b 2'

echo '$ echo '\''L'\''|json -b 3'
echo 'L'|json -b 3 2>&1 ||
echo 'command failed: echo '\''L'\''|json -b 3'

echo '$ echo '\''M'\''|json -b 1'
echo 'M'|json -b 1 2>&1 ||
echo 'command failed: echo '\''M'\''|json -b 1'

echo '$ echo '\''M'\''|json -b 2'
echo 'M'|json -b 2 2>&1 ||
echo 'command failed: echo '\''M'\''|json -b 2'

echo '$ echo '\''M'\''|json -b 3'
echo 'M'|json -b 3 2>&1 ||
echo 'command failed: echo '\''M'\''|json -b 3'

echo '$ echo '\''N'\''|json -b 1'
echo 'N'|json -b 1 2>&1 ||
echo 'command failed: echo '\''N'\''|json -b 1'

echo '$ echo '\''N'\''|json -b 2'
echo 'N'|json -b 2 2>&1 ||
echo 'command failed: echo '\''N'\''|json -b 2'

echo '$ echo '\''N'\''|json -b 3'
echo 'N'|json -b 3 2>&1 ||
echo 'command failed: echo '\''N'\''|json -b 3'

echo '$ echo '\''O'\''|json -b 1'
echo 'O'|json -b 1 2>&1 ||
echo 'command failed: echo '\''O'\''|json -b 1'

echo '$ echo '\''O'\''|json -b 2'
echo 'O'|json -b 2 2>&1 ||
echo 'command failed: echo '\''O'\''|json -b 2'

echo '$ echo '\''O'\''|json -b 3'
echo 'O'|json -b 3 2>&1 ||
echo 'command failed: echo '\''O'\''|json -b 3'

echo '$ echo '\''P'\''|json -b 1'
echo 'P'|json -b 1 2>&1 ||
echo 'command failed: echo '\''P'\''|json -b 1'

echo '$ echo '\''P'\''|json -b 2'
echo 'P'|json -b 2 2>&1 ||
echo 'command failed: echo '\''P'\''|json -b 2'

echo '$ echo '\''P'\''|json -b 3'
echo 'P'|json -b 3 2>&1 ||
echo 'command failed: echo '\''P'\''|json -b 3'

echo '$ echo '\''Q'\''|json -b 1'
echo 'Q'|json -b 1 2>&1 ||
echo 'command failed: echo '\''Q'\''|json -b 1'

echo '$ echo '\''Q'\''|json -b 2'
echo 'Q'|json -b 2 2>&1 ||
echo 'command failed: echo '\''Q'\''|json -b 2'

echo '$ echo '\''Q'\''|json -b 3'
echo 'Q'|json -b 3 2>&1 ||
echo 'command failed: echo '\''Q'\''|json -b 3'

echo '$ echo '\''R'\''|json -b 1'
echo 'R'|json -b 1 2>&1 ||
echo 'command failed: echo '\''R'\''|json -b 1'

echo '$ echo '\''R'\''|json -b 2'
echo 'R'|json -b 2 2>&1 ||
echo 'command failed: echo '\''R'\''|json -b 2'

echo '$ echo '\''R'\''|json -b 3'
echo 'R'|json -b 3 2>&1 ||
echo 'command failed: echo '\''R'\''|json -b 3'

echo '$ echo '\''S'\''|json -b 1'
echo 'S'|json -b 1 2>&1 ||
echo 'command failed: echo '\''S'\''|json -b 1'

echo '$ echo '\''S'\''|json -b 2'
echo 'S'|json -b 2 2>&1 ||
echo 'command failed: echo '\''S'\''|json -b 2'

echo '$ echo '\''S'\''|json -b 3'
echo 'S'|json -b 3 2>&1 ||
echo 'command failed: echo '\''S'\''|json -b 3'

echo '$ echo '\''T'\''|json -b 1'
echo 'T'|json -b 1 2>&1 ||
echo 'command failed: echo '\''T'\''|json -b 1'

echo '$ echo '\''T'\''|json -b 2'
echo 'T'|json -b 2 2>&1 ||
echo 'command failed: echo '\''T'\''|json -b 2'

echo '$ echo '\''T'\''|json -b 3'
echo 'T'|json -b 3 2>&1 ||
echo 'command failed: echo '\''T'\''|json -b 3'

echo '$ echo '\''U'\''|json -b 1'
echo 'U'|json -b 1 2>&1 ||
echo 'command failed: echo '\''U'\''|json -b 1'

echo '$ echo '\''U'\''|json -b 2'
echo 'U'|json -b 2 2>&1 ||
echo 'command failed: echo '\''U'\''|json -b 2'

echo '$ echo '\''U'\''|json -b 3'
echo 'U'|json -b 3 2>&1 ||
echo 'command failed: echo '\''U'\''|json -b 3'

echo '$ echo '\''V'\''|json -b 1'
echo 'V'|json -b 1 2>&1 ||
echo 'command failed: echo '\''V'\''|json -b 1'

echo '$ echo '\''V'\''|json -b 2'
echo 'V'|json -b 2 2>&1 ||
echo 'command failed: echo '\''V'\''|json -b 2'

echo '$ echo '\''V'\''|json -b 3'
echo 'V'|json -b 3 2>&1 ||
echo 'command failed: echo '\''V'\''|json -b 3'

echo '$ echo '\''W'\''|json -b 1'
echo 'W'|json -b 1 2>&1 ||
echo 'command failed: echo '\''W'\''|json -b 1'

echo '$ echo '\''W'\''|json -b 2'
echo 'W'|json -b 2 2>&1 ||
echo 'command failed: echo '\''W'\''|json -b 2'

echo '$ echo '\''W'\''|json -b 3'
echo 'W'|json -b 3 2>&1 ||
echo 'command failed: echo '\''W'\''|json -b 3'

echo '$ echo '\''X'\''|json -b 1'
echo 'X'|json -b 1 2>&1 ||
echo 'command failed: echo '\''X'\''|json -b 1'

echo '$ echo '\''X'\''|json -b 2'
echo 'X'|json -b 2 2>&1 ||
echo 'command failed: echo '\''X'\''|json -b 2'

echo '$ echo '\''X'\''|json -b 3'
echo 'X'|json -b 3 2>&1 ||
echo 'command failed: echo '\''X'\''|json -b 3'

echo '$ echo '\''Y'\''|json -b 1'
echo 'Y'|json -b 1 2>&1 ||
echo 'command failed: echo '\''Y'\''|json -b 1'

echo '$ echo '\''Y'\''|json -b 2'
echo 'Y'|json -b 2 2>&1 ||
echo 'command failed: echo '\''Y'\''|json -b 2'

echo '$ echo '\''Y'\''|json -b 3'
echo 'Y'|json -b 3 2>&1 ||
echo 'command failed: echo '\''Y'\''|json -b 3'

echo '$ echo '\''Z'\''|json -b 1'
echo 'Z'|json -b 1 2>&1 ||
echo 'command failed: echo '\''Z'\''|json -b 1'

echo '$ echo '\''Z'\''|json -b 2'
echo 'Z'|json -b 2 2>&1 ||
echo 'command failed: echo '\''Z'\''|json -b 2'

echo '$ echo '\''Z'\''|json -b 3'
echo 'Z'|json -b 3 2>&1 ||
echo 'command failed: echo '\''Z'\''|json -b 3'

echo '$ echo '\''['\''|json -b 1'
echo '['|json -b 1 2>&1 ||
echo 'command failed: echo '\''['\''|json -b 1'

echo '$ echo '\''['\''|json -b 2'
echo '['|json -b 2 2>&1 ||
echo 'command failed: echo '\''['\''|json -b 2'

echo '$ echo '\''['\''|json -b 3'
echo '['|json -b 3 2>&1 ||
echo 'command failed: echo '\''['\''|json -b 3'

echo '$ echo '\''\'\''|json -b 1'
echo '\'|json -b 1 2>&1 ||
echo 'command failed: echo '\''\'\''|json -b 1'

echo '$ echo '\''\'\''|json -b 2'
echo '\'|json -b 2 2>&1 ||
echo 'command failed: echo '\''\'\''|json -b 2'

echo '$ echo '\''\'\''|json -b 3'
echo '\'|json -b 3 2>&1 ||
echo 'command failed: echo '\''\'\''|json -b 3'

echo '$ echo '\'']'\''|json -b 1'
echo ']'|json -b 1 2>&1 ||
echo 'command failed: echo '\'']'\''|json -b 1'

echo '$ echo '\'']'\''|json -b 2'
echo ']'|json -b 2 2>&1 ||
echo 'command failed: echo '\'']'\''|json -b 2'

echo '$ echo '\'']'\''|json -b 3'
echo ']'|json -b 3 2>&1 ||
echo 'command failed: echo '\'']'\''|json -b 3'

echo '$ echo '\''^'\''|json -b 1'
echo '^'|json -b 1 2>&1 ||
echo 'command failed: echo '\''^'\''|json -b 1'

echo '$ echo '\''^'\''|json -b 2'
echo '^'|json -b 2 2>&1 ||
echo 'command failed: echo '\''^'\''|json -b 2'

echo '$ echo '\''^'\''|json -b 3'
echo '^'|json -b 3 2>&1 ||
echo 'command failed: echo '\''^'\''|json -b 3'

echo '$ echo '\''_'\''|json -b 1'
echo '_'|json -b 1 2>&1 ||
echo 'command failed: echo '\''_'\''|json -b 1'

echo '$ echo '\''_'\''|json -b 2'
echo '_'|json -b 2 2>&1 ||
echo 'command failed: echo '\''_'\''|json -b 2'

echo '$ echo '\''_'\''|json -b 3'
echo '_'|json -b 3 2>&1 ||
echo 'command failed: echo '\''_'\''|json -b 3'

echo '$ echo '\''`'\''|json -b 1'
echo '`'|json -b 1 2>&1 ||
echo 'command failed: echo '\''`'\''|json -b 1'

echo '$ echo '\''`'\''|json -b 2'
echo '`'|json -b 2 2>&1 ||
echo 'command failed: echo '\''`'\''|json -b 2'

echo '$ echo '\''`'\''|json -b 3'
echo '`'|json -b 3 2>&1 ||
echo 'command failed: echo '\''`'\''|json -b 3'

echo '$ echo '\''a'\''|json -b 1'
echo 'a'|json -b 1 2>&1 ||
echo 'command failed: echo '\''a'\''|json -b 1'

echo '$ echo '\''a'\''|json -b 2'
echo 'a'|json -b 2 2>&1 ||
echo 'command failed: echo '\''a'\''|json -b 2'

echo '$ echo '\''a'\''|json -b 3'
echo 'a'|json -b 3 2>&1 ||
echo 'command failed: echo '\''a'\''|json -b 3'

echo '$ echo '\''b'\''|json -b 1'
echo 'b'|json -b 1 2>&1 ||
echo 'command failed: echo '\''b'\''|json -b 1'

echo '$ echo '\''b'\''|json -b 2'
echo 'b'|json -b 2 2>&1 ||
echo 'command failed: echo '\''b'\''|json -b 2'

echo '$ echo '\''b'\''|json -b 3'
echo 'b'|json -b 3 2>&1 ||
echo 'command failed: echo '\''b'\''|json -b 3'

echo '$ echo '\''c'\''|json -b 1'
echo 'c'|json -b 1 2>&1 ||
echo 'command failed: echo '\''c'\''|json -b 1'

echo '$ echo '\''c'\''|json -b 2'
echo 'c'|json -b 2 2>&1 ||
echo 'command failed: echo '\''c'\''|json -b 2'

echo '$ echo '\''c'\''|json -b 3'
echo 'c'|json -b 3 2>&1 ||
echo 'command failed: echo '\''c'\''|json -b 3'

echo '$ echo '\''d'\''|json -b 1'
echo 'd'|json -b 1 2>&1 ||
echo 'command failed: echo '\''d'\''|json -b 1'

echo '$ echo '\''d'\''|json -b 2'
echo 'd'|json -b 2 2>&1 ||
echo 'command failed: echo '\''d'\''|json -b 2'

echo '$ echo '\''d'\''|json -b 3'
echo 'd'|json -b 3 2>&1 ||
echo 'command failed: echo '\''d'\''|json -b 3'

echo '$ echo '\''e'\''|json -b 1'
echo 'e'|json -b 1 2>&1 ||
echo 'command failed: echo '\''e'\''|json -b 1'

echo '$ echo '\''e'\''|json -b 2'
echo 'e'|json -b 2 2>&1 ||
echo 'command failed: echo '\''e'\''|json -b 2'

echo '$ echo '\''e'\''|json -b 3'
echo 'e'|json -b 3 2>&1 ||
echo 'command failed: echo '\''e'\''|json -b 3'

echo '$ echo '\''f'\''|json -b 1'
echo 'f'|json -b 1 2>&1 ||
echo 'command failed: echo '\''f'\''|json -b 1'

echo '$ echo '\''f'\''|json -b 2'
echo 'f'|json -b 2 2>&1 ||
echo 'command failed: echo '\''f'\''|json -b 2'

echo '$ echo '\''f'\''|json -b 3'
echo 'f'|json -b 3 2>&1 ||
echo 'command failed: echo '\''f'\''|json -b 3'

echo '$ echo '\''g'\''|json -b 1'
echo 'g'|json -b 1 2>&1 ||
echo 'command failed: echo '\''g'\''|json -b 1'

echo '$ echo '\''g'\''|json -b 2'
echo 'g'|json -b 2 2>&1 ||
echo 'command failed: echo '\''g'\''|json -b 2'

echo '$ echo '\''g'\''|json -b 3'
echo 'g'|json -b 3 2>&1 ||
echo 'command failed: echo '\''g'\''|json -b 3'

echo '$ echo '\''h'\''|json -b 1'
echo 'h'|json -b 1 2>&1 ||
echo 'command failed: echo '\''h'\''|json -b 1'

echo '$ echo '\''h'\''|json -b 2'
echo 'h'|json -b 2 2>&1 ||
echo 'command failed: echo '\''h'\''|json -b 2'

echo '$ echo '\''h'\''|json -b 3'
echo 'h'|json -b 3 2>&1 ||
echo 'command failed: echo '\''h'\''|json -b 3'

echo '$ echo '\''i'\''|json -b 1'
echo 'i'|json -b 1 2>&1 ||
echo 'command failed: echo '\''i'\''|json -b 1'

echo '$ echo '\''i'\''|json -b 2'
echo 'i'|json -b 2 2>&1 ||
echo 'command failed: echo '\''i'\''|json -b 2'

echo '$ echo '\''i'\''|json -b 3'
echo 'i'|json -b 3 2>&1 ||
echo 'command failed: echo '\''i'\''|json -b 3'

echo '$ echo '\''j'\''|json -b 1'
echo 'j'|json -b 1 2>&1 ||
echo 'command failed: echo '\''j'\''|json -b 1'

echo '$ echo '\''j'\''|json -b 2'
echo 'j'|json -b 2 2>&1 ||
echo 'command failed: echo '\''j'\''|json -b 2'

echo '$ echo '\''j'\''|json -b 3'
echo 'j'|json -b 3 2>&1 ||
echo 'command failed: echo '\''j'\''|json -b 3'

echo '$ echo '\''k'\''|json -b 1'
echo 'k'|json -b 1 2>&1 ||
echo 'command failed: echo '\''k'\''|json -b 1'

echo '$ echo '\''k'\''|json -b 2'
echo 'k'|json -b 2 2>&1 ||
echo 'command failed: echo '\''k'\''|json -b 2'

echo '$ echo '\''k'\''|json -b 3'
echo 'k'|json -b 3 2>&1 ||
echo 'command failed: echo '\''k'\''|json -b 3'

echo '$ echo '\''l'\''|json -b 1'
echo 'l'|json -b 1 2>&1 ||
echo 'command failed: echo '\''l'\''|json -b 1'

echo '$ echo '\''l'\''|json -b 2'
echo 'l'|json -b 2 2>&1 ||
echo 'command failed: echo '\''l'\''|json -b 2'

echo '$ echo '\''l'\''|json -b 3'
echo 'l'|json -b 3 2>&1 ||
echo 'command failed: echo '\''l'\''|json -b 3'

echo '$ echo '\''m'\''|json -b 1'
echo 'm'|json -b 1 2>&1 ||
echo 'command failed: echo '\''m'\''|json -b 1'

echo '$ echo '\''m'\''|json -b 2'
echo 'm'|json -b 2 2>&1 ||
echo 'command failed: echo '\''m'\''|json -b 2'

echo '$ echo '\''m'\''|json -b 3'
echo 'm'|json -b 3 2>&1 ||
echo 'command failed: echo '\''m'\''|json -b 3'

echo '$ echo '\''n'\''|json -b 1'
echo 'n'|json -b 1 2>&1 ||
echo 'command failed: echo '\''n'\''|json -b 1'

echo '$ echo '\''n'\''|json -b 2'
echo 'n'|json -b 2 2>&1 ||
echo 'command failed: echo '\''n'\''|json -b 2'

echo '$ echo '\''n'\''|json -b 3'
echo 'n'|json -b 3 2>&1 ||
echo 'command failed: echo '\''n'\''|json -b 3'

echo '$ echo '\''o'\''|json -b 1'
echo 'o'|json -b 1 2>&1 ||
echo 'command failed: echo '\''o'\''|json -b 1'

echo '$ echo '\''o'\''|json -b 2'
echo 'o'|json -b 2 2>&1 ||
echo 'command failed: echo '\''o'\''|json -b 2'

echo '$ echo '\''o'\''|json -b 3'
echo 'o'|json -b 3 2>&1 ||
echo 'command failed: echo '\''o'\''|json -b 3'

echo '$ echo '\''p'\''|json -b 1'
echo 'p'|json -b 1 2>&1 ||
echo 'command failed: echo '\''p'\''|json -b 1'

echo '$ echo '\''p'\''|json -b 2'
echo 'p'|json -b 2 2>&1 ||
echo 'command failed: echo '\''p'\''|json -b 2'

echo '$ echo '\''p'\''|json -b 3'
echo 'p'|json -b 3 2>&1 ||
echo 'command failed: echo '\''p'\''|json -b 3'

echo '$ echo '\''q'\''|json -b 1'
echo 'q'|json -b 1 2>&1 ||
echo 'command failed: echo '\''q'\''|json -b 1'

echo '$ echo '\''q'\''|json -b 2'
echo 'q'|json -b 2 2>&1 ||
echo 'command failed: echo '\''q'\''|json -b 2'

echo '$ echo '\''q'\''|json -b 3'
echo 'q'|json -b 3 2>&1 ||
echo 'command failed: echo '\''q'\''|json -b 3'

echo '$ echo '\''r'\''|json -b 1'
echo 'r'|json -b 1 2>&1 ||
echo 'command failed: echo '\''r'\''|json -b 1'

echo '$ echo '\''r'\''|json -b 2'
echo 'r'|json -b 2 2>&1 ||
echo 'command failed: echo '\''r'\''|json -b 2'

echo '$ echo '\''r'\''|json -b 3'
echo 'r'|json -b 3 2>&1 ||
echo 'command failed: echo '\''r'\''|json -b 3'

echo '$ echo '\''s'\''|json -b 1'
echo 's'|json -b 1 2>&1 ||
echo 'command failed: echo '\''s'\''|json -b 1'

echo '$ echo '\''s'\''|json -b 2'
echo 's'|json -b 2 2>&1 ||
echo 'command failed: echo '\''s'\''|json -b 2'

echo '$ echo '\''s'\''|json -b 3'
echo 's'|json -b 3 2>&1 ||
echo 'command failed: echo '\''s'\''|json -b 3'

echo '$ echo '\''t'\''|json -b 1'
echo 't'|json -b 1 2>&1 ||
echo 'command failed: echo '\''t'\''|json -b 1'

echo '$ echo '\''t'\''|json -b 2'
echo 't'|json -b 2 2>&1 ||
echo 'command failed: echo '\''t'\''|json -b 2'

echo '$ echo '\''t'\''|json -b 3'
echo 't'|json -b 3 2>&1 ||
echo 'command failed: echo '\''t'\''|json -b 3'

echo '$ echo '\''u'\''|json -b 1'
echo 'u'|json -b 1 2>&1 ||
echo 'command failed: echo '\''u'\''|json -b 1'

echo '$ echo '\''u'\''|json -b 2'
echo 'u'|json -b 2 2>&1 ||
echo 'command failed: echo '\''u'\''|json -b 2'

echo '$ echo '\''u'\''|json -b 3'
echo 'u'|json -b 3 2>&1 ||
echo 'command failed: echo '\''u'\''|json -b 3'

echo '$ echo '\''v'\''|json -b 1'
echo 'v'|json -b 1 2>&1 ||
echo 'command failed: echo '\''v'\''|json -b 1'

echo '$ echo '\''v'\''|json -b 2'
echo 'v'|json -b 2 2>&1 ||
echo 'command failed: echo '\''v'\''|json -b 2'

echo '$ echo '\''v'\''|json -b 3'
echo 'v'|json -b 3 2>&1 ||
echo 'command failed: echo '\''v'\''|json -b 3'

echo '$ echo '\''w'\''|json -b 1'
echo 'w'|json -b 1 2>&1 ||
echo 'command failed: echo '\''w'\''|json -b 1'

echo '$ echo '\''w'\''|json -b 2'
echo 'w'|json -b 2 2>&1 ||
echo 'command failed: echo '\''w'\''|json -b 2'

echo '$ echo '\''w'\''|json -b 3'
echo 'w'|json -b 3 2>&1 ||
echo 'command failed: echo '\''w'\''|json -b 3'

echo '$ echo '\''x'\''|json -b 1'
echo 'x'|json -b 1 2>&1 ||
echo 'command failed: echo '\''x'\''|json -b 1'

echo '$ echo '\''x'\''|json -b 2'
echo 'x'|json -b 2 2>&1 ||
echo 'command failed: echo '\''x'\''|json -b 2'

echo '$ echo '\''x'\''|json -b 3'
echo 'x'|json -b 3 2>&1 ||
echo 'command failed: echo '\''x'\''|json -b 3'

echo '$ echo '\''y'\''|json -b 1'
echo 'y'|json -b 1 2>&1 ||
echo 'command failed: echo '\''y'\''|json -b 1'

echo '$ echo '\''y'\''|json -b 2'
echo 'y'|json -b 2 2>&1 ||
echo 'command failed: echo '\''y'\''|json -b 2'

echo '$ echo '\''y'\''|json -b 3'
echo 'y'|json -b 3 2>&1 ||
echo 'command failed: echo '\''y'\''|json -b 3'

echo '$ echo '\''z'\''|json -b 1'
echo 'z'|json -b 1 2>&1 ||
echo 'command failed: echo '\''z'\''|json -b 1'

echo '$ echo '\''z'\''|json -b 2'
echo 'z'|json -b 2 2>&1 ||
echo 'command failed: echo '\''z'\''|json -b 2'

echo '$ echo '\''z'\''|json -b 3'
echo 'z'|json -b 3 2>&1 ||
echo 'command failed: echo '\''z'\''|json -b 3'

echo '$ echo '\''{'\''|json -b 1'
echo '{'|json -b 1 2>&1 ||
echo 'command failed: echo '\''{'\''|json -b 1'

echo '$ echo '\''{'\''|json -b 2'
echo '{'|json -b 2 2>&1 ||
echo 'command failed: echo '\''{'\''|json -b 2'

echo '$ echo '\''{'\''|json -b 3'
echo '{'|json -b 3 2>&1 ||
echo 'command failed: echo '\''{'\''|json -b 3'

echo '$ echo '\''|'\''|json -b 1'
echo '|'|json -b 1 2>&1 ||
echo 'command failed: echo '\''|'\''|json -b 1'

echo '$ echo '\''|'\''|json -b 2'
echo '|'|json -b 2 2>&1 ||
echo 'command failed: echo '\''|'\''|json -b 2'

echo '$ echo '\''|'\''|json -b 3'
echo '|'|json -b 3 2>&1 ||
echo 'command failed: echo '\''|'\''|json -b 3'

echo '$ echo '\''}'\''|json -b 1'
echo '}'|json -b 1 2>&1 ||
echo 'command failed: echo '\''}'\''|json -b 1'

echo '$ echo '\''}'\''|json -b 2'
echo '}'|json -b 2 2>&1 ||
echo 'command failed: echo '\''}'\''|json -b 2'

echo '$ echo '\''}'\''|json -b 3'
echo '}'|json -b 3 2>&1 ||
echo 'command failed: echo '\''}'\''|json -b 3'

echo '$ echo '\''~'\''|json -b 1'
echo '~'|json -b 1 2>&1 ||
echo 'command failed: echo '\''~'\''|json -b 1'

echo '$ echo '\''~'\''|json -b 2'
echo '~'|json -b 2 2>&1 ||
echo 'command failed: echo '\''~'\''|json -b 2'

echo '$ echo '\''~'\''|json -b 3'
echo '~'|json -b 3 2>&1 ||
echo 'command failed: echo '\''~'\''|json -b 3'

echo '$ echo -e '\''\x7f'\''|json -b 1'
echo -e '\x7f'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''\x7f'\''|json -b 1'

echo '$ echo -e '\''\x7f'\''|json -b 2'
echo -e '\x7f'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''\x7f'\''|json -b 2'

echo '$ echo -e '\''\x7f'\''|json -b 3'
echo -e '\x7f'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''\x7f'\''|json -b 3'
)

