#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -w39 -G type-checker
#

w=39
c=""
q=""

if [[ "$1" =~ ^-w[1-9][0-9]*$ ]]; then
    w="${1:2}"
    shift
fi
if [ "$1" == "-c" ]; then
    c="c"
    shift
fi
if [ "$1" == "-q" ]; then
    q="q"
fi

p=0
f=0

for t in \
    basic \
    plain \
    plain2 \
    object \
    object2 \
    object3 \
    object4 \
    object5 \
    object6 \
    object7 \
    object8 \
    object9 \
    object10 \
    dict \
    dict2 \
    dict3 \
    dict4 \
    dict5 \
    dict6 \
    dict7 \
    dict8 \
    dict9 \
    dict10 \
    dict11 \
    dict12 \
    dict13 \
    dict14 \
    open-array \
    open-array2 \
    open-array3 \
    open-array4 \
    open-array5 \
    open-array6 \
    open-array7 \
    open-array8 \
    open-array9 \
    open-array10 \
    open-array11 \
    open-array12 \
    object-open-array \
    object-open-array2 \
    dict-open-array \
    dict-open-array2 \
    open-array-object \
    open-array-object2 \
    open-array-object3 \
    open-array-dict \
    open-array-dict2 \
    open-array-dict3 \
    open-array-open-array \
    open-array-open-array2 \
    open-array-open-array3 \
    open-array-open-array4 \
    closed-array \
    closed-array2 \
    closed-array3 \
    closed-array4 \
    closed-array5 \
    closed-array6 \
    closed-array7 \
    closed-array8 \
    closed-array9 \
    closed-array10 \
    closed-array11 \
    object-closed-array \
    object-closed-array2 \
    dict-closed-array \
    dict-closed-array2 \
    closed-array-object \
    closed-array-object2 \
    closed-array-object3 \
    closed-array-dict \
    closed-array-dict2 \
    closed-array-dict3 \
    closed-array-closed-array \
    closed-array-closed-array2 \
    closed-array-open-array \
    closed-array-open-array2 \
    closed-array-open-array3 \
    open-array-closed-array \
    open-array-closed-array2 \
    list \
    list2 \
    list3 \
    list4 \
    list5 \
    object-list \
    object-list2 \
    object-list3 \
    object-list4 \
    object-list5 \
    object-list6 \
    object-list7 \
    dict-list \
    dict-list2 \
    dict-list3 \
    dict-list4 \
    dict-list5 \
    dict-list6 \
    dict-list7 \
    open-array-list \
    open-array-list2 \
    open-array-list3 \
    open-array-list4 \
    open-array-list5 \
    open-array-list6 \
    open-array-list7 \
    open-array-list8 \
    open-array-list9 \
    open-array-list10 \
    open-array-list11 \
    closed-array-list \
    closed-array-list2 \
    closed-array-list3 \
    closed-array-list4 \
    closed-array-list5 \
    closed-array-list6 \
    closed-array-list7 \
    dict-expr \
    dict-expr2 \
    dict-expr3 \
    dict-expr4 \
    dict-expr5 \
    dict-expr6
do
    test -z "$q" &&
    printf >&2 "%-$((w + 6))s " "test: type-checker:$t"
    if ! type-checker/test-$t.sh &>/dev/null; then
        (( f ++ ))

        test -n "$q" &&
        echo >&2 -n "test: type-checker:$t "
        echo >&2 failed
    else
        (( p ++ ))

        test -z "$q" &&
        echo >&2 OK
    fi
done

if [ -z "$c" ]; then
    [ -z "$q" -o "$f" -gt 0 ] &&
    echo >&2
    echo "tests passed: $p"
    echo "tests failed: $f"
else
    echo "$p"
    echo "$f"
fi

exit $(( f != 0 ))

