#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C gen-def:basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L basic.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ set -o pipefail
$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }
$ json-litex -d '\''"`foo`"'\''
static const struct json_litex_expr_node_t __0[] = {
    match_str("foo")
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 1
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`foo`"
    },
    .attr.string = &__1
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__2
};
$ json-litex -d '\''"/foo/"'\''
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "foo"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 1
};
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/foo/"
    },
    .attr.string = &__4
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__5
};
$ json-litex -d '\''"'\''\'\'''\''foo'\''\'\'''\''"'\''
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "foo"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 1
};
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "'\''foo'\''"
    },
    .attr.string = &__4
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__5
};'
) -L basic.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }'
json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'$'};\n''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'; } 2>&1 ||
echo 'command failed: json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }'

echo '$ json-litex -d '\''"`foo`"'\'''
json-litex -d '"`foo`"' 2>&1 ||
echo 'command failed: json-litex -d '\''"`foo`"'\'''

echo '$ json-litex -d '\''"/foo/"'\'''
json-litex -d '"/foo/"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/foo/"'\'''

echo '$ json-litex -d '\''"'\''\'\'''\''foo'\''\'\'''\''"'\'''
json-litex -d '"'\''foo'\''"' 2>&1 ||
echo 'command failed: json-litex -d '\''"'\''\'\'''\''foo'\''\'\'''\''"'\'''
)

