#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def:node-closed-array-dict-any3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-closed-array-dict-any3.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_attr_t __6 = {
    .args = &__5
};
static const struct json_type_dict_node_arg_t __7[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__6,
    .node.dict = {
        .args = __7,
        .size = 1
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''r'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''a'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_node_t __13 = {
    .sym = '\''b'\'',
    .EQ = &__12
};
static const struct json_type_dict_trie_t __14 = {
    .root = &__13
};
static const struct json_type_dict_attr_t __15 = {
    .args = &__14
};
static const struct json_type_dict_node_arg_t __16[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__9
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__15,
    .node.dict = {
        .args = __16,
        .size = 1
    }
};
static const struct json_type_node_t* __18[] = {
    &__8,
    &__17,
    NULL
};
static const struct json_type_node_t __19 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __18,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__19
};'
) -L node-closed-array-dict-any3.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
)

