#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list8.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[]]'\'''
) -L open-array-list8.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[]]'\'''
)

