#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict-expr3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr3.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }
$ json '\''a ~a b'\'' '\''a'\''
{"a":0}
$ json '\''a ~a ~b'\'' '\''a'\''
{"a":0}
$ json '\''a ~a c'\'' '\''a'\''
{"a":0}
$ json '\''a ~a ~c'\'' '\''a'\''
{"a":0}
$ json '\''a b ~a'\'' '\''a'\''
{"a":0}
$ json '\''a b ~b'\'' '\''a'\''
{"a":0}
$ json '\''a b c'\'' '\''a'\''
{"a":0}
$ json '\''a b ~c'\'' '\''a'\''
{"a":0}
$ json '\''a ~b ~a'\'' '\''a'\''
{"a":0}
$ json '\''a ~b b'\'' '\''a'\''
{"a":0}
$ json '\''a ~b c'\'' '\''a'\''
{"a":0}
$ json '\''a ~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''a c ~a'\'' '\''a'\''
{"a":0}
$ json '\''a c b'\'' '\''a'\''
{"a":0}
$ json '\''a c ~b'\'' '\''a'\''
{"a":0}
$ json '\''a c ~c'\'' '\''a'\''
{"a":0}
$ json '\''a ~c ~a'\'' '\''a'\''
{"a":0}
$ json '\''a ~c b'\'' '\''a'\''
{"a":0}
$ json '\''a ~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''a ~c c'\'' '\''a'\''
{"a":0}
$ json '\''~a a b'\'' '\''a'\''
{"a":0}
$ json '\''~a a ~b'\'' '\''a'\''
{"a":0}
$ json '\''~a a c'\'' '\''a'\''
{"a":0}
$ json '\''~a a ~c'\'' '\''a'\''
{"a":0}
$ json '\''~a b a'\'' '\''a'\''
{"a":0}
$ json '\''~a b ~b'\'' '\''a'\''
{"a":0}
$ json '\''~a b c'\'' '\''a'\''
{"a":0}
$ json '\''~a b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b ~c'\'' '\''a'\''
$ json '\''~a ~b a'\'' '\''a'\''
{"a":0}
$ json '\''~a ~b b'\'' '\''a'\''
{"a":0}
$ json '\''~a ~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b c'\'' '\''a'\''
$ json '\''~a ~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''~a c a'\'' '\''a'\''
{"a":0}
$ json '\''~a c b'\'' '\''a'\''
{"a":0}
$ json '\''~a c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c ~b'\'' '\''a'\''
$ json '\''~a c ~c'\'' '\''a'\''
{"a":0}
$ json '\''~a ~c a'\'' '\''a'\''
{"a":0}
$ json '\''~a ~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c b'\'' '\''a'\''
$ json '\''~a ~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''~a ~c c'\'' '\''a'\''
{"a":0}
$ json '\''b a ~a'\'' '\''a'\''
{"a":0}
$ json '\''b a ~b'\'' '\''a'\''
{"a":0}
$ json '\''b a c'\'' '\''a'\''
{"a":0}
$ json '\''b a ~c'\'' '\''a'\''
{"a":0}
$ json '\''b ~a a'\'' '\''a'\''
{"a":0}
$ json '\''b ~a ~b'\'' '\''a'\''
{"a":0}
$ json '\''b ~a c'\'' '\''a'\''
{"a":0}
$ json '\''b ~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a ~c'\'' '\''a'\''
$ json '\''b ~b a'\'' '\''a'\''
{"a":0}
$ json '\''b ~b ~a'\'' '\''a'\''
{"a":0}
$ json '\''b ~b c'\'' '\''a'\''
{"a":0}
$ json '\''b ~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''b c a'\'' '\''a'\''
{"a":0}
$ json '\''b c ~a'\'' '\''a'\''
{"a":0}
$ json '\''b c ~b'\'' '\''a'\''
{"a":0}
$ json '\''b c ~c'\'' '\''a'\''
{"a":0}
$ json '\''b ~c a'\'' '\''a'\''
{"a":0}
$ json '\''b ~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c ~a'\'' '\''a'\''
$ json '\''b ~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''b ~c c'\'' '\''a'\''
{"a":0}
$ json '\''~b a ~a'\'' '\''a'\''
{"a":0}
$ json '\''~b a b'\'' '\''a'\''
{"a":0}
$ json '\''~b a c'\'' '\''a'\''
{"a":0}
$ json '\''~b a ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b ~a a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~a b'\'' '\''a'\''
{"a":0}
$ json '\''~b ~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a c'\'' '\''a'\''
$ json '\''~b ~a ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b b a'\'' '\''a'\''
{"a":0}
$ json '\''~b b ~a'\'' '\''a'\''
{"a":0}
$ json '\''~b b c'\'' '\''a'\''
{"a":0}
$ json '\''~b b ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b c a'\'' '\''a'\''
{"a":0}
$ json '\''~b c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c ~a'\'' '\''a'\''
$ json '\''~b c b'\'' '\''a'\''
{"a":0}
$ json '\''~b c ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c ~a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c b'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c c'\'' '\''a'\''
{"a":0}
$ json '\''c a ~a'\'' '\''a'\''
{"a":0}
$ json '\''c a b'\'' '\''a'\''
{"a":0}
$ json '\''c a ~b'\'' '\''a'\''
{"a":0}
$ json '\''c a ~c'\'' '\''a'\''
{"a":0}
$ json '\''c ~a a'\'' '\''a'\''
{"a":0}
$ json '\''c ~a b'\'' '\''a'\''
{"a":0}
$ json '\''c ~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a ~b'\'' '\''a'\''
$ json '\''c ~a ~c'\'' '\''a'\''
{"a":0}
$ json '\''c b a'\'' '\''a'\''
{"a":0}
$ json '\''c b ~a'\'' '\''a'\''
{"a":0}
$ json '\''c b ~b'\'' '\''a'\''
{"a":0}
$ json '\''c b ~c'\'' '\''a'\''
{"a":0}
$ json '\''c ~b a'\'' '\''a'\''
{"a":0}
$ json '\''c ~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b ~a'\'' '\''a'\''
$ json '\''c ~b b'\'' '\''a'\''
{"a":0}
$ json '\''c ~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''c ~c a'\'' '\''a'\''
{"a":0}
$ json '\''c ~c ~a'\'' '\''a'\''
{"a":0}
$ json '\''c ~c b'\'' '\''a'\''
{"a":0}
$ json '\''c ~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c a ~a'\'' '\''a'\''
{"a":0}
$ json '\''~c a b'\'' '\''a'\''
{"a":0}
$ json '\''~c a ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c a c'\'' '\''a'\''
{"a":0}
$ json '\''~c ~a a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a b'\'' '\''a'\''
$ json '\''~c ~a ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c ~a c'\'' '\''a'\''
{"a":0}
$ json '\''~c b a'\'' '\''a'\''
{"a":0}
$ json '\''~c b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b ~a'\'' '\''a'\''
$ json '\''~c b ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c b c'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b ~a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b b'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b c'\'' '\''a'\''
{"a":0}
$ json '\''~c c a'\'' '\''a'\''
{"a":0}
$ json '\''~c c ~a'\'' '\''a'\''
{"a":0}
$ json '\''~c c b'\'' '\''a'\''
{"a":0}
$ json '\''~c c ~b'\'' '\''a'\''
{"a":0}
$ json '\''a ~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~a|b'\'' '\''a'\''
$ json '\''a ~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~a|~b'\'' '\''a'\''
$ json '\''a ~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~a|c'\'' '\''a'\''
$ json '\''a ~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~a|~c'\'' '\''a'\''
$ json '\''a b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a b|~a'\'' '\''a'\''
$ json '\''a b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a b|~b'\'' '\''a'\''
$ json '\''a b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a b|c'\'' '\''a'\''
$ json '\''a b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a b|~c'\'' '\''a'\''
$ json '\''a ~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~b|~a'\'' '\''a'\''
$ json '\''a ~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~b|b'\'' '\''a'\''
$ json '\''a ~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~b|c'\'' '\''a'\''
$ json '\''a ~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~b|~c'\'' '\''a'\''
$ json '\''a c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a c|~a'\'' '\''a'\''
$ json '\''a c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a c|b'\'' '\''a'\''
$ json '\''a c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a c|~b'\'' '\''a'\''
$ json '\''a c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a c|~c'\'' '\''a'\''
$ json '\''a ~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~c|~a'\'' '\''a'\''
$ json '\''a ~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~c|b'\'' '\''a'\''
$ json '\''a ~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~c|~b'\'' '\''a'\''
$ json '\''a ~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a ~c|c'\'' '\''a'\''
$ json '\''~a a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a a|b'\'' '\''a'\''
$ json '\''~a a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a a|~b'\'' '\''a'\''
$ json '\''~a a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a a|c'\'' '\''a'\''
$ json '\''~a a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a a|~c'\'' '\''a'\''
$ json '\''~a b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b|a'\'' '\''a'\''
$ json '\''~a b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b|~b'\'' '\''a'\''
$ json '\''~a b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b|c'\'' '\''a'\''
$ json '\''~a b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b|~c'\'' '\''a'\''
$ json '\''~a ~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b|a'\'' '\''a'\''
$ json '\''~a ~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b|b'\'' '\''a'\''
$ json '\''~a ~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b|c'\'' '\''a'\''
$ json '\''~a ~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b|~c'\'' '\''a'\''
$ json '\''~a c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c|a'\'' '\''a'\''
$ json '\''~a c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c|b'\'' '\''a'\''
$ json '\''~a c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c|~b'\'' '\''a'\''
$ json '\''~a c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c|~c'\'' '\''a'\''
$ json '\''~a ~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c|a'\'' '\''a'\''
$ json '\''~a ~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c|b'\'' '\''a'\''
$ json '\''~a ~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c|~b'\'' '\''a'\''
$ json '\''~a ~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c|c'\'' '\''a'\''
$ json '\''b a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b a|~a'\'' '\''a'\''
$ json '\''b a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b a|~b'\'' '\''a'\''
$ json '\''b a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b a|c'\'' '\''a'\''
$ json '\''b a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b a|~c'\'' '\''a'\''
$ json '\''b ~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a|a'\'' '\''a'\''
$ json '\''b ~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a|~b'\'' '\''a'\''
$ json '\''b ~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a|c'\'' '\''a'\''
$ json '\''b ~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a|~c'\'' '\''a'\''
$ json '\''b ~b|a'\'' '\''a'\''
{"a":0}
$ json '\''b ~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~b|~a'\'' '\''a'\''
$ json '\''b ~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~b|c'\'' '\''a'\''
$ json '\''b ~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~b|~c'\'' '\''a'\''
$ json '\''b c|a'\'' '\''a'\''
{"a":0}
$ json '\''b c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b c|~a'\'' '\''a'\''
$ json '\''b c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b c|~b'\'' '\''a'\''
$ json '\''b c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b c|~c'\'' '\''a'\''
$ json '\''b ~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c|a'\'' '\''a'\''
$ json '\''b ~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c|~a'\'' '\''a'\''
$ json '\''b ~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c|~b'\'' '\''a'\''
$ json '\''b ~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c|c'\'' '\''a'\''
$ json '\''~b a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b a|~a'\'' '\''a'\''
$ json '\''~b a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b a|b'\'' '\''a'\''
$ json '\''~b a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b a|c'\'' '\''a'\''
$ json '\''~b a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b a|~c'\'' '\''a'\''
$ json '\''~b ~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a|a'\'' '\''a'\''
$ json '\''~b ~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a|b'\'' '\''a'\''
$ json '\''~b ~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a|c'\'' '\''a'\''
$ json '\''~b ~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a|~c'\'' '\''a'\''
$ json '\''~b b|a'\'' '\''a'\''
{"a":0}
$ json '\''~b b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b b|~a'\'' '\''a'\''
$ json '\''~b b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b b|c'\'' '\''a'\''
$ json '\''~b b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b b|~c'\'' '\''a'\''
$ json '\''~b c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c|a'\'' '\''a'\''
$ json '\''~b c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c|~a'\'' '\''a'\''
$ json '\''~b c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c|b'\'' '\''a'\''
$ json '\''~b c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c|~c'\'' '\''a'\''
$ json '\''~b ~c|a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~c|~a'\'' '\''a'\''
$ json '\''~b ~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~c|b'\'' '\''a'\''
$ json '\''~b ~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~c|c'\'' '\''a'\''
$ json '\''c a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c a|~a'\'' '\''a'\''
$ json '\''c a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c a|b'\'' '\''a'\''
$ json '\''c a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c a|~b'\'' '\''a'\''
$ json '\''c a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c a|~c'\'' '\''a'\''
$ json '\''c ~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a|a'\'' '\''a'\''
$ json '\''c ~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a|b'\'' '\''a'\''
$ json '\''c ~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a|~b'\'' '\''a'\''
$ json '\''c ~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a|~c'\'' '\''a'\''
$ json '\''c b|a'\'' '\''a'\''
{"a":0}
$ json '\''c b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c b|~a'\'' '\''a'\''
$ json '\''c b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c b|~b'\'' '\''a'\''
$ json '\''c b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c b|~c'\'' '\''a'\''
$ json '\''c ~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b|a'\'' '\''a'\''
$ json '\''c ~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b|~a'\'' '\''a'\''
$ json '\''c ~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b|b'\'' '\''a'\''
$ json '\''c ~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b|~c'\'' '\''a'\''
$ json '\''c ~c|a'\'' '\''a'\''
{"a":0}
$ json '\''c ~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~c|~a'\'' '\''a'\''
$ json '\''c ~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~c|b'\'' '\''a'\''
$ json '\''c ~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~c|~b'\'' '\''a'\''
$ json '\''~c a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c a|~a'\'' '\''a'\''
$ json '\''~c a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c a|b'\'' '\''a'\''
$ json '\''~c a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c a|~b'\'' '\''a'\''
$ json '\''~c a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c a|c'\'' '\''a'\''
$ json '\''~c ~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a|a'\'' '\''a'\''
$ json '\''~c ~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a|b'\'' '\''a'\''
$ json '\''~c ~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a|~b'\'' '\''a'\''
$ json '\''~c ~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a|c'\'' '\''a'\''
$ json '\''~c b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b|a'\'' '\''a'\''
$ json '\''~c b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b|~a'\'' '\''a'\''
$ json '\''~c b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b|~b'\'' '\''a'\''
$ json '\''~c b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b|c'\'' '\''a'\''
$ json '\''~c ~b|a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~b|~a'\'' '\''a'\''
$ json '\''~c ~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~b|b'\'' '\''a'\''
$ json '\''~c ~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~b|c'\'' '\''a'\''
$ json '\''~c c|a'\'' '\''a'\''
{"a":0}
$ json '\''~c c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c c|~a'\'' '\''a'\''
$ json '\''~c c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c c|b'\'' '\''a'\''
$ json '\''~c c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c c|~b'\'' '\''a'\''
$ json '\''a ~a||b'\'' '\''a'\''
{"a":0}
$ json '\''a ~a||~b'\'' '\''a'\''
{"a":0}
$ json '\''a ~a||c'\'' '\''a'\''
{"a":0}
$ json '\''a ~a||~c'\'' '\''a'\''
{"a":0}
$ json '\''a b||~a'\'' '\''a'\''
{"a":0}
$ json '\''a b||~b'\'' '\''a'\''
{"a":0}
$ json '\''a b||c'\'' '\''a'\''
{"a":0}
$ json '\''a b||~c'\'' '\''a'\''
{"a":0}
$ json '\''a ~b||~a'\'' '\''a'\''
{"a":0}
$ json '\''a ~b||b'\'' '\''a'\''
{"a":0}
$ json '\''a ~b||c'\'' '\''a'\''
{"a":0}
$ json '\''a ~b||~c'\'' '\''a'\''
{"a":0}
$ json '\''a c||~a'\'' '\''a'\''
{"a":0}
$ json '\''a c||b'\'' '\''a'\''
{"a":0}
$ json '\''a c||~b'\'' '\''a'\''
{"a":0}
$ json '\''a c||~c'\'' '\''a'\''
{"a":0}
$ json '\''a ~c||~a'\'' '\''a'\''
{"a":0}
$ json '\''a ~c||b'\'' '\''a'\''
{"a":0}
$ json '\''a ~c||~b'\'' '\''a'\''
{"a":0}
$ json '\''a ~c||c'\'' '\''a'\''
{"a":0}
$ json '\''~a a||b'\'' '\''a'\''
{"a":0}
$ json '\''~a a||~b'\'' '\''a'\''
{"a":0}
$ json '\''~a a||c'\'' '\''a'\''
{"a":0}
$ json '\''~a a||~c'\'' '\''a'\''
{"a":0}
$ json '\''~a b||a'\'' '\''a'\''
{"a":0}
$ json '\''~a b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b||~b'\'' '\''a'\''
$ json '\''~a b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b||c'\'' '\''a'\''
$ json '\''~a b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a b||~c'\'' '\''a'\''
$ json '\''~a ~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~a ~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b||b'\'' '\''a'\''
$ json '\''~a ~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b||c'\'' '\''a'\''
$ json '\''~a ~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~b||~c'\'' '\''a'\''
$ json '\''~a c||a'\'' '\''a'\''
{"a":0}
$ json '\''~a c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c||b'\'' '\''a'\''
$ json '\''~a c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c||~b'\'' '\''a'\''
$ json '\''~a c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a c||~c'\'' '\''a'\''
$ json '\''~a ~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~a ~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c||b'\'' '\''a'\''
$ json '\''~a ~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c||~b'\'' '\''a'\''
$ json '\''~a ~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a ~c||c'\'' '\''a'\''
$ json '\''b a||~a'\'' '\''a'\''
{"a":0}
$ json '\''b a||~b'\'' '\''a'\''
{"a":0}
$ json '\''b a||c'\'' '\''a'\''
{"a":0}
$ json '\''b a||~c'\'' '\''a'\''
{"a":0}
$ json '\''b ~a||a'\'' '\''a'\''
{"a":0}
$ json '\''b ~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a||~b'\'' '\''a'\''
$ json '\''b ~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a||c'\'' '\''a'\''
$ json '\''b ~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~a||~c'\'' '\''a'\''
$ json '\''b ~b||a'\'' '\''a'\''
{"a":0}
$ json '\''b ~b||~a'\'' '\''a'\''
{"a":0}
$ json '\''b ~b||c'\'' '\''a'\''
{"a":0}
$ json '\''b ~b||~c'\'' '\''a'\''
{"a":0}
$ json '\''b c||a'\'' '\''a'\''
{"a":0}
$ json '\''b c||~a'\'' '\''a'\''
{"a":0}
$ json '\''b c||~b'\'' '\''a'\''
{"a":0}
$ json '\''b c||~c'\'' '\''a'\''
{"a":0}
$ json '\''b ~c||a'\'' '\''a'\''
{"a":0}
$ json '\''b ~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c||~a'\'' '\''a'\''
$ json '\''b ~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c||~b'\'' '\''a'\''
$ json '\''b ~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b ~c||c'\'' '\''a'\''
$ json '\''~b a||~a'\'' '\''a'\''
{"a":0}
$ json '\''~b a||b'\'' '\''a'\''
{"a":0}
$ json '\''~b a||c'\'' '\''a'\''
{"a":0}
$ json '\''~b a||~c'\'' '\''a'\''
{"a":0}
$ json '\''~b ~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a||b'\'' '\''a'\''
$ json '\''~b ~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a||c'\'' '\''a'\''
$ json '\''~b ~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b ~a||~c'\'' '\''a'\''
$ json '\''~b b||a'\'' '\''a'\''
{"a":0}
$ json '\''~b b||~a'\'' '\''a'\''
{"a":0}
$ json '\''~b b||c'\'' '\''a'\''
{"a":0}
$ json '\''~b b||~c'\'' '\''a'\''
{"a":0}
$ json '\''~b c||a'\'' '\''a'\''
{"a":0}
$ json '\''~b c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c||~a'\'' '\''a'\''
$ json '\''~b c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c||b'\'' '\''a'\''
$ json '\''~b c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b c||~c'\'' '\''a'\''
$ json '\''~b ~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c||~a'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c||b'\'' '\''a'\''
{"a":0}
$ json '\''~b ~c||c'\'' '\''a'\''
{"a":0}
$ json '\''c a||~a'\'' '\''a'\''
{"a":0}
$ json '\''c a||b'\'' '\''a'\''
{"a":0}
$ json '\''c a||~b'\'' '\''a'\''
{"a":0}
$ json '\''c a||~c'\'' '\''a'\''
{"a":0}
$ json '\''c ~a||a'\'' '\''a'\''
{"a":0}
$ json '\''c ~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a||b'\'' '\''a'\''
$ json '\''c ~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a||~b'\'' '\''a'\''
$ json '\''c ~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~a||~c'\'' '\''a'\''
$ json '\''c b||a'\'' '\''a'\''
{"a":0}
$ json '\''c b||~a'\'' '\''a'\''
{"a":0}
$ json '\''c b||~b'\'' '\''a'\''
{"a":0}
$ json '\''c b||~c'\'' '\''a'\''
{"a":0}
$ json '\''c ~b||a'\'' '\''a'\''
{"a":0}
$ json '\''c ~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b||~a'\'' '\''a'\''
$ json '\''c ~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b||b'\'' '\''a'\''
$ json '\''c ~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c ~b||~c'\'' '\''a'\''
$ json '\''c ~c||a'\'' '\''a'\''
{"a":0}
$ json '\''c ~c||~a'\'' '\''a'\''
{"a":0}
$ json '\''c ~c||b'\'' '\''a'\''
{"a":0}
$ json '\''c ~c||~b'\'' '\''a'\''
{"a":0}
$ json '\''~c a||~a'\'' '\''a'\''
{"a":0}
$ json '\''~c a||b'\'' '\''a'\''
{"a":0}
$ json '\''~c a||~b'\'' '\''a'\''
{"a":0}
$ json '\''~c a||c'\'' '\''a'\''
{"a":0}
$ json '\''~c ~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a||b'\'' '\''a'\''
$ json '\''~c ~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a||~b'\'' '\''a'\''
$ json '\''~c ~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c ~a||c'\'' '\''a'\''
$ json '\''~c b||a'\'' '\''a'\''
{"a":0}
$ json '\''~c b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b||~a'\'' '\''a'\''
$ json '\''~c b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b||~b'\'' '\''a'\''
$ json '\''~c b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c b||c'\'' '\''a'\''
$ json '\''~c ~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b||~a'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b||b'\'' '\''a'\''
{"a":0}
$ json '\''~c ~b||c'\'' '\''a'\''
{"a":0}
$ json '\''~c c||a'\'' '\''a'\''
{"a":0}
$ json '\''~c c||~a'\'' '\''a'\''
{"a":0}
$ json '\''~c c||b'\'' '\''a'\''
{"a":0}
$ json '\''~c c||~b'\'' '\''a'\''
{"a":0}
$ json '\''a|~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a b'\'' '\''a'\''
$ json '\''a|~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a ~b'\'' '\''a'\''
$ json '\''a|~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a c'\'' '\''a'\''
$ json '\''a|~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a ~c'\'' '\''a'\''
$ json '\''a|b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b ~a'\'' '\''a'\''
$ json '\''a|b ~b'\'' '\''a'\''
{"a":0}
$ json '\''a|b c'\'' '\''a'\''
{"a":0}
$ json '\''a|b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b ~c'\'' '\''a'\''
$ json '\''a|~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b ~a'\'' '\''a'\''
$ json '\''a|~b b'\'' '\''a'\''
{"a":0}
$ json '\''a|~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b c'\'' '\''a'\''
$ json '\''a|~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''a|c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c ~a'\'' '\''a'\''
$ json '\''a|c b'\'' '\''a'\''
{"a":0}
$ json '\''a|c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c ~b'\'' '\''a'\''
$ json '\''a|c ~c'\'' '\''a'\''
{"a":0}
$ json '\''a|~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c ~a'\'' '\''a'\''
$ json '\''a|~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c b'\'' '\''a'\''
$ json '\''a|~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''a|~c c'\'' '\''a'\''
{"a":0}
$ json '\''~a|a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a b'\'' '\''a'\''
$ json '\''~a|a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a ~b'\'' '\''a'\''
$ json '\''~a|a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a c'\'' '\''a'\''
$ json '\''~a|a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a ~c'\'' '\''a'\''
$ json '\''~a|b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b a'\'' '\''a'\''
$ json '\''~a|b ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b ~b'\'' '\''a'\''
$ json '\''~a|b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b c'\'' '\''a'\''
$ json '\''~a|b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b ~c'\'' '\''a'\''
$ json '\''~a|~b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b a'\'' '\''a'\''
$ json '\''~a|~b b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b b'\'' '\''a'\''
$ json '\''~a|~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b c'\'' '\''a'\''
$ json '\''~a|~b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b ~c'\'' '\''a'\''
$ json '\''~a|c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c a'\'' '\''a'\''
$ json '\''~a|c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c b'\'' '\''a'\''
$ json '\''~a|c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c ~b'\'' '\''a'\''
$ json '\''~a|c ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c ~c'\'' '\''a'\''
$ json '\''~a|~c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c a'\'' '\''a'\''
$ json '\''~a|~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c b'\'' '\''a'\''
$ json '\''~a|~c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c ~b'\'' '\''a'\''
$ json '\''~a|~c c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c c'\'' '\''a'\''
$ json '\''b|a ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a ~a'\'' '\''a'\''
$ json '\''b|a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a ~b'\'' '\''a'\''
$ json '\''b|a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a c'\'' '\''a'\''
$ json '\''b|a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a ~c'\'' '\''a'\''
$ json '\''b|~a a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a a'\'' '\''a'\''
$ json '\''b|~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a ~b'\'' '\''a'\''
$ json '\''b|~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a c'\'' '\''a'\''
$ json '\''b|~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a ~c'\'' '\''a'\''
$ json '\''b|~b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b a'\'' '\''a'\''
$ json '\''b|~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b ~a'\'' '\''a'\''
$ json '\''b|~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b c'\'' '\''a'\''
$ json '\''b|~b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b ~c'\'' '\''a'\''
$ json '\''b|c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c a'\'' '\''a'\''
$ json '\''b|c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c ~a'\'' '\''a'\''
$ json '\''b|c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c ~b'\'' '\''a'\''
$ json '\''b|c ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c ~c'\'' '\''a'\''
$ json '\''b|~c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c a'\'' '\''a'\''
$ json '\''b|~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c ~a'\'' '\''a'\''
$ json '\''b|~c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c ~b'\'' '\''a'\''
$ json '\''b|~c c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c c'\'' '\''a'\''
$ json '\''~b|a ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a ~a'\'' '\''a'\''
$ json '\''~b|a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a b'\'' '\''a'\''
$ json '\''~b|a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a c'\'' '\''a'\''
$ json '\''~b|a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a ~c'\'' '\''a'\''
$ json '\''~b|~a a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a a'\'' '\''a'\''
$ json '\''~b|~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a b'\'' '\''a'\''
$ json '\''~b|~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a c'\'' '\''a'\''
$ json '\''~b|~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a ~c'\'' '\''a'\''
$ json '\''~b|b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b a'\'' '\''a'\''
$ json '\''~b|b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b ~a'\'' '\''a'\''
$ json '\''~b|b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b c'\'' '\''a'\''
$ json '\''~b|b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b ~c'\'' '\''a'\''
$ json '\''~b|c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c a'\'' '\''a'\''
$ json '\''~b|c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c ~a'\'' '\''a'\''
$ json '\''~b|c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c b'\'' '\''a'\''
$ json '\''~b|c ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c ~c'\'' '\''a'\''
$ json '\''~b|~c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c a'\'' '\''a'\''
$ json '\''~b|~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c ~a'\'' '\''a'\''
$ json '\''~b|~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c b'\'' '\''a'\''
$ json '\''~b|~c c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c c'\'' '\''a'\''
$ json '\''c|a ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a ~a'\'' '\''a'\''
$ json '\''c|a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a b'\'' '\''a'\''
$ json '\''c|a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a ~b'\'' '\''a'\''
$ json '\''c|a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a ~c'\'' '\''a'\''
$ json '\''c|~a a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a a'\'' '\''a'\''
$ json '\''c|~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a b'\'' '\''a'\''
$ json '\''c|~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a ~b'\'' '\''a'\''
$ json '\''c|~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a ~c'\'' '\''a'\''
$ json '\''c|b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b a'\'' '\''a'\''
$ json '\''c|b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b ~a'\'' '\''a'\''
$ json '\''c|b ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b ~b'\'' '\''a'\''
$ json '\''c|b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b ~c'\'' '\''a'\''
$ json '\''c|~b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b a'\'' '\''a'\''
$ json '\''c|~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b ~a'\'' '\''a'\''
$ json '\''c|~b b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b b'\'' '\''a'\''
$ json '\''c|~b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b ~c'\'' '\''a'\''
$ json '\''c|~c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c a'\'' '\''a'\''
$ json '\''c|~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c ~a'\'' '\''a'\''
$ json '\''c|~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c b'\'' '\''a'\''
$ json '\''c|~c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c ~b'\'' '\''a'\''
$ json '\''~c|a ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a ~a'\'' '\''a'\''
$ json '\''~c|a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a b'\'' '\''a'\''
$ json '\''~c|a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a ~b'\'' '\''a'\''
$ json '\''~c|a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a c'\'' '\''a'\''
$ json '\''~c|~a a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a a'\'' '\''a'\''
$ json '\''~c|~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a b'\'' '\''a'\''
$ json '\''~c|~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a ~b'\'' '\''a'\''
$ json '\''~c|~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a c'\'' '\''a'\''
$ json '\''~c|b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b a'\'' '\''a'\''
$ json '\''~c|b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b ~a'\'' '\''a'\''
$ json '\''~c|b ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b ~b'\'' '\''a'\''
$ json '\''~c|b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b c'\'' '\''a'\''
$ json '\''~c|~b a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b a'\'' '\''a'\''
$ json '\''~c|~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b ~a'\'' '\''a'\''
$ json '\''~c|~b b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b b'\'' '\''a'\''
$ json '\''~c|~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b c'\'' '\''a'\''
$ json '\''~c|c a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c a'\'' '\''a'\''
$ json '\''~c|c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c ~a'\'' '\''a'\''
$ json '\''~c|c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c b'\'' '\''a'\''
$ json '\''~c|c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c ~b'\'' '\''a'\''
$ json '\''a|~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a|b'\'' '\''a'\''
$ json '\''a|~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a|~b'\'' '\''a'\''
$ json '\''a|~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a|c'\'' '\''a'\''
$ json '\''a|~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a|~c'\'' '\''a'\''
$ json '\''a|b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b|~a'\'' '\''a'\''
$ json '\''a|b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b|~b'\'' '\''a'\''
$ json '\''a|b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b|c'\'' '\''a'\''
$ json '\''a|b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b|~c'\'' '\''a'\''
$ json '\''a|~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b|~a'\'' '\''a'\''
$ json '\''a|~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b|b'\'' '\''a'\''
$ json '\''a|~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b|c'\'' '\''a'\''
$ json '\''a|~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b|~c'\'' '\''a'\''
$ json '\''a|c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c|~a'\'' '\''a'\''
$ json '\''a|c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c|b'\'' '\''a'\''
$ json '\''a|c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c|~b'\'' '\''a'\''
$ json '\''a|c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c|~c'\'' '\''a'\''
$ json '\''a|~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c|~a'\'' '\''a'\''
$ json '\''a|~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c|b'\'' '\''a'\''
$ json '\''a|~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c|~b'\'' '\''a'\''
$ json '\''a|~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c|c'\'' '\''a'\''
$ json '\''~a|a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a|b'\'' '\''a'\''
$ json '\''~a|a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a|~b'\'' '\''a'\''
$ json '\''~a|a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a|c'\'' '\''a'\''
$ json '\''~a|a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a|~c'\'' '\''a'\''
$ json '\''~a|b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b|a'\'' '\''a'\''
$ json '\''~a|b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b|~b'\'' '\''a'\''
$ json '\''~a|b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b|c'\'' '\''a'\''
$ json '\''~a|b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b|~c'\'' '\''a'\''
$ json '\''~a|~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b|a'\'' '\''a'\''
$ json '\''~a|~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b|b'\'' '\''a'\''
$ json '\''~a|~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b|c'\'' '\''a'\''
$ json '\''~a|~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b|~c'\'' '\''a'\''
$ json '\''~a|c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c|a'\'' '\''a'\''
$ json '\''~a|c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c|b'\'' '\''a'\''
$ json '\''~a|c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c|~b'\'' '\''a'\''
$ json '\''~a|c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c|~c'\'' '\''a'\''
$ json '\''~a|~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c|a'\'' '\''a'\''
$ json '\''~a|~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c|b'\'' '\''a'\''
$ json '\''~a|~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c|~b'\'' '\''a'\''
$ json '\''~a|~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c|c'\'' '\''a'\''
$ json '\''b|a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a|~a'\'' '\''a'\''
$ json '\''b|a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a|~b'\'' '\''a'\''
$ json '\''b|a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a|c'\'' '\''a'\''
$ json '\''b|a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a|~c'\'' '\''a'\''
$ json '\''b|~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a|a'\'' '\''a'\''
$ json '\''b|~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a|~b'\'' '\''a'\''
$ json '\''b|~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a|c'\'' '\''a'\''
$ json '\''b|~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a|~c'\'' '\''a'\''
$ json '\''b|~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b|a'\'' '\''a'\''
$ json '\''b|~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b|~a'\'' '\''a'\''
$ json '\''b|~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b|c'\'' '\''a'\''
$ json '\''b|~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b|~c'\'' '\''a'\''
$ json '\''b|c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c|a'\'' '\''a'\''
$ json '\''b|c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c|~a'\'' '\''a'\''
$ json '\''b|c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c|~b'\'' '\''a'\''
$ json '\''b|c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c|~c'\'' '\''a'\''
$ json '\''b|~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c|a'\'' '\''a'\''
$ json '\''b|~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c|~a'\'' '\''a'\''
$ json '\''b|~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c|~b'\'' '\''a'\''
$ json '\''b|~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c|c'\'' '\''a'\''
$ json '\''~b|a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a|~a'\'' '\''a'\''
$ json '\''~b|a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a|b'\'' '\''a'\''
$ json '\''~b|a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a|c'\'' '\''a'\''
$ json '\''~b|a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a|~c'\'' '\''a'\''
$ json '\''~b|~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a|a'\'' '\''a'\''
$ json '\''~b|~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a|b'\'' '\''a'\''
$ json '\''~b|~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a|c'\'' '\''a'\''
$ json '\''~b|~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a|~c'\'' '\''a'\''
$ json '\''~b|b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b|a'\'' '\''a'\''
$ json '\''~b|b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b|~a'\'' '\''a'\''
$ json '\''~b|b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b|c'\'' '\''a'\''
$ json '\''~b|b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b|~c'\'' '\''a'\''
$ json '\''~b|c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c|a'\'' '\''a'\''
$ json '\''~b|c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c|~a'\'' '\''a'\''
$ json '\''~b|c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c|b'\'' '\''a'\''
$ json '\''~b|c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c|~c'\'' '\''a'\''
$ json '\''~b|~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c|a'\'' '\''a'\''
$ json '\''~b|~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c|~a'\'' '\''a'\''
$ json '\''~b|~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c|b'\'' '\''a'\''
$ json '\''~b|~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c|c'\'' '\''a'\''
$ json '\''c|a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a|~a'\'' '\''a'\''
$ json '\''c|a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a|b'\'' '\''a'\''
$ json '\''c|a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a|~b'\'' '\''a'\''
$ json '\''c|a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a|~c'\'' '\''a'\''
$ json '\''c|~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a|a'\'' '\''a'\''
$ json '\''c|~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a|b'\'' '\''a'\''
$ json '\''c|~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a|~b'\'' '\''a'\''
$ json '\''c|~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a|~c'\'' '\''a'\''
$ json '\''c|b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b|a'\'' '\''a'\''
$ json '\''c|b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b|~a'\'' '\''a'\''
$ json '\''c|b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b|~b'\'' '\''a'\''
$ json '\''c|b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b|~c'\'' '\''a'\''
$ json '\''c|~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b|a'\'' '\''a'\''
$ json '\''c|~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b|~a'\'' '\''a'\''
$ json '\''c|~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b|b'\'' '\''a'\''
$ json '\''c|~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b|~c'\'' '\''a'\''
$ json '\''c|~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c|a'\'' '\''a'\''
$ json '\''c|~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c|~a'\'' '\''a'\''
$ json '\''c|~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c|b'\'' '\''a'\''
$ json '\''c|~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c|~b'\'' '\''a'\''
$ json '\''~c|a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a|~a'\'' '\''a'\''
$ json '\''~c|a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a|b'\'' '\''a'\''
$ json '\''~c|a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a|~b'\'' '\''a'\''
$ json '\''~c|a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a|c'\'' '\''a'\''
$ json '\''~c|~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a|a'\'' '\''a'\''
$ json '\''~c|~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a|b'\'' '\''a'\''
$ json '\''~c|~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a|~b'\'' '\''a'\''
$ json '\''~c|~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a|c'\'' '\''a'\''
$ json '\''~c|b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b|a'\'' '\''a'\''
$ json '\''~c|b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b|~a'\'' '\''a'\''
$ json '\''~c|b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b|~b'\'' '\''a'\''
$ json '\''~c|b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b|c'\'' '\''a'\''
$ json '\''~c|~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b|a'\'' '\''a'\''
$ json '\''~c|~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b|~a'\'' '\''a'\''
$ json '\''~c|~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b|b'\'' '\''a'\''
$ json '\''~c|~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b|c'\'' '\''a'\''
$ json '\''~c|c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c|a'\'' '\''a'\''
$ json '\''~c|c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c|~a'\'' '\''a'\''
$ json '\''~c|c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c|b'\'' '\''a'\''
$ json '\''~c|c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c|~b'\'' '\''a'\''
$ json '\''a|~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a||b'\'' '\''a'\''
$ json '\''a|~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a||~b'\'' '\''a'\''
$ json '\''a|~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a||c'\'' '\''a'\''
$ json '\''a|~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~a||~c'\'' '\''a'\''
$ json '\''a|b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b||~a'\'' '\''a'\''
$ json '\''a|b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b||~b'\'' '\''a'\''
$ json '\''a|b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b||c'\'' '\''a'\''
$ json '\''a|b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|b||~c'\'' '\''a'\''
$ json '\''a|~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b||~a'\'' '\''a'\''
$ json '\''a|~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b||b'\'' '\''a'\''
$ json '\''a|~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b||c'\'' '\''a'\''
$ json '\''a|~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~b||~c'\'' '\''a'\''
$ json '\''a|c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c||~a'\'' '\''a'\''
$ json '\''a|c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c||b'\'' '\''a'\''
$ json '\''a|c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c||~b'\'' '\''a'\''
$ json '\''a|c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|c||~c'\'' '\''a'\''
$ json '\''a|~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c||~a'\'' '\''a'\''
$ json '\''a|~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c||b'\'' '\''a'\''
$ json '\''a|~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c||~b'\'' '\''a'\''
$ json '\''a|~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|~c||c'\'' '\''a'\''
$ json '\''~a|a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a||b'\'' '\''a'\''
$ json '\''~a|a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a||~b'\'' '\''a'\''
$ json '\''~a|a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a||c'\'' '\''a'\''
$ json '\''~a|a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|a||~c'\'' '\''a'\''
$ json '\''~a|b||a'\'' '\''a'\''
{"a":0}
$ json '\''~a|b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b||~b'\'' '\''a'\''
$ json '\''~a|b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b||c'\'' '\''a'\''
$ json '\''~a|b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|b||~c'\'' '\''a'\''
$ json '\''~a|~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~a|~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b||b'\'' '\''a'\''
$ json '\''~a|~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b||c'\'' '\''a'\''
$ json '\''~a|~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~b||~c'\'' '\''a'\''
$ json '\''~a|c||a'\'' '\''a'\''
{"a":0}
$ json '\''~a|c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c||b'\'' '\''a'\''
$ json '\''~a|c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c||~b'\'' '\''a'\''
$ json '\''~a|c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|c||~c'\'' '\''a'\''
$ json '\''~a|~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~a|~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c||b'\'' '\''a'\''
$ json '\''~a|~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c||~b'\'' '\''a'\''
$ json '\''~a|~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a|~c||c'\'' '\''a'\''
$ json '\''b|a||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a||~a'\'' '\''a'\''
$ json '\''b|a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a||~b'\'' '\''a'\''
$ json '\''b|a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a||c'\'' '\''a'\''
$ json '\''b|a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|a||~c'\'' '\''a'\''
$ json '\''b|~a||a'\'' '\''a'\''
{"a":0}
$ json '\''b|~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a||~b'\'' '\''a'\''
$ json '\''b|~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a||c'\'' '\''a'\''
$ json '\''b|~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~a||~c'\'' '\''a'\''
$ json '\''b|~b||a'\'' '\''a'\''
{"a":0}
$ json '\''b|~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b||~a'\'' '\''a'\''
$ json '\''b|~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b||c'\'' '\''a'\''
$ json '\''b|~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~b||~c'\'' '\''a'\''
$ json '\''b|c||a'\'' '\''a'\''
{"a":0}
$ json '\''b|c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c||~a'\'' '\''a'\''
$ json '\''b|c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c||~b'\'' '\''a'\''
$ json '\''b|c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|c||~c'\'' '\''a'\''
$ json '\''b|~c||a'\'' '\''a'\''
{"a":0}
$ json '\''b|~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c||~a'\'' '\''a'\''
$ json '\''b|~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c||~b'\'' '\''a'\''
$ json '\''b|~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b|~c||c'\'' '\''a'\''
$ json '\''~b|a||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a||~a'\'' '\''a'\''
$ json '\''~b|a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a||b'\'' '\''a'\''
$ json '\''~b|a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a||c'\'' '\''a'\''
$ json '\''~b|a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|a||~c'\'' '\''a'\''
$ json '\''~b|~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~b|~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a||b'\'' '\''a'\''
$ json '\''~b|~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a||c'\'' '\''a'\''
$ json '\''~b|~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~a||~c'\'' '\''a'\''
$ json '\''~b|b||a'\'' '\''a'\''
{"a":0}
$ json '\''~b|b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b||~a'\'' '\''a'\''
$ json '\''~b|b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b||c'\'' '\''a'\''
$ json '\''~b|b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|b||~c'\'' '\''a'\''
$ json '\''~b|c||a'\'' '\''a'\''
{"a":0}
$ json '\''~b|c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c||~a'\'' '\''a'\''
$ json '\''~b|c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c||b'\'' '\''a'\''
$ json '\''~b|c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|c||~c'\'' '\''a'\''
$ json '\''~b|~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~b|~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c||~a'\'' '\''a'\''
$ json '\''~b|~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c||b'\'' '\''a'\''
$ json '\''~b|~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b|~c||c'\'' '\''a'\''
$ json '\''c|a||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a||~a'\'' '\''a'\''
$ json '\''c|a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a||b'\'' '\''a'\''
$ json '\''c|a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a||~b'\'' '\''a'\''
$ json '\''c|a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|a||~c'\'' '\''a'\''
$ json '\''c|~a||a'\'' '\''a'\''
{"a":0}
$ json '\''c|~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a||b'\'' '\''a'\''
$ json '\''c|~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a||~b'\'' '\''a'\''
$ json '\''c|~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~a||~c'\'' '\''a'\''
$ json '\''c|b||a'\'' '\''a'\''
{"a":0}
$ json '\''c|b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b||~a'\'' '\''a'\''
$ json '\''c|b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b||~b'\'' '\''a'\''
$ json '\''c|b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|b||~c'\'' '\''a'\''
$ json '\''c|~b||a'\'' '\''a'\''
{"a":0}
$ json '\''c|~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b||~a'\'' '\''a'\''
$ json '\''c|~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b||b'\'' '\''a'\''
$ json '\''c|~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~b||~c'\'' '\''a'\''
$ json '\''c|~c||a'\'' '\''a'\''
{"a":0}
$ json '\''c|~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c||~a'\'' '\''a'\''
$ json '\''c|~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c||b'\'' '\''a'\''
$ json '\''c|~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c|~c||~b'\'' '\''a'\''
$ json '\''~c|a||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a||~a'\'' '\''a'\''
$ json '\''~c|a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a||b'\'' '\''a'\''
$ json '\''~c|a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a||~b'\'' '\''a'\''
$ json '\''~c|a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|a||c'\'' '\''a'\''
$ json '\''~c|~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~c|~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a||b'\'' '\''a'\''
$ json '\''~c|~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a||~b'\'' '\''a'\''
$ json '\''~c|~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~a||c'\'' '\''a'\''
$ json '\''~c|b||a'\'' '\''a'\''
{"a":0}
$ json '\''~c|b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b||~a'\'' '\''a'\''
$ json '\''~c|b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b||~b'\'' '\''a'\''
$ json '\''~c|b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|b||c'\'' '\''a'\''
$ json '\''~c|~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~c|~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b||~a'\'' '\''a'\''
$ json '\''~c|~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b||b'\'' '\''a'\''
$ json '\''~c|~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|~b||c'\'' '\''a'\''
$ json '\''~c|c||a'\'' '\''a'\''
{"a":0}
$ json '\''~c|c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c||~a'\'' '\''a'\''
$ json '\''~c|c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c||b'\'' '\''a'\''
$ json '\''~c|c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c|c||~b'\'' '\''a'\''
$ json '\''a||~a b'\'' '\''a'\''
{"a":0}
$ json '\''a||~a ~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~a c'\'' '\''a'\''
{"a":0}
$ json '\''a||~a ~c'\'' '\''a'\''
{"a":0}
$ json '\''a||b ~a'\'' '\''a'\''
{"a":0}
$ json '\''a||b ~b'\'' '\''a'\''
{"a":0}
$ json '\''a||b c'\'' '\''a'\''
{"a":0}
$ json '\''a||b ~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~b ~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~b b'\'' '\''a'\''
{"a":0}
$ json '\''a||~b c'\'' '\''a'\''
{"a":0}
$ json '\''a||~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''a||c ~a'\'' '\''a'\''
{"a":0}
$ json '\''a||c b'\'' '\''a'\''
{"a":0}
$ json '\''a||c ~b'\'' '\''a'\''
{"a":0}
$ json '\''a||c ~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~c ~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~c b'\'' '\''a'\''
{"a":0}
$ json '\''a||~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~c c'\'' '\''a'\''
{"a":0}
$ json '\''~a||a b'\'' '\''a'\''
{"a":0}
$ json '\''~a||a ~b'\'' '\''a'\''
{"a":0}
$ json '\''~a||a c'\'' '\''a'\''
{"a":0}
$ json '\''~a||a ~c'\'' '\''a'\''
{"a":0}
$ json '\''~a||b a'\'' '\''a'\''
{"a":0}
$ json '\''~a||b ~b'\'' '\''a'\''
{"a":0}
$ json '\''~a||b c'\'' '\''a'\''
{"a":0}
$ json '\''~a||b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b ~c'\'' '\''a'\''
$ json '\''~a||~b a'\'' '\''a'\''
{"a":0}
$ json '\''~a||~b b'\'' '\''a'\''
{"a":0}
$ json '\''~a||~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b c'\'' '\''a'\''
$ json '\''~a||~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''~a||c a'\'' '\''a'\''
{"a":0}
$ json '\''~a||c b'\'' '\''a'\''
{"a":0}
$ json '\''~a||c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c ~b'\'' '\''a'\''
$ json '\''~a||c ~c'\'' '\''a'\''
{"a":0}
$ json '\''~a||~c a'\'' '\''a'\''
{"a":0}
$ json '\''~a||~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c b'\'' '\''a'\''
$ json '\''~a||~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''~a||~c c'\'' '\''a'\''
{"a":0}
$ json '\''b||a ~a'\'' '\''a'\''
{"a":0}
$ json '\''b||a ~b'\'' '\''a'\''
{"a":0}
$ json '\''b||a c'\'' '\''a'\''
{"a":0}
$ json '\''b||a ~c'\'' '\''a'\''
{"a":0}
$ json '\''b||~a a'\'' '\''a'\''
{"a":0}
$ json '\''b||~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a ~b'\'' '\''a'\''
$ json '\''b||~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a c'\'' '\''a'\''
$ json '\''b||~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a ~c'\'' '\''a'\''
$ json '\''b||~b a'\'' '\''a'\''
{"a":0}
$ json '\''b||~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b ~a'\'' '\''a'\''
$ json '\''b||~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b c'\'' '\''a'\''
$ json '\''b||~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''b||c a'\'' '\''a'\''
{"a":0}
$ json '\''b||c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c ~a'\'' '\''a'\''
$ json '\''b||c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c ~b'\'' '\''a'\''
$ json '\''b||c ~c'\'' '\''a'\''
{"a":0}
$ json '\''b||~c a'\'' '\''a'\''
{"a":0}
$ json '\''b||~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c ~a'\'' '\''a'\''
$ json '\''b||~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''b||~c c'\'' '\''a'\''
{"a":0}
$ json '\''~b||a ~a'\'' '\''a'\''
{"a":0}
$ json '\''~b||a b'\'' '\''a'\''
{"a":0}
$ json '\''~b||a c'\'' '\''a'\''
{"a":0}
$ json '\''~b||a ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b||~a a'\'' '\''a'\''
{"a":0}
$ json '\''~b||~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a b'\'' '\''a'\''
$ json '\''~b||~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a c'\'' '\''a'\''
$ json '\''~b||~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a ~c'\'' '\''a'\''
$ json '\''~b||b a'\'' '\''a'\''
{"a":0}
$ json '\''~b||b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b ~a'\'' '\''a'\''
$ json '\''~b||b c'\'' '\''a'\''
{"a":0}
$ json '\''~b||b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b ~c'\'' '\''a'\''
$ json '\''~b||c a'\'' '\''a'\''
{"a":0}
$ json '\''~b||c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c ~a'\'' '\''a'\''
$ json '\''~b||c b'\'' '\''a'\''
{"a":0}
$ json '\''~b||c ~c'\'' '\''a'\''
{"a":0}
$ json '\''~b||~c a'\'' '\''a'\''
{"a":0}
$ json '\''~b||~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c ~a'\'' '\''a'\''
$ json '\''~b||~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c b'\'' '\''a'\''
$ json '\''~b||~c c'\'' '\''a'\''
{"a":0}
$ json '\''c||a ~a'\'' '\''a'\''
{"a":0}
$ json '\''c||a b'\'' '\''a'\''
{"a":0}
$ json '\''c||a ~b'\'' '\''a'\''
{"a":0}
$ json '\''c||a ~c'\'' '\''a'\''
{"a":0}
$ json '\''c||~a a'\'' '\''a'\''
{"a":0}
$ json '\''c||~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a b'\'' '\''a'\''
$ json '\''c||~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a ~b'\'' '\''a'\''
$ json '\''c||~a ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a ~c'\'' '\''a'\''
$ json '\''c||b a'\'' '\''a'\''
{"a":0}
$ json '\''c||b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b ~a'\'' '\''a'\''
$ json '\''c||b ~b'\'' '\''a'\''
{"a":0}
$ json '\''c||b ~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b ~c'\'' '\''a'\''
$ json '\''c||~b a'\'' '\''a'\''
{"a":0}
$ json '\''c||~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b ~a'\'' '\''a'\''
$ json '\''c||~b b'\'' '\''a'\''
{"a":0}
$ json '\''c||~b ~c'\'' '\''a'\''
{"a":0}
$ json '\''c||~c a'\'' '\''a'\''
{"a":0}
$ json '\''c||~c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c ~a'\'' '\''a'\''
$ json '\''c||~c b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c b'\'' '\''a'\''
$ json '\''c||~c ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c||a ~a'\'' '\''a'\''
{"a":0}
$ json '\''~c||a b'\'' '\''a'\''
{"a":0}
$ json '\''~c||a ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c||a c'\'' '\''a'\''
{"a":0}
$ json '\''~c||~a a'\'' '\''a'\''
{"a":0}
$ json '\''~c||~a b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a b'\'' '\''a'\''
$ json '\''~c||~a ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a ~b'\'' '\''a'\''
$ json '\''~c||~a c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a c'\'' '\''a'\''
$ json '\''~c||b a'\'' '\''a'\''
{"a":0}
$ json '\''~c||b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b ~a'\'' '\''a'\''
$ json '\''~c||b ~b'\'' '\''a'\''
{"a":0}
$ json '\''~c||b c'\'' '\''a'\''
{"a":0}
$ json '\''~c||~b a'\'' '\''a'\''
{"a":0}
$ json '\''~c||~b ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b ~a'\'' '\''a'\''
$ json '\''~c||~b b'\'' '\''a'\''
{"a":0}
$ json '\''~c||~b c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b c'\'' '\''a'\''
$ json '\''~c||c a'\'' '\''a'\''
{"a":0}
$ json '\''~c||c ~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c ~a'\'' '\''a'\''
$ json '\''~c||c b'\'' '\''a'\''
{"a":0}
$ json '\''~c||c ~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c ~b'\'' '\''a'\''
$ json '\''a||~a|b'\'' '\''a'\''
{"a":0}
$ json '\''a||~a|~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~a|c'\'' '\''a'\''
{"a":0}
$ json '\''a||~a|~c'\'' '\''a'\''
{"a":0}
$ json '\''a||b|~a'\'' '\''a'\''
{"a":0}
$ json '\''a||b|~b'\'' '\''a'\''
{"a":0}
$ json '\''a||b|c'\'' '\''a'\''
{"a":0}
$ json '\''a||b|~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~b|~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~b|b'\'' '\''a'\''
{"a":0}
$ json '\''a||~b|c'\'' '\''a'\''
{"a":0}
$ json '\''a||~b|~c'\'' '\''a'\''
{"a":0}
$ json '\''a||c|~a'\'' '\''a'\''
{"a":0}
$ json '\''a||c|b'\'' '\''a'\''
{"a":0}
$ json '\''a||c|~b'\'' '\''a'\''
{"a":0}
$ json '\''a||c|~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~c|~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~c|b'\'' '\''a'\''
{"a":0}
$ json '\''a||~c|~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~c|c'\'' '\''a'\''
{"a":0}
$ json '\''~a||a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||a|b'\'' '\''a'\''
$ json '\''~a||a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||a|~b'\'' '\''a'\''
$ json '\''~a||a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||a|c'\'' '\''a'\''
$ json '\''~a||a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||a|~c'\'' '\''a'\''
$ json '\''~a||b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b|a'\'' '\''a'\''
$ json '\''~a||b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b|~b'\'' '\''a'\''
$ json '\''~a||b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b|c'\'' '\''a'\''
$ json '\''~a||b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b|~c'\'' '\''a'\''
$ json '\''~a||~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b|a'\'' '\''a'\''
$ json '\''~a||~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b|b'\'' '\''a'\''
$ json '\''~a||~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b|c'\'' '\''a'\''
$ json '\''~a||~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b|~c'\'' '\''a'\''
$ json '\''~a||c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c|a'\'' '\''a'\''
$ json '\''~a||c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c|b'\'' '\''a'\''
$ json '\''~a||c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c|~b'\'' '\''a'\''
$ json '\''~a||c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c|~c'\'' '\''a'\''
$ json '\''~a||~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c|a'\'' '\''a'\''
$ json '\''~a||~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c|b'\'' '\''a'\''
$ json '\''~a||~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c|~b'\'' '\''a'\''
$ json '\''~a||~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c|c'\'' '\''a'\''
$ json '\''b||a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||a|~a'\'' '\''a'\''
$ json '\''b||a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||a|~b'\'' '\''a'\''
$ json '\''b||a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||a|c'\'' '\''a'\''
$ json '\''b||a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||a|~c'\'' '\''a'\''
$ json '\''b||~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a|a'\'' '\''a'\''
$ json '\''b||~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a|~b'\'' '\''a'\''
$ json '\''b||~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a|c'\'' '\''a'\''
$ json '\''b||~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a|~c'\'' '\''a'\''
$ json '\''b||~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b|a'\'' '\''a'\''
$ json '\''b||~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b|~a'\'' '\''a'\''
$ json '\''b||~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b|c'\'' '\''a'\''
$ json '\''b||~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b|~c'\'' '\''a'\''
$ json '\''b||c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c|a'\'' '\''a'\''
$ json '\''b||c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c|~a'\'' '\''a'\''
$ json '\''b||c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c|~b'\'' '\''a'\''
$ json '\''b||c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c|~c'\'' '\''a'\''
$ json '\''b||~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c|a'\'' '\''a'\''
$ json '\''b||~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c|~a'\'' '\''a'\''
$ json '\''b||~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c|~b'\'' '\''a'\''
$ json '\''b||~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c|c'\'' '\''a'\''
$ json '\''~b||a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||a|~a'\'' '\''a'\''
$ json '\''~b||a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||a|b'\'' '\''a'\''
$ json '\''~b||a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||a|c'\'' '\''a'\''
$ json '\''~b||a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||a|~c'\'' '\''a'\''
$ json '\''~b||~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a|a'\'' '\''a'\''
$ json '\''~b||~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a|b'\'' '\''a'\''
$ json '\''~b||~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a|c'\'' '\''a'\''
$ json '\''~b||~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a|~c'\'' '\''a'\''
$ json '\''~b||b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b|a'\'' '\''a'\''
$ json '\''~b||b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b|~a'\'' '\''a'\''
$ json '\''~b||b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b|c'\'' '\''a'\''
$ json '\''~b||b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b|~c'\'' '\''a'\''
$ json '\''~b||c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c|a'\'' '\''a'\''
$ json '\''~b||c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c|~a'\'' '\''a'\''
$ json '\''~b||c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c|b'\'' '\''a'\''
$ json '\''~b||c|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c|~c'\'' '\''a'\''
$ json '\''~b||~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c|a'\'' '\''a'\''
$ json '\''~b||~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c|~a'\'' '\''a'\''
$ json '\''~b||~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c|b'\'' '\''a'\''
$ json '\''~b||~c|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c|c'\'' '\''a'\''
$ json '\''c||a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||a|~a'\'' '\''a'\''
$ json '\''c||a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||a|b'\'' '\''a'\''
$ json '\''c||a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||a|~b'\'' '\''a'\''
$ json '\''c||a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||a|~c'\'' '\''a'\''
$ json '\''c||~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a|a'\'' '\''a'\''
$ json '\''c||~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a|b'\'' '\''a'\''
$ json '\''c||~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a|~b'\'' '\''a'\''
$ json '\''c||~a|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a|~c'\'' '\''a'\''
$ json '\''c||b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b|a'\'' '\''a'\''
$ json '\''c||b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b|~a'\'' '\''a'\''
$ json '\''c||b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b|~b'\'' '\''a'\''
$ json '\''c||b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b|~c'\'' '\''a'\''
$ json '\''c||~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b|a'\'' '\''a'\''
$ json '\''c||~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b|~a'\'' '\''a'\''
$ json '\''c||~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b|b'\'' '\''a'\''
$ json '\''c||~b|~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b|~c'\'' '\''a'\''
$ json '\''c||~c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c|a'\'' '\''a'\''
$ json '\''c||~c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c|~a'\'' '\''a'\''
$ json '\''c||~c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c|b'\'' '\''a'\''
$ json '\''c||~c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c|~b'\'' '\''a'\''
$ json '\''~c||a|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||a|~a'\'' '\''a'\''
$ json '\''~c||a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||a|b'\'' '\''a'\''
$ json '\''~c||a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||a|~b'\'' '\''a'\''
$ json '\''~c||a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||a|c'\'' '\''a'\''
$ json '\''~c||~a|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a|a'\'' '\''a'\''
$ json '\''~c||~a|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a|b'\'' '\''a'\''
$ json '\''~c||~a|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a|~b'\'' '\''a'\''
$ json '\''~c||~a|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a|c'\'' '\''a'\''
$ json '\''~c||b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b|a'\'' '\''a'\''
$ json '\''~c||b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b|~a'\'' '\''a'\''
$ json '\''~c||b|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b|~b'\'' '\''a'\''
$ json '\''~c||b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b|c'\'' '\''a'\''
$ json '\''~c||~b|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b|a'\'' '\''a'\''
$ json '\''~c||~b|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b|~a'\'' '\''a'\''
$ json '\''~c||~b|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b|b'\'' '\''a'\''
$ json '\''~c||~b|c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b|c'\'' '\''a'\''
$ json '\''~c||c|a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c|a'\'' '\''a'\''
$ json '\''~c||c|~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c|~a'\'' '\''a'\''
$ json '\''~c||c|b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c|b'\'' '\''a'\''
$ json '\''~c||c|~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c|~b'\'' '\''a'\''
$ json '\''a||~a||b'\'' '\''a'\''
{"a":0}
$ json '\''a||~a||~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~a||c'\'' '\''a'\''
{"a":0}
$ json '\''a||~a||~c'\'' '\''a'\''
{"a":0}
$ json '\''a||b||~a'\'' '\''a'\''
{"a":0}
$ json '\''a||b||~b'\'' '\''a'\''
{"a":0}
$ json '\''a||b||c'\'' '\''a'\''
{"a":0}
$ json '\''a||b||~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~b||~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~b||b'\'' '\''a'\''
{"a":0}
$ json '\''a||~b||c'\'' '\''a'\''
{"a":0}
$ json '\''a||~b||~c'\'' '\''a'\''
{"a":0}
$ json '\''a||c||~a'\'' '\''a'\''
{"a":0}
$ json '\''a||c||b'\'' '\''a'\''
{"a":0}
$ json '\''a||c||~b'\'' '\''a'\''
{"a":0}
$ json '\''a||c||~c'\'' '\''a'\''
{"a":0}
$ json '\''a||~c||~a'\'' '\''a'\''
{"a":0}
$ json '\''a||~c||b'\'' '\''a'\''
{"a":0}
$ json '\''a||~c||~b'\'' '\''a'\''
{"a":0}
$ json '\''a||~c||c'\'' '\''a'\''
{"a":0}
$ json '\''~a||a||b'\'' '\''a'\''
{"a":0}
$ json '\''~a||a||~b'\'' '\''a'\''
{"a":0}
$ json '\''~a||a||c'\'' '\''a'\''
{"a":0}
$ json '\''~a||a||~c'\'' '\''a'\''
{"a":0}
$ json '\''~a||b||a'\'' '\''a'\''
{"a":0}
$ json '\''~a||b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b||~b'\'' '\''a'\''
$ json '\''~a||b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b||c'\'' '\''a'\''
$ json '\''~a||b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||b||~c'\'' '\''a'\''
$ json '\''~a||~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~a||~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b||b'\'' '\''a'\''
$ json '\''~a||~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b||c'\'' '\''a'\''
$ json '\''~a||~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~b||~c'\'' '\''a'\''
$ json '\''~a||c||a'\'' '\''a'\''
{"a":0}
$ json '\''~a||c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c||b'\'' '\''a'\''
$ json '\''~a||c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c||~b'\'' '\''a'\''
$ json '\''~a||c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||c||~c'\'' '\''a'\''
$ json '\''~a||~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~a||~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c||b'\'' '\''a'\''
$ json '\''~a||~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c||~b'\'' '\''a'\''
$ json '\''~a||~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b" and "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a||~c||c'\'' '\''a'\''
$ json '\''b||a||~a'\'' '\''a'\''
{"a":0}
$ json '\''b||a||~b'\'' '\''a'\''
{"a":0}
$ json '\''b||a||c'\'' '\''a'\''
{"a":0}
$ json '\''b||a||~c'\'' '\''a'\''
{"a":0}
$ json '\''b||~a||a'\'' '\''a'\''
{"a":0}
$ json '\''b||~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a||~b'\'' '\''a'\''
$ json '\''b||~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a||c'\'' '\''a'\''
$ json '\''b||~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~a||~c'\'' '\''a'\''
$ json '\''b||~b||a'\'' '\''a'\''
{"a":0}
$ json '\''b||~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b||~a'\'' '\''a'\''
$ json '\''b||~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b||c'\'' '\''a'\''
$ json '\''b||~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~b||~c'\'' '\''a'\''
$ json '\''b||c||a'\'' '\''a'\''
{"a":0}
$ json '\''b||c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c||~a'\'' '\''a'\''
$ json '\''b||c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c||~b'\'' '\''a'\''
$ json '\''b||c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||c||~c'\'' '\''a'\''
$ json '\''b||~c||a'\'' '\''a'\''
{"a":0}
$ json '\''b||~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c||~a'\'' '\''a'\''
$ json '\''b||~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c||~b'\'' '\''a'\''
$ json '\''b||~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b||~c||c'\'' '\''a'\''
$ json '\''~b||a||~a'\'' '\''a'\''
{"a":0}
$ json '\''~b||a||b'\'' '\''a'\''
{"a":0}
$ json '\''~b||a||c'\'' '\''a'\''
{"a":0}
$ json '\''~b||a||~c'\'' '\''a'\''
{"a":0}
$ json '\''~b||~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~b||~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a||b'\'' '\''a'\''
$ json '\''~b||~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a||c'\'' '\''a'\''
$ json '\''~b||~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~a||~c'\'' '\''a'\''
$ json '\''~b||b||a'\'' '\''a'\''
{"a":0}
$ json '\''~b||b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b||~a'\'' '\''a'\''
$ json '\''~b||b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b||c'\'' '\''a'\''
$ json '\''~b||b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||b||~c'\'' '\''a'\''
$ json '\''~b||c||a'\'' '\''a'\''
{"a":0}
$ json '\''~b||c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c||~a'\'' '\''a'\''
$ json '\''~b||c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c||b'\'' '\''a'\''
$ json '\''~b||c||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||c||~c'\'' '\''a'\''
$ json '\''~b||~c||a'\'' '\''a'\''
{"a":0}
$ json '\''~b||~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c||~a'\'' '\''a'\''
$ json '\''~b||~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c||b'\'' '\''a'\''
$ json '\''~b||~c||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~b||~c||c'\'' '\''a'\''
$ json '\''c||a||~a'\'' '\''a'\''
{"a":0}
$ json '\''c||a||b'\'' '\''a'\''
{"a":0}
$ json '\''c||a||~b'\'' '\''a'\''
{"a":0}
$ json '\''c||a||~c'\'' '\''a'\''
{"a":0}
$ json '\''c||~a||a'\'' '\''a'\''
{"a":0}
$ json '\''c||~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a||b'\'' '\''a'\''
$ json '\''c||~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a||~b'\'' '\''a'\''
$ json '\''c||~a||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b" and "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~a||~c'\'' '\''a'\''
$ json '\''c||b||a'\'' '\''a'\''
{"a":0}
$ json '\''c||b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b||~a'\'' '\''a'\''
$ json '\''c||b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b||~b'\'' '\''a'\''
$ json '\''c||b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||b||~c'\'' '\''a'\''
$ json '\''c||~b||a'\'' '\''a'\''
{"a":0}
$ json '\''c||~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b||~a'\'' '\''a'\''
$ json '\''c||~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b||b'\'' '\''a'\''
$ json '\''c||~b||~c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~b||~c'\'' '\''a'\''
$ json '\''c||~c||a'\'' '\''a'\''
{"a":0}
$ json '\''c||~c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c||~a'\'' '\''a'\''
$ json '\''c||~c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c||b'\'' '\''a'\''
$ json '\''c||~c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "c"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''c||~c||~b'\'' '\''a'\''
$ json '\''~c||a||~a'\'' '\''a'\''
{"a":0}
$ json '\''~c||a||b'\'' '\''a'\''
{"a":0}
$ json '\''~c||a||~b'\'' '\''a'\''
{"a":0}
$ json '\''~c||a||c'\'' '\''a'\''
{"a":0}
$ json '\''~c||~a||a'\'' '\''a'\''
{"a":0}
$ json '\''~c||~a||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a||b'\'' '\''a'\''
$ json '\''~c||~a||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a||~b'\'' '\''a'\''
$ json '\''~c||~a||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b" and "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~a||c'\'' '\''a'\''
$ json '\''~c||b||a'\'' '\''a'\''
{"a":0}
$ json '\''~c||b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b||~a'\'' '\''a'\''
$ json '\''~c||b||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b||~b'\'' '\''a'\''
$ json '\''~c||b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "b"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||b||c'\'' '\''a'\''
$ json '\''~c||~b||a'\'' '\''a'\''
{"a":0}
$ json '\''~c||~b||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b||~a'\'' '\''a'\''
$ json '\''~c||~b||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b||b'\'' '\''a'\''
$ json '\''~c||~b||c'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||~b||c'\'' '\''a'\''
$ json '\''~c||c||a'\'' '\''a'\''
{"a":0}
$ json '\''~c||c||~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b" and "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c||~a'\'' '\''a'\''
$ json '\''~c||c||b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c||b'\'' '\''a'\''
$ json '\''~c||c||~b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: 1st case: "b"; 2nd case: "c"; 3rd case: "c"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~c||c||~b'\'' '\''a'\'''
) -L dict-expr3.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'
json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); } 2>&1 ||
echo 'command failed: json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k3 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k3 -ae "$1"); }'

echo '$ json '\''a ~a b'\'' '\''a'\'''
json 'a ~a b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a b'\'' '\''a'\'''

echo '$ json '\''a ~a ~b'\'' '\''a'\'''
json 'a ~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a ~b'\'' '\''a'\'''

echo '$ json '\''a ~a c'\'' '\''a'\'''
json 'a ~a c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a c'\'' '\''a'\'''

echo '$ json '\''a ~a ~c'\'' '\''a'\'''
json 'a ~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a ~c'\'' '\''a'\'''

echo '$ json '\''a b ~a'\'' '\''a'\'''
json 'a b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a b ~a'\'' '\''a'\'''

echo '$ json '\''a b ~b'\'' '\''a'\'''
json 'a b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a b ~b'\'' '\''a'\'''

echo '$ json '\''a b c'\'' '\''a'\'''
json 'a b c' 'a' 2>&1 ||
echo 'command failed: json '\''a b c'\'' '\''a'\'''

echo '$ json '\''a b ~c'\'' '\''a'\'''
json 'a b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a b ~c'\'' '\''a'\'''

echo '$ json '\''a ~b ~a'\'' '\''a'\'''
json 'a ~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b ~a'\'' '\''a'\'''

echo '$ json '\''a ~b b'\'' '\''a'\'''
json 'a ~b b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b b'\'' '\''a'\'''

echo '$ json '\''a ~b c'\'' '\''a'\'''
json 'a ~b c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b c'\'' '\''a'\'''

echo '$ json '\''a ~b ~c'\'' '\''a'\'''
json 'a ~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b ~c'\'' '\''a'\'''

echo '$ json '\''a c ~a'\'' '\''a'\'''
json 'a c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a c ~a'\'' '\''a'\'''

echo '$ json '\''a c b'\'' '\''a'\'''
json 'a c b' 'a' 2>&1 ||
echo 'command failed: json '\''a c b'\'' '\''a'\'''

echo '$ json '\''a c ~b'\'' '\''a'\'''
json 'a c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a c ~b'\'' '\''a'\'''

echo '$ json '\''a c ~c'\'' '\''a'\'''
json 'a c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a c ~c'\'' '\''a'\'''

echo '$ json '\''a ~c ~a'\'' '\''a'\'''
json 'a ~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c ~a'\'' '\''a'\'''

echo '$ json '\''a ~c b'\'' '\''a'\'''
json 'a ~c b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c b'\'' '\''a'\'''

echo '$ json '\''a ~c ~b'\'' '\''a'\'''
json 'a ~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c ~b'\'' '\''a'\'''

echo '$ json '\''a ~c c'\'' '\''a'\'''
json 'a ~c c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c c'\'' '\''a'\'''

echo '$ json '\''~a a b'\'' '\''a'\'''
json '~a a b' 'a' 2>&1 ||
echo 'command failed: json '\''~a a b'\'' '\''a'\'''

echo '$ json '\''~a a ~b'\'' '\''a'\'''
json '~a a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a a ~b'\'' '\''a'\'''

echo '$ json '\''~a a c'\'' '\''a'\'''
json '~a a c' 'a' 2>&1 ||
echo 'command failed: json '\''~a a c'\'' '\''a'\'''

echo '$ json '\''~a a ~c'\'' '\''a'\'''
json '~a a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a a ~c'\'' '\''a'\'''

echo '$ json '\''~a b a'\'' '\''a'\'''
json '~a b a' 'a' 2>&1 ||
echo 'command failed: json '\''~a b a'\'' '\''a'\'''

echo '$ json '\''~a b ~b'\'' '\''a'\'''
json '~a b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a b ~b'\'' '\''a'\'''

echo '$ json '\''~a b c'\'' '\''a'\'''
json '~a b c' 'a' 2>&1 ||
echo 'command failed: json '\''~a b c'\'' '\''a'\'''

echo '$ json '\''~a b ~c'\'' '\''a'\'''
json '~a b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a b ~c'\'' '\''a'\'''

echo '$ json '\''~a ~b a'\'' '\''a'\'''
json '~a ~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b a'\'' '\''a'\'''

echo '$ json '\''~a ~b b'\'' '\''a'\'''
json '~a ~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b b'\'' '\''a'\'''

echo '$ json '\''~a ~b c'\'' '\''a'\'''
json '~a ~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b c'\'' '\''a'\'''

echo '$ json '\''~a ~b ~c'\'' '\''a'\'''
json '~a ~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b ~c'\'' '\''a'\'''

echo '$ json '\''~a c a'\'' '\''a'\'''
json '~a c a' 'a' 2>&1 ||
echo 'command failed: json '\''~a c a'\'' '\''a'\'''

echo '$ json '\''~a c b'\'' '\''a'\'''
json '~a c b' 'a' 2>&1 ||
echo 'command failed: json '\''~a c b'\'' '\''a'\'''

echo '$ json '\''~a c ~b'\'' '\''a'\'''
json '~a c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a c ~b'\'' '\''a'\'''

echo '$ json '\''~a c ~c'\'' '\''a'\'''
json '~a c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a c ~c'\'' '\''a'\'''

echo '$ json '\''~a ~c a'\'' '\''a'\'''
json '~a ~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c a'\'' '\''a'\'''

echo '$ json '\''~a ~c b'\'' '\''a'\'''
json '~a ~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c b'\'' '\''a'\'''

echo '$ json '\''~a ~c ~b'\'' '\''a'\'''
json '~a ~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c ~b'\'' '\''a'\'''

echo '$ json '\''~a ~c c'\'' '\''a'\'''
json '~a ~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c c'\'' '\''a'\'''

echo '$ json '\''b a ~a'\'' '\''a'\'''
json 'b a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b a ~a'\'' '\''a'\'''

echo '$ json '\''b a ~b'\'' '\''a'\'''
json 'b a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b a ~b'\'' '\''a'\'''

echo '$ json '\''b a c'\'' '\''a'\'''
json 'b a c' 'a' 2>&1 ||
echo 'command failed: json '\''b a c'\'' '\''a'\'''

echo '$ json '\''b a ~c'\'' '\''a'\'''
json 'b a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b a ~c'\'' '\''a'\'''

echo '$ json '\''b ~a a'\'' '\''a'\'''
json 'b ~a a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a a'\'' '\''a'\'''

echo '$ json '\''b ~a ~b'\'' '\''a'\'''
json 'b ~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a ~b'\'' '\''a'\'''

echo '$ json '\''b ~a c'\'' '\''a'\'''
json 'b ~a c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a c'\'' '\''a'\'''

echo '$ json '\''b ~a ~c'\'' '\''a'\'''
json 'b ~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a ~c'\'' '\''a'\'''

echo '$ json '\''b ~b a'\'' '\''a'\'''
json 'b ~b a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b a'\'' '\''a'\'''

echo '$ json '\''b ~b ~a'\'' '\''a'\'''
json 'b ~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b ~a'\'' '\''a'\'''

echo '$ json '\''b ~b c'\'' '\''a'\'''
json 'b ~b c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b c'\'' '\''a'\'''

echo '$ json '\''b ~b ~c'\'' '\''a'\'''
json 'b ~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b ~c'\'' '\''a'\'''

echo '$ json '\''b c a'\'' '\''a'\'''
json 'b c a' 'a' 2>&1 ||
echo 'command failed: json '\''b c a'\'' '\''a'\'''

echo '$ json '\''b c ~a'\'' '\''a'\'''
json 'b c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b c ~a'\'' '\''a'\'''

echo '$ json '\''b c ~b'\'' '\''a'\'''
json 'b c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b c ~b'\'' '\''a'\'''

echo '$ json '\''b c ~c'\'' '\''a'\'''
json 'b c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b c ~c'\'' '\''a'\'''

echo '$ json '\''b ~c a'\'' '\''a'\'''
json 'b ~c a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c a'\'' '\''a'\'''

echo '$ json '\''b ~c ~a'\'' '\''a'\'''
json 'b ~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c ~a'\'' '\''a'\'''

echo '$ json '\''b ~c ~b'\'' '\''a'\'''
json 'b ~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c ~b'\'' '\''a'\'''

echo '$ json '\''b ~c c'\'' '\''a'\'''
json 'b ~c c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c c'\'' '\''a'\'''

echo '$ json '\''~b a ~a'\'' '\''a'\'''
json '~b a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b a ~a'\'' '\''a'\'''

echo '$ json '\''~b a b'\'' '\''a'\'''
json '~b a b' 'a' 2>&1 ||
echo 'command failed: json '\''~b a b'\'' '\''a'\'''

echo '$ json '\''~b a c'\'' '\''a'\'''
json '~b a c' 'a' 2>&1 ||
echo 'command failed: json '\''~b a c'\'' '\''a'\'''

echo '$ json '\''~b a ~c'\'' '\''a'\'''
json '~b a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b a ~c'\'' '\''a'\'''

echo '$ json '\''~b ~a a'\'' '\''a'\'''
json '~b ~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a a'\'' '\''a'\'''

echo '$ json '\''~b ~a b'\'' '\''a'\'''
json '~b ~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a b'\'' '\''a'\'''

echo '$ json '\''~b ~a c'\'' '\''a'\'''
json '~b ~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a c'\'' '\''a'\'''

echo '$ json '\''~b ~a ~c'\'' '\''a'\'''
json '~b ~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a ~c'\'' '\''a'\'''

echo '$ json '\''~b b a'\'' '\''a'\'''
json '~b b a' 'a' 2>&1 ||
echo 'command failed: json '\''~b b a'\'' '\''a'\'''

echo '$ json '\''~b b ~a'\'' '\''a'\'''
json '~b b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b b ~a'\'' '\''a'\'''

echo '$ json '\''~b b c'\'' '\''a'\'''
json '~b b c' 'a' 2>&1 ||
echo 'command failed: json '\''~b b c'\'' '\''a'\'''

echo '$ json '\''~b b ~c'\'' '\''a'\'''
json '~b b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b b ~c'\'' '\''a'\'''

echo '$ json '\''~b c a'\'' '\''a'\'''
json '~b c a' 'a' 2>&1 ||
echo 'command failed: json '\''~b c a'\'' '\''a'\'''

echo '$ json '\''~b c ~a'\'' '\''a'\'''
json '~b c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b c ~a'\'' '\''a'\'''

echo '$ json '\''~b c b'\'' '\''a'\'''
json '~b c b' 'a' 2>&1 ||
echo 'command failed: json '\''~b c b'\'' '\''a'\'''

echo '$ json '\''~b c ~c'\'' '\''a'\'''
json '~b c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b c ~c'\'' '\''a'\'''

echo '$ json '\''~b ~c a'\'' '\''a'\'''
json '~b ~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c a'\'' '\''a'\'''

echo '$ json '\''~b ~c ~a'\'' '\''a'\'''
json '~b ~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c ~a'\'' '\''a'\'''

echo '$ json '\''~b ~c b'\'' '\''a'\'''
json '~b ~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c b'\'' '\''a'\'''

echo '$ json '\''~b ~c c'\'' '\''a'\'''
json '~b ~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c c'\'' '\''a'\'''

echo '$ json '\''c a ~a'\'' '\''a'\'''
json 'c a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c a ~a'\'' '\''a'\'''

echo '$ json '\''c a b'\'' '\''a'\'''
json 'c a b' 'a' 2>&1 ||
echo 'command failed: json '\''c a b'\'' '\''a'\'''

echo '$ json '\''c a ~b'\'' '\''a'\'''
json 'c a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c a ~b'\'' '\''a'\'''

echo '$ json '\''c a ~c'\'' '\''a'\'''
json 'c a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c a ~c'\'' '\''a'\'''

echo '$ json '\''c ~a a'\'' '\''a'\'''
json 'c ~a a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a a'\'' '\''a'\'''

echo '$ json '\''c ~a b'\'' '\''a'\'''
json 'c ~a b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a b'\'' '\''a'\'''

echo '$ json '\''c ~a ~b'\'' '\''a'\'''
json 'c ~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a ~b'\'' '\''a'\'''

echo '$ json '\''c ~a ~c'\'' '\''a'\'''
json 'c ~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a ~c'\'' '\''a'\'''

echo '$ json '\''c b a'\'' '\''a'\'''
json 'c b a' 'a' 2>&1 ||
echo 'command failed: json '\''c b a'\'' '\''a'\'''

echo '$ json '\''c b ~a'\'' '\''a'\'''
json 'c b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c b ~a'\'' '\''a'\'''

echo '$ json '\''c b ~b'\'' '\''a'\'''
json 'c b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c b ~b'\'' '\''a'\'''

echo '$ json '\''c b ~c'\'' '\''a'\'''
json 'c b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c b ~c'\'' '\''a'\'''

echo '$ json '\''c ~b a'\'' '\''a'\'''
json 'c ~b a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b a'\'' '\''a'\'''

echo '$ json '\''c ~b ~a'\'' '\''a'\'''
json 'c ~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b ~a'\'' '\''a'\'''

echo '$ json '\''c ~b b'\'' '\''a'\'''
json 'c ~b b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b b'\'' '\''a'\'''

echo '$ json '\''c ~b ~c'\'' '\''a'\'''
json 'c ~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b ~c'\'' '\''a'\'''

echo '$ json '\''c ~c a'\'' '\''a'\'''
json 'c ~c a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c a'\'' '\''a'\'''

echo '$ json '\''c ~c ~a'\'' '\''a'\'''
json 'c ~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c ~a'\'' '\''a'\'''

echo '$ json '\''c ~c b'\'' '\''a'\'''
json 'c ~c b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c b'\'' '\''a'\'''

echo '$ json '\''c ~c ~b'\'' '\''a'\'''
json 'c ~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c ~b'\'' '\''a'\'''

echo '$ json '\''~c a ~a'\'' '\''a'\'''
json '~c a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c a ~a'\'' '\''a'\'''

echo '$ json '\''~c a b'\'' '\''a'\'''
json '~c a b' 'a' 2>&1 ||
echo 'command failed: json '\''~c a b'\'' '\''a'\'''

echo '$ json '\''~c a ~b'\'' '\''a'\'''
json '~c a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c a ~b'\'' '\''a'\'''

echo '$ json '\''~c a c'\'' '\''a'\'''
json '~c a c' 'a' 2>&1 ||
echo 'command failed: json '\''~c a c'\'' '\''a'\'''

echo '$ json '\''~c ~a a'\'' '\''a'\'''
json '~c ~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a a'\'' '\''a'\'''

echo '$ json '\''~c ~a b'\'' '\''a'\'''
json '~c ~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a b'\'' '\''a'\'''

echo '$ json '\''~c ~a ~b'\'' '\''a'\'''
json '~c ~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a ~b'\'' '\''a'\'''

echo '$ json '\''~c ~a c'\'' '\''a'\'''
json '~c ~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a c'\'' '\''a'\'''

echo '$ json '\''~c b a'\'' '\''a'\'''
json '~c b a' 'a' 2>&1 ||
echo 'command failed: json '\''~c b a'\'' '\''a'\'''

echo '$ json '\''~c b ~a'\'' '\''a'\'''
json '~c b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c b ~a'\'' '\''a'\'''

echo '$ json '\''~c b ~b'\'' '\''a'\'''
json '~c b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c b ~b'\'' '\''a'\'''

echo '$ json '\''~c b c'\'' '\''a'\'''
json '~c b c' 'a' 2>&1 ||
echo 'command failed: json '\''~c b c'\'' '\''a'\'''

echo '$ json '\''~c ~b a'\'' '\''a'\'''
json '~c ~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b a'\'' '\''a'\'''

echo '$ json '\''~c ~b ~a'\'' '\''a'\'''
json '~c ~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b ~a'\'' '\''a'\'''

echo '$ json '\''~c ~b b'\'' '\''a'\'''
json '~c ~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b b'\'' '\''a'\'''

echo '$ json '\''~c ~b c'\'' '\''a'\'''
json '~c ~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b c'\'' '\''a'\'''

echo '$ json '\''~c c a'\'' '\''a'\'''
json '~c c a' 'a' 2>&1 ||
echo 'command failed: json '\''~c c a'\'' '\''a'\'''

echo '$ json '\''~c c ~a'\'' '\''a'\'''
json '~c c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c c ~a'\'' '\''a'\'''

echo '$ json '\''~c c b'\'' '\''a'\'''
json '~c c b' 'a' 2>&1 ||
echo 'command failed: json '\''~c c b'\'' '\''a'\'''

echo '$ json '\''~c c ~b'\'' '\''a'\'''
json '~c c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c c ~b'\'' '\''a'\'''

echo '$ json '\''a ~a|b'\'' '\''a'\'''
json 'a ~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a|b'\'' '\''a'\'''

echo '$ json '\''a ~a|~b'\'' '\''a'\'''
json 'a ~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a|~b'\'' '\''a'\'''

echo '$ json '\''a ~a|c'\'' '\''a'\'''
json 'a ~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a|c'\'' '\''a'\'''

echo '$ json '\''a ~a|~c'\'' '\''a'\'''
json 'a ~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a|~c'\'' '\''a'\'''

echo '$ json '\''a b|~a'\'' '\''a'\'''
json 'a b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a b|~a'\'' '\''a'\'''

echo '$ json '\''a b|~b'\'' '\''a'\'''
json 'a b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a b|~b'\'' '\''a'\'''

echo '$ json '\''a b|c'\'' '\''a'\'''
json 'a b|c' 'a' 2>&1 ||
echo 'command failed: json '\''a b|c'\'' '\''a'\'''

echo '$ json '\''a b|~c'\'' '\''a'\'''
json 'a b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a b|~c'\'' '\''a'\'''

echo '$ json '\''a ~b|~a'\'' '\''a'\'''
json 'a ~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b|~a'\'' '\''a'\'''

echo '$ json '\''a ~b|b'\'' '\''a'\'''
json 'a ~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b|b'\'' '\''a'\'''

echo '$ json '\''a ~b|c'\'' '\''a'\'''
json 'a ~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b|c'\'' '\''a'\'''

echo '$ json '\''a ~b|~c'\'' '\''a'\'''
json 'a ~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b|~c'\'' '\''a'\'''

echo '$ json '\''a c|~a'\'' '\''a'\'''
json 'a c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a c|~a'\'' '\''a'\'''

echo '$ json '\''a c|b'\'' '\''a'\'''
json 'a c|b' 'a' 2>&1 ||
echo 'command failed: json '\''a c|b'\'' '\''a'\'''

echo '$ json '\''a c|~b'\'' '\''a'\'''
json 'a c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a c|~b'\'' '\''a'\'''

echo '$ json '\''a c|~c'\'' '\''a'\'''
json 'a c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a c|~c'\'' '\''a'\'''

echo '$ json '\''a ~c|~a'\'' '\''a'\'''
json 'a ~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c|~a'\'' '\''a'\'''

echo '$ json '\''a ~c|b'\'' '\''a'\'''
json 'a ~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c|b'\'' '\''a'\'''

echo '$ json '\''a ~c|~b'\'' '\''a'\'''
json 'a ~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c|~b'\'' '\''a'\'''

echo '$ json '\''a ~c|c'\'' '\''a'\'''
json 'a ~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c|c'\'' '\''a'\'''

echo '$ json '\''~a a|b'\'' '\''a'\'''
json '~a a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a a|b'\'' '\''a'\'''

echo '$ json '\''~a a|~b'\'' '\''a'\'''
json '~a a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a a|~b'\'' '\''a'\'''

echo '$ json '\''~a a|c'\'' '\''a'\'''
json '~a a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a a|c'\'' '\''a'\'''

echo '$ json '\''~a a|~c'\'' '\''a'\'''
json '~a a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a a|~c'\'' '\''a'\'''

echo '$ json '\''~a b|a'\'' '\''a'\'''
json '~a b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a b|a'\'' '\''a'\'''

echo '$ json '\''~a b|~b'\'' '\''a'\'''
json '~a b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a b|~b'\'' '\''a'\'''

echo '$ json '\''~a b|c'\'' '\''a'\'''
json '~a b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a b|c'\'' '\''a'\'''

echo '$ json '\''~a b|~c'\'' '\''a'\'''
json '~a b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a b|~c'\'' '\''a'\'''

echo '$ json '\''~a ~b|a'\'' '\''a'\'''
json '~a ~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b|a'\'' '\''a'\'''

echo '$ json '\''~a ~b|b'\'' '\''a'\'''
json '~a ~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b|b'\'' '\''a'\'''

echo '$ json '\''~a ~b|c'\'' '\''a'\'''
json '~a ~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b|c'\'' '\''a'\'''

echo '$ json '\''~a ~b|~c'\'' '\''a'\'''
json '~a ~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b|~c'\'' '\''a'\'''

echo '$ json '\''~a c|a'\'' '\''a'\'''
json '~a c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a c|a'\'' '\''a'\'''

echo '$ json '\''~a c|b'\'' '\''a'\'''
json '~a c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a c|b'\'' '\''a'\'''

echo '$ json '\''~a c|~b'\'' '\''a'\'''
json '~a c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a c|~b'\'' '\''a'\'''

echo '$ json '\''~a c|~c'\'' '\''a'\'''
json '~a c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a c|~c'\'' '\''a'\'''

echo '$ json '\''~a ~c|a'\'' '\''a'\'''
json '~a ~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c|a'\'' '\''a'\'''

echo '$ json '\''~a ~c|b'\'' '\''a'\'''
json '~a ~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c|b'\'' '\''a'\'''

echo '$ json '\''~a ~c|~b'\'' '\''a'\'''
json '~a ~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c|~b'\'' '\''a'\'''

echo '$ json '\''~a ~c|c'\'' '\''a'\'''
json '~a ~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c|c'\'' '\''a'\'''

echo '$ json '\''b a|~a'\'' '\''a'\'''
json 'b a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b a|~a'\'' '\''a'\'''

echo '$ json '\''b a|~b'\'' '\''a'\'''
json 'b a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b a|~b'\'' '\''a'\'''

echo '$ json '\''b a|c'\'' '\''a'\'''
json 'b a|c' 'a' 2>&1 ||
echo 'command failed: json '\''b a|c'\'' '\''a'\'''

echo '$ json '\''b a|~c'\'' '\''a'\'''
json 'b a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b a|~c'\'' '\''a'\'''

echo '$ json '\''b ~a|a'\'' '\''a'\'''
json 'b ~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a|a'\'' '\''a'\'''

echo '$ json '\''b ~a|~b'\'' '\''a'\'''
json 'b ~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a|~b'\'' '\''a'\'''

echo '$ json '\''b ~a|c'\'' '\''a'\'''
json 'b ~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a|c'\'' '\''a'\'''

echo '$ json '\''b ~a|~c'\'' '\''a'\'''
json 'b ~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a|~c'\'' '\''a'\'''

echo '$ json '\''b ~b|a'\'' '\''a'\'''
json 'b ~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b|a'\'' '\''a'\'''

echo '$ json '\''b ~b|~a'\'' '\''a'\'''
json 'b ~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b|~a'\'' '\''a'\'''

echo '$ json '\''b ~b|c'\'' '\''a'\'''
json 'b ~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b|c'\'' '\''a'\'''

echo '$ json '\''b ~b|~c'\'' '\''a'\'''
json 'b ~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b|~c'\'' '\''a'\'''

echo '$ json '\''b c|a'\'' '\''a'\'''
json 'b c|a' 'a' 2>&1 ||
echo 'command failed: json '\''b c|a'\'' '\''a'\'''

echo '$ json '\''b c|~a'\'' '\''a'\'''
json 'b c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b c|~a'\'' '\''a'\'''

echo '$ json '\''b c|~b'\'' '\''a'\'''
json 'b c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b c|~b'\'' '\''a'\'''

echo '$ json '\''b c|~c'\'' '\''a'\'''
json 'b c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b c|~c'\'' '\''a'\'''

echo '$ json '\''b ~c|a'\'' '\''a'\'''
json 'b ~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c|a'\'' '\''a'\'''

echo '$ json '\''b ~c|~a'\'' '\''a'\'''
json 'b ~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c|~a'\'' '\''a'\'''

echo '$ json '\''b ~c|~b'\'' '\''a'\'''
json 'b ~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c|~b'\'' '\''a'\'''

echo '$ json '\''b ~c|c'\'' '\''a'\'''
json 'b ~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c|c'\'' '\''a'\'''

echo '$ json '\''~b a|~a'\'' '\''a'\'''
json '~b a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b a|~a'\'' '\''a'\'''

echo '$ json '\''~b a|b'\'' '\''a'\'''
json '~b a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b a|b'\'' '\''a'\'''

echo '$ json '\''~b a|c'\'' '\''a'\'''
json '~b a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b a|c'\'' '\''a'\'''

echo '$ json '\''~b a|~c'\'' '\''a'\'''
json '~b a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b a|~c'\'' '\''a'\'''

echo '$ json '\''~b ~a|a'\'' '\''a'\'''
json '~b ~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a|a'\'' '\''a'\'''

echo '$ json '\''~b ~a|b'\'' '\''a'\'''
json '~b ~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a|b'\'' '\''a'\'''

echo '$ json '\''~b ~a|c'\'' '\''a'\'''
json '~b ~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a|c'\'' '\''a'\'''

echo '$ json '\''~b ~a|~c'\'' '\''a'\'''
json '~b ~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a|~c'\'' '\''a'\'''

echo '$ json '\''~b b|a'\'' '\''a'\'''
json '~b b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b b|a'\'' '\''a'\'''

echo '$ json '\''~b b|~a'\'' '\''a'\'''
json '~b b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b b|~a'\'' '\''a'\'''

echo '$ json '\''~b b|c'\'' '\''a'\'''
json '~b b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b b|c'\'' '\''a'\'''

echo '$ json '\''~b b|~c'\'' '\''a'\'''
json '~b b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b b|~c'\'' '\''a'\'''

echo '$ json '\''~b c|a'\'' '\''a'\'''
json '~b c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b c|a'\'' '\''a'\'''

echo '$ json '\''~b c|~a'\'' '\''a'\'''
json '~b c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b c|~a'\'' '\''a'\'''

echo '$ json '\''~b c|b'\'' '\''a'\'''
json '~b c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b c|b'\'' '\''a'\'''

echo '$ json '\''~b c|~c'\'' '\''a'\'''
json '~b c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b c|~c'\'' '\''a'\'''

echo '$ json '\''~b ~c|a'\'' '\''a'\'''
json '~b ~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c|a'\'' '\''a'\'''

echo '$ json '\''~b ~c|~a'\'' '\''a'\'''
json '~b ~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c|~a'\'' '\''a'\'''

echo '$ json '\''~b ~c|b'\'' '\''a'\'''
json '~b ~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c|b'\'' '\''a'\'''

echo '$ json '\''~b ~c|c'\'' '\''a'\'''
json '~b ~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c|c'\'' '\''a'\'''

echo '$ json '\''c a|~a'\'' '\''a'\'''
json 'c a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c a|~a'\'' '\''a'\'''

echo '$ json '\''c a|b'\'' '\''a'\'''
json 'c a|b' 'a' 2>&1 ||
echo 'command failed: json '\''c a|b'\'' '\''a'\'''

echo '$ json '\''c a|~b'\'' '\''a'\'''
json 'c a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c a|~b'\'' '\''a'\'''

echo '$ json '\''c a|~c'\'' '\''a'\'''
json 'c a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c a|~c'\'' '\''a'\'''

echo '$ json '\''c ~a|a'\'' '\''a'\'''
json 'c ~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a|a'\'' '\''a'\'''

echo '$ json '\''c ~a|b'\'' '\''a'\'''
json 'c ~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a|b'\'' '\''a'\'''

echo '$ json '\''c ~a|~b'\'' '\''a'\'''
json 'c ~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a|~b'\'' '\''a'\'''

echo '$ json '\''c ~a|~c'\'' '\''a'\'''
json 'c ~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a|~c'\'' '\''a'\'''

echo '$ json '\''c b|a'\'' '\''a'\'''
json 'c b|a' 'a' 2>&1 ||
echo 'command failed: json '\''c b|a'\'' '\''a'\'''

echo '$ json '\''c b|~a'\'' '\''a'\'''
json 'c b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c b|~a'\'' '\''a'\'''

echo '$ json '\''c b|~b'\'' '\''a'\'''
json 'c b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c b|~b'\'' '\''a'\'''

echo '$ json '\''c b|~c'\'' '\''a'\'''
json 'c b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c b|~c'\'' '\''a'\'''

echo '$ json '\''c ~b|a'\'' '\''a'\'''
json 'c ~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b|a'\'' '\''a'\'''

echo '$ json '\''c ~b|~a'\'' '\''a'\'''
json 'c ~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b|~a'\'' '\''a'\'''

echo '$ json '\''c ~b|b'\'' '\''a'\'''
json 'c ~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b|b'\'' '\''a'\'''

echo '$ json '\''c ~b|~c'\'' '\''a'\'''
json 'c ~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b|~c'\'' '\''a'\'''

echo '$ json '\''c ~c|a'\'' '\''a'\'''
json 'c ~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c|a'\'' '\''a'\'''

echo '$ json '\''c ~c|~a'\'' '\''a'\'''
json 'c ~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c|~a'\'' '\''a'\'''

echo '$ json '\''c ~c|b'\'' '\''a'\'''
json 'c ~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c|b'\'' '\''a'\'''

echo '$ json '\''c ~c|~b'\'' '\''a'\'''
json 'c ~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c|~b'\'' '\''a'\'''

echo '$ json '\''~c a|~a'\'' '\''a'\'''
json '~c a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c a|~a'\'' '\''a'\'''

echo '$ json '\''~c a|b'\'' '\''a'\'''
json '~c a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c a|b'\'' '\''a'\'''

echo '$ json '\''~c a|~b'\'' '\''a'\'''
json '~c a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c a|~b'\'' '\''a'\'''

echo '$ json '\''~c a|c'\'' '\''a'\'''
json '~c a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c a|c'\'' '\''a'\'''

echo '$ json '\''~c ~a|a'\'' '\''a'\'''
json '~c ~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a|a'\'' '\''a'\'''

echo '$ json '\''~c ~a|b'\'' '\''a'\'''
json '~c ~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a|b'\'' '\''a'\'''

echo '$ json '\''~c ~a|~b'\'' '\''a'\'''
json '~c ~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a|~b'\'' '\''a'\'''

echo '$ json '\''~c ~a|c'\'' '\''a'\'''
json '~c ~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a|c'\'' '\''a'\'''

echo '$ json '\''~c b|a'\'' '\''a'\'''
json '~c b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c b|a'\'' '\''a'\'''

echo '$ json '\''~c b|~a'\'' '\''a'\'''
json '~c b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c b|~a'\'' '\''a'\'''

echo '$ json '\''~c b|~b'\'' '\''a'\'''
json '~c b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c b|~b'\'' '\''a'\'''

echo '$ json '\''~c b|c'\'' '\''a'\'''
json '~c b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c b|c'\'' '\''a'\'''

echo '$ json '\''~c ~b|a'\'' '\''a'\'''
json '~c ~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b|a'\'' '\''a'\'''

echo '$ json '\''~c ~b|~a'\'' '\''a'\'''
json '~c ~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b|~a'\'' '\''a'\'''

echo '$ json '\''~c ~b|b'\'' '\''a'\'''
json '~c ~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b|b'\'' '\''a'\'''

echo '$ json '\''~c ~b|c'\'' '\''a'\'''
json '~c ~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b|c'\'' '\''a'\'''

echo '$ json '\''~c c|a'\'' '\''a'\'''
json '~c c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c c|a'\'' '\''a'\'''

echo '$ json '\''~c c|~a'\'' '\''a'\'''
json '~c c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c c|~a'\'' '\''a'\'''

echo '$ json '\''~c c|b'\'' '\''a'\'''
json '~c c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c c|b'\'' '\''a'\'''

echo '$ json '\''~c c|~b'\'' '\''a'\'''
json '~c c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c c|~b'\'' '\''a'\'''

echo '$ json '\''a ~a||b'\'' '\''a'\'''
json 'a ~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a||b'\'' '\''a'\'''

echo '$ json '\''a ~a||~b'\'' '\''a'\'''
json 'a ~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a||~b'\'' '\''a'\'''

echo '$ json '\''a ~a||c'\'' '\''a'\'''
json 'a ~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a||c'\'' '\''a'\'''

echo '$ json '\''a ~a||~c'\'' '\''a'\'''
json 'a ~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~a||~c'\'' '\''a'\'''

echo '$ json '\''a b||~a'\'' '\''a'\'''
json 'a b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a b||~a'\'' '\''a'\'''

echo '$ json '\''a b||~b'\'' '\''a'\'''
json 'a b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a b||~b'\'' '\''a'\'''

echo '$ json '\''a b||c'\'' '\''a'\'''
json 'a b||c' 'a' 2>&1 ||
echo 'command failed: json '\''a b||c'\'' '\''a'\'''

echo '$ json '\''a b||~c'\'' '\''a'\'''
json 'a b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a b||~c'\'' '\''a'\'''

echo '$ json '\''a ~b||~a'\'' '\''a'\'''
json 'a ~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b||~a'\'' '\''a'\'''

echo '$ json '\''a ~b||b'\'' '\''a'\'''
json 'a ~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b||b'\'' '\''a'\'''

echo '$ json '\''a ~b||c'\'' '\''a'\'''
json 'a ~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b||c'\'' '\''a'\'''

echo '$ json '\''a ~b||~c'\'' '\''a'\'''
json 'a ~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~b||~c'\'' '\''a'\'''

echo '$ json '\''a c||~a'\'' '\''a'\'''
json 'a c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a c||~a'\'' '\''a'\'''

echo '$ json '\''a c||b'\'' '\''a'\'''
json 'a c||b' 'a' 2>&1 ||
echo 'command failed: json '\''a c||b'\'' '\''a'\'''

echo '$ json '\''a c||~b'\'' '\''a'\'''
json 'a c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a c||~b'\'' '\''a'\'''

echo '$ json '\''a c||~c'\'' '\''a'\'''
json 'a c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a c||~c'\'' '\''a'\'''

echo '$ json '\''a ~c||~a'\'' '\''a'\'''
json 'a ~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c||~a'\'' '\''a'\'''

echo '$ json '\''a ~c||b'\'' '\''a'\'''
json 'a ~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c||b'\'' '\''a'\'''

echo '$ json '\''a ~c||~b'\'' '\''a'\'''
json 'a ~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c||~b'\'' '\''a'\'''

echo '$ json '\''a ~c||c'\'' '\''a'\'''
json 'a ~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''a ~c||c'\'' '\''a'\'''

echo '$ json '\''~a a||b'\'' '\''a'\'''
json '~a a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a a||b'\'' '\''a'\'''

echo '$ json '\''~a a||~b'\'' '\''a'\'''
json '~a a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a a||~b'\'' '\''a'\'''

echo '$ json '\''~a a||c'\'' '\''a'\'''
json '~a a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a a||c'\'' '\''a'\'''

echo '$ json '\''~a a||~c'\'' '\''a'\'''
json '~a a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a a||~c'\'' '\''a'\'''

echo '$ json '\''~a b||a'\'' '\''a'\'''
json '~a b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a b||a'\'' '\''a'\'''

echo '$ json '\''~a b||~b'\'' '\''a'\'''
json '~a b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a b||~b'\'' '\''a'\'''

echo '$ json '\''~a b||c'\'' '\''a'\'''
json '~a b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a b||c'\'' '\''a'\'''

echo '$ json '\''~a b||~c'\'' '\''a'\'''
json '~a b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a b||~c'\'' '\''a'\'''

echo '$ json '\''~a ~b||a'\'' '\''a'\'''
json '~a ~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b||a'\'' '\''a'\'''

echo '$ json '\''~a ~b||b'\'' '\''a'\'''
json '~a ~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b||b'\'' '\''a'\'''

echo '$ json '\''~a ~b||c'\'' '\''a'\'''
json '~a ~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b||c'\'' '\''a'\'''

echo '$ json '\''~a ~b||~c'\'' '\''a'\'''
json '~a ~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~b||~c'\'' '\''a'\'''

echo '$ json '\''~a c||a'\'' '\''a'\'''
json '~a c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a c||a'\'' '\''a'\'''

echo '$ json '\''~a c||b'\'' '\''a'\'''
json '~a c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a c||b'\'' '\''a'\'''

echo '$ json '\''~a c||~b'\'' '\''a'\'''
json '~a c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a c||~b'\'' '\''a'\'''

echo '$ json '\''~a c||~c'\'' '\''a'\'''
json '~a c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a c||~c'\'' '\''a'\'''

echo '$ json '\''~a ~c||a'\'' '\''a'\'''
json '~a ~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c||a'\'' '\''a'\'''

echo '$ json '\''~a ~c||b'\'' '\''a'\'''
json '~a ~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c||b'\'' '\''a'\'''

echo '$ json '\''~a ~c||~b'\'' '\''a'\'''
json '~a ~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c||~b'\'' '\''a'\'''

echo '$ json '\''~a ~c||c'\'' '\''a'\'''
json '~a ~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a ~c||c'\'' '\''a'\'''

echo '$ json '\''b a||~a'\'' '\''a'\'''
json 'b a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b a||~a'\'' '\''a'\'''

echo '$ json '\''b a||~b'\'' '\''a'\'''
json 'b a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b a||~b'\'' '\''a'\'''

echo '$ json '\''b a||c'\'' '\''a'\'''
json 'b a||c' 'a' 2>&1 ||
echo 'command failed: json '\''b a||c'\'' '\''a'\'''

echo '$ json '\''b a||~c'\'' '\''a'\'''
json 'b a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b a||~c'\'' '\''a'\'''

echo '$ json '\''b ~a||a'\'' '\''a'\'''
json 'b ~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a||a'\'' '\''a'\'''

echo '$ json '\''b ~a||~b'\'' '\''a'\'''
json 'b ~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a||~b'\'' '\''a'\'''

echo '$ json '\''b ~a||c'\'' '\''a'\'''
json 'b ~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a||c'\'' '\''a'\'''

echo '$ json '\''b ~a||~c'\'' '\''a'\'''
json 'b ~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~a||~c'\'' '\''a'\'''

echo '$ json '\''b ~b||a'\'' '\''a'\'''
json 'b ~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b||a'\'' '\''a'\'''

echo '$ json '\''b ~b||~a'\'' '\''a'\'''
json 'b ~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b||~a'\'' '\''a'\'''

echo '$ json '\''b ~b||c'\'' '\''a'\'''
json 'b ~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b||c'\'' '\''a'\'''

echo '$ json '\''b ~b||~c'\'' '\''a'\'''
json 'b ~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~b||~c'\'' '\''a'\'''

echo '$ json '\''b c||a'\'' '\''a'\'''
json 'b c||a' 'a' 2>&1 ||
echo 'command failed: json '\''b c||a'\'' '\''a'\'''

echo '$ json '\''b c||~a'\'' '\''a'\'''
json 'b c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b c||~a'\'' '\''a'\'''

echo '$ json '\''b c||~b'\'' '\''a'\'''
json 'b c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b c||~b'\'' '\''a'\'''

echo '$ json '\''b c||~c'\'' '\''a'\'''
json 'b c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b c||~c'\'' '\''a'\'''

echo '$ json '\''b ~c||a'\'' '\''a'\'''
json 'b ~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c||a'\'' '\''a'\'''

echo '$ json '\''b ~c||~a'\'' '\''a'\'''
json 'b ~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c||~a'\'' '\''a'\'''

echo '$ json '\''b ~c||~b'\'' '\''a'\'''
json 'b ~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c||~b'\'' '\''a'\'''

echo '$ json '\''b ~c||c'\'' '\''a'\'''
json 'b ~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''b ~c||c'\'' '\''a'\'''

echo '$ json '\''~b a||~a'\'' '\''a'\'''
json '~b a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b a||~a'\'' '\''a'\'''

echo '$ json '\''~b a||b'\'' '\''a'\'''
json '~b a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b a||b'\'' '\''a'\'''

echo '$ json '\''~b a||c'\'' '\''a'\'''
json '~b a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b a||c'\'' '\''a'\'''

echo '$ json '\''~b a||~c'\'' '\''a'\'''
json '~b a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b a||~c'\'' '\''a'\'''

echo '$ json '\''~b ~a||a'\'' '\''a'\'''
json '~b ~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a||a'\'' '\''a'\'''

echo '$ json '\''~b ~a||b'\'' '\''a'\'''
json '~b ~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a||b'\'' '\''a'\'''

echo '$ json '\''~b ~a||c'\'' '\''a'\'''
json '~b ~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a||c'\'' '\''a'\'''

echo '$ json '\''~b ~a||~c'\'' '\''a'\'''
json '~b ~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~a||~c'\'' '\''a'\'''

echo '$ json '\''~b b||a'\'' '\''a'\'''
json '~b b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b b||a'\'' '\''a'\'''

echo '$ json '\''~b b||~a'\'' '\''a'\'''
json '~b b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b b||~a'\'' '\''a'\'''

echo '$ json '\''~b b||c'\'' '\''a'\'''
json '~b b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b b||c'\'' '\''a'\'''

echo '$ json '\''~b b||~c'\'' '\''a'\'''
json '~b b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b b||~c'\'' '\''a'\'''

echo '$ json '\''~b c||a'\'' '\''a'\'''
json '~b c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b c||a'\'' '\''a'\'''

echo '$ json '\''~b c||~a'\'' '\''a'\'''
json '~b c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b c||~a'\'' '\''a'\'''

echo '$ json '\''~b c||b'\'' '\''a'\'''
json '~b c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b c||b'\'' '\''a'\'''

echo '$ json '\''~b c||~c'\'' '\''a'\'''
json '~b c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b c||~c'\'' '\''a'\'''

echo '$ json '\''~b ~c||a'\'' '\''a'\'''
json '~b ~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c||a'\'' '\''a'\'''

echo '$ json '\''~b ~c||~a'\'' '\''a'\'''
json '~b ~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c||~a'\'' '\''a'\'''

echo '$ json '\''~b ~c||b'\'' '\''a'\'''
json '~b ~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c||b'\'' '\''a'\'''

echo '$ json '\''~b ~c||c'\'' '\''a'\'''
json '~b ~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b ~c||c'\'' '\''a'\'''

echo '$ json '\''c a||~a'\'' '\''a'\'''
json 'c a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c a||~a'\'' '\''a'\'''

echo '$ json '\''c a||b'\'' '\''a'\'''
json 'c a||b' 'a' 2>&1 ||
echo 'command failed: json '\''c a||b'\'' '\''a'\'''

echo '$ json '\''c a||~b'\'' '\''a'\'''
json 'c a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c a||~b'\'' '\''a'\'''

echo '$ json '\''c a||~c'\'' '\''a'\'''
json 'c a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c a||~c'\'' '\''a'\'''

echo '$ json '\''c ~a||a'\'' '\''a'\'''
json 'c ~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a||a'\'' '\''a'\'''

echo '$ json '\''c ~a||b'\'' '\''a'\'''
json 'c ~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a||b'\'' '\''a'\'''

echo '$ json '\''c ~a||~b'\'' '\''a'\'''
json 'c ~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a||~b'\'' '\''a'\'''

echo '$ json '\''c ~a||~c'\'' '\''a'\'''
json 'c ~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~a||~c'\'' '\''a'\'''

echo '$ json '\''c b||a'\'' '\''a'\'''
json 'c b||a' 'a' 2>&1 ||
echo 'command failed: json '\''c b||a'\'' '\''a'\'''

echo '$ json '\''c b||~a'\'' '\''a'\'''
json 'c b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c b||~a'\'' '\''a'\'''

echo '$ json '\''c b||~b'\'' '\''a'\'''
json 'c b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c b||~b'\'' '\''a'\'''

echo '$ json '\''c b||~c'\'' '\''a'\'''
json 'c b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c b||~c'\'' '\''a'\'''

echo '$ json '\''c ~b||a'\'' '\''a'\'''
json 'c ~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b||a'\'' '\''a'\'''

echo '$ json '\''c ~b||~a'\'' '\''a'\'''
json 'c ~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b||~a'\'' '\''a'\'''

echo '$ json '\''c ~b||b'\'' '\''a'\'''
json 'c ~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b||b'\'' '\''a'\'''

echo '$ json '\''c ~b||~c'\'' '\''a'\'''
json 'c ~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c ~b||~c'\'' '\''a'\'''

echo '$ json '\''c ~c||a'\'' '\''a'\'''
json 'c ~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c||a'\'' '\''a'\'''

echo '$ json '\''c ~c||~a'\'' '\''a'\'''
json 'c ~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c||~a'\'' '\''a'\'''

echo '$ json '\''c ~c||b'\'' '\''a'\'''
json 'c ~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c||b'\'' '\''a'\'''

echo '$ json '\''c ~c||~b'\'' '\''a'\'''
json 'c ~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c ~c||~b'\'' '\''a'\'''

echo '$ json '\''~c a||~a'\'' '\''a'\'''
json '~c a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c a||~a'\'' '\''a'\'''

echo '$ json '\''~c a||b'\'' '\''a'\'''
json '~c a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c a||b'\'' '\''a'\'''

echo '$ json '\''~c a||~b'\'' '\''a'\'''
json '~c a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c a||~b'\'' '\''a'\'''

echo '$ json '\''~c a||c'\'' '\''a'\'''
json '~c a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c a||c'\'' '\''a'\'''

echo '$ json '\''~c ~a||a'\'' '\''a'\'''
json '~c ~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a||a'\'' '\''a'\'''

echo '$ json '\''~c ~a||b'\'' '\''a'\'''
json '~c ~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a||b'\'' '\''a'\'''

echo '$ json '\''~c ~a||~b'\'' '\''a'\'''
json '~c ~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a||~b'\'' '\''a'\'''

echo '$ json '\''~c ~a||c'\'' '\''a'\'''
json '~c ~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~a||c'\'' '\''a'\'''

echo '$ json '\''~c b||a'\'' '\''a'\'''
json '~c b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c b||a'\'' '\''a'\'''

echo '$ json '\''~c b||~a'\'' '\''a'\'''
json '~c b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c b||~a'\'' '\''a'\'''

echo '$ json '\''~c b||~b'\'' '\''a'\'''
json '~c b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c b||~b'\'' '\''a'\'''

echo '$ json '\''~c b||c'\'' '\''a'\'''
json '~c b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c b||c'\'' '\''a'\'''

echo '$ json '\''~c ~b||a'\'' '\''a'\'''
json '~c ~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b||a'\'' '\''a'\'''

echo '$ json '\''~c ~b||~a'\'' '\''a'\'''
json '~c ~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b||~a'\'' '\''a'\'''

echo '$ json '\''~c ~b||b'\'' '\''a'\'''
json '~c ~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b||b'\'' '\''a'\'''

echo '$ json '\''~c ~b||c'\'' '\''a'\'''
json '~c ~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c ~b||c'\'' '\''a'\'''

echo '$ json '\''~c c||a'\'' '\''a'\'''
json '~c c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c c||a'\'' '\''a'\'''

echo '$ json '\''~c c||~a'\'' '\''a'\'''
json '~c c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c c||~a'\'' '\''a'\'''

echo '$ json '\''~c c||b'\'' '\''a'\'''
json '~c c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c c||b'\'' '\''a'\'''

echo '$ json '\''~c c||~b'\'' '\''a'\'''
json '~c c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c c||~b'\'' '\''a'\'''

echo '$ json '\''a|~a b'\'' '\''a'\'''
json 'a|~a b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a b'\'' '\''a'\'''

echo '$ json '\''a|~a ~b'\'' '\''a'\'''
json 'a|~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a ~b'\'' '\''a'\'''

echo '$ json '\''a|~a c'\'' '\''a'\'''
json 'a|~a c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a c'\'' '\''a'\'''

echo '$ json '\''a|~a ~c'\'' '\''a'\'''
json 'a|~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a ~c'\'' '\''a'\'''

echo '$ json '\''a|b ~a'\'' '\''a'\'''
json 'a|b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|b ~a'\'' '\''a'\'''

echo '$ json '\''a|b ~b'\'' '\''a'\'''
json 'a|b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|b ~b'\'' '\''a'\'''

echo '$ json '\''a|b c'\'' '\''a'\'''
json 'a|b c' 'a' 2>&1 ||
echo 'command failed: json '\''a|b c'\'' '\''a'\'''

echo '$ json '\''a|b ~c'\'' '\''a'\'''
json 'a|b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|b ~c'\'' '\''a'\'''

echo '$ json '\''a|~b ~a'\'' '\''a'\'''
json 'a|~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b ~a'\'' '\''a'\'''

echo '$ json '\''a|~b b'\'' '\''a'\'''
json 'a|~b b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b b'\'' '\''a'\'''

echo '$ json '\''a|~b c'\'' '\''a'\'''
json 'a|~b c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b c'\'' '\''a'\'''

echo '$ json '\''a|~b ~c'\'' '\''a'\'''
json 'a|~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b ~c'\'' '\''a'\'''

echo '$ json '\''a|c ~a'\'' '\''a'\'''
json 'a|c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|c ~a'\'' '\''a'\'''

echo '$ json '\''a|c b'\'' '\''a'\'''
json 'a|c b' 'a' 2>&1 ||
echo 'command failed: json '\''a|c b'\'' '\''a'\'''

echo '$ json '\''a|c ~b'\'' '\''a'\'''
json 'a|c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|c ~b'\'' '\''a'\'''

echo '$ json '\''a|c ~c'\'' '\''a'\'''
json 'a|c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|c ~c'\'' '\''a'\'''

echo '$ json '\''a|~c ~a'\'' '\''a'\'''
json 'a|~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c ~a'\'' '\''a'\'''

echo '$ json '\''a|~c b'\'' '\''a'\'''
json 'a|~c b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c b'\'' '\''a'\'''

echo '$ json '\''a|~c ~b'\'' '\''a'\'''
json 'a|~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c ~b'\'' '\''a'\'''

echo '$ json '\''a|~c c'\'' '\''a'\'''
json 'a|~c c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c c'\'' '\''a'\'''

echo '$ json '\''~a|a b'\'' '\''a'\'''
json '~a|a b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a b'\'' '\''a'\'''

echo '$ json '\''~a|a ~b'\'' '\''a'\'''
json '~a|a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a ~b'\'' '\''a'\'''

echo '$ json '\''~a|a c'\'' '\''a'\'''
json '~a|a c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a c'\'' '\''a'\'''

echo '$ json '\''~a|a ~c'\'' '\''a'\'''
json '~a|a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a ~c'\'' '\''a'\'''

echo '$ json '\''~a|b a'\'' '\''a'\'''
json '~a|b a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b a'\'' '\''a'\'''

echo '$ json '\''~a|b ~b'\'' '\''a'\'''
json '~a|b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b ~b'\'' '\''a'\'''

echo '$ json '\''~a|b c'\'' '\''a'\'''
json '~a|b c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b c'\'' '\''a'\'''

echo '$ json '\''~a|b ~c'\'' '\''a'\'''
json '~a|b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b ~c'\'' '\''a'\'''

echo '$ json '\''~a|~b a'\'' '\''a'\'''
json '~a|~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b a'\'' '\''a'\'''

echo '$ json '\''~a|~b b'\'' '\''a'\'''
json '~a|~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b b'\'' '\''a'\'''

echo '$ json '\''~a|~b c'\'' '\''a'\'''
json '~a|~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b c'\'' '\''a'\'''

echo '$ json '\''~a|~b ~c'\'' '\''a'\'''
json '~a|~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b ~c'\'' '\''a'\'''

echo '$ json '\''~a|c a'\'' '\''a'\'''
json '~a|c a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c a'\'' '\''a'\'''

echo '$ json '\''~a|c b'\'' '\''a'\'''
json '~a|c b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c b'\'' '\''a'\'''

echo '$ json '\''~a|c ~b'\'' '\''a'\'''
json '~a|c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c ~b'\'' '\''a'\'''

echo '$ json '\''~a|c ~c'\'' '\''a'\'''
json '~a|c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c ~c'\'' '\''a'\'''

echo '$ json '\''~a|~c a'\'' '\''a'\'''
json '~a|~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c a'\'' '\''a'\'''

echo '$ json '\''~a|~c b'\'' '\''a'\'''
json '~a|~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c b'\'' '\''a'\'''

echo '$ json '\''~a|~c ~b'\'' '\''a'\'''
json '~a|~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c ~b'\'' '\''a'\'''

echo '$ json '\''~a|~c c'\'' '\''a'\'''
json '~a|~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c c'\'' '\''a'\'''

echo '$ json '\''b|a ~a'\'' '\''a'\'''
json 'b|a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|a ~a'\'' '\''a'\'''

echo '$ json '\''b|a ~b'\'' '\''a'\'''
json 'b|a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|a ~b'\'' '\''a'\'''

echo '$ json '\''b|a c'\'' '\''a'\'''
json 'b|a c' 'a' 2>&1 ||
echo 'command failed: json '\''b|a c'\'' '\''a'\'''

echo '$ json '\''b|a ~c'\'' '\''a'\'''
json 'b|a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|a ~c'\'' '\''a'\'''

echo '$ json '\''b|~a a'\'' '\''a'\'''
json 'b|~a a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a a'\'' '\''a'\'''

echo '$ json '\''b|~a ~b'\'' '\''a'\'''
json 'b|~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a ~b'\'' '\''a'\'''

echo '$ json '\''b|~a c'\'' '\''a'\'''
json 'b|~a c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a c'\'' '\''a'\'''

echo '$ json '\''b|~a ~c'\'' '\''a'\'''
json 'b|~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a ~c'\'' '\''a'\'''

echo '$ json '\''b|~b a'\'' '\''a'\'''
json 'b|~b a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b a'\'' '\''a'\'''

echo '$ json '\''b|~b ~a'\'' '\''a'\'''
json 'b|~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b ~a'\'' '\''a'\'''

echo '$ json '\''b|~b c'\'' '\''a'\'''
json 'b|~b c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b c'\'' '\''a'\'''

echo '$ json '\''b|~b ~c'\'' '\''a'\'''
json 'b|~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b ~c'\'' '\''a'\'''

echo '$ json '\''b|c a'\'' '\''a'\'''
json 'b|c a' 'a' 2>&1 ||
echo 'command failed: json '\''b|c a'\'' '\''a'\'''

echo '$ json '\''b|c ~a'\'' '\''a'\'''
json 'b|c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|c ~a'\'' '\''a'\'''

echo '$ json '\''b|c ~b'\'' '\''a'\'''
json 'b|c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|c ~b'\'' '\''a'\'''

echo '$ json '\''b|c ~c'\'' '\''a'\'''
json 'b|c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|c ~c'\'' '\''a'\'''

echo '$ json '\''b|~c a'\'' '\''a'\'''
json 'b|~c a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c a'\'' '\''a'\'''

echo '$ json '\''b|~c ~a'\'' '\''a'\'''
json 'b|~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c ~a'\'' '\''a'\'''

echo '$ json '\''b|~c ~b'\'' '\''a'\'''
json 'b|~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c ~b'\'' '\''a'\'''

echo '$ json '\''b|~c c'\'' '\''a'\'''
json 'b|~c c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c c'\'' '\''a'\'''

echo '$ json '\''~b|a ~a'\'' '\''a'\'''
json '~b|a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a ~a'\'' '\''a'\'''

echo '$ json '\''~b|a b'\'' '\''a'\'''
json '~b|a b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a b'\'' '\''a'\'''

echo '$ json '\''~b|a c'\'' '\''a'\'''
json '~b|a c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a c'\'' '\''a'\'''

echo '$ json '\''~b|a ~c'\'' '\''a'\'''
json '~b|a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a ~c'\'' '\''a'\'''

echo '$ json '\''~b|~a a'\'' '\''a'\'''
json '~b|~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a a'\'' '\''a'\'''

echo '$ json '\''~b|~a b'\'' '\''a'\'''
json '~b|~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a b'\'' '\''a'\'''

echo '$ json '\''~b|~a c'\'' '\''a'\'''
json '~b|~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a c'\'' '\''a'\'''

echo '$ json '\''~b|~a ~c'\'' '\''a'\'''
json '~b|~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a ~c'\'' '\''a'\'''

echo '$ json '\''~b|b a'\'' '\''a'\'''
json '~b|b a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b a'\'' '\''a'\'''

echo '$ json '\''~b|b ~a'\'' '\''a'\'''
json '~b|b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b ~a'\'' '\''a'\'''

echo '$ json '\''~b|b c'\'' '\''a'\'''
json '~b|b c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b c'\'' '\''a'\'''

echo '$ json '\''~b|b ~c'\'' '\''a'\'''
json '~b|b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b ~c'\'' '\''a'\'''

echo '$ json '\''~b|c a'\'' '\''a'\'''
json '~b|c a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c a'\'' '\''a'\'''

echo '$ json '\''~b|c ~a'\'' '\''a'\'''
json '~b|c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c ~a'\'' '\''a'\'''

echo '$ json '\''~b|c b'\'' '\''a'\'''
json '~b|c b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c b'\'' '\''a'\'''

echo '$ json '\''~b|c ~c'\'' '\''a'\'''
json '~b|c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c ~c'\'' '\''a'\'''

echo '$ json '\''~b|~c a'\'' '\''a'\'''
json '~b|~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c a'\'' '\''a'\'''

echo '$ json '\''~b|~c ~a'\'' '\''a'\'''
json '~b|~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c ~a'\'' '\''a'\'''

echo '$ json '\''~b|~c b'\'' '\''a'\'''
json '~b|~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c b'\'' '\''a'\'''

echo '$ json '\''~b|~c c'\'' '\''a'\'''
json '~b|~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c c'\'' '\''a'\'''

echo '$ json '\''c|a ~a'\'' '\''a'\'''
json 'c|a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|a ~a'\'' '\''a'\'''

echo '$ json '\''c|a b'\'' '\''a'\'''
json 'c|a b' 'a' 2>&1 ||
echo 'command failed: json '\''c|a b'\'' '\''a'\'''

echo '$ json '\''c|a ~b'\'' '\''a'\'''
json 'c|a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|a ~b'\'' '\''a'\'''

echo '$ json '\''c|a ~c'\'' '\''a'\'''
json 'c|a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|a ~c'\'' '\''a'\'''

echo '$ json '\''c|~a a'\'' '\''a'\'''
json 'c|~a a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a a'\'' '\''a'\'''

echo '$ json '\''c|~a b'\'' '\''a'\'''
json 'c|~a b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a b'\'' '\''a'\'''

echo '$ json '\''c|~a ~b'\'' '\''a'\'''
json 'c|~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a ~b'\'' '\''a'\'''

echo '$ json '\''c|~a ~c'\'' '\''a'\'''
json 'c|~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a ~c'\'' '\''a'\'''

echo '$ json '\''c|b a'\'' '\''a'\'''
json 'c|b a' 'a' 2>&1 ||
echo 'command failed: json '\''c|b a'\'' '\''a'\'''

echo '$ json '\''c|b ~a'\'' '\''a'\'''
json 'c|b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|b ~a'\'' '\''a'\'''

echo '$ json '\''c|b ~b'\'' '\''a'\'''
json 'c|b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|b ~b'\'' '\''a'\'''

echo '$ json '\''c|b ~c'\'' '\''a'\'''
json 'c|b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|b ~c'\'' '\''a'\'''

echo '$ json '\''c|~b a'\'' '\''a'\'''
json 'c|~b a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b a'\'' '\''a'\'''

echo '$ json '\''c|~b ~a'\'' '\''a'\'''
json 'c|~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b ~a'\'' '\''a'\'''

echo '$ json '\''c|~b b'\'' '\''a'\'''
json 'c|~b b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b b'\'' '\''a'\'''

echo '$ json '\''c|~b ~c'\'' '\''a'\'''
json 'c|~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b ~c'\'' '\''a'\'''

echo '$ json '\''c|~c a'\'' '\''a'\'''
json 'c|~c a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c a'\'' '\''a'\'''

echo '$ json '\''c|~c ~a'\'' '\''a'\'''
json 'c|~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c ~a'\'' '\''a'\'''

echo '$ json '\''c|~c b'\'' '\''a'\'''
json 'c|~c b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c b'\'' '\''a'\'''

echo '$ json '\''c|~c ~b'\'' '\''a'\'''
json 'c|~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c ~b'\'' '\''a'\'''

echo '$ json '\''~c|a ~a'\'' '\''a'\'''
json '~c|a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a ~a'\'' '\''a'\'''

echo '$ json '\''~c|a b'\'' '\''a'\'''
json '~c|a b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a b'\'' '\''a'\'''

echo '$ json '\''~c|a ~b'\'' '\''a'\'''
json '~c|a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a ~b'\'' '\''a'\'''

echo '$ json '\''~c|a c'\'' '\''a'\'''
json '~c|a c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a c'\'' '\''a'\'''

echo '$ json '\''~c|~a a'\'' '\''a'\'''
json '~c|~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a a'\'' '\''a'\'''

echo '$ json '\''~c|~a b'\'' '\''a'\'''
json '~c|~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a b'\'' '\''a'\'''

echo '$ json '\''~c|~a ~b'\'' '\''a'\'''
json '~c|~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a ~b'\'' '\''a'\'''

echo '$ json '\''~c|~a c'\'' '\''a'\'''
json '~c|~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a c'\'' '\''a'\'''

echo '$ json '\''~c|b a'\'' '\''a'\'''
json '~c|b a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b a'\'' '\''a'\'''

echo '$ json '\''~c|b ~a'\'' '\''a'\'''
json '~c|b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b ~a'\'' '\''a'\'''

echo '$ json '\''~c|b ~b'\'' '\''a'\'''
json '~c|b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b ~b'\'' '\''a'\'''

echo '$ json '\''~c|b c'\'' '\''a'\'''
json '~c|b c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b c'\'' '\''a'\'''

echo '$ json '\''~c|~b a'\'' '\''a'\'''
json '~c|~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b a'\'' '\''a'\'''

echo '$ json '\''~c|~b ~a'\'' '\''a'\'''
json '~c|~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b ~a'\'' '\''a'\'''

echo '$ json '\''~c|~b b'\'' '\''a'\'''
json '~c|~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b b'\'' '\''a'\'''

echo '$ json '\''~c|~b c'\'' '\''a'\'''
json '~c|~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b c'\'' '\''a'\'''

echo '$ json '\''~c|c a'\'' '\''a'\'''
json '~c|c a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c a'\'' '\''a'\'''

echo '$ json '\''~c|c ~a'\'' '\''a'\'''
json '~c|c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c ~a'\'' '\''a'\'''

echo '$ json '\''~c|c b'\'' '\''a'\'''
json '~c|c b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c b'\'' '\''a'\'''

echo '$ json '\''~c|c ~b'\'' '\''a'\'''
json '~c|c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c ~b'\'' '\''a'\'''

echo '$ json '\''a|~a|b'\'' '\''a'\'''
json 'a|~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a|b'\'' '\''a'\'''

echo '$ json '\''a|~a|~b'\'' '\''a'\'''
json 'a|~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a|~b'\'' '\''a'\'''

echo '$ json '\''a|~a|c'\'' '\''a'\'''
json 'a|~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a|c'\'' '\''a'\'''

echo '$ json '\''a|~a|~c'\'' '\''a'\'''
json 'a|~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a|~c'\'' '\''a'\'''

echo '$ json '\''a|b|~a'\'' '\''a'\'''
json 'a|b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|b|~a'\'' '\''a'\'''

echo '$ json '\''a|b|~b'\'' '\''a'\'''
json 'a|b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|b|~b'\'' '\''a'\'''

echo '$ json '\''a|b|c'\'' '\''a'\'''
json 'a|b|c' 'a' 2>&1 ||
echo 'command failed: json '\''a|b|c'\'' '\''a'\'''

echo '$ json '\''a|b|~c'\'' '\''a'\'''
json 'a|b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|b|~c'\'' '\''a'\'''

echo '$ json '\''a|~b|~a'\'' '\''a'\'''
json 'a|~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b|~a'\'' '\''a'\'''

echo '$ json '\''a|~b|b'\'' '\''a'\'''
json 'a|~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b|b'\'' '\''a'\'''

echo '$ json '\''a|~b|c'\'' '\''a'\'''
json 'a|~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b|c'\'' '\''a'\'''

echo '$ json '\''a|~b|~c'\'' '\''a'\'''
json 'a|~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b|~c'\'' '\''a'\'''

echo '$ json '\''a|c|~a'\'' '\''a'\'''
json 'a|c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|c|~a'\'' '\''a'\'''

echo '$ json '\''a|c|b'\'' '\''a'\'''
json 'a|c|b' 'a' 2>&1 ||
echo 'command failed: json '\''a|c|b'\'' '\''a'\'''

echo '$ json '\''a|c|~b'\'' '\''a'\'''
json 'a|c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|c|~b'\'' '\''a'\'''

echo '$ json '\''a|c|~c'\'' '\''a'\'''
json 'a|c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|c|~c'\'' '\''a'\'''

echo '$ json '\''a|~c|~a'\'' '\''a'\'''
json 'a|~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c|~a'\'' '\''a'\'''

echo '$ json '\''a|~c|b'\'' '\''a'\'''
json 'a|~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c|b'\'' '\''a'\'''

echo '$ json '\''a|~c|~b'\'' '\''a'\'''
json 'a|~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c|~b'\'' '\''a'\'''

echo '$ json '\''a|~c|c'\'' '\''a'\'''
json 'a|~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c|c'\'' '\''a'\'''

echo '$ json '\''~a|a|b'\'' '\''a'\'''
json '~a|a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a|b'\'' '\''a'\'''

echo '$ json '\''~a|a|~b'\'' '\''a'\'''
json '~a|a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a|~b'\'' '\''a'\'''

echo '$ json '\''~a|a|c'\'' '\''a'\'''
json '~a|a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a|c'\'' '\''a'\'''

echo '$ json '\''~a|a|~c'\'' '\''a'\'''
json '~a|a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a|~c'\'' '\''a'\'''

echo '$ json '\''~a|b|a'\'' '\''a'\'''
json '~a|b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b|a'\'' '\''a'\'''

echo '$ json '\''~a|b|~b'\'' '\''a'\'''
json '~a|b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b|~b'\'' '\''a'\'''

echo '$ json '\''~a|b|c'\'' '\''a'\'''
json '~a|b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b|c'\'' '\''a'\'''

echo '$ json '\''~a|b|~c'\'' '\''a'\'''
json '~a|b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b|~c'\'' '\''a'\'''

echo '$ json '\''~a|~b|a'\'' '\''a'\'''
json '~a|~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b|a'\'' '\''a'\'''

echo '$ json '\''~a|~b|b'\'' '\''a'\'''
json '~a|~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b|b'\'' '\''a'\'''

echo '$ json '\''~a|~b|c'\'' '\''a'\'''
json '~a|~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b|c'\'' '\''a'\'''

echo '$ json '\''~a|~b|~c'\'' '\''a'\'''
json '~a|~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b|~c'\'' '\''a'\'''

echo '$ json '\''~a|c|a'\'' '\''a'\'''
json '~a|c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c|a'\'' '\''a'\'''

echo '$ json '\''~a|c|b'\'' '\''a'\'''
json '~a|c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c|b'\'' '\''a'\'''

echo '$ json '\''~a|c|~b'\'' '\''a'\'''
json '~a|c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c|~b'\'' '\''a'\'''

echo '$ json '\''~a|c|~c'\'' '\''a'\'''
json '~a|c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c|~c'\'' '\''a'\'''

echo '$ json '\''~a|~c|a'\'' '\''a'\'''
json '~a|~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c|a'\'' '\''a'\'''

echo '$ json '\''~a|~c|b'\'' '\''a'\'''
json '~a|~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c|b'\'' '\''a'\'''

echo '$ json '\''~a|~c|~b'\'' '\''a'\'''
json '~a|~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c|~b'\'' '\''a'\'''

echo '$ json '\''~a|~c|c'\'' '\''a'\'''
json '~a|~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c|c'\'' '\''a'\'''

echo '$ json '\''b|a|~a'\'' '\''a'\'''
json 'b|a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|a|~a'\'' '\''a'\'''

echo '$ json '\''b|a|~b'\'' '\''a'\'''
json 'b|a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|a|~b'\'' '\''a'\'''

echo '$ json '\''b|a|c'\'' '\''a'\'''
json 'b|a|c' 'a' 2>&1 ||
echo 'command failed: json '\''b|a|c'\'' '\''a'\'''

echo '$ json '\''b|a|~c'\'' '\''a'\'''
json 'b|a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|a|~c'\'' '\''a'\'''

echo '$ json '\''b|~a|a'\'' '\''a'\'''
json 'b|~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a|a'\'' '\''a'\'''

echo '$ json '\''b|~a|~b'\'' '\''a'\'''
json 'b|~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a|~b'\'' '\''a'\'''

echo '$ json '\''b|~a|c'\'' '\''a'\'''
json 'b|~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a|c'\'' '\''a'\'''

echo '$ json '\''b|~a|~c'\'' '\''a'\'''
json 'b|~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a|~c'\'' '\''a'\'''

echo '$ json '\''b|~b|a'\'' '\''a'\'''
json 'b|~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b|a'\'' '\''a'\'''

echo '$ json '\''b|~b|~a'\'' '\''a'\'''
json 'b|~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b|~a'\'' '\''a'\'''

echo '$ json '\''b|~b|c'\'' '\''a'\'''
json 'b|~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b|c'\'' '\''a'\'''

echo '$ json '\''b|~b|~c'\'' '\''a'\'''
json 'b|~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b|~c'\'' '\''a'\'''

echo '$ json '\''b|c|a'\'' '\''a'\'''
json 'b|c|a' 'a' 2>&1 ||
echo 'command failed: json '\''b|c|a'\'' '\''a'\'''

echo '$ json '\''b|c|~a'\'' '\''a'\'''
json 'b|c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|c|~a'\'' '\''a'\'''

echo '$ json '\''b|c|~b'\'' '\''a'\'''
json 'b|c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|c|~b'\'' '\''a'\'''

echo '$ json '\''b|c|~c'\'' '\''a'\'''
json 'b|c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|c|~c'\'' '\''a'\'''

echo '$ json '\''b|~c|a'\'' '\''a'\'''
json 'b|~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c|a'\'' '\''a'\'''

echo '$ json '\''b|~c|~a'\'' '\''a'\'''
json 'b|~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c|~a'\'' '\''a'\'''

echo '$ json '\''b|~c|~b'\'' '\''a'\'''
json 'b|~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c|~b'\'' '\''a'\'''

echo '$ json '\''b|~c|c'\'' '\''a'\'''
json 'b|~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c|c'\'' '\''a'\'''

echo '$ json '\''~b|a|~a'\'' '\''a'\'''
json '~b|a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a|~a'\'' '\''a'\'''

echo '$ json '\''~b|a|b'\'' '\''a'\'''
json '~b|a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a|b'\'' '\''a'\'''

echo '$ json '\''~b|a|c'\'' '\''a'\'''
json '~b|a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a|c'\'' '\''a'\'''

echo '$ json '\''~b|a|~c'\'' '\''a'\'''
json '~b|a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a|~c'\'' '\''a'\'''

echo '$ json '\''~b|~a|a'\'' '\''a'\'''
json '~b|~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a|a'\'' '\''a'\'''

echo '$ json '\''~b|~a|b'\'' '\''a'\'''
json '~b|~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a|b'\'' '\''a'\'''

echo '$ json '\''~b|~a|c'\'' '\''a'\'''
json '~b|~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a|c'\'' '\''a'\'''

echo '$ json '\''~b|~a|~c'\'' '\''a'\'''
json '~b|~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a|~c'\'' '\''a'\'''

echo '$ json '\''~b|b|a'\'' '\''a'\'''
json '~b|b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b|a'\'' '\''a'\'''

echo '$ json '\''~b|b|~a'\'' '\''a'\'''
json '~b|b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b|~a'\'' '\''a'\'''

echo '$ json '\''~b|b|c'\'' '\''a'\'''
json '~b|b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b|c'\'' '\''a'\'''

echo '$ json '\''~b|b|~c'\'' '\''a'\'''
json '~b|b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b|~c'\'' '\''a'\'''

echo '$ json '\''~b|c|a'\'' '\''a'\'''
json '~b|c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c|a'\'' '\''a'\'''

echo '$ json '\''~b|c|~a'\'' '\''a'\'''
json '~b|c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c|~a'\'' '\''a'\'''

echo '$ json '\''~b|c|b'\'' '\''a'\'''
json '~b|c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c|b'\'' '\''a'\'''

echo '$ json '\''~b|c|~c'\'' '\''a'\'''
json '~b|c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c|~c'\'' '\''a'\'''

echo '$ json '\''~b|~c|a'\'' '\''a'\'''
json '~b|~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c|a'\'' '\''a'\'''

echo '$ json '\''~b|~c|~a'\'' '\''a'\'''
json '~b|~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c|~a'\'' '\''a'\'''

echo '$ json '\''~b|~c|b'\'' '\''a'\'''
json '~b|~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c|b'\'' '\''a'\'''

echo '$ json '\''~b|~c|c'\'' '\''a'\'''
json '~b|~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c|c'\'' '\''a'\'''

echo '$ json '\''c|a|~a'\'' '\''a'\'''
json 'c|a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|a|~a'\'' '\''a'\'''

echo '$ json '\''c|a|b'\'' '\''a'\'''
json 'c|a|b' 'a' 2>&1 ||
echo 'command failed: json '\''c|a|b'\'' '\''a'\'''

echo '$ json '\''c|a|~b'\'' '\''a'\'''
json 'c|a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|a|~b'\'' '\''a'\'''

echo '$ json '\''c|a|~c'\'' '\''a'\'''
json 'c|a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|a|~c'\'' '\''a'\'''

echo '$ json '\''c|~a|a'\'' '\''a'\'''
json 'c|~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a|a'\'' '\''a'\'''

echo '$ json '\''c|~a|b'\'' '\''a'\'''
json 'c|~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a|b'\'' '\''a'\'''

echo '$ json '\''c|~a|~b'\'' '\''a'\'''
json 'c|~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a|~b'\'' '\''a'\'''

echo '$ json '\''c|~a|~c'\'' '\''a'\'''
json 'c|~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a|~c'\'' '\''a'\'''

echo '$ json '\''c|b|a'\'' '\''a'\'''
json 'c|b|a' 'a' 2>&1 ||
echo 'command failed: json '\''c|b|a'\'' '\''a'\'''

echo '$ json '\''c|b|~a'\'' '\''a'\'''
json 'c|b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|b|~a'\'' '\''a'\'''

echo '$ json '\''c|b|~b'\'' '\''a'\'''
json 'c|b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|b|~b'\'' '\''a'\'''

echo '$ json '\''c|b|~c'\'' '\''a'\'''
json 'c|b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|b|~c'\'' '\''a'\'''

echo '$ json '\''c|~b|a'\'' '\''a'\'''
json 'c|~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b|a'\'' '\''a'\'''

echo '$ json '\''c|~b|~a'\'' '\''a'\'''
json 'c|~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b|~a'\'' '\''a'\'''

echo '$ json '\''c|~b|b'\'' '\''a'\'''
json 'c|~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b|b'\'' '\''a'\'''

echo '$ json '\''c|~b|~c'\'' '\''a'\'''
json 'c|~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b|~c'\'' '\''a'\'''

echo '$ json '\''c|~c|a'\'' '\''a'\'''
json 'c|~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c|a'\'' '\''a'\'''

echo '$ json '\''c|~c|~a'\'' '\''a'\'''
json 'c|~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c|~a'\'' '\''a'\'''

echo '$ json '\''c|~c|b'\'' '\''a'\'''
json 'c|~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c|b'\'' '\''a'\'''

echo '$ json '\''c|~c|~b'\'' '\''a'\'''
json 'c|~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c|~b'\'' '\''a'\'''

echo '$ json '\''~c|a|~a'\'' '\''a'\'''
json '~c|a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a|~a'\'' '\''a'\'''

echo '$ json '\''~c|a|b'\'' '\''a'\'''
json '~c|a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a|b'\'' '\''a'\'''

echo '$ json '\''~c|a|~b'\'' '\''a'\'''
json '~c|a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a|~b'\'' '\''a'\'''

echo '$ json '\''~c|a|c'\'' '\''a'\'''
json '~c|a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a|c'\'' '\''a'\'''

echo '$ json '\''~c|~a|a'\'' '\''a'\'''
json '~c|~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a|a'\'' '\''a'\'''

echo '$ json '\''~c|~a|b'\'' '\''a'\'''
json '~c|~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a|b'\'' '\''a'\'''

echo '$ json '\''~c|~a|~b'\'' '\''a'\'''
json '~c|~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a|~b'\'' '\''a'\'''

echo '$ json '\''~c|~a|c'\'' '\''a'\'''
json '~c|~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a|c'\'' '\''a'\'''

echo '$ json '\''~c|b|a'\'' '\''a'\'''
json '~c|b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b|a'\'' '\''a'\'''

echo '$ json '\''~c|b|~a'\'' '\''a'\'''
json '~c|b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b|~a'\'' '\''a'\'''

echo '$ json '\''~c|b|~b'\'' '\''a'\'''
json '~c|b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b|~b'\'' '\''a'\'''

echo '$ json '\''~c|b|c'\'' '\''a'\'''
json '~c|b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b|c'\'' '\''a'\'''

echo '$ json '\''~c|~b|a'\'' '\''a'\'''
json '~c|~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b|a'\'' '\''a'\'''

echo '$ json '\''~c|~b|~a'\'' '\''a'\'''
json '~c|~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b|~a'\'' '\''a'\'''

echo '$ json '\''~c|~b|b'\'' '\''a'\'''
json '~c|~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b|b'\'' '\''a'\'''

echo '$ json '\''~c|~b|c'\'' '\''a'\'''
json '~c|~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b|c'\'' '\''a'\'''

echo '$ json '\''~c|c|a'\'' '\''a'\'''
json '~c|c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c|a'\'' '\''a'\'''

echo '$ json '\''~c|c|~a'\'' '\''a'\'''
json '~c|c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c|~a'\'' '\''a'\'''

echo '$ json '\''~c|c|b'\'' '\''a'\'''
json '~c|c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c|b'\'' '\''a'\'''

echo '$ json '\''~c|c|~b'\'' '\''a'\'''
json '~c|c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c|~b'\'' '\''a'\'''

echo '$ json '\''a|~a||b'\'' '\''a'\'''
json 'a|~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a||b'\'' '\''a'\'''

echo '$ json '\''a|~a||~b'\'' '\''a'\'''
json 'a|~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a||~b'\'' '\''a'\'''

echo '$ json '\''a|~a||c'\'' '\''a'\'''
json 'a|~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a||c'\'' '\''a'\'''

echo '$ json '\''a|~a||~c'\'' '\''a'\'''
json 'a|~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~a||~c'\'' '\''a'\'''

echo '$ json '\''a|b||~a'\'' '\''a'\'''
json 'a|b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|b||~a'\'' '\''a'\'''

echo '$ json '\''a|b||~b'\'' '\''a'\'''
json 'a|b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|b||~b'\'' '\''a'\'''

echo '$ json '\''a|b||c'\'' '\''a'\'''
json 'a|b||c' 'a' 2>&1 ||
echo 'command failed: json '\''a|b||c'\'' '\''a'\'''

echo '$ json '\''a|b||~c'\'' '\''a'\'''
json 'a|b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|b||~c'\'' '\''a'\'''

echo '$ json '\''a|~b||~a'\'' '\''a'\'''
json 'a|~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b||~a'\'' '\''a'\'''

echo '$ json '\''a|~b||b'\'' '\''a'\'''
json 'a|~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b||b'\'' '\''a'\'''

echo '$ json '\''a|~b||c'\'' '\''a'\'''
json 'a|~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b||c'\'' '\''a'\'''

echo '$ json '\''a|~b||~c'\'' '\''a'\'''
json 'a|~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~b||~c'\'' '\''a'\'''

echo '$ json '\''a|c||~a'\'' '\''a'\'''
json 'a|c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|c||~a'\'' '\''a'\'''

echo '$ json '\''a|c||b'\'' '\''a'\'''
json 'a|c||b' 'a' 2>&1 ||
echo 'command failed: json '\''a|c||b'\'' '\''a'\'''

echo '$ json '\''a|c||~b'\'' '\''a'\'''
json 'a|c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|c||~b'\'' '\''a'\'''

echo '$ json '\''a|c||~c'\'' '\''a'\'''
json 'a|c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a|c||~c'\'' '\''a'\'''

echo '$ json '\''a|~c||~a'\'' '\''a'\'''
json 'a|~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c||~a'\'' '\''a'\'''

echo '$ json '\''a|~c||b'\'' '\''a'\'''
json 'a|~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c||b'\'' '\''a'\'''

echo '$ json '\''a|~c||~b'\'' '\''a'\'''
json 'a|~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c||~b'\'' '\''a'\'''

echo '$ json '\''a|~c||c'\'' '\''a'\'''
json 'a|~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''a|~c||c'\'' '\''a'\'''

echo '$ json '\''~a|a||b'\'' '\''a'\'''
json '~a|a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a||b'\'' '\''a'\'''

echo '$ json '\''~a|a||~b'\'' '\''a'\'''
json '~a|a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a||~b'\'' '\''a'\'''

echo '$ json '\''~a|a||c'\'' '\''a'\'''
json '~a|a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a||c'\'' '\''a'\'''

echo '$ json '\''~a|a||~c'\'' '\''a'\'''
json '~a|a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|a||~c'\'' '\''a'\'''

echo '$ json '\''~a|b||a'\'' '\''a'\'''
json '~a|b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b||a'\'' '\''a'\'''

echo '$ json '\''~a|b||~b'\'' '\''a'\'''
json '~a|b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b||~b'\'' '\''a'\'''

echo '$ json '\''~a|b||c'\'' '\''a'\'''
json '~a|b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b||c'\'' '\''a'\'''

echo '$ json '\''~a|b||~c'\'' '\''a'\'''
json '~a|b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|b||~c'\'' '\''a'\'''

echo '$ json '\''~a|~b||a'\'' '\''a'\'''
json '~a|~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b||a'\'' '\''a'\'''

echo '$ json '\''~a|~b||b'\'' '\''a'\'''
json '~a|~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b||b'\'' '\''a'\'''

echo '$ json '\''~a|~b||c'\'' '\''a'\'''
json '~a|~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b||c'\'' '\''a'\'''

echo '$ json '\''~a|~b||~c'\'' '\''a'\'''
json '~a|~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~b||~c'\'' '\''a'\'''

echo '$ json '\''~a|c||a'\'' '\''a'\'''
json '~a|c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c||a'\'' '\''a'\'''

echo '$ json '\''~a|c||b'\'' '\''a'\'''
json '~a|c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c||b'\'' '\''a'\'''

echo '$ json '\''~a|c||~b'\'' '\''a'\'''
json '~a|c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c||~b'\'' '\''a'\'''

echo '$ json '\''~a|c||~c'\'' '\''a'\'''
json '~a|c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|c||~c'\'' '\''a'\'''

echo '$ json '\''~a|~c||a'\'' '\''a'\'''
json '~a|~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c||a'\'' '\''a'\'''

echo '$ json '\''~a|~c||b'\'' '\''a'\'''
json '~a|~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c||b'\'' '\''a'\'''

echo '$ json '\''~a|~c||~b'\'' '\''a'\'''
json '~a|~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c||~b'\'' '\''a'\'''

echo '$ json '\''~a|~c||c'\'' '\''a'\'''
json '~a|~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a|~c||c'\'' '\''a'\'''

echo '$ json '\''b|a||~a'\'' '\''a'\'''
json 'b|a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|a||~a'\'' '\''a'\'''

echo '$ json '\''b|a||~b'\'' '\''a'\'''
json 'b|a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|a||~b'\'' '\''a'\'''

echo '$ json '\''b|a||c'\'' '\''a'\'''
json 'b|a||c' 'a' 2>&1 ||
echo 'command failed: json '\''b|a||c'\'' '\''a'\'''

echo '$ json '\''b|a||~c'\'' '\''a'\'''
json 'b|a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|a||~c'\'' '\''a'\'''

echo '$ json '\''b|~a||a'\'' '\''a'\'''
json 'b|~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a||a'\'' '\''a'\'''

echo '$ json '\''b|~a||~b'\'' '\''a'\'''
json 'b|~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a||~b'\'' '\''a'\'''

echo '$ json '\''b|~a||c'\'' '\''a'\'''
json 'b|~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a||c'\'' '\''a'\'''

echo '$ json '\''b|~a||~c'\'' '\''a'\'''
json 'b|~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~a||~c'\'' '\''a'\'''

echo '$ json '\''b|~b||a'\'' '\''a'\'''
json 'b|~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b||a'\'' '\''a'\'''

echo '$ json '\''b|~b||~a'\'' '\''a'\'''
json 'b|~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b||~a'\'' '\''a'\'''

echo '$ json '\''b|~b||c'\'' '\''a'\'''
json 'b|~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b||c'\'' '\''a'\'''

echo '$ json '\''b|~b||~c'\'' '\''a'\'''
json 'b|~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~b||~c'\'' '\''a'\'''

echo '$ json '\''b|c||a'\'' '\''a'\'''
json 'b|c||a' 'a' 2>&1 ||
echo 'command failed: json '\''b|c||a'\'' '\''a'\'''

echo '$ json '\''b|c||~a'\'' '\''a'\'''
json 'b|c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|c||~a'\'' '\''a'\'''

echo '$ json '\''b|c||~b'\'' '\''a'\'''
json 'b|c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|c||~b'\'' '\''a'\'''

echo '$ json '\''b|c||~c'\'' '\''a'\'''
json 'b|c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b|c||~c'\'' '\''a'\'''

echo '$ json '\''b|~c||a'\'' '\''a'\'''
json 'b|~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c||a'\'' '\''a'\'''

echo '$ json '\''b|~c||~a'\'' '\''a'\'''
json 'b|~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c||~a'\'' '\''a'\'''

echo '$ json '\''b|~c||~b'\'' '\''a'\'''
json 'b|~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c||~b'\'' '\''a'\'''

echo '$ json '\''b|~c||c'\'' '\''a'\'''
json 'b|~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''b|~c||c'\'' '\''a'\'''

echo '$ json '\''~b|a||~a'\'' '\''a'\'''
json '~b|a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a||~a'\'' '\''a'\'''

echo '$ json '\''~b|a||b'\'' '\''a'\'''
json '~b|a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a||b'\'' '\''a'\'''

echo '$ json '\''~b|a||c'\'' '\''a'\'''
json '~b|a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a||c'\'' '\''a'\'''

echo '$ json '\''~b|a||~c'\'' '\''a'\'''
json '~b|a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|a||~c'\'' '\''a'\'''

echo '$ json '\''~b|~a||a'\'' '\''a'\'''
json '~b|~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a||a'\'' '\''a'\'''

echo '$ json '\''~b|~a||b'\'' '\''a'\'''
json '~b|~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a||b'\'' '\''a'\'''

echo '$ json '\''~b|~a||c'\'' '\''a'\'''
json '~b|~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a||c'\'' '\''a'\'''

echo '$ json '\''~b|~a||~c'\'' '\''a'\'''
json '~b|~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~a||~c'\'' '\''a'\'''

echo '$ json '\''~b|b||a'\'' '\''a'\'''
json '~b|b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b||a'\'' '\''a'\'''

echo '$ json '\''~b|b||~a'\'' '\''a'\'''
json '~b|b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b||~a'\'' '\''a'\'''

echo '$ json '\''~b|b||c'\'' '\''a'\'''
json '~b|b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b||c'\'' '\''a'\'''

echo '$ json '\''~b|b||~c'\'' '\''a'\'''
json '~b|b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|b||~c'\'' '\''a'\'''

echo '$ json '\''~b|c||a'\'' '\''a'\'''
json '~b|c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c||a'\'' '\''a'\'''

echo '$ json '\''~b|c||~a'\'' '\''a'\'''
json '~b|c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c||~a'\'' '\''a'\'''

echo '$ json '\''~b|c||b'\'' '\''a'\'''
json '~b|c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c||b'\'' '\''a'\'''

echo '$ json '\''~b|c||~c'\'' '\''a'\'''
json '~b|c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|c||~c'\'' '\''a'\'''

echo '$ json '\''~b|~c||a'\'' '\''a'\'''
json '~b|~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c||a'\'' '\''a'\'''

echo '$ json '\''~b|~c||~a'\'' '\''a'\'''
json '~b|~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c||~a'\'' '\''a'\'''

echo '$ json '\''~b|~c||b'\'' '\''a'\'''
json '~b|~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c||b'\'' '\''a'\'''

echo '$ json '\''~b|~c||c'\'' '\''a'\'''
json '~b|~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b|~c||c'\'' '\''a'\'''

echo '$ json '\''c|a||~a'\'' '\''a'\'''
json 'c|a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|a||~a'\'' '\''a'\'''

echo '$ json '\''c|a||b'\'' '\''a'\'''
json 'c|a||b' 'a' 2>&1 ||
echo 'command failed: json '\''c|a||b'\'' '\''a'\'''

echo '$ json '\''c|a||~b'\'' '\''a'\'''
json 'c|a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|a||~b'\'' '\''a'\'''

echo '$ json '\''c|a||~c'\'' '\''a'\'''
json 'c|a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|a||~c'\'' '\''a'\'''

echo '$ json '\''c|~a||a'\'' '\''a'\'''
json 'c|~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a||a'\'' '\''a'\'''

echo '$ json '\''c|~a||b'\'' '\''a'\'''
json 'c|~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a||b'\'' '\''a'\'''

echo '$ json '\''c|~a||~b'\'' '\''a'\'''
json 'c|~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a||~b'\'' '\''a'\'''

echo '$ json '\''c|~a||~c'\'' '\''a'\'''
json 'c|~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~a||~c'\'' '\''a'\'''

echo '$ json '\''c|b||a'\'' '\''a'\'''
json 'c|b||a' 'a' 2>&1 ||
echo 'command failed: json '\''c|b||a'\'' '\''a'\'''

echo '$ json '\''c|b||~a'\'' '\''a'\'''
json 'c|b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|b||~a'\'' '\''a'\'''

echo '$ json '\''c|b||~b'\'' '\''a'\'''
json 'c|b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|b||~b'\'' '\''a'\'''

echo '$ json '\''c|b||~c'\'' '\''a'\'''
json 'c|b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|b||~c'\'' '\''a'\'''

echo '$ json '\''c|~b||a'\'' '\''a'\'''
json 'c|~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b||a'\'' '\''a'\'''

echo '$ json '\''c|~b||~a'\'' '\''a'\'''
json 'c|~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b||~a'\'' '\''a'\'''

echo '$ json '\''c|~b||b'\'' '\''a'\'''
json 'c|~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b||b'\'' '\''a'\'''

echo '$ json '\''c|~b||~c'\'' '\''a'\'''
json 'c|~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c|~b||~c'\'' '\''a'\'''

echo '$ json '\''c|~c||a'\'' '\''a'\'''
json 'c|~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c||a'\'' '\''a'\'''

echo '$ json '\''c|~c||~a'\'' '\''a'\'''
json 'c|~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c||~a'\'' '\''a'\'''

echo '$ json '\''c|~c||b'\'' '\''a'\'''
json 'c|~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c||b'\'' '\''a'\'''

echo '$ json '\''c|~c||~b'\'' '\''a'\'''
json 'c|~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c|~c||~b'\'' '\''a'\'''

echo '$ json '\''~c|a||~a'\'' '\''a'\'''
json '~c|a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a||~a'\'' '\''a'\'''

echo '$ json '\''~c|a||b'\'' '\''a'\'''
json '~c|a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a||b'\'' '\''a'\'''

echo '$ json '\''~c|a||~b'\'' '\''a'\'''
json '~c|a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a||~b'\'' '\''a'\'''

echo '$ json '\''~c|a||c'\'' '\''a'\'''
json '~c|a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|a||c'\'' '\''a'\'''

echo '$ json '\''~c|~a||a'\'' '\''a'\'''
json '~c|~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a||a'\'' '\''a'\'''

echo '$ json '\''~c|~a||b'\'' '\''a'\'''
json '~c|~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a||b'\'' '\''a'\'''

echo '$ json '\''~c|~a||~b'\'' '\''a'\'''
json '~c|~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a||~b'\'' '\''a'\'''

echo '$ json '\''~c|~a||c'\'' '\''a'\'''
json '~c|~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~a||c'\'' '\''a'\'''

echo '$ json '\''~c|b||a'\'' '\''a'\'''
json '~c|b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b||a'\'' '\''a'\'''

echo '$ json '\''~c|b||~a'\'' '\''a'\'''
json '~c|b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b||~a'\'' '\''a'\'''

echo '$ json '\''~c|b||~b'\'' '\''a'\'''
json '~c|b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b||~b'\'' '\''a'\'''

echo '$ json '\''~c|b||c'\'' '\''a'\'''
json '~c|b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|b||c'\'' '\''a'\'''

echo '$ json '\''~c|~b||a'\'' '\''a'\'''
json '~c|~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b||a'\'' '\''a'\'''

echo '$ json '\''~c|~b||~a'\'' '\''a'\'''
json '~c|~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b||~a'\'' '\''a'\'''

echo '$ json '\''~c|~b||b'\'' '\''a'\'''
json '~c|~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b||b'\'' '\''a'\'''

echo '$ json '\''~c|~b||c'\'' '\''a'\'''
json '~c|~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c|~b||c'\'' '\''a'\'''

echo '$ json '\''~c|c||a'\'' '\''a'\'''
json '~c|c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c||a'\'' '\''a'\'''

echo '$ json '\''~c|c||~a'\'' '\''a'\'''
json '~c|c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c||~a'\'' '\''a'\'''

echo '$ json '\''~c|c||b'\'' '\''a'\'''
json '~c|c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c||b'\'' '\''a'\'''

echo '$ json '\''~c|c||~b'\'' '\''a'\'''
json '~c|c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c|c||~b'\'' '\''a'\'''

echo '$ json '\''a||~a b'\'' '\''a'\'''
json 'a||~a b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a b'\'' '\''a'\'''

echo '$ json '\''a||~a ~b'\'' '\''a'\'''
json 'a||~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a ~b'\'' '\''a'\'''

echo '$ json '\''a||~a c'\'' '\''a'\'''
json 'a||~a c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a c'\'' '\''a'\'''

echo '$ json '\''a||~a ~c'\'' '\''a'\'''
json 'a||~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a ~c'\'' '\''a'\'''

echo '$ json '\''a||b ~a'\'' '\''a'\'''
json 'a||b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||b ~a'\'' '\''a'\'''

echo '$ json '\''a||b ~b'\'' '\''a'\'''
json 'a||b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||b ~b'\'' '\''a'\'''

echo '$ json '\''a||b c'\'' '\''a'\'''
json 'a||b c' 'a' 2>&1 ||
echo 'command failed: json '\''a||b c'\'' '\''a'\'''

echo '$ json '\''a||b ~c'\'' '\''a'\'''
json 'a||b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||b ~c'\'' '\''a'\'''

echo '$ json '\''a||~b ~a'\'' '\''a'\'''
json 'a||~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b ~a'\'' '\''a'\'''

echo '$ json '\''a||~b b'\'' '\''a'\'''
json 'a||~b b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b b'\'' '\''a'\'''

echo '$ json '\''a||~b c'\'' '\''a'\'''
json 'a||~b c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b c'\'' '\''a'\'''

echo '$ json '\''a||~b ~c'\'' '\''a'\'''
json 'a||~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b ~c'\'' '\''a'\'''

echo '$ json '\''a||c ~a'\'' '\''a'\'''
json 'a||c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||c ~a'\'' '\''a'\'''

echo '$ json '\''a||c b'\'' '\''a'\'''
json 'a||c b' 'a' 2>&1 ||
echo 'command failed: json '\''a||c b'\'' '\''a'\'''

echo '$ json '\''a||c ~b'\'' '\''a'\'''
json 'a||c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||c ~b'\'' '\''a'\'''

echo '$ json '\''a||c ~c'\'' '\''a'\'''
json 'a||c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||c ~c'\'' '\''a'\'''

echo '$ json '\''a||~c ~a'\'' '\''a'\'''
json 'a||~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c ~a'\'' '\''a'\'''

echo '$ json '\''a||~c b'\'' '\''a'\'''
json 'a||~c b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c b'\'' '\''a'\'''

echo '$ json '\''a||~c ~b'\'' '\''a'\'''
json 'a||~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c ~b'\'' '\''a'\'''

echo '$ json '\''a||~c c'\'' '\''a'\'''
json 'a||~c c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c c'\'' '\''a'\'''

echo '$ json '\''~a||a b'\'' '\''a'\'''
json '~a||a b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a b'\'' '\''a'\'''

echo '$ json '\''~a||a ~b'\'' '\''a'\'''
json '~a||a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a ~b'\'' '\''a'\'''

echo '$ json '\''~a||a c'\'' '\''a'\'''
json '~a||a c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a c'\'' '\''a'\'''

echo '$ json '\''~a||a ~c'\'' '\''a'\'''
json '~a||a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a ~c'\'' '\''a'\'''

echo '$ json '\''~a||b a'\'' '\''a'\'''
json '~a||b a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b a'\'' '\''a'\'''

echo '$ json '\''~a||b ~b'\'' '\''a'\'''
json '~a||b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b ~b'\'' '\''a'\'''

echo '$ json '\''~a||b c'\'' '\''a'\'''
json '~a||b c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b c'\'' '\''a'\'''

echo '$ json '\''~a||b ~c'\'' '\''a'\'''
json '~a||b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b ~c'\'' '\''a'\'''

echo '$ json '\''~a||~b a'\'' '\''a'\'''
json '~a||~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b a'\'' '\''a'\'''

echo '$ json '\''~a||~b b'\'' '\''a'\'''
json '~a||~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b b'\'' '\''a'\'''

echo '$ json '\''~a||~b c'\'' '\''a'\'''
json '~a||~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b c'\'' '\''a'\'''

echo '$ json '\''~a||~b ~c'\'' '\''a'\'''
json '~a||~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b ~c'\'' '\''a'\'''

echo '$ json '\''~a||c a'\'' '\''a'\'''
json '~a||c a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c a'\'' '\''a'\'''

echo '$ json '\''~a||c b'\'' '\''a'\'''
json '~a||c b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c b'\'' '\''a'\'''

echo '$ json '\''~a||c ~b'\'' '\''a'\'''
json '~a||c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c ~b'\'' '\''a'\'''

echo '$ json '\''~a||c ~c'\'' '\''a'\'''
json '~a||c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c ~c'\'' '\''a'\'''

echo '$ json '\''~a||~c a'\'' '\''a'\'''
json '~a||~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c a'\'' '\''a'\'''

echo '$ json '\''~a||~c b'\'' '\''a'\'''
json '~a||~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c b'\'' '\''a'\'''

echo '$ json '\''~a||~c ~b'\'' '\''a'\'''
json '~a||~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c ~b'\'' '\''a'\'''

echo '$ json '\''~a||~c c'\'' '\''a'\'''
json '~a||~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c c'\'' '\''a'\'''

echo '$ json '\''b||a ~a'\'' '\''a'\'''
json 'b||a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||a ~a'\'' '\''a'\'''

echo '$ json '\''b||a ~b'\'' '\''a'\'''
json 'b||a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||a ~b'\'' '\''a'\'''

echo '$ json '\''b||a c'\'' '\''a'\'''
json 'b||a c' 'a' 2>&1 ||
echo 'command failed: json '\''b||a c'\'' '\''a'\'''

echo '$ json '\''b||a ~c'\'' '\''a'\'''
json 'b||a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||a ~c'\'' '\''a'\'''

echo '$ json '\''b||~a a'\'' '\''a'\'''
json 'b||~a a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a a'\'' '\''a'\'''

echo '$ json '\''b||~a ~b'\'' '\''a'\'''
json 'b||~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a ~b'\'' '\''a'\'''

echo '$ json '\''b||~a c'\'' '\''a'\'''
json 'b||~a c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a c'\'' '\''a'\'''

echo '$ json '\''b||~a ~c'\'' '\''a'\'''
json 'b||~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a ~c'\'' '\''a'\'''

echo '$ json '\''b||~b a'\'' '\''a'\'''
json 'b||~b a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b a'\'' '\''a'\'''

echo '$ json '\''b||~b ~a'\'' '\''a'\'''
json 'b||~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b ~a'\'' '\''a'\'''

echo '$ json '\''b||~b c'\'' '\''a'\'''
json 'b||~b c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b c'\'' '\''a'\'''

echo '$ json '\''b||~b ~c'\'' '\''a'\'''
json 'b||~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b ~c'\'' '\''a'\'''

echo '$ json '\''b||c a'\'' '\''a'\'''
json 'b||c a' 'a' 2>&1 ||
echo 'command failed: json '\''b||c a'\'' '\''a'\'''

echo '$ json '\''b||c ~a'\'' '\''a'\'''
json 'b||c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||c ~a'\'' '\''a'\'''

echo '$ json '\''b||c ~b'\'' '\''a'\'''
json 'b||c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||c ~b'\'' '\''a'\'''

echo '$ json '\''b||c ~c'\'' '\''a'\'''
json 'b||c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||c ~c'\'' '\''a'\'''

echo '$ json '\''b||~c a'\'' '\''a'\'''
json 'b||~c a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c a'\'' '\''a'\'''

echo '$ json '\''b||~c ~a'\'' '\''a'\'''
json 'b||~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c ~a'\'' '\''a'\'''

echo '$ json '\''b||~c ~b'\'' '\''a'\'''
json 'b||~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c ~b'\'' '\''a'\'''

echo '$ json '\''b||~c c'\'' '\''a'\'''
json 'b||~c c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c c'\'' '\''a'\'''

echo '$ json '\''~b||a ~a'\'' '\''a'\'''
json '~b||a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a ~a'\'' '\''a'\'''

echo '$ json '\''~b||a b'\'' '\''a'\'''
json '~b||a b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a b'\'' '\''a'\'''

echo '$ json '\''~b||a c'\'' '\''a'\'''
json '~b||a c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a c'\'' '\''a'\'''

echo '$ json '\''~b||a ~c'\'' '\''a'\'''
json '~b||a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a ~c'\'' '\''a'\'''

echo '$ json '\''~b||~a a'\'' '\''a'\'''
json '~b||~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a a'\'' '\''a'\'''

echo '$ json '\''~b||~a b'\'' '\''a'\'''
json '~b||~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a b'\'' '\''a'\'''

echo '$ json '\''~b||~a c'\'' '\''a'\'''
json '~b||~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a c'\'' '\''a'\'''

echo '$ json '\''~b||~a ~c'\'' '\''a'\'''
json '~b||~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a ~c'\'' '\''a'\'''

echo '$ json '\''~b||b a'\'' '\''a'\'''
json '~b||b a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b a'\'' '\''a'\'''

echo '$ json '\''~b||b ~a'\'' '\''a'\'''
json '~b||b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b ~a'\'' '\''a'\'''

echo '$ json '\''~b||b c'\'' '\''a'\'''
json '~b||b c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b c'\'' '\''a'\'''

echo '$ json '\''~b||b ~c'\'' '\''a'\'''
json '~b||b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b ~c'\'' '\''a'\'''

echo '$ json '\''~b||c a'\'' '\''a'\'''
json '~b||c a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c a'\'' '\''a'\'''

echo '$ json '\''~b||c ~a'\'' '\''a'\'''
json '~b||c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c ~a'\'' '\''a'\'''

echo '$ json '\''~b||c b'\'' '\''a'\'''
json '~b||c b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c b'\'' '\''a'\'''

echo '$ json '\''~b||c ~c'\'' '\''a'\'''
json '~b||c ~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c ~c'\'' '\''a'\'''

echo '$ json '\''~b||~c a'\'' '\''a'\'''
json '~b||~c a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c a'\'' '\''a'\'''

echo '$ json '\''~b||~c ~a'\'' '\''a'\'''
json '~b||~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c ~a'\'' '\''a'\'''

echo '$ json '\''~b||~c b'\'' '\''a'\'''
json '~b||~c b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c b'\'' '\''a'\'''

echo '$ json '\''~b||~c c'\'' '\''a'\'''
json '~b||~c c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c c'\'' '\''a'\'''

echo '$ json '\''c||a ~a'\'' '\''a'\'''
json 'c||a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||a ~a'\'' '\''a'\'''

echo '$ json '\''c||a b'\'' '\''a'\'''
json 'c||a b' 'a' 2>&1 ||
echo 'command failed: json '\''c||a b'\'' '\''a'\'''

echo '$ json '\''c||a ~b'\'' '\''a'\'''
json 'c||a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||a ~b'\'' '\''a'\'''

echo '$ json '\''c||a ~c'\'' '\''a'\'''
json 'c||a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||a ~c'\'' '\''a'\'''

echo '$ json '\''c||~a a'\'' '\''a'\'''
json 'c||~a a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a a'\'' '\''a'\'''

echo '$ json '\''c||~a b'\'' '\''a'\'''
json 'c||~a b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a b'\'' '\''a'\'''

echo '$ json '\''c||~a ~b'\'' '\''a'\'''
json 'c||~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a ~b'\'' '\''a'\'''

echo '$ json '\''c||~a ~c'\'' '\''a'\'''
json 'c||~a ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a ~c'\'' '\''a'\'''

echo '$ json '\''c||b a'\'' '\''a'\'''
json 'c||b a' 'a' 2>&1 ||
echo 'command failed: json '\''c||b a'\'' '\''a'\'''

echo '$ json '\''c||b ~a'\'' '\''a'\'''
json 'c||b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||b ~a'\'' '\''a'\'''

echo '$ json '\''c||b ~b'\'' '\''a'\'''
json 'c||b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||b ~b'\'' '\''a'\'''

echo '$ json '\''c||b ~c'\'' '\''a'\'''
json 'c||b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||b ~c'\'' '\''a'\'''

echo '$ json '\''c||~b a'\'' '\''a'\'''
json 'c||~b a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b a'\'' '\''a'\'''

echo '$ json '\''c||~b ~a'\'' '\''a'\'''
json 'c||~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b ~a'\'' '\''a'\'''

echo '$ json '\''c||~b b'\'' '\''a'\'''
json 'c||~b b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b b'\'' '\''a'\'''

echo '$ json '\''c||~b ~c'\'' '\''a'\'''
json 'c||~b ~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b ~c'\'' '\''a'\'''

echo '$ json '\''c||~c a'\'' '\''a'\'''
json 'c||~c a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c a'\'' '\''a'\'''

echo '$ json '\''c||~c ~a'\'' '\''a'\'''
json 'c||~c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c ~a'\'' '\''a'\'''

echo '$ json '\''c||~c b'\'' '\''a'\'''
json 'c||~c b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c b'\'' '\''a'\'''

echo '$ json '\''c||~c ~b'\'' '\''a'\'''
json 'c||~c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c ~b'\'' '\''a'\'''

echo '$ json '\''~c||a ~a'\'' '\''a'\'''
json '~c||a ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a ~a'\'' '\''a'\'''

echo '$ json '\''~c||a b'\'' '\''a'\'''
json '~c||a b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a b'\'' '\''a'\'''

echo '$ json '\''~c||a ~b'\'' '\''a'\'''
json '~c||a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a ~b'\'' '\''a'\'''

echo '$ json '\''~c||a c'\'' '\''a'\'''
json '~c||a c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a c'\'' '\''a'\'''

echo '$ json '\''~c||~a a'\'' '\''a'\'''
json '~c||~a a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a a'\'' '\''a'\'''

echo '$ json '\''~c||~a b'\'' '\''a'\'''
json '~c||~a b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a b'\'' '\''a'\'''

echo '$ json '\''~c||~a ~b'\'' '\''a'\'''
json '~c||~a ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a ~b'\'' '\''a'\'''

echo '$ json '\''~c||~a c'\'' '\''a'\'''
json '~c||~a c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a c'\'' '\''a'\'''

echo '$ json '\''~c||b a'\'' '\''a'\'''
json '~c||b a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b a'\'' '\''a'\'''

echo '$ json '\''~c||b ~a'\'' '\''a'\'''
json '~c||b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b ~a'\'' '\''a'\'''

echo '$ json '\''~c||b ~b'\'' '\''a'\'''
json '~c||b ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b ~b'\'' '\''a'\'''

echo '$ json '\''~c||b c'\'' '\''a'\'''
json '~c||b c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b c'\'' '\''a'\'''

echo '$ json '\''~c||~b a'\'' '\''a'\'''
json '~c||~b a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b a'\'' '\''a'\'''

echo '$ json '\''~c||~b ~a'\'' '\''a'\'''
json '~c||~b ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b ~a'\'' '\''a'\'''

echo '$ json '\''~c||~b b'\'' '\''a'\'''
json '~c||~b b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b b'\'' '\''a'\'''

echo '$ json '\''~c||~b c'\'' '\''a'\'''
json '~c||~b c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b c'\'' '\''a'\'''

echo '$ json '\''~c||c a'\'' '\''a'\'''
json '~c||c a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c a'\'' '\''a'\'''

echo '$ json '\''~c||c ~a'\'' '\''a'\'''
json '~c||c ~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c ~a'\'' '\''a'\'''

echo '$ json '\''~c||c b'\'' '\''a'\'''
json '~c||c b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c b'\'' '\''a'\'''

echo '$ json '\''~c||c ~b'\'' '\''a'\'''
json '~c||c ~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c ~b'\'' '\''a'\'''

echo '$ json '\''a||~a|b'\'' '\''a'\'''
json 'a||~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a|b'\'' '\''a'\'''

echo '$ json '\''a||~a|~b'\'' '\''a'\'''
json 'a||~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a|~b'\'' '\''a'\'''

echo '$ json '\''a||~a|c'\'' '\''a'\'''
json 'a||~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a|c'\'' '\''a'\'''

echo '$ json '\''a||~a|~c'\'' '\''a'\'''
json 'a||~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a|~c'\'' '\''a'\'''

echo '$ json '\''a||b|~a'\'' '\''a'\'''
json 'a||b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||b|~a'\'' '\''a'\'''

echo '$ json '\''a||b|~b'\'' '\''a'\'''
json 'a||b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||b|~b'\'' '\''a'\'''

echo '$ json '\''a||b|c'\'' '\''a'\'''
json 'a||b|c' 'a' 2>&1 ||
echo 'command failed: json '\''a||b|c'\'' '\''a'\'''

echo '$ json '\''a||b|~c'\'' '\''a'\'''
json 'a||b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||b|~c'\'' '\''a'\'''

echo '$ json '\''a||~b|~a'\'' '\''a'\'''
json 'a||~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b|~a'\'' '\''a'\'''

echo '$ json '\''a||~b|b'\'' '\''a'\'''
json 'a||~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b|b'\'' '\''a'\'''

echo '$ json '\''a||~b|c'\'' '\''a'\'''
json 'a||~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b|c'\'' '\''a'\'''

echo '$ json '\''a||~b|~c'\'' '\''a'\'''
json 'a||~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b|~c'\'' '\''a'\'''

echo '$ json '\''a||c|~a'\'' '\''a'\'''
json 'a||c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||c|~a'\'' '\''a'\'''

echo '$ json '\''a||c|b'\'' '\''a'\'''
json 'a||c|b' 'a' 2>&1 ||
echo 'command failed: json '\''a||c|b'\'' '\''a'\'''

echo '$ json '\''a||c|~b'\'' '\''a'\'''
json 'a||c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||c|~b'\'' '\''a'\'''

echo '$ json '\''a||c|~c'\'' '\''a'\'''
json 'a||c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||c|~c'\'' '\''a'\'''

echo '$ json '\''a||~c|~a'\'' '\''a'\'''
json 'a||~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c|~a'\'' '\''a'\'''

echo '$ json '\''a||~c|b'\'' '\''a'\'''
json 'a||~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c|b'\'' '\''a'\'''

echo '$ json '\''a||~c|~b'\'' '\''a'\'''
json 'a||~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c|~b'\'' '\''a'\'''

echo '$ json '\''a||~c|c'\'' '\''a'\'''
json 'a||~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c|c'\'' '\''a'\'''

echo '$ json '\''~a||a|b'\'' '\''a'\'''
json '~a||a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a|b'\'' '\''a'\'''

echo '$ json '\''~a||a|~b'\'' '\''a'\'''
json '~a||a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a|~b'\'' '\''a'\'''

echo '$ json '\''~a||a|c'\'' '\''a'\'''
json '~a||a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a|c'\'' '\''a'\'''

echo '$ json '\''~a||a|~c'\'' '\''a'\'''
json '~a||a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a|~c'\'' '\''a'\'''

echo '$ json '\''~a||b|a'\'' '\''a'\'''
json '~a||b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b|a'\'' '\''a'\'''

echo '$ json '\''~a||b|~b'\'' '\''a'\'''
json '~a||b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b|~b'\'' '\''a'\'''

echo '$ json '\''~a||b|c'\'' '\''a'\'''
json '~a||b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b|c'\'' '\''a'\'''

echo '$ json '\''~a||b|~c'\'' '\''a'\'''
json '~a||b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b|~c'\'' '\''a'\'''

echo '$ json '\''~a||~b|a'\'' '\''a'\'''
json '~a||~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b|a'\'' '\''a'\'''

echo '$ json '\''~a||~b|b'\'' '\''a'\'''
json '~a||~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b|b'\'' '\''a'\'''

echo '$ json '\''~a||~b|c'\'' '\''a'\'''
json '~a||~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b|c'\'' '\''a'\'''

echo '$ json '\''~a||~b|~c'\'' '\''a'\'''
json '~a||~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b|~c'\'' '\''a'\'''

echo '$ json '\''~a||c|a'\'' '\''a'\'''
json '~a||c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c|a'\'' '\''a'\'''

echo '$ json '\''~a||c|b'\'' '\''a'\'''
json '~a||c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c|b'\'' '\''a'\'''

echo '$ json '\''~a||c|~b'\'' '\''a'\'''
json '~a||c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c|~b'\'' '\''a'\'''

echo '$ json '\''~a||c|~c'\'' '\''a'\'''
json '~a||c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c|~c'\'' '\''a'\'''

echo '$ json '\''~a||~c|a'\'' '\''a'\'''
json '~a||~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c|a'\'' '\''a'\'''

echo '$ json '\''~a||~c|b'\'' '\''a'\'''
json '~a||~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c|b'\'' '\''a'\'''

echo '$ json '\''~a||~c|~b'\'' '\''a'\'''
json '~a||~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c|~b'\'' '\''a'\'''

echo '$ json '\''~a||~c|c'\'' '\''a'\'''
json '~a||~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c|c'\'' '\''a'\'''

echo '$ json '\''b||a|~a'\'' '\''a'\'''
json 'b||a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||a|~a'\'' '\''a'\'''

echo '$ json '\''b||a|~b'\'' '\''a'\'''
json 'b||a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||a|~b'\'' '\''a'\'''

echo '$ json '\''b||a|c'\'' '\''a'\'''
json 'b||a|c' 'a' 2>&1 ||
echo 'command failed: json '\''b||a|c'\'' '\''a'\'''

echo '$ json '\''b||a|~c'\'' '\''a'\'''
json 'b||a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||a|~c'\'' '\''a'\'''

echo '$ json '\''b||~a|a'\'' '\''a'\'''
json 'b||~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a|a'\'' '\''a'\'''

echo '$ json '\''b||~a|~b'\'' '\''a'\'''
json 'b||~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a|~b'\'' '\''a'\'''

echo '$ json '\''b||~a|c'\'' '\''a'\'''
json 'b||~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a|c'\'' '\''a'\'''

echo '$ json '\''b||~a|~c'\'' '\''a'\'''
json 'b||~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a|~c'\'' '\''a'\'''

echo '$ json '\''b||~b|a'\'' '\''a'\'''
json 'b||~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b|a'\'' '\''a'\'''

echo '$ json '\''b||~b|~a'\'' '\''a'\'''
json 'b||~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b|~a'\'' '\''a'\'''

echo '$ json '\''b||~b|c'\'' '\''a'\'''
json 'b||~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b|c'\'' '\''a'\'''

echo '$ json '\''b||~b|~c'\'' '\''a'\'''
json 'b||~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b|~c'\'' '\''a'\'''

echo '$ json '\''b||c|a'\'' '\''a'\'''
json 'b||c|a' 'a' 2>&1 ||
echo 'command failed: json '\''b||c|a'\'' '\''a'\'''

echo '$ json '\''b||c|~a'\'' '\''a'\'''
json 'b||c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||c|~a'\'' '\''a'\'''

echo '$ json '\''b||c|~b'\'' '\''a'\'''
json 'b||c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||c|~b'\'' '\''a'\'''

echo '$ json '\''b||c|~c'\'' '\''a'\'''
json 'b||c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||c|~c'\'' '\''a'\'''

echo '$ json '\''b||~c|a'\'' '\''a'\'''
json 'b||~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c|a'\'' '\''a'\'''

echo '$ json '\''b||~c|~a'\'' '\''a'\'''
json 'b||~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c|~a'\'' '\''a'\'''

echo '$ json '\''b||~c|~b'\'' '\''a'\'''
json 'b||~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c|~b'\'' '\''a'\'''

echo '$ json '\''b||~c|c'\'' '\''a'\'''
json 'b||~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c|c'\'' '\''a'\'''

echo '$ json '\''~b||a|~a'\'' '\''a'\'''
json '~b||a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a|~a'\'' '\''a'\'''

echo '$ json '\''~b||a|b'\'' '\''a'\'''
json '~b||a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a|b'\'' '\''a'\'''

echo '$ json '\''~b||a|c'\'' '\''a'\'''
json '~b||a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a|c'\'' '\''a'\'''

echo '$ json '\''~b||a|~c'\'' '\''a'\'''
json '~b||a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a|~c'\'' '\''a'\'''

echo '$ json '\''~b||~a|a'\'' '\''a'\'''
json '~b||~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a|a'\'' '\''a'\'''

echo '$ json '\''~b||~a|b'\'' '\''a'\'''
json '~b||~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a|b'\'' '\''a'\'''

echo '$ json '\''~b||~a|c'\'' '\''a'\'''
json '~b||~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a|c'\'' '\''a'\'''

echo '$ json '\''~b||~a|~c'\'' '\''a'\'''
json '~b||~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a|~c'\'' '\''a'\'''

echo '$ json '\''~b||b|a'\'' '\''a'\'''
json '~b||b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b|a'\'' '\''a'\'''

echo '$ json '\''~b||b|~a'\'' '\''a'\'''
json '~b||b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b|~a'\'' '\''a'\'''

echo '$ json '\''~b||b|c'\'' '\''a'\'''
json '~b||b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b|c'\'' '\''a'\'''

echo '$ json '\''~b||b|~c'\'' '\''a'\'''
json '~b||b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b|~c'\'' '\''a'\'''

echo '$ json '\''~b||c|a'\'' '\''a'\'''
json '~b||c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c|a'\'' '\''a'\'''

echo '$ json '\''~b||c|~a'\'' '\''a'\'''
json '~b||c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c|~a'\'' '\''a'\'''

echo '$ json '\''~b||c|b'\'' '\''a'\'''
json '~b||c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c|b'\'' '\''a'\'''

echo '$ json '\''~b||c|~c'\'' '\''a'\'''
json '~b||c|~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c|~c'\'' '\''a'\'''

echo '$ json '\''~b||~c|a'\'' '\''a'\'''
json '~b||~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c|a'\'' '\''a'\'''

echo '$ json '\''~b||~c|~a'\'' '\''a'\'''
json '~b||~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c|~a'\'' '\''a'\'''

echo '$ json '\''~b||~c|b'\'' '\''a'\'''
json '~b||~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c|b'\'' '\''a'\'''

echo '$ json '\''~b||~c|c'\'' '\''a'\'''
json '~b||~c|c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c|c'\'' '\''a'\'''

echo '$ json '\''c||a|~a'\'' '\''a'\'''
json 'c||a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||a|~a'\'' '\''a'\'''

echo '$ json '\''c||a|b'\'' '\''a'\'''
json 'c||a|b' 'a' 2>&1 ||
echo 'command failed: json '\''c||a|b'\'' '\''a'\'''

echo '$ json '\''c||a|~b'\'' '\''a'\'''
json 'c||a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||a|~b'\'' '\''a'\'''

echo '$ json '\''c||a|~c'\'' '\''a'\'''
json 'c||a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||a|~c'\'' '\''a'\'''

echo '$ json '\''c||~a|a'\'' '\''a'\'''
json 'c||~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a|a'\'' '\''a'\'''

echo '$ json '\''c||~a|b'\'' '\''a'\'''
json 'c||~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a|b'\'' '\''a'\'''

echo '$ json '\''c||~a|~b'\'' '\''a'\'''
json 'c||~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a|~b'\'' '\''a'\'''

echo '$ json '\''c||~a|~c'\'' '\''a'\'''
json 'c||~a|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a|~c'\'' '\''a'\'''

echo '$ json '\''c||b|a'\'' '\''a'\'''
json 'c||b|a' 'a' 2>&1 ||
echo 'command failed: json '\''c||b|a'\'' '\''a'\'''

echo '$ json '\''c||b|~a'\'' '\''a'\'''
json 'c||b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||b|~a'\'' '\''a'\'''

echo '$ json '\''c||b|~b'\'' '\''a'\'''
json 'c||b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||b|~b'\'' '\''a'\'''

echo '$ json '\''c||b|~c'\'' '\''a'\'''
json 'c||b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||b|~c'\'' '\''a'\'''

echo '$ json '\''c||~b|a'\'' '\''a'\'''
json 'c||~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b|a'\'' '\''a'\'''

echo '$ json '\''c||~b|~a'\'' '\''a'\'''
json 'c||~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b|~a'\'' '\''a'\'''

echo '$ json '\''c||~b|b'\'' '\''a'\'''
json 'c||~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b|b'\'' '\''a'\'''

echo '$ json '\''c||~b|~c'\'' '\''a'\'''
json 'c||~b|~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b|~c'\'' '\''a'\'''

echo '$ json '\''c||~c|a'\'' '\''a'\'''
json 'c||~c|a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c|a'\'' '\''a'\'''

echo '$ json '\''c||~c|~a'\'' '\''a'\'''
json 'c||~c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c|~a'\'' '\''a'\'''

echo '$ json '\''c||~c|b'\'' '\''a'\'''
json 'c||~c|b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c|b'\'' '\''a'\'''

echo '$ json '\''c||~c|~b'\'' '\''a'\'''
json 'c||~c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c|~b'\'' '\''a'\'''

echo '$ json '\''~c||a|~a'\'' '\''a'\'''
json '~c||a|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a|~a'\'' '\''a'\'''

echo '$ json '\''~c||a|b'\'' '\''a'\'''
json '~c||a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a|b'\'' '\''a'\'''

echo '$ json '\''~c||a|~b'\'' '\''a'\'''
json '~c||a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a|~b'\'' '\''a'\'''

echo '$ json '\''~c||a|c'\'' '\''a'\'''
json '~c||a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a|c'\'' '\''a'\'''

echo '$ json '\''~c||~a|a'\'' '\''a'\'''
json '~c||~a|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a|a'\'' '\''a'\'''

echo '$ json '\''~c||~a|b'\'' '\''a'\'''
json '~c||~a|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a|b'\'' '\''a'\'''

echo '$ json '\''~c||~a|~b'\'' '\''a'\'''
json '~c||~a|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a|~b'\'' '\''a'\'''

echo '$ json '\''~c||~a|c'\'' '\''a'\'''
json '~c||~a|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a|c'\'' '\''a'\'''

echo '$ json '\''~c||b|a'\'' '\''a'\'''
json '~c||b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b|a'\'' '\''a'\'''

echo '$ json '\''~c||b|~a'\'' '\''a'\'''
json '~c||b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b|~a'\'' '\''a'\'''

echo '$ json '\''~c||b|~b'\'' '\''a'\'''
json '~c||b|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b|~b'\'' '\''a'\'''

echo '$ json '\''~c||b|c'\'' '\''a'\'''
json '~c||b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b|c'\'' '\''a'\'''

echo '$ json '\''~c||~b|a'\'' '\''a'\'''
json '~c||~b|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b|a'\'' '\''a'\'''

echo '$ json '\''~c||~b|~a'\'' '\''a'\'''
json '~c||~b|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b|~a'\'' '\''a'\'''

echo '$ json '\''~c||~b|b'\'' '\''a'\'''
json '~c||~b|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b|b'\'' '\''a'\'''

echo '$ json '\''~c||~b|c'\'' '\''a'\'''
json '~c||~b|c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b|c'\'' '\''a'\'''

echo '$ json '\''~c||c|a'\'' '\''a'\'''
json '~c||c|a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c|a'\'' '\''a'\'''

echo '$ json '\''~c||c|~a'\'' '\''a'\'''
json '~c||c|~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c|~a'\'' '\''a'\'''

echo '$ json '\''~c||c|b'\'' '\''a'\'''
json '~c||c|b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c|b'\'' '\''a'\'''

echo '$ json '\''~c||c|~b'\'' '\''a'\'''
json '~c||c|~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c|~b'\'' '\''a'\'''

echo '$ json '\''a||~a||b'\'' '\''a'\'''
json 'a||~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a||b'\'' '\''a'\'''

echo '$ json '\''a||~a||~b'\'' '\''a'\'''
json 'a||~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a||~b'\'' '\''a'\'''

echo '$ json '\''a||~a||c'\'' '\''a'\'''
json 'a||~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a||c'\'' '\''a'\'''

echo '$ json '\''a||~a||~c'\'' '\''a'\'''
json 'a||~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~a||~c'\'' '\''a'\'''

echo '$ json '\''a||b||~a'\'' '\''a'\'''
json 'a||b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||b||~a'\'' '\''a'\'''

echo '$ json '\''a||b||~b'\'' '\''a'\'''
json 'a||b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||b||~b'\'' '\''a'\'''

echo '$ json '\''a||b||c'\'' '\''a'\'''
json 'a||b||c' 'a' 2>&1 ||
echo 'command failed: json '\''a||b||c'\'' '\''a'\'''

echo '$ json '\''a||b||~c'\'' '\''a'\'''
json 'a||b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||b||~c'\'' '\''a'\'''

echo '$ json '\''a||~b||~a'\'' '\''a'\'''
json 'a||~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b||~a'\'' '\''a'\'''

echo '$ json '\''a||~b||b'\'' '\''a'\'''
json 'a||~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b||b'\'' '\''a'\'''

echo '$ json '\''a||~b||c'\'' '\''a'\'''
json 'a||~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b||c'\'' '\''a'\'''

echo '$ json '\''a||~b||~c'\'' '\''a'\'''
json 'a||~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~b||~c'\'' '\''a'\'''

echo '$ json '\''a||c||~a'\'' '\''a'\'''
json 'a||c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||c||~a'\'' '\''a'\'''

echo '$ json '\''a||c||b'\'' '\''a'\'''
json 'a||c||b' 'a' 2>&1 ||
echo 'command failed: json '\''a||c||b'\'' '\''a'\'''

echo '$ json '\''a||c||~b'\'' '\''a'\'''
json 'a||c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||c||~b'\'' '\''a'\'''

echo '$ json '\''a||c||~c'\'' '\''a'\'''
json 'a||c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''a||c||~c'\'' '\''a'\'''

echo '$ json '\''a||~c||~a'\'' '\''a'\'''
json 'a||~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c||~a'\'' '\''a'\'''

echo '$ json '\''a||~c||b'\'' '\''a'\'''
json 'a||~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c||b'\'' '\''a'\'''

echo '$ json '\''a||~c||~b'\'' '\''a'\'''
json 'a||~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c||~b'\'' '\''a'\'''

echo '$ json '\''a||~c||c'\'' '\''a'\'''
json 'a||~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''a||~c||c'\'' '\''a'\'''

echo '$ json '\''~a||a||b'\'' '\''a'\'''
json '~a||a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a||b'\'' '\''a'\'''

echo '$ json '\''~a||a||~b'\'' '\''a'\'''
json '~a||a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a||~b'\'' '\''a'\'''

echo '$ json '\''~a||a||c'\'' '\''a'\'''
json '~a||a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a||c'\'' '\''a'\'''

echo '$ json '\''~a||a||~c'\'' '\''a'\'''
json '~a||a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||a||~c'\'' '\''a'\'''

echo '$ json '\''~a||b||a'\'' '\''a'\'''
json '~a||b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b||a'\'' '\''a'\'''

echo '$ json '\''~a||b||~b'\'' '\''a'\'''
json '~a||b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b||~b'\'' '\''a'\'''

echo '$ json '\''~a||b||c'\'' '\''a'\'''
json '~a||b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b||c'\'' '\''a'\'''

echo '$ json '\''~a||b||~c'\'' '\''a'\'''
json '~a||b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||b||~c'\'' '\''a'\'''

echo '$ json '\''~a||~b||a'\'' '\''a'\'''
json '~a||~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b||a'\'' '\''a'\'''

echo '$ json '\''~a||~b||b'\'' '\''a'\'''
json '~a||~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b||b'\'' '\''a'\'''

echo '$ json '\''~a||~b||c'\'' '\''a'\'''
json '~a||~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b||c'\'' '\''a'\'''

echo '$ json '\''~a||~b||~c'\'' '\''a'\'''
json '~a||~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~b||~c'\'' '\''a'\'''

echo '$ json '\''~a||c||a'\'' '\''a'\'''
json '~a||c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c||a'\'' '\''a'\'''

echo '$ json '\''~a||c||b'\'' '\''a'\'''
json '~a||c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c||b'\'' '\''a'\'''

echo '$ json '\''~a||c||~b'\'' '\''a'\'''
json '~a||c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c||~b'\'' '\''a'\'''

echo '$ json '\''~a||c||~c'\'' '\''a'\'''
json '~a||c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||c||~c'\'' '\''a'\'''

echo '$ json '\''~a||~c||a'\'' '\''a'\'''
json '~a||~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c||a'\'' '\''a'\'''

echo '$ json '\''~a||~c||b'\'' '\''a'\'''
json '~a||~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c||b'\'' '\''a'\'''

echo '$ json '\''~a||~c||~b'\'' '\''a'\'''
json '~a||~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c||~b'\'' '\''a'\'''

echo '$ json '\''~a||~c||c'\'' '\''a'\'''
json '~a||~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~a||~c||c'\'' '\''a'\'''

echo '$ json '\''b||a||~a'\'' '\''a'\'''
json 'b||a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||a||~a'\'' '\''a'\'''

echo '$ json '\''b||a||~b'\'' '\''a'\'''
json 'b||a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||a||~b'\'' '\''a'\'''

echo '$ json '\''b||a||c'\'' '\''a'\'''
json 'b||a||c' 'a' 2>&1 ||
echo 'command failed: json '\''b||a||c'\'' '\''a'\'''

echo '$ json '\''b||a||~c'\'' '\''a'\'''
json 'b||a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||a||~c'\'' '\''a'\'''

echo '$ json '\''b||~a||a'\'' '\''a'\'''
json 'b||~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a||a'\'' '\''a'\'''

echo '$ json '\''b||~a||~b'\'' '\''a'\'''
json 'b||~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a||~b'\'' '\''a'\'''

echo '$ json '\''b||~a||c'\'' '\''a'\'''
json 'b||~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a||c'\'' '\''a'\'''

echo '$ json '\''b||~a||~c'\'' '\''a'\'''
json 'b||~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~a||~c'\'' '\''a'\'''

echo '$ json '\''b||~b||a'\'' '\''a'\'''
json 'b||~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b||a'\'' '\''a'\'''

echo '$ json '\''b||~b||~a'\'' '\''a'\'''
json 'b||~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b||~a'\'' '\''a'\'''

echo '$ json '\''b||~b||c'\'' '\''a'\'''
json 'b||~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b||c'\'' '\''a'\'''

echo '$ json '\''b||~b||~c'\'' '\''a'\'''
json 'b||~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~b||~c'\'' '\''a'\'''

echo '$ json '\''b||c||a'\'' '\''a'\'''
json 'b||c||a' 'a' 2>&1 ||
echo 'command failed: json '\''b||c||a'\'' '\''a'\'''

echo '$ json '\''b||c||~a'\'' '\''a'\'''
json 'b||c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||c||~a'\'' '\''a'\'''

echo '$ json '\''b||c||~b'\'' '\''a'\'''
json 'b||c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||c||~b'\'' '\''a'\'''

echo '$ json '\''b||c||~c'\'' '\''a'\'''
json 'b||c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''b||c||~c'\'' '\''a'\'''

echo '$ json '\''b||~c||a'\'' '\''a'\'''
json 'b||~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c||a'\'' '\''a'\'''

echo '$ json '\''b||~c||~a'\'' '\''a'\'''
json 'b||~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c||~a'\'' '\''a'\'''

echo '$ json '\''b||~c||~b'\'' '\''a'\'''
json 'b||~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c||~b'\'' '\''a'\'''

echo '$ json '\''b||~c||c'\'' '\''a'\'''
json 'b||~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''b||~c||c'\'' '\''a'\'''

echo '$ json '\''~b||a||~a'\'' '\''a'\'''
json '~b||a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a||~a'\'' '\''a'\'''

echo '$ json '\''~b||a||b'\'' '\''a'\'''
json '~b||a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a||b'\'' '\''a'\'''

echo '$ json '\''~b||a||c'\'' '\''a'\'''
json '~b||a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a||c'\'' '\''a'\'''

echo '$ json '\''~b||a||~c'\'' '\''a'\'''
json '~b||a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||a||~c'\'' '\''a'\'''

echo '$ json '\''~b||~a||a'\'' '\''a'\'''
json '~b||~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a||a'\'' '\''a'\'''

echo '$ json '\''~b||~a||b'\'' '\''a'\'''
json '~b||~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a||b'\'' '\''a'\'''

echo '$ json '\''~b||~a||c'\'' '\''a'\'''
json '~b||~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a||c'\'' '\''a'\'''

echo '$ json '\''~b||~a||~c'\'' '\''a'\'''
json '~b||~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~a||~c'\'' '\''a'\'''

echo '$ json '\''~b||b||a'\'' '\''a'\'''
json '~b||b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b||a'\'' '\''a'\'''

echo '$ json '\''~b||b||~a'\'' '\''a'\'''
json '~b||b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b||~a'\'' '\''a'\'''

echo '$ json '\''~b||b||c'\'' '\''a'\'''
json '~b||b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b||c'\'' '\''a'\'''

echo '$ json '\''~b||b||~c'\'' '\''a'\'''
json '~b||b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||b||~c'\'' '\''a'\'''

echo '$ json '\''~b||c||a'\'' '\''a'\'''
json '~b||c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c||a'\'' '\''a'\'''

echo '$ json '\''~b||c||~a'\'' '\''a'\'''
json '~b||c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c||~a'\'' '\''a'\'''

echo '$ json '\''~b||c||b'\'' '\''a'\'''
json '~b||c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c||b'\'' '\''a'\'''

echo '$ json '\''~b||c||~c'\'' '\''a'\'''
json '~b||c||~c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||c||~c'\'' '\''a'\'''

echo '$ json '\''~b||~c||a'\'' '\''a'\'''
json '~b||~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c||a'\'' '\''a'\'''

echo '$ json '\''~b||~c||~a'\'' '\''a'\'''
json '~b||~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c||~a'\'' '\''a'\'''

echo '$ json '\''~b||~c||b'\'' '\''a'\'''
json '~b||~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c||b'\'' '\''a'\'''

echo '$ json '\''~b||~c||c'\'' '\''a'\'''
json '~b||~c||c' 'a' 2>&1 ||
echo 'command failed: json '\''~b||~c||c'\'' '\''a'\'''

echo '$ json '\''c||a||~a'\'' '\''a'\'''
json 'c||a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||a||~a'\'' '\''a'\'''

echo '$ json '\''c||a||b'\'' '\''a'\'''
json 'c||a||b' 'a' 2>&1 ||
echo 'command failed: json '\''c||a||b'\'' '\''a'\'''

echo '$ json '\''c||a||~b'\'' '\''a'\'''
json 'c||a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||a||~b'\'' '\''a'\'''

echo '$ json '\''c||a||~c'\'' '\''a'\'''
json 'c||a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||a||~c'\'' '\''a'\'''

echo '$ json '\''c||~a||a'\'' '\''a'\'''
json 'c||~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a||a'\'' '\''a'\'''

echo '$ json '\''c||~a||b'\'' '\''a'\'''
json 'c||~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a||b'\'' '\''a'\'''

echo '$ json '\''c||~a||~b'\'' '\''a'\'''
json 'c||~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a||~b'\'' '\''a'\'''

echo '$ json '\''c||~a||~c'\'' '\''a'\'''
json 'c||~a||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~a||~c'\'' '\''a'\'''

echo '$ json '\''c||b||a'\'' '\''a'\'''
json 'c||b||a' 'a' 2>&1 ||
echo 'command failed: json '\''c||b||a'\'' '\''a'\'''

echo '$ json '\''c||b||~a'\'' '\''a'\'''
json 'c||b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||b||~a'\'' '\''a'\'''

echo '$ json '\''c||b||~b'\'' '\''a'\'''
json 'c||b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||b||~b'\'' '\''a'\'''

echo '$ json '\''c||b||~c'\'' '\''a'\'''
json 'c||b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||b||~c'\'' '\''a'\'''

echo '$ json '\''c||~b||a'\'' '\''a'\'''
json 'c||~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b||a'\'' '\''a'\'''

echo '$ json '\''c||~b||~a'\'' '\''a'\'''
json 'c||~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b||~a'\'' '\''a'\'''

echo '$ json '\''c||~b||b'\'' '\''a'\'''
json 'c||~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b||b'\'' '\''a'\'''

echo '$ json '\''c||~b||~c'\'' '\''a'\'''
json 'c||~b||~c' 'a' 2>&1 ||
echo 'command failed: json '\''c||~b||~c'\'' '\''a'\'''

echo '$ json '\''c||~c||a'\'' '\''a'\'''
json 'c||~c||a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c||a'\'' '\''a'\'''

echo '$ json '\''c||~c||~a'\'' '\''a'\'''
json 'c||~c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c||~a'\'' '\''a'\'''

echo '$ json '\''c||~c||b'\'' '\''a'\'''
json 'c||~c||b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c||b'\'' '\''a'\'''

echo '$ json '\''c||~c||~b'\'' '\''a'\'''
json 'c||~c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''c||~c||~b'\'' '\''a'\'''

echo '$ json '\''~c||a||~a'\'' '\''a'\'''
json '~c||a||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a||~a'\'' '\''a'\'''

echo '$ json '\''~c||a||b'\'' '\''a'\'''
json '~c||a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a||b'\'' '\''a'\'''

echo '$ json '\''~c||a||~b'\'' '\''a'\'''
json '~c||a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a||~b'\'' '\''a'\'''

echo '$ json '\''~c||a||c'\'' '\''a'\'''
json '~c||a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||a||c'\'' '\''a'\'''

echo '$ json '\''~c||~a||a'\'' '\''a'\'''
json '~c||~a||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a||a'\'' '\''a'\'''

echo '$ json '\''~c||~a||b'\'' '\''a'\'''
json '~c||~a||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a||b'\'' '\''a'\'''

echo '$ json '\''~c||~a||~b'\'' '\''a'\'''
json '~c||~a||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a||~b'\'' '\''a'\'''

echo '$ json '\''~c||~a||c'\'' '\''a'\'''
json '~c||~a||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~a||c'\'' '\''a'\'''

echo '$ json '\''~c||b||a'\'' '\''a'\'''
json '~c||b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b||a'\'' '\''a'\'''

echo '$ json '\''~c||b||~a'\'' '\''a'\'''
json '~c||b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b||~a'\'' '\''a'\'''

echo '$ json '\''~c||b||~b'\'' '\''a'\'''
json '~c||b||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b||~b'\'' '\''a'\'''

echo '$ json '\''~c||b||c'\'' '\''a'\'''
json '~c||b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||b||c'\'' '\''a'\'''

echo '$ json '\''~c||~b||a'\'' '\''a'\'''
json '~c||~b||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b||a'\'' '\''a'\'''

echo '$ json '\''~c||~b||~a'\'' '\''a'\'''
json '~c||~b||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b||~a'\'' '\''a'\'''

echo '$ json '\''~c||~b||b'\'' '\''a'\'''
json '~c||~b||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b||b'\'' '\''a'\'''

echo '$ json '\''~c||~b||c'\'' '\''a'\'''
json '~c||~b||c' 'a' 2>&1 ||
echo 'command failed: json '\''~c||~b||c'\'' '\''a'\'''

echo '$ json '\''~c||c||a'\'' '\''a'\'''
json '~c||c||a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c||a'\'' '\''a'\'''

echo '$ json '\''~c||c||~a'\'' '\''a'\'''
json '~c||c||~a' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c||~a'\'' '\''a'\'''

echo '$ json '\''~c||c||b'\'' '\''a'\'''
json '~c||c||b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c||b'\'' '\''a'\'''

echo '$ json '\''~c||c||~b'\'' '\''a'\'''
json '~c||c||~b' 'a' 2>&1 ||
echo 'command failed: json '\''~c||c||~b'\'' '\''a'\'''
)

