#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict-expr
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k2 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k2 -ae "$1"); }
$ json '\''a'\'' '\''a'\''
{"a":0}
$ json '\''a'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''a'\'' '\''b'\''
$ json '\''a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''a'\'' '\''z'\''
$ json '\''b'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''b'\'' '\''a'\''
$ json '\''b'\'' '\''b'\''
{"b":1}
$ json '\''b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''b'\'' '\''z'\''
$ json '\''~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a'\'' '\''a'\''
$ json '\''~a'\'' '\''b'\''
{"b":1}
$ json '\''~a'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~a'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "b"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~a'\'' '\''z'\''
$ json '\''~b'\'' '\''a'\''
{"a":0}
$ json '\''~b'\'' '\''b'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:7: {"b":1}
json: error: <stdin>:1:7:       ^
{"b":1}
command failed: json '\''~b'\'' '\''b'\''
$ json '\''~b'\'' '\''a,b'\''
{"a":0,"b":1}
$ json '\''~b'\'' '\''z'\''
json: error: <stdin>:1:2: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{}
command failed: json '\''~b'\'' '\''z'\'''
) -L dict-expr.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k2 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k2 -ae "$1"); }'
json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k2 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k2 -ae "$1"); } 2>&1 ||
echo 'command failed: json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k2 -ae "$2"|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k2 -ae "$1"); }'

echo '$ json '\''a'\'' '\''a'\'''
json 'a' 'a' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''a'\'''

echo '$ json '\''a'\'' '\''b'\'''
json 'a' 'b' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''b'\'''

echo '$ json '\''a'\'' '\''a,b'\'''
json 'a' 'a,b' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''a,b'\'''

echo '$ json '\''a'\'' '\''z'\'''
json 'a' 'z' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''z'\'''

echo '$ json '\''b'\'' '\''a'\'''
json 'b' 'a' 2>&1 ||
echo 'command failed: json '\''b'\'' '\''a'\'''

echo '$ json '\''b'\'' '\''b'\'''
json 'b' 'b' 2>&1 ||
echo 'command failed: json '\''b'\'' '\''b'\'''

echo '$ json '\''b'\'' '\''a,b'\'''
json 'b' 'a,b' 2>&1 ||
echo 'command failed: json '\''b'\'' '\''a,b'\'''

echo '$ json '\''b'\'' '\''z'\'''
json 'b' 'z' 2>&1 ||
echo 'command failed: json '\''b'\'' '\''z'\'''

echo '$ json '\''~a'\'' '\''a'\'''
json '~a' 'a' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''a'\'''

echo '$ json '\''~a'\'' '\''b'\'''
json '~a' 'b' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''b'\'''

echo '$ json '\''~a'\'' '\''a,b'\'''
json '~a' 'a,b' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''a,b'\'''

echo '$ json '\''~a'\'' '\''z'\'''
json '~a' 'z' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''z'\'''

echo '$ json '\''~b'\'' '\''a'\'''
json '~b' 'a' 2>&1 ||
echo 'command failed: json '\''~b'\'' '\''a'\'''

echo '$ json '\''~b'\'' '\''b'\'''
json '~b' 'b' 2>&1 ||
echo 'command failed: json '\''~b'\'' '\''b'\'''

echo '$ json '\''~b'\'' '\''a,b'\'''
json '~b' 'a,b' 2>&1 ||
echo 'command failed: json '\''~b'\'' '\''a,b'\'''

echo '$ json '\''~b'\'' '\''z'\'''
json '~b' 'z' 2>&1 ||
echo 'command failed: json '\''~b'\'' '\''z'\'''
)

