#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:closed-array-open-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L closed-array-open-array.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[[]]'\''
[[]]'
) -L closed-array-open-array.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"type"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"type"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"type"}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"null"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"null"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"null"}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"boolean"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"boolean"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"boolean"}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"number"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"number"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"number"}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"string"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"string"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"string"}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"object"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"object"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"object"}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"array"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"array","args":"array"}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"array","args":"array"}]}'\'' <<< '\''[[]]'\'''
)

