#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-plain-object-basic-val-object-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-plain-object-basic-val-object-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":789,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"baz","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
) -L list-plain-object-basic-val-object-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"type"}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"null"}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"boolean"}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}' <<< '{"fuu":789,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"number"}]}]}'\'' <<< '\''{"fuu":789,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}' <<< '{"fuu":"baz","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"string"}]}]}'\'' <<< '\''{"fuu":"baz","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"object"}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":"array"}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
)

