#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:62
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 62.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number"]}}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: sort of object of list type not yet supported (the inner list is at 1:70)
json: error: <stdin>:1:24: {"type":"list","args":[{"type":"object","args":[{"name":
json: error: <stdin>:1:24:                        ^
command failed: json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number"]}}]}]}'\'''
) -L 62.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number"]}}]}]}'\'''
json -Tc <<< '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number"]}}]}]}' 2>&1 ||
echo 'command failed: json -Tc <<< '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number"]}}]}]}'\'''
)

